/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import com.kdjsystem.mlink.shop.ImageUpload.CloudinaryUploadService;
import com.kdjsystem.mlink.shop.ImageUpload.FtpUploadService;
import com.kdjsystem.mlink.shop.ImageUpload.UploadException;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface CleanImageService {
    public static final Logger logger = LoggerFactory.getLogger(CleanImageService.class);

    public String upload(Path var1) throws UploadException;

    default public void deleteThumbnailServer(List<String> imageDelete, String prodcd, String shopcd) throws Exception {
        ArrayList<String> cloudinaryList = new ArrayList<String>();
        ArrayList<String> localList = new ArrayList<String>();
        HashMap ftpMap = new HashMap();
        String localPath1 = ShopCommon.getImgPath();
        String localPath2 = ShopCommon.getImgPathLocalThumnail();
        for (String raw : imageDelete) {
            String item = raw.trim();
            if (!ShopCommon.deleteimagesolderthantenminutes(shopcd) && item.contains("cloudinary")) {
                cloudinaryList.add(item);
            }
            if (!item.contains(prodcd)) continue;
            String string = String.valueOf(localPath1) + File.separator + prodcd + "*.jpg";
            localList.add(string);
            String string2 = String.valueOf(localPath2) + File.separator + prodcd + "*.jpg";
            localList.add(string2);
            break;
        }
        int totalTasks = cloudinaryList.size() + localList.size() + ftpMap.size();
        if (totalTasks == 0) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(Math.max(1, Math.min(totalTasks, Runtime.getRuntime().availableProcessors())));
        ArrayList futures = new ArrayList(totalTasks);
        for (String string : cloudinaryList) {
            futures.add(executor.submit(() -> {
                try {
                    CloudinaryUploadService.get().deleteImage(url);
                    logger.info("Cloudinary \uc0ad\uc81c \uc644\ub8cc: {}", (Object)url);
                }
                catch (Exception e) {
                    logger.error("Cloudinary \uc0ad\uc81c \uc2e4\ud328: {}", (Object)url, (Object)e);
                }
            }));
        }
        for (String string : localList) {
            futures.add(executor.submit(() -> {
                try {
                    int sep = pathPattern.lastIndexOf(File.separatorChar);
                    if (sep < 0) {
                        logger.warn("\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uacbd\ub85c \ud328\ud134: {}", (Object)pathPattern);
                        return;
                    }
                    String dirPath = pathPattern.substring(0, sep);
                    String globExpr = pathPattern.substring(sep + 1);
                    Path dir = Paths.get(dirPath, new String[0]);
                    if (!Files.isDirectory(dir, new LinkOption[0])) {
                        logger.warn("\ub514\ub809\ud1a0\ub9ac\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc74c: {}", (Object)dir);
                        return;
                    }
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, globExpr);){
                        boolean found = false;
                        for (Path file : stream) {
                            found = true;
                            try {
                                if (Files.deleteIfExists(file)) {
                                    logger.info("\ub85c\uceec \ud30c\uc77c \uc0ad\uc81c \uc131\uacf5: {}", (Object)file);
                                    continue;
                                }
                                logger.warn("\ub85c\uceec \ud30c\uc77c \uc5c6\uc74c(\uc774\ubbf8 \uc0ad\uc81c\ub428): {}", (Object)file);
                            }
                            catch (IOException ioe) {
                                logger.error("\ub85c\uceec \ud30c\uc77c \uc0ad\uc81c \uc2e4\ud328: {}", (Object)file, (Object)ioe);
                            }
                        }
                        if (!found) {
                            logger.warn("\ud328\ud134\uc5d0 \ub9e4\uce6d\ub418\ub294 \ud30c\uc77c \uc5c6\uc74c: {}/{}", (Object)dir, (Object)globExpr);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    logger.error("\ub85c\uceec \ud30c\uc77c \uc0ad\uc81c \ucc98\ub9ac \uc911 \uc608\uc678 \ubc1c\uc0dd: \ud328\ud134={}", (Object)pathPattern, (Object)e);
                }
            }));
        }
        for (Map.Entry entry : ftpMap.entrySet()) {
            String remoteDir = (String)entry.getKey();
            List files = (List)entry.getValue();
            futures.add(executor.submit(() -> {
                try {
                    new FtpUploadService().deleteFilesFromFtp(remoteDir, files);
                    logger.info("FTP \ub514\ub809\ud1a0\ub9ac '{}' \uc5d0\uc11c {}\uac1c \ud30c\uc77c \uc0ad\uc81c \uc644\ub8cc", (Object)remoteDir, (Object)files.size());
                }
                catch (Exception e) {
                    logger.error("FTP \uc0ad\uc81c \uc2e4\ud328: {} -> {}", new Object[]{remoteDir, files, e});
                }
            }));
        }
        executor.shutdown();
        if (!executor.awaitTermination(1L, TimeUnit.MINUTES)) {
            logger.warn("\uc0ad\uc81c \uc791\uc5c5 \ud0c0\uc784\uc544\uc6c3, \uac15\uc81c \uc885\ub8cc\ud569\ub2c8\ub2e4.");
            executor.shutdownNow();
        }
    }
}

