/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import com.cloudinary.Cloudinary;
import com.cloudinary.Transformation;
import com.cloudinary.api.ApiResponse;
import com.cloudinary.utils.ObjectUtils;
import com.kdjsystem.mlink.shop.ImageUpload.CleanImageService;
import com.kdjsystem.mlink.shop.ImageUpload.ImageDownloader;
import com.kdjsystem.mlink.shop.ImageUpload.UploadException;
import com.kdjsystem.mlink.shop.ImageUpload.UploadResult;
import com.kdjsystem.mlink.shop.dao.CloudinaryApiInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudinaryUploadService
implements CleanImageService {
    private static final Logger logger = LoggerFactory.getLogger(CloudinaryUploadService.class);
    private static volatile CloudinaryUploadService instance;
    private final Cloudinary cloudinary;
    private final CloudinaryApiInfoDto apiInfo;
    private static final Pattern VERSION_PATTERN;

    static {
        VERSION_PATTERN = Pattern.compile("/v(\\d+)/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadConfig() {
        Class<CloudinaryUploadService> clazz = CloudinaryUploadService.class;
        synchronized (CloudinaryUploadService.class) {
            try {
                Optional<CloudinaryApiInfoDto> infoOpt = ShopCommonDao.get().getCloudinaryApiInfo();
                CloudinaryApiInfoDto info = infoOpt.orElseThrow(() -> new IllegalStateException("\ud65c\uc131\ud654\ub41c Cloudinary \uc124\uc815\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4."));
                instance = new CloudinaryUploadService(info);
                logger.info("CloudinaryUploadService reloaded with new configuration.");
            }
            catch (Exception e) {
                logger.error("Failed to reload Cloudinary configuration, disabling service.", (Throwable)e);
                instance = new DisabledCloudinaryUploadService();
            }
            return;
        }
    }

    private CloudinaryUploadService(CloudinaryApiInfoDto info) {
        this.apiInfo = info;
        this.cloudinary = new Cloudinary(ObjectUtils.asMap((Object[])new Object[]{"cloud_name", info.getCloudname(), "api_key", info.getApikey(), "api_secret", info.getApisecret(), "secure", true}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static CloudinaryUploadService initInstance() {
        if (instance != null) return instance;
        Class<CloudinaryUploadService> clazz = CloudinaryUploadService.class;
        synchronized (CloudinaryUploadService.class) {
            if (instance != null) return instance;
            try {
                Optional<CloudinaryApiInfoDto> infoOpt = ShopCommonDao.get().getCloudinaryApiInfo();
                CloudinaryApiInfoDto info = infoOpt.orElseThrow(() -> new IllegalStateException("No active Cloudinary configuration found"));
                instance = new CloudinaryUploadService(info);
                logger.info("CloudinaryUploadService initialized successfully.");
            }
            catch (Exception e) {
                logger.error("Failed to initialize CloudinaryUploadService, disabling service.", (Throwable)e);
                instance = new DisabledCloudinaryUploadService();
            }
            return instance;
        }
    }

    public static CloudinaryUploadService get() {
        return CloudinaryUploadService.initInstance();
    }

    public static CloudinaryUploadService getInstance() {
        return CloudinaryUploadService.initInstance();
    }

    public CloudinaryApiInfoDto getApiInfo() {
        return this.apiInfo;
    }

    public void runSwitchedCleanupIfEnabled() {
        if (!this.isEnabled()) {
            YDMAStringUtil.Print("Cloudinary \ube44\ud65c\uc131 \uc0c1\ud0dc\ub85c \uc815\ub9ac \uc791\uc5c5 \uc0dd\ub7b5");
            return;
        }
        try {
            int found = this.searchImageCountOlderThanMinutes(10);
            if (found > 0) {
                YDMAStringUtil.Print("Cloudinary \uc0ad\uc81c \ub300\uc0c1: " + found + "\uac74");
                this.deleteImagesOlderThanTenMinutes();
                YDMAStringUtil.Print("Cloudinary \uc774\ubbf8\uc9c0 \uc77c\uad04 \uc0ad\uc81c \uc644\ub8cc");
            } else {
                YDMAStringUtil.Print("\uc0ad\uc81c \ub300\uc0c1 \uc5c6\uc74c: Cloudinary \uce90\uc2dc \uc720\uc9c0");
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print("Cloudinary \uc815\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd: " + e.getMessage());
        }
    }

    @Override
    public String upload(Path localFile) throws UploadException {
        this.ensureEnabled();
        try {
            Map result = this.cloudinary.uploader().upload((Object)localFile.toFile(), ObjectUtils.emptyMap());
            return (String)result.get("secure_url");
        }
        catch (IOException e) {
            CloudinaryUploadService.setDisabled();
            throw new UploadException("Cloudinary upload failed.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setDisabled() {
        Class<CloudinaryUploadService> clazz = CloudinaryUploadService.class;
        synchronized (CloudinaryUploadService.class) {
            try {
                if (instance != null && CloudinaryUploadService.instance.apiInfo != null) {
                    ShopCommonDao.get().updateCloudinaryApiInfoToDisabled(CloudinaryUploadService.instance.apiInfo.getSeq(), CloudinaryUploadService.instance.apiInfo.getCompno(), CloudinaryUploadService.instance.apiInfo.getCloudname(), "N");
                }
            }
            catch (Exception e) {
                logger.warn("Failed to update use_yn flag before disabling service.", (Throwable)e);
            }
            instance = null;
            CloudinaryUploadService.getInstance();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public Optional<Double> getUsagePercentage() throws UploadException {
        if (!this.isEnabled()) {
            return Optional.of(-1.0);
        }
        try {
            ApiResponse usage = this.cloudinary.api().usage(ObjectUtils.emptyMap());
            Map credits = (Map)usage.get("credits");
            return Optional.of(Double.parseDouble(credits.get("used_percent").toString()));
        }
        catch (Exception exception) {
            CloudinaryUploadService.setDisabled();
            return Optional.of(-1.0);
        }
    }

    public void deleteImagesOlderThanTenMinutes() {
        if (!this.isEnabled()) {
            return;
        }
        String cutoffIso = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(10L).format(DateTimeFormatter.ISO_INSTANT);
        try {
            ApiResponse result = this.cloudinary.search().expression("resource_type:image AND created_at<\"" + cutoffIso + "\"").maxResults(Integer.valueOf(100)).execute();
            List resources = (List)result.get((Object)"resources");
            for (Map res : resources) {
                String publicId = (String)res.get("public_id");
                this.cloudinary.uploader().destroy(publicId, ObjectUtils.emptyMap());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int searchImageCountOlderThanMinutes(int minutes) throws Exception {
        if (!this.isEnabled()) {
            return 0;
        }
        String cutoffIso = ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(minutes).format(DateTimeFormatter.ISO_INSTANT);
        ApiResponse result = this.cloudinary.search().expression("resource_type:image AND created_at<\"" + cutoffIso + "\"").maxResults(Integer.valueOf(1)).execute();
        Object totalCount = result.get((Object)"total_count");
        return totalCount instanceof Number ? ((Number)totalCount).intValue() : 0;
    }

    public UploadResult uploadImageWithFallback(String imageUrl) throws UploadException {
        try {
            byte[] imageData = ImageDownloader.downloadImage(imageUrl);
            Map result = this.cloudinary.uploader().upload((Object)imageData, ObjectUtils.asMap((Object[])new Object[]{"resource_type", "image"}));
            String pid = (String)result.get("public_id");
            String url = (String)result.get("secure_url");
            long version = ((Number)result.get("version")).longValue();
            return new UploadResult(pid, url, version);
        }
        catch (Exception e) {
            logger.error("Cloudinary \uc9c1\uc811 \uc5c5\ub85c\ub4dc \uc2e4\ud328", (Throwable)e);
            throw new UploadException("Cloudinary \uc9c1\uc811 \uc5c5\ub85c\ub4dc \uc2e4\ud328: " + imageUrl, e);
        }
    }

    public byte[] toByteArray(InputStream input) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data2 = new byte[8192];
        while ((nRead = input.read(data2, 0, data2.length)) != -1) {
            buffer.write(data2, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public boolean isEnabled() {
        return !(this instanceof DisabledCloudinaryUploadService);
    }

    public void deleteImage(String publicId) throws UploadException {
        if (publicId == null || publicId.trim().isEmpty()) {
            return;
        }
        String fileName = this.extractFileName(publicId);
        try {
            Map result = this.cloudinary.uploader().destroy(fileName, ObjectUtils.emptyMap());
            logger.info("\uc774\ubbf8\uc9c0 \uc0ad\uc81c \uc644\ub8cc: {} \u2192 {}", (Object)fileName, (Object)result);
        }
        catch (Exception e) {
            logger.error("\uc774\ubbf8\uc9c0 \uc0ad\uc81c \uc2e4\ud328: {}", (Object)publicId, (Object)e);
            throw new UploadException("\uc774\ubbf8\uc9c0 \uc0ad\uc81c \uc2e4\ud328: " + publicId, e);
        }
    }

    public String extractFileName(String fullPath) {
        if (fullPath == null || fullPath.trim().isEmpty()) {
            return "";
        }
        String name = fullPath.substring(fullPath.lastIndexOf(47) + 1);
        int idx = name.lastIndexOf(46);
        return idx > 0 ? name.substring(0, idx) : name;
    }

    public static long extractVersion(String url) {
        if (url == null) {
            throw new IllegalArgumentException("URL\uc774 null\uc785\ub2c8\ub2e4.");
        }
        Matcher m = VERSION_PATTERN.matcher(url);
        if (m.find()) {
            String verStr = m.group(1);
            try {
                return Long.parseLong(verStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("\ubc84\uc804 \ubb38\uc790\uc5f4\uc744 \uc22b\uc790\ub85c \ubcc0\ud658\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + verStr, e);
            }
        }
        throw new IllegalArgumentException("URL\uc5d0\uc11c \ubc84\uc804 \ud328\ud134\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4: " + url);
    }

    public String getResize1000Url(String publicId, long version) {
        return this.cloudinary.url().version((Object)version).transformation(new Transformation().crop("fill").width((Object)1000).height((Object)1000)).format("jpg").secure(true).generate(publicId);
    }

    public String getFlippedUrl(String publicId, long version) {
        return this.cloudinary.url().version((Object)version).transformation(new Transformation().angle(new String[]{"hflip"})).format("jpg").secure(true).generate(publicId);
    }

    public String getCropRotateZoomUrl(String publicId, long version, int x, int y, int w, int h, double angle, double scalePercent) {
        int roundedAngle = (int)Math.round(angle);
        return this.cloudinary.url().version((Object)version).transformation(new Transformation().crop("crop").x((Object)x).y((Object)y).width((Object)w).height((Object)h).angle(roundedAngle).zoom(scalePercent)).format("jpg").generate(publicId);
    }

    public String getResize34Url(String publicId, long version, int w, int h) {
        return this.cloudinary.url().version((Object)version).transformation(new Transformation().crop("fill").width((Object)w).height((Object)h)).format("jpg").generate(publicId);
    }

    public String generateUrlWithTransformation(String publicId, long version, Transformation transformation) {
        return this.cloudinary.url().version((Object)version).transformation(transformation).format("jpg").secure(true).generate(publicId);
    }

    public String generateUrlWithTransformation(String publicId, long version, Transformation transformation, String format) {
        return this.cloudinary.url().version((Object)version).transformation(transformation).format(format).secure(true).generate(publicId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String downloadByUrl(String imageUrl, String destinationPath) throws IOException {
        URL url = new URL(imageUrl);
        Path dest = Paths.get(destinationPath, new String[0]);
        Files.createDirectories(dest.getParent(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            InputStream in = url.openStream();
            try {
                try (FileOutputStream out = new FileOutputStream(dest.toFile());){
                    int bytesRead;
                    byte[] buffer = new byte[4096];
                    while ((bytesRead = in.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, bytesRead);
                    }
                }
                if (in == null) return dest.toAbsolutePath().toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return dest.toAbsolutePath().toString();
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private void ensureEnabled() throws UploadException {
        if (!this.isEnabled()) {
            throw new UploadException("Cloudinary service is disabled.");
        }
    }

    /* synthetic */ CloudinaryUploadService(CloudinaryApiInfoDto cloudinaryApiInfoDto, CloudinaryUploadService cloudinaryUploadService) {
        this(cloudinaryApiInfoDto);
    }

    private static class DisabledCloudinaryUploadService
    extends CloudinaryUploadService {
        private DisabledCloudinaryUploadService() {
            super(new CloudinaryApiInfoDto(), null);
        }

        @Override
        public String upload(Path localFile) throws UploadException {
            throw new UploadException("Cloudinary service disabled.");
        }

        @Override
        public Optional<Double> getUsagePercentage() {
            return Optional.of(-1.0);
        }

        @Override
        public void deleteImagesOlderThanTenMinutes() {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }
    }
}

