/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kdjsystem.mlink.shop.ImageUpload.CloudinaryUploadService;
import com.kdjsystem.mlink.shop.ImageUpload.UnifiedUploadManager;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.common.ShopErrorCode;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopOptionProductInDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionProductInfoDao;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductNaverStoreAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.common.FtpUtil;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.ProductIforDao;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public interface IProduct
extends IShopCommonLogin {
    public static final String \uc0c1\ud488\uc874\uc7ac\ud568 = "2";
    public static final String \ub370\uc774\ud0c0\uc5c6\uc74c = "0";
    public static final String \uc5d0\ub7ec\ubc1c\uc0dd = "-1";
    public static final String \uc815\uc0c1\ucc98\ub9ac = "1";

    public ShopProductSendDto excute(ShopProductSendDto var1) throws Exception;

    public ShopProductSendDto complate(ShopProductSendDto var1) throws Exception;

    public RegResultDTO deleteAfterRegister(ShopProductSendDto var1, ShopProductDto var2) throws Exception;

    public static void setAdditionalExceptionThrow(ShopProductAdditionDto shopProductAdditionDto, List<ShopProductDto> shopProductDtos) {
        ShopProductSendDto sendDto = new ShopProductSendDto();
        sendDto.setProductAdditionDto(shopProductAdditionDto);
        for (ShopProductDto dto : shopProductDtos) {
            if (!shopProductAdditionDto.getShopcd().equals("shop0055")) continue;
            ShopProductNaverStoreAdditionDto dtllist = (ShopProductNaverStoreAdditionDto)sendDto.getProductAdditionDto();
            if (!YDMAStringUtil.checkRegex("^[1-9][0-9]*[0]", dtllist.getDelvcost())) {
                dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                dto.setResult_text(ShopErrorCode.get().getMessage("D0009").getCode());
            }
            if (dtllist.getAreadelvtyp().equals("02")) {
                if (!YDMAStringUtil.checkRegex("^[1-9][0-9]*[0]", dtllist.getJejucost())) {
                    dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                    dto.setResult_text(ShopErrorCode.get().getMessage("D0010").getCode());
                }
            } else if (dtllist.getAreadelvtyp().equals("03")) {
                if (!YDMAStringUtil.checkRegex("^[1-9][0-9]*[0]", dtllist.getJejucost())) {
                    dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                    dto.setResult_text(ShopErrorCode.get().getMessage("D0010").getCode());
                }
                if (!YDMAStringUtil.checkRegex("^[1-9][0-9]*[0]", dtllist.getIslandcost())) {
                    dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                    dto.setResult_text(ShopErrorCode.get().getMessage("D0010").getCode());
                }
            }
            if (!dtllist.getShipdelvtyp().equals("04") || !dtllist.getQtydivisiontyp().equals("02") || !dtllist.getDelvcost2().contains(",")) continue;
            String[] split = dtllist.getDelvcost2().split(",");
            if (split.length <= 2) {
                if (YDMAStringUtil.checkRegex("^[1-9][0-9]*[0]", split[1])) continue;
                dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                dto.setResult_text(ShopErrorCode.get().getMessage("D0011").getCode());
                continue;
            }
            if (!YDMAStringUtil.checkRegex("^[1-9][0-9]*[0]", split[1])) {
                dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                dto.setResult_text(ShopErrorCode.get().getMessage("D0011").getCode());
            }
            if (Integer.parseInt(split[0]) >= Integer.parseInt(split[2])) {
                dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                dto.setResult_text(ShopErrorCode.get().getMessage("D0012").getCode());
            }
            if (YDMAStringUtil.checkRegex("^[1-9][0-9]*[0]", split[3])) continue;
            dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
            dto.setResult_text(ShopErrorCode.get().getMessage("D0011").getCode());
        }
    }

    public static void setExceptionThrow(String shopcd, ShopProductDto dto) {
        if (YDMAStringUtil.checkRegex("[*,]", dto.getGoods_nm())) {
            dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
            dto.setResult_text(ShopErrorCode.get().getMessage("D0002").getCode());
        }
        if (dto.getGoods_price().length() == 0 || dto.getGoods_price() == null) {
            dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
            dto.setResult_text(ShopErrorCode.get().getMessage("D0003").getCode());
        }
        if (YDMAStringUtil.checkRegex("[><|]", String.valueOf(dto.getChar_1_nm()) + dto.getChar_2_nm())) {
            dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
            dto.setResult_text(ShopErrorCode.get().getMessage("D0004").getCode());
        }
        ArrayList<ShopOptionDto> options = new ArrayList<ShopOptionDto>();
        dto.getChar_1_val();
        ShopOptionProductInfoDao dao = new ShopOptionProductInfoDao();
        try {
            List<ShopProductOptionDto> list = dao.getShopOptProdInfoListByProdseq(dto.getProdseq());
            for (ShopProductOptionDto optdto : list) {
                ShopOptionDto opt = new ShopOptionDto();
                opt.setName(optdto.getOptprodnm().concat("_").concat(optdto.getOptspecdes()));
                opt.setCnt(optdto.getOptvertstock());
                opt.setAmt(Integer.toString(optdto.getOptaddamt()));
                options.add(opt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!dto.getChar_1_nm().equals("\ub2e8\ud488") && options.size() == 0) {
            dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
            dto.setResult_text(ShopErrorCode.get().getMessage("D0005").getCode());
        }
        if (dto.getCompayny_goods_cd().startsWith("@") || dto.getModel_nm().startsWith("@") || dto.getGoods_nm().startsWith("@") || dto.getBrand_nm().startsWith("@") || dto.getModel_no().startsWith("@") || dto.getGoods_search().startsWith("@")) {
            dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
            dto.setResult_text(ShopErrorCode.get().getMessage("D0008").getCode());
        }
        if (shopcd.equals("shop0076")) {
            if (dto.getGoods_nm().contains(" ")) {
                dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                dto.setResult_text(ShopErrorCode.get().getMessage("D0006").getCode());
            }
            if (dto.getChar_1_nm().startsWith(" ") || dto.getChar_1_nm().endsWith(" ") || dto.getChar_2_nm().startsWith(" ") || dto.getChar_2_nm().endsWith(" ") || dto.getChar_1_val().startsWith(" ") || dto.getChar_1_val().endsWith(" ") || dto.getChar_2_val().startsWith(" ") || dto.getChar_2_val().endsWith(" ")) {
                dto.setResult_code(\uc5d0\ub7ec\ubc1c\uc0dd);
                dto.setResult_text(ShopErrorCode.get().getMessage("D0007").getCode());
            }
        }
    }

    default public List<ShopProdAttrnmDto> getProductNotices(ShopProductDto dto) throws Exception {
        String attrcd = dto.getProp1_cd();
        ProductIforDao dao = new ProductIforDao();
        return dao.getProductNotice(attrcd);
    }

    default public List<ShopOptionDto> getProductInOptions(ShopProductDto dto) {
        ArrayList<ShopOptionDto> options = new ArrayList<ShopOptionDto>();
        ShopOptionProductInDao dao = new ShopOptionProductInDao();
        try {
            List<ShopProductOptionDto> list = dao.getShopOptProdInListBySendseq(dto.getSendseq());
            for (ShopProductOptionDto optdto : list) {
                ShopOptionDto opt = new ShopOptionDto();
                opt.setSkuseq(String.valueOf(optdto.getSkuseq()));
                opt.setName(optdto.getOptprodnm());
                opt.setOptspecdes(optdto.getOptspecdes());
                opt.setCnt(optdto.getOptvertstock());
                opt.setAmt(String.valueOf(optdto.getOptaddamt()));
                opt.setOptcompanycd(optdto.getOptprodcd());
                opt.setLimit_price(optdto.getLimit_price());
                opt.setSellerProductItemId(optdto.getShopprodsku());
                opt.setVendorItemId("");
                options.add(opt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    default public List<ShopOptionDto> getProductOptions(ShopProductDto dto) {
        ArrayList<ShopOptionDto> options = new ArrayList<ShopOptionDto>();
        ShopOptionProductInfoDao dao = new ShopOptionProductInfoDao();
        try {
            List<ShopProductOptionDto> list = dao.getShopOptProdInfoListByProdseq(dto.getProdseq());
            for (ShopProductOptionDto optdto : list) {
                ShopOptionDto opt = new ShopOptionDto();
                opt.setSkuseq(String.valueOf(optdto.getSkuseq()));
                opt.setName(optdto.getOptprodnm());
                opt.setOptspecdes(optdto.getOptspecdes());
                opt.setCnt(optdto.getOptvertstock());
                opt.setAmt(String.valueOf(optdto.getOptaddamt()));
                opt.setOptcompanycd(optdto.getOptprodcd());
                opt.setLimit_price(optdto.getLimit_price());
                opt.setSellerProductItemId("");
                opt.setVendorItemId("");
                options.add(opt);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return options;
    }

    default public String cropImage(String img, int x, int y, int w, int h) {
        File filePath = new File(img);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedImage originalImgage = ImageIO.read(filePath);
            BufferedImage subImgage = originalImgage.getSubimage(x, y, w, h);
            BufferedImage outputImage = new BufferedImage(600, 600, subImgage.getType());
            Graphics2D graphics2D = outputImage.createGraphics();
            graphics2D.drawImage(subImgage, 0, 0, 600, 600, null);
            graphics2D.dispose();
            sb.append(img);
            int p = img.indexOf(".jpg");
            sb.insert(p, "c");
            File targetfilePath = new File(sb.toString());
            ImageIO.write((RenderedImage)outputImage, "jpg", targetfilePath);
            return targetfilePath.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String cropImage(String img, int x, int y, int w, int h, double angle, double scalePercent) {
        x = 0;
        y = 0;
        File filePath = new File(img);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedImage originalImage = ImageIO.read(filePath);
            if (w > originalImage.getWidth()) {
                w = originalImage.getWidth();
            }
            if (h > originalImage.getHeight()) {
                h = originalImage.getHeight();
            }
            AffineTransform rotateTransform = new AffineTransform();
            rotateTransform.rotate(Math.toRadians(angle), (double)originalImage.getWidth() / 2.0, (double)originalImage.getHeight() / 2.0);
            BufferedImage rotatedImage = new BufferedImage(originalImage.getWidth(), originalImage.getHeight(), 2);
            Graphics2D rotatedGraphics = rotatedImage.createGraphics();
            rotatedGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            rotatedGraphics.transform(rotateTransform);
            rotatedGraphics.drawImage((Image)originalImage, 0, 0, null);
            rotatedGraphics.dispose();
            double scaledWidth = (double)rotatedImage.getWidth() * scalePercent / 100.0;
            double scaledHeight = (double)rotatedImage.getHeight() * scalePercent / 100.0;
            AffineTransform scaleTransform = new AffineTransform();
            scaleTransform.scale(scaledWidth / (double)rotatedImage.getWidth(), scaledHeight / (double)rotatedImage.getHeight());
            BufferedImage scaledImage = new BufferedImage((int)scaledWidth, (int)scaledHeight, 2);
            Graphics2D scaledGraphics = scaledImage.createGraphics();
            scaledGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            scaledGraphics.drawImage(rotatedImage, scaleTransform, null);
            scaledGraphics.dispose();
            int cropX = Math.max(0, (scaledImage.getWidth() - w) / 2);
            int cropY = Math.max(0, (scaledImage.getHeight() - h) / 2);
            BufferedImage croppedImage = scaledImage.getSubimage(cropX, cropY, w, h);
            sb.append(img);
            int p = img.indexOf(".jpg");
            sb.insert(p, "c");
            File targetfilePath = new File(sb.toString());
            ImageIO.write((RenderedImage)croppedImage, "png", targetfilePath);
            return targetfilePath.getAbsolutePath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    default public String cropImageWithmirrored(String img) {
        File filePath = new File(img);
        StringBuffer sb = new StringBuffer();
        try {
            BufferedImage originalImgage = ImageIO.read(filePath);
            int width = originalImgage.getWidth();
            int height = originalImgage.getHeight();
            BufferedImage mirrored = new BufferedImage(width, height, originalImgage.getType());
            Graphics2D g2d = mirrored.createGraphics();
            g2d.scale(-1.0, 1.0);
            g2d.translate(-originalImgage.getWidth(), 0);
            g2d.drawImage((Image)originalImgage, 0, 0, null);
            g2d.dispose();
            sb.append(img);
            int p = img.indexOf(".jpg");
            sb.insert(p, "m");
            File targetfilePath = new File(sb.toString());
            ImageIO.write((RenderedImage)mirrored, "jpg", targetfilePath);
            return targetfilePath.getAbsolutePath();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    default public List<String> getProductImages(ShopProductDto dto) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        if (dto.getGoods_keyword().equals("shop0319")) {
            List<String> images = Arrays.asList(dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24());
            List imgs = images.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            int i = 0;
            while (i < imgs.size()) {
                String img = ShopCommon.downloadImgFileJPG((String)imgs.get(i), 600, 600, dto, i);
                if (!img.equals("")) {
                    if (YDMASessonUtil.getUserInfo().getPricetype().equals("9")) {
                        String imgchk = ShopCommon.downloadImgFileCheck(img);
                        if (!imgchk.equals("")) {
                            ret.add(imgchk);
                        } else {
                            img = this.cropImage(img, 10, 10, 580, 580);
                            ret.add(img);
                        }
                    } else {
                        img = this.cropImage(img, 10, 10, 580, 580);
                        ret.add(img);
                    }
                }
                ++i;
            }
        } else {
            List<String> images = Arrays.asList(dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24());
            List imgs = images.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            int i = 0;
            while (i < imgs.size()) {
                String img = ShopCommon.downloadImgFileJPG((String)imgs.get(i), 600, 600, dto, i);
                if (!img.equals("")) {
                    if (dto.getGoods_keyword().equals("shop9987") || dto.getGoods_keyword().equals("shop0000") || dto.getGoods_keyword().equals("shop9985") || dto.getGoods_keyword().equals("shop9986")) {
                        String imgchk = ShopCommon.downloadImgFileCheck(img);
                        if (!imgchk.equals("")) {
                            ret.add(imgchk);
                        } else {
                            img = this.cropImage(img, 10, 10, 580, 580);
                            ret.add(img);
                        }
                    } else {
                        ret.add((String)imgs.get(i));
                    }
                }
                ++i;
            }
        }
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    default public List<String> getProductImages(ShopProductDto dto, String x, String y, String w, String h, double angle, double scalePercent) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        if (dto.getGoods_keyword().equals("shop0319")) {
            List<String> images = Arrays.asList(dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24());
            List imgs = images.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            int i = 0;
            while (i < imgs.size()) {
                String img = ShopCommon.downloadImgFileJPG((String)imgs.get(i), 600, 600, dto, i);
                if (!img.equals("")) {
                    String imgchk = ShopCommon.downloadImgFileCheck(img);
                    if (!imgchk.equals("")) {
                        ret.add(imgchk);
                    } else {
                        if (scalePercent <= 0.0) {
                            scalePercent = 100.0;
                        }
                        if (angle < 0.0) {
                            angle = 0.0;
                        }
                        img = IProduct.cropImage(img, Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(w), Integer.parseInt(h), angle, scalePercent);
                        ret.add(img);
                    }
                }
                ++i;
            }
        } else {
            List<String> images = Arrays.asList(dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24());
            List imgs = images.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            int i = 0;
            while (i < imgs.size()) {
                String img = ShopCommon.downloadImgFileJPG((String)imgs.get(i), 600, 600, dto, i);
                if (!img.equals("")) {
                    String imgchk;
                    if (dto.getGoods_keyword().equals("shop9987") || dto.getGoods_keyword().equals("shop9985")) {
                        imgchk = ShopCommon.downloadImgFileCheck(img);
                        if (!imgchk.equals("")) {
                            ret.add(imgchk);
                        } else {
                            if (scalePercent <= 0.0) {
                                scalePercent = 100.0;
                            }
                            if (angle < 0.0) {
                                angle = 0.0;
                            }
                            img = IProduct.cropImage(img, Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(w), Integer.parseInt(h), angle, scalePercent);
                            ret.add(img);
                        }
                    } else if (YDMASessonUtil.getUserInfo().getPricetype().equals(\uc0c1\ud488\uc874\uc7ac\ud568) || YDMASessonUtil.getUserInfo().getPricetype().equals("4") || YDMASessonUtil.getUserInfo().getPricetype().equals("6")) {
                        imgchk = ShopCommon.downloadImgFileCheck(img);
                        if (!imgchk.equals("")) {
                            ret.add(imgchk);
                        } else {
                            if (scalePercent <= 0.0) {
                                scalePercent = 100.0;
                            }
                            if (angle < 0.0) {
                                angle = 0.0;
                            }
                            img = IProduct.cropImage(img, Integer.parseInt(x), Integer.parseInt(y), Integer.parseInt(w), Integer.parseInt(h), angle, scalePercent);
                            ret.add(img);
                        }
                    } else {
                        ret.add((String)imgs.get(i));
                    }
                }
                ++i;
            }
        }
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    default public List<String> getProductImages(ShopProductDto dto, String x, String y, String w, String h) throws Exception {
        ArrayList<String> ret = new ArrayList<String>();
        if (dto.getGoods_keyword().equals("shop0319")) {
            List<String> images = Arrays.asList(dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24());
            List imgs = images.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            int i = 0;
            while (i < imgs.size()) {
                String img = ShopCommon.downloadImgFileJPG((String)imgs.get(i), 600, 600, dto, i);
                if (!img.equals("")) {
                    UnifiedUploadManager manager = new UnifiedUploadManager();
                    String xmlfile = manager.upload(Paths.get(img, new String[0]));
                    ret.add(xmlfile);
                }
                ++i;
            }
        } else {
            List<String> images = Arrays.asList(dto.getImg_path(), dto.getImg_path1(), dto.getImg_path2(), dto.getImg_path3(), dto.getImg_path4(), dto.getImg_path5(), dto.getImg_path6(), dto.getImg_path7(), dto.getImg_path8(), dto.getImg_path9(), dto.getImg_path10(), dto.getImg_path11(), dto.getImg_path12(), dto.getImg_path13(), dto.getImg_path14(), dto.getImg_path15(), dto.getImg_path16(), dto.getImg_path17(), dto.getImg_path18(), dto.getImg_path19(), dto.getImg_path20(), dto.getImg_path21(), dto.getImg_path22(), dto.getImg_path23(), dto.getImg_path24());
            List imgs = images.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            int i = 0;
            while (i < imgs.size()) {
                String img = ShopCommon.downloadImgFileJPG((String)imgs.get(i), 600, 600, dto, i);
                if (!img.equals("")) {
                    ret.add((String)imgs.get(i));
                }
                ++i;
            }
        }
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    default public List<String> setImgRatioChange(ShopProductDto dto, List<String> strImages, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String img = "";
        ArrayList<String> ret = new ArrayList<String>();
        if (dto.getGoods_keyword().equals("shop0319")) {
            int i = 0;
            while (i < strImages.size()) {
                if (shoppingMallDetailDto.getShopcd().equals("shop0067") || shoppingMallDetailDto.getShopcd().equals("shop0068") || shoppingMallDetailDto.getShopcd().equals("shop00671") || shoppingMallDetailDto.getShopcd().equals("shop00681")) {
                    img = ShopCommon.downloadImgFileJPG(strImages.get(i), 600, 800, dto, i);
                    ret.add(img);
                } else {
                    img = ShopCommon.downloadImgFileJPG(strImages.get(i), 450, 600, dto, i);
                    ret.add(img);
                }
                if (img.equals("")) {
                    // empty if block
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < strImages.size()) {
                if (shoppingMallDetailDto.getShopcd().equals("shop0067") || shoppingMallDetailDto.getShopcd().equals("shop0068")) {
                    img = ShopCommon.downloadImgFileJPG(strImages.get(i), 600, 800, dto, i);
                    ret.add(img);
                } else {
                    img = ShopCommon.downloadImgFileJPG(strImages.get(i), 450, 600, dto, i);
                    ret.add(img);
                }
                if (!img.equals("")) {
                    if (dto.getGoods_keyword().equals("shop9985")) {
                        String imgchk = ShopCommon.downloadImgFileCheck(img);
                        if (!imgchk.equals("")) {
                            ret.add(imgchk);
                        } else {
                            ret.add(img);
                        }
                    } else {
                        ret.add(strImages.get(i));
                    }
                }
                ++i;
            }
        }
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    default public Process execImgConvert(String[] convImages, String exeFile, String exeDirectory) throws IOException {
        String imagesToProcess = String.join((CharSequence)",", convImages);
        String commandImagesArg = String.format("\"1,%s\"", imagesToProcess);
        ProcessBuilder builder = new ProcessBuilder(exeFile, "-l", commandImagesArg);
        builder.directory(new File(exeDirectory));
        builder.redirectErrorStream(true);
        return builder.start();
    }

    default public void waitResult(Process activeProcess) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(activeProcess.getInputStream()));){
            while (reader.readLine() != null) {
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    default public List<String> returnFolderInConverImage(String[] orgImages, String[] convImages, String exeDirectory, Process activeProcess) throws Exception {
        ArrayList<String> processedList = new ArrayList<String>();
        int exitCode = activeProcess.waitFor();
        if (exitCode == 0) {
            int i = 0;
            while (i < orgImages.length) {
                String outputImagePath = String.valueOf(exeDirectory) + File.separator + "out_" + convImages[i];
                if (new File(outputImagePath).exists()) {
                    processedList.add(outputImagePath);
                } else {
                    processedList.add(orgImages[i]);
                }
                new File(String.valueOf(exeDirectory) + File.separator + convImages[i]).delete();
                ++i;
            }
        }
        return processedList;
    }

    public static String getContentString(List<List<String>> prodnm) {
        String complite = "";
        int i = 0;
        while (i < prodnm.size()) {
            complite = prodnm.get(i).get(3);
            ++i;
        }
        return complite;
    }

    public static String getContentprodnm(List<List<String>> prodnm) {
        String complite = "";
        int i = 0;
        while (i < prodnm.size()) {
            complite = prodnm.get(i).get(0).trim();
            ++i;
        }
        return complite;
    }

    public static String splitMark(String text) {
        String[] split = text.split("-| ");
        String complite = "";
        int j = 0;
        while (j < split.length) {
            complite = String.valueOf(complite) + split[j];
            complite = complite.trim();
            ++j;
        }
        return complite;
    }

    default public void deleteFTPServerOrigin(List<String> imageDelete) throws Exception {
        int i = 0;
        while (i < imageDelete.size()) {
            if (!imageDelete.get(i).trim().equals("")) {
                String remoteDir = "";
                remoteDir = YDMAProperties.getInstance().getAppProperty("ftp.webpath");
                String userdir = String.valueOf(YDMASessonUtil.getCompnoInfo().getCompno()) + YDMASessonUtil.getUserInfo().getUserId();
                FtpUtil.deletefile(String.valueOf(remoteDir) + "/" + userdir, imageDelete.get(i).substring(imageDelete.get(i).lastIndexOf("/") + 1, imageDelete.get(i).length()));
            }
            ++i;
        }
    }

    default public void deleteFTPServer(List<String> imageDelete) throws Exception {
        int i = 0;
        while (i < imageDelete.size()) {
            if (imageDelete.get(i).trim().contains("cloudinary")) {
                CloudinaryUploadService.get().deleteImage(imageDelete.get(i));
            }
            ++i;
        }
    }

    public static List<String> checkSearch(List<String> list, List<String> removetag, List<String> search) {
        int i = 0;
        while (i < list.size()) {
            boolean shouldAdd = true;
            int j = 0;
            while (j < removetag.size()) {
                if (list.get(i).contains(removetag.get(j))) {
                    shouldAdd = false;
                    break;
                }
                ++j;
            }
            if (shouldAdd) {
                search.add(list.get(i));
            }
            ++i;
        }
        search = Lists.newArrayList((Iterable)Sets.newHashSet(search));
        return search;
    }

    public static String findFirstForbiddenKeyword(ShopProductDto dto, String forbiddenKeywords) {
        if (dto == null) {
            return null;
        }
        if (!dto.getExcepkeywdyn().equals("Y")) {
            return null;
        }
        HashSet forbiddenSet = new HashSet();
        if (dto.getExcepkeywd() != null && !dto.getExcepkeywd().trim().isEmpty()) {
            forbiddenSet.addAll(Arrays.stream(dto.getExcepkeywd().split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toSet()));
        }
        if (forbiddenKeywords != null && !forbiddenKeywords.trim().isEmpty()) {
            forbiddenSet.addAll(Arrays.stream(forbiddenKeywords.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toSet()));
        }
        if (forbiddenSet.isEmpty()) {
            return null;
        }
        if (dto.getGoods_search() != null && !dto.getGoods_search().trim().isEmpty()) {
            Set searchSet = Arrays.stream(dto.getGoods_search().split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(String::toLowerCase).collect(Collectors.toSet());
            for (String fw : forbiddenSet) {
                if (!searchSet.contains(fw)) continue;
                return fw;
            }
        }
        if (dto.getGoods_nm() != null && !dto.getGoods_nm().trim().isEmpty()) {
            String nameLower = dto.getGoods_nm().toLowerCase();
            for (String fw : forbiddenSet) {
                if (!nameLower.contains(fw)) continue;
                return fw;
            }
        }
        return null;
    }

    public static boolean isAllowed(ShopProductDto dto, String forbiddenKeywords) {
        return IProduct.findFirstForbiddenKeyword(dto, forbiddenKeywords) == null;
    }

    public static String removeBrokenImgTag(String html) {
        String brokenImgTag = "<br/><img src='http://im2.wholesaledepot.co.kr/images/etc/dw_notice.jpg'/>";
        if (html.contains(brokenImgTag)) {
            html = html.replace(brokenImgTag, "");
        }
        return html;
    }

    public static String formatProductNameByCode(String code, ShopProductDto dto) {
        String value = "";
        String modelNm = dto.getModel_nm() != null ? dto.getModel_nm() : "";
        String goodsNm = dto.getGoods_nm() != null ? dto.getGoods_nm() : "";
        switch (code) {
            case "1": {
                value = goodsNm;
                break;
            }
            case "2": {
                value = modelNm.isEmpty() ? goodsNm : modelNm;
                break;
            }
            case "3": {
                value = modelNm.isEmpty() ? goodsNm : String.valueOf(goodsNm) + " (" + modelNm + ")";
                break;
            }
            case "4": {
                value = modelNm.isEmpty() ? goodsNm : String.valueOf(modelNm) + " (" + goodsNm + ")";
                break;
            }
            case "5": {
                value = modelNm.isEmpty() ? goodsNm : String.valueOf(goodsNm) + " " + modelNm;
                break;
            }
            case "6": {
                value = modelNm.isEmpty() ? goodsNm : String.valueOf(modelNm) + " " + goodsNm;
                break;
            }
            default: {
                value = goodsNm;
            }
        }
        return value;
    }

    public static String formatProductNameByCode2(String code, ShopProductDto dto) {
        String value = "";
        String modelNm = dto.getModel_nm() != null ? dto.getModel_nm() : "";
        String goodsNm = dto.getGoods_nm() != null ? dto.getGoods_nm() : "";
        switch (code) {
            case "0": 
            case "01": {
                value = goodsNm;
                break;
            }
            case "1": 
            case "02": {
                value = modelNm.isEmpty() ? goodsNm : modelNm;
                break;
            }
            case "2": 
            case "03": {
                value = modelNm.isEmpty() ? goodsNm : String.valueOf(goodsNm) + " (" + modelNm + ")";
                break;
            }
            case "3": 
            case "04": {
                value = modelNm.isEmpty() ? goodsNm : String.valueOf(modelNm) + " (" + goodsNm + ")";
                break;
            }
            case "4": 
            case "05": {
                value = modelNm.isEmpty() ? goodsNm : String.valueOf(goodsNm) + " " + modelNm;
                break;
            }
            case "5": 
            case "06": {
                value = modelNm.isEmpty() ? goodsNm : String.valueOf(modelNm) + " " + goodsNm;
                break;
            }
            default: {
                value = goodsNm;
            }
        }
        return value;
    }
}

