/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.data.Tmon.ShopProductTmonCategory;
import com.kdjsystem.mlink.shop.data.kakaostore.ShopProductKakaoStoreCategory;
import com.kdjsystem.mlink.shop.data.ssgmarket.ShopProductSSGCategory;
import com.kdjsystem.mlink.shop.data.wemakeprice.ShopProductWemarketCategory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface IShopProductCategory {
    public String excute(ShopProductDto var1, Map<String, String> var2, ShoppingMallDetailDto var3) throws Exception;

    public static IShopProductCategory getSearchBean(String shopid) {
        switch (shopid) {
            case "shop0287": {
                return new ShopProductWemarketCategory(null);
            }
            case "shop0273": {
                return new ShopProductKakaoStoreCategory(null);
            }
            case "shop0076": {
                return new ShopProductTmonCategory(null);
            }
            case "shop0411": {
                return new ShopProductSSGCategory(null);
            }
        }
        return null;
    }

    default public List<String> getCategorySplit(String catenm) throws Exception {
        List<String> list = Arrays.asList(catenm.split(">| |/|\u00b7"));
        return list;
    }

    default public String setCategoryFullname(String lcateName, String mcateName, String scateName, String dcateName) {
        String fullname = "";
        fullname = String.valueOf(lcateName) + ">" + mcateName + ">" + scateName + ">" + dcateName;
        return fullname;
    }

    default public List<String> getCategoryCode(ShopProductDto dto) {
        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }
}

