/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.ImageUpload.CloudinaryUploadService;
import com.kdjsystem.mlink.shop.ImageUpload.CloudinaryUsageService;
import com.kdjsystem.mlink.shop.common.CommonCodeDto;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.CloudinaryApiInfoDto;
import com.kdjsystem.mlink.shop.dao.NaverCateApiInfoDto;
import com.kdjsystem.mlink.shop.dao.OwnerClanMyItemInfo;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ShopCatInfDto;
import com.kdjsystem.mlink.shop.dao.ShopCateDto;
import com.kdjsystem.mlink.shop.dao.ShopCategoryDto;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopErrCodeDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProdFolderDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopSqlBuilder;
import com.kdjsystem.mlink.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.domesin.DomesinSessonUtil;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.ProductIforDto;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;

public class ShopCommonDao {
    private static ShopCommonDao daoInstance = new ShopCommonDao();
    Map<String, ShopProductAdditionDto> MapProductAddition = new HashMap<String, ShopProductAdditionDto>();

    private ShopCommonDao() {
    }

    public static ShopCommonDao get() {
        return daoInstance;
    }

    public String getAttrName(String attrcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String ret = "";
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = String.format(" SELECT attrnm as attrnm from prodattr where attrcd = '%s' limit 1 ", attrcd);
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getSeasonItems]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ret = rs.getString("attrnm");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return ret;
    }

    public List<ShopErrCodeDto> getErrorCode() throws Exception {
        ArrayList<ShopErrCodeDto> contents = new ArrayList<ShopErrCodeDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(code,''), ifnull(content,''), ifnull(treatcontent,''), ifnull(use_yn,'') from shoperrcode ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getErrorCode]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int j = 0;
                    ShopErrCodeDto dto = new ShopErrCodeDto();
                    dto.setCode(rs.getString(++j));
                    dto.setContent(rs.getString(++j));
                    dto.setTreatcontent(rs.getString(++j));
                    dto.setUse_yn(rs.getString(++j));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public boolean isCrawling() {
        boolean result;
        block12: {
            result = false;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT EXISTS(\r\n\tSELECT 1 FROM shopdtl\r\n\tWHERE COMPNO= ?\r\n\tAND  DEALTREAD ='\uc0ac\uc6a9\uc911'\r\n)AS ISCHK";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        boolean bl = result = rs.getInt("ISCHK") > 0;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int UpdateInvoiceOrder(int ordSeq, int wonCost, int mallWonCost, String deliveryCode, String invoNo) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE shopordmst \r\n");
                sql.append("SET WON_COST=? \r\n");
                sql.append(",MALL_WON_COST=? \r\n");
                sql.append(",ORDER_STATUS =? \r\n");
                sql.append(",DELIVERY_ID=? \r\n");
                sql.append(",INVOICE_NO=? \r\n");
                sql.append("WHERE ORDSEQ=?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int rowIdx = 0;
                pstmt.setInt(++rowIdx, wonCost);
                pstmt.setInt(++rowIdx, mallWonCost);
                pstmt.setString(++rowIdx, "401");
                pstmt.setString(++rowIdx, deliveryCode);
                pstmt.setString(++rowIdx, invoNo);
                pstmt.setInt(++rowIdx, ordSeq);
                YDMAStringUtil.Print("[INVOIC UPDATE]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int UpdateInvoiceOrder1(int ordSeq, String deliveryCode, String invoNo) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("UPDATE shopordmst SET \r\n");
                sql.append("ORDER_STATUS =?, \r\n");
                sql.append("DELIVERY_ID=?, \r\n");
                sql.append("INVOICE_NO=? \r\n");
                sql.append("WHERE ORDSEQ=?");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int rowIdx = 0;
                pstmt.setString(++rowIdx, "402");
                pstmt.setString(++rowIdx, deliveryCode);
                pstmt.setString(++rowIdx, invoNo);
                pstmt.setInt(++rowIdx, ordSeq);
                YDMAStringUtil.Print("[INVOIC UPDATE]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopDeliveryDto> getExpress(String shopcode) throws Exception {
        ArrayList<ShopDeliveryDto> contents = new ArrayList<ShopDeliveryDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SHOPCD,'') as  SHOPCD,ifnull(DLVID,'') as DLVID,ifnull(DLVNM,'') as DLVNM , ifnull(EXPRESS_URL_ID,'') as URL,ifnull(DOSIN_CODE,'') as DOSIN_CODE  from shopdeliverys where shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcode);
                YDMAStringUtil.Print("[getExpress]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopDeliveryDto dto = new ShopDeliveryDto();
                    dto.setShopCd(rs.getString("SHOPCD"));
                    dto.setDlvID(rs.getString("DLVID"));
                    dto.setDivNM(rs.getString("DLVNM"));
                    dto.setUrlcode(rs.getString("URL"));
                    dto.setDs_code(rs.getString("DOSIN_CODE"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopDeliveryDto> getExpress_ExpSeq(String shopcode) throws Exception {
        ArrayList<ShopDeliveryDto> contents = new ArrayList<ShopDeliveryDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder queryBuilder = new StringBuilder();
                queryBuilder.append("SELECT IFNULL(SHOPCD,'') AS SHOPCD, ").append("IFNULL(DLVID,'') AS DLVID, ").append("IFNULL(DLVNM,'') AS DLVNM, ").append("IFNULL(EXPRESS_URL_ID,'') AS URL, ").append("IFNULL(DOSIN_CODE,'') AS DOSIN_CODE ").append("FROM SHOPDELIVERYS ").append("WHERE SHOPCD = ? ").append("ORDER BY ").append("CASE WHEN EXP_SEQ IS NOT NULL AND EXP_SEQ > 0 THEN EXP_SEQ ELSE DLVNM END ASC, ").append("DLVNM ASC;");
                String query = queryBuilder.toString().toUpperCase();
                pstmt = connection.prepareStatement(query);
                pstmt.setString(1, shopcode);
                YDMAStringUtil.Print("[getExpress_ExpSeq]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopDeliveryDto dto = new ShopDeliveryDto();
                    dto.setShopCd(rs.getString("SHOPCD"));
                    dto.setDlvID(rs.getString("DLVID"));
                    dto.setDivNM(rs.getString("DLVNM"));
                    dto.setUrlcode(rs.getString("URL"));
                    dto.setDs_code(rs.getString("DOSIN_CODE"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopDeliveryDto> getExpressAll() throws Exception {
        ArrayList<ShopDeliveryDto> contents = new ArrayList<ShopDeliveryDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SHOPCD,'') as  SHOPCD,ifnull(DLVID,'') as DLVID ,ifnull(DLVNM,'')  as DLVNM from shopdeliverys order by SHOPCD,DLVID  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getExpressAll]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopDeliveryDto dto = new ShopDeliveryDto();
                    dto.setShopCd(rs.getString("SHOPCD"));
                    dto.setDlvID(rs.getString("DLVID"));
                    dto.setDivNM(rs.getString("DLVNM"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShoppingMallDetailDto> ShoppingMallDetailList() throws Exception {
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(m.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(m.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(b.SHOPURL,'')  AS SHOPURL, \r\n");
                sql.append("IFNULL(d.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(D.NICKNM1,D.NICKNM2) AS NICKNM, \r\n");
                sql.append("IFNULL(D.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(D.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(d.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(d.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(d.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(d.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(d.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(D.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(D.SHOPSEQ, '') AS SHOPSEQ,      \r\n");
                sql.append("IFNULL(D.SUPPSTDITEM, '') AS SUPPSTDITEM  ,    \r\n");
                sql.append("IFNULL(D.SUPPSTDRATI, '') AS SUPPSTDRATI,      \r\n");
                sql.append("IFNULL(D.FORBIDDENKEYWORDS, '') AS FORBIDDENKEYWORDS \r\n");
                sql.append(" FROM shopmst AS m");
                sql.append(" LEFT JOIN shopdtl AS d");
                sql.append(" ON m.COMPNO = d.COMPNO AND m.SHOPCD = d.SHOPCD join shopinfo b on m.shopcd = b.shopcd ");
                sql.append(" WHERE m.COMPNO =?  AND D.DEALTREAD = '\uc0ac\uc6a9\uc911' \r\n");
                sql.append(" ORDER BY m.SHOPCD, d.SHOPSEQ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setNicknm1(rs.getString("NICKNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShopUrl(rs.getString("SHOPURL"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                    dto.setSuppstditem(rs.getString("SUPPSTDITEM"));
                    dto.setSuppstdrati(rs.getString("SUPPSTDRATI"));
                    dto.setForbiddenKeywords(rs.getString("FORBIDDENKEYWORDS"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShoppingMallDetailDto> DomeMallDetailList() throws Exception {
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(m.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(m.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(b.SHOPURL,'')  AS SHOPURL, \r\n");
                sql.append("IFNULL(d.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(D.NICKNM1,D.NICKNM2) AS NICKNM, \r\n");
                sql.append("IFNULL(D.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(D.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(d.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(d.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(d.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(d.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(d.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(D.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(D.SHOPSEQ, '') AS SHOPSEQ,      \r\n");
                sql.append("IFNULL(D.SUPPSTDITEM, '') AS SUPPSTDITEM  ,    \r\n");
                sql.append("IFNULL(D.SUPPSTDRATI, '') AS SUPPSTDRATI      \r\n");
                sql.append(" FROM shopmstdome AS m");
                sql.append(" LEFT JOIN shopdtldome AS d");
                sql.append(" ON m.COMPNO = d.COMPNO AND m.SHOPCD = d.SHOPCD join shopinfodome b on m.shopcd = b.shopcd ");
                sql.append(" WHERE m.COMPNO =?  AND D.DEALTREAD = '\uc0ac\uc6a9\uc911' \r\n");
                sql.append(" ORDER BY m.SHOPCD, d.SHOPSEQ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setNicknm1(rs.getString("NICKNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setShopUrl(rs.getString("SHOPURL"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                    dto.setSuppstditem(rs.getString("SUPPSTDITEM"));
                    dto.setSuppstdrati(rs.getString("SUPPSTDRATI"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void setShopCategoryInsertNUpdate(List<ShopCateDto> list) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into categlarge (SHOPCD,CODE,NAME, PARENT_CODE, LEVEL, SORT_IDX,COMMENT,USE_YN )  \r\n values (?, ?, ?, ?, ?, ? , ?, ?) ON  DUPLICATE KEY  UPDATE NAME = ? , PARENT_CODE = ? , LEVEL = ? , SORT_IDX = ? , COMMENT = ?, USE_YN = ?  ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopCateDto dto : list) {
                    int idx = 0;
                    pstmt.setString(++idx, dto.getShopcd());
                    pstmt.setString(++idx, dto.getCode());
                    pstmt.setString(++idx, dto.getName());
                    pstmt.setString(++idx, dto.getParent_code());
                    pstmt.setInt(++idx, dto.getLevel());
                    pstmt.setInt(++idx, dto.getSort_idx());
                    pstmt.setString(++idx, dto.getComment());
                    pstmt.setString(++idx, dto.getUse_yn());
                    pstmt.setString(++idx, dto.getName());
                    pstmt.setString(++idx, dto.getParent_code());
                    pstmt.setInt(++idx, dto.getLevel());
                    pstmt.setInt(++idx, dto.getSort_idx());
                    pstmt.setString(++idx, dto.getComment());
                    pstmt.setString(++idx, dto.getUse_yn());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setShopProdInfoUpdate(List<ShopProductDto> list) {
    }

    public boolean isCompno() {
        boolean result;
        block12: {
            result = false;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT count(*) as cnt from systemconf WHERE COMPNO= ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        boolean bl = result = rs.getInt("cnt") > 0;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public int systemConfInsert(ShopPreferencesDto dto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into systemconf(COMPNO,      SUGGPROCNT,       ORDPERIOD,        ORDSTATUS,  \t  ORDIMPTPER,     PRODMNG,      PRODLINK,PRODFAIL,    EXCEPKEYWDYN,  \t  EXCEPKEYWD, \t    PRODNM_LENMNGYN,  STSCPERIOD,     ENDDATE,      DELIVERYNM,PRODSEARCHYN,PRODSEARCHYN2,    PRODDUP1,   \t    PRODDUP2,         PRODDUP3,   \t  DELIVERYCOST, PRODCPYYN,autostat,    URL_PRODRECV,     SECONDAUTH11STYN, DISPLAYHOME,      OUTOFPRODINFO,  PRODCPY_LOC,  SAVEPRODUCTLOGYN,SLACKYN, \tSLACKKEY, \t \t  SLACKID, \t\t\tSTARTMENU,   \t  Y_STARTMENU,    SELFCHANGEYN, SELFMOD_NO) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++rowIdx, dto.getSuggprocnt());
                pstmt.setString(++rowIdx, dto.getOrdperiod());
                pstmt.setString(++rowIdx, dto.getOrdstatus());
                pstmt.setString(++rowIdx, dto.getOrdimptper());
                pstmt.setString(++rowIdx, dto.getProdmng());
                pstmt.setString(++rowIdx, dto.getProdlink());
                pstmt.setString(++rowIdx, dto.getProdfail());
                pstmt.setString(++rowIdx, dto.getExcepkeywdyn());
                pstmt.setString(++rowIdx, dto.getExcepkeywd() == null ? "" : dto.getExcepkeywd());
                pstmt.setString(++rowIdx, dto.getProdnm_lenmngyn());
                pstmt.setString(++rowIdx, dto.getStscperiod());
                pstmt.setString(++rowIdx, dto.getEnddate());
                pstmt.setString(++rowIdx, dto.getDeliverynm());
                pstmt.setString(++rowIdx, dto.getProdsearchyn());
                pstmt.setString(++rowIdx, dto.getProdsearchyn2());
                pstmt.setString(++rowIdx, dto.getProddup1());
                pstmt.setString(++rowIdx, dto.getProddup2());
                pstmt.setString(++rowIdx, dto.getProddup3());
                pstmt.setString(++rowIdx, dto.getDeliverycost());
                pstmt.setString(++rowIdx, dto.getProdcpyyn());
                pstmt.setInt(++rowIdx, dto.getAutostat());
                pstmt.setString(++rowIdx, dto.getUrl_prodrecv());
                pstmt.setString(++rowIdx, dto.getSecondAuth11styn());
                pstmt.setString(++rowIdx, dto.getDisplayHome());
                pstmt.setString(++rowIdx, dto.getOutofprodinfo());
                pstmt.setString(++rowIdx, dto.getProdcpy_loc() == null ? "" : dto.getProdcpy_loc());
                pstmt.setString(++rowIdx, dto.getSaveproductlogyn());
                pstmt.setString(++rowIdx, dto.getSlackyn());
                pstmt.setString(++rowIdx, dto.getSlackkey());
                pstmt.setString(++rowIdx, dto.getSlackid());
                pstmt.setString(++rowIdx, dto.getStartMenu());
                pstmt.setString(++rowIdx, dto.getY_startMenu());
                YDMAStringUtil.Print("[systemConfInsert]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int systemConfUpdate(ShopPreferencesDto dto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " update systemconf     set SUGGPROCNT = ?, ORDPERIOD = ?, ORDSTATUS = ?, ORDIMPTPER = ?, PRODMNG = ?, \t\t   EXCEPKEYWDYN = ?, EXCEPKEYWD = ?, PRODNM_LENMNGYN = ?,  \t   STSCPERIOD = ? ,ENDDATE=?,DELIVERYNM=?,PRODSEARCHYN=?, PRODSEARCHYN2=?,        PRODDUP1 = ? , PRODDUP2 = ? , PRODDUP3 = ? , DELIVERYCOST = ?, PRODCPYYN = ?, autostat = ? , \t\t   URL_PRODRECV = ?, \t\t   SECONDAUTH11STYN = ?, DISPLAYHOME = ?, OUTOFPRODINFO=?, PRODCPY_LOC = ?, SAVEPRODUCTLOGYN = ?,\t\t   SLACKYN = ?, SLACKKEY = ?, SLACKID = ?, STARTMENU = ?, Y_STARTMENU = ?,\t\t   SELFCHANGEYN = ?, SELFMOD_NO = ? where compno = ? ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                int rowIdx = 0;
                pstmt.setString(++rowIdx, dto.getSuggprocnt());
                pstmt.setString(++rowIdx, dto.getOrdperiod());
                pstmt.setString(++rowIdx, dto.getOrdstatus());
                pstmt.setString(++rowIdx, dto.getOrdimptper());
                pstmt.setString(++rowIdx, dto.getProdmng());
                pstmt.setString(++rowIdx, dto.getExcepkeywdyn());
                pstmt.setString(++rowIdx, dto.getExcepkeywd() == null ? "" : dto.getExcepkeywd());
                pstmt.setString(++rowIdx, dto.getProdnm_lenmngyn());
                pstmt.setString(++rowIdx, dto.getStscperiod());
                pstmt.setString(++rowIdx, dto.getEnddate());
                pstmt.setString(++rowIdx, dto.getDeliverynm());
                pstmt.setString(++rowIdx, dto.getProdsearchyn());
                pstmt.setString(++rowIdx, dto.getProdsearchyn2());
                pstmt.setString(++rowIdx, dto.getProddup1());
                pstmt.setString(++rowIdx, dto.getProddup2());
                pstmt.setString(++rowIdx, dto.getProddup3());
                pstmt.setString(++rowIdx, dto.getDeliverycost());
                pstmt.setString(++rowIdx, dto.getProdcpyyn());
                pstmt.setInt(++rowIdx, dto.getAutostat());
                pstmt.setString(++rowIdx, dto.getUrl_prodrecv());
                pstmt.setString(++rowIdx, dto.getSecondAuth11styn());
                pstmt.setString(++rowIdx, dto.getDisplayHome());
                pstmt.setString(++rowIdx, dto.getOutofprodinfo());
                pstmt.setString(++rowIdx, dto.getProdcpy_loc() == null ? "" : dto.getProdcpy_loc());
                pstmt.setString(++rowIdx, dto.getSaveproductlogyn());
                pstmt.setString(++rowIdx, dto.getSlackyn());
                pstmt.setString(++rowIdx, dto.getSlackkey());
                pstmt.setString(++rowIdx, dto.getSlackid());
                pstmt.setString(++rowIdx, dto.getStartMenu());
                pstmt.setString(++rowIdx, dto.getY_startMenu());
                pstmt.setString(++rowIdx, dto.getSelfchangeyn());
                pstmt.setString(++rowIdx, dto.getSelfmod_no());
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[systemConfUpdate]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public ShopPreferencesDto getSystemConf() throws Exception {
        ShopPreferencesDto dto = new ShopPreferencesDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(COMPNO,''), ifnull(SUGGPROCNT,''), ifnull(ORDPERIOD,''), ifnull(ORDSTATUS,''), ifnull(ORDIMPTPER,''), ifnull(PRODMNG,''), ifnull(PRODLINK,''), ifnull(PRODFAIL,''), ifnull(EXCEPKEYWDYN,''), ifnull(EXCEPKEYWD,''), ifnull(PRODNM_LENMNGYN,''), ifnull(STSCPERIOD,''),ifnull(ENDDATE,''),ifnull(DELIVERYNM,''),ifnull(PRODSEARCHYN,'N'),ifnull(PRODSEARCHYN2,'N'),ifnull(PROCCNT,1),ifnull(PRODDUP1,''),ifnull(PRODDUP2,''),ifnull(PRODDUP3,''),ifnull(DELIVERYCOST,'0'), ifnull(PRODCPYYN,'N'), ifnull(AUTOSTAT,0),ifnull(URL_PRODRECV,''), ifnull(SECONDAUTH11STYN,'N'), ifnull(DISPLAYHOME,'N'), ifnull(OUTOFPRODINFO,'N'), ifnull(PRODCPY_LOC,''), ifnull(SAVEPRODUCTLOGYN,'N'), ifnull(SLACKYN,'N'), ifnull(SLACKKEY,''), ifnull(SLACKURL,''), ifnull(SLACKID,''), ifnull(STARTMENU,''), ifnull(Y_STARTMENU,''),ifnull(SELFCHANGEYN,''), ifnull(SELFMOD_NO,'')from systemconf where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int j = 0;
                    dto.setCompno(rs.getString(++j));
                    dto.setSuggprocnt(rs.getString(++j));
                    dto.setOrdperiod(rs.getString(++j));
                    dto.setOrdstatus(rs.getString(++j));
                    dto.setOrdimptper(rs.getString(++j));
                    dto.setProdmng(rs.getString(++j));
                    dto.setProdlink(rs.getString(++j));
                    dto.setProdfail(rs.getString(++j));
                    dto.setExcepkeywdyn(rs.getString(++j));
                    dto.setExcepkeywd(rs.getString(++j));
                    dto.setProdnm_lenmngyn(rs.getString(++j));
                    dto.setStscperiod(rs.getString(++j));
                    dto.setEnddate(rs.getString(++j));
                    dto.setDeliverynm(rs.getString(++j));
                    dto.setProdsearchyn(rs.getString(++j));
                    dto.setProdsearchyn2(rs.getString(++j));
                    dto.setProccnt(rs.getInt(++j));
                    dto.setProddup1(rs.getString(++j));
                    dto.setProddup2(rs.getString(++j));
                    dto.setProddup3(rs.getString(++j));
                    dto.setDeliverycost(rs.getString(++j));
                    dto.setProdcpyyn(rs.getString(++j));
                    dto.setAutostat(rs.getInt(++j));
                    dto.setUrl_prodrecv(rs.getString(++j));
                    dto.setSecondAuth11styn(rs.getString(++j));
                    dto.setDisplayHome(rs.getString(++j));
                    dto.setOutofprodinfo(rs.getString(++j));
                    dto.setProdcpy_loc(rs.getString(++j));
                    dto.setSaveproductlogyn(rs.getString(++j));
                    dto.setSlackyn(rs.getString(++j));
                    dto.setSlackkey(rs.getString(++j));
                    dto.setSlackurl(rs.getString(++j));
                    dto.setSlackid(rs.getString(++j));
                    dto.setStartMenu(rs.getString(++j));
                    dto.setY_startMenu(rs.getString(++j));
                    dto.setSelfchangeyn(rs.getString(++j));
                    dto.setSelfmod_no(rs.getString(++j));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public boolean isJobScheduler() {
        boolean result;
        block12: {
            result = false;
            Connection connection = null;
            PreparedStatement pstmt_orddtl = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql_orddtl = "SELECT EXISTS(\r\n\tSELECT 1 FROM scheduinfo\r\n\tWHERE COMPNO= ?\r\n\tAND  JOBSTAT ='Y'\r\n)AS ISCHK";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    YDMAStringUtil.Print("[\uc874\uc7ac \uc720\ubb34]" + pstmt_orddtl.toString());
                    rs = pstmt_orddtl.executeQuery();
                    while (rs.next()) {
                        boolean bl = result = rs.getInt("ISCHK") > 0;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt_orddtl, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public ShopOrderMstDto ShoppingMallDetailOneChoice(ShopOrderMstDto dtoItem) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SUPPSTDITEM,'') AS SUPPSTDITEM, ifnull(SUPPSTDRATI,'0') AS SUPPSTDRATI from shopdtl where compno = ? and shopcd = ? and shoppingid = ? ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dtoItem.getShopid());
                pstmt.setString(3, dtoItem.getShop_userid());
                YDMAStringUtil.Print("[ShoppingMallDetailOneChoice]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dtoItem.setSuppstditem(rs.getString("SUPPSTDITEM"));
                    dtoItem.setSuppstdrati(rs.getString("SUPPSTDRATI"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dtoItem;
    }

    public String getDeliveryName(String shopid, String delivery_id) throws Exception {
        String delvnm = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select dlvnm from shopdeliverys where shopcd = ? and dlvid = ? ";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, shopid);
                pstmt.setString(2, delivery_id);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    delvnm = rs.getString(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return delvnm;
    }

    public List<CommonCodeDto> getCommonCode() throws Exception {
        ArrayList<CommonCodeDto> contents = new ArrayList<CommonCodeDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT \r\nB.code_mng AS mngcode ,\r\nA.name     AS mngname ,\r\nB.code     AS code    ,\r\nB.name     AS NAME   , \r\nb.use_yn  AS use_yn      \r\nFROM com_code_master AS A\r\nINNER JOIN com_code_detail AS B \r\nON A.code = B.code_mng  \tWHERE B.USE_YN ='Y' ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[CommonCodeDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    CommonCodeDto dto = new CommonCodeDto();
                    dto.setMngCode(rs.getString("MNGCODE"));
                    dto.setMngName(rs.getString("MNGNAME"));
                    dto.setCode(rs.getString("CODE"));
                    dto.setName(rs.getString("NAME"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ProductIforDto> getAttrCode() throws Exception {
        ArrayList<ProductIforDto> contents = new ArrayList<ProductIforDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(attrcd,'') AS ATTRCD , ifnull(attrnm,'') AS ATTRNM from prodattr";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getAttrCode]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ProductIforDto dto = new ProductIforDto();
                    dto.setAttrcd(rs.getString("ATTRCD"));
                    dto.setAttrnm(rs.getString("ATTRNM"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopProductDto> getProductInCountNotCond(String dome, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ShopProductDto> contents = new ArrayList<ShopProductDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SHOPCD,SHOPID,SHOPSEQ,COUNTS  FROM SUM_PRODINCOUNTS WHERE compno = ? ";
                if (!dome.equals("")) {
                    sql = String.valueOf(sql) + "  AND GOODS_KEYWORD = ? \r\n";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                }
                YDMAStringUtil.Print("[getProductInCountNotCond]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProductDto dto = new ShopProductDto();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopuserid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setCounts(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopProductDto> getProductInCount(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        String compno = YDMASessonUtil.getCompnoInfo().getCompno();
        ArrayList<ShopProductDto> contents = new ArrayList<ShopProductDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT SHOPCD AS SHOPCD, SHOP_USERID AS SHOPID, SHOPSEQ AS SHOPSEQ, COUNT(*) AS COUNTS \r\n").append("  FROM ( \r\n");
                sql.append("        SELECT SHOPCD, SHOP_USERID, SHOPSEQ \r\n").append("          FROM shopprodin AS A \r\n").append("         WHERE COMPNO = ? \r\n").append("           AND SHOPSENDSTATUS <> 9000 \r\n");
                ShopSqlBuilder.appendCommonConditions(sql, compno, dome, folder, categ, searchgubun, searchtxt);
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("           AND INSERTDT BETWEEN ? AND ? \r\n");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("        UNION ALL \r\n").append("        SELECT SHOPCD, SHOP_USERID, SHOPSEQ \r\n").append("          FROM shopprodin AS A \r\n").append("         WHERE COMPNO = ? \r\n").append("           AND SHOPSENDSTATUS <> 9000 \r\n");
                    ShopSqlBuilder.appendCommonConditions(sql, compno, dome, folder, categ, searchgubun, searchtxt);
                    sql.append("           AND MODIFYDT BETWEEN ? AND ? \r\n");
                }
                sql.append("       ) T \r\n").append(" GROUP BY SHOPCD, SHOP_USERID, SHOPSEQ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int idx = 1;
                pstmt.setString(idx++, compno);
                if (!dome.equals("")) {
                    pstmt.setString(idx++, dome);
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(idx++, prodFrom);
                    pstmt.setString(idx++, prodTo);
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(idx++, compno);
                    if (!dome.equals("")) {
                        pstmt.setString(idx++, dome);
                    }
                    pstmt.setString(idx++, prodFrom);
                    pstmt.setString(idx++, prodTo);
                }
                YDMAStringUtil.Print("[getProductInCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProductDto dto = new ShopProductDto();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopuserid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setCounts(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopCateDto.CategoryMapLevelList> getProductInfoCountWithCateg(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ShopCateDto.CategoryMapLevelList> contents = new ArrayList<ShopCateDto.CategoryMapLevelList>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT a.ID, a.NAME, a.PARENT_CODE, a.LEVEL, IFNULL(b.COUNTS,0) AS COUNTS \r\n").append("  FROM category AS a \r\n").append("  LEFT JOIN ( \r\n").append("     SELECT CLASS_CD3 AS ID, COUNT(*) AS COUNTS \r\n").append("       FROM ( \r\n");
                sql.append("             SELECT CLASS_CD3 \r\n").append("               FROM shopprodinfo AS A \r\n").append("              WHERE COMPNO = ? \r\n");
                ShopSqlBuilder.appendCommonConditions(sql, compno, dome, folder, categ, searchgubun, searchtxt);
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("                AND INSERTDT BETWEEN ? AND ? \r\n");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("             UNION ALL \r\n").append("             SELECT CLASS_CD3 \r\n").append("               FROM shopprodinfo AS A \r\n").append("              WHERE COMPNO = ? \r\n");
                    ShopSqlBuilder.appendCommonConditions(sql, compno, dome, folder, categ, searchgubun, searchtxt);
                    sql.append("                AND MODIFYDT BETWEEN ? AND ? \r\n");
                }
                sql.append("          ) T \r\n").append("     GROUP BY CLASS_CD3 \r\n").append("  ) AS b ON a.ID = b.ID ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int idx = 1;
                pstmt.setString(idx++, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(idx++, dome);
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(idx++, prodFrom);
                    pstmt.setString(idx++, prodTo);
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(idx++, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (!dome.equals("")) {
                        pstmt.setString(idx++, dome);
                    }
                    pstmt.setString(idx++, prodFrom);
                    pstmt.setString(idx++, prodTo);
                }
                YDMAStringUtil.Print("[getProductInfoCountWithCateg]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto.CategoryMapLevelList dto = new ShopCateDto.CategoryMapLevelList();
                    dto.setId(rs.getString("ID"));
                    dto.setName(rs.getString("NAME"));
                    dto.setPid(rs.getString("PARENT_CODE"));
                    dto.setLevel(rs.getString("LEVEL"));
                    dto.setCount(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopCateDto.CategoryMapLevelList> getProductInfoCountWithCategTopLevel(String dome, String folder, String categ, String searchgubun, String searchtxt, String prodFrom, String prodTo) throws Exception {
        ArrayList<ShopCateDto.CategoryMapLevelList> contents = new ArrayList<ShopCateDto.CategoryMapLevelList>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String compno = YDMASessonUtil.getCompnoInfo().getCompno();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT a.ID, a.NAME, a.PARENT_CODE, a.LEVEL, IFNULL(b.COUNTS,0) AS COUNTS \r\n").append("  FROM category AS a \r\n").append("  LEFT JOIN ( \r\n").append("     SELECT '110000000' AS ID, COUNTS \r\n").append("       FROM ( \r\n");
                sql.append("             SELECT count(*) AS COUNTS \r\n").append("               FROM shopprodinfo AS A \r\n").append("              WHERE COMPNO = ? \r\n");
                if (!"GOODS_SEARCH_CNT".equals(searchgubun)) {
                    ShopSqlBuilder.appendCommonConditions(sql, compno, dome, folder, categ, searchgubun, searchtxt);
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("                AND INSERTDT BETWEEN ? AND ? \r\n");
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    sql.append("             UNION ALL \r\n").append("             SELECT count(*) AS COUNTS \r\n").append("               FROM shopprodinfo AS A \r\n").append("              WHERE COMPNO = ? \r\n");
                    if (!"GOODS_SEARCH_CNT".equals(searchgubun)) {
                        ShopSqlBuilder.appendCommonConditions(sql, compno, dome, folder, categ, searchgubun, searchtxt);
                    }
                    sql.append("                AND MODIFYDT BETWEEN ? AND ? \r\n");
                }
                sql.append("          ) T \r\n").append("  ) AS b ON a.ID = b.ID limit 1 ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                int idx = 1;
                pstmt.setString(idx++, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(idx++, dome);
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(idx++, prodFrom);
                    pstmt.setString(idx++, prodTo);
                }
                if (!prodFrom.equals("") && !prodTo.equals("")) {
                    pstmt.setString(idx++, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (!dome.equals("")) {
                        pstmt.setString(idx++, dome);
                    }
                    pstmt.setString(idx++, prodFrom);
                    pstmt.setString(idx++, prodTo);
                }
                YDMAStringUtil.Print("[getProductInfoCountWithCateg]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopCateDto.CategoryMapLevelList dto = new ShopCateDto.CategoryMapLevelList();
                    dto.setId(rs.getString("ID"));
                    dto.setName(rs.getString("NAME"));
                    dto.setPid(rs.getString("PARENT_CODE"));
                    dto.setLevel(rs.getString("LEVEL"));
                    dto.setCount(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<ShopProductDto> getProductInCountSum(String dome) throws Exception {
        ArrayList<ShopProductDto> contents = new ArrayList<ShopProductDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SHOPCD,SHOPID,SHOPSEQ,sum(COUNTS) AS COUNTS    from sum_prodincounts WHERE compno = ?    AND SHOPSENDSTATUS <> 9000 ";
                if (!dome.equals("")) {
                    sql = String.valueOf(sql) + "  AND GOODS_KEYWORD = ? \r\n";
                }
                sql = String.valueOf(sql) + "   group by SHOPCD,SHOPID,SHOPSEQ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (!dome.equals("")) {
                    pstmt.setString(2, dome);
                }
                YDMAStringUtil.Print("[getProductInCountSum]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShopProductDto dto = new ShopProductDto();
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopuserid(rs.getString("SHOPID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setCounts(rs.getInt("COUNTS"));
                    contents.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public ShopCatInfDto getShopCateInfName(String catsitenm, String shopcd) throws Exception {
        ShopCatInfDto dto = new ShopCatInfDto();
        List<String> find_class_nm = Arrays.asList(catsitenm.replace(" ", "").split(">"));
        List<Object> get_class_cd = new ArrayList();
        new ArrayList();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SHOPLAGCATCD,'') AS SHOPLAGCATCD, \t\t  ifnull(SHOPMIDCATCD,'') AS SHOPMIDCATCD, \t\t  ifnull(SHOPSMLCATCD,'') AS SHOPSMLCATCD,\t\t  ifnull(SHOPDETCATCD,'') AS SHOPDETCATCD, \t\t  ifnull(SHOPCATSITENM,'') AS SHOPCATSITENM   from shopcatinf  WHERE compno = ?    and shopcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[ProductIforDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    List<String> ret = Arrays.asList(rs.getString("SHOPLAGCATCD"), rs.getString("SHOPMIDCATCD"), rs.getString("SHOPSMLCATCD"), rs.getString("SHOPDETCATCD"));
                    if (catsitenm.replace(" ", "").equals(rs.getString("SHOPCATSITENM").replace(" ", ""))) {
                        get_class_cd = ret;
                        break;
                    }
                    ArrayList<String> part_class_cd = new ArrayList<String>();
                    List<String> target_class_nm = Arrays.asList(rs.getString("SHOPCATSITENM").replace(" ", "").split(">"));
                    int match = 0;
                    if (target_class_nm.size() < find_class_nm.size()) continue;
                    int i = 0;
                    while (i < find_class_nm.size()) {
                        if (!find_class_nm.get(i).equals(target_class_nm.get(i))) break;
                        ++match;
                        part_class_cd.add(ret.get(i));
                        ++i;
                    }
                    if (match <= get_class_cd.size()) continue;
                    get_class_cd = part_class_cd;
                }
                int i = 0;
                while (i < get_class_cd.size()) {
                    if (i == 0) {
                        dto.setShoplagcatcd((String)get_class_cd.get(0));
                    }
                    if (i == 1) {
                        dto.setShopmidcatcd((String)get_class_cd.get(1));
                    }
                    if (i == 2) {
                        dto.setShopsmlcatcd((String)get_class_cd.get(2));
                    }
                    if (i == 3) {
                        dto.setShopdetcatcd((String)get_class_cd.get(3));
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShopCatInfDto getShopCateInf(String catno, String shopcd) throws Exception {
        ShopCatInfDto dto = new ShopCatInfDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SHOPLAGCATCD,'') AS SHOPLAGCATCD, \t\t  ifnull(SHOPMIDCATCD,'') AS SHOPMIDCATCD, \t\t  ifnull(SHOPSMLCATCD,'') AS SHOPSMLCATCD,\t\t  ifnull(SHOPDETCATCD,'') AS SHOPDETCATCD, \t\t  ifnull(SHOPCATSITENM,'') AS SHOPCATSITENM   from shopcatinf  WHERE compno = ?    and shopcatno = ?    and shopcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, catno);
                pstmt.setString(3, shopcd);
                YDMAStringUtil.Print("[ProductIforDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setShoplagcatcd(rs.getString("SHOPLAGCATCD"));
                    dto.setShopmidcatcd(rs.getString("SHOPMIDCATCD"));
                    dto.setShopsmlcatcd(rs.getString("SHOPSMLCATCD"));
                    dto.setShopdetcatcd(rs.getString("SHOPDETCATCD"));
                    dto.setShopcatsitenm(rs.getString("SHOPCATSITENM"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShoppingMallDetailDto> getShoppingMallDetail(String shopcd, String shopseq) throws Exception {
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("(SELECT shopnm FROM shopinfo AS b WHERE shopdtl.shopcd=b.shopcd) AS shopnam, \r\n");
                sql.append("IFNULL(SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtl ");
                sql.append(" WHERE COMPNO =?  AND SHOPCD= ? AND SHOPSEQ = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopseq);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopnm(rs.getString("SHOPNAM"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int setProductStatusIn(ShopProductDto dto, int status2) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodin set SHOPSENDSTATUS = ?  where compno = ?    and SENDSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setInt(++i, status2);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getSendseq());
                result = pstmt.executeUpdate();
                YDMAStringUtil.Print("[setShopOrderMstChange]" + pstmt.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setProductStatusInWithinfo(ShopProductDto dto, int status2) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodin set SHOPSENDSTATUS = ?  where compno = ?    and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setInt(++i, status2);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getProdseq());
                result = pstmt.executeUpdate();
                YDMAStringUtil.Print("[setProductStatusInWithinfo]" + pstmt.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setProductStatusInfo(ShopProductDto dto, int status2) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo set SHOPSENDSTATUS = ?  where compno = ?    and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setInt(++i, status2);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getProdseq());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getOrderExcel1(ShopProductDto dto) throws Exception {
        String domain = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ORDEREXCEL1 AS ORDEREXCEL1 FROM shopdtl where COMPNO = ? and SHOPCD = ? and SHOPSEQ = ? ";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dto.getShopcd());
                pstmt.setString(3, dto.getShopseq());
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    domain = rs.getString("ORDEREXCEL1");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return domain;
    }

    public ShoppingMallDetailDto getShopDtlOneId(String shopcd) throws Exception {
        ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtl  ");
                sql.append(" WHERE COMPNO =?  AND SHOPCD= ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShoppingMallDetailDto getShopDtlOneIdWithDome(String shopcd) throws Exception {
        ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(a.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(a.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(a.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(a.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(a.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(a.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(a.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(a.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(a.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(a.SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtldome AS a ");
                sql.append(" join shopinfodome AS b on a.shopcd = b.shopcd ");
                sql.append(" WHERE COMPNO =?  AND a.SHOPCD= ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public List<ShoppingMallDetailDto> getShopDtlListWithDome(String shopcd) throws Exception {
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(a.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(a.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(a.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(a.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(a.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(a.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(a.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(a.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(a.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(a.SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtldome AS a ");
                sql.append(" join shopinfodome AS b on a.shopcd = b.shopcd ");
                sql.append(" WHERE COMPNO =?  AND a.SHOPCD= ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public ShoppingMallDetailDto getShopDtlIdWithDome(String shopcd, String shopseq) throws Exception {
        ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(a.COMPNO, '') AS COMPNO, \r\n");
                sql.append("IFNULL(a.SHOPCD,'')  AS SHOPCD, \r\n");
                sql.append("IFNULL(a.SHOPPINGID,'') AS SHOPPINGID, \r\n ");
                sql.append("IFNULL(b.SHOPNM,'')  AS SHOPNM, \r\n");
                sql.append("IFNULL(a.APIKEY,'') AS APIKEY, \r\n");
                sql.append("IFNULL(a.DEALTREAD,'') AS DEALTREAD, \r\n");
                sql.append("IFNULL(a.PASSWORD, '') AS PASSWORD , \r\n");
                sql.append("IFNULL(a.AUTHKEY1, '') AS AUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.AUTHKEY2, '') AS AUTHKEY2 ,   \r\n");
                sql.append("IFNULL(a.EDITAUTHKEY1, '') AS EDITAUTHKEY1  ,   \r\n");
                sql.append("IFNULL(a.EDITAPIKEY, '') AS EDITAPIKEY ,   \r\n");
                sql.append("IFNULL(a.NICKNM2, '') AS VENDORID ,      \r\n");
                sql.append("IFNULL(a.SHOPSEQ, '') AS SHOPSEQ      \r\n");
                sql.append(" FROM shopdtldome AS a ");
                sql.append(" join shopinfodome AS b on a.shopcd = b.shopcd ");
                sql.append(" WHERE COMPNO =?  AND a.SHOPCD= ? and \tshopseq = ?  \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopseq);
                YDMAStringUtil.Print("[ShoppingMallDetailDto]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setCompno(rs.getString("COMPNO"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShoppingid(rs.getString("SHOPPINGID"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setApikey(rs.getString("APIKEY"));
                    dto.setDealtread(rs.getString("DEALTREAD"));
                    dto.setPassword(rs.getString("PASSWORD"));
                    dto.setAuthkey1(rs.getString("AUTHKEY1"));
                    dto.setAuthkey2(rs.getString("AUTHKEY2"));
                    dto.setVendorId(rs.getString("VENDORID"));
                    dto.setShopseq(rs.getString("SHOPSEQ"));
                    dto.setEditauthkey1(rs.getString("EDITAUTHKEY1"));
                    dto.setEditapikey(rs.getString("EDITAPIKEY"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public ShoppingMallDetailDto getShopDtlRegCount(String shopcd, String shopseq) throws Exception {
        ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(REGCNT, '0') AS REGCNT, \r\n");
                sql.append("IFNULL(EXCESSYN,'N')  AS EXCESSYN, \r\n");
                sql.append("IFNULL(EXCESSCNT,'0') AS EXCESSCNT \r\n ");
                sql.append(" FROM shopdtl  ");
                sql.append(" WHERE COMPNO =?  AND SHOPCD= ? AND SHOPSEQ = ? \r\n");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopseq);
                YDMAStringUtil.Print("[getShopDtlRegCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    dto.setRegcnt(rs.getString("REGCNT"));
                    dto.setExcessyn(rs.getString("EXCESSYN"));
                    dto.setExcesscnt(rs.getString("EXCESSCNT"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return dto;
    }

    public String getCategorySetting(String json, String shopcd, String categoryJson) throws Exception {
        String retJson;
        block5: {
            retJson = "";
            if (!json.equals("")) break block5;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(json, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                if (item.getShopcd().equals(shopcd)) {
                    item.setCid(categoryJson);
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public String getCategoryShopSetting(String json, String shopcd, String cid) throws Exception {
        String retJson;
        block5: {
            retJson = "";
            if (!json.equals("")) break block5;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(json, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                if (item.getShopcd().equals(shopcd)) {
                    item.setCid(cid);
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public String getCategoryDomeSetting(String json, String shopcd, String cid) throws Exception {
        String retJson;
        block5: {
            retJson = "";
            if (!json.equals("")) break block5;
            return null;
        }
        try {
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.DomeCateItem[] shopcateItem = (ShopProductDao.DomeCateItem[])mapper.readValue(json, ShopProductDao.DomeCateItem[].class);
            ShopProductDao.DomeCateItem cateitem = Arrays.asList(shopcateItem).stream().filter(d -> d.getShopcd().equals(shopcd)).findAny().orElse(null);
            ArrayList<ShopProductDao.DomeCateItem> shopcateItems = new ArrayList<ShopProductDao.DomeCateItem>(Arrays.asList(shopcateItem));
            if (cateitem == null) {
                cateitem = new ShopProductDao.DomeCateItem();
                cateitem.setShopcd(shopcd);
                cateitem.setCid(new ArrayList<String>());
                shopcateItems.add(cateitem);
            }
            for (ShopProductDao.DomeCateItem item : shopcateItems) {
                String categ;
                if (!item.getShopcd().equals(shopcd) || (categ = (String)item.getCid().stream().filter(d -> d.equals(cid)).findAny().orElse(null)) != null) continue;
                item.getCid().add(cid);
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public String getEsmCategorySetting(String json, String shopcd, String categoryJson, String EsmCate) throws Exception {
        String retJson;
        block10: {
            retJson = "";
            if (!json.equals("")) break block10;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(json, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                if (item.getShopcd().equals("shop0068") && shopcd.equals("shop00681")) {
                    item.setCid(categoryJson);
                }
                if (item.getShopcd().equals(shopcd)) {
                    if (shopcd.equals("shop00671")) {
                        item.setEsm_auction(EsmCate);
                        item.setCid(categoryJson);
                    } else if (shopcd.equals("shop00681")) {
                        item.setEsm_gmarket(EsmCate);
                        item.setCid(categoryJson);
                    } else {
                        item.setCid(categoryJson);
                    }
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public void setDomeCategInsertDelete(List<ShopCategoryDto> resultList) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "DELETE FROM domecateg WHERE SHOPCD=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, resultList.get(0).getShopcd());
                pstmt.executeUpdate();
                String sql1 = "INSERT INTO domecateg (SHOPCD, LEVEL, CODE, UPCODE, NAME, FULLCAT)\tVALUES (?, ?, ?, ?, ?, ?)";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopCategoryDto dto : resultList) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getShopcd());
                    pstmt1.setString(++idx, dto.getLevel());
                    pstmt1.setString(++idx, dto.getCode());
                    pstmt1.setString(++idx, dto.getUpcode());
                    pstmt1.setString(++idx, dto.getName());
                    pstmt1.setString(++idx, dto.getFullcat());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setDomeCategInsertDelete]" + pstmt.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<String> getCategoryMapList(String es) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT IFNULL(DOMECATG, '') AS DOMECATG, \r\n");
                sql.append("IFNULL(SHOPCATE,'')  AS SHOPCATE \r\n");
                sql.append(" FROM category  ");
                sql.append(" WHERE ID =? ");
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, es);
                YDMAStringUtil.Print("[getShopDtlRegCount]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    list.add(rs.getString("DOMECATG"));
                    list.add(rs.getString("SHOPCATE"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<ShopCateDto.CategoryMapLevelList> getCategoryMapLevelList() throws Exception {
        ArrayList<ShopCateDto.CategoryMapLevelList> list;
        block6: {
            list = new ArrayList<ShopCateDto.CategoryMapLevelList>();
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuffer sql = new StringBuffer();
                    sql.append("SELECT ID, NAME, PARENT_CODE FROM category \r\n");
                    pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                    YDMAStringUtil.Print("[getCategoryMapLevelList]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        ShopCateDto.CategoryMapLevelList dto = new ShopCateDto.CategoryMapLevelList();
                        dto.setId(rs.getString("ID"));
                        dto.setName(rs.getString("NAME"));
                        dto.setPid(rs.getString("PARENT_CODE"));
                        list.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return list;
    }

    public void setNewCategoryMapUpdate(String es, String shopcate_json, String domecate_json) throws Exception {
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE category set DOMECATG = ?, SHOPCATE = ? where ID = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, domecate_json);
                pstmt.setString(++i, shopcate_json);
                pstmt.setString(++i, es);
                pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public List<String> getShopGroup(ShopProductDto dto) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SHOPSEQ FROM shopdtl where compno = ? and SHOPCD = ? and SHOPGRP = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dto.getShopcd());
                pstmt.setString(3, dto.getShopgrp());
                YDMAStringUtil.Print("[getShopGroup]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public static String getShopId(String shopCd, int shopseq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String shopId = "";
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT  \r\n");
                sql.append("      IFNULL(SHOPPINGID, '') AS SHOPPINGID  \r\n");
                sql.append("  FROM shopdtl  \r\n");
                sql.append(" WHERE SHOPCD = ?  \r\n");
                sql.append("   AND SHOPSEQ = ?  \r\n");
                pstmt = connection.prepareStatement(sql.toString());
                pstmt.setString(1, shopCd);
                pstmt.setInt(2, shopseq);
                YDMAStringUtil.Print("[getShopIdn]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowIdx = 0;
                    shopId = rs.getString(++rowIdx);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return shopId;
    }

    public List<String> getShopGroupWithShopseq(String shopcd, String shopseq) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT shopseq \r\n  FROM shopdtl \r\n WHERE compno=? \r\n   AND SHOPCD=? \r\n   AND shopgrp=(SELECT ifnull(shopgrp,'') FROM shopdtl WHERE compno=? AND SHOPCD=? AND SHOPSEQ = ?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(4, shopcd);
                pstmt.setString(5, shopseq);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public ShopCateDto getCategoryAPI(String es) throws IOException {
        String url = String.format("http://api.kdjsystem.com:8080/api/v1/getCategoryMap?esCid=%s", es);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(url).method("GET", null).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string();
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ShopCateDto category = (ShopCateDto)mapper.readValue(data2, ShopCateDto.class);
        return category;
    }

    public String getCategoryShopApiSetting(String shopJson, ProductItemDto dto) throws Exception {
        String retJson;
        block78: {
            retJson = "";
            if (shopJson != null && !shopJson.equals("")) break block78;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(shopJson, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                switch (item.getShopcd()) {
                    case "shop0067": 
                    case "shop00671": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_auction());
                        } else {
                            dto.setEs_auction(item.getCid());
                        }
                        if (item.getEsm_auction().equals("")) {
                            item.setEsm_auction(dto.getEsm_auction());
                            break;
                        }
                        dto.setEsm_auction(item.getEsm_auction());
                        break;
                    }
                    case "shop0068": 
                    case "shop00681": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_gmarket());
                        } else {
                            dto.setEs_gmarket(item.getCid());
                        }
                        if (item.getEsm_gmarket().equals("")) {
                            item.setEsm_gmarket(dto.getEsm_gmarket());
                            break;
                        }
                        dto.setEsm_gmarket(item.getEsm_gmarket());
                        break;
                    }
                    case "shop0004": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_interpark());
                            break;
                        }
                        dto.setEs_interpark(item.getCid());
                        break;
                    }
                    case "shop0055": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_storefarm());
                            break;
                        }
                        dto.setEs_storefarm(item.getCid());
                        break;
                    }
                    case "shop0003": 
                    case "shop00031": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_11st());
                            break;
                        }
                        dto.setEs_11st(item.getCid());
                        break;
                    }
                    case "shop0075": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_coupang());
                            break;
                        }
                        dto.setEs_coupang(item.getCid());
                        break;
                    }
                    case "shop0411": {
                        if (item.getCid().equals("")) {
                            item.setCid(String.valueOf(dto.getEs_ssg()));
                            break;
                        }
                        dto.setEs_ssg(String.valueOf(item.getCid()));
                        break;
                    }
                    case "shop0287": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_wemarket());
                            break;
                        }
                        dto.setEs_wemarket(item.getCid());
                        break;
                    }
                    case "shop0076": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_tmon());
                            break;
                        }
                        dto.setEs_tmon(item.getCid());
                        break;
                    }
                    case "shop0273": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_kakao());
                            break;
                        }
                        dto.setEs_kakao(item.getCid());
                        break;
                    }
                    case "shop0372": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_lotteon());
                            break;
                        }
                        dto.setEs_lotteon(item.getCid());
                        break;
                    }
                    case "shop0106": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_melchi());
                            break;
                        }
                        dto.setEs_melchi(item.getCid());
                        break;
                    }
                    case "shop0211": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_godomall());
                            break;
                        }
                        dto.setEs_godomall(item.getCid());
                        break;
                    }
                    case "shop9982": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_tossShopping());
                            break;
                        }
                        dto.setEs_tossShopping(item.getCid());
                        break;
                    }
                    case "shop9984": {
                        if (item.getCid().equals("")) {
                            item.setCid(dto.getEs_alwayz());
                            break;
                        }
                        dto.setEs_alwayz(item.getCid());
                    }
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public String getCategoryShopApiSetting2(String shopJson, ProductItemDto dto) throws Exception {
        String retJson;
        block59: {
            retJson = "";
            if (shopJson != null && !shopJson.equals("")) break block59;
            return null;
        }
        try {
            ShopProductDao.ShopCateItem[] shopcateItem;
            ObjectMapper mapper = new ObjectMapper();
            ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(shopJson, ShopProductDao.ShopCateItem[].class);
            int n = shopcateItem.length;
            int n2 = 0;
            while (n2 < n) {
                ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
                switch (item.getShopcd()) {
                    case "shop0067": 
                    case "shop00671": {
                        dto.setEs_auction(item.getCid());
                        dto.setEsm_auction(item.getEsm_auction());
                        break;
                    }
                    case "shop0068": 
                    case "shop00681": {
                        dto.setEs_gmarket(item.getCid());
                        dto.setEsm_gmarket(item.getEsm_gmarket());
                        break;
                    }
                    case "shop0004": {
                        dto.setEs_interpark(item.getCid());
                        break;
                    }
                    case "shop0055": {
                        dto.setEs_storefarm(item.getCid());
                        break;
                    }
                    case "shop0003": 
                    case "shop00031": {
                        dto.setEs_11st(item.getCid());
                        break;
                    }
                    case "shop0075": {
                        dto.setEs_coupang(item.getCid());
                        break;
                    }
                    case "shop0411": {
                        dto.setEs_ssg(String.valueOf(item.getCid()));
                        break;
                    }
                    case "shop0287": {
                        dto.setEs_wemarket(item.getCid());
                        break;
                    }
                    case "shop0076": {
                        dto.setEs_tmon(item.getCid());
                        break;
                    }
                    case "shop0273": {
                        dto.setEs_kakao(item.getCid());
                        break;
                    }
                    case "shop0372": {
                        dto.setEs_lotteon(item.getCid());
                        break;
                    }
                    case "shop0106": {
                        dto.setEs_melchi(item.getCid());
                        break;
                    }
                    case "shop0211": {
                        dto.setEs_godomall(item.getCid());
                        break;
                    }
                    case "shop9982": {
                        dto.setEs_tossShopping(item.getCid());
                        break;
                    }
                    case "shop9984": {
                        dto.setEs_alwayz(item.getCid());
                    }
                }
                ++n2;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            retJson = mapper.writeValueAsString((Object)shopcateItem);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ubcc0\ud658\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.\n" + e.getMessage());
        }
        return retJson;
    }

    public int setCategoryMapUpdateApi(String es, String shopcate_json, String domecate_json) throws IOException {
        String url = String.format("http://api.kdjsystem.com:8080/api/v1/updateCategoryMap", new Object[0]);
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("id", es);
        jsonObject.addProperty("domecatg", domecate_json);
        jsonObject.addProperty("shopcate", shopcate_json);
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)jsonObject.toString());
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/json").build();
        String data2 = "";
        Throwable throwable = null;
        Object var12_13 = null;
        try (Response response = client.newCall(request2).execute();){
            data2 = response.body().string();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JsonParser parser = new JsonParser();
        JsonObject obj = (JsonObject)parser.parse(data2);
        return obj.get("returnCode").getAsInt();
    }

    public ShopCateDto getCategoryMapAPI(int idx) throws IOException {
        String url = String.format("http://api.kdjsystem.com:8080/api/v1/searchCategoryMap?page=%s", idx);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(url).method("GET", null).addHeader("Content-Type", "application/json").build();
        String data2 = "";
        Throwable throwable = null;
        Object var7_8 = null;
        try (Response response = client.newCall(request2).execute();){
            data2 = response.body().string();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ShopCateDto category = (ShopCateDto)mapper.readValue(data2, ShopCateDto.class);
        return category;
    }

    public int setShopCategorysDelete(String shopcd) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopcategorys where shopcd=? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, shopcd);
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public void setShopCategorysInsertNUpdate(List<ShopCateDto.MallCategoryList> list, String shopcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO shopcategorys (SHOPCD, CODE, SHOPCATENM, ESMCODE, ESMSHOPCATENM) VALUES (?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE SHOPCATENM = ?, ESMCODE = ?, ESMSHOPCATENM = ?";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopCateDto.MallCategoryList dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getShopcd());
                    pstmt1.setString(++idx, dto.getCode());
                    pstmt1.setString(++idx, dto.getShopcatenm());
                    pstmt1.setString(++idx, dto.getEsmcode());
                    pstmt1.setString(++idx, dto.getEsmshopcatenm());
                    pstmt1.setString(++idx, dto.getShopcatenm());
                    pstmt1.setString(++idx, dto.getEsmcode());
                    pstmt1.setString(++idx, dto.getEsmshopcatenm());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setShopCategorysInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setCategoryMapInsertNUpdate(List<ShopCateDto.CategoryMapList> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO category\r\n\t(ID, NAME, PARENT_CODE, FULL_NAME, `LEVEL`, SHOPCATE, DOMECATG)\r\n\tVALUES (?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE \r\nNAME=?, PARENT_CODE=?, FULL_NAME=?, LEVEL=?, SHOPCATE=?, DOMECATG=?";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopCateDto.CategoryMapList dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getId());
                    if (dto.getId().equals("120508000")) {
                        // empty if block
                    }
                    pstmt1.setString(++idx, dto.getName());
                    pstmt1.setString(++idx, dto.getParent_code());
                    pstmt1.setString(++idx, dto.getFull_name());
                    pstmt1.setString(++idx, dto.getLevel());
                    pstmt1.setString(++idx, dto.getShopcate());
                    pstmt1.setString(++idx, dto.getDomecatg());
                    pstmt1.setString(++idx, dto.getName());
                    pstmt1.setString(++idx, dto.getParent_code());
                    pstmt1.setString(++idx, dto.getFull_name());
                    pstmt1.setString(++idx, dto.getLevel());
                    pstmt1.setString(++idx, dto.getShopcate());
                    pstmt1.setString(++idx, dto.getDomecatg());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setCategoryMapInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProdAttrInsertNUpdate(List<ShopProdAttrnmDto.ProdAttrList> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO prodattr\r\n\t(ATTRCD, ATTRNM, FLAGDEFT, LOTTECD, NAVERCD, DOSINCD, TMONCD, KAKAOCD, MELCHICD)\r\n\tVALUES (?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE \r\nATTRNM=?, FLAGDEFT=?, LOTTECD=?, NAVERCD=?, DOSINCD=?, TMONCD=?, KAKAOCD=?, MELCHICD=? ";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopProdAttrnmDto.ProdAttrList dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getAttrcd());
                    pstmt1.setString(++idx, dto.getAttrnm());
                    pstmt1.setString(++idx, dto.getFlagdeft());
                    pstmt1.setString(++idx, dto.getLottecd());
                    pstmt1.setString(++idx, dto.getNavercd());
                    pstmt1.setString(++idx, dto.getDosincd());
                    pstmt1.setString(++idx, dto.getTmoncd());
                    pstmt1.setString(++idx, dto.getKakaocd());
                    pstmt1.setString(++idx, dto.getMelchicd());
                    pstmt1.setString(++idx, dto.getAttrnm());
                    pstmt1.setString(++idx, dto.getFlagdeft());
                    pstmt1.setString(++idx, dto.getLottecd());
                    pstmt1.setString(++idx, dto.getNavercd());
                    pstmt1.setString(++idx, dto.getDosincd());
                    pstmt1.setString(++idx, dto.getTmoncd());
                    pstmt1.setString(++idx, dto.getKakaocd());
                    pstmt1.setString(++idx, dto.getMelchicd());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setProdAttrInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setProdAttrNMInsertNUpdate(List<ShopProdAttrnmDto.ProdAttrNMList> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO prodattrnm\r\n\t(ATTRCD, COLSEQ, ATTRNM, FUNNSEQ, WTRADINGSEQ, TOBIZONSEQ, DOMEGGOOKSEQ, OWNERCLANSEQ, HUBSELLSEQ, DOSINSEQ, NOTICETYPE, ITEMCODE, INTERCODE, \t INTERAPICODE, INTERAPITYPE)\r\n\tVALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ON DUPLICATE KEY UPDATE \r\nATTRNM=?, FUNNSEQ=?, WTRADINGSEQ=?, TOBIZONSEQ=?, DOMEGGOOKSEQ=?, OWNERCLANSEQ=?, HUBSELLSEQ=?, DOSINSEQ=?, NOTICETYPE=?, ITEMCODE=?, INTERCODE=?, INTERAPICODE=?, INTERAPITYPE=?";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopProdAttrnmDto.ProdAttrNMList dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getAttrcd());
                    pstmt1.setString(++idx, dto.getColseq());
                    pstmt1.setString(++idx, dto.getAttrnm());
                    pstmt1.setString(++idx, dto.getFunnseq());
                    pstmt1.setString(++idx, dto.getWtradingseq());
                    pstmt1.setString(++idx, dto.getTobizonseq());
                    pstmt1.setString(++idx, dto.getDomeggookseq());
                    pstmt1.setString(++idx, dto.getOwnerclanseq());
                    pstmt1.setString(++idx, dto.getHubsellseq());
                    pstmt1.setString(++idx, dto.getDosinseq());
                    pstmt1.setString(++idx, dto.getNoticetype());
                    pstmt1.setString(++idx, dto.getItemcode());
                    pstmt1.setString(++idx, dto.getIntercode());
                    pstmt1.setString(++idx, dto.getInterapicode());
                    pstmt1.setString(++idx, dto.getInterapitype());
                    pstmt1.setString(++idx, dto.getAttrnm());
                    pstmt1.setString(++idx, dto.getFunnseq());
                    pstmt1.setString(++idx, dto.getWtradingseq());
                    pstmt1.setString(++idx, dto.getTobizonseq());
                    pstmt1.setString(++idx, dto.getDomeggookseq());
                    pstmt1.setString(++idx, dto.getOwnerclanseq());
                    pstmt1.setString(++idx, dto.getHubsellseq());
                    pstmt1.setString(++idx, dto.getDosinseq());
                    pstmt1.setString(++idx, dto.getNoticetype());
                    pstmt1.setString(++idx, dto.getItemcode());
                    pstmt1.setString(++idx, dto.getIntercode());
                    pstmt1.setString(++idx, dto.getInterapicode());
                    pstmt1.setString(++idx, dto.getInterapitype());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setProdAttrNMInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setShopAttrInfoInsertNUpdate(List<ShopProdAttrnmDto.ShopAttrInfoInf> list) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO shopattrinfo (SHOPCD, GOSICODE, GOSINUM, GOSIVAL)\r\n\tVALUES (?,?,?,?) ON DUPLICATE KEY UPDATE GOSIVAL=?";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopProdAttrnmDto.ShopAttrInfoInf dto : list) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getShopcd());
                    pstmt1.setString(++idx, dto.getGosicode());
                    pstmt1.setString(++idx, dto.getGosinum());
                    pstmt1.setString(++idx, dto.getGosival());
                    pstmt1.setString(++idx, dto.getGosival());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                YDMAStringUtil.Print("[setShopAttrInfoInsertNUpdate]" + pstmt1.toString());
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public String getCateDomeJson(ProductItemDto item) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        List<String> shopList = DomesinSessonUtil.ManagerDome;
        ArrayList<ShopProductDao.DomeCateItem> cate_list = new ArrayList<ShopProductDao.DomeCateItem>();
        for (String shopcd : shopList) {
            ShopProductDao.DomeCateItem cateItem = new ShopProductDao.DomeCateItem();
            cateItem.shopcd = shopcd;
            cateItem.cid = new ArrayList<String>();
            cate_list.add(cateItem);
        }
        String json = mapper.writeValueAsString(cate_list);
        return json;
    }

    public String getEsCode(String class_cd3) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT `GET_COUPANG_ESCODE`(?);";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, class_cd3);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getEsCodeNaver(String class_cd3) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT `GET_NAVER_ESCODE`(?);";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, class_cd3);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getEsCodeAllShop(String shopcd, String val, String json) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT `GET_ALL_ESCODE`(?,?,?);";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, val);
                pstmt.setString(3, json);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void saveCat_imsi_tot(String id, String shopcode, String code) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into cat_imsi_tot values(?,?,?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, id);
                pstmt.setString(2, shopcode);
                pstmt.setString(3, code);
                pstmt.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void getSyncCategory(ProductItemDto newInfoDto, ShopProductDto sync) throws Exception {
        ShopProductDao.ShopCateItem[] shopcateItem;
        ObjectMapper mapper = new ObjectMapper();
        ShopProductDao.ShopCateItem[] shopCateItemArray = shopcateItem = (ShopProductDao.ShopCateItem[])mapper.readValue(sync.getShop_cid_info(), ShopProductDao.ShopCateItem[].class);
        int n = shopcateItem.length;
        int n2 = 0;
        while (n2 < n) {
            ShopProductDao.ShopCateItem item = shopCateItemArray[n2];
            switch (item.getShopcd()) {
                case "shop0067": 
                case "shop00671": {
                    newInfoDto.setEs_auction(String.valueOf(item.getCid()));
                    newInfoDto.setEsm_auction(String.valueOf(item.getEsm_auction()));
                    break;
                }
                case "shop0068": 
                case "shop00681": {
                    newInfoDto.setEs_gmarket(String.valueOf(item.getCid()));
                    newInfoDto.setEsm_gmarket(String.valueOf(item.getEsm_gmarket()));
                    break;
                }
                case "shop0004": {
                    newInfoDto.setEs_interpark(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0055": {
                    newInfoDto.setEs_storefarm(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0003": 
                case "shop00031": {
                    newInfoDto.setEs_11st(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0075": {
                    newInfoDto.setEs_coupang(String.valueOf(sync.getCid()));
                    break;
                }
                case "shop0110": {
                    item.setCid("");
                    break;
                }
                case "shop0287": {
                    newInfoDto.setEs_wemarket(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0076": {
                    newInfoDto.setEs_tmon(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0273": {
                    newInfoDto.setEs_kakao(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0411": {
                    newInfoDto.setEs_ssg(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0372": {
                    newInfoDto.setEs_lotteon(String.valueOf(item.getCid()));
                    break;
                }
                case "shop0106": {
                    newInfoDto.setEs_melchi(String.valueOf(item.getCid()));
                }
            }
            ++n2;
        }
    }

    public void setCategorySave(List<ShopCategoryDto> dtolist) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt1 = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ArrayList<PreparedStatement> statementlist1 = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql1 = "INSERT INTO shopcategorys (SHOPCD, CODE, SHOPCATENM) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE SHOPCATENM = ? ";
                sql1 = sql1.toUpperCase();
                pstmt1 = connection.prepareStatement(sql1);
                statementlist1.add(pstmt1);
                for (ShopCategoryDto dto : dtolist) {
                    int idx = 0;
                    pstmt1.setString(++idx, dto.getShopcd());
                    pstmt1.setString(++idx, dto.getCatlrgcd());
                    pstmt1.setString(++idx, dto.getCatlrgnm());
                    pstmt1.setString(++idx, dto.getCatlrgnm());
                    pstmt1.addBatch();
                    pstmt1.clearParameters();
                }
                pstmt1.executeBatch();
                pstmt1.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public String getCategoryMatch(String class_nm1, String shopcd) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(CODE,'') FROM shopcategorys WHERE shopcd = ? and MATCH(SHOPCATENM) AGAINST(? IN boolean MODE) LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, class_nm1);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getCategoryMatchCode(String shopcd, String num) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SHOPCATENM,'') FROM shopcategorys WHERE shopcd = ? and code = ? LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, num);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public String getCategoryMatchName(String class_nm1, String shopcd) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(SHOPCATENM,'') FROM shopcategorys WHERE shopcd = ? and MATCH(SHOPCATENM) AGAINST(? IN boolean MODE) LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, shopcd);
                pstmt.setString(2, class_nm1);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setInfoDelvCost(List<ShopProductDto> dto1) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo set DELV_COST = ?,RETURN_DELV_COST = ?   where compno = ?  and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (ShopProductDto dto : dto1) {
                    int i = 0;
                    pstmt.setString(++i, dto.getDelv_cost());
                    pstmt.setString(++i, dto.getDelv_r_cost());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, dto.getProdseq());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setInfoCategoryCD(ShopProductDto dto) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo set class_cd3 = ?, shop_cid_info = ?, status = ?, goods_price = ?, goods_search = ?     where compno = ?  and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, dto.getClass_cd3());
                pstmt.setString(++i, dto.getShop_cid_info());
                pstmt.setString(++i, dto.getStatus());
                pstmt.setString(++i, dto.getGoods_price());
                pstmt.setString(++i, dto.getGoods_search());
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getProdseq());
                pstmt.execute();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setGoods_Name(ShopProductDto dto) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodinfo set GOODS_NM = ? ,STATUS = ?  where compno = ?  and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, dto.getGoods_nm());
                pstmt.setString(++i, dto.getStatus());
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getProdseq());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setGoods_NameIn(ShopProductDto dto) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update shopprodin set GOODS_NM = ? ,STATUS = ?  where compno = ?  and PRODSEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, dto.getGoods_nm());
                pstmt.setString(++i, dto.getStatus());
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, dto.getProdseq());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setShopCookiesUpdate(String shopcd, String shopid, String key, String cookie, String authkey) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE shopdtl AS a \r\n";
                sql = shopcd.equals("shop0273") ? String.valueOf(sql) + " INNER JOIN (SELECT MIN(SHOPSEQ) AS shopseq FROM shopdtl WHERE compno= ? AND SHOPCD= ? AND SHOPPINGID= ?  AND AUTHKEY1= ? ) AS b\r\n" : (shopcd.equals("shop0055") ? String.valueOf(sql) + " INNER JOIN (SELECT MIN(SHOPSEQ) AS shopseq FROM shopdtl WHERE compno= ? AND SHOPCD= ? AND SHOPPINGID= ?  AND APIKEY LIKE ? ) AS b\r\n" : String.valueOf(sql) + " INNER JOIN (SELECT MIN(SHOPSEQ) AS shopseq FROM shopdtl WHERE compno= ? AND SHOPCD= ? AND SHOPPINGID= ?  ) AS b\r\n");
                sql = String.valueOf(sql) + " \t\t ON a.SHOPSEQ=b.SHOPSEQ \r\n\tSET a.COOKIEKEY= ? , a.COOKIES= ? \r\n WHERE compno= ?  \r\n   AND SHOPCD= ? \r\n\tAND SHOPPINGID= ? ";
                if (shopcd.equals("shop0273")) {
                    sql = String.valueOf(sql) + "   AND AUTHKEY1= ? ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, shopid);
                if (shopcd.equals("shop0273")) {
                    pstmt.setString(++i, authkey);
                } else if (shopcd.equals("shop0055")) {
                    pstmt.setString(++i, String.valueOf(authkey) + "%");
                }
                pstmt.setString(++i, key);
                pstmt.setString(++i, cookie);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, shopid);
                if (shopcd.equals("shop0273")) {
                    pstmt.setString(++i, authkey);
                }
                YDMAStringUtil.Print("[setShopCookiesUpdate]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int setDomeCookiesUpdate(String shopcd, String shopid, String key, String cookie) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE shopdtldome AS a \r\n INNER JOIN (SELECT MIN(SHOPSEQ) AS shopseq FROM shopdtldome WHERE compno= ? AND SHOPCD= ? AND SHOPPINGID= ? ) AS b\r\n \t\t ON a.SHOPSEQ=b.SHOPSEQ \r\n\tSET a.COOKIEKEY= ? , a.COOKIES= ? \r\n WHERE compno= ?  \r\n   AND SHOPCD= ? \r\n\tAND SHOPPINGID= ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, shopid);
                pstmt.setString(++i, key);
                pstmt.setString(++i, cookie);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++i, shopcd);
                pstmt.setString(++i, shopid);
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShoppingMallDetailDto> getShopCookies() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShoppingMallDetailDto> list = new ArrayList<ShoppingMallDetailDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT DISTINCT SHOPCD,SHOPPINGID,ifnull(COOKIEKEY,'') AS COOKIEKEY,ifnull(COOKIES,'') AS COOKIES\r\n  FROM shopdtl \r\n WHERE compno= ? \r\n   AND COOKIEKEY IS not null\r\n UNION ALL\r\nSELECT DISTINCT SHOPCD,SHOPPINGID,ifnull(COOKIEKEY,'') AS COOKIEKEY,ifnull(COOKIES,'') AS COOKIES\r\n  FROM shopdtldome \r\n WHERE compno= ? \r\n   AND COOKIEKEY IS not null";
                pstmt = connection.prepareStatement(sql.toUpperCase());
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ShoppingMallDetailDto dto = new ShoppingMallDetailDto();
                    dto.setCookiekey(rs.getString("COOKIEKEY"));
                    dto.setCookies(rs.getString("COOKIES"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public String getCategoryMatch(String class_nm1) throws Exception {
        String result = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(id,'') FROM category WHERE MATCH(FULL_NAME) AGAINST(? IN boolean MODE) LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, class_nm1);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopProdFolderDto> getShopProdFolders() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShopProdFolderDto> result = new ArrayList<ShopProdFolderDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COMPNO, FOLDER, COMPAYNY_GOODS_CD\r\n\tFROM shopprodfolders\r\n where compno=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ShopProdFolderDto dto = new ShopProdFolderDto();
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setFolder(rs.getString(++columnIndex));
                    dto.setCompany_goods_cd(rs.getString(++columnIndex));
                    result.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopProdFolderDto> getShopProdFoldersForGrid() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShopProdFolderDto> result = new ArrayList<ShopProdFolderDto>();
        LinkedHashMap<String, List> folderMap = new LinkedHashMap<String, List>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COMPNO, FOLDER, COMPAYNY_GOODS_CD\r\n\tFROM shopprodfolders\r\n where compno=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    String folder = rs.getString("FOLDER");
                    String goodsCd = rs.getString("COMPAYNY_GOODS_CD");
                    folderMap.computeIfAbsent(folder, k -> new ArrayList()).add(goodsCd);
                }
                for (Map.Entry entry : folderMap.entrySet()) {
                    ShopProdFolderDto dto = new ShopProdFolderDto();
                    dto.setFolder((String)entry.getKey());
                    dto.setCompany_goods_cd(String.join((CharSequence)", ", (Iterable)entry.getValue()));
                    result.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<ShopProdFolderDto> getShopprodfoldersByFolder(String folder) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<ShopProdFolderDto> result = new ArrayList<ShopProdFolderDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COMPNO, FOLDER, COMPAYNY_GOODS_CD\r\n\tFROM shopprodfolders\r\n where compno=?   and FOLDER=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, folder);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ShopProdFolderDto dto = new ShopProdFolderDto();
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setFolder(rs.getString(++columnIndex));
                    dto.setCompany_goods_cd(rs.getString(++columnIndex));
                    result.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int insertShopprodfoldersByFolder(String folder, String company_goods_cd) throws Exception {
        int result = 1;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into shopprodfolders (COMPNO, FOLDER, COMPAYNY_GOODS_CD)values (?, ?, ?)ON DUPLICATE KEY UPDATE COMPAYNY_GOODS_CD = VALUES(COMPAYNY_GOODS_CD);";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int idx = 0;
                pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(++idx, folder);
                pstmt.setString(++idx, company_goods_cd);
                YDMAStringUtil.Print("[insertShopprodfoldersByFolder]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int clearShopProdFolders() throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodfolders where compno=? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public List<NaverCateApiInfoDto> getNaverCateApiInfos() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<NaverCateApiInfoDto> result = new ArrayList<NaverCateApiInfoDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT COMPNO, CLIENTID, CLIENTSECRET\r\n\tFROM navercateapiinfo\r\n where compno=?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    NaverCateApiInfoDto dto = new NaverCateApiInfoDto();
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setClientID(rs.getString(++columnIndex));
                    dto.setClientSecret(rs.getString(++columnIndex));
                    result.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int insertNaverCateApiInfo(NaverCateApiInfoDto dto) throws Exception {
        int result = 1;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into navercateapiinfo values (?, ?, ?)";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int idx = 0;
                pstmt.setInt(++idx, Integer.parseInt(dto.getCompno()));
                pstmt.setString(++idx, dto.getClientID());
                pstmt.setString(++idx, dto.getClientSecret());
                YDMAStringUtil.Print("[insertNaverCateApiInfo]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int updateNaverCateApiInfo(String clientId, NaverCateApiInfoDto dto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE navercateapiinfo \r\n   SET CLIENTID =?, CLIENTSECRET = ? WHERE compno = ? AND CLIENTID = ?";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, dto.getClientID());
                pstmt.setString(2, dto.getClientSecret());
                pstmt.setInt(3, Integer.parseInt(dto.getCompno()));
                pstmt.setString(4, clientId);
                YDMAStringUtil.Print("[updateNaverCateApiInfo]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int clearNaverCateApiInfos() throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from navercateapiinfo where compno=? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int deleteNaverCateApiInfos(String clientId) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from navercateapiinfo where compno = ? and CLIENTID = ?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, clientId);
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int deleteShopProdFolders(List<String> folders) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodfolders where compno=? and FOLDER=?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (String folder : folders) {
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, folder);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int deleteShopProdFolders_folder(String folder) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodfolders where compno=? and FOLDER=?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, folder);
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int deleteShopProdFolders_company_goods_cd(String folder, String company_goods_cd) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from shopprodfolders where compno=? and FOLDER=? and COMPAYNY_GOODS_CD=?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, folder);
                pstmt.setString(3, company_goods_cd);
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int setNaverCateInfos(List<NaverCateApiInfoDto> list) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into navercateapiinfo values (?, ?, ?) ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (NaverCateApiInfoDto dto : list) {
                    int idx = 0;
                    pstmt.setString(++idx, dto.getCompno());
                    pstmt.setString(++idx, dto.getClientID());
                    pstmt.setString(++idx, dto.getClientSecret());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public CloudinaryApiInfoDto getEasyCloudInfo() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        CloudinaryApiInfoDto result = new CloudinaryApiInfoDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SEQ, COMPNO, CLOUDNAME, SUM(CAST(APIKEY AS SIGNED)) OVER () AS APIKEY, \r\n       CAST(APISECRET AS SIGNED) AS APISECRET, USE_LIMIT\r\n\tFROM cloudinaryapiinfo\r\n where compno=?\r\n   and use_yn = 'Y' ORDER BY CLOUDNAME, (CAST(USE_LIMIT AS SIGNED) - CAST(APISECRET AS SIGNED)) DESC LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, "0");
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result.setSeq(rs.getString(++columnIndex));
                    result.setCompno(rs.getString(++columnIndex));
                    result.setCloudname(rs.getString(++columnIndex));
                    result.setApikey(rs.getString(++columnIndex));
                    result.setApisecret(rs.getString(++columnIndex));
                    result.setUse_limit(rs.getInt(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void updateEasyCloudUsage(String seq, String cloudname, String newUsed) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE cloudinaryapiinfo \r\n").append("   SET APIKEY = CAST(APIKEY AS SIGNED) + ? \r\n").append(" WHERE SEQ = ? \r\n").append("   AND COMPNO = 0 \r\n").append("   AND CLOUDNAME = ? \r\n");
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{newUsed, seq, cloudname};
                YDMAStringUtil.Print("[Ftp \uc0ac\uc6a9\ub7c9 \uc5c5\ub370\uc774\ud2b8]" + sql.toString());
                runner.update(connection, sql.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateEasyCloudUsageApisecret(String seq, String cloudname, String newUsed, String use_yn) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE cloudinaryapiinfo \r\n").append("   SET APISECRET = ? \r\n").append("     , USE_YN = ? \r\n").append(" WHERE SEQ = ? \r\n").append("   AND COMPNO = 0 \r\n").append("   AND CLOUDNAME = ? \r\n");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{newUsed, use_yn, seq, cloudname};
                YDMAStringUtil.Print("[Ftp \uc0ac\uc6a9\ub7c9 \uc5c5\ub370\uc774\ud2b8]" + sql.toString());
                runner.update(connection, sql.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CloudinaryApiInfoDto getEasyCloudUsage() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        CloudinaryApiInfoDto result = new CloudinaryApiInfoDto();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SEQ, COMPNO, CLOUDNAME, APIKEY, APISECRET, USE_LIMIT\r\n\tFROM cloudinaryapiinfo\r\n where compno = 0 \r\n   and use_yn = 'Y' ORDER BY SEQ limit 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    result.setSeq(rs.getString(++columnIndex));
                    result.setCompno(rs.getString(++columnIndex));
                    result.setCloudname(rs.getString(++columnIndex));
                    result.setApikey(rs.getString(++columnIndex));
                    result.setApisecret(rs.getString(++columnIndex));
                    result.setUse_limit(rs.getInt(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<CloudinaryApiInfoDto> getEasyCloudUsage2() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<CloudinaryApiInfoDto> list = new ArrayList<CloudinaryApiInfoDto>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT SEQ, COMPNO, CLOUDNAME, APIKEY, APISECRET, USE_LIMIT\r\n\tFROM cloudinaryapiinfo\r\n where compno = 0 \r\n ORDER BY SEQ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    CloudinaryApiInfoDto dto = new CloudinaryApiInfoDto();
                    dto.setSeq(rs.getString(++columnIndex));
                    dto.setCompno(rs.getString(++columnIndex));
                    dto.setCloudname(rs.getString(++columnIndex));
                    dto.setApikey(rs.getString(++columnIndex));
                    dto.setApisecret(rs.getString(++columnIndex));
                    dto.setUse_limit(rs.getInt(++columnIndex));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    /*
     * Exception decompiling
     */
    public Optional<CloudinaryApiInfoDto> getCloudinaryApiInfo() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateCloudinaryApiInfoToDisabled(String seq, String compno, String cloudname, String use_yn) throws Exception {
        int rowsAffected;
        block14: {
            String sql = "UPDATE cloudinaryapiinfo SET use_yn = ? WHERE seq = ? AND compno  = ? AND cloudname = ? ";
            Throwable throwable = null;
            Object var8_8 = null;
            try {
                Connection conn = DBCPInit.getInstance().getConnection();
                try {
                    try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                        pstmt.setString(1, use_yn);
                        pstmt.setString(2, seq);
                        pstmt.setString(3, compno);
                        pstmt.setString(4, cloudname);
                        rowsAffected = pstmt.executeUpdate();
                        YDMAStringUtil.Print(String.format("cloudinaryapiinfo use_yn \uc5c5\ub370\uc774\ud2b8: seq=%s compno=%s cloudname=%s rowsAffected=%s", seq, compno, cloudname, rowsAffected));
                    }
                    if (conn == null) break block14;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        if (rowsAffected > 0) {
            if (this.hasAnyEnabledRecord(compno)) return;
            this.re_useCloudinary();
            return;
        }
        YDMAStringUtil.Print(String.format("\uc5c5\ub370\uc774\ud2b8 \ub300\uc0c1\uc774 \uc5c6\uac70\ub098 \uc774\ubbf8 N \uc0c1\ud0dc\uc785\ub2c8\ub2e4: seq=%s compno=%s cloudname=%s", seq, compno, cloudname));
    }

    /*
     * Exception decompiling
     */
    private boolean hasAnyEnabledRecord(String compno) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void re_useCloudinary() throws Exception {
        List<CloudinaryApiInfoDto> cloudinaryInfos = this.getListCloudinaryApiInfo();
        for (CloudinaryApiInfoDto dto : cloudinaryInfos) {
            CloudinaryUsageService againUse = new CloudinaryUsageService(dto.getCloudname(), dto.getApikey(), dto.getApisecret());
            double percent = againUse.getUsagePercentage().orElse(0.0);
            if (percent == -1.0 || !(percent < (double)dto.getUse_limit())) continue;
            String use_yn = "Y";
            this.updateCloudinaryApiInfo_Y(dto.getSeq(), dto.getCloudname(), use_yn);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean chk_useCloudinary() throws Exception {
        try {
            double percent;
            CloudinaryUploadService service = CloudinaryUploadService.getInstance();
            if (!service.isEnabled()) {
                YDMAStringUtil.Print("Cloudinary service disabled, attempting re-initialization...");
                CloudinaryUploadService.reloadConfig();
                service = CloudinaryUploadService.getInstance();
                if (!service.isEnabled()) {
                    YDMAStringUtil.Print("Re-initialization failed, Cloudinary remains disabled.");
                    return false;
                }
                YDMAStringUtil.Print("Cloudinary re-initialized successfully.");
            }
            if ((percent = service.getUsagePercentage().orElse(0.0).doubleValue()) == -1.0) {
                return false;
            }
            CloudinaryUploadService servicefinal = service;
            CompletableFuture.runAsync(() -> servicefinal.runSwitchedCleanupIfEnabled());
            Optional<CloudinaryApiInfoDto> dtoOpt = ShopCommonDao.get().getCloudinaryApiInfo();
            if (!dtoOpt.isPresent()) {
                CloudinaryUploadService.reloadConfig();
                service = CloudinaryUploadService.getInstance();
                if (!service.isEnabled()) {
                    YDMAStringUtil.Print("Re-initialization failed, Cloudinary remains disabled.");
                    return false;
                }
                return false;
            }
            CloudinaryApiInfoDto dto = dtoOpt.get();
            if (!(percent > (double)dto.getUse_limit())) {
                return true;
            }
            this.updateCloudinaryApiInfoToDisabled(dto.getSeq(), dto.getCompno(), dto.getCloudname(), "N");
            CloudinaryUploadService.reloadConfig();
            service = CloudinaryUploadService.getInstance();
            if (!service.isEnabled()) {
                YDMAStringUtil.Print("Re-initialization failed, Cloudinary remains disabled.");
                return false;
            }
            return false;
        }
        catch (Exception e) {
            YDMAStringUtil.Print("Cloudinary \uc0ac\uc6a9 \uc5ec\ubd80 \ud655\uc778 \uc911 \uc608\uc678 \ubc1c\uc0dd: " + e.getMessage());
            return false;
        }
    }

    public boolean isEnabled(CloudinaryApiInfoDto dto) {
        return dto != null && dto.getCloudname() != null && !dto.getCloudname().isEmpty() && dto.getApikey() != null && !dto.getApikey().isEmpty() && dto.getApisecret() != null && !dto.getApisecret().isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateCloudinaryApiInfo_Y(String seq, String cloudname, String useYn) throws Exception {
        String sql = "UPDATE cloudinaryapiinfo SET use_yn = ? WHERE seq = ? AND compno = ? AND cloudname = ?";
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                Connection conn = DBCPInit.getInstance().getConnection();
                try {
                    try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                        pstmt.setString(1, useYn);
                        pstmt.setString(2, seq);
                        pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setString(4, cloudname);
                        int rows = pstmt.executeUpdate();
                        YDMAStringUtil.Print(String.format("Cloudinary use_yn \uc5c5\ub370\uc774\ud2b8: seq=%s, cloudname=%s, useYn=%s, rowsAffected=%s", seq, cloudname, useYn, rows));
                    }
                    if (conn == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (conn == null) throw throwable;
                    conn.close();
                    throw throwable;
                }
                conn.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException sqle) {
            YDMAStringUtil.Print(String.format("Cloudinary use_yn \uc124\uc815 \uc2e4\ud328: seq=%s, cloudname=%s, useYn=%s", seq, cloudname, useYn, sqle));
            throw sqle;
        }
    }

    public int updateCloudinaryApiInfo(int seq, CloudinaryApiInfoDto dto) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "UPDATE cloudinaryapiinfo \r\n   SET CLOUDNAME =?, APIKEY = ?, APISECRET = ?, USE_LIMIT = ?, USE_YN = ?, ID = ?, PW = ? \r\n WHERE seq = ? AND compno = ?";
                pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                pstmt.setString(1, dto.getCloudname());
                pstmt.setString(2, dto.getApikey());
                pstmt.setString(3, dto.getApisecret());
                pstmt.setInt(4, dto.getUse_limit());
                pstmt.setString(5, dto.getUse_yn());
                pstmt.setString(6, dto.getId());
                pstmt.setString(7, dto.getPw());
                pstmt.setInt(8, seq);
                pstmt.setString(9, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[updateCloudinaryApiInfo]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int clearCloudinaryApiInfo() throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from cloudinaryapiinfo where compno=? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int deleteCloudinaryApiInfo(int seq) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from cloudinaryapiinfo where compno=? and seq = ?";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, seq);
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int setCloudinaryApiInfo(List<CloudinaryApiInfoDto> list) throws Exception {
        int result = 1;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into cloudinaryapiinfo values (?, ?, ?, ?, ?, ?, ?, ?, ?) ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (CloudinaryApiInfoDto dto : list) {
                    int idx = 0;
                    pstmt.setInt(++idx, result);
                    pstmt.setString(++idx, dto.getCompno());
                    pstmt.setString(++idx, dto.getCloudname());
                    pstmt.setString(++idx, dto.getApikey());
                    pstmt.setString(++idx, dto.getApisecret());
                    pstmt.setInt(++idx, dto.getUse_limit());
                    pstmt.setString(++idx, dto.getUse_yn());
                    pstmt.setString(++idx, dto.getId());
                    pstmt.setString(++idx, dto.getPw());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result - 1;
    }

    public int insertCloudinaryApiInfo(CloudinaryApiInfoDto dto) throws Exception {
        int result;
        block6: {
            result = 1;
            Connection connection = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    int nextSeq = 1;
                    String getSeqSql = "SELECT IFNULL(MAX(seq), 0) + 1 AS nextSeq FROM cloudinaryapiinfo WHERE compno != '0'";
                    PreparedStatement seqStmt = connection.prepareStatement(getSeqSql);
                    statementlist.add(seqStmt);
                    rs = seqStmt.executeQuery();
                    if (rs.next()) {
                        nextSeq = rs.getInt("nextSeq");
                    }
                    String sql = "INSERT INTO cloudinaryapiinfo    (SEQ, COMPNO, CLOUDNAME, APIKEY, APISECRET, USE_LIMIT, USE_YN, ID, PW)   VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    sql = sql.toUpperCase();
                    PreparedStatement pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int idx = 0;
                    pstmt.setInt(++idx, nextSeq);
                    pstmt.setString(++idx, dto.getCompno());
                    pstmt.setString(++idx, dto.getCloudname());
                    pstmt.setString(++idx, dto.getApikey());
                    pstmt.setString(++idx, dto.getApisecret());
                    pstmt.setInt(++idx, dto.getUse_limit());
                    pstmt.setString(++idx, dto.getUse_yn());
                    pstmt.setString(++idx, dto.getId());
                    pstmt.setString(++idx, dto.getPw());
                    result = pstmt.executeUpdate();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public List<CloudinaryApiInfoDto> getListCloudinaryApiInfo() throws Exception {
        ArrayList<CloudinaryApiInfoDto> result;
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            result = new ArrayList<CloudinaryApiInfoDto>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "SELECT SEQ, COMPNO, CLOUDNAME, APIKEY, APISECRET, USE_LIMIT, USE_YN, ID, PW\r\n\tFROM cloudinaryapiinfo\r\n where compno = ?";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int columnIndex = 0;
                        CloudinaryApiInfoDto dto = new CloudinaryApiInfoDto();
                        dto.setSeq(rs.getString(++columnIndex));
                        dto.setCompno(rs.getString(++columnIndex));
                        dto.setCloudname(rs.getString(++columnIndex));
                        dto.setApikey(rs.getString(++columnIndex));
                        dto.setApisecret(rs.getString(++columnIndex));
                        dto.setUse_limit(rs.getInt(++columnIndex));
                        dto.setUse_yn(rs.getString(++columnIndex));
                        dto.setId(rs.getString(++columnIndex));
                        dto.setPw(rs.getString(++columnIndex));
                        result.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return result;
    }

    public void updateShopdtlAPIKEY(String shopcd, String shopid, String token, String sellerId) throws Exception {
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE shopdtl AS a \r\n").append(" INNER JOIN (SELECT MIN(SHOPSEQ) AS SHOPSEQ FROM shopdtl \r\n").append("              WHERE COMPNO = ? \r\n").append("                AND SHOPCD = ? \r\n").append("                AND SHOPPINGID = ?) AS b \r\n").append("    ON a.SHOPSEQ = b.SHOPSEQ \r\n").append("   SET a.APIKEY = ?, \r\n").append("       a.AUTHKEY1 = ? \r\n").append(" WHERE COMPNO = ? \r\n").append("   AND SHOPCD = ? \r\n").append("   AND SHOPPINGID = ? \r\n");
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                QueryRunner runner = new QueryRunner();
                Object[] params = new Object[]{YDMASessonUtil.getCompnoInfo().getCompno(), shopcd, shopid, token, sellerId, YDMASessonUtil.getCompnoInfo().getCompno(), shopcd, shopid};
                YDMAStringUtil.Print("[\uc62c\uc6e8\uc774\uc988 \uacc4\uc815 \ud1a0\ud070 \uc5c5\ub370\uc774\ud2b8]" + sql.toString());
                runner.update(connection, sql.toString(), params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ShopDeliveryDto getShippingInfo(ShopOrderMstDto dto) throws Exception {
        ShopDeliveryDto result = null;
        QueryRunner run = new QueryRunner();
        BeanHandler handler = new BeanHandler(ShopDeliveryDto.class);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("\t\tSHOPCD  \r\n");
                query.append("\t  , DLVID  \r\n");
                query.append("\t  , DLVNM AS divNM \r\n");
                query.append("\t  , DOSIN_CODE AS ds_code \r\n");
                query.append("  FROM shopdeliverys  \r\n");
                query.append(" WHERE SHOPCD = ?  \r\n");
                query.append("   AND DLVID = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{dto.getShopid(), dto.getDelivery_id()};
                result = (ShopDeliveryDto)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getCompanyGoodsCd(String itemId, String shopId) throws Exception {
        String companyGoodsCd = null;
        QueryRunner run = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT  \r\n");
                query.append("\t\tIFNULL(COMPAYNY_GOODS_CD, '') AS compayny_goods_cd  \r\n");
                query.append("  FROM shopprodin  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND SHOPCD = ?  \r\n");
                query.append("   AND SHOPPRODNO = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{YDMASessonUtil.getCompnoInfo().getCompno(), shopId, itemId};
                companyGoodsCd = (String)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return companyGoodsCd != null ? companyGoodsCd : "";
    }

    public String getDelvCost(String companyGoodsCd) {
        String delvCost = null;
        QueryRunner run = new QueryRunner();
        ScalarHandler handler = new ScalarHandler();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Connection connection = DBCPInit.getInstance().getConnection();){
                StringBuilder query = new StringBuilder();
                query.append("SELECT IFNULL(CAST(DELV_COST AS CHAR), '0') AS delvCost  \r\n");
                query.append("  FROM shopprodinfo  \r\n");
                query.append(" WHERE COMPNO = ?  \r\n");
                query.append("   AND COMPAYNY_GOODS_CD = ?  \r\n");
                YDMAStringUtil.Print(query.toString());
                Object[] params = new Object[]{YDMASessonUtil.getCompnoInfo().getCompno(), companyGoodsCd};
                delvCost = (String)run.query(connection, query.toString(), (ResultSetHandler)handler, params);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return delvCost != null ? delvCost : "0";
    }

    public int deleteOwnerClanMyItemInfo(OwnerClanMyItemInfo ownerClanMyItemInfo) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from ownerclan_my_items where shopcd = ? and shopseq = ? and shoppingid = ? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, ownerClanMyItemInfo.getShopcd());
                pstmt.setInt(2, ownerClanMyItemInfo.getShopseq());
                pstmt.setString(3, ownerClanMyItemInfo.getShoppingid());
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int insertOwnerClanMyItemInfo(List<OwnerClanMyItemInfo> list) throws Exception {
        int result = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into ownerclan_my_items values (?, ?, ?, ?) ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (OwnerClanMyItemInfo dto : list) {
                    int idx = 0;
                    pstmt.setString(++idx, dto.getShopcd());
                    pstmt.setInt(++idx, dto.getShopseq());
                    pstmt.setString(++idx, dto.getShoppingid());
                    pstmt.setString(++idx, dto.getCompany_goods_cd());
                    ++result;
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public List<String> selectOwnerClanMyItemInfo(OwnerClanMyItemInfo ownerClanMyItemInfo) throws Exception {
        ArrayList<String> list;
        block6: {
            list = new ArrayList<String>();
            Connection connection = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "select company_goods_cd from ownerclan_my_items where shopcd = ? and shopseq = ? and shoppingid = ? ";
                    sql = sql.toUpperCase();
                    PreparedStatement pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    pstmt.setString(1, ownerClanMyItemInfo.getShopcd());
                    pstmt.setInt(2, ownerClanMyItemInfo.getShopseq());
                    pstmt.setString(3, ownerClanMyItemInfo.getShoppingid());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(rs.getString(1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return list;
    }

    public int setShopProdFolders(List<ShopProdFolderDto> list) throws Exception {
        int successCnt;
        block10: {
            int count = 0;
            int batchSize = 1000;
            successCnt = 0;
            Connection connection = null;
            PreparedStatement pstmt = null;
            String sql = "INSERT INTO shopprodfolders (compno, folder, COMPAYNY_GOODS_CD) VALUES (?, ?, ?)";
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement(sql);
                    for (ShopProdFolderDto dto : list) {
                        pstmt.setString(1, dto.getCompno());
                        pstmt.setString(2, dto.getFolder());
                        pstmt.setString(3, dto.getCompany_goods_cd());
                        pstmt.addBatch();
                        if (++count % batchSize != 0) continue;
                        int[] batchResults = pstmt.executeBatch();
                        successCnt += batchResults.length;
                        connection.commit();
                    }
                    if (count % batchSize != 0) {
                        int[] batchResults = pstmt.executeBatch();
                        successCnt += batchResults.length;
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    if (connection != null) {
                        try {
                            connection.rollback();
                        }
                        catch (Exception exception2) {}
                    }
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
        return successCnt;
    }

    private static class CommonCode {
        int MultiThreadCnt = 1;
        final List<String> ShopList = ShopCommon.getCommonCodeList("PRODUCT_SHOP").stream().map(p -> p.getCode()).collect(Collectors.toList());
        private static CommonCode instance = new CommonCode();
        Map<String, Map<String, List<ShoppingMallDetailDto>>> mapShopUserList;
        List<ShoppingMallDetailDto> shoppingMallDetailDtos;
        private String shopcd = "";
        private String shopuserid = "";

        private CommonCode() {
        }

        public Map<String, Map<String, List<ShoppingMallDetailDto>>> getMapShopUserList() {
            return this.mapShopUserList;
        }

        public Map<String, List<ShoppingMallDetailDto>> filterMapShopUserList(String shopcd) {
            if (this.shopuserid.isEmpty()) {
                return this.mapShopUserList.get(shopcd);
            }
            HashMap<String, List<ShoppingMallDetailDto>> ret = new HashMap<String, List<ShoppingMallDetailDto>>();
            ret.put(this.shopuserid, this.mapShopUserList.get(shopcd).get(this.shopuserid));
            return ret;
        }

        public void setMapShopUserList(Map<String, Map<String, List<ShoppingMallDetailDto>>> mapShopUserList) {
            this.mapShopUserList = mapShopUserList;
        }

        public List<ShoppingMallDetailDto> getShoppingMallDetailDtos() {
            return this.shoppingMallDetailDtos;
        }

        public void setShoppingMallDetailDtos(List<ShoppingMallDetailDto> shoppingMallDetailDtos) {
            this.shoppingMallDetailDtos = shoppingMallDetailDtos;
        }

        public void init() throws Exception {
            this.MultiThreadCnt = ShopWorkDao.get().getMultiThreadCnt();
            this.shoppingMallDetailDtos = ShopCommonDao.get().ShoppingMallDetailList();
            this.mapShopUserList = this.shoppingMallDetailDtos.stream().collect(Collectors.groupingBy(ShoppingMallDetailDto::getShopcd, Collectors.groupingBy(ShoppingMallDetailDto::getShoppingid)));
        }

        private static CommonCode get() {
            return instance;
        }

        public String getShopcd() {
            return this.shopcd;
        }

        public void setShopcd(String shopcd) {
            this.shopcd = shopcd;
        }

        public String getShopuserid() {
            return this.shopuserid;
        }

        public void setShopuserid(String shopuserid) {
            this.shopuserid = shopuserid;
        }

        public List<String> getAllShopCode() {
            return this.ShopList;
        }

        public List<String> getShopCode() {
            if (!this.shopcd.isEmpty()) {
                return Arrays.asList(this.shopcd);
            }
            return this.ShopList;
        }
    }
}

