/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.cafe24;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.ImageUpload.ImageTransformParams;
import com.kdjsystem.mlink.shop.ImageUpload.UnifiedUploadManager;
import com.kdjsystem.mlink.shop.common.DriverPool;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IShopProductListener;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCafe24AdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopCatInfDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductCafe24AdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.shop.dao.WorkmgrlogDao;
import com.kdjsystem.mlink.shop.data.cafe24.Cafe24AcessToken;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.openqa.selenium.chrome.ChromeDriver;

public class Cafe24ProductRegService
implements IProduct {
    private static final String content_type = "application/json";
    JsonParser jsonparser = new JsonParser();
    ShopProductDto dto;
    ShopProductCafe24AdditionDto dtllist;
    ShoppingMallDetailDto idlist;
    DriverPool driverPool;
    ChromeDriver driver;
    int count;
    String shopinfo;
    IShopProductListener listener;
    List<String> imageDelete = new ArrayList<String>();

    private static OkHttpClient getUnsafeOkHttpClient() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustAllCerts, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            return new OkHttpClient.Builder().sslSocketFactory(sslSocketFactory, (X509TrustManager)trustAllCerts[0]).hostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            }).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Cafe24ProductRegService() {
    }

    public Cafe24ProductRegService(ShopProductDto dto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto idlist, DriverPool driverPool, int cnt, String shopinfo, IShopProductListener listener) {
        this.dto = dto;
        this.dtllist = (ShopProductCafe24AdditionDto)dtllist;
        this.idlist = idlist;
        this.count = cnt;
        this.shopinfo = shopinfo;
        this.driverPool = driverPool;
        this.driver = driverPool.getChromeDriver();
        this.listener = listener;
    }

    private void getOption(ShopProductDto dto, Cafe24ProductItem cafe24ProductItem, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            cafe24ProductItem.request.has_option = dto.getChar_1_nm().equals("\ub2e8\ud488") ? "F" : "T";
            if (!dto.getChar_1_nm().equals("\ub2e8\ud488")) {
                cafe24ProductItem.request.options = new ArrayList();
                Cafe24Option cafe24Option = new Cafe24Option();
                cafe24Option.value = new ArrayList();
                List<ShopOptionDto> shopOptionDtos = this.getProductOptions(dto);
                ArrayList<String> value1 = new ArrayList<String>();
                ArrayList<String> value2 = new ArrayList<String>();
                if (shopOptionDtos.size() > 0) {
                    for (ShopOptionDto optionDto : shopOptionDtos) {
                        if (dto.getChar_2_nm().equals("")) {
                            value1.add(optionDto.getOptspecdes());
                            continue;
                        }
                        value1.add(optionDto.getOptspecdes().split(":")[0]);
                        value2.add(optionDto.getOptspecdes().split(":")[1]);
                    }
                    if (dto.getChar_2_nm().equals("")) {
                        cafe24Option.name = dto.getChar_1_nm();
                        cafe24Option.value = value1.stream().distinct().collect(Collectors.toList());
                        cafe24ProductItem.request.options.add(cafe24Option);
                    } else {
                        cafe24Option.name = dto.getChar_1_nm();
                        cafe24Option.value = value1.stream().distinct().collect(Collectors.toList());
                        cafe24ProductItem.request.options.add(cafe24Option);
                        cafe24Option = new Cafe24Option();
                        cafe24Option.name = dto.getChar_2_nm();
                        cafe24Option.value = value2.stream().distinct().collect(Collectors.toList());
                        cafe24ProductItem.request.options.add(cafe24Option);
                    }
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getCode(ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem) throws Exception {
        try {
            cafe24ProductItem.request.manufacturer_code = "M0000000";
            cafe24ProductItem.request.trend_code = "T0000000";
            cafe24ProductItem.request.brand_code = "B0000000";
            cafe24ProductItem.request.supplier_code = "S0000000";
        }
        catch (Exception exception) {
            throw new Exception("\uc81c\uc870\uc0ac,\uacf5\uae09\uc0ac,\ube0c\ub79c\ub4dc,\ud2b8\ub79c\ub4dc \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getDelvExpress(ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem, ShopProductDto dto) throws Exception {
        try {
            String delvtype2;
            String deliveryFee;
            cafe24ProductItem.request.shipping_fee_by_product = dtllist.getDeliveryfeetype().equals("F") ? "F" : "T";
            String delvtype = dtllist.getDeliveryfeetype();
            String prodDelvType = dto.getDelv_type();
            String string = deliveryFee = dtllist.getShipfee().equals("") ? "0" : dtllist.getShipfee();
            if (delvtype.equals("P")) {
                if (prodDelvType.equals("2") || prodDelvType.equals("3")) {
                    throw new Exception("\uc0c1\ud488\uc815\ubcf4 \ubc30\uc1a1\ube44 \uc0ac\uc6a9 \uc2dc \uc720\ub8cc\ubc30\uc1a1, \ubb34\ub8cc\ubc30\uc1a1\ub9cc \ub4f1\ub85d \uac00\ub2a5\ud569\ub2c8\ub2e4.");
                }
                delvtype = prodDelvType.equals("0") ? "R" : (prodDelvType.equals("1") ? "T" : "");
                deliveryFee = dto.getDelv_cost();
            }
            if (!dtllist.getDeliveryfeetype().equals("F")) {
                cafe24ProductItem.request.shipping_scope = "A";
                cafe24ProductItem.request.shipping_method = "01";
                cafe24ProductItem.request.shipping_area = "\uc804\uad6d(\ub3c4\uc11c\uc0b0\uac04\uc81c\uc678)";
                cafe24ProductItem.request.shipping_fee_type = delvtype;
                Cafe24Rates rate = new Cafe24Rates();
                if (dtllist.getShipfee().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = dto.getDelv_cost();
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDeliverycost();
                    }
                }
                rate.shipping_fee = deliveryFee;
                cafe24ProductItem.request.shipping_rates = new ArrayList();
                cafe24ProductItem.request.shipping_rates.add(rate);
            }
            String string2 = delvtype.equals("F") ? "\uae30\ubcf8\ubc30\uc1a1 \uc124\uc815" : (delvtype.equals("T") ? "\ubb34\ub8cc\ubc30\uc1a1" : (delvtype.equals("R_C") ? "\ucc29\ubd88\ubc30\uc1a1" : (delvtype2 = delvtype.equals("R") ? "\uc720\ub8cc\ubc30\uc1a1" : "\uc218\ub7c9\ubcc4 \ubc30\uc1a1")));
            long delvcost = delvtype.equals("\ubb34\ub8cc\ubc30\uc1a1") ? 0 : (delvtype.equals("\uae30\ubcf8\ubc30\uc1a1 \uc124\uc815") ? 0 : (delvtype.equals("\ucc29\ubd88\ubc30\uc1a1") ? 0 : Integer.parseInt(deliveryFee)));
            dto.setPack_code_str(delvtype2.concat("=").concat(String.valueOf(delvcost)));
        }
        catch (Exception exception) {
            throw new Exception("\ubc30\uc1a1\uc815\ubcf4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public String getCategorySize(ShopProductDto dto) {
        List<String> ret = Arrays.asList(dto.getClass_cd1(), dto.getClass_cd2(), dto.getClass_cd3(), dto.getClass_cd4());
        String strCategs = "";
        if (YDMASessonUtil.getLoginType() == 2) {
            List result = ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
            strCategs = (String)result.get(result.size() - 1);
        } else {
            strCategs = ret.stream().map(n -> String.valueOf(n)).collect(Collectors.joining());
        }
        return strCategs;
    }

    private void getCategory(ShopProductDto dto, Cafe24ProductItem cafe24ProductItem, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            Response response;
            String strCategs = this.getCategorySize(dto);
            ShopCatInfDto cateDto = ShopCommonDao.get().getShopCateInfName(dto.getClass_nm1(), dto.getShopcd());
            String sendcatno = "";
            ObjectMapper mapper = new ObjectMapper();
            List<String> class_nm = Arrays.asList(dto.getClass_nm1().split(">"));
            String catecd = "1";
            if (cateDto.getShoplagcatcd() == null || cateDto.getShoplagcatcd().equals("")) {
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 0);
            } else {
                sendcatno = cateDto.getShoplagcatcd();
                response = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (response.code() != 200) {
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 0);
                }
            }
            if (cateDto.getShopmidcatcd() == null || cateDto.getShopmidcatcd().equals("")) {
                catecd = cateDto.getShoplagcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 1);
            } else {
                sendcatno = cateDto.getShopmidcatcd();
                response = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (response.code() != 200) {
                    catecd = cateDto.getShoplagcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 1);
                }
            }
            if (cateDto.getShopsmlcatcd() == null || cateDto.getShopsmlcatcd().equals("")) {
                catecd = cateDto.getShopmidcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 2);
            } else {
                sendcatno = cateDto.getShopsmlcatcd();
                response = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (response.code() != 200) {
                    catecd = cateDto.getShopmidcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 2);
                }
            }
            if (cateDto.getShopdetcatcd() == null || cateDto.getShopdetcatcd().equals("")) {
                catecd = cateDto.getShopsmlcatcd();
                catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 3);
            } else {
                sendcatno = cateDto.getShopdetcatcd();
                response = this.ShopCategSearch(shoppingMallDetailDto, sendcatno);
                if (response.code() != 200) {
                    catecd = cateDto.getShopsmlcatcd();
                    catecd = this.ShopCategoryCreate(shoppingMallDetailDto, cateDto, mapper, catecd, class_nm, 3);
                }
            }
            cateDto.setShopcatno(strCategs);
            cateDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
            cateDto.setShopcd(shoppingMallDetailDto.getShopcd());
            cateDto.setShopcatnm(String.valueOf(shoppingMallDetailDto.getShopcd()) + "_" + class_nm.get(class_nm.size() - 1));
            cateDto.setShopcatsitenm(dto.getClass_nm1());
            List<String> list = this.getProductCategory(cateDto);
            if (list.size() > 0) {
                cafe24ProductItem.request.add_category_no = new ArrayList();
                for (String cate : list) {
                    CategoryReg categoryReg = new CategoryReg();
                    categoryReg.category_no = cate;
                    categoryReg.recommend = "F";
                    categoryReg.neW = "F";
                    cafe24ProductItem.request.add_category_no.add(categoryReg);
                }
            }
            ShopProductDao.get().Category(cateDto, dto, class_nm, dto.getGoods_keyword());
        }
        catch (Exception exception) {
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    public List<String> getProductCategory(ShopCatInfDto dto) {
        List<String> ret = Arrays.asList(dto.getShoplagcatcd(), dto.getShopmidcatcd(), dto.getShopsmlcatcd(), dto.getShopdetcatcd());
        return ret.stream().filter(p -> p != null && !p.isEmpty()).collect(Collectors.toList());
    }

    private Response ShopCategSearch(ShoppingMallDetailDto shoppingMallDetailDto, String sendcatno) throws IOException {
        try {
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/categories/%s", shoppingMallDetailDto.getShoppingid(), sendcatno)).addHeader("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto)).addHeader("Content-Type", content_type).get().build();
            Response response = Cafe24ProductRegService.getUnsafeOkHttpClient().newCall(request2).execute();
            return response;
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
            return null;
        }
    }

    private String ShopCategoryCreate(ShoppingMallDetailDto shoppingMallDetailDto, ShopCatInfDto cateDto, ObjectMapper mapper, String catecd, List<String> class_nm, int size) throws JsonProcessingException, IOException, Exception {
        int i = size;
        while (i < class_nm.size()) {
            CategoryCreate categoryCreate = new CategoryCreate();
            categoryCreate.request.parent_category_no = Integer.parseInt(catecd);
            categoryCreate.request.category_name = class_nm.get(i);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            String json = mapper.writeValueAsString((Object)categoryCreate);
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/categories", shoppingMallDetailDto.getShoppingid())).addHeader("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto)).addHeader("Content-Type", content_type).post(body).build();
            Response response = Cafe24ProductRegService.getUnsafeOkHttpClient().newCall(request2).execute();
            if (response.code() == 201) {
                String bodycate = response.body().string().toString();
                JsonObject jsonobject = (JsonObject)this.jsonparser.parse(bodycate);
                JsonObject datas = (JsonObject)jsonobject.get("category");
                JsonObject category_no = (JsonObject)datas.get("full_category_no");
                if (i == 0) {
                    catecd = category_no.get("1").getAsString();
                    cateDto.setShoplagcatcd(catecd);
                } else if (i == 1) {
                    catecd = category_no.get("2").getAsString();
                    cateDto.setShopmidcatcd(catecd);
                } else if (i == 2) {
                    catecd = category_no.get("3").getAsString();
                    cateDto.setShopsmlcatcd(catecd);
                } else if (i == 3) {
                    catecd = category_no.get("4").getAsString();
                    cateDto.setShopdetcatcd(catecd);
                }
            } else {
                throw new Exception("\uce74\ud14c\uace0\ub9ac \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
            ++i;
        }
        return catecd;
    }

    private void productBasicInfo(ShopProductDto dto, Cafe24ProductItem cafe24ProductItem, ShopCafe24AdditionDto dtllist) throws Exception {
        try {
            cafe24ProductItem.request.custom_product_code = dto.getCompayny_goods_cd();
            String value = IProduct.formatProductNameByCode(dtllist.getProdoutput(), dto);
            if (!dtllist.getProdnmfront().equals("")) {
                value = dtllist.getProdnmfront().concat(value);
            }
            if (!dtllist.getProdnmend().equals("")) {
                value = value.concat(" ").concat(dtllist.getProdnmend());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 250);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            String sellerProductName = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 250) : value;
            cafe24ProductItem.request.product_name = sellerProductName;
            cafe24ProductItem.request.eng_product_name = dto.getGoods_nm_en();
            cafe24ProductItem.request.supply_product_name = dto.getGoods_nm();
            cafe24ProductItem.request.internal_product_name = dto.getGoods_nm();
            cafe24ProductItem.request.model_name = dto.getCompayny_goods_cd();
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice getMarketPrice(ShopProductDto dto, ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            if (dtllist.getFreedelivery().equals("T")) {
                int deliveryFee;
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            cafe24ProductItem.request.price = resultMarketPrice.getConsumer_if_sale_price();
            cafe24ProductItem.request.retail_price = "0";
            cafe24ProductItem.request.supply_price = resultMarketPrice.getConsumer_if_sale_price();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return resultMarketPrice;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getImage(Cafe24ProductItem cafe24ProductItem, ShopProductDto dto, ShopCafe24AdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception {
        try {
            byte[] byteArray;
            block28: {
                String imgpath = "";
                byteArray = null;
                imgpath = strImages.get(0);
                URL url = new URL(imgpath);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 Chrome/124.0.0.0 Safari/537.36");
                connection.connect();
                Throwable throwable = null;
                Object var11_13 = null;
                try {
                    InputStream inputStream = connection.getInputStream();
                    try {
                        try (ByteArrayOutputStream byteOutStream = new ByteArrayOutputStream();){
                            byte[] buffer = new byte[1024];
                            while (true) {
                                int bytesRead;
                                if ((bytesRead = inputStream.read(buffer)) == -1) {
                                    byteArray = byteOutStream.toByteArray();
                                    break;
                                }
                                byteOutStream.write(buffer, 0, bytesRead);
                            }
                        }
                        if (inputStream == null) break block28;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    inputStream.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            String imageString = Base64.getEncoder().encodeToString(byteArray);
            StringBuffer payload = new StringBuffer();
            payload.append("{ \"requests\": [\n");
            payload.append("\n");
            payload.append("{\n");
            payload.append("\"image\":\"" + imageString + "\"");
            payload.append("}\n");
            payload.append("\n");
            payload.append("] }");
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)payload.toString());
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/products/images", shoppingMallDetailDto.getShoppingid())).addHeader("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto)).addHeader("Content-Type", content_type).post(body).build();
            Throwable bytesRead = null;
            Object var16_23 = null;
            try (Response response = Cafe24ProductRegService.getUnsafeOkHttpClient().newCall(request2).execute();){
                String data2 = response.body().string();
                JsonObject jsonobject = (JsonObject)this.jsonparser.parse(data2);
                JsonArray images = (JsonArray)jsonobject.get("images");
                JsonObject object = (JsonObject)images.get(0);
                String image = object.get("path").getAsString();
                image = image.substring(image.indexOf("/web"), image.length());
                cafe24ProductItem.request.detail_image = image;
                return;
            }
            catch (Throwable throwable) {
                if (bytesRead == null) {
                    bytesRead = throwable;
                    throw bytesRead;
                }
                if (bytesRead == throwable) throw bytesRead;
                bytesRead.addSuppressed(throwable);
                throw bytesRead;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc774\ubbf8\uc9c0 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void remarkNservice(ShopProductDto dto, Cafe24ProductItem cafe24ProductItem, ShopCafe24AdditionDto dtllist) throws Exception {
        try {
            String remark = "";
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            List noticeDto = dto.getShopProdAttrnmDtos().stream().filter(d -> !d.getProp_val().equals("")).collect(Collectors.toList());
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < noticeDto.size()) {
                sb.append(String.valueOf(((ShopProdAttrnmDto)noticeDto.get(i)).getAttrnm()) + " : " + ((ShopProdAttrnmDto)noticeDto.get(i)).getProp_val());
                sb.append("\n");
                ++i;
            }
            String html = IProduct.removeBrokenImgTag(dto.getGoods_remarks());
            remark = dtllist.getDetailexplain().equals("2") ? String.valueOf(sb.toString()) + html : (dtllist.getDetailexplain().equals("3") ? String.valueOf(html) + sb.toString() : html);
            if (dtllist.getProddetailoutput().equals("1")) {
                remark = dtllist.getProddetailfront().concat(remark).concat(dtllist.getProddetailend());
            } else if (dtllist.getProddetailoutput().equals("2")) {
                dto.setGoods_remarks2(dtllist.getProddetailfront().concat(dto.getGoods_remarks2()).concat(dtllist.getProddetailend()));
            } else if (dtllist.getProddetailoutput().equals("3")) {
                dto.setGoods_remarks3(dtllist.getProddetailfront().concat(dto.getGoods_remarks3()).concat(dtllist.getProddetailend()));
            }
            if (dtllist.getRemarktop().equals("Y")) {
                remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat(remark);
            }
            cafe24ProductItem.request.description = remark;
            cafe24ProductItem.request.summary_description = dto.getGoods_remarks2();
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> removetag = new ArrayList<String>();
            List<String> search = new ArrayList<String>();
            if (dto.getExcepkeywdyn().equals("Y")) {
                removetag.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
                list.addAll(Arrays.asList(dto.getGoods_search().split(",")));
                search = IProduct.checkSearch(list, removetag, search);
            } else {
                search.addAll(Arrays.asList(dto.getGoods_search().split(",")));
            }
            cafe24ProductItem.request.product_tag = search.stream().collect(Collectors.toList());
            cafe24ProductItem.request.payment_info = dtllist.getPayinfo();
            cafe24ProductItem.request.shipping_info = dtllist.getShippinginfo();
            cafe24ProductItem.request.exchange_info = dtllist.getExchretinfo();
            cafe24ProductItem.request.service_info = dtllist.getServiceinfo();
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\uc138\uc124\uba85, \uc548\ub0b4 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void getOrginNMaterial(ShopProductDto dto, ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem) throws Exception {
        try {
            cafe24ProductItem.request.origin_classification = "E";
            cafe24ProductItem.request.origin_place_value = dto.getOrigin();
            cafe24ProductItem.request.tax_type = dtllist.getTaxrating();
            cafe24ProductItem.request.tax_rate = dtllist.getTaxrating1();
            cafe24ProductItem.request.adult_certification = dtllist.getAdultcheck();
        }
        catch (Exception exception) {
            throw new Exception("\uc6d0\uc0b0\uc9c0, \uc131\uc778\uc5ec\ubd80, \uacfc\uc138 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void shopPoint(ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem) throws Exception {
        try {
            cafe24ProductItem.request.points_by_product = "F";
        }
        catch (Exception exception) {
            throw new Exception("\ud3ec\uc778\ud2b8 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<String> getPoint(ShopCafe24AdditionDto dtllist, int i) {
        ArrayList<String> pnt = new ArrayList<String>();
        switch (i) {
            case 0: {
                pnt.add("cash");
                pnt.add(dtllist.getMileage3());
                pnt.add(dtllist.getMileage());
                break;
            }
            case 1: {
                pnt.add("card");
                pnt.add(dtllist.getMileage5());
                pnt.add(dtllist.getMileage6());
                break;
            }
            case 2: {
                pnt.add("tcash");
                pnt.add(dtllist.getMileage9());
                pnt.add(dtllist.getMileage10());
                break;
            }
            case 3: {
                pnt.add("mileage");
                pnt.add(dtllist.getMileage7());
                pnt.add(dtllist.getMileage8());
                break;
            }
            case 4: {
                pnt.add("cell");
                pnt.add(dtllist.getMileage11());
                pnt.add(dtllist.getMileage12());
                break;
            }
            case 5: {
                pnt.add("deposit");
                pnt.add(dtllist.getMileage13());
                pnt.add(dtllist.getMileage14());
            }
        }
        return pnt;
    }

    private void salesMaximumQty(ShopCafe24AdditionDto dtllist, Cafe24ProductItem cafe24ProductItem) throws Exception {
        try {
            if (dtllist.getSellpricereplace().equals("T")) {
                cafe24ProductItem.request.price_content = dtllist.getSellpricereplace1();
            }
            cafe24ProductItem.request.buy_limit_by_product = "F";
            cafe24ProductItem.request.order_quantity_limit_type = "P";
            cafe24ProductItem.request.minimum_quantity = dtllist.getProductmin().equals("") ? "1" : dtllist.getProductmin();
            cafe24ProductItem.request.maximum_quantity = dtllist.getProductmaxtype().equals("T") ? dtllist.getProductmax() : "0";
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uc81c\ud55c, \uc8fc\ubb38\uc218\ub7c9 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String getApiJsonString(ShopProductDto dto, ShopCafe24AdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        Cafe24ProductItem cafe24ProductItem = new Cafe24ProductItem();
        cafe24ProductItem.shop_no = 1;
        cafe24ProductItem.request.display = "T";
        cafe24ProductItem.request.selling = "T";
        cafe24ProductItem.request.product_condition = "N";
        ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
        dto.setSaleenddt("2999-12-31");
        this.getCategory(dto, cafe24ProductItem, shoppingMallDetailDto);
        this.productBasicInfo(dto, cafe24ProductItem, dtllist);
        resultMarketPrice = this.getMarketPrice(dto, dtllist, cafe24ProductItem, resultMarketPrice);
        this.getOption(dto, cafe24ProductItem, resultMarketPrice);
        this.getCode(dtllist, cafe24ProductItem);
        try {
            cafe24ProductItem.request.release_date = dtllist.getReleasedate();
            if (dtllist.getExpirationdate().equals("T")) {
                cafe24ProductItem.request.expiration_date.start_date = dtllist.getPrstartdate();
                cafe24ProductItem.request.expiration_date.end_date = dtllist.getPrenddate();
            }
        }
        catch (Exception exception) {
            throw new Exception("\ucd9c\uc2dc\uc77c\uc790, \uc720\ud6a8\uae30\uac04 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        this.remarkNservice(dto, cafe24ProductItem, dtllist);
        this.getDelvExpress(dtllist, cafe24ProductItem, dto);
        this.getImage(cafe24ProductItem, dto, dtllist, shoppingMallDetailDto, strImages);
        this.salesMaximumQty(dtllist, cafe24ProductItem);
        this.shopPoint(dtllist, cafe24ProductItem);
        this.getOrginNMaterial(dto, dtllist, cafe24ProductItem);
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        String json = mapper.writeValueAsString((Object)cafe24ProductItem);
        json = json.replace("neW", "new");
        YDMAStringUtil.Print(json);
        return json;
    }

    @Override
    public Map<String, String> loginCookie(String loginID, String password, String shopcd, boolean flag, String authkey) throws Exception {
        String key = "";
        ChromeDriver driver = null;
        try {
            switch (shopcd) {
                case "shop0110": {
                    key = String.format("%s%s%s", loginID, password, LocalDate.now());
                    if (cokieManager.get(key) != null) {
                        Map map = (Map)cokieManager.get(key);
                        return map;
                    }
                    driver = this.loginCafe24(loginID, password, flag, shopcd);
                }
            }
            if (cokieManager.get(key) == null) {
                throw new Exception("\ub85c\uadf8\uc778 \uc0ac\uc6a9\uc790 \uc544\uc774\ub514 \ud328\uc2a4\uc6cc\ub4dc\ub97c \ud655\uc778\ud574 \uc8fc\uc138\uc694");
            }
            Map map = (Map)cokieManager.get(key);
            return map;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        finally {
            if (driver != null) {
                driver.close();
                driver.quit();
            }
        }
    }

    @Override
    public ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShoppingMallDetailDto shoppingMallDetailDto = sendProdList.getShoppingMallDetailDto();
        YDMAStringUtil.Print();
        List<ShopProductDto> prodList = sendProdList.getShopProductDto();
        ShopCafe24AdditionDto dtllist = (ShopCafe24AdditionDto)sendProdList.getProductAdditionDto();
        String uuid = sendProdList.getWorkgrp();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        workMngDto.setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        double mod = 0.0;
        double rate = 0.0;
        try {
            String.format("(%s) %s", shoppingMallDetailDto.getShopnm(), shoppingMallDetailDto.getShoppingid());
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            mod = sendProdList.isManual() ? (double)conf.getProccnt() / (double)prodList.size() : 100.0 / (double)prodList.size();
            int progress = workMngDto.getProgress_rate();
            List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ShopProductDto dto : prodList) {
                this.imageDelete = new ArrayList<String>();
                if ((int)(rate += mod) > 0) {
                    progress += (int)rate;
                    rate = 0.0;
                }
                workMngDto.setProgress_rate(progress);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                ArrayList<String> strImages = new ArrayList();
                ImageTransformParams params = new ImageTransformParams();
                params.setShopProductDto(dto);
                params.setChangesize("");
                params.setChangeSizeX("");
                params.setChangeSizeY("");
                params.setChangeSizeW("");
                params.setChangeSizeH("");
                params.setAngle(0.0);
                params.setScalePercent(0.0);
                params.setImgThreeOnFour("");
                params.setRemoveImgTextYN("");
                params.setMirrorImgYN("");
                params.setImageresize("");
                params.setImageresize1("");
                UnifiedUploadManager manager = new UnifiedUploadManager();
                strImages = manager.processAndUploadImages(params);
                this.imageDelete = strImages;
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    try {
                        boolean isExitsProd = this.isExitsProductCd(shoppingMallDetailDto, dto);
                        if (isExitsProd) {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage("\uc0c1\ud488\ub4f1\ub85d\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            dto.setResult_code("-1");
                            dto.setResult_text("\uc0c1\ud488\ub4f1\ub85d\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub9c8\ucf13\uc5d0 \uac19\uc740 \uc0c1\ud488\uc774  \uc874\uc7ac\ud558\uace0 \uc788\uc2b5\ub2c8\ub2e4. \uc0ad\uc81c\ud6c4\uc5d0 \uc7ac\ub4f1\ub85d\ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.");
                            WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                            continue;
                        }
                        String json = this.getApiJsonString(dto, dtllist, shoppingMallDetailDto, strImages);
                        Response result = this.postProductReg(json, shoppingMallDetailDto);
                        this.deleteFTPServer(this.imageDelete);
                        if (result.code() == 201) {
                            String jsonData = result.body().string().toString();
                            JsonObject jsonobject = (JsonObject)this.jsonparser.parse(jsonData);
                            JsonObject data2 = (JsonObject)jsonobject.get("product");
                            String code = data2.get("product_no").getAsString();
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            String message = String.valueOf(shoppingMallDetailDto.getShopnm()) + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4 [\uc0c1\ud488\ubc88\ud638 : " + code + " ]";
                            workMngDetailDto.setMessage(message);
                            dto.setShopprodno(code);
                            dto.setResult_text(message);
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                            result.body().close();
                        } else {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(result.message());
                            dto.setResult_code("-1");
                            dto.setResult_text(result.message());
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(e.getMessage());
                        dto.setResult_code("-1");
                        dto.setResult_text(e.getMessage());
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    if (!conf.getSaveproductlogyn().equals("Y")) continue;
                    ArrayList<String> sendList = new ArrayList<String>();
                    sendList.add(uuid);
                    sendList.add(dto.getShopcd());
                    sendList.add(shoppingMallDetailDto.getShopnm());
                    sendList.add(dto.getShopseq());
                    sendList.add(shoppingMallDetailDto.getShoppingid());
                    sendList.add(shoppingMallDetailDto.getNicknm1());
                    sendList.add(workMngDetailDto.getSeq());
                    sendList.add(dto.getCompayny_goods_cd());
                    sendList.add(workMngDetailDto.getStatus());
                    sendList.add(workMngDetailDto.getMessage());
                    sendList.add(dtllist.getSeq());
                    sendList.add(dtllist.getTitle());
                    sendList.add("Y");
                    sendList.add(String.valueOf(dtllist.getSellerDc()));
                    sendList.add(String.valueOf(dtllist.getMargin()));
                    sendList.add(String.valueOf(dtllist.getCommission()));
                    sendList.add("");
                    sendList.add("");
                    sendList.add("");
                    sendList.add("");
                    sendList.add(String.valueOf(dtllist.getAngle()));
                    sendList.add(String.valueOf(dtllist.getScalePercent()));
                    sendList.add("N");
                    sendList.add(dto.getGoods_keyword());
                    sendList.add(dto.getClass_cd3());
                    sendList.add(dto.getClass_nm1());
                    sendList.add(YDMATimeUtil.getCurrentTimeByYDFormat());
                    sendList.add(dto.getGoods_cost());
                    sendList.add(dto.getDelv_cost());
                    sendList.add(dto.getGoods_search());
                    sendList.add("0");
                    WorkmgrlogDao.get().insertWorkLog(sendList);
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            workMngDto.setWork_enddate(YDMATimeUtil.getCurrentTimeByYDFormat());
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isExitsProductCd(ShoppingMallDetailDto shoppingMallDetailDto, ShopProductDto dto) {
        String url = String.format("https://%s.cafe24api.com/api/v2/admin/products?custom_product_code=%s", shoppingMallDetailDto.getShoppingid(), dto.getCompayny_goods_cd());
        Request request2 = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto)).addHeader("Content-Type", content_type).get().build();
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (Response response = Cafe24ProductRegService.getUnsafeOkHttpClient().newCall(request2).execute();){
                String data2 = response.body().string();
                JsonObject jsonobject = (JsonObject)this.jsonparser.parse(data2);
                JsonArray product2 = (JsonArray)jsonobject.get("products");
                if (product2.size() <= 0) return false;
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private Response postProductReg(String json, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        Response response = this.useBearerToken(Cafe24AcessToken.get().getAccessToken(shoppingMallDetailDto), json, shoppingMallDetailDto);
        return response;
    }

    public Response useBearerToken(String bearerToken, String json, ShoppingMallDetailDto shoppingMallDetailDto) {
        Response response = null;
        Random rand = new Random();
        try {
            MediaType mediaType = MediaType.parse((String)"");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(String.format("https://%s.cafe24api.com/api/v2/admin/products", shoppingMallDetailDto.getShoppingid())).addHeader("Authorization", "Bearer " + bearerToken).addHeader("Content-Type", content_type).post(body).build();
            response = Cafe24ProductRegService.getUnsafeOkHttpClient().newCall(request2).execute();
            if (response.code() == 422) {
                YDMAStringUtil.Print("Error 422: " + response.message());
                if (response.body() != null) {
                    YDMAStringUtil.Print("Response Body: " + response.body().string());
                }
            }
            int delay = 3000 + rand.nextInt(1000);
            Thread.sleep(delay);
        }
        catch (Exception e) {
            YDMAStringUtil.Print("Error : " + e.getMessage());
        }
        return response;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    private static final class Cafe24Addinfo {
        private String key;
        private String value;

        private Cafe24Addinfo() {
        }
    }

    private static final class Cafe24Date {
        private String start_date;
        private String end_date;

        private Cafe24Date() {
        }
    }

    private static final class Cafe24Icon {
        private String icon;

        private Cafe24Icon() {
        }
    }

    private static final class Cafe24Option {
        private String name;
        private List<String> value;

        private Cafe24Option() {
        }
    }

    private static final class Cafe24Period {
        private String minimum;
        private String maximum;

        private Cafe24Period() {
        }
    }

    private static final class Cafe24Point {
        private String payment_method;
        private String points_rate;
        private String points_unit_by_payment;

        private Cafe24Point() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class Cafe24ProductItem {
        private int shop_no;
        private request request = new request();

        private Cafe24ProductItem() {
        }

        public request getRequest() {
            return this.request;
        }

        public void setRequest(request request2) {
            this.request = request2;
        }
    }

    private static final class Cafe24Rates {
        private String shipping_rates_min;
        private String shipping_rates_max;
        private String shipping_fee;

        private Cafe24Rates() {
        }
    }

    private static final class Cafe24Volume {
        private String use_product_volume;
        private String product_width;
        private String product_height;
        private String product_length;

        private Cafe24Volume() {
        }
    }

    private static final class Cafe24relational {
        private String product_no;
        private String interrelated;

        private Cafe24relational() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class CategoryCreate {
        @JsonProperty(value="shop_no")
        private int shop_no = 1;
        @JsonProperty(value="request")
        private Requests request = new Requests();

        private CategoryCreate() {
        }
    }

    private static final class CategoryReg {
        private String category_no;
        private String recommend;
        private String neW;

        private CategoryReg() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class Requests {
        @JsonProperty(value="parent_category_no")
        private int parent_category_no;
        @JsonProperty(value="category_name")
        private String category_name;
        @JsonProperty(value="display_type")
        private String display_type = "A";
        @JsonProperty(value="use_main")
        private String use_main = "F";
        @JsonProperty(value="use_display")
        private String use_display = "T";
        @JsonProperty(value="soldout_product_display")
        private String soldout_product_display = "N";
        @JsonProperty(value="sub_category_product_display")
        private String sub_category_product_display = "T";
        @JsonProperty(value="hashtag_product_display")
        private String hashtag_product_display = "F";
        @JsonProperty(value="hash_tags")
        private List<String> hash_tags = new ArrayList<String>();
        @JsonProperty(value="product_display_scope")
        private String product_display_scope;
        @JsonProperty(value="product_display_type")
        private String product_display_type;
        @JsonProperty(value="product_display_key")
        private String product_display_key;
        @JsonProperty(value="product_display_sort")
        private String product_display_sort;
        @JsonProperty(value="product_display_period")
        private String product_display_period;
        @JsonProperty(value="normal_product_display_type")
        private String normal_product_display_type;
        @JsonProperty(value="normal_product_display_key")
        private String normal_product_display_key;
        @JsonProperty(value="normal_product_display_sort")
        private String normal_product_display_sort;
        @JsonProperty(value="normal_product_display_period")
        private String normal_product_display_period;
        @JsonProperty(value="recommend_product_display_type")
        private String recommend_product_display_type;
        @JsonProperty(value="recommend_product_display_key")
        private String recommend_product_display_key;
        @JsonProperty(value="recommend_product_display_sort")
        private String recommend_product_display_sort;
        @JsonProperty(value="recommend_product_display_period")
        private String recommend_product_display_period;
        @JsonProperty(value="new_product_display_type")
        private String new_product_display_type;
        @JsonProperty(value="new_product_display_key")
        private String new_product_display_key;
        @JsonProperty(value="new_product_display_sort")
        private String new_product_display_sort;
        @JsonProperty(value="new_product_display_period")
        private String new_product_display_period;

        private Requests() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static class request {
        private String display;
        private String selling;
        private String product_condition;
        private String product_used_month;
        private List<CategoryReg> add_category_no;
        private String custom_product_code;
        private String product_name;
        private String eng_product_name;
        private String supply_product_name;
        private String internal_product_name;
        private String model_name;
        private String price_excluding_tax;
        private String price;
        private String retail_price;
        private String supply_price;
        private String has_option;
        private List<Cafe24Option> options;
        private String use_naverpay;
        private String naverpay_type;
        private String manufacturer_code;
        private String trend_code;
        private String brand_code;
        private String supplier_code;
        private String product_weight;
        private String made_date;
        private String release_date;
        private Cafe24Date expiration_date;
        private String description;
        private String mobile_description;
        private String summary_description;
        private String simple_description;
        private List<String> product_tag;
        private String payment_info;
        private String shipping_info;
        private String exchange_info;
        private String service_info;
        private List<Cafe24Icon> icon;
        private String hscode;
        private String shipping_scope;
        private String shipping_method;
        private String shipping_fee_by_product;
        private String shipping_area;
        private Cafe24Period shipping_period;
        private String shipping_fee_type;
        private List<Cafe24Rates> shipping_rates;
        private String shipping_fee;
        private String prepaid_shipping_fee;
        private String clearance_category_code;
        private String detail_image;
        private String list_image;
        private String tiny_image;
        private String small_image;
        private String image_upload_type;
        private String price_content;
        private String buy_limit_by_product;
        private String buy_limit_type;
        private String repurchase_restriction;
        private String single_purchase_restriction;
        private String buy_unit_type;
        private String buy_unit;
        private String order_quantity_limit_type;
        private String minimum_quantity;
        private String maximum_quantity;
        private String points_by_product;
        private String points_setting_by_payment;
        private List<Cafe24Point> points_amount;
        private String except_member_points;
        private Cafe24Volume product_volume;
        private String origin_classification;
        private String origin_place_no;
        private String origin_place_value;
        private String made_in_code;
        private String main;
        private String product_material;
        private String english_product_material;
        private String cloth_fabric;
        private String classification_code;
        private String additional_price;
        private String margin_rate;
        private String tax_type;
        private String tax_rate;
        private String additional_image;
        private String adult_certification;

        private request() {
        }
    }
}

