/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverPay;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class NaverPayOrderNewCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverPayOrderNewCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverPayOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        long range;
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        String startDate = YDMATimeUtil.getTime(param.get(0).getStartDt());
        String endDate = YDMATimeUtil.getTime(param.get(0).getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sDate = formatter.parse(param.get(0).getStartDt());
        Date eDate = formatter.parse(param.get(0).getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sDate);
        cal2.setTime(eDate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            YDMAProgressBar.get().setValue("\ub124\uc774\ubc84\ud398\uc774 - 1\ub144 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc218\uc815\ub41c \ub0a0\uc9dc\ub85c \uac80\uc0c9\ud569\ub2c8\ub2e4.", 0);
            startDate = String.valueOf(cal2.getTimeInMillis());
            sDate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)(range = Math.abs((eDate.getTime() - sDate.getTime()) / 86400000L) + 1L) % 90 == 0 ? (int)range / 90 : (int)range / 90 + 1;
        cal1.setTime(sDate);
        cal2.setTime(sDate);
        if (num > 1) {
            cal2.add(5, 89);
            endDate = String.valueOf(cal2.getTimeInMillis());
        }
        int i = 0;
        while (i < num) {
            this.getNewOrder(param, retList, "NEW_ORDER", startDate, endDate);
            cal1.add(5, 90);
            cal2.add(5, 90);
            startDate = String.valueOf(cal1.getTimeInMillis());
            endDate = String.valueOf(cal2.getTimeInMillis());
            ++i;
        }
        return retList;
    }

    public List<ShopOrderMstDto> getNewOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String orderType, String startDate, String endDate) throws Exception {
        block4: {
            IShopCommonLogin login = new IShopCommonLogin(){};
            HashMap<String, String> cookies = new HashMap();
            String payCenterId = param.get(0).getNickname();
            try {
                cookies = login.loginNaverPayCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), payCenterId);
                Connection.Response rs = Jsoup.connect((String)"https://admin.pay.naver.com/o/v3/n/sale/delivery").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
                Document doc = Jsoup.parseBodyFragment((String)rs.body());
                Elements script = doc.select("script");
                String dataStr = script.stream().filter(x -> x.toString().contains("merchantNo")).map(x -> x.toString().substring(x.toString().indexOf("merchantNo"))).findAny().orElse(null);
                String merchantNo = dataStr.substring(0, dataStr.indexOf(",")).replace("\\\"", "").split(":")[1];
                String requestBody = this.getRequestBody(merchantNo, orderType, startDate, endDate);
                Connection.Response response = Jsoup.connect((String)"https://admin.pay.naver.com/o/v3/graphql").cookies(cookies).header("content-type", "application/json").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/105.0.0.0 Safari/537.36").header("Content-Length", Integer.toString(requestBody.length())).header("Host", "admin.pay.naver.com").requestBody(requestBody).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                JsonParser parser = new JsonParser();
                if (response.statusCode() == 200) {
                    JsonObject body = parser.parse(response.body()).getAsJsonObject();
                    JsonObject data2 = body.get("data").getAsJsonObject();
                    JsonObject deliveryList = data2.get("deliveryList").getAsJsonObject();
                    JsonArray elements = deliveryList.get("elements").getAsJsonArray();
                    if (elements.size() > 0) {
                        List<ShopOrderMstDto> orderList = this.setData(param, elements, cookies);
                        orderList.forEach(a -> a.setResult_code("1"));
                        retList.addAll(orderList);
                    }
                    break block4;
                }
                throw new Exception("\uc218\uc9d1 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retList;
    }

    public List<ShopOrderMstDto> setData(List<ShopOrderMstDto> param, JsonArray orderArray, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> orderList = new ArrayList<ShopOrderMstDto>();
        for (JsonElement order : orderArray) {
            JsonObject orderDetail = order.getAsJsonObject();
            ShopOrderMstDto saveDto = new ShopOrderMstDto();
            saveDto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
            saveDto.setOrder_id(orderDetail.get("orderNo").getAsString());
            saveDto.setOrder_status(this.getOrderStatus(orderDetail.get("productOrderStatus").getAsString()));
            saveDto.setP_product_name(orderDetail.get("productName").getAsString());
            String orddt = YDMATimeUtil.getDate(orderDetail.get("orderDateTime").getAsString());
            saveDto.setOrder_date(orddt);
            saveDto.setProduct_name(orderDetail.get("productName").getAsString());
            saveDto.setSale_cnt(orderDetail.get("orderQuantity").getAsString());
            saveDto.setUser_name(orderDetail.get("orderMemberName").getAsString());
            saveDto.setUser_email("");
            saveDto.setReceive_name(orderDetail.get("receiverName").getAsString());
            saveDto.setShopid(param.get(0).getShopid());
            saveDto.setShop_userid(param.get(0).getShop_userid());
            saveDto.setUser_id(orderDetail.get("orderMemberId").getAsString());
            saveDto.setP_sku_value(this.jsonElementNullStr(orderDetail.get("productOptionContents")));
            saveDto.setSku_value(this.jsonElementNullStr(orderDetail.get("productOptionContents")));
            saveDto.setMall_exp_cd(orderDetail.get("productOrderNo").getAsString());
            saveDto.setUser_tel(this.jsonElementNullStr(orderDetail.get("orderMemberTelNo")));
            saveDto.setUser_cel(this.jsonElementNullStr(orderDetail.get("orderMemberTelNo")));
            saveDto.setReceive_tel(this.jsonElementNullStr(orderDetail.get("receiverTelNo2")));
            saveDto.setReceive_cel(this.jsonElementNullStr(orderDetail.get("receiverTelNo1")));
            saveDto.setReceive_zipcode(this.jsonElementNullStr(orderDetail.get("receiverZipCode")));
            String receiverAddr = this.jsonElementNullStr(orderDetail.get("receiverAddress"));
            saveDto.setReceive_addr(receiverAddr);
            saveDto.setDelv_cost(this.jsonElementNullStr(orderDetail.get("deliveryFeeAmt")));
            saveDto.setDelv_msg(this.jsonElementNullStr(orderDetail.get("productOrderMemo")));
            saveDto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(orderDetail.get("deliveryFeeRatingClass"))));
            String ordamt = orderDetail.get("productPayAmt").getAsString();
            saveDto.setMall_won_cost(this.jsonElementNullStr(orderDetail.get("settlementExpectAmt")));
            saveDto.setPay_cost(orderDetail.get("generalPayAmt").getAsString());
            saveDto.setTotal_cost(ordamt);
            saveDto.setSale_cost(Integer.toString(Integer.parseInt(orderDetail.get("productUnitPrice").getAsString()) * Integer.parseInt(saveDto.getSale_cnt())));
            saveDto.setCompno(param.get(0).getCompno());
            saveDto.setReceive_email("");
            saveDto.setWon_cost("0");
            saveDto.setBox_ea("0");
            saveDto.setNickname(param.get(0).getNickname());
            saveDto.setP_sku_id("");
            String str = orderDetail.get("productName").toString();
            String companyGoodsCd = str.substring(str.indexOf("[") + 1, str.indexOf("]"));
            saveDto.setCompayny_goods_cd(companyGoodsCd);
            saveDto.setMall_product_id(orderDetail.get("productNo").getAsString());
            saveDto.setResult_code("1");
            orderList.add(saveDto);
        }
        return orderList;
    }

    public List<ShopOrderMstDto> getDeliveryCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        try {
            IShopCommonLogin login = new IShopCommonLogin(){};
            HashMap<String, String> cookies = new HashMap();
            String payCenterId = param.get(0).getNickname();
            cookies = login.loginNaverPayCookie(param.get(0).getShop_userid(), param.get(0).getShopPw(), param.get(0).getShopid(), true, param.get(0).getAuthkey1(), payCenterId);
            Connection.Response rs = Jsoup.connect((String)"https://admin.pay.naver.com/o/v3/sale/purchaseDecision?summaryInfoType=PURCHASE_DECIDED").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).execute();
            Document doc = Jsoup.parseBodyFragment((String)rs.body());
            Elements script = doc.select("script");
            String user = ((Node)((Element)script.get(5)).childNodes().get(0)).toString();
            JsonParser jsonparser = new JsonParser();
            JsonObject jsonobject = (JsonObject)jsonparser.parse(user.substring(user.indexOf("{"), user.lastIndexOf("}") + 1));
            YDMAStringUtil.Print(jsonobject);
            String json = "{\"operationName\":\"SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision\",\"variables\":{\"merchantNo\":\"" + jsonobject.get("merchantNo").getAsString() + "\",\"serviceType\":\"MP\",\"paging_page\":1," + "\"paging_size\":500,\"sort_type\":\"RECENTLY_ORDER_YMDT\",\"sort_type\":\"PRODUCT_ORDER_PURCHASE_DECISION_COMPLETE_OPERATION_YMDT\"," + "\"sort_direction\":\"DESC\",\"rangeType\":\"PURCHASE_DECISION_COMPLETED\"," + "\"dateRange_from\":\"" + start + "\",\"dateRange_to\":\"" + end + "\",\"detailedOrderStatus\":\"ALL\"}," + "\"query\":\"query SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision($merchantNo: String!, $serviceType: String!, $claimStatus: ClaimStatusType, $dateRange_from: String, $dateRange_to: String, $detailSearch_keyword: String, $detailSearch_type: DetailSearchType, $paging_page: Int, $paging_size: Int, $rangeType: RangeType, $sort_direction: SortDirectionType, $sort_type: SortType) {\\n  purchaseDecisionList: SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision(merchantNo: $merchantNo, serviceType: $serviceType, claimStatus: $claimStatus, dateRange_from: $dateRange_from, dateRange_to: $dateRange_to, detailSearch_keyword: $detailSearch_keyword, detailSearch_type: $detailSearch_type, paging_page: $paging_page, paging_size: $paging_size, rangeType: $rangeType, sort_direction: $sort_direction, sort_type: $sort_type) {\\n    elements {\\n      ...purchaseDecisionElementField\\n      __typename\\n    }\\n    pagination {\\n      ...paginationField\\n      __typename\\n    }\\n    __typename\\n  }\\n}\\n\\nfragment purchaseDecisionElementField on PurchaseDecisionMp {\\n  branchId\\n  merchantChannelNo\\n  deliveryFeeAmt\\n  deliveryFeeClass\\n  deliveryMethod\\n  biztalkAccountId\\n  deliveryInvoiceNo\\n  productPayAmt\\n  orderStatus\\n  productUnitPrice\\n  purchaseDecisionCompleteDateTime\\n  orderQuantity\\n  productName\\n  orderMemberName\\n  payDateTime\\n  productOrderNo\\n  productOptionContents\\n  deliveryFeeRatingClass\\n  orderMemberId\\n  knowledgeShoppingCommissionAmt\\n  remoteAreaCostChargeAmt\\n  productOptionAmt\\n  salesCommissionPrepay\\n  productNo\\n  payLocationType\\n  totalDiscountAmt\\n  orderNo\\n  payMeansClass\\n  productClass\\n  commissionClassType\\n  inflowPath\\n  receiverName\\n  settlementExpectAmt\\n  deliveryNo\\n  deliveryCompleteDateTime\\n  saleChannelType\\n  sellerDiscountAmt\\n  deliveryCompanyName\\n  deliveryFeeDiscountAmt\\n  dispatchDateTime\\n  sellerProductManagementCode\\n  payCommissionAmt\\n  syncDateTime\\n  productOrderStatus\\n  sellerInternalCode2\\n  sellingInterlockCommissionClassType\\n  sellingInterlockCommissionInflowPath\\n  sellerInternalCode1\\n  deliveryBundleGroupSeq\\n  productUrl\\n  __typename\\n}\\n\\nfragment paginationField on Pagination {\\n  size\\n  totalElements\\n  page\\n  totalPages\\n  __typename\\n}\\n\"}";
            rs = Jsoup.connect((String)"https://admin.pay.naver.com/o/v3/graphql").header("Host", "admin.pay.naver.com").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").header("Origin", "https://admin.pay.naver.com").header("Connection", "keep-alive").header("Content-Type", "application/json").header("Accept", "application/json").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/107.0.0.0 Safari/537.36").requestBody(json).referrer("https://admin.pay.naver.com/o/v3/sale/purchaseDecision").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = rs.body();
            jsonparser = new JsonParser();
            jsonobject = (JsonObject)jsonparser.parse(body);
            JsonObject obj1 = (JsonObject)jsonobject.get("data");
            JsonObject obj2 = (JsonObject)obj1.get("purchaseDecisionList");
            JsonArray jsonArray = (JsonArray)obj2.get("elements");
            if (jsonArray.size() > 0) {
                List<ShopOrderMstDto> param1 = this.getExcelFileManagerJson(param, jsonArray, cookies);
                param1.forEach(d -> d.setResult_code("1"));
                retList.addAll(param1);
            }
            return retList;
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private List<ShopOrderMstDto> getExcelFileManagerJson(List<ShopOrderMstDto> param, JsonArray jsonArray, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = (JsonObject)jsonArray.get(i);
                if (!ShopOrderDao.get().isOrdered(object.get("orderNo").getAsString())) {
                    String ordamt;
                    String orddt;
                    ShopOrderMstDto saveDto = new ShopOrderMstDto();
                    if (object.get("orderStatus").getAsString().equals("WAITING_DISPATCH")) {
                        saveDto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        saveDto.setOrder_id(object.get("orderNo").getAsString());
                        saveDto.setOrder_status(this.getOrderStatus(object.get("productOrderStatus").getAsString()));
                        saveDto.setP_product_name(object.get("productName").getAsString());
                        orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
                        saveDto.setOrder_date(orddt);
                        saveDto.setProduct_name(object.get("productName").getAsString());
                        saveDto.setSale_cnt(object.get("orderQuantity").getAsString());
                        saveDto.setUser_name(object.get("orderMemberName").getAsString());
                        saveDto.setUser_email("");
                        saveDto.setUser_id(object.get("orderMemberId").getAsString());
                        saveDto.setReceive_name(object.get("receiverName").getAsString());
                        saveDto.setShopid(param.get(0).getShopid());
                        saveDto.setShop_userid(param.get(0).getShop_userid());
                        saveDto.setMall_product_id(object.get("productNo").getAsString());
                        saveDto.setReceive_zipcode(this.jsonElementNullStr(object.get("receiverZipCode")));
                        saveDto.setReceive_addr(this.jsonElementNullStr(object.get("receiverAddress")));
                        saveDto.setUser_tel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
                        saveDto.setUser_cel(this.jsonElementNullStr(object.get("orderMemberTelNo")));
                        saveDto.setReceive_tel(this.jsonElementNullStr(object.get("receiverTelNo2")));
                        saveDto.setReceive_cel(this.jsonElementNullStr(object.get("receiverTelNo1")));
                        saveDto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
                        saveDto.setDelv_msg(this.jsonElementNullStr(object.get("productOrderMemo")));
                        saveDto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
                        ordamt = object.get("productPayAmt").getAsString();
                        saveDto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
                        saveDto.setPay_cost(object.get("generalPayAmt").getAsString());
                        saveDto.setTotal_cost(ordamt);
                        saveDto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(saveDto.getSale_cnt())));
                        saveDto.setCompno(param.get(0).getCompno());
                        saveDto.setReceive_email("");
                        saveDto.setWon_cost("0");
                        saveDto.setBox_ea("0");
                        saveDto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        saveDto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        saveDto.setMall_exp_cd(object.get("productOrderNo").getAsString());
                        saveDto.setP_sku_id("");
                        saveDto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
                        saveDto.setResult_code("1");
                        saveDto.setAuthkey1(param.get(0).getAuthkey1());
                        dtolist.add(saveDto);
                    } else if (object.get("orderStatus").getAsString().equals("PURCHASE_DECIDED")) {
                        saveDto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        saveDto.setOrder_id(object.get("orderNo").getAsString());
                        saveDto.setOrder_status("410");
                        saveDto.setP_product_name(object.get("productName").getAsString());
                        orddt = YDMATimeUtil.getDate(object.get("payDateTime").getAsString());
                        saveDto.setOrder_date(orddt);
                        saveDto.setProduct_name(object.get("productName").getAsString());
                        saveDto.setSale_cnt(object.get("orderQuantity").getAsString());
                        saveDto.setUser_name(object.get("orderMemberName").getAsString());
                        saveDto.setUser_email("");
                        saveDto.setUser_id(object.get("orderMemberId").getAsString());
                        saveDto.setReceive_name(object.get("receiverName").getAsString());
                        saveDto.setShopid(param.get(0).getShopid());
                        saveDto.setShop_userid(param.get(0).getShop_userid());
                        saveDto.setMall_product_id(object.get("productNo").getAsString());
                        saveDto.setReceive_zipcode("");
                        saveDto.setReceive_addr("");
                        saveDto.setUser_tel("");
                        saveDto.setUser_cel("");
                        saveDto.setReceive_tel("");
                        saveDto.setReceive_cel("");
                        saveDto.setDelv_cost(this.jsonElementNullStr(object.get("deliveryFeeAmt")));
                        saveDto.setDelv_msg("");
                        saveDto.setDelivery_method_str2(this.getDelivery(this.jsonElementNullStr(object.get("deliveryFeeRatingClass"))));
                        ordamt = object.get("productPayAmt").getAsString();
                        saveDto.setMall_won_cost(this.jsonElementNullStr(object.get("settlementExpectAmt")));
                        saveDto.setPay_cost(Integer.toString(Integer.parseInt(ordamt) + Integer.parseInt(object.get("deliveryFeeAmt").getAsString())));
                        saveDto.setTotal_cost(ordamt);
                        saveDto.setSale_cost(Integer.toString(Integer.parseInt(object.get("productUnitPrice").getAsString()) * Integer.parseInt(saveDto.getSale_cnt())));
                        saveDto.setCompno(param.get(0).getCompno());
                        saveDto.setReceive_email("");
                        saveDto.setWon_cost("0");
                        saveDto.setBox_ea("0");
                        saveDto.setP_sku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        saveDto.setSku_value(this.jsonElementNullStr(object.get("productOptionContents")));
                        saveDto.setMall_exp_cd(object.get("productOrderNo").getAsString());
                        saveDto.setP_sku_id("");
                        saveDto.setCompayny_goods_cd(this.jsonElementNullStr(object.get("sellerProductManagementCode")));
                        saveDto.setResult_code("1");
                        saveDto.setAuthkey1(param.get(0).getAuthkey1());
                        dtolist.add(saveDto);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dtolist;
    }

    public String getRequestBody(String merchantNo, String type, String startDate, String endDate) throws Exception {
        NewOrder newOrder = new NewOrder();
        newOrder.operationName = "findDeliveriesBySummaryInfoType_ForSaleDelivery";
        newOrder.variables.merchantNo = merchantNo;
        newOrder.variables.serviceType = "CHECKOUT";
        newOrder.variables.paging_page = 1;
        newOrder.variables.paging_size = 100;
        newOrder.variables.sort_type = "RECENTLY_ORDER_YMDT";
        newOrder.variables.sort_direction = "DESC";
        newOrder.variables.summaryInfoType = "NEW_ORDERS";
        newOrder.query = "query findDeliveriesBySummaryInfoType_ForSaleDelivery($merchantNo: String!, $paging_page: Int, $paging_size: Int, $serviceType: ServiceType!, $sort_direction: SortDirectionType, $sort_type: SortType, $summaryInfoType: SummaryInfoType) {\n  deliveryList: findDeliveriesBySummaryInfoType_ForSaleDelivery(merchantNo: $merchantNo, paging_page: $paging_page, paging_size: $paging_size, serviceType: $serviceType, sort_direction: $sort_direction, sort_type: $sort_type, summaryInfoType: $summaryInfoType) {\n    elements {\n      ...deliveryElementField\n      __typename\n    }\n    pagination {\n      ...paginationField\n      __typename\n    }\n    __typename\n  }\n}\n\nfragment deliveryElementField on SaleDeliveryMall {\n  deliveryFeeClass\n  generalPayAmt\n  cashPayAmt\n  deliveryInvoiceNo\n  saleCode\n  orderQuantity\n  productName\n  orderAdditionInformationKey\n  payDateTime\n  deliveryDateTime\n  deliveryFeeRatingClass\n  productOrderMemo\n  orderMemberId\n  payLocationType\n  totalDiscountAmt\n  orderNo\n  payMeansClass\n  productClass\n  payAdmissionConfirmType\n  receiverAddress\n  deliveryCompanyName\n  sellerProductManagementCode\n  cartDiscountCouponAmt\n  productOptionCode\n  orderMemberTelNo\n  deliveryFeeAmt\n  claimNo\n  deliveryMethod\n  deliveryMethodPay\n  receiverTelNo2\n  productPayAmt\n  receiverTelNo1\n  orderStatus\n  productUnitPrice\n  waybillPrintDateTime\n  chargeAmtPayAmt\n  payLaterAmt\n  orderOptionContents\n  orderMemberName\n  productOrderNo\n  deliveryCompanyCode\n  productOptionContents\n  dispatchDueDateTime\n  productOptionAmt\n  productNo\n  individualCustomUniqueCode\n  orderDateTime\n  placingOrderDateTime\n  inflowPath\n  receiverName\n  settlementExpectAmt\n  deliveryNo\n  payAdmissionNo\n  sellerDiscountAmt\n  deliveryFeeDiscountAmt\n  dispatchDateTime\n  receiverZipCode\n  checkoutAccmAmtPayAmt\n  payCommissionAmt\n  productOrderStatus\n  sellerOptionManagementCode\n  productUrl\n  syncDateTime\n  __typename\n}\n\nfragment paginationField on Pagination {\n  size\n  totalElements\n  page\n  totalPages\n  __typename\n}\n";
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)newOrder);
    }

    private String getDelivery(String deliveryFeeRatingClass) {
        String value = "";
        switch (deliveryFeeRatingClass) {
            case "PREPAYED": {
                value = "\uc120\uacb0\uc81c";
                break;
            }
            case "FREE": {
                value = "\ubb34\ub8cc";
            }
        }
        return value;
    }

    private String getOrderStatus(String productOrderStatus) {
        String value = "";
        switch (productOrderStatus) {
            case "NEW_ORDER": {
                value = "100";
            }
        }
        return value;
    }

    private class NewOrder {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="paging_page")
            private int paging_page;
            @JsonProperty(value="paging_size")
            private int paging_size;
            @JsonProperty(value="sort_type")
            private String sort_type;
            @JsonProperty(value="sort_direction")
            private String sort_direction;
            @JsonProperty(value="summaryInfoType")
            private String summaryInfoType;

            private Variables() {
            }
        }
    }
}

