/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.mindrot.jbcrypt.BCrypt;

public class NaverStoreGenerateSignature {
    static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();

    public String generateSignature(String clientId, String clientSecret, Long timestamp) {
        String password = String.valueOf(clientId) + "_" + timestamp;
        String hashedPw = BCrypt.hashpw((String)password, (String)clientSecret);
        return Base64.getUrlEncoder().encodeToString(hashedPw.getBytes(StandardCharsets.UTF_8));
    }

    public String accessToken(String secretSign, String clientId, Long timestamp, String grantType, String type) {
        String accessToken = "";
        try {
            FormBody body = new FormBody.Builder().add("client_id", clientId).add("timestamp", String.valueOf(timestamp)).add("client_secret_sign", secretSign).add("grant_type", grantType).add("type", type).build();
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/oauth2/token").post((RequestBody)body).addHeader("Content-Type", "application/x-www-form-urlencoded").addHeader("Accept", "application/json").build();
            try {
                Throwable throwable = null;
                Object var10_11 = null;
                try (Response response = client.newCall(request2).execute();){
                    JsonParser parser = new JsonParser();
                    JsonObject jsonobject = (JsonObject)parser.parse(response.body().string());
                    accessToken = jsonobject.get("access_token").getAsString();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                return "";
            }
        }
        catch (Exception exception) {
            return "";
        }
        return "Bearer " + accessToken;
    }
}

