/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TossShoppingOrderSearchCommand
extends IShopOrderTossShoppingCommand {
    OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    private static IShopOrderCommand instance = new TossShoppingOrderSearchCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private TossShoppingOrderSearchCommand() {
    }

    @Override
    public int Search(String URL2, String startdt, String enddt) throws Exception {
        return super.Search(URL2, startdt, enddt);
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        long range;
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        String start = YDMATimeUtil.getTime(param.get(0).getStartDt());
        String end = YDMATimeUtil.getTime(param.get(0).getEndDt());
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmm");
        Date sdate = formatter.parse(param.get(0).getStartDt());
        Date edate = formatter.parse(param.get(0).getEndDt());
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(2, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            start = String.valueOf(cal2.getTimeInMillis());
            sdate = formatter.parse(formatter.format(cal2.getTime()));
        }
        int num = (int)((range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L) % 30L == 0L ? range / 30L : range / 30L + 1L);
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 29);
            end = String.valueOf(cal2.getTimeInMillis());
        }
        this.searchDeliveryOrder(param, retList, start, end);
        this.searchClaimOrder(param, retList, start, end);
        cal1.add(5, 30);
        cal2.add(5, 30);
        start = String.valueOf(cal1.getTimeInMillis());
        end = String.valueOf(cal2.getTimeInMillis());
        return retList;
    }

    private void searchDeliveryOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        try {
            cookies = is.getTossCookies(param.get(0).getShop_userid(), param.get(0).getShopPw());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String startFormatted = dateFormat.format(new Date(Long.parseLong(start)));
            String endFormatted = dateFormat.format(new Date());
            String url = "https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/order/histories";
            boolean isContirue = true;
            JsonParser parser = new JsonParser();
            while (isContirue) {
                int page = 0;
                String strParam = this.getOrderSyncStringParam(param.get(0).getApikey(), startFormatted, endFormatted, page++);
                RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)strParam);
                Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody).addHeader("Content-Type", "application/json");
                for (Map.Entry<Object, Object> entry : cookies.entrySet()) {
                    requestBuilder.addHeader("Cookie", String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                }
                Request request2 = requestBuilder.build();
                Object object = null;
                Object var19_21 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    if (!response.isSuccessful()) continue;
                    String responseBody = response.body().string();
                    JsonObject body = parser.parse(responseBody).getAsJsonObject();
                    JsonObject successObject = body.getAsJsonObject("success");
                    JsonObject paging = successObject.getAsJsonObject("paging");
                    if (paging.get("totalCount").getAsInt() < 100) {
                        isContirue = false;
                    }
                    JsonArray results = successObject.getAsJsonArray("results");
                    int j = 0;
                    while (j < results.size()) {
                        JsonObject order = results.get(j).getAsJsonObject();
                        String orderId = order.get("orderId").getAsString();
                        for (ShopOrderMstDto dto : param) {
                            if (!dto.getOrder_id().equals(orderId)) continue;
                            dto.setOrder_status("410");
                            dto.setResult_code("1");
                            retList.add(dto);
                        }
                        ++j;
                    }
                }
                catch (Throwable throwable) {
                    if (object == null) {
                        object = throwable;
                    } else if (object != throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                    throw object;
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void searchClaimOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String start, String end) throws Exception {
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        try {
            cookies = is.getTossCookies(param.get(0).getShop_userid(), param.get(0).getShopPw());
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String startFormatted = dateFormat.format(new Date(Long.parseLong(start)));
            String endFormatted = dateFormat.format(new Date());
            String[] types = new String[]{"CANCEL", "EXCHANGE", "RETURN"};
            JsonParser parser = new JsonParser();
            String url = "https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/orders/claims";
            int i = 0;
            while (i < 3) {
                boolean isContirue = true;
                while (isContirue) {
                    int page = 1;
                    String strParam = this.getOrderClaimSyncStringParam(types[i], startFormatted, endFormatted, page++);
                    RequestBody requestBody = RequestBody.create((MediaType)MediaType.get((String)"application/json"), (String)strParam);
                    Request.Builder requestBuilder = new Request.Builder().url(url).post(requestBody).addHeader("Content-Type", "application/json").addHeader("X-Merchant-id", param.get(0).getApikey());
                    for (Map.Entry<Object, Object> entry : cookies.entrySet()) {
                        requestBuilder.addHeader("Cookie", String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue());
                    }
                    Request request2 = requestBuilder.build();
                    Object object = null;
                    Object var21_23 = null;
                    try (Response response = this.client.newCall(request2).execute();){
                        JsonObject claim;
                        int j;
                        JsonArray claims;
                        if (!response.isSuccessful()) continue;
                        String responseBody = response.body().string();
                        JsonObject body = parser.parse(responseBody).getAsJsonObject();
                        JsonObject successObject = body.getAsJsonObject("success");
                        JsonObject paging = successObject.getAsJsonObject("paging");
                        if (paging.get("totalCount").getAsInt() < 50) {
                            isContirue = false;
                        }
                        if ((claims = successObject.getAsJsonArray("claims")).size() == 0) continue;
                        if (i == 0) {
                            j = 0;
                            while (j < claims.size()) {
                                claim = claims.get(j).getAsJsonObject();
                                this.processClaim(claim, param, retList, "C01", "C02");
                                ++j;
                            }
                            continue;
                        }
                        if (i == 1) {
                            j = 0;
                            while (j < claims.size()) {
                                claim = claims.get(j).getAsJsonObject();
                                this.processClaim(claim, param, retList, "E01", "E02");
                                ++j;
                            }
                            continue;
                        }
                        j = 0;
                        while (j < claims.size()) {
                            claim = claims.get(j).getAsJsonObject();
                            this.processClaim(claim, param, retList, "R01", "R02");
                            ++j;
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private void processClaim(JsonObject claim, List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, String requestedStatus, String closedStatus) {
        JsonObject order = claim.get("order").getAsJsonObject();
        String orderId = order.get("id").getAsString();
        for (ShopOrderMstDto dto : param) {
            if (!dto.getOrder_id().equals(orderId)) continue;
            if (claim.get("status").getAsString().equals("REQUESTED") || claim.get("status").getAsString().equals("COLLECTING") || claim.get("status").getAsString().equals("COLLECTED") || claim.get("status").getAsString().equals("DELIVERING")) {
                dto.setOrder_status(requestedStatus);
                dto.setResult_code("1");
                retList.add(dto);
                continue;
            }
            dto.setOrder_status(closedStatus);
            dto.setResult_code("1");
            retList.add(dto);
            try {
                ShopOrderMstDto temp = dto.clone(closedStatus);
                String canceledAt = claim.get("requestedDate").getAsString();
                String orddt = this.formatDateString(canceledAt);
                temp.setOrder_date(orddt);
                retList.add(temp);
            }
            catch (Exception exception) {}
        }
    }

    private String getOrderSyncStringParam(String merchantId, String startDate, String endDate, int page) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("merchantId", merchantId);
        json.addProperty("startDate", startDate);
        json.addProperty("endDate", endDate);
        json.addProperty("page", (Number)page);
        json.addProperty("pageSize", (Number)100);
        JsonArray statuses = new JsonArray();
        statuses.add("\ubc30\uc1a1\uc644\ub8cc");
        statuses.add("\uad6c\ub9e4\ud655\uc815");
        json.add("statuses", (JsonElement)statuses);
        json.addProperty("queryType", "ORDER_ID");
        json.addProperty("query", "");
        return json.toString();
    }

    private String getOrderClaimSyncStringParam(String type, String startDate, String endDate, int page) throws Exception {
        JsonObject json = new JsonObject();
        json.addProperty("type", type);
        json.addProperty("page", (Number)page);
        json.addProperty("fromRequestDate", startDate);
        json.addProperty("toRequestDate", endDate);
        JsonArray statuses = new JsonArray();
        statuses.add("REQUESTED");
        statuses.add("COLLECTING");
        statuses.add("COLLECTED");
        statuses.add("DELIVERING");
        statuses.add("COMPLETED");
        json.add("statuses", (JsonElement)statuses);
        json.addProperty("pageSize", (Number)50);
        return json.toString();
    }

    private String formatDateString(String dateStr) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime dateTime = LocalDateTime.parse(dateStr, inputFormatter);
        return dateTime.format(outputFormatter);
    }
}

