/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.shop.ImageUpload.ImageTransformParams;
import com.kdjsystem.mlink.shop.ImageUpload.UnifiedUploadManager;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.MarketPriceCalc;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.common.ShopWorkDataQueue;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShopProductTossShoppingAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDao;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.shop.dao.WorkmgrlogDao;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.tot.common.YDMAProperties;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TossShoppingProductRegService
implements IProduct {
    private int merchantId = 0;
    private int merchantUserId = 0;
    JsonParser jsonParser = new JsonParser();
    IShopCommonLogin is = new IShopCommonLogin(){};

    @Override
    public ShopProductSendDto excute(ShopProductSendDto sendProdList) throws Exception {
        ShopProductTossShoppingAdditionDto dtllist = null;
        ShoppingMallDetailDto shoppingMallDetailDto = sendProdList.getShoppingMallDetailDto();
        List<ShopProductDto> prodList = sendProdList.getShopProductDto();
        WorkMngDto workMngDto = sendProdList.getWorkMngDto();
        workMngDto.setWork_startdate(YDMATimeUtil.getCurrentTimeByYDFormat());
        String uuid = sendProdList.getWorkgrp();
        if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
            workMngDto.setWork_status("W02");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            return sendProdList;
        }
        dtllist = (ShopProductTossShoppingAdditionDto)sendProdList.getProductAdditionDto();
        int progress = workMngDto.getProgress_rate();
        List<WorkMngDetailDto> workMngDetailDtos = workMngDto.getWork_detail();
        String loginID = shoppingMallDetailDto.getShoppingid();
        String password = shoppingMallDetailDto.getPassword();
        String authkey1 = shoppingMallDetailDto.getAuthkey1();
        double mod = 0.0;
        double rate = 0.0;
        try {
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            mod = sendProdList.isManual() ? (double)conf.getProccnt() / (double)prodList.size() : 100.0 / (double)prodList.size();
            workMngDto.setWork_status("W06");
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
            for (ShopProductDto dto : prodList) {
                if ((int)(rate += mod) > 0) {
                    progress += (int)rate;
                    rate = 0.0;
                }
                workMngDto.setProgress_rate(progress);
                workMngDto.setWork_status("W08");
                ShopWorkDataQueue.get().notifyObservers();
                WorkMngDetailDto workMngDetailDto = workMngDetailDtos.stream().filter(p -> p.getProdseq().equals(dto.getCompayny_goods_cd())).findAny().orElse(null);
                if (!ShopWorkDataQueue.get().isExistGrp(uuid)) {
                    workMngDetailDto.setStatus("W02");
                    workMngDetailDto.setMessage("\ucde8\uc18c \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    continue;
                }
                if (workMngDetailDto.getStatus().equals("W06")) continue;
                if (workMngDto.getWork_status().equals("W02")) {
                    ShopProductSendDto shopProductSendDto = sendProdList;
                    return shopProductSendDto;
                }
                try {
                    try {
                        String matched = IProduct.findFirstForbiddenKeyword(dto, shoppingMallDetailDto.getForbiddenKeywords());
                        if (matched != null) {
                            throw new IllegalArgumentException(String.format("\uae08\uc9c0 \ud0a4\uc6cc\ub4dc '%s'\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc0c1\ud488\uba85=\"%s\", \uac80\uc0c9 \ud0a4\uc6cc\ub4dc=\"%s\"", matched, dto.getGoods_nm(), dto.getGoods_search()));
                        }
                        if (dtllist.getImgTextExcludeYN().equals("Y")) {
                            boolean hasText = false;
                            hasText = this.imageTextSearch(dto);
                            if (hasText) {
                                throw new IllegalArgumentException("\uc774\ubbf8\uc9c0\uc5d0 \ud14d\uc2a4\ud2b8\uac00 \uac10\uc9c0\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                            }
                        }
                        ArrayList<String> strImages = new ArrayList();
                        ImageTransformParams params = new ImageTransformParams();
                        params.setShopProductDto(dto);
                        params.setChangesize(dtllist.getChangesize());
                        params.setChangeSizeX(dtllist.getChangeSizeX());
                        params.setChangeSizeY(dtllist.getChangeSizeY());
                        params.setChangeSizeW(dtllist.getChangeSizeW());
                        params.setChangeSizeH(dtllist.getChangeSizeH());
                        params.setAngle(dtllist.getAngle());
                        params.setScalePercent(dtllist.getScalePercent());
                        params.setImgThreeOnFour(dtllist.getImgThreeOnFour());
                        params.setRemoveImgTextYN(dtllist.getRemoveImgTextYN());
                        params.setMirrorImgYN(dtllist.getMirrorImgYN());
                        params.setImageresize("");
                        params.setImageresize1("");
                        UnifiedUploadManager manager = new UnifiedUploadManager();
                        strImages = manager.processAndUploadImages(params);
                        String json = this.MakeProductJson(dto, dtllist, loginID, password, strImages, authkey1, shoppingMallDetailDto);
                        this.ProductRegSend(dto, json, loginID, password);
                        if (!dto.getShopprodno().equals("")) {
                            dto.setResult_code("1");
                            workMngDetailDto.setStatus("W06");
                            workMngDetailDto.setMessage(String.valueOf(shoppingMallDetailDto.getShopnm()) + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4. [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            dto.setShopprodno(dto.getShopprodno());
                            dto.setResult_text(String.valueOf(shoppingMallDetailDto.getShopnm()) + "\uc5d0 \uc0c1\ud488\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ub4f1\ub85d \ub418\uc5c8\uc2b5\ub2c8\ub2e4. [\uc0c1\ud488\ubc88\ud638 : " + dto.getShopprodno() + " ]");
                            sendProdList.setShopProductDto(Arrays.asList(dto));
                            WorkMngDao.get().saveProductIn(sendProdList);
                        } else {
                            workMngDto.setWork_status("-1");
                            workMngDetailDto.setStatus("-1");
                            workMngDetailDto.setMessage(dto.getResult_text());
                            dto.setResult_code("-1");
                            dto.setResult_text(dto.getResult_text());
                        }
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                    }
                    catch (Exception e) {
                        workMngDto.setWork_status("-1");
                        workMngDetailDto.setStatus("-1");
                        workMngDetailDto.setMessage(e.getMessage());
                        dto.setResult_code("-1");
                        dto.setResult_text(e.getMessage());
                        WorkMngDao.get().saveDtl(uuid, workMngDetailDto);
                        continue;
                    }
                    InterruptSource.Thread.sleep((long)5000L);
                    if (!conf.getSaveproductlogyn().equals("Y")) continue;
                    ArrayList<String> sendList = new ArrayList<String>();
                    sendList.add(uuid);
                    sendList.add(dto.getShopcd());
                    sendList.add(shoppingMallDetailDto.getShopnm());
                    sendList.add(dto.getShopseq());
                    sendList.add(loginID);
                    sendList.add(shoppingMallDetailDto.getNicknm1());
                    sendList.add(workMngDetailDto.getSeq());
                    sendList.add(dto.getCompayny_goods_cd());
                    sendList.add(workMngDetailDto.getStatus());
                    sendList.add(workMngDetailDto.getMessage());
                    sendList.add(dtllist.getSeq());
                    sendList.add(dtllist.getTitle());
                    sendList.add(dtllist.getImgOneOnOne());
                    sendList.add(String.valueOf(dtllist.getSellerDc()));
                    sendList.add(String.valueOf(dtllist.getMargin()));
                    sendList.add(String.valueOf(dtllist.getCommdc()));
                    sendList.add(dtllist.getChangeSizeX());
                    sendList.add(dtllist.getChangeSizeY());
                    sendList.add(dtllist.getChangeSizeW());
                    sendList.add(dtllist.getChangeSizeH());
                    sendList.add(String.valueOf(dtllist.getAngle()));
                    sendList.add(String.valueOf(dtllist.getScalePercent()));
                    sendList.add(dtllist.getMirrorImgYN());
                    sendList.add(dto.getGoods_keyword());
                    sendList.add(dto.getClass_cd3());
                    sendList.add(dto.getClass_nm1());
                    sendList.add(YDMATimeUtil.getCurrentTimeByYDFormat());
                    sendList.add(dto.getGoods_cost());
                    sendList.add(dto.getDelv_cost());
                    sendList.add(dto.getGoods_search());
                    sendList.add("0");
                    WorkmgrlogDao.get().insertWorkLog(sendList);
                    continue;
                }
                catch (Exception exception) {
                    workMngDto.setWork_status("-1");
                }
                break;
            }
        }
        finally {
            workMngDto.setWork_enddate(YDMATimeUtil.getCurrentTimeByYDFormat());
            WorkMngDao.get().saveMst(uuid, sendProdList.getWorkMngDto());
        }
        return sendProdList;
    }

    protected boolean imageTextSearch(ShopProductDto dto) {
        try {
            List<ShopProductDto> filteredList = this.detectTextInImage(dto);
            return !filteredList.isEmpty();
        }
        catch (Exception e) {
            throw new RuntimeException("\uc774\ubbf8\uc9c0 \ud14d\uc2a4\ud2b8 \uac10\uc9c0 \uc911 \uc624\ub958 \ubc1c\uc0dd", e);
        }
    }

    private List<ShopProductDto> detectTextInImage(ShopProductDto dto) {
        String imagePath;
        String exeDirectory;
        List<ShopProductDto> filteredList;
        block7: {
            String exePath;
            filteredList = new ArrayList<ShopProductDto>();
            String basePath = YDMASessonUtil.getAppPath("");
            exeDirectory = exePath = String.valueOf(basePath) + YDMAProperties.getInstance().getAppProperty("Product.imageChangePath").replace("/", File.separator);
            imagePath = "";
            String imageUrls = dto.getImg_path();
            if (imageUrls == null || imageUrls.equals("") || !(imagePath = this.writeImageLocalFolder(dto, imageUrls, exeDirectory)).equals("")) break block7;
            return null;
        }
        try {
            if (!imagePath.isEmpty()) {
                filteredList = this.execTextDetection(imagePath, exeDirectory, dto);
            }
        }
        catch (InterruptedException interruptedException) {
            YDMAStringUtil.Print("\uc791\uc5c5\uc774 \uc0ac\uc6a9\uc790\uc5d0 \uc758\ud574 \ucde8\uc18c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
        }
        catch (Exception exception) {}
        if (filteredList.size() > 0) {
            YDMAStringUtil.Print("\ud14d\uc2a4\ud2b8\uac00 \uc788\ub294 \uc774\ubbf8\uc9c0\uc785\ub2c8\ub2e4.");
        } else {
            YDMAStringUtil.Print("\ud14d\uc2a4\ud2b8\uac00 \uc5c6\ub294 \uc774\ubbf8\uc9c0\uc785\ub2c8\ub2e4.");
        }
        return filteredList;
    }

    private List<ShopProductDto> execTextDetection(String imagePath, String exeDirectory, ShopProductDto dto) throws Exception {
        ArrayList<ShopProductDto> resultList = new ArrayList();
        Process process = null;
        try {
            try {
                String exeFile = String.valueOf(exeDirectory) + File.separator + YDMAProperties.getInstance().getAppProperty("Product.imageChangeFile");
                process = this.imgexec(imagePath, exeFile, exeDirectory, "0");
                this.waitResult(process);
                int exitCode = process.waitFor();
                if (exitCode != 0) {
                    throw new RuntimeException("\ud504\ub85c\uc138\uc2a4\uac00 \ube44\uc815\uc0c1 \uc885\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc885\ub8cc \ucf54\ub4dc: " + exitCode);
                }
                resultList = this.getFilteredResults(imagePath, dto, exeDirectory, process);
            }
            catch (Exception ex) {
                throw new RuntimeException("\ud14d\uc2a4\ud2b8 \uac10\uc9c0 \ucc98\ub9ac \uc911 \uc608\uae30\uce58 \ubabb\ud55c \uc624\ub958 \ubc1c\uc0dd", ex);
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
        return resultList;
    }

    @Override
    public void waitResult(Process activeProcess) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(activeProcess.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("ETA: 0s")) continue;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private List<ShopProductDto> getFilteredResults(String imagePath, ShopProductDto dto, String exeDirectory, Process activeProcess) throws Exception {
        ArrayList<ShopProductDto> filteredList = new ArrayList<ShopProductDto>();
        int exitCode = activeProcess.waitFor();
        boolean hasText = false;
        if (exitCode == 0) {
            if (!imagePath.equals("empty_placeholder.jpg")) {
                File outputFile = new File(exeDirectory, "out_" + imagePath);
                if (outputFile.exists()) {
                    hasText = true;
                }
                new File(exeDirectory, imagePath).delete();
            }
            if (hasText) {
                filteredList.add(dto);
            }
        }
        return filteredList;
    }

    private Process imgexec(String imagePath, String exeFile, String exeDirectory, String type) throws IOException {
        String imagesToProcess = String.join((CharSequence)",", imagePath);
        String commandImagesArg = String.format("\"%s,%s\"", type, imagesToProcess);
        ProcessBuilder builder = new ProcessBuilder(exeFile, "-l", commandImagesArg);
        builder.directory(new File(exeDirectory));
        builder.redirectErrorStream(true);
        return builder.start();
    }

    private String writeImageLocalFolder(ShopProductDto dto, String imageUrl, String exeDirectory) throws Exception {
        BufferedImage bufferedImage;
        String imagePath;
        block19: {
            imagePath = "";
            String domeCode = dto.getGoods_keyword();
            bufferedImage = null;
            URL url = new URL(imageUrl);
            if (imageUrl.startsWith("http") || imageUrl.startsWith("https")) {
                if (domeCode.equals("shop0120")) {
                    URLConnection connection = url.openConnection();
                    connection.setRequestProperty("User-Agent", "Mozilla/5.0");
                    connection.connect();
                    Throwable throwable = null;
                    Object var10_13 = null;
                    try (InputStream in = connection.getInputStream();){
                        bufferedImage = ImageIO.read(in);
                        break block19;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                bufferedImage = ImageIO.read(url);
                if (bufferedImage == null) {
                    bufferedImage = ImageIO.read(url);
                }
            } else {
                File file = new File(imageUrl);
                bufferedImage = ImageIO.read(file);
            }
        }
        if (bufferedImage != null) {
            if (bufferedImage.getType() != 1) {
                BufferedImage rgbImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 1);
                Graphics2D g = rgbImage.createGraphics();
                g.drawImage((java.awt.Image)bufferedImage, 0, 0, null);
                g.dispose();
                bufferedImage = rgbImage;
            }
            String fileName = String.valueOf(dto.getCompayny_goods_cd()) + ".jpg";
            File outputfile = new File(String.valueOf(exeDirectory) + File.separator + fileName);
            ImageIO.write((RenderedImage)bufferedImage, "jpg", outputfile);
            imagePath = fileName;
        }
        return imagePath;
    }

    private String MakeProductJson(ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, String loginID, String password, List<String> strImages, String authkey1, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String json = "";
        try {
            ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
            ObjectMapper mapper = new ObjectMapper();
            TossProductReg tosReg = new TossProductReg();
            tosReg.managementCode = dto.getCompayny_goods_cd();
            Map<String, String> cookies = this.BasicInfoSetting(tosReg, dtllist, dto, loginID, password, authkey1);
            this.CategorySetting(tosReg, dtllist, dto, cookies);
            this.ProductNameSetting(tosReg, dtllist, dto);
            resultMarketPrice = this.PriceSetting(dto, dtllist, resultMarketPrice);
            this.OptionSetting(tosReg, dtllist, dto, resultMarketPrice, cookies);
            this.ImageSetting(tosReg, dtllist, dto, strImages, cookies, loginID, password);
            this.DeiliverySetting(tosReg, dtllist, dto);
            this.ExchangeReturnSetting(tosReg, dtllist, dto);
            this.ExposureSetting(tosReg, dtllist, dto, shoppingMallDetailDto);
            this.GosiSetting(tosReg, dtllist, dto);
            this.GoodsRemarkSetting(tosReg, dtllist, dto);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
            json = mapper.writeValueAsString((Object)tosReg);
            YDMAStringUtil.Print(json);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private void ProductRegSend(ShopProductDto dto, String json, String loginID, String password) throws Exception {
        Connection.Response rs = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/shopping-internal/merchants/products").header("Content-Type", "application/json").header("X-Merchant-Id", String.valueOf(this.merchantId)).header("X-Merchant-User-Id", String.valueOf(this.merchantUserId)).header("Content-Type", "application/json").cookies(this.is.getTossCookies(loginID, password)).timeout(15000).requestBody(json).method(Connection.Method.POST).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonObject = (JsonObject)this.jsonParser.parse(rs.body());
        String resultType = jsonObject.get("resultType").getAsString();
        if (resultType.equals("SUCCESS")) {
            JsonObject success = (JsonObject)jsonObject.get("success");
            dto.setShopprodno(success.get("id").getAsString());
        } else {
            JsonObject error = (JsonObject)jsonObject.get("error");
            dto.setResult_text("\uc0c1\ud488 \ub4f1\ub85d \uc2e4\ud328 : " + this.getErrorMessage(error.get("reason").getAsString()));
        }
    }

    private Map<String, String> BasicInfoSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, String loginID, String password, String authkey1) throws Exception {
        HashMap<String, String> cookies = new HashMap();
        try {
            JsonArray merchantMappingArray;
            JsonObject success;
            cookies = this.is.getTossCookies(loginID, password);
            Connection.Response rs = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/my-info").cookies(cookies).method(Connection.Method.GET).timeout(15000).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonObject = (JsonObject)this.jsonParser.parse(rs.body());
            String resultType = jsonObject.get("resultType").getAsString();
            if (resultType.equals("SUCCESS")) {
                success = (JsonObject)jsonObject.get("success");
                merchantMappingArray = (JsonArray)success.get("merchantMappingInfo");
                if (authkey1.equals("")) {
                    throw new Exception("\uc0c1\ud488\ub4f1\ub85d \uc911 \uc720\uc800 \uc815\ubcf4\ub97c \ubabb \uac00\uc838\uc624\ub294 \uc5d0\ub7ec \ubc1c\uc0dd :\uc0ac\uc5c5\uc790 \ub85c\uadf8\uc778 \uc21c\uc11c \uac12\uc774 \ube44\uc5b4\uc788\uc2b5\ub2c8\ub2e4.");
                }
            } else {
                JsonObject error = (JsonObject)jsonObject.get("error");
                throw new Exception("\uc0c1\ud488\ub4f1\ub85d \uc911 \uc720\uc800 \uc815\ubcf4\ub97c \ubabb \uac00\uc838\uc624\ub294 \uc5d0\ub7ec \ubc1c\uc0dd [" + this.getErrorMessage(error.get("reason").getAsString()) + "]");
            }
            JsonObject merchantMappingInfo = Integer.parseInt(authkey1) == 0 ? merchantMappingArray.get(0).getAsJsonObject() : merchantMappingArray.get(Integer.parseInt(authkey1) - 1).getAsJsonObject();
            JsonObject merchantUser = (JsonObject)success.get("merchantUser");
            tosReg.isTaxFree = !dto.getTax_yn().equals("0");
            tosReg.isCultureDeduction = false;
            this.merchantId = merchantMappingInfo.get("merchantId").getAsInt();
            this.merchantUserId = merchantUser.get("id").getAsInt();
        }
        catch (Exception e) {
            throw new Exception(e.getMessage(), e);
        }
        return cookies;
    }

    private void CategorySetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, Map<String, String> cookies) throws Exception {
        try {
            if (MLinkCommon.get().isNotNullEmpty(dtllist.getShopcatno())) {
                tosReg.categoryId = Integer.parseInt(dtllist.getShopcatno());
                return;
            }
            if (MLinkCommon.get().isNotNullEmpty(dto.getShopCid())) {
                tosReg.categoryId = Integer.parseInt(dto.getShopCid());
            } else {
                String[] parts = dto.getGmcategnm().split(">");
                if (parts.length == 0) {
                    throw new Exception("\uce74\ud14c\uace0\ub9ac \uc218\uc9d1 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [\uce74\ud14c\uace0\ub9ac\uba85 \uc5c6\uc74c]");
                }
                String[] stringArray = parts;
                int n = parts.length;
                int n2 = 0;
                while (n2 < n) {
                    JsonArray jsonArray;
                    String element = stringArray[n2];
                    Connection.Response rs = Jsoup.connect((String)("https://api-public.toss.im/api-public/v2/shopping-internal/products/categories?name=" + URLEncoder.encode(element, "UTF-8") + "&page=0&pageSize=30&versionFilter=V2")).cookies(cookies).header("Connection", "keep-alive").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/129.0.0.0 Safari/537.36").timeout(15000).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                    JsonObject jsonObject = (JsonObject)this.jsonParser.parse(rs.body());
                    String resultType = jsonObject.get("resultType").getAsString();
                    if (resultType.equals("SUCCESS") && (jsonArray = jsonObject.getAsJsonObject("success").getAsJsonArray("items")) != null && jsonArray.size() != 0) {
                        int i = 0;
                        while (i < jsonArray.size()) {
                            JsonObject data2 = (JsonObject)jsonArray.get(i);
                            if (data2.get("isSellable").getAsBoolean()) {
                                int categoryId = data2.get("id").getAsInt();
                                tosReg.categoryId = categoryId;
                                return;
                            }
                            ++i;
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void ImageSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, List<String> strImages, Map<String, String> cookies, String loginID, String password) throws Exception {
        String imgpath = ShopCommon.getImgLocalPath(strImages.get(0));
        File jpgFile = new File(imgpath);
        FileInputStream jpgFs = new FileInputStream(jpgFile);
        try {
            Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/ml/text-logo").cookies(cookies).header("Content-Type", "multipart/form-data").method(Connection.Method.POST).data("file", jpgFile.getName(), (InputStream)jpgFs).timeout(20000).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonObject = (JsonObject)this.jsonParser.parse(response.body());
            String resultType = jsonObject.get("resultType").getAsString();
            if (!resultType.equals("SUCCESS")) {
                JsonObject error = (JsonObject)jsonObject.get("error");
                throw new Exception("[text-logo] \uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [" + this.getErrorMessage(error.get("reason").getAsString()) + "]");
            }
            Connection.Response rs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products/files/upload-url").header("Content-Type", "application/json").cookies(cookies).requestBody("{\"merchantId\":" + this.merchantId + ",\"fileExtension\":\"jpeg\"}").method(Connection.Method.POST).timeout(20000).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            jsonObject = (JsonObject)this.jsonParser.parse(rs.body());
            resultType = jsonObject.get("resultType").getAsString();
            if (!resultType.equals("SUCCESS")) {
                JsonObject error = (JsonObject)jsonObject.get("error");
                throw new Exception("[upload-url] \uc774\ubbf8\uc9c0 \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [" + this.getErrorMessage(error.get("reason").getAsString()) + "]");
            }
            JsonObject success = (JsonObject)jsonObject.get("success");
            String changedImgPath = imgpath.replace(".jpg", ".jpeg");
            this.convertJpgToJpeg(imgpath, changedImgPath);
            String fileUploadUrl = success.get("fileUploadUrl").getAsString();
            File jpegFile = new File(changedImgPath);
            FileInputStream jpegFs = new FileInputStream(jpegFile);
            URL url = new URL(fileUploadUrl);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("PUT");
            connection.setConnectTimeout(20000);
            connection.setReadTimeout(20000);
            connection.setRequestProperty("Origin", "https://shopping-seller.toss.im");
            connection.setRequestProperty("Content-Type", "image/jpeg");
            connection.setRequestProperty("Content-Length", String.valueOf(jpegFile.length()));
            OutputStream outputStream = connection.getOutputStream();
            byte[] buffer = new byte[4096];
            while (true) {
                int bytesRead;
                if ((bytesRead = jpegFs.read(buffer)) == -1) {
                    outputStream.flush();
                    outputStream.close();
                    jpegFs.close();
                    int responseCode = connection.getResponseCode();
                    YDMAStringUtil.Print("AWS \uc0c1\ud488\ub4f1\ub85d : " + responseCode);
                    Image image = new Image();
                    image.type = "THUMBNAIL";
                    image.url = success.get("fileUrl").getAsString();
                    image.order = 0;
                    tosReg.images.add(image);
                    if (dtllist.getUseADImgYN().equals("Y")) break;
                    return;
                }
                outputStream.write(buffer, 0, bytesRead);
            }
            String adImagePath = String.valueOf(imgpath.replace(".jpg", "")) + "_AD" + ".jpg";
            this.convertADImage(imgpath, adImagePath);
            File adImageFile = new File(adImagePath);
            FileInputStream adImageFs = new FileInputStream(adImageFile);
            Connection.Response adImageResponse = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/ml/text-logo").cookies(cookies).header("Content-Type", "multipart/form-data").method(Connection.Method.POST).timeout(20000).data("file", adImageFile.getName(), (InputStream)adImageFs).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonObject adObject = (JsonObject)this.jsonParser.parse(adImageResponse.body());
            if (!adObject.get("resultType").getAsString().equals("SUCCESS")) return;
            Connection.Response checkRs = Jsoup.connect((String)"https://api-public.toss.im/api-public/v2/shopping-internal/products/files/upload-url").header("Content-Type", "application/json").cookies(cookies).requestBody("{\"merchantId\":" + this.merchantId + ",\"fileExtension\":\"jpeg\"}").method(Connection.Method.POST).timeout(20000).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            adObject = (JsonObject)this.jsonParser.parse(checkRs.body());
            if (!adObject.get("resultType").getAsString().equals("SUCCESS")) return;
            JsonObject success2 = (JsonObject)adObject.get("success");
            String changedAdImgPath = adImagePath.replace(".jpg", ".jpeg");
            this.convertJpgToJpeg(adImagePath, changedAdImgPath);
            String fileUploadUrl2 = success2.get("fileUploadUrl").getAsString();
            File jpegAdFile = new File(changedAdImgPath);
            FileInputStream jpegAdFs = new FileInputStream(jpegAdFile);
            URL url2 = new URL(fileUploadUrl2);
            HttpURLConnection connection2 = (HttpURLConnection)url2.openConnection();
            connection2.setDoOutput(true);
            connection2.setRequestMethod("PUT");
            connection2.setConnectTimeout(20000);
            connection2.setReadTimeout(20000);
            connection2.setRequestProperty("Origin", "https://shopping-seller.toss.im");
            connection2.setRequestProperty("Content-Type", "image/jpeg");
            connection2.setRequestProperty("Content-Length", String.valueOf(jpegAdFile.length()));
            OutputStream outputStream2 = connection2.getOutputStream();
            byte[] buffer2 = new byte[4096];
            while (true) {
                int bytesRead;
                if ((bytesRead = jpegAdFs.read(buffer2)) == -1) {
                    outputStream2.flush();
                    outputStream2.close();
                    jpegAdFs.close();
                    int responseCode = connection2.getResponseCode();
                    YDMAStringUtil.Print("AWS \ucd94\uac00\uc0c1\ud488\ub4f1\ub85d : " + responseCode);
                    Image image = new Image();
                    image.type = "AD";
                    image.url = success2.get("fileUrl").getAsString();
                    image.order = 0;
                    tosReg.images.add(image);
                    return;
                }
                outputStream2.write(buffer2, 0, bytesRead);
            }
        }
        catch (IOException e) {
            throw new Exception("[ImageSetting]\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [" + e + "]");
        }
    }

    private void convertJpgToJpeg(String inputImagePath, String outputImagePath) throws Exception {
        File inputFile = new File(inputImagePath);
        BufferedImage image = ImageIO.read(inputFile);
        BufferedImage rgbImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
        rgbImage.createGraphics().drawImage((java.awt.Image)image, 0, 0, null);
        File outputFile = new File(outputImagePath);
        ImageIO.write((RenderedImage)rgbImage, "jpeg", outputFile);
    }

    private void convertADImage(String inputImagePath, String adImagePath) throws Exception {
        File inputFile = new File(inputImagePath);
        BufferedImage image = ImageIO.read(inputFile);
        java.awt.Image resizeImage = image.getScaledInstance(600, 240, 4);
        BufferedImage bufferedImage = new BufferedImage(600, 240, 4);
        Graphics2D graphics = (Graphics2D)bufferedImage.getGraphics();
        graphics.setBackground(Color.WHITE);
        graphics.drawImage(resizeImage, 0, 0, null);
        graphics.dispose();
        ImageIO.write((RenderedImage)bufferedImage, "jpg", new File(adImagePath));
    }

    private void ProductNameSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) throws Exception {
        String value = IProduct.formatProductNameByCode(dtllist.getProdnmoutput(), dto);
        if (!dtllist.getProdnmaddfront().equals("")) {
            value = dtllist.getProdnmaddfront().concat(value);
        }
        if (!dtllist.getProdnmaddback().equals("")) {
            value = value.concat(" ").concat(dtllist.getProdnmaddback());
        }
        if (dtllist.getProdnmafter().equals("Y")) {
            value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 99);
        }
        if (dtllist.getProdnmrand().equals("Y")) {
            value = ShopCommon.setWordRandomGenerator(value);
        }
        if (dto.getProdnmlenyn().equals("Y")) {
            tosReg.name = YDMAStringUtil.setTextStrtok(value, 99);
        } else {
            tosReg.name = value;
        }
    }

    private ResultMarketPrice PriceSetting(ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, ResultMarketPrice resultMarketPrice) throws Exception {
        try {
            String price_cost;
            if (dtllist.getPriceAddDeliveryCostYN().equals("Y")) {
                if (dtllist.getExpprc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dtllist.getExpprc()));
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = MarketPriceCalc.get().setCompliancePrice(limit_price).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDc()).setDc(dtllist.getDcrate()).setFlatDc(dtllist.getFlatdc()).setMargin(dtllist.getMargindc()).setCommission(dtllist.getCommdc()).calculate();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            return resultMarketPrice;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc0c1\ud0dc, \ud310\ub9e4\uac00 \ub4f1\ub85d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private int getPriceAfterOptionCharges(ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, String amt, String limitPrice) throws Exception {
        try {
            String price_cost;
            if (dtllist.getPriceAddDeliveryCostYN().equals("Y") && dtllist.getDeliveryType().equals("F")) {
                if (dtllist.getExpprc().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dtllist.getExpprc()));
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            price_cost = String.valueOf(Integer.parseInt(price_cost) + Integer.parseInt(amt));
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            ResultMarketPrice priceAfterOptionChacrge = MarketPriceCalc.get().setCompliancePrice(Integer.parseInt(limitPrice)).setTestPrice(salePrice.longValue()).setSellerDc(dtllist.getSellerDc()).setDc(dtllist.getDcrate()).setFlatDc(dtllist.getFlatdc()).setMargin(dtllist.getMargindc()).setCommission(dtllist.getCommdc()).calculate();
            return Integer.parseInt(priceAfterOptionChacrge.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\uc635\uc158\ucd94\uac00\uae08\uc561 \uc138\ud305 \uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void OptionSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, ResultMarketPrice resultMarketPrice, Map<String, String> cookies) throws Exception {
        ArrayList<String> recommendedOptions = new ArrayList();
        int categoryId = tosReg.categoryId;
        try {
            recommendedOptions = this.fetchRecommendedOptionsByCategory(categoryId, cookies);
        }
        catch (Exception e) {
            throw new Exception("\ucd94\ucc9c \uc635\uc158 \ubd88\ub7ec\uc624\uae30 \uc2e4\ud328: " + e.getMessage());
        }
        if ("\ub2e8\ud488".equals(dto.getChar_1_nm())) {
            this.createSingleStock(dto, dtllist, recommendedOptions, tosReg);
            return;
        }
        recommendedOptions = recommendedOptions.stream().map(option2 -> option2.contains(",") ? option2.split(",")[0] : option2).collect(Collectors.toList());
        List<ShopOptionDto> optionList = this.getProductOptions(dto);
        ArrayList<String> amtList = new ArrayList<String>();
        ArrayList<String> option1List = new ArrayList<String>();
        ArrayList<String> option2List = new ArrayList<String>();
        ArrayList<String> option3List = new ArrayList<String>();
        ArrayList<String> limitPriceList = new ArrayList<String>();
        for (ShopOptionDto opt : optionList) {
            boolean isSoldOut;
            String optSpec = opt.getOptspecdes();
            boolean bl = isSoldOut = opt.getName().contains("\ud488\uc808") || optSpec.contains("\ud488\uc808") || "0".equals(opt.getCnt());
            if (isSoldOut) continue;
            amtList.add(opt.getAmt());
            limitPriceList.add(opt.getLimit_price());
            String[] options = optSpec.split(":");
            if (options.length > 0) {
                option1List.add(options[0]);
            }
            if (options.length > 1) {
                option2List.add(options[1]);
            }
            if (options.length <= 2) continue;
            option3List.add(options[2]);
        }
        int optionDepth = this.getOptionDepth(option1List, option2List, option3List);
        String optionNameRaw = optionList.get(0).getName().replaceAll("&", "");
        String[] optionNames = optionNameRaw.split(":");
        switch (optionDepth) {
            case 1: {
                String actual = optionNames[0];
                this.createSingleLevelOptionStocks(option1List, amtList, limitPriceList, actual, dto, dtllist, recommendedOptions, tosReg);
                break;
            }
            case 2: {
                List<String> actualList = Arrays.asList(optionNames[0], optionNames[1]);
                if (recommendedOptions.size() < 2) {
                    throw new Exception("\uc5e0\ub9c1\ud06c\uc5d0 2\ub2e8 \uc635\uc158\uc73c\ub85c \uad6c\uc131\ub41c \uc0c1\ud488\uc774\uc9c0\ub9cc, \ud1a0\uc2a4 \ud574\ub2f9 \uce74\ud14c\uace0\ub9ac [" + tosReg.categoryId + "] \ub294 1\ub2e8 \uc635\uc158\ub9cc \uc9c0\uc6d0\ud558\ubbc0\ub85c \ub4f1\ub85d\uc774 \ubd88\uac00\ub2a5\ud569\ub2c8\ub2e4.");
                }
                this.createDoubleLevelOptionStocks(option1List, option2List, amtList, limitPriceList, actualList, dto, dtllist, recommendedOptions, tosReg);
                break;
            }
            case 3: {
                List<String> actualList2 = Arrays.asList(optionNames[0], optionNames[1], optionNames[2]);
                if (recommendedOptions.size() < 3) {
                    throw new Exception("\uc5e0\ub9c1\ud06c\uc5d0 3\ub2e8 \uc635\uc158\uc73c\ub85c \uad6c\uc131\ub41c \uc0c1\ud488\uc774\uc9c0\ub9cc, \ud1a0\uc2a4 \ud574\ub2f9 \uce74\ud14c\uace0\ub9ac [" + tosReg.categoryId + "] \ub294 " + recommendedOptions.size() + "\ub2e8 \uc635\uc158\ub9cc \uc9c0\uc6d0\ud558\ubbc0\ub85c \ub4f1\ub85d\uc774 \ubd88\uac00\ub2a5\ud569\ub2c8\ub2e4.");
                }
                this.createTripleLevelOptionStocks(option1List, option2List, option3List, amtList, limitPriceList, actualList2, dto, dtllist, recommendedOptions, tosReg);
                break;
            }
            default: {
                throw new Exception("\uc9c0\uc6d0\ud558\uc9c0 \uc54a\ub294 \uc635\uc158 \ub2e8\uacc4\uc785\ub2c8\ub2e4: " + optionDepth);
            }
        }
    }

    private int getOptionDepth(List<String> option1List, List<String> option2List, List<String> option3List) {
        if (option2List.isEmpty()) {
            return 1;
        }
        if (option3List.isEmpty()) {
            return 2;
        }
        return 3;
    }

    private void createSingleStock(ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, List<String> categorySalesOptionList, TossProductReg tosReg) {
        Stock stock = new Stock();
        boolean useTack = false;
        for (String optionGroupName : categorySalesOptionList) {
            if (useTack && optionGroupName.contains("\ud0dd1")) continue;
            Option option2 = new Option();
            if (optionGroupName.contains(",")) {
                String[] optionInfo = optionGroupName.split(",");
                option2.groupName = optionInfo[0];
                option2.valueName = String.valueOf(1) + optionInfo[1];
            } else {
                option2.groupName = optionGroupName;
                option2.valueName = "\ub2e8\uc77c\uc635\uc158";
            }
            stock.options.add(option2);
            if (!optionGroupName.contains("\ud0dd1")) continue;
            useTack = true;
        }
        if ("Y".equals(dtllist.getUserSaleYN())) {
            double saleprice = (double)Integer.parseInt(dto.getGoods_price()) / (1.0 - 0.01 * (double)dtllist.getUserSalePercent());
            stock.originPrice = Integer.parseInt(String.format("%.0f", Math.floor(saleprice / 10.0) * 10.0));
            dto.setMarket_price(dto.getGoods_price());
        } else {
            stock.originPrice = Integer.parseInt(dto.getGoods_price());
        }
        stock.salePrice = Integer.parseInt(dto.getMarket_price());
        stock.remainingCount = 999;
        stock.isMainPrice = true;
        stock.order = 0;
        stock.isHide = false;
        stock.isSoldOut = false;
        stock.managementCode = String.valueOf(dto.getCompayny_goods_cd()) + "-0";
        tosReg.stocks.add(stock);
    }

    private void createSingleLevelOptionStocks(List<String> optionList, List<String> amtList, List<String> limitPriceList, String optionNm, ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, List<String> categorySalesOptionList, TossProductReg tosReg) throws Exception {
        boolean useTack = false;
        String lowerOptionNm = optionNm.toLowerCase();
        if (lowerOptionNm.contains("\uc0c9\uc0c1") || lowerOptionNm.contains("color")) {
            optionNm = "\uc0c9\uc0c1";
        } else if (lowerOptionNm.contains("\uc0ac\uc774\uc988") || lowerOptionNm.contains("size")) {
            optionNm = "\uc0ac\uc774\uc988";
        }
        int i = 0;
        while (i < optionList.size()) {
            Stock stock = new Stock();
            boolean matched = false;
            int j = 0;
            while (j < categorySalesOptionList.size()) {
                String optionGroupName = categorySalesOptionList.get(j);
                if (!useTack || !optionGroupName.contains("\ud0dd1")) {
                    Option option2 = new Option();
                    if (optionGroupName.contains(optionNm)) {
                        option2.groupName = optionGroupName;
                        option2.valueName = optionList.get(i);
                        matched = true;
                    } else if (j == categorySalesOptionList.size() - 1 && !matched) {
                        option2.groupName = optionGroupName;
                        option2.valueName = optionList.get(i);
                    } else {
                        option2.groupName = optionGroupName;
                        option2.valueName = optionGroupName.equals("\uc218\ub7c9") ? "1\uac1c" : "\ub2e8\uc77c\uc635\uc158";
                    }
                    stock.options.add(option2);
                    if (optionGroupName.contains("\ud0dd1")) {
                        useTack = true;
                    }
                }
                ++j;
            }
            boolean hasPrice = Integer.parseInt(amtList.get(i)) > 0;
            int priceAfterOptionCharges = hasPrice ? this.getPriceAfterOptionCharges(dto, dtllist, amtList.get(i), limitPriceList.get(i)) : Integer.parseInt(dto.getGoods_price());
            if ("Y".equals(dtllist.getUserSaleYN())) {
                double salePrice = (double)priceAfterOptionCharges / (1.0 - 0.01 * (double)dtllist.getUserSalePercent());
                stock.originPrice = Integer.parseInt(String.format("%.0f", Math.floor(salePrice / 10.0) * 10.0));
                if (!hasPrice) {
                    dto.setMarket_price(dto.getGoods_price());
                }
            } else {
                stock.originPrice = priceAfterOptionCharges;
            }
            stock.salePrice = hasPrice ? priceAfterOptionCharges : Integer.parseInt(dto.getMarket_price());
            stock.remainingCount = 999;
            stock.isHide = false;
            stock.isSoldOut = false;
            stock.isMainPrice = i == 0;
            stock.order = i;
            stock.managementCode = String.valueOf(dto.getCompayny_goods_cd()) + "-" + i;
            tosReg.stocks.add(stock);
            ++i;
        }
    }

    private void createDoubleLevelOptionStocks(List<String> option1List, List<String> option2List, List<String> amtList, List<String> limitPriceList, List<String> optionNames, ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, List<String> categorySalesOptionList, TossProductReg tosReg) throws Exception {
        String lowerOptionNm1 = optionNames.get(0).toLowerCase();
        if (lowerOptionNm1.contains("\uc0c9\uc0c1") || lowerOptionNm1.contains("color")) {
            lowerOptionNm1 = "\uc0c9\uc0c1";
        } else if (lowerOptionNm1.contains("\uc0ac\uc774\uc988") || lowerOptionNm1.contains("size")) {
            lowerOptionNm1 = "\uc0ac\uc774\uc988";
        }
        String lowerOptionNm2 = optionNames.get(1).toLowerCase();
        if (lowerOptionNm2.contains("\uc0c9\uc0c1") || lowerOptionNm2.contains("color")) {
            lowerOptionNm2 = "\uc0c9\uc0c1";
        } else if (lowerOptionNm2.contains("\uc0ac\uc774\uc988") || lowerOptionNm2.contains("size")) {
            lowerOptionNm2 = "\uc0ac\uc774\uc988";
        }
        int i = 0;
        while (i < option1List.size()) {
            Stock stock = new Stock();
            boolean matched1 = false;
            boolean matched2 = false;
            boolean useTack = false;
            int j = 0;
            while (j < categorySalesOptionList.size()) {
                String optionGroupName = categorySalesOptionList.get(j);
                if (!useTack || !optionGroupName.contains("\ud0dd1")) {
                    Option option2 = new Option();
                    option2.groupName = optionGroupName;
                    if (!matched1 && optionGroupName.contains(lowerOptionNm1)) {
                        option2.valueName = option1List.get(i);
                        matched1 = true;
                    } else if (!matched2 && optionGroupName.contains(lowerOptionNm2)) {
                        option2.valueName = option2List.get(i);
                        matched2 = true;
                    } else {
                        boolean isSecondLast;
                        boolean isLast = j == categorySalesOptionList.size() - 1;
                        boolean bl = isSecondLast = j == categorySalesOptionList.size() - 2;
                        if (isSecondLast && !matched1 && !matched2) {
                            option2.valueName = option1List.get(i);
                            matched1 = true;
                        } else if (isLast && !matched1) {
                            option2.valueName = option1List.get(i);
                            matched1 = true;
                        } else if (isLast && !matched2) {
                            option2.valueName = option2List.get(i);
                            matched2 = true;
                        } else {
                            option2.valueName = optionGroupName.equals("\uc218\ub7c9") ? "1\uac1c" : "\ub2e8\uc77c\uc635\uc158";
                        }
                    }
                    stock.options.add(option2);
                    if (optionGroupName.contains("\ud0dd1")) {
                        useTack = true;
                    }
                }
                ++j;
            }
            boolean hasPrice = Integer.parseInt(amtList.get(i)) > 0;
            int priceAfterOptionCharges = hasPrice ? this.getPriceAfterOptionCharges(dto, dtllist, amtList.get(i), limitPriceList.get(i)) : Integer.parseInt(dto.getGoods_price());
            if ("Y".equals(dtllist.getUserSaleYN())) {
                double salePrice = (double)priceAfterOptionCharges / (1.0 - 0.01 * (double)dtllist.getUserSalePercent());
                stock.originPrice = Integer.parseInt(String.format("%.0f", Math.floor(salePrice / 10.0) * 10.0));
                if (!hasPrice) {
                    dto.setMarket_price(dto.getGoods_price());
                }
            } else {
                stock.originPrice = priceAfterOptionCharges;
            }
            stock.salePrice = hasPrice ? priceAfterOptionCharges : Integer.parseInt(dto.getMarket_price());
            stock.remainingCount = 999;
            stock.isHide = false;
            stock.isSoldOut = false;
            stock.isMainPrice = i == 0;
            stock.order = i;
            stock.managementCode = String.valueOf(dto.getCompayny_goods_cd()) + "-" + i;
            tosReg.stocks.add(stock);
            ++i;
        }
    }

    private void createTripleLevelOptionStocks(List<String> option1List, List<String> option2List, List<String> option3List, List<String> amtList, List<String> limitPriceList, List<String> optionNames, ShopProductDto dto, ShopProductTossShoppingAdditionDto dtllist, List<String> categorySalesOptionList, TossProductReg tosReg) throws Exception {
        String lowerOptionNm1 = optionNames.get(0).toLowerCase();
        if (lowerOptionNm1.contains("\uc0c9\uc0c1") || lowerOptionNm1.contains("color")) {
            lowerOptionNm1 = "\uc0c9\uc0c1";
        } else if (lowerOptionNm1.contains("\uc0ac\uc774\uc988") || lowerOptionNm1.contains("size")) {
            lowerOptionNm1 = "\uc0ac\uc774\uc988";
        }
        String lowerOptionNm2 = optionNames.get(1).toLowerCase();
        if (lowerOptionNm2.contains("\uc0c9\uc0c1") || lowerOptionNm2.contains("color")) {
            lowerOptionNm2 = "\uc0c9\uc0c1";
        } else if (lowerOptionNm2.contains("\uc0ac\uc774\uc988") || lowerOptionNm2.contains("size")) {
            lowerOptionNm2 = "\uc0ac\uc774\uc988";
        }
        String lowerOptionNm3 = optionNames.get(2).toLowerCase();
        if (lowerOptionNm3.contains("\uc0c9\uc0c1") || lowerOptionNm3.contains("color")) {
            lowerOptionNm3 = "\uc0c9\uc0c1";
        } else if (lowerOptionNm3.contains("\uc0ac\uc774\uc988") || lowerOptionNm3.contains("size")) {
            lowerOptionNm3 = "\uc0ac\uc774\uc988";
        }
        int i = 0;
        while (i < option1List.size()) {
            Stock stock = new Stock();
            boolean matched1 = false;
            boolean matched2 = false;
            boolean matched3 = false;
            boolean useTack = false;
            int j = 0;
            while (j < categorySalesOptionList.size()) {
                String optionGroupName = categorySalesOptionList.get(j);
                if (!useTack || !optionGroupName.contains("\ud0dd1")) {
                    Option option2 = new Option();
                    option2.groupName = optionGroupName;
                    if (!matched1 && optionGroupName.contains(lowerOptionNm1)) {
                        option2.valueName = option1List.get(i);
                        matched1 = true;
                    } else if (!matched2 && optionGroupName.contains(lowerOptionNm2)) {
                        option2.valueName = option2List.get(i);
                        matched2 = true;
                    } else if (!matched3 && optionGroupName.contains(lowerOptionNm3)) {
                        option2.valueName = option3List.get(i);
                        matched3 = true;
                    } else {
                        boolean isThirdLast;
                        boolean isLast = j == categorySalesOptionList.size() - 1;
                        boolean isSecondLast = j == categorySalesOptionList.size() - 2;
                        boolean bl = isThirdLast = j == categorySalesOptionList.size() - 3;
                        if (isThirdLast && !matched1 && !matched2 && !matched3) {
                            option2.valueName = option1List.get(i);
                            matched1 = true;
                        } else if (isSecondLast && !matched1 && !matched2) {
                            option2.valueName = option1List.get(i);
                            matched1 = true;
                        } else if (isSecondLast && !matched1 && !matched3) {
                            option2.valueName = option1List.get(i);
                            matched1 = true;
                        } else if (isSecondLast && !matched2 && !matched3) {
                            option2.valueName = option2List.get(i);
                            matched2 = true;
                        } else if (isLast && !matched1) {
                            option2.valueName = option1List.get(i);
                            matched1 = true;
                        } else if (isLast && !matched2) {
                            option2.valueName = option2List.get(i);
                            matched2 = true;
                        } else if (isLast && !matched3) {
                            option2.valueName = option3List.get(i);
                            matched3 = true;
                        } else {
                            option2.valueName = optionGroupName.equals("\uc218\ub7c9") ? "1\uac1c" : "\ub2e8\uc77c\uc635\uc158";
                        }
                    }
                    stock.options.add(option2);
                    if (optionGroupName.contains("\ud0dd1")) {
                        useTack = true;
                    }
                }
                ++j;
            }
            boolean hasPrice = Integer.parseInt(amtList.get(i)) > 0;
            int priceAfterOptionCharges = hasPrice ? this.getPriceAfterOptionCharges(dto, dtllist, amtList.get(i), limitPriceList.get(i)) : Integer.parseInt(dto.getGoods_price());
            if ("Y".equals(dtllist.getUserSaleYN())) {
                double salePrice = (double)priceAfterOptionCharges / (1.0 - 0.01 * (double)dtllist.getUserSalePercent());
                stock.originPrice = Integer.parseInt(String.format("%.0f", Math.floor(salePrice / 10.0) * 10.0));
                if (!hasPrice) {
                    dto.setMarket_price(dto.getGoods_price());
                }
            } else {
                stock.originPrice = priceAfterOptionCharges;
            }
            stock.salePrice = hasPrice ? priceAfterOptionCharges : Integer.parseInt(dto.getMarket_price());
            stock.remainingCount = 999;
            stock.isHide = false;
            stock.isSoldOut = false;
            stock.isMainPrice = i == 0;
            stock.order = i;
            stock.managementCode = String.valueOf(dto.getCompayny_goods_cd()) + "-" + i;
            tosReg.stocks.add(stock);
            ++i;
        }
    }

    private List<String> fetchRecommendedOptionsByCategory(int categoryId, Map<String, String> cookies) throws Exception {
        String uri = "https://api-public.toss.im/api-public/v2/shopping-internal/toss-shopping-partners/category/" + categoryId + "/constraints-template";
        Connection.Response optionByCategoryResponse = Jsoup.connect((String)uri).cookies(cookies).method(Connection.Method.GET).timeout(15000).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
        String body = optionByCategoryResponse.body();
        if (body == null) {
            throw new Exception("API response body is null");
        }
        JsonObject optionObject = (JsonObject)this.jsonParser.parse(body);
        ArrayList<String> categorySalesOptionList = new ArrayList<String>();
        if (optionObject.has("resultType") && "SUCCESS".equals(optionObject.get("resultType").getAsString())) {
            JsonObject success = (JsonObject)optionObject.get("success");
            JsonArray categorySalesOptions = success.getAsJsonArray("categorySalesOptions");
            if (categorySalesOptions != null) {
                for (JsonElement elem : categorySalesOptions) {
                    JsonObject categorySalesOption = elem.getAsJsonObject();
                    if (!categorySalesOption.has("key")) continue;
                    String key = categorySalesOption.get("key").getAsString();
                    JsonElement element = categorySalesOption.get("unitValues");
                    if (element != null && element.isJsonArray()) {
                        JsonArray optionMustEndWith = element.getAsJsonArray();
                        if (optionMustEndWith.size() > 0) {
                            categorySalesOptionList.add(String.valueOf(key) + "," + optionMustEndWith.get(0).getAsString());
                            continue;
                        }
                        categorySalesOptionList.add(key);
                        continue;
                    }
                    categorySalesOptionList.add(key);
                }
            }
        } else {
            JsonObject error;
            String reason = "";
            if (optionObject.has("error") && (error = optionObject.getAsJsonObject("error")).has("reason")) {
                reason = error.get("reason").getAsString();
            }
            throw new Exception(this.getErrorMessage(reason));
        }
        return categorySalesOptionList;
    }

    private void DeiliverySetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        block16: {
            block14: {
                String deliveryType;
                tosReg.deliveryPolicy.deliveryMethod = "NORMAL";
                tosReg.deliveryPolicy.deliveryDeadline = "";
                if (dtllist.IsGroupDelivery()) {
                    String locationId = dtllist.getLocationId();
                    tosReg.deliveryPolicy.deliveryLocationId = locationId != null ? locationId : null;
                } else {
                    tosReg.deliveryPolicy.deliveryLocationId = null;
                }
                if (!"Y".equals(dtllist.getUseAdditionalDeliveryTypeYN())) break block14;
                switch (deliveryType = dtllist.getDeliveryType()) {
                    case "F": {
                        tosReg.deliveryPolicy.deliveryFeeType = "FREE";
                        tosReg.deliveryPolicy.deliveryFee = 0;
                        break;
                    }
                    case "P": {
                        tosReg.deliveryPolicy.deliveryFeeType = "PAID";
                        tosReg.deliveryPolicy.deliveryFee = dtllist.getBaseFee();
                        break;
                    }
                    default: {
                        tosReg.deliveryPolicy.deliveryFeeType = "CONDITIONALLY_FREE";
                        tosReg.deliveryPolicy.deliveryFee = dtllist.getBaseFee();
                        tosReg.deliveryPolicy.minimumPurchasePrice = dtllist.getFreeAmtCond();
                        break;
                    }
                }
                break block16;
            }
            if ("0".equals(dto.getDelv_type())) {
                tosReg.deliveryPolicy.deliveryFeeType = "PAID";
                tosReg.deliveryPolicy.deliveryFee = Integer.parseInt(dto.getDelv_cost());
            } else {
                tosReg.deliveryPolicy.deliveryFeeType = "FREE";
                tosReg.deliveryPolicy.deliveryFee = 0;
            }
        }
        tosReg.deliveryPolicy.isJejuAndIslandsMountainsDelivery = dtllist.isCanBeDeliveredLongDistance();
        tosReg.deliveryPolicy.jejuDeliveryFee = dtllist.getJejuDeliveryFee();
        tosReg.deliveryPolicy.islandsMountainsDeliveryFee = dtllist.getLongDistanceDeliveryCost();
    }

    private void ExchangeReturnSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        tosReg.exchangeReturnPolicy.exchangeRefundLocationId = Integer.parseInt(dtllist.getRefundExchangeLocationId());
        tosReg.exchangeReturnPolicy.refundOneWayDeliveryFee = dtllist.getBothWaysDeliveryCost();
        tosReg.exchangeReturnPolicy.exchangeRoundTripDeliveryFee = dtllist.getExchangeRoundTripDeliveryFee();
        tosReg.exchangeReturnPolicy.applicationTermDescription = dtllist.getApplicationTermDescription();
        tosReg.exchangeReturnPolicy.applicationMethodDescription = dtllist.getApplicationMethodDescription();
    }

    private void ExposureSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto) {
        tosReg.exposure.description = "";
        if (!dto.getGoods_search().equals("")) {
            String[] keywords = dto.getGoods_search().split(",");
            int limit = Math.min(keywords.length, 10);
            tosReg.exposure.searchKeywords = Arrays.asList(Arrays.copyOfRange(keywords, 0, limit));
        }
    }

    private void GosiSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        tosReg.notice.categoryCode = "ETC_GOODS";
        NoticeItem item1 = new NoticeItem();
        item1.id = 397;
        item1.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        NoticeItem item2 = new NoticeItem();
        item2.id = 399;
        item2.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        NoticeItem item3 = new NoticeItem();
        item3.id = 401;
        item3.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        NoticeItem item4 = new NoticeItem();
        item4.id = 403;
        item4.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        NoticeItem item5 = new NoticeItem();
        item5.id = 405;
        item5.content = "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
        tosReg.notice.items.add(item1);
        tosReg.notice.items.add(item2);
        tosReg.notice.items.add(item3);
        tosReg.notice.items.add(item4);
        tosReg.notice.items.add(item5);
        tosReg.notice.isTemplateSaved = false;
    }

    private void GoodsRemarkSetting(TossProductReg tosReg, ShopProductTossShoppingAdditionDto dtllist, ShopProductDto dto) {
        if (dto.getGoods_keyword().equals("shop9987")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://www.onnme.com//", "https://cafe24.poxo.com/ec01/onnme/0jJurf5+JqL2mXn6P+LWO7AOJReIvurqGIXrcbUKXpOyPc6+sV46LMYTP2N64fK/UxkTbRHFkp58If06vHlUUA==/_/"));
        } else if (dto.getGoods_keyword().equals("shop0000")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://cbw.co.kr//", "https://cafe24.poxo.com/ec01/kdh0201/EjglQcnyYl9oLKpqUS6wZgXi8sojGAGtEWIWWXL2plRUVd7qyEd9+lcioi6YTYl8+M0/iGFZrQSxc8jTkkjqtw==/_/"));
        } else if (dto.getGoods_keyword().equals("shop9986")) {
            dto.setGoods_remarks(dto.getGoods_remarks().replace("https://xn--jt2by0pl8b7va956c.kr", "https://ydinc.cafe24.com"));
        }
        String remark = "";
        String addDetailPlus = "";
        String body = dtllist.getProddetailfront().concat(dto.getGoods_remarks()).replace("&#39;", "");
        remark = dtllist.getProddetailoutput().equals("1") ? body.concat(dtllist.getProddetailback()).replace("&#39;", "") : body;
        if (dtllist.getRemarktop().equals("Y")) {
            remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat(dto.getGoods_remarks()).replace("&#39;", "");
        }
        if (dtllist.getDetailkeywordb().equals("Y")) {
            addDetailPlus = String.valueOf(dtllist.getDetailKeywordL()) + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
        }
        if (dtllist.getDetailproductcodeb().equals("Y")) {
            addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
        }
        if (dtllist.getDetailproductnameb().equals("Y")) {
            addDetailPlus = String.valueOf(addDetailPlus) + dtllist.getDetailProductNameL() + dto.getGoods_nm() + dtllist.getDetailProductNameR();
        }
        String headHtmlByToss = "<p id=\"companygoodsCD\" style=\"display: none;\">" + dto.getCompayny_goods_cd() + "</p>";
        Image image = new Image();
        image.type = "DESCRIPTION_HTML";
        image.html = IProduct.removeBrokenImgTag(String.valueOf(headHtmlByToss) + remark + addDetailPlus);
        image.order = 0;
        tosReg.images.add(image);
    }

    private String getErrorMessage(String reason) {
        switch (reason) {
            case "AUTHENTICATION FAIL01": {
                return "[01] \uc778\uc99d\uc815\ubcf4 \uc5c6\uc74c \ub85c\uadf8\uc778 \ud6c4 \uc2dc\ub3c4\ud558\uc138\uc694";
            }
            case "AUTHENTICATION FAIL04": {
                return "[04] \ub85c\uadf8\uc778 \ub9cc\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc7ac\ub85c\uadf8\uc778 \ud6c4 \uc2dc\ub3c4\ud558\uc138\uc694.";
            }
        }
        return reason;
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    private static class DeliveryPolicy {
        private String deliveryDeadline;
        private String deliveryMethod;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String deliveryLocationId;
        private String deliveryFeeType;
        private int deliveryFee;
        private int minimumPurchasePrice;
        private int jejuDeliveryFee;
        private int islandsMountainsDeliveryFee;
        private boolean isJejuAndIslandsMountainsDelivery;

        private DeliveryPolicy() {
        }
    }

    private static class ExchangeReturnPolicy {
        private int exchangeRefundLocationId;
        private int refundOneWayDeliveryFee;
        private int exchangeRoundTripDeliveryFee;
        private String applicationTermDescription;
        private String applicationMethodDescription;

        private ExchangeReturnPolicy() {
        }
    }

    private static class Exposure {
        private List<String> searchKeywords = new ArrayList<String>();
        private String description;

        private Exposure() {
        }
    }

    private static class Image {
        private String type;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String url;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private String html;
        private int order;

        private Image() {
        }
    }

    private static class Notice {
        private String categoryCode;
        private List<NoticeItem> items = new ArrayList<NoticeItem>();
        private boolean isTemplateSaved;

        private Notice() {
        }
    }

    private static class NoticeItem {
        private int id;
        private String content;

        private NoticeItem() {
        }
    }

    private static class Option {
        private String groupName;
        private String valueName;

        private Option() {
        }
    }

    private static class Stock {
        private List<Option> options = new ArrayList<Option>();
        private int originPrice;
        private int salePrice;
        private int remainingCount;
        private boolean isMainPrice;
        private int order;
        private boolean isHide;
        private boolean isSoldOut;
        private String managementCode;

        private Stock() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class TossProductReg {
        private String name;
        private String managementCode;
        private List<Stock> stocks = new ArrayList<Stock>();
        private int categoryId;
        private boolean isTaxFree;
        private boolean isCultureDeduction;
        private DeliveryPolicy deliveryPolicy = new DeliveryPolicy();
        private ExchangeReturnPolicy exchangeReturnPolicy = new ExchangeReturnPolicy();
        private Exposure exposure = new Exposure();
        private Notice notice = new Notice();
        private List<Image> images = new ArrayList<Image>();

        private TossProductReg() {
        }
    }
}

