/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.hubseller;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.CaffeineCategoryCache;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ProductResultDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.hubseller.HubsellerOrderDto;
import com.kdjsystem.mlink.shop.hubseller.HubsellerProductDto;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkDomeOrderCollectConnection;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HubsellerCommon {
    private final OkHttpClient client = new OkHttpClient().newBuilder().build();
    public static HubsellerCommon instance = new HubsellerCommon();
    static final String HEXES = "0123456789abcdef";

    private HubsellerCommon() {
    }

    public static HubsellerCommon get() {
        return instance;
    }

    public void HubsellerSendOrder(List<ShopOrderMstDto> orderList, ShoppingMallDetailDto shopDto, YDMAProgressBar console) {
        int page = 0;
        ObjectMapper mapper = new ObjectMapper();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String apiTime = datetime.format(cal.getTime());
        String apiKeySig = this.getApiKeySig(shopDto.getAuthkey1(), shopDto.getApikey(), apiTime);
        List keys = orderList.stream().filter(d -> d.getDosinstatus() != null && !d.getDosinstatus().equals("\ud488\uc808")).map(p -> String.valueOf(String.valueOf(p.getReceive_name()) + p.getReceive_cel() + p.getReceive_tel() + p.getReceive_addr())).distinct().collect(Collectors.toList());
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\ud488\uc808\uc0c1\ud488 \ubc0f \ub3d9\uc77c\ubc30\uc1a1\uc9c0 \uc81c\uc678 " + keys.size() + "\uac74\uc758 \uc8fc\ubb38\uc815\ubcf4 \uc804\uc1a1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4", 0);
        Map<String, List<ShopOrderMstDto>> mapList = orderList.stream().collect(Collectors.groupingBy(p -> String.valueOf(String.valueOf(p.getReceive_name()) + p.getReceive_cel() + p.getReceive_tel() + p.getReceive_addr())));
        for (String key : keys) {
            List<ShopOrderMstDto> product2 = mapList.get(key);
            String solution_number = String.valueOf(System.currentTimeMillis());
            String json = this.setSendOrderRequestParams(product2, shopDto.getAuthkey1(), solution_number);
            String content = "memberId=" + shopDto.getAuthkey1() + "&apiKeySig=" + apiKeySig + "&apiTime=" + apiTime + "&sellerId=" + shopDto.getShoppingid() + "&mode=write&orderJson=" + json;
            MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)content);
            Request request2 = new Request.Builder().url("https://www.hubseller.co.kr/www/api/prod/sellerOrderWriteApi.php").method("POST", body).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
            try {
                Throwable throwable = null;
                Object var22_24 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                    Result result = (Result)mapper.readValue(response.body().string().toString(), Result.class);
                    if (result.SUCC_CNT != null) {
                        String startDate = product2.get(0).getStartDt().substring(0, 10);
                        String endDate = product2.get(0).getEndDt().substring(0, 10);
                        for (ShopOrderMstDto dto : product2) {
                            RequestBody orderSerachBody = RequestBody.create((MediaType)mediaType, (String)("memberId=" + shopDto.getAuthkey1() + "&apiKeySig=" + apiKeySig + "&apiTime=" + apiTime + "&sellerId=" + shopDto.getShoppingid() + "&mode=list&searchOrderStatus=&" + "searchOrderClaimStatus=&searchRegStartDt=" + startDate + "&searchRegEndDt=" + endDate + "&searchField=ocSellerMemo1&searchKey=" + solution_number));
                            Request request1 = new Request.Builder().url("https://www.hubseller.co.kr/www/api/prod/sellerOrderApi.php").method("POST", orderSerachBody).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
                            try {
                                Throwable throwable2 = null;
                                Object var32_37 = null;
                                try (Response response1 = this.client.newCall(request1).execute();){
                                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{HubsellerOrderDto.ResponseOrderSearch.class});
                                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                                    StringReader reader = new StringReader(response1.body().string());
                                    HubsellerOrderDto.ResponseOrderSearch result1 = (HubsellerOrderDto.ResponseOrderSearch)jaxbUnmarshaller.unmarshal((Reader)reader);
                                    String domeShopOrderNum = result1.info.order_key;
                                    String receiverName = result1.info.b_name;
                                    String domeCompanyGoodCd = result1.info.product.prod_code;
                                    String sellerMemo = result1.info.product.prod_seller_memo1;
                                    if (!dto.getReceive_name().equals(receiverName) || !dto.getCompayny_goods_cd().equals(domeCompanyGoodCd) || !solution_number.equals(sellerMemo)) continue;
                                    dto.setDs_order_status("\ud5c8\ube0c\uc2e0\uaddc");
                                    dto.setOrder_status("500");
                                    dto.setDosinOrder_code(String.valueOf(domeShopOrderNum) + "-" + shopDto.getShopseq());
                                    dto.setResult_code("1");
                                    ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
                                    retList.add(dto);
                                    ShopOrderDao.get().SaveOrUpdate(retList);
                                    String message = String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s \uc8fc\ubb38\uc774 \uc131\uacf5\ud588\uc2b5\ub2c8\ub2e4.", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getCompayny_goods_cd(), dto.getSale_cnt());
                                    MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, message, ++page);
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                    } else if (throwable2 != throwable3) {
                                        throwable2.addSuppressed(throwable3);
                                    }
                                    throw throwable2;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        continue;
                    }
                    for (ShopOrderMstDto dto : product2) {
                        String message = String.format("\uc218\ucde8\uc778\uba85 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", dto.getReceive_name(), dto.getCompayny_goods_cd(), dto.getSale_cnt(), result.MSG_ALL);
                        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, message, page);
                        dto.setResult_code("-1");
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "---------------------------------------------------------------------------------------", page);
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, String.format("[\uc804\uccb4\uacb0\uacfc] \uc8fc\ubb38 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4. \uc8fc\ubb38\uac74\uc774 \ub2e4\ub97c \uacbd\uc6b0 \ubb38\uc758\ubc14\ub78d\ub2c8\ub2e4.", page), page);
    }

    public List<ShopOrderMstDto> HubsellerOrderSearch(List<ShopOrderMstDto> orderList, ShoppingMallDetailDto shopDto, YDMAProgressBar console) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        int page = 0;
        String startDate = orderList.get(0).getStartDt().substring(0, 10);
        String endDate = orderList.get(0).getEndDt().substring(0, 10);
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String apiTime = datetime.format(cal.getTime());
        String apiKeySig = this.getApiKeySig(shopDto.getAuthkey1(), shopDto.getApikey(), apiTime);
        for (ShopOrderMstDto dto : orderList) {
            if (!dto.getCompayny_goods_cd().substring(0, 2).equals("HS")) {
                throw new Exception("\ud5c8\ube0c\uc140\ub7ec \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " + dto.getCompayny_goods_cd());
            }
            Request request2 = new Request.Builder().url("https://www.hubseller.co.kr/www/api/prod/sellerOrderApi.php").method("POST", this.createRequestBody(shopDto, apiKeySig, apiTime, startDate, endDate, dto)).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
            try {
                Throwable throwable = null;
                Object var16_18 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    String orderCode;
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{HubsellerOrderDto.ResponseOrderSearch.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    StringReader reader = new StringReader(response.body().string());
                    HubsellerOrderDto.ResponseOrderSearch result1 = (HubsellerOrderDto.ResponseOrderSearch)jaxbUnmarshaller.unmarshal((Reader)reader);
                    String domeShopOrderNum = result1.info.order_key;
                    String receiverName = result1.info.b_name;
                    String domeCompanyGoodCd = result1.info.product.prod_code;
                    String string = orderCode = dto.getDosinOrder_code().contains("-") ? dto.getDosinOrder_code().split("-")[0] : dto.getDosinOrder_code();
                    if (!dto.getReceive_name().trim().equals(receiverName) || !dto.getCompayny_goods_cd().contains(domeCompanyGoodCd) || !orderCode.equals(domeShopOrderNum)) continue;
                    dto.setDelivery_id("");
                    dto.setInvoice_no("");
                    switch (result1.info.order_status) {
                        case "\uacb0\uc81c\uc644\ub8cc": {
                            dto.setDs_order_status("\ud5c8\ube0c\uc2e0\uaddc");
                            break;
                        }
                        case "\ubc30\uc1a1\uc900\ube44\uc911": {
                            dto.setOrder_status("501");
                            dto.setDs_order_status("\ud5c8\ube0c\uc900\ube44");
                            break;
                        }
                        case "\ubc30\uc1a1\uc911": 
                        case "\ubc30\uc1a1\uc644\ub8cc": {
                            List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
                            String delv = result1.info.product.prod_delivery_com;
                            ShopDeliveryDto delvname = MLinkDomeOrderCollectConnection.get().findDelvName(dto, delv, datasource);
                            dto.setDs_order_status(result1.info.order_status);
                            dto.setDelivery_id(delvname.getDlvID());
                            dto.setInvoice_no(result1.info.product.prod_delivery_num == null ? "" : result1.info.product.prod_delivery_num.trim());
                            dto.setOrder_status("402");
                            break;
                        }
                        default: {
                            dto.setDs_order_status(result1.info.order_status);
                        }
                    }
                    ++page;
                    if (dto.getInvoice_no().equals("")) {
                        MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, page, "", false, console);
                    } else {
                        MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, page, "", true, console);
                    }
                    dto.setResult_code("1");
                    ret.add(dto);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "[\ud5c8\ube0c\uc140\ub7ec] \ub3d9\uae30\ud654 \uc911\uc5d0 \uc5d0\ub7ec \ubc1c\uc0dd \uba54\uc138\uc9c0 [" + e + "]", page);
            }
        }
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, String.format("[\ud5c8\ube0c\uc140\ub7ec \uacb0\uacfc] \ub3d9\uae30\ud654 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4.", page), page);
        return ret;
    }

    public ProductResultDto getProductUploadMapping(Map<Integer, HashMap<String, String>> readExcelManager) throws Exception {
        ProductResultDto productResult = new ProductResultDto();
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        for (Integer key : readExcelManager.keySet()) {
            String prodcd;
            HashMap<String, String> data2;
            if (key == 0 || (data2 = readExcelManager.get(key)).get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d") != null && !data2.get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d").isEmpty() || data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85") != null && !data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85").isEmpty() || data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4") != null && !data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4").isEmpty() || (prodcd = data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc")).length() == 0) continue;
            ProductItemDto dto = new ProductItemDto();
            new ShopOrderMstDto();
            dto.setIcode(data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc"));
            dto.setVender_code(data2.get("\ud310\ub9e4\uc790 \uad00\ub9ac\ucf54\ub4dc"));
            dto.setFolder(data2.get("\ud3f4\ub354\uba85"));
            dto.setCid(data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*"));
            dto.setIname(data2.get("\uc0c1\ud488\uba85*"));
            dto.setPrice(data2.get("\ud310\ub9e4\uac00*"));
            dto.setQty(data2.get("\uc218\ub7c9*"));
            dto.setLimitQty(data2.get("\ucd5c\ub300\uad6c\ub9e4\uc218\ub7c9"));
            dto.setLowLimitQty(data2.get("\ucd5c\uc18c\uad6c\ub9e4\uc218\ub7c9"));
            dto.setIcountry(data2.get("\uc6d0\uc0b0\uc9c0*"));
            dto.setOrigin(data2.get("G\ub9c8\ucf13,\uc625\uc158 \uc6d0\uc0b0\uc9c0 \uc720\ud615"));
            dto.setMaker(data2.get("\uc218\uc785\uc0ac"));
            String[] imgList = (String[])Arrays.asList(data2.get("\ubaa9\ub85d \uc774\ubbf8\uc9c0*"), data2.get("\uc774\ubbf8\uc9c01(\ub300\ud45c/\uae30\ubcf8\uc774\ubbf8\uc9c0)*"), data2.get("\uc774\ubbf8\uc9c02"), data2.get("\uc774\ubbf8\uc9c03"), data2.get("\uc774\ubbf8\uc9c04"), data2.get("\uc774\ubbf8\uc9c05")).toArray();
            dto.setImg(imgList);
            dto.setContent(data2.get("\uc0c1\uc138\uc124\uba85*"));
            dto.setEsm_auction(data2.get("ESM \ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc124\uba85"));
            dto.setEsm_auction(data2.get("ESM \uad11\uace0\ud64d\ubcf4 \uc0c1\uc138\uc124\uba85"));
            dto.setSelect_option(data2.get("\uc120\ud0dd\uc0ac\ud56d \ud0c0\uc785"));
            dto.setSelect_option_name(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc635\uc158\uba85"));
            dto.setSelect_option_config(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc0c1\uc138\uc815\ubcf4"));
            dto.setSelect_option_use(data2.get("\uc120\ud0dd\uc0ac\ud56d \uc7ac\uace0 \uc0ac\uc6a9\uc5ec\ubd80"));
            dto.setText_option(data2.get("\uc791\uc131\ud615 \uc120\ud0dd\uc0ac\ud56d"));
            dto.setText_option_name(data2.get("\ucd94\uac00\uad6c\uc131 \uc635\uc158\uba85"));
            dto.setText_option_config(data2.get("\ucd94\uac00\uad6c\uc131 \uc0c1\uc138\uc815\ubcf4"));
            dto.setBrand(data2.get("\ube0c\ub79c\ub4dc"));
            dto.setModel(data2.get("\ubaa8\ub378\uba85"));
            dto.setMaker(data2.get("\uc81c\uc870\uc0ac"));
            dto.setTax(data2.get("\uacfc\uc138\uc5ec\ubd80").equals("\uacfc\uc138") ? "0" : "1");
            dto.setAdult(data2.get("\ub098\uc774\uc81c\ud55c"));
            dto.setMake_datetime(data2.get("\uc81c\uc870\uc77c\uc790"));
            dto.setUse_datetime(data2.get("\uc720\ud6a8\uc77c\uc790"));
            dto.setHongbo(data2.get("\ud64d\ubcf4\ubb38\uad6c"));
            dto.setItype(data2.get("\uc0c1\ud488\uc0c1\ud0dc"));
            dto.setCost(data2.get("\uc6d0\uac00"));
            dto.setPrice_consumer(data2.get("\uacf5\uae09\uac00"));
            dto.setLimit_price(data2.get("\ub3c4\uc11c\uc815\uac00"));
            dto.setIsbn(data2.get("ISBN"));
            dto.setMoonhwa(data2.get("\ubb38\ud654\ube44 \uc18c\ub4dd\uacf5\uc81c"));
            dto.setKeyword(data2.get("\uac80\uc0c9\uc5b4(\ud0dc\uadf8)"));
            dto.setCert(data2.get("\uc778\uc99d\uc815\ubcf4"));
            dto.setGosi_code(data2.get("\uc694\uc57d\uc815\ubcf4 \uc0c1\ud488\uad70 \ucf54\ub4dc*"));
            dto.setGosi1(data2.get("\uac121"));
            dto.setGosi2(data2.get("\uac122"));
            dto.setGosi3(data2.get("\uac123"));
            dto.setGosi4(data2.get("\uac124"));
            dto.setGosi5(data2.get("\uac125"));
            dto.setGosi6(data2.get("\uac126"));
            dto.setGosi7(data2.get("\uac127"));
            dto.setGosi8(data2.get("\uac128"));
            dto.setGosi9(data2.get("\uac129"));
            dto.setGosi10(data2.get("\uac1210"));
            dto.setGosi11(data2.get("\uac1211"));
            dto.setGosi12(data2.get("\uac1212"));
            dto.setGosi13(data2.get("\uac1213"));
            dto.setGosi14(data2.get("\uac1214"));
            dto.setGosi15(data2.get("\uac1215"));
            dto.setGosi16(data2.get("\uac1216"));
            dto.setGosi17(data2.get("\uac1217"));
            dto.setGosi18(data2.get("\uac1218"));
            dto.setGosi19(data2.get("\uac1219"));
            dto.setGosi20(data2.get("\uac1220"));
            dto.setGosi21(data2.get("\uac1221"));
            dto.setGosi22(data2.get("\uac1222"));
            dto.setGosi23(data2.get("\uac1223"));
            dto.setGosi24(data2.get("\uac1224"));
            dto.setGosi25(data2.get("\uac1225"));
            dto.setGosi26(data2.get("\uac1226"));
            dto.setGosi27(data2.get("\uac1227"));
            dto.setGosi28(data2.get("\uac1228"));
            dto.setGosi29(data2.get("\uac1229"));
            dto.setErr_message(data2.get("\uae30\ubcf8\uc815\ubcf4 \uc624\ub958\uba54\uc2dc\uc9c0"));
            dto.setDelivery_amount(data2.get("\ubc30\uc1a1\ube44"));
            dto.setStatus("0");
            String id = data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*");
            ShopProductDao.get();
            String cate_list = ShopProductDao.getCategoryInfo(id);
            dto.setCategoryInfo(cate_list);
            dto.setCateg_nm(CaffeineCategoryCache.getInstance().getFullCategoryName(data2.get("\uce74\ud14c\uace0\ub9ac \ubc88\ud638*")));
            dto.seteSellersExcelYN("Y");
            dto.setSearch("shop5001");
            items.add(dto);
        }
        productResult.items = items;
        return productResult;
    }

    private String setSendOrderRequestParams(List<ShopOrderMstDto> param, String id, String solution_number) {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            RequestJsons request2 = new RequestJsons();
            request2.requestJson = new ArrayList<RequestJson>();
            for (ShopOrderMstDto dto : param) {
                RequestJson requestJson = new RequestJson();
                requestJson.O_B_ADDR = dto.getReceive_addr();
                requestJson.O_B_HP = dto.getReceive_cel();
                requestJson.O_B_MEMO = dto.getDelv_msg();
                requestJson.O_B_NAME = dto.getReceive_name();
                requestJson.O_B_PHONE = dto.getReceive_tel().equals("") ? dto.getReceive_cel() : dto.getReceive_tel();
                requestJson.O_B_ZIP = dto.getReceive_zipcode();
                requestJson.O_SHIPPING_NO = "";
                if (dto.getP_sku_value2() == null || dto.getP_sku_value2().equals("")) {
                    requestJson.OC_OPT_ATTR1 = "";
                    requestJson.OC_OPT_ATTR2 = "";
                } else if (dto.getP_sku_value2().contains(":")) {
                    String[] optionValues = dto.getP_sku_value2().split(":");
                    requestJson.OC_OPT_ATTR1 = optionValues[0];
                    requestJson.OC_OPT_ATTR2 = optionValues[1];
                } else if (!dto.getP_sku_value2().equals("")) {
                    requestJson.OC_OPT_ATTR1 = dto.getP_sku_value2();
                    requestJson.OC_OPT_ATTR2 = "";
                }
                requestJson.OC_SELLER_MEMO1 = solution_number;
                requestJson.OC_SELLER_MEMO2 = id;
                requestJson.OC_SELLER_MEMO3 = "";
                requestJson.OCT_DLV_TYPE = "\uc120\ubd88";
                requestJson.P_CODE = dto.getCompayny_goods_cd();
                requestJson.PB_QTY = dto.getSale_cnt();
                request2.requestJson.add(requestJson);
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString(request2.requestJson);
        }
        catch (Exception exception) {}
        return json;
    }

    public String getApiKeySig(String memberId, String apiKey, String apiTime) {
        String apiKeyMsg = String.valueOf(memberId) + "_" + apiKey + "_" + apiTime;
        String apiKeySig = "";
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(apiKey.getBytes("UTF-8"), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            byte[] res = sha256_HMAC.doFinal(apiKeyMsg.getBytes("UTF-8"));
            apiKeySig = HubsellerCommon.getHex(res);
        }
        catch (Exception exception) {}
        return apiKeySig;
    }

    public static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        byte[] byArray = raw;
        int n = raw.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
            ++n2;
        }
        return hex.toString();
    }

    public List<ProductItemDto> getProductInfo(List<ShopOrderMstDto> list, ShoppingMallDetailDto detailDto) throws Exception {
        ArrayList<ProductItemDto> datasource = new ArrayList<ProductItemDto>();
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat datetime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat datetime1 = new SimpleDateFormat("yyyy-MM-dd");
        String apiTime = datetime.format(cal.getTime());
        String searchTime = datetime1.format(cal.getTime());
        String apiKeySig = this.getApiKeySig(detailDto.getAuthkey1(), detailDto.getApikey(), apiTime);
        ShopPreferencesDto shopPreferencesDto = ShopCommonDao.get().getSystemConf();
        for (ShopOrderMstDto dto : list) {
            MLinkCommon.get().setCompanyGoodsCd(dto, shopPreferencesDto);
            if (!dto.getCompayny_goods_cd().substring(0, 2).equals("HS")) {
                throw new Exception("\ud5c8\ube0c\uc140\ub7ec \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud558\uc2ed\uc2dc\uc624. " + dto.getCompayny_goods_cd());
            }
            MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)("memberId=" + detailDto.getAuthkey1() + "&apiKeySig=" + apiKeySig + "&" + "apiTime=" + apiTime + "&" + "sellerId=" + detailDto.getShoppingid() + "&" + "mode=api_product_list&" + "searchDateTp=R&" + "searchStartDt=2018-01-01&" + "searchEndDt=" + searchTime + "&" + "search_p_code_text=" + dto.getCompayny_goods_cd() + "&"));
            Request request2 = new Request.Builder().url("http://www.hubseller.co.kr/www/api/prod/productListFileApi.php").method("POST", body).addHeader("Content-Type", "application/x-www-form-urlencoded").build();
            try {
                Throwable throwable = null;
                Object var17_19 = null;
                try (Response response = this.client.newCall(request2).execute();){
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ResponseData.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    StringReader reader = new StringReader(response.body().string());
                    ResponseData result = (ResponseData)jaxbUnmarshaller.unmarshal((Reader)reader);
                    InputStream in = null;
                    String query = result.file;
                    ZipInputStream stream = null;
                    try {
                        try {
                            URL url = new URL(query);
                            in = new BufferedInputStream(url.openStream(), 1024);
                            stream = new ZipInputStream(in);
                            byte[] buffer = new byte[1024];
                            while (stream.getNextEntry() != null) {
                                int read;
                                StringBuilder sb = new StringBuilder();
                                while ((read = stream.read(buffer)) != -1) {
                                    sb.append(new String(buffer, 0, read, "utf-8"));
                                }
                                if (sb.toString().isEmpty()) continue;
                                String data2 = sb.toString().substring(sb.toString().lastIndexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"), sb.toString().length());
                                JAXBContext jaxbContext1 = JAXBContext.newInstance((Class[])new Class[]{HubsellerProductDto.HubsellerProduct.class});
                                Unmarshaller jaxbUnmarshaller1 = jaxbContext1.createUnmarshaller();
                                StringReader reader1 = new StringReader(this.filterBadXMLCharactors(data2));
                                HubsellerProductDto.HubsellerProduct productInfo = (HubsellerProductDto.HubsellerProduct)jaxbUnmarshaller1.unmarshal((Reader)reader1);
                                ProductItemDto productItemDto = this.getOrderMapping(productInfo);
                                datasource.add(productItemDto);
                            }
                        }
                        catch (Exception e) {
                            YDMAStringUtil.Print(e.getMessage());
                            throw new Exception(e.getMessage());
                        }
                    }
                    finally {
                        if (in != null) {
                            in.close();
                        }
                        if (stream != null) {
                            stream.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return datasource;
    }

    public String filterBadXMLCharactors(String textToFilter) {
        StringBuffer filteredString = new StringBuffer();
        if (textToFilter == null || "".equals(textToFilter)) {
            return "";
        }
        int i = 0;
        while (i < textToFilter.length()) {
            char current = textToFilter.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                filteredString.append(current);
            }
            ++i;
        }
        return filteredString.toString();
    }

    public ProductItemDto getOrderMapping(HubsellerProductDto.HubsellerProduct response) {
        ProductItemDto item = new ProductItemDto();
        try {
            item.setSearch("shop5001");
            for (HubsellerProductDto.GoodsInfo dto : response.getGoodsInfo()) {
                item.setIcode(dto.getPtn_goods_cd());
                item.setIname(dto.getProd_nm());
                if (!dto.getOptions().getOpt_title1().equals("")) {
                    StringBuffer sb = new StringBuffer();
                    int z = 0;
                    String[] optionValues1 = dto.getOptions().getOpt_valuel1().split(",");
                    if (!dto.getOptions().getOpt_title2().equals("")) {
                        sb.append("[" + dto.getOptions().getOpt_title1() + "=" + dto.getOptions().getOpt_title2() + "]\n");
                        String[] optionValues2 = dto.getOptions().getOpt_valuel2().split(",");
                        String[] optionPrice = dto.getOptions().getOptAmt().split(",");
                        String[] optionQty = dto.getOptions().getOptQty().split(",");
                        if (optionPrice[0].equals("")) {
                            optionPrice = null;
                        }
                        int j = 0;
                        while (j < optionValues1.length) {
                            int k = 0;
                            while (k < optionValues2.length) {
                                sb.append(optionValues1[j].concat("=").concat(optionValues2[k]).concat("=").concat(String.valueOf(String.valueOf(Integer.parseInt(optionPrice == null || optionPrice[z].equals("") ? "0" : optionPrice[z])) + dto.getOrg_price())).concat("=0=0=").concat(optionQty[z].equals("0") ? "1" : "0").concat("\n"));
                                ++z;
                                ++k;
                            }
                            ++j;
                        }
                    } else {
                        String[] optionQty;
                        sb.append("[" + dto.getOptions().getOpt_title1() + "]\n");
                        String[] optionPrice = dto.getOptions().getOptAmt().split(",");
                        if (optionPrice.length == 1 && optionPrice[0].equals("")) {
                            optionQty = dto.getOptions().getOptQty().split(",");
                            int i = 0;
                            while (i < optionValues1.length) {
                                sb.append(optionValues1[i].concat("==").concat(String.valueOf(dto.getOrg_price())).concat("=0=0=").concat(optionQty[z].equals("0") ? "1" : "0").concat("\n"));
                                ++z;
                                ++i;
                            }
                        } else {
                            optionQty = dto.getOptions().getOptQty().split(",");
                            int i = 0;
                            while (i < optionValues1.length) {
                                sb.append(optionValues1[i].concat("==").concat(String.valueOf(Integer.parseInt(optionPrice[z]) + Integer.parseInt(dto.getOrg_price()))).concat("=0=0=").concat(optionQty[z].equals("0") ? "1" : "0").concat("\n"));
                                ++z;
                                ++i;
                            }
                        }
                    }
                    item.setSelect_option(sb.toString());
                    item.setText_option("");
                }
                int price2 = Integer.parseInt(dto.getOrg_price());
                item.setPrice(String.valueOf(price2));
                item.setVender_code(dto.getUse_seller_id());
                item.setDelivery_amount(dto.getDlvy_cost());
                item.setStatus(dto.getSale_status().equals("B") ? "0" : "1");
                item.setDelivery_type("");
                item.setDelivery_qty("");
                item.setIsreturn("");
                String[] img = new String[10];
                img[0] = dto.getImg_0();
                item.setImg(img);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return item;
    }

    public RequestBody createRequestBody(ShoppingMallDetailDto shopDto, String apiKeySig, String apiTime, String startDate, String endDate, ShopOrderMstDto dto) {
        MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
        String memberId = "memberId=" + shopDto.getAuthkey1();
        String apiKey = "&apiKeySig=" + apiKeySig;
        String apiTimestamp = "&apiTime=" + apiTime;
        String sellerId = "&sellerId=" + shopDto.getShoppingid();
        String mode = "&mode=list";
        String searchOrderStatus = "&searchOrderStatus=";
        String searchOrderClaimStatus = "&searchOrderClaimStatus=";
        String searchRegStartDt = "&searchRegStartDt=" + startDate;
        String searchRegEndDt = "&searchRegEndDt=" + endDate;
        String searchField = "&searchField=orderNum";
        String orderCode = dto.getDosinOrder_code().contains("-") ? dto.getDosinOrder_code().split("-")[0] : dto.getDosinOrder_code();
        String searchKey = "&searchKey=" + orderCode;
        String requestBodyContent = String.valueOf(memberId) + apiKey + apiTimestamp + sellerId + mode + searchOrderStatus + searchOrderClaimStatus + searchRegStartDt + searchRegEndDt + searchField + searchKey;
        return RequestBody.create((MediaType)mediaType, (String)requestBodyContent);
    }

    public static class RequestJson {
        public String P_CODE;
        public String PB_QTY;
        public String OC_OPT_ATTR1;
        public String OC_OPT_ATTR2;
        public String OCT_DLV_TYPE;
        public String O_B_NAME;
        public String O_B_PHONE;
        public String O_B_HP;
        public String O_B_ZIP;
        public String O_B_ADDR;
        public String O_B_MEMO;
        public String O_SHIPPING_NO;
        public String OC_SELLER_MEMO1;
        public String OC_SELLER_MEMO2;
        public String OC_SELLER_MEMO3;
    }

    public static class RequestJsons {
        public List<RequestJson> requestJson;
    }

    @XmlRootElement(name="DATA")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class ResponseData {
        @XmlElement(name="RET")
        public String ret;
        @XmlElement(name="MSG")
        public String msg;
        @XmlElement(name="FILE")
        public String file;
    }

    public static class Result {
        public String RET_ALL;
        public String CODE;
        public String MSG_ALL;
        public String SUCC_CNT;
        public String FAIL_CNT;
    }
}

