/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.jcef;

import com.kdjsystem.mlink.shop.jcef.ControlPanel;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import org.cef.OS;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefPdfPrintCallback;
import org.cef.callback.CefRunFileDialogCallback;
import org.cef.callback.CefStringVisitor;
import org.cef.handler.CefDialogHandler;
import org.cef.misc.CefPdfPrintSettings;
import org.cef.network.CefCookieManager;
import org.cef.network.CefRequest;
import tests.detailed.BrowserFrame;
import tests.detailed.MainFrame;
import tests.detailed.dialog.CookieManagerDialog;
import tests.detailed.dialog.DevToolsDialog;
import tests.detailed.dialog.DownloadDialog;
import tests.detailed.dialog.SearchDialog;
import tests.detailed.dialog.ShowTextDialog;
import tests.detailed.dialog.UrlRequestDialog;
import tests.detailed.dialog.WebPluginManagerDialog;

public class MenuBar
extends JMenuBar {
    private final MainFrame owner_;
    private final CefBrowser browser_;
    private String last_selected_file_ = "";
    private final JMenu bookmarkMenu_;
    private final ControlPanel control_pane_;
    private final DownloadDialog downloadDialog_;
    private final CefCookieManager cookieManager_;
    private boolean reparentPending_ = false;

    public MenuBar(MainFrame owner, final CefBrowser browser, ControlPanel control_pane, DownloadDialog downloadDialog, CefCookieManager cookieManager) {
        this.owner_ = owner;
        this.browser_ = browser;
        this.control_pane_ = control_pane;
        this.downloadDialog_ = downloadDialog;
        this.cookieManager_ = cookieManager;
        this.setEnabled(this.browser_ != null);
        JMenu fileMenu = new JMenu("File");
        JMenuItem openFileItem = new JMenuItem("Open file...");
        openFileItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser fc = new JFileChooser(new File(MenuBar.this.last_selected_file_));
                fc.showOpenDialog((Component)MenuBar.this.owner_);
                File selectedFile = fc.getSelectedFile();
                if (selectedFile != null) {
                    MenuBar.this.last_selected_file_ = selectedFile.getAbsolutePath();
                    MenuBar.this.browser_.loadURL("file:///" + selectedFile.getAbsolutePath());
                }
            }
        });
        fileMenu.add(openFileItem);
        JMenuItem openFileDialog = new JMenuItem("Save as...");
        openFileDialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CefRunFileDialogCallback callback = new CefRunFileDialogCallback(){

                    public void onFileDialogDismissed(int selectedAcceptFilter, Vector<String> filePaths) {
                        if (!filePaths.isEmpty()) {
                            try {
                                SaveAs saveContent = new SaveAs(filePaths.get(0));
                                MenuBar.this.browser_.getSource((CefStringVisitor)saveContent);
                            }
                            catch (FileNotFoundException | UnsupportedEncodingException iOException) {
                                MenuBar.this.browser_.executeJavaScript("alert(\"Can't save file\");", MenuBar.this.control_pane_.getAddress(), 0);
                            }
                        }
                    }
                };
                MenuBar.this.browser_.runFileDialog(CefDialogHandler.FileDialogMode.FILE_DIALOG_SAVE, MenuBar.this.owner_.getTitle(), "index.html", null, 0, callback);
            }
        });
        fileMenu.add(openFileDialog);
        JMenuItem printItem = new JMenuItem("Print...");
        printItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.print();
            }
        });
        fileMenu.add(printItem);
        JMenuItem printToPdfItem = new JMenuItem("Print to PDF");
        printToPdfItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.showSaveDialog((Component)MenuBar.this.owner_);
                File selectedFile = fc.getSelectedFile();
                if (selectedFile != null) {
                    CefPdfPrintSettings pdfSettings = new CefPdfPrintSettings();
                    pdfSettings.header_footer_enabled = true;
                    pdfSettings.page_width = 210000;
                    pdfSettings.page_height = 297000;
                    browser.printToPDF(selectedFile.getAbsolutePath(), pdfSettings, new CefPdfPrintCallback(){

                        public void onPdfPrintFinished(final String path, final boolean ok) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    if (ok) {
                                        JOptionPane.showMessageDialog((Component)MenuBar.this.owner_, "PDF saved to " + path, "Success", 1);
                                    } else {
                                        JOptionPane.showMessageDialog((Component)MenuBar.this.owner_, "PDF failed", "Failed", 0);
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
        fileMenu.add(printToPdfItem);
        JMenuItem searchItem = new JMenuItem("Search...");
        searchItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SearchDialog((Frame)MenuBar.this.owner_, MenuBar.this.browser_).setVisible(true);
            }
        });
        fileMenu.add(searchItem);
        fileMenu.addSeparator();
        JMenuItem viewSource = new JMenuItem("View source");
        viewSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.viewSource();
            }
        });
        fileMenu.add(viewSource);
        JMenuItem getSource = new JMenuItem("Get source...");
        getSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowTextDialog visitor = new ShowTextDialog((Frame)MenuBar.this.owner_, "Source of \"" + MenuBar.this.control_pane_.getAddress() + "\"");
                MenuBar.this.browser_.getSource((CefStringVisitor)visitor);
            }
        });
        fileMenu.add(getSource);
        JMenuItem getText = new JMenuItem("Get text...");
        getText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowTextDialog visitor = new ShowTextDialog((Frame)MenuBar.this.owner_, "Content of \"" + MenuBar.this.control_pane_.getAddress() + "\"");
                MenuBar.this.browser_.getText((CefStringVisitor)visitor);
            }
        });
        fileMenu.add(getText);
        fileMenu.addSeparator();
        JMenuItem showDownloads = new JMenuItem("Show Downloads");
        showDownloads.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.downloadDialog_.setVisible(true);
            }
        });
        fileMenu.add(showDownloads);
        JMenuItem showCookies = new JMenuItem("Show Cookies");
        showCookies.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CookieManagerDialog cookieManager = new CookieManagerDialog((Frame)MenuBar.this.owner_, "Cookie Manager", MenuBar.this.cookieManager_);
                cookieManager.setVisible(true);
            }
        });
        fileMenu.add(showCookies);
        JMenuItem showPlugins = new JMenuItem("Show Plugins");
        showPlugins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WebPluginManagerDialog pluginManager = new WebPluginManagerDialog((Frame)MenuBar.this.owner_, "Plugin Manager");
                pluginManager.setVisible(true);
            }
        });
        fileMenu.add(showPlugins);
        fileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.owner_.dispatchEvent((AWTEvent)new WindowEvent((Window)MenuBar.this.owner_, 201));
            }
        });
        fileMenu.add(exitItem);
        this.bookmarkMenu_ = new JMenu("Bookmarks");
        JMenuItem addBookmarkItem = new JMenuItem("Add bookmark");
        addBookmarkItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.addBookmark(MenuBar.this.owner_.getTitle(), MenuBar.this.control_pane_.getAddress());
            }
        });
        this.bookmarkMenu_.add(addBookmarkItem);
        this.bookmarkMenu_.addSeparator();
        JMenu testMenu = new JMenu("Tests");
        JMenuItem testJSItem = new JMenuItem("JavaScript alert");
        testJSItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.executeJavaScript("alert('Hello World');", MenuBar.this.control_pane_.getAddress(), 1);
            }
        });
        testMenu.add(testJSItem);
        JMenuItem jsAlertItem = new JMenuItem("JavaScript alert (will be suppressed)");
        jsAlertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.executeJavaScript("alert('Never displayed');", "http://dontshow.me", 1);
            }
        });
        testMenu.add(jsAlertItem);
        JMenuItem httpRequest = new JMenuItem("Manual HTTP request");
        httpRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String searchFor = JOptionPane.showInputDialog((Component)MenuBar.this.owner_, (Object)"Search on google:");
                if (searchFor != null && !searchFor.isEmpty()) {
                    CefRequest myRequest = CefRequest.create();
                    myRequest.setMethod("GET");
                    myRequest.setURL("http://www.google.com/#q=" + searchFor);
                    myRequest.setFirstPartyForCookies("http://www.google.com/#q=" + searchFor);
                    MenuBar.this.browser_.loadRequest(myRequest);
                }
            }
        });
        testMenu.add(httpRequest);
        JMenuItem showInfo = new JMenuItem("Show Info");
        showInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String info = "<html><head><title>Browser status</title></head>";
                info = String.valueOf(info) + "<body><h1>Browser status</h1><table border=\"0\">";
                info = String.valueOf(info) + "<tr><td>CanGoBack</td><td>" + MenuBar.this.browser_.canGoBack() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>CanGoForward</td><td>" + MenuBar.this.browser_.canGoForward() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>IsLoading</td><td>" + MenuBar.this.browser_.isLoading() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>isPopup</td><td>" + MenuBar.this.browser_.isPopup() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>hasDocument</td><td>" + MenuBar.this.browser_.hasDocument() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>Url</td><td>" + MenuBar.this.browser_.getURL() + "</td></tr>";
                info = String.valueOf(info) + "<tr><td>Zoom-Level</td><td>" + MenuBar.this.browser_.getZoomLevel() + "</td></tr>";
                info = String.valueOf(info) + "</table></body></html>";
                String js = "var x=window.open(); x.document.open(); x.document.write('" + info + "'); x.document.close();";
                MenuBar.this.browser_.executeJavaScript(js, "", 0);
            }
        });
        testMenu.add(showInfo);
        final JMenuItem showDevTools = new JMenuItem("Show DevTools");
        showDevTools.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DevToolsDialog devToolsDlg = new DevToolsDialog((Frame)MenuBar.this.owner_, "DEV Tools", MenuBar.this.browser_);
                devToolsDlg.addComponentListener((ComponentListener)new ComponentAdapter(){

                    @Override
                    public void componentHidden(ComponentEvent e) {
                        showDevTools.setEnabled(true);
                    }
                });
                devToolsDlg.setVisible(true);
                showDevTools.setEnabled(false);
            }
        });
        testMenu.add(showDevTools);
        JMenuItem testURLRequest = new JMenuItem("URL Request");
        testURLRequest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UrlRequestDialog dlg = new UrlRequestDialog((Frame)MenuBar.this.owner_, "URL Request Test");
                dlg.setVisible(true);
            }
        });
        testMenu.add(testURLRequest);
        JMenuItem reparent = new JMenuItem("Reparent");
        reparent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final BrowserFrame newFrame = new BrowserFrame("New Window");
                newFrame.setLayout((LayoutManager)new BorderLayout());
                final JButton reparentButton = new JButton("Reparent <");
                reparentButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (MenuBar.this.reparentPending_) {
                            return;
                        }
                        MenuBar.this.reparentPending_ = true;
                        if (reparentButton.getText().equals("Reparent <")) {
                            MenuBar.this.owner_.removeBrowser(new Runnable(){

                                @Override
                                public void run() {
                                    newFrame.add(MenuBar.this.browser_.getUIComponent(), (Object)"Center");
                                    newFrame.setBrowser(MenuBar.this.browser_);
                                    reparentButton.setText("Reparent >");
                                    MenuBar.this.reparentPending_ = false;
                                }
                            });
                        } else {
                            newFrame.removeBrowser(new Runnable(){

                                @Override
                                public void run() {
                                    JRootPane rootPane = (JRootPane)MenuBar.this.owner_.getComponent(0);
                                    Container container = rootPane.getContentPane();
                                    JPanel panel = (JPanel)container.getComponent(0);
                                    panel.add(MenuBar.this.browser_.getUIComponent());
                                    MenuBar.this.owner_.setBrowser(MenuBar.this.browser_);
                                    MenuBar.this.owner_.revalidate();
                                    reparentButton.setText("Reparent <");
                                    MenuBar.this.reparentPending_ = false;
                                }
                            });
                        }
                    }
                });
                newFrame.add((Component)reparentButton, (Object)"North");
                newFrame.setSize(400, 400);
                newFrame.setVisible(true);
            }
        });
        testMenu.add(reparent);
        JMenuItem newwindow = new JMenuItem("New window");
        newwindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame frame = new MainFrame(OS.isLinux(), false, false, null);
                frame.setSize(800, 600);
                frame.setVisible(true);
            }
        });
        testMenu.add(newwindow);
        JMenuItem screenshotSync = new JMenuItem("Screenshot (on AWT thread, native res)");
        screenshotSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long start = System.nanoTime();
                CompletableFuture shot = browser.createScreenshot(true);
                YDMAStringUtil.Print("Took screenshot from the AWT event thread in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " msecs");
                try {
                    MenuBar.this.displayScreenshot((BufferedImage)shot.get());
                }
                catch (InterruptedException | ExecutionException exception) {}
            }
        });
        screenshotSync.setEnabled(owner.isOsrEnabled());
        testMenu.add(screenshotSync);
        JMenuItem screenshotSyncScaled = new JMenuItem("Screenshot (on AWT thread, scaled)");
        screenshotSyncScaled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long start = System.nanoTime();
                CompletableFuture shot = browser.createScreenshot(false);
                YDMAStringUtil.Print("Took screenshot from the AWT event thread in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " msecs");
                try {
                    MenuBar.this.displayScreenshot((BufferedImage)shot.get());
                }
                catch (InterruptedException | ExecutionException exception) {}
            }
        });
        screenshotSyncScaled.setEnabled(owner.isOsrEnabled());
        testMenu.add(screenshotSyncScaled);
        JMenuItem screenshotAsync = new JMenuItem("Screenshot (from other thread, scaled)");
        screenshotAsync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long start = System.nanoTime();
                CompletableFuture shot = browser.createScreenshot(false);
                shot.thenAccept(image -> {
                    YDMAStringUtil.Print("Took screenshot asynchronously in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + " msecs");
                    SwingUtilities.invokeLater(new Runnable((BufferedImage)image){
                        private final /* synthetic */ BufferedImage val$image;
                        {
                            this.val$image = bufferedImage;
                        }

                        @Override
                        public void run() {
                            MenuBar.this.displayScreenshot(this.val$image);
                        }
                    });
                });
            }
        });
        screenshotAsync.setEnabled(owner.isOsrEnabled());
        testMenu.add(screenshotAsync);
        this.add(fileMenu);
        this.add(this.bookmarkMenu_);
        this.add(testMenu);
    }

    public void addBookmark(String name, String URL2) {
        Component[] entries;
        if (this.bookmarkMenu_ == null) {
            return;
        }
        Component[] componentArray = entries = this.bookmarkMenu_.getMenuComponents();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            JMenuItem item;
            Component itemEntry = componentArray[n2];
            if (itemEntry instanceof JMenuItem && (item = (JMenuItem)itemEntry).getText().equals(name)) {
                item.setActionCommand(URL2);
                return;
            }
            ++n2;
        }
        JMenuItem menuItem = new JMenuItem(name);
        menuItem.setActionCommand(URL2);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuBar.this.browser_.loadURL(e.getActionCommand());
            }
        });
        this.bookmarkMenu_.add(menuItem);
        this.validate();
    }

    private void displayScreenshot(BufferedImage aScreenshot) {
        JFrame frame = new JFrame("Screenshot");
        ImageIcon image = new ImageIcon();
        image.setImage(aScreenshot);
        frame.setLayout(new FlowLayout());
        JLabel label = new JLabel(image);
        label.setPreferredSize(new Dimension(aScreenshot.getWidth(), aScreenshot.getHeight()));
        frame.add(label);
        frame.setVisible(true);
        frame.pack();
    }

    public void addBookmarkSeparator() {
        this.bookmarkMenu_.addSeparator();
    }

    class SaveAs
    implements CefStringVisitor {
        private PrintWriter fileWriter_;

        public SaveAs(String fName) throws FileNotFoundException, UnsupportedEncodingException {
            this.fileWriter_ = new PrintWriter(fName, "UTF-8");
        }

        public void visit(String string) {
            this.fileWriter_.write(string);
            this.fileWriter_.close();
        }
    }
}

