/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.job;

import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopQuestion;
import com.kdjsystem.mlink.shop.common.ProductQuestionService;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopQuestionDao;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.QuestListDao;
import com.kdjsystem.mlink.tot.data.dao.QuestListDto;
import com.kdjsystem.mlink.tot.ui.MainView;
import com.kdjsystem.mlink.tot.ui.QuestionsShoppingMallManager;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobQuestion
implements Job {
    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap data2 = context.getJobDetail().getJobDataMap();
        ScheduleInfoDto scheduler = (ScheduleInfoDto)data2.get((Object)"Question");
        List shoplist = (List)data2.get((Object)"SHOP");
        String execKey = (String)data2.get((Object)"EXEC_KEY");
        List<String> macAddressList = IShopCommonLogin.getLocalMacAddressListNotVirtual();
        if (!macAddressList.contains(execKey)) {
            return;
        }
        this.getQuestion(context, scheduler, shoplist);
        this.setAnswerAndReply(context, scheduler, shoplist);
        this.triggerAutoSearchIfViewOpened();
    }

    private void getQuestion(JobExecutionContext context, ScheduleInfoDto scheduler, List<ShopOrderMstDto> list) {
        boolean emergencyMsg;
        boolean productInquiry;
        if (scheduler.getTypechk().equals("") || scheduler.getTypechk().equals("B")) {
            Calendar cal = Calendar.getInstance();
            int dayOfWeek = cal.get(7);
            switch (dayOfWeek) {
                case 1: {
                    productInquiry = scheduler.getJobexe14().equals("Y");
                    emergencyMsg = scheduler.getJobexe24().equals("Y");
                    break;
                }
                case 6: {
                    productInquiry = scheduler.getJobexe12().equals("Y");
                    emergencyMsg = scheduler.getJobexe22().equals("Y");
                    break;
                }
                case 7: {
                    productInquiry = scheduler.getJobexe13().equals("Y");
                    emergencyMsg = scheduler.getJobexe23().equals("Y");
                    break;
                }
                default: {
                    productInquiry = scheduler.getJobexe11().equals("Y");
                    emergencyMsg = scheduler.getJobexe21().equals("Y");
                    break;
                }
            }
        } else {
            String cycleInfo = scheduler.getCycleinfo();
            if (cycleInfo.contains(",")) {
                String[] splitCycleInfo = cycleInfo.split(",");
                productInquiry = splitCycleInfo[1].equals("Y");
                emergencyMsg = splitCycleInfo[2].equals("Y");
            } else {
                productInquiry = false;
                emergencyMsg = false;
            }
        }
        if (!productInquiry && !emergencyMsg) {
            return;
        }
        String btnstats = "";
        btnstats = productInquiry && !emergencyMsg ? "\ubb38\uc758" : (!productInquiry && emergencyMsg ? "\uae34\uae09" : "\uc804\uccb4");
        List<QuestListDto> qnalist = this.conVersion(list);
        int count = 1;
        ArrayList<QuestListDto> content = new ArrayList<QuestListDto>();
        YDMAProgressBar console = new YDMAProgressBar();
        console.startToBack("\ubb38\uc758\uc218\uc9d1", qnalist.size(), 100, true);
        try {
            for (QuestListDto dto : qnalist) {
                List<Object> list2 = new ArrayList();
                String shopinfo = String.format("(%s-%s) %s", dto.getShopname(), dto.getNickname(), dto.getShopid());
                try {
                    dto.setBtnstats(btnstats);
                    List<QuestListDto> args = Arrays.asList(dto);
                    console.setValueBack("[" + shopinfo + "] \ubb38\uc758 \uc218\uc9d1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", count++);
                    ProductQuestionService service = new ProductQuestionService(IShopQuestion.getSearchBean(dto.getShopnm()));
                    list2 = service.excute(args);
                    if (list2.size() > 0) {
                        int i = 0;
                        while (i < list2.size()) {
                            ((QuestListDto)list2.get(i)).setShopseq(dto.getShopseq());
                            ++i;
                        }
                    }
                    console.setValueBack(String.format("[" + shopinfo + "] \ubb38\uc758  %s\uac74\uc744 \uc218\uc9d1 \uc644\ub8cc\ud558\uc600\uc2b5\ub2c8\ub2e4.", list2.size()), count);
                    content.addAll(list2);
                }
                catch (Exception e) {
                    console.setValueBack(String.format("[" + shopinfo + "] \ubb38\uc758 \uc218\uc9d1 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [%s]", e.getMessage()), count);
                }
            }
            if (content.size() > 0) {
                for (QuestListDto dto : content) {
                    this.conVersionQuestAndAnswer(dto);
                }
                ShopQuestionDao.get().SaveOrUpdate(content);
                console.setValueBack(String.format("[%s]\uac74\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \uc218\uc9d1 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", content.size()), count);
            } else {
                console.setValueBack("\ubb38\uc758 \uc218\uc9d1\ud55c \ub0b4\uc6a9\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.", count);
            }
        }
        catch (Exception e) {
            console.setValueBack("\ubb38\uc758 \uc218\uc9d1 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd [ " + e + " ]", count);
        }
        int i = 0;
        while (i < 5) {
            console.setValueBack("\ubb38\uc758 \uc218\uc9d1 \uc791\uc5c5\uc774 \ub9c8\ubb34\ub9ac \ub418\uc5b4 [" + String.valueOf(5 - i) + "]\ucd08 \ub4a4\uc5d0 \ucc3d\uc774 \ub2eb\ud799\ub2c8\ub2e4.", count);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                console.setValueBack("\ubb38\uc758 \uc218\uc9d1 \uc791\uc5c5 \ub9c8\ubb34\ub9ac \ud6c4 \uc885\ub8cc \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc5ec \uc791\uc5c5\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4. \r\n " + e.getMessage(), count);
                break;
            }
            ++i;
        }
        console.end();
    }

    private List<QuestListDto> conVersion(List<ShopOrderMstDto> list) {
        ArrayList<QuestListDto> qnalist = new ArrayList<QuestListDto>();
        for (ShopOrderMstDto dto : list) {
            QuestListDto adddto = new QuestListDto();
            adddto.setApikey(dto.getApikey());
            adddto.setAuthkey1(dto.getAuthkey1());
            adddto.setAuthkey2(dto.getAuthKey2());
            adddto.setShopid(dto.getShop_userid());
            adddto.setShopnm(dto.getShopid());
            adddto.setShopPw(dto.getShopPw());
            if (!dto.getEndDt().substring(0, 8).equals(YDMATimeUtil.getCurrentTime().substring(0, 8))) {
                LocalDate currentEndDate = LocalDate.parse(YDMATimeUtil.getCurrentTime().substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd"));
                LocalDate pastEndDate = LocalDate.parse(dto.getEndDt().substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd"));
                long daysBetween = ChronoUnit.DAYS.between(pastEndDate, currentEndDate);
                LocalDate pastStartDate = LocalDate.parse(dto.getStartDt().substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd"));
                LocalDate currentStateDate = pastStartDate.plus(daysBetween, ChronoUnit.DAYS);
                adddto.setStartDt(currentStateDate.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
                adddto.setEndDt(YDMATimeUtil.getCurrentTime().substring(0, 8));
            } else {
                adddto.setStartDt(dto.getStartDt().substring(0, 8));
                adddto.setEndDt(dto.getEndDt().substring(0, 8));
            }
            adddto.setShopname(dto.getShopnm());
            adddto.setNickname(dto.getNickname());
            adddto.setNickNm2(dto.getAuthkey1());
            adddto.setShopseq(dto.getShopseq());
            qnalist.add(adddto);
        }
        return qnalist;
    }

    private void conVersionQuestAndAnswer(QuestListDto dto) {
        if (dto.getQuests() != null) {
            dto.setQuests(dto.getQuests().replaceAll("<br>", "\n"));
            dto.setQuests(dto.getQuests().replaceAll("<BR>", "\n"));
            dto.setQuests(dto.getQuests().replaceAll("&lt;", "<"));
            dto.setQuests(dto.getQuests().replaceAll("&gt;", ">"));
            dto.setQuests(dto.getQuests().replaceAll("&nbsp;", ""));
            dto.setQuests(dto.getQuests().replaceAll("&amp;nbsp;", ""));
            dto.setQuests(dto.getQuests().replaceAll("<BR/>", "\n"));
            dto.setQuests(dto.getQuests().replaceAll("/br", "\n"));
            dto.setQuests(dto.getQuests().replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", ""));
            dto.setQuests(dto.getQuests().replace("&#40;", "("));
            dto.setQuests(dto.getQuests().replace("&#41;", ")"));
        }
        if (dto.getAnsws() != null) {
            dto.setAnsws(dto.getAnsws().replaceAll("<br>", "\n"));
            dto.setAnsws(dto.getAnsws().replaceAll("<BR>", "\n"));
            dto.setAnsws(dto.getAnsws().replaceAll("&lt;", "<"));
            dto.setAnsws(dto.getAnsws().replaceAll("&gt;", ">"));
            dto.setAnsws(dto.getAnsws().replaceAll("&nbsp;", ""));
            dto.setAnsws(dto.getAnsws().replaceAll("&amp;nbsp;", ""));
            dto.setAnsws(dto.getAnsws().replaceAll("<BR/>", "\n"));
            dto.setAnsws(dto.getAnsws().replaceAll("/br", "\n"));
            dto.setAnsws(dto.getAnsws().replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", ""));
            dto.setAnsws(dto.getAnsws().replace("&#40;", "("));
            dto.setAnsws(dto.getAnsws().replace("&#41;", ")"));
        }
    }

    private void setAnswerAndReply(JobExecutionContext context, ScheduleInfoDto scheduler, List<ShopOrderMstDto> list) {
        List<QuestListDto> param;
        List<QuestListDto> mapList;
        boolean reply;
        boolean answer;
        if (scheduler.getTypechk().equals("") || scheduler.getTypechk().equals("B")) {
            Calendar cal = Calendar.getInstance();
            int dayOfWeek = cal.get(7);
            switch (dayOfWeek) {
                case 1: {
                    answer = scheduler.getJobexe34().equals("Y");
                    reply = scheduler.getJobexe44().equals("Y");
                    break;
                }
                case 6: {
                    answer = scheduler.getJobexe32().equals("Y");
                    reply = scheduler.getJobexe42().equals("Y");
                    break;
                }
                case 7: {
                    answer = scheduler.getJobexe33().equals("Y");
                    reply = scheduler.getJobexe43().equals("Y");
                    break;
                }
                default: {
                    answer = scheduler.getJobexe31().equals("Y");
                    reply = scheduler.getJobexe41().equals("Y");
                    break;
                }
            }
        } else {
            String cycleInfo = scheduler.getCycleinfo();
            if (cycleInfo.contains(",")) {
                String[] splitCycleInfo = cycleInfo.split(",");
                if (splitCycleInfo.length != 5) {
                    return;
                }
                answer = splitCycleInfo[3].equals("Y");
                reply = splitCycleInfo[4].equals("Y");
            } else {
                answer = false;
                reply = false;
            }
        }
        if (!answer && !reply) {
            return;
        }
        List<QuestListDto> qnalist = this.conVersion(list);
        YDMAProgressBar console = new YDMAProgressBar();
        console.startToBack("\ubb38\uc758 \ub2f5\ubcc0 \uc791\uc131 \ubc0f \ub0b4\ubcf4\ub0b4\uae30", qnalist.size(), 100, true);
        int count = 0;
        LocalDate currentStartDate = LocalDate.parse(YDMATimeUtil.getCurrentTime().substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd")).minusDays(7L);
        LocalDate currentEndDate = LocalDate.parse(YDMATimeUtil.getCurrentTime().substring(0, 8), DateTimeFormatter.ofPattern("yyyyMMdd"));
        String start = String.valueOf(currentStartDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"))) + "000000";
        String end = String.valueOf(currentEndDate.format(DateTimeFormatter.ofPattern("yyyyMMdd"))) + "999999";
        String opt = "INSDM";
        if (answer) {
            block39: {
                try {
                    console.setValueBack("\ub2f5\ubcc0\uc791\uc131 \uc2a4\ucf00\uc974\ub7ec\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4. \ucd5c\uadfc \uc77c\uc8fc\uc77c\uac04\uc758 \uc2e0\uaddc \ubb38\uc758\ub97c \uc870\ud68c\ud569\ub2c8\ub2e4.", 0);
                    mapList = ShopQuestionDao.get().getNewQuestionList(start, end, opt);
                    if (mapList == null || mapList.isEmpty()) {
                        console.setValueBack("\ucd5c\uadfc \uc77c\uc8fc\uc77c\uac04 \uc2e0\uaddc \ubb38\uc758\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.", 90);
                        break block39;
                    }
                    if ((mapList = mapList.stream().filter(d -> qnalist.stream().anyMatch(p -> d.getShopnm().equals(p.getShopnm()) && d.getShopseq().equals(p.getShopseq()))).collect(Collectors.toList())) == null || mapList.isEmpty()) {
                        console.setValueBack("\uc124\uc815\ud55c \uc1fc\ud551\ubab0 \uae30\uc900\uc73c\ub85c \ucd5c\uadfc \uc77c\uc8fc\uc77c\uac04 \uc870\ud68c\ub41c \uc2e0\uaddc \ubb38\uc758\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.", 90);
                        break block39;
                    }
                    console.setValueBack("\uc124\uc815\ud55c \uc0ac\uc774\ud2b8 \uae30\uc900\uc73c\ub85c \uc2e0\uaddc \ubb38\uc758 " + mapList.size() + "\uac74\uc774 \uc870\ud68c\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \ub2f5\ubcc0 \ub9e4\ud551 \uc124\uc815\uc5d0 \ub530\ub77c \ub2f5\ubcc0 \uc791\uc131\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 30);
                    QuestListDao dao = new QuestListDao();
                    for (QuestListDto dto : qnalist) {
                        param = mapList.stream().filter(p -> p.getShopnm().equals(dto.getShopnm())).filter(p -> p.getShopseq().equals(dto.getShopseq())).collect(Collectors.toList());
                        if (param.size() <= 0) continue;
                        String shopinfo = String.format("(%s-%s) %s", dto.getShopname(), dto.getNickname(), dto.getShopid());
                        console.setValueBack("[" + shopinfo + "]\uc5d0 \ub300\ud55c \ub2f5\ubcc0 \ub9e4\ud551 \uc815\ubcf4\ub97c \uc870\ud68c\ud569\ub2c8\ub2e4.", 50);
                        List<QuestListDto> mappingList = ShopQuestionDao.get().getTemplateListByShopcd(dto.getShopnm());
                        if (mappingList.size() > 0) {
                            console.setValueBack("[" + shopinfo + "]\uc5d0 \ub300\ud55c \ub2f5\ubcc0 \ub9e4\ud551 \uc815\ubcf4\ub97c \ubc14\ud0d5\uc73c\ub85c \uc2e0\uaddc \ubb38\uc758 \ub2f5\ubcc0\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 70);
                            block14: for (QuestListDto questListDto : param) {
                                for (QuestListDto mappinginfo : mappingList) {
                                    String keyword = mappinginfo.getMappingkeyword();
                                    if (!questListDto.getSubject().contains(keyword) && !questListDto.getQuests().contains(keyword)) continue;
                                    console.setValueBack("[" + shopinfo + "] - '" + questListDto.getSubject() + "' \ubb38\uc758\uc5d0 \ub300\ud55c \ub9e4\ud551\uc744 \uc644\ub8cc\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub2f5\ubcc0 \uc791\uc131\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 0);
                                    questListDto.setQnastat("101");
                                    int a = dao.AnswerContentSave(questListDto, mappinginfo.getTemptitle(), mappinginfo.getTempansws());
                                    if (a > 0) {
                                        console.setValueBack("[" + shopinfo + "] - '" + questListDto.getSubject() + "' \ubb38\uc758\uc5d0 \ub300\ud55c \ub2f5\ubcc0\uc744 \uc131\uacf5\uc801\uc73c\ub85c \uc800\uc7a5\ud558\uc600\uc2b5\ub2c8\ub2e4.", 0);
                                        continue block14;
                                    }
                                    console.setValueBack("[" + shopinfo + "] - '" + questListDto.getSubject() + "' \ubb38\uc758\uc5d0 \ub300\ud55c \ub2f5\ubcc0 \uc800\uc7a5 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", 0);
                                    continue block14;
                                }
                            }
                            continue;
                        }
                        console.setValueBack("[" + shopinfo + "] \uc5d0 \ub300\ud55c \ub2f5\ubcc0 \ub9e4\ud551 \uc815\ubcf4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.", 0);
                    }
                }
                catch (Exception e) {
                    console.setValueBack(String.format("\ub2f5\ubcc0\uc791\uc131 \uc911\uc5d0 \uc77c\uc2dc\uc801\uc778 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \n[%s]", e.getMessage()), 50);
                }
            }
            console.setValueBack("\ub2f5\ubcc0 \uc791\uc131\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 100);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (reply) {
            try {
                console.setValueBack("\ucd5c\uadfc \uc77c\uc8fc\uc77c\uac04\uc758 \ub2f5\ubcc0\uc644\ub8cc \uc0c1\ud0dc \ubb38\uc758\ub97c \ud655\uc778\ud569\ub2c8\ub2e4.", 50);
                mapList = ShopQuestionDao.get().QuestionAnswer(start, end, opt);
                if (mapList == null || mapList.size() == 0) {
                    console.setValueBack("\ucd5c\uadfc \uc77c\uc8fc\uc77c\uac04 \ub2f5\ubcc0\uc644\ub8cc \uc0c1\ud0dc\uc758 \ubb38\uc758\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.", 90);
                } else if ((mapList = mapList.stream().filter(d -> qnalist.stream().anyMatch(p -> d.getShopnm().equals(p.getShopnm()) && d.getShopseq().equals(p.getShopseq()))).collect(Collectors.toList())) == null || mapList.size() == 0) {
                    console.setValueBack("\uc124\uc815\ud55c \uc1fc\ud551\ubab0 \uae30\uc900\uc73c\ub85c \ucd5c\uadfc \uc77c\uc8fc\uc77c\uac04 \uc870\ud68c\ub41c \ub2f5\ubcc0\uc644\ub8cc \ubb38\uc758\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.", 50);
                } else {
                    count = 0;
                    console.setValueBack("\uc870\uac74\uc5d0 \ub9de\ub294 " + mapList.size() + "\uac74 \ubb38\uc758\ub2f5\ubcc0 \uc804\uc1a1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", count);
                    ArrayList<QuestListDto> quest = new ArrayList<QuestListDto>();
                    for (QuestListDto dto : qnalist) {
                        param = mapList.stream().filter(p -> p.getShopnm().equals(dto.getShopnm())).filter(p -> p.getShopseq().equals(dto.getShopseq())).collect(Collectors.toList());
                        if (param.size() <= 0) continue;
                        for (QuestListDto que : param) {
                            que.setBtnstats("\uc804\uccb4");
                        }
                        ((QuestListDto)param.get(0)).setStartDt(dto.getStartDt());
                        ((QuestListDto)param.get(0)).setEndDt(dto.getEndDt());
                        ((QuestListDto)param.get(0)).setApikey(dto.getApikey());
                        ((QuestListDto)param.get(0)).setAuthkey1(dto.getAuthkey1());
                        ((QuestListDto)param.get(0)).setAuthkey2(dto.getAuthkey2());
                        ((QuestListDto)param.get(0)).setNickname(dto.getNickname());
                        ((QuestListDto)param.get(0)).setNickNm2(dto.getNickNm2());
                        ((QuestListDto)param.get(0)).setEditAuthkey1(dto.getEditAuthkey1());
                        ((QuestListDto)param.get(0)).setEditApikey(dto.getEditApikey());
                        ProductQuestionService service = new ProductQuestionService(IShopQuestion.getEnrollmentBean(dto.getShopnm()));
                        quest.addAll(service.excute(param));
                    }
                    if (quest.size() < 1) {
                        console.setValueBack("\ubaa8\ub4e0 \ub2f5\ubcc0\uc804\uc1a1\uc774 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc1fc\ud551\ubab0\uc744 \ud655\uc778 \ud6c4 \uc7a0\uc2dc \ud6c4 \ub2e4\uc2dc \uc2dc\ub3c4\ud574\uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.", 100);
                    } else {
                        for (QuestListDto dto : quest) {
                            if (dto.getCode().equals("200")) {
                                ShopQuestionDao.get().SenddtUpdate(Arrays.asList(dto));
                                console.setValue(String.format("%s", "[" + dto.getInsnm() + "]\ub2d8\uc758 \ub2f5\ubcc0\uc804\uc1a1\uc774 \uc131\uacf5\ud558\uc600\uc2b5\ub2c8\ub2e4."), ++count);
                                continue;
                            }
                            console.setValue("[" + dto.getInsnm() + "]\ub2d8\uc758 \ub2f5\ubcc0\uc804\uc1a1\uc774 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. (\uc2e4\ud328\ub0b4\uc6a9 : " + dto.getMessage() + ")", ++count);
                        }
                    }
                }
            }
            catch (Exception exception) {}
        }
        int i = 0;
        while (i < 5) {
            console.setValueBack("\ubb38\uc758 \ub2f5\ubcc0 \ubc0f \uc804\uc1a1 \uc791\uc5c5\uc774 \ub9c8\ubb34\ub9ac \ub418\uc5b4 " + String.valueOf(5 - i) + "\ucd08 \ub4a4\uc5d0 \ucc3d\uc774 \ub2eb\ud799\ub2c8\ub2e4.", 100);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                console.setValueBack("\ubb38\uc758\ub2f5\ubcc0 \ubc0f \uc804\uc1a1 \uc791\uc5c5 \uc791\uc5c5 \ub9c8\ubb34\ub9ac \ud6c4 \uc885\ub8cc \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc5ec \uc791\uc5c5\uc744 \uc885\ub8cc\ud569\ub2c8\ub2e4. \r\n " + e.getMessage(), 100);
                break;
            }
            ++i;
        }
        console.end();
    }

    private void triggerAutoSearchIfViewOpened() {
        Display.getDefault().syncExec(() -> {
            block7: {
                try {
                    IViewPart viewPart = null;
                    IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
                    int n = iWorkbenchWindowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                        try {
                            viewPart = window.getActivePage().showView(MainView.ID);
                        }
                        catch (Exception exception) {}
                        ++n2;
                    }
                    if (!(viewPart instanceof MainView)) break block7;
                    MainView view = (MainView)viewPart;
                    CTabFolder mainTabFolder = view.getMainTabFolder();
                    CTabItem[] cTabItemArray = mainTabFolder.getItems();
                    int n3 = cTabItemArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        CTabItem item = cTabItemArray[n4];
                        Control ctrl = item.getControl();
                        if (ctrl != null && ctrl instanceof QuestionsShoppingMallManager) {
                            ((QuestionsShoppingMallManager)ctrl).getShopQuestionsList();
                            break;
                        }
                        ++n4;
                    }
                }
                catch (Exception exception) {}
            }
        });
    }
}

