/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.roomnoffice;

import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.mlink.MLinkOption;
import com.kdjsystem.mlink.shop.mlink.MLinkOptionList;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.chrome.ChromeDriver;

public class RoomNOfficeOrderCommon {
    public static RoomNOfficeOrderCommon instance = new RoomNOfficeOrderCommon();

    private RoomNOfficeOrderCommon() {
    }

    public static RoomNOfficeOrderCommon get() {
        return instance;
    }

    public List<ShopOrderMstDto> getSearchRoomNOfficeProd(Map<String, String> cookies, List<ShopOrderMstDto> list, ChromeDriver driver) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        try {
            for (ShopOrderMstDto dto : list) {
                Connection.Response response = Jsoup.connect((String)("https://ydinc.cafe24.com/product/detail.html?product_no=" + dto.getCompayny_goods_cd().replaceAll("RM", ""))).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").data("product_no", dto.getCompayny_goods_cd().replaceAll("RM", "")).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response.body());
                String productName = body.select("tr:contains(\uc0c1\ud488\uba85) td").text();
                String price2 = body.select("tr:contains(\ud310\ub9e4\uac00) td strong#span_product_price_text").text().replaceAll("[^\\d]", "");
                String imageUrl = body.select("div.thumbnail img").attr("src");
                dto.setOrdimg("https:" + imageUrl);
                dto.setDsGoods_cost(price2);
                dto.setProduct_name(productName);
                dto.setGoods_keyword("shop9986");
                Elements optionTables = body.select("table.xans-product-option");
                Elements optionRows = optionTables.select("th[scope='row']");
                StringBuilder options = new StringBuilder();
                String sku_value = "";
                if (optionRows.size() > 1) {
                    String optionTitle1 = ((Element)optionRows.get(0)).select("th[scope='row']").text();
                    String optionTitle2 = ((Element)optionRows.get(1)).select("th[scope='row']").text();
                    options.append("[").append(optionTitle1).append("=").append(optionTitle2).append("]\n");
                    Elements optionElements1 = ((Element)optionTables.select("tbody tr").get(0)).select("td select option");
                    Elements optionElements2 = ((Element)optionTables.select("tbody tr").get(1)).select("td select option");
                    for (Element optionElement1 : optionElements1) {
                        String optionValue1 = optionElement1.text().trim();
                        if (optionValue1.contains("[\ud544\uc218]") || optionValue1.contains("----------") || optionValue1.isEmpty()) continue;
                        for (Element optionElement2 : optionElements2) {
                            String optionValue2 = optionElement2.text().trim();
                            if (optionValue2.contains("[\ud544\uc218]") || optionValue2.contains("----------") || optionValue2.isEmpty()) continue;
                            options.append(optionValue1).append("=").append(optionValue2).append("=").append(price2).append("=").append(price2).append("=0=0\n");
                        }
                    }
                    sku_value = String.valueOf(optionTitle1) + ":" + optionTitle2;
                } else {
                    String optionTitle = ((Element)optionRows.get(0)).select("th[scope='row']").text();
                    Elements optionElements = ((Element)optionTables.select("tbody tr").get(0)).select("td select option");
                    options.append("[").append(optionTitle).append("]\n");
                    for (Element optionElement : optionElements) {
                        String optionValue = optionElement.text().trim();
                        if (optionValue.contains("[\ud544\uc218]") || optionValue.contains("----------") || optionValue.isEmpty()) continue;
                        options.append(optionValue).append("=").append(price2).append("=").append(price2).append("=0=0\n");
                    }
                    sku_value = optionTitle;
                }
                if (sku_value.endsWith(":")) {
                    sku_value = sku_value.substring(0, sku_value.length() - 1);
                }
                if (options.length() == 0) {
                    sku_value = "\ub2e8\ud488";
                }
                dto.setDosinoption(options.toString());
                dto.setSku_value(sku_value);
                dto.setDosinstatus("\ud310\ub9e4\uc911");
                Element deliveryInfo = body.select("div.cont:contains(\ubc30\uc1a1\uc815\ubcf4) ul.delivery").first();
                Elements deliveryItems = deliveryInfo.select("li");
                block6: for (Element item : deliveryItems) {
                    if (!item.text().contains("\ubc30\uc1a1 \ube44\uc6a9")) continue;
                    String deliveryCostText = item.text();
                    Pattern pattern = Pattern.compile("\\b\\d{1,3}(,\\d{3})*(\\.\\d+)?\\b");
                    Matcher matcher = pattern.matcher(deliveryCostText);
                    String deliveryCost = "";
                    if (matcher.find()) {
                        deliveryCost = matcher.group().replaceAll(",", "");
                    }
                    dto.setDsdelv_cost(deliveryCost);
                    if (deliveryCostText.contains("\ucc29\ubd88")) {
                        dto.setDsdelv_type("2");
                        break;
                    }
                    if (deliveryCostText.contains("~")) {
                        dto.setDsdelv_type("3");
                        Element differentialShipping = body.select("div.differentialShipping").first();
                        Elements shippingConditions = differentialShipping.select("ul li");
                        for (Element condition : shippingConditions) {
                            String conditionText = condition.text();
                            if (!conditionText.contains("\uac1c \ubbf8\ub9cc")) continue;
                            String[] parts = conditionText.split(" ");
                            String maxCount = parts[3].replace("\uac1c", "").trim();
                            String minCount = parts[0].replace("\uac1c", "").trim();
                            int deliveryUnit = Integer.parseInt(maxCount) - Integer.parseInt(minCount);
                            dto.setDsdelv_qty(String.valueOf(deliveryUnit));
                            break block6;
                        }
                        break;
                    }
                    dto.setDsdelv_type("0");
                    break;
                }
                ret.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public List<ShopOrderMstDto> roomNOfficeOptionSetting(List<ShopOrderMstDto> list) {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        for (ShopOrderMstDto dto : list) {
            String optinon = "\uc635\uc158\uc120\ud0dd``";
            List<MLinkOption> options = this.getOptionList((String)dto.getDosinoption()).options;
            for (MLinkOption option2 : options) {
                int optionPrice = option2.getOptionPrice() - Integer.parseInt(dto.getDsGoods_cost());
                optinon = String.valueOf(optinon) + (!option2.getOptionName1().equals("") ? option2.getOptionName1().concat(option2.getOptionName2().equals("") ? "+" + optionPrice : ":" + option2.getOptionName2() + "+" + optionPrice) : "");
                optinon = String.valueOf(optinon) + "``";
            }
            dto.setDosinoption(optinon);
            ret.add(dto);
        }
        return ret;
    }

    public MLinkOptionList getOptionList(String option2) {
        MLinkOptionList optionList = new MLinkOptionList();
        ArrayList<MLinkOption> ret_options = new ArrayList<MLinkOption>();
        List lines = Arrays.stream(option2.split("\\r|\\n")).collect(Collectors.toList());
        YDMAStringUtil.Print();
        String title = (String)lines.get(0);
        lines.remove(0);
        title = title.replace("[", "");
        title = title.replace("]", "");
        int dan = title.indexOf("=") > 0 ? 2 : 1;
        optionList.setDan(dan);
        if (dan == 1) {
            String char_1_nm = title.indexOf("\uc0c9\uc0c1") > 0 ? "\uce7c\ub77c" : title;
            optionList.setChar_1_nm(char_1_nm);
        } else {
            String[] charnms = title.split("=");
            if (charnms[0].indexOf("\uc0c9\uc0c1") > 0) {
                optionList.setChar_1_nm("\uce7c\ub77c");
            } else {
                optionList.setChar_1_nm(charnms[0]);
            }
            optionList.setChar_2_nm(charnms[1]);
        }
        for (String line : lines) {
            MLinkOption dto = new MLinkOption();
            List<String> lst_option = Arrays.asList(line.split("="));
            if (dan == 1) {
                dto.setOptionName1(lst_option.get(0));
                dto.setOptionName2("");
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt("0"));
            } else {
                dto.setOptionName1(lst_option.get(0));
                dto.setOptionName2(lst_option.get(1));
                dto.setOptionPrice(YDMAStringUtil.convertToInt(lst_option.get(2)));
                dto.setCompliancePrice(YDMAStringUtil.convertToInt(lst_option.get(3)));
                dto.setRetailPrice(YDMAStringUtil.convertToInt(lst_option.get(4)));
                dto.setSoldOut(YDMAStringUtil.convertToInt(lst_option.get(5)));
            }
            ret_options.add(dto);
        }
        if (ret_options.size() > 0 && dan == 2) {
            String char_2_val = ret_options.stream().map(p -> p.getOptionName2()).collect(Collectors.joining(","));
            optionList.setChar_2_val(char_2_val);
        }
        optionList.setOptions(ret_options);
        return optionList;
    }
}

