/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot;

import com.kdjsystem.mlink.shop.mlink.MLinkAPI;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class InstanceSocketServer
implements Runnable {
    private int instanceCount = 0;
    private ServerSocket serverSocket;
    private volatile boolean running = true;
    private int port;

    public InstanceSocketServer(int port) throws IOException {
        this.port = port;
        this.serverSocket = new ServerSocket(port);
    }

    @Override
    public void run() {
        YDMAStringUtil.Print("Socket server started on port " + this.port);
        while (this.running) {
            try {
                Socket client = this.serverSocket.accept();
                BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                PrintWriter out = new PrintWriter(client.getOutputStream(), true);
                String command = in.readLine();
                if (command != null) {
                    if ("INC".equalsIgnoreCase(command)) {
                        ++this.instanceCount;
                        YDMAStringUtil.Print("Received INC command. New count: " + this.instanceCount);
                    } else if ("GET".equalsIgnoreCase(command)) {
                        YDMAStringUtil.Print("Received GET command. Current count: " + this.instanceCount);
                    } else if ("DEC".equalsIgnoreCase(command)) {
                        this.instanceCount = Math.max(0, this.instanceCount - 1);
                        YDMAStringUtil.Print("Received DEC command. New count: " + this.instanceCount);
                    } else {
                        YDMAStringUtil.Print("Unknown command received: " + command);
                    }
                }
                out.println(this.instanceCount);
                client.close();
            }
            catch (IOException e) {
                if (!this.running) continue;
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        this.running = false;
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
                this.performCleanup();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void performCleanup() {
        YDMAStringUtil.Print("\ub9c8\uc9c0\ub9c9 \uc778\uc2a4\ud134\uc2a4 \uc885\ub8cc. \ucd5c\uc885 \ud074\ub9b0\uc5c5 \uc791\uc5c5\uc744 \uc218\ud589\ud569\ub2c8\ub2e4.");
        MLinkAPI.get().setUserCountPermitAPI("InActive");
    }
}

