/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot;

import com.kdjsystem.mlink.tot.logging.AppLog;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public final class NoUpdateDialogKiller {
    private static final AtomicBoolean INSTALLED = new AtomicBoolean(false);
    private static final boolean DEBUG = Boolean.getBoolean("mlink.debug");
    private static final Pattern[] MSG = new Pattern[]{Pattern.compile("no\\s+updates\\s+were\\s+found", 2), Pattern.compile("available\\s+software\\s+sites", 2), Pattern.compile("\ufffd\ubfbd\ufffd\ub732\ufffd\uc520\ufffd\ub4c3[^\\n]*\ufffd\ubfbe\ufffd\ub4bf"), Pattern.compile("\ufffd\ubfbd\ufffd\ub732\ufffd\uc520\ufffd\ub4c3[^\\n]*\uf9e1\uc5a0\uc4e3\\s*\ufffd\ub2d4\\s*\ufffd\ubfbe")};

    private NoUpdateDialogKiller() {
    }

    public static void install() {
        if (!PlatformUI.isWorkbenchRunning()) {
            AppLog.info("NoUpdateDialogKiller.install() skipped: workbench not running");
            return;
        }
        if (!INSTALLED.compareAndSet(false, true)) {
            AppLog.info("NoUpdateDialogKiller.install() skipped: already installed");
            return;
        }
        AppLog.info("NoUpdateDialogKiller.install(): OK");
        Display d = PlatformUI.getWorkbench().getDisplay();
        NoUpdateDialogKiller.startScanner(d, 750);
        AppLog.info("install: after startScanner");
        Listener l = e -> {
            if (e.widget instanceof Shell) {
                Shell sh = (Shell)e.widget;
                AppLog.info("ShellEvent: type=" + (e.type == 22 ? "Show" : "Activate") + ", title='" + NoUpdateDialogKiller.safe(sh.getText()) + "', style=0x" + Integer.toHexString(sh.getStyle()));
                d.timerExec(40, () -> NoUpdateDialogKiller.tryKill(sh, "event#1"));
                d.timerExec(200, () -> NoUpdateDialogKiller.tryKill(sh, "event#2"));
                d.timerExec(500, () -> NoUpdateDialogKiller.tryKill(sh, "event#3"));
            }
        };
        d.addFilter(22, l);
        d.addFilter(26, l);
    }

    private static void startScanner(final Display d, final int intervalMs) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (d.isDisposed()) {
                    return;
                }
                Shell[] shellArray = d.getShells();
                int n = shellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell s = shellArray[n2];
                    NoUpdateDialogKiller.tryKill(s, "scan");
                    ++n2;
                }
                d.timerExec(intervalMs, (Runnable)this);
            }
        };
        d.timerExec(0, r);
    }

    private static void tryKill(Shell shell, String origin) {
        boolean structuralHit;
        AppLog.info("tryKill: begin [" + origin + "]");
        if (shell == null || shell.isDisposed()) {
            return;
        }
        AppLog.info("tryKill: shell ok [" + origin + "] title='" + NoUpdateDialogKiller.safe(shell.getText()) + "'");
        if (Boolean.TRUE.equals(shell.getData("noUpdateKilled"))) {
            return;
        }
        AppLog.info("tryKill: noUpdateKilled ok [" + origin + "]");
        String title = NoUpdateDialogKiller.safe(shell.getText());
        String payloadRaw = String.valueOf(title) + "\n" + NoUpdateDialogKiller.collectText((Composite)shell);
        String normalized = NoUpdateDialogKiller.normalize(payloadRaw);
        if (DEBUG || NoUpdateDialogKiller.titleMatches(title)) {
            AppLog.debug("Killer.try [" + origin + "] title='" + title + "'");
            AppLog.debug("Killer.try [" + origin + "] normalized='" + normalized + "'");
        }
        AppLog.info("tryKill: before matches(normalized) [" + origin + "]");
        boolean contentHit = NoUpdateDialogKiller.matches(normalized);
        boolean bl = structuralHit = NoUpdateDialogKiller.isInfoLike(shell) && NoUpdateDialogKiller.hasAnyLink((Composite)shell) && NoUpdateDialogKiller.findPush((Control)shell, "OK", "\ufffd\uc197\ufffd\uc524", "Close", "\ufffd\ub595\u6e72\ufffd") != null;
        if (!contentHit && !structuralHit) {
            return;
        }
        shell.setData("noUpdateKilled", (Object)Boolean.TRUE);
        AppLog.info("Killer.MATCH [" + origin + "] \ufffd\ub102 auto-close" + " (contentHit=" + contentHit + ", structuralHit=" + structuralHit + ")" + ", title='" + title + "'");
        Button ok = shell.getDefaultButton();
        if (ok == null || ok.isDisposed()) {
            ok = NoUpdateDialogKiller.findPush((Control)shell, "OK", "\ufffd\uc197\ufffd\uc524", "Close", "\ufffd\ub595\u6e72\ufffd");
        }
        Button toClick = ok;
        shell.getDisplay().timerExec(50, () -> {
            if (toClick != null && !toClick.isDisposed()) {
                Event ev = new Event();
                ev.widget = toClick;
                toClick.notifyListeners(13, ev);
                AppLog.info("Killer.CLICK [" + origin + "] default/OK button notified");
            } else if (!shell.isDisposed()) {
                shell.close();
                AppLog.info("Killer.CLOSE [" + origin + "] shell.close() called");
            }
        });
    }

    private static boolean isInfoLike(Shell shell) {
        String t = NoUpdateDialogKiller.safe(shell.getText()).toLowerCase();
        return t.contains("\ufffd\uc819\u8e42\ufffd") || t.contains("information") || t.contains("message");
    }

    private static boolean hasAnyLink(Composite root) {
        return NoUpdateDialogKiller.findFirst(root, Link.class) != null;
    }

    private static <T extends Control> T findFirst(Composite parent, Class<T> type) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            T r;
            Control c = controlArray[n2];
            if (type.isInstance(c)) {
                return (T)((Control)type.cast(c));
            }
            if (c instanceof Composite && (r = NoUpdateDialogKiller.findFirst((Composite)c, type)) != null) {
                return r;
            }
            ++n2;
        }
        return null;
    }

    private static boolean titleMatches(String title) {
        String t = title.toLowerCase();
        return t.contains("\ufffd\uc819\u8e42\ufffd") || t.contains("information") || t.contains("software updates");
    }

    private static String safe(String s) {
        return s == null ? "" : s;
    }

    private static boolean matches(String s) {
        AppLog.info("matches: " + s);
        Pattern[] patternArray = MSG;
        int n = MSG.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            if (p.matcher(s).find()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static String normalize(String raw) {
        if (raw == null) {
            return "";
        }
        String s = raw;
        s = s.replace("&", "");
        s = s.replaceAll("<[^>]+>", " ");
        s = s.replace('\u00a0', ' ');
        s = s.replaceAll("\\s+", " ").trim();
        return s;
    }

    private static String collectText(Composite root) {
        StringBuilder sb = new StringBuilder(256);
        NoUpdateDialogKiller.collect(root, sb);
        return sb.toString();
    }

    private static void collect(Composite parent, StringBuilder out) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            String x;
            Control c = controlArray[n2];
            if (c instanceof Composite) {
                NoUpdateDialogKiller.collect((Composite)c, out);
            } else if (c instanceof Label) {
                x = ((Label)c).getText();
                if (x != null && !x.isEmpty()) {
                    out.append(x).append('\n');
                }
            } else if (c instanceof Link) {
                x = ((Link)c).getText();
                if (x != null && !x.isEmpty()) {
                    out.append(x).append('\n');
                }
            } else if (c instanceof Text) {
                x = ((Text)c).getText();
                if (x != null && !x.isEmpty()) {
                    out.append(x).append('\n');
                }
            } else if (c instanceof Button && (x = ((Button)c).getText()) != null && !x.isEmpty()) {
                out.append(x).append('\n');
            }
            ++n2;
        }
    }

    private static Button findPush(Control c, String ... labels) {
        Button b;
        if (c instanceof Button && ((b = (Button)c).getStyle() & 8) != 0) {
            String txt = NoUpdateDialogKiller.safe(b.getText()).replace("&", "");
            String[] stringArray = labels;
            int n = labels.length;
            int n2 = 0;
            while (n2 < n) {
                String want = stringArray[n2];
                if (txt.equalsIgnoreCase(want)) {
                    return b;
                }
                ++n2;
            }
        }
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n3 = 0;
            while (n3 < n) {
                Control child = controlArray[n3];
                Button r = NoUpdateDialogKiller.findPush(child, labels);
                if (r != null) {
                    return r;
                }
                ++n3;
            }
        }
        return null;
    }
}

