/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class AlimTalkChargeDao {
    public List<String> getAlimTalkChargeList(String userid) throws Exception {
        String url = String.format("http://api.kdjsystem.com:8080/api/v1/smschargeselect?userid=%s", userid);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        Request request2 = new Request.Builder().url(url).method("GET", null).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string();
        data2 = data2.substring(data2.indexOf("[") + 1, data2.indexOf("]"));
        data2 = data2.replaceAll("\"", "");
        return Arrays.asList(data2.split(","));
    }

    public int updateMoneyKakaoInfo(String userid, int price2, int total, String content, String type, String tocontact) throws Exception {
        JsonObject obj = new JsonObject();
        obj.addProperty("userid", userid);
        obj.addProperty("smsuseamt", (Number)price2);
        obj.addProperty("smsbalance", (Number)total);
        obj.addProperty("content", content);
        obj.addProperty("smstype", type);
        obj.addProperty("tocontact", tocontact);
        String url = "http://api.kdjsystem.com:8080/api/v1/smschargemst";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)obj.toString());
        Request request2 = new Request.Builder().url(url).method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string().toString();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
        return jsonObject.get("returnCode").getAsInt();
    }

    public int insertMoneyKakaoDetail(String aliaseseq, String tocontact, String contents, String sentdate, String timespent, String type, String userid) throws Exception {
        contents.replaceAll("\r\n", "\n");
        JsonObject obj = new JsonObject();
        obj.addProperty("compno", YDMASessonUtil.getCompnoInfo().getCompno());
        obj.addProperty("aliaseseq", aliaseseq);
        obj.addProperty("tocontact", tocontact);
        obj.addProperty("contents", contents);
        obj.addProperty("sentdate", sentdate);
        obj.addProperty("timespent", timespent);
        obj.addProperty("smstype", type);
        obj.addProperty("userid", userid);
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)obj.toString());
        Request request2 = new Request.Builder().url("http://api.kdjsystem.com:8080/api/v1/smschargedtl").method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string().toString();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
        return jsonObject.get("returnCode").getAsInt();
    }

    public List<String> getTemplateCodeList(String compno, String template) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(COMPNO,''), ifnull(AREAOFUSE,''),ifnull(TEMPLATECODE,'') from kakaotemp where COMPNO=? and areaofuse = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, template);
                rs = pstmt.executeQuery();
                YDMAStringUtil.Print("[getTemplateCodeList]" + pstmt.toString());
                while (rs.next()) {
                    int i = 0;
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<List<String>> getKakaoSearchListSelect(int select, String orddtFrom, String orddtTo, String content, List<String> list2) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        String json = "{\"userid\" : \"" + list2.get(8) + "\" , \"select\" : " + select + " , \"orddtFrom\" : \"" + orddtFrom + "\" , \"orddtTo\" : \"" + orddtTo + "\" , \"content\" : \"" + content + "\"}";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url("http://api.kdjsystem.com:8080/api/v1/smsdtl").method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string().toString();
        JsonParser jsonParser = new JsonParser();
        JsonArray jsonArray = (JsonArray)jsonParser.parse(data2);
        int i = 0;
        while (i < jsonArray.size()) {
            JsonArray datadtl = (JsonArray)jsonArray.get(i);
            ArrayList<String> list = new ArrayList<String>();
            int k = 0;
            while (k < datadtl.size()) {
                list.add(datadtl.get(k).getAsString());
                ++k;
            }
            contents.add(list);
            ++i;
        }
        return contents;
    }

    public List<String> getSmsChargeMstList() throws Exception {
        String url = String.format("http://api.kdjsystem.com:8080/api/v1/smschargeselect?userid=%s", YDMASessonUtil.getUserInfo().getUserId());
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType.parse((String)"application/json");
        Request request2 = new Request.Builder().url(url).method("GET", null).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string();
        data2 = data2.substring(data2.indexOf("[") + 1, data2.indexOf("]"));
        data2 = data2.replaceAll("\"", "");
        return Arrays.asList(data2.split(","));
    }

    public List<List<String>> getSmsTemplateList() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(COMPNO,''), ifnull(AREAOFUSE,''),ifnull(TEMPLATECODE,''), ifnull(CONTENT,'') from kakaotemp where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                YDMAStringUtil.Print("[getSmsTemplateList]" + pstmt.toString());
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int i = 0;
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int updateMoneyKakaoSeqUpdate(String num, String userid) throws Exception {
        String json = "{\"userid\" : \"" + userid + "\" , \"serialno\" : \"" + num + "\" }";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url("http://api.kdjsystem.com:8080/api/v1/smschargeserialup").method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string().toString();
        JsonParser jsonParser = new JsonParser();
        JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
        return jsonObject.get("returnCode").getAsInt();
    }

    public List<String> getTemplist() throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(AREAOFUSE,'')  from kakaotemp where compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                rs = pstmt.executeQuery();
                YDMAStringUtil.Print("[getSmsTemplateList]" + pstmt.toString());
                while (rs.next()) {
                    int i = 0;
                    list.add(rs.getString(++i));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void updateseqNumber(String compno, String num) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                PreparedStatement pstmt_prodmst = null;
                String sql_prodmst = "update SMSCHARGEMST set SERIALno=?  where COMPNo=?";
                sql_prodmst = sql_prodmst.toUpperCase();
                pstmt_prodmst = connection.prepareStatement(sql_prodmst);
                statementlist.add(pstmt_prodmst);
                pstmt_prodmst.setInt(1, Integer.parseInt(num));
                pstmt_prodmst.setString(2, compno);
                pstmt_prodmst.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public int setAutoSendInvoice(String orddt, String ordseq, String seq, String recvname, String senddate, String prodcd) {
        int result = 0;
        try {
            String infornm = this.getInfforName(prodcd);
            String json = "{\"compno\" : " + YDMASessonUtil.getCompnoInfo().getCompno() + " ,\"orddt\" : \"" + orddt + "\" , \"ordseq\" : \"" + ordseq + "\", " + "\"seq\" : \"" + seq + "\" , \"receive_name\" : \"" + recvname + "\", \"senddate\" : \"" + senddate + "\" , \"dlv_id\" : \"" + infornm + "\"}";
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url("http://api.kdjsystem.com:8080/api/v1/invoice").method("POST", body).addHeader("Content-Type", "application/json").build();
            Response response = client.newCall(request2).execute();
            String data2 = response.body().string().toString();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
            result = jsonObject.get("returnCode").getAsInt();
        }
        catch (Exception exception) {
            return result;
        }
        return result;
    }

    private String getInfforName(String prodcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String name = "";
        new ArrayList();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT b.INFORNM FROM prodmst AS a JOIN prodinfor AS b ON a.compno = b.COMPNO AND a.infornum = b.SEQ WHERE a.compno = ? AND a.prodcd = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, prodcd);
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    String string = rs.getString(++i).equals("\ud654\uac1c\uc81c\ub2e4") ? "\ub85c\uc820\ud0dd\ubc30" : (name = rs.getString(i).equals("\uccad\ubc31\uc6d0") ? "CJ \ub300\ud55c\ud1b5\uc6b4" : "");
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return name;
    }

    public List<List<String>> getKakaoAllListSelect(String userId, String orddtFrom, String orddtTo, String telno, String content, String type) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        String json = "{\r\n    \"userid\" : \"" + userId + "\",\r\n" + "    \"dateFrom\" : \"" + orddtFrom + "\",\r\n" + "    \"dateTo\" : \"" + orddtTo + "\",\r\n" + "    \"telno\" : \"" + telno + "\",\r\n" + "    \"content\" : \"" + content + "\",\r\n" + "    \"type\" : \"" + type + "\"\r\n" + "}";
        OkHttpClient client = new OkHttpClient().newBuilder().build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url("http://api.kdjsystem.com:8080/api/v1/smschargedtlall").method("POST", body).addHeader("Content-Type", "application/json").build();
        Response response = client.newCall(request2).execute();
        String data2 = response.body().string().toString();
        JsonParser jsonParser = new JsonParser();
        JsonArray jsonArray = (JsonArray)jsonParser.parse(data2);
        int i = 0;
        while (i < jsonArray.size()) {
            JsonArray datadtl = (JsonArray)jsonArray.get(i);
            ArrayList<String> list = new ArrayList<String>();
            int k = 0;
            while (k < datadtl.size()) {
                list.add(datadtl.get(k).getAsString());
                ++k;
            }
            contents.add(list);
            ++i;
        }
        return contents;
    }
}

