/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class ClaimProcTypeDao {
    public List<String> getProcTypeCode(int brandcd) throws Exception {
        ArrayList<String> contents = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT\tproctypecd FROM\tPROCTYPE WHERE\tcompno\t=\t? AND\tbrandcd\t=\t? ";
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                YDMAStringUtil.Print("[getProcTypeCode]" + pstmt.toString());
                rs = pstmt.executeQuery();
                rs.last();
                int rowcount = rs.getRow();
                if (rowcount > 0) {
                    contents = new ArrayList<String>();
                    rs.beforeFirst();
                    while (rs.next()) {
                        contents.add(rs.getString("proctypecd"));
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getClaimProcTypeListByName(int opt, String optStr, int brandcd) throws Exception {
        ArrayList<List<String>> contents = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT\tproctypecd,\tinouttype,\tdeliverytype,\tsortrank FROM\tPROCTYPE WHERE\tcompno\t=\t? AND\tbrandcd\t=\t? ";
                if (opt == 0) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + "AND\tproctypecd\tlike\t? ";
                    }
                    sql = String.valueOf(sql) + "  ORDER\tBY\tsortrank,\tproctypecd ";
                } else if (opt == 1) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " AND\tproctypecd\tlike\t? ";
                    }
                    sql = String.valueOf(sql) + "\tORDER\tBY\tsortrank,\tproctypecd ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                if (optStr.length() != 0) {
                    pstmt.setString(3, "%" + optStr + "%");
                }
                YDMAStringUtil.Print("[getClaimProcTypeListByName]" + pstmt.toString());
                rs = pstmt.executeQuery();
                rs.last();
                int rowcount = rs.getRow();
                if (rowcount > 0) {
                    rs.beforeFirst();
                    contents = new ArrayList<List<String>>();
                    int rowno = 0;
                    while (rs.next()) {
                        int i = 0;
                        ArrayList<String> list = new ArrayList<String>();
                        list.add("" + ++rowno);
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        contents.add(list);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public String getInOutType(int brandcd, String proctypecd) throws Exception {
        String strInOutType = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT\tIFNULL(inouttype, '') AS inouttype FROM\tPROCTYPE WHERE\tcompno\t\t=\t? AND\tbrandcd\t\t=\t? AND\tproctypecd\t=\t? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, proctypecd);
                YDMAStringUtil.Print("[getInOutType]" + pstmt.toString());
                rs = pstmt.executeQuery();
                strInOutType = rs.next() ? rs.getString("inouttype") : "";
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return strInOutType;
    }

    public boolean checkUsingProcType(int brandcd, String proctypecd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT\tproctype FROM\tclmlist WHERE\tcompno\t\t=\t? AND\tbrandcd\t\t=\t? AND\tproctype\t=\t? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, proctypecd);
                YDMAStringUtil.Print("[checkExistClaimProcType]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean checkExistClaimProcType(int brandcd, String proctypecd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT\tproctypecd FROM\tproctype WHERE\tcompno\t\t=\t? AND\tbrandcd\t\t=\t? AND\tproctypecd\t=\t? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, proctypecd);
                YDMAStringUtil.Print("[checkExistClaimProcType]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public int insertClaimProcType(int brandcd, String proctypecd, String inouttype, String deliverytype, String sortrank) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert\tinto\tproctype\t(compno,\tbrandcd,\tproctypecd,\tinouttype,\tdeliverytype,\tsortrank) \t\t\t\tvalues\t\t(?,\t\t\t?,\t\t\t?,\t\t\t?,\t\t\t?,\t\t\t\t?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, proctypecd);
                pstmt.setString(4, inouttype);
                pstmt.setString(5, deliverytype);
                pstmt.setString(6, sortrank);
                YDMAStringUtil.Print("[insertClaimProcType]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public void deleteProcType(int brandcd, String[] proctypecd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                String sql = "DELETE\tFROM\tproctype WHERE\tcompno\t\t=\t? AND\tbrandcd\t\t=\t? AND\tproctypecd\t=\t? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                int i = 0;
                while (i < proctypecd.length) {
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(2, brandcd);
                    pstmt.setString(3, proctypecd[i]);
                    YDMAStringUtil.Print("[deleteProcType]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public int updateClaimProcType(int brandcd, String proctypecd, String inouttype, String deliverytype, String sortrank) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update\tproctype set\tinouttype\t\t=\t?, \t\tdeliverytype\t=\t?, \t\tsortrank\t\t=\t?  where\tcompno\t\t\t=\t?  and\tbrandcd\t\t\t=\t?  and\tproctypecd\t\t=\t?  ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, inouttype);
                pstmt.setString(2, deliverytype);
                pstmt.setString(3, sortrank);
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(5, brandcd);
                pstmt.setString(6, proctypecd);
                YDMAStringUtil.Print("[updateClaimProcType]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<String> getClaimProcTypeInfoByProctype(int brandcd, String proctypecd) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select\tifnull(proctypecd,'') as proctypecd,\t\tifnull(inouttype,'') as inouttype, \t\tifnull(deliverytype,'') as deliverytype,\tifnull(sortrank,'') as sortrank from\tproctype where\tcompno\t\t=\t? and\tbrandcd\t\t=\t? and\tproctypecd\t=\t? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, proctypecd);
                YDMAStringUtil.Print("[getClaimProcTypeInfoByProctype]" + pstmt.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    list.add(rs.getString("proctypecd"));
                    list.add(rs.getString("inouttype"));
                    list.add(rs.getString("deliverytype"));
                    list.add(rs.getString("sortrank"));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }
}

