/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class CustomerDao {
    public List<List<String>> getCustListForClaimManager(int opt, String optStr) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select  ifnull(A.CUSTNO,''), ifnull(A.CUSTNM,''),  ifnull(A.CEONM,''),ifnull(A.TELNO,''),ifnull(A.ADDRESS,'')   FROM  CUSTMST A";
                if (opt == 0) {
                    sql = String.valueOf(sql) + " where  custno like ? and A.compno = ? ";
                    sql = String.valueOf(sql) + "  order by A.CUSTNO ";
                } else if (opt == 1) {
                    sql = String.valueOf(sql) + " where  CUSTNM like ? and A.compno = ? ";
                    sql = String.valueOf(sql) + "  order by A.CUSTNM ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, "%" + optStr + "%");
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCustListForClaimManager]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getCustomerListByName(int opt, String optStr, int brandcd) throws Exception {
        ArrayList<List<String>> contents = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT custno, custnm, ceonm, telno, ifnull(faxno,''),cphon,ifnull(cphonaddr,''), ifnull(email,''),address,  ifnull(direct,''), ifnull(USEYN,'') FROM custmst where compno = ? and brandcd = ? ";
                if (opt == 0) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  custno like ? ";
                    }
                    sql = String.valueOf(sql) + "  order by custno ";
                } else if (opt == 1) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  custnm like ? ";
                    }
                    sql = String.valueOf(sql) + "  order by custnm ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                if (optStr.length() != 0) {
                    pstmt.setString(3, "%" + optStr + "%");
                }
                YDMAStringUtil.Print("[getCustomerListByName]" + pstmt.toString());
                rs = pstmt.executeQuery();
                rs.last();
                int rowcount = rs.getRow();
                if (rowcount > 0) {
                    rs.beforeFirst();
                    contents = new ArrayList<List<String>>();
                    int rowno = 0;
                    while (rs.next()) {
                        int i = 0;
                        ArrayList<String> list = new ArrayList<String>();
                        list.add("" + ++rowno);
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        list.add(rs.getString(++i));
                        contents.add(list);
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public boolean checkExistCustomer(String custno) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select  custno from custmst where custno = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, custno);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[checkExistCustomer]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public int insertCustomer(String custno, String custnm, String ceonm, String telno, String cphon, String address, String useyn, String faxno, String kakao, String email, String jiksong, int brandcd) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into custmst (compno, custno, custnm, ceonm, telno, faxno,cphon,cphonaddr,email, address, direct,USEYN,brandcd)  values (?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?,?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, custno);
                pstmt.setString(3, custnm);
                pstmt.setString(4, ceonm);
                pstmt.setString(5, telno);
                pstmt.setString(6, faxno);
                pstmt.setString(7, cphon);
                pstmt.setString(8, kakao);
                pstmt.setString(9, email);
                pstmt.setString(10, address);
                pstmt.setString(11, jiksong);
                pstmt.setString(12, useyn);
                pstmt.setInt(13, brandcd);
                YDMAStringUtil.Print("[insertUser]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int updateCustomer(String custno, String custnm, String ceonm, String telno, String cphon, String address, String useyn, String faxno, String kakao, String email, String jiksong, int brandcd) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update custmst set custnm=?, ceonm=?, telno=?, cphon=?, address=?, useyn=?, faxno = ?, cphonaddr = ?, email=?, direct =?";
                sql = String.valueOf(sql) + " where custno=? and compno = ? and brandcd =?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, custnm);
                pstmt.setString(2, ceonm);
                pstmt.setString(3, telno);
                pstmt.setString(4, cphon);
                pstmt.setString(5, address);
                pstmt.setString(6, useyn);
                pstmt.setString(7, faxno);
                pstmt.setString(8, kakao);
                pstmt.setString(9, email);
                pstmt.setString(10, jiksong);
                pstmt.setString(11, custno);
                pstmt.setString(12, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(13, brandcd);
                YDMAStringUtil.Print("[updateCustomer]" + pstmt.toString());
                result = pstmt.executeUpdate();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<String> getCustomerInfoByCustno(String custno) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(custno,''), ifnull(custnm,''), ifnull(ceonm,''),  ifnull(telno,''), ifnull(faxno,''), ifnull(cphon,''), ifnull(cphonaddr,''), ifnull(email,''),ifnull(address,''), ifnull(direct,''),ifnull(USEYN,'') from custmst ";
                sql = String.valueOf(sql) + " Where custno = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, custno);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCustomerInfoByCustno]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int i = 0;
                if (rs.next()) {
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<List<String>> getCustListForProductOrderList(int select, String search) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select  ifnull(compno,''), ifnull(custno,''), ifnull(custnm,''), ifnull(ceonm,''), ifnull(telno,''),ifnull(faxno,''),ifnull(cphon,''), ifnull(cphonaddr,''), ifnull(email,''), ifnull(address,''), ifnull(direct,'N'), ifnull(useyn,'N') FROM  CUSTMST ";
                if (select == 0) {
                    sql = String.valueOf(sql) + " where  custnm like ? and compno = ? ";
                    sql = String.valueOf(sql) + "  order by custnm ";
                } else if (select == 1) {
                    sql = String.valueOf(sql) + " where  ceonm like ? and compno = ? ";
                    sql = String.valueOf(sql) + "  order by ceonm ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, "%" + search + "%");
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getCustListForClaimManager]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }
}

