/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.PickupDto;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class OrderDao {
    public int getEcountSentOrderNum(String orddt, String ordseq) throws Exception {
        int count = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT count(ECOUNTSNDYN)  FROM ORDDTL where orddt=? and ordseq=? and ECOUNTSNDYN='Y' and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, ordseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[checkEcountSentOrder]" + pstmt.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return count;
    }

    public boolean existOrdmst(int brandcd, String orddt, String ordseq) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select * from ORDMST where orddt = ? and ordseq=? and compno = ?     and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, ordseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                YDMAStringUtil.Print("[isExistOrder]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isExistOrddtl(int brandcd, String strAsignDate, String strAsignSeq) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select * from ORDDTL  where ASIGNDT = ? and ASIGNSEQ=? and compno = ?    and brandcd = ? LIMIT 1 ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, strAsignDate);
                pstmt.setString(2, strAsignSeq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(4, brandcd);
                YDMAStringUtil.Print("[isExistOrderDtl]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public List<List<String>> getSalesRankItemList(String clmdtFrom, String clmdtTo, int opt, String optStr, String gunun, int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "CALL YWM_PERIOD_SALE_LIST(?, ?,? ,? ,? , ?,?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, clmdtFrom);
                pstmt.setString(4, clmdtTo);
                pstmt.setInt(5, opt);
                pstmt.setString(6, "%" + optStr + "%");
                pstmt.setString(7, gunun);
                YDMAStringUtil.Print("[getSalesRankItemList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowNum = 1;
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int processDeleteOrder(int brandcd, String orddt, List<List<String>> orderList) throws Exception {
        int iCount = 0;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                for (List<String> order : orderList) {
                    int ordseq = Integer.parseInt(order.get(26));
                    int seq = Integer.parseInt(order.get(0));
                    this.updateClaimFromOrderDel(brandcd, connection, statementlist, orddt, ordseq, seq);
                    this.deleteOrder(brandcd, connection, statementlist, orddt, ordseq, seq);
                    ++iCount;
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return iCount;
    }

    public int[] deleteOrder(int brandcd, Connection connection, List<PreparedStatement> statementlist, String orddt, int ordseq, int seq) throws Exception {
        PreparedStatement pstmt = null;
        String sql = "DELETE FROM ORDDTL where orddt=? and ordseq=? and seq=? and compno = ? and brandcd = ? ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        int i = 0;
        pstmt.setString(++i, orddt);
        pstmt.setInt(++i, ordseq);
        pstmt.setInt(++i, seq);
        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(++i, brandcd);
        YDMAStringUtil.Print("[deleteOrder]" + pstmt.toString());
        pstmt.addBatch();
        pstmt.clearParameters();
        int[] result = pstmt.executeBatch();
        pstmt.clearBatch();
        return result;
    }

    public void updateClaimFromOrderDel(int brandcd, Connection connection, List<PreparedStatement> statementlist, String orddt, int ordseq, int seq) throws Exception {
        PreparedStatement pstmt = null;
        PreparedStatement ps_Order = null;
        ResultSet rs = null;
        String strSQL = "select\tclmdt,\tclmseq from\torddtl where\tcompno\t=\t? and\tbrandcd\t=\t? and\torddt\t=\t? and\tordseq\t=\t? and\tseq\t\t=\t? ";
        strSQL = strSQL.toUpperCase();
        ps_Order = connection.prepareStatement(strSQL);
        ps_Order.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
        ps_Order.setInt(2, brandcd);
        ps_Order.setString(3, orddt);
        ps_Order.setInt(4, ordseq);
        ps_Order.setInt(5, seq);
        rs = ps_Order.executeQuery();
        int iCount = 0;
        String strUpdateOrddt = "";
        String strUpdateOrdseq = "";
        String strUpdateSeq = "";
        if (rs.next()) {
            String strClmdt = rs.getString("clmdt");
            String strClmseq = rs.getString("clmseq");
            strSQL = "select\torddt,\tordseq,\tseq from\torddtl where\t\tcompno\t=\t? and\t\tbrandcd\t=\t? and\t\tclmdt\t=\t? and\t\tclmseq\t=\t? and\tnot (orddt\t=\t? and\t\tordseq\t=\t? and\t\tseq\t\t=\t?) \t\torder\tby\tseq desc ";
            strSQL = strSQL.toUpperCase();
            PreparedStatement psOrderList = connection.prepareStatement(strSQL);
            psOrderList.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
            psOrderList.setInt(2, brandcd);
            psOrderList.setString(3, strClmdt);
            psOrderList.setString(4, strClmseq);
            psOrderList.setString(5, orddt);
            psOrderList.setInt(6, ordseq);
            psOrderList.setInt(7, seq);
            ResultSet rsOrderList = psOrderList.executeQuery();
            if (rsOrderList.next()) {
                strUpdateOrddt = rsOrderList.getString("orddt");
                strUpdateOrdseq = rsOrderList.getString("ordseq");
                strUpdateSeq = rsOrderList.getString("seq");
                ++iCount;
            }
            rsOrderList.close();
        }
        rs.close();
        if (iCount >= 1) {
            strSQL = "update\tclmlist set\torddt\t\t=\t?, \t\tordseq\t\t=\t?, \t\tseq\t\t\t=\t?, \t\tupdatedt\t=\t?, \t\tupdateid\t=\t? where\torddt\t\t=\t? and \tordseq\t\t=\t? and \tseq\t\t\t=\t? and\tcompno\t\t=\t? and\tbrandcd\t\t=\t? ";
            strSQL = strSQL.toUpperCase();
            pstmt = connection.prepareStatement(strSQL);
            pstmt.setString(1, strUpdateOrddt);
            pstmt.setString(2, strUpdateOrdseq);
            pstmt.setString(3, strUpdateSeq);
            pstmt.setString(4, YDMATimeUtil.getCurrentTimeByYDFormat());
            pstmt.setString(5, YDMASessonUtil.getUserInfo().getUserId());
            pstmt.setString(6, orddt);
            pstmt.setInt(7, ordseq);
            pstmt.setInt(8, seq);
            pstmt.setString(9, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(10, brandcd);
        } else {
            strSQL = "update\tclmlist set\torddt\t\t=\tnull, \t\tordseq\t\t=\tnull, \t\tseq\t\t\t=\tnull, \t\tUPDATEDT\t=\t?,\t\tUPDATEID\t=\t? where\torddt\t\t=\t? and\tordseq\t\t=\t? and\tseq\t\t\t=\t? and\tcompno\t\t=\t? and\tbrandcd\t\t=\t? ";
            strSQL = strSQL.toUpperCase();
            pstmt = connection.prepareStatement(strSQL);
            pstmt.setString(1, YDMATimeUtil.getCurrentTimeByYDFormat());
            pstmt.setString(2, YDMASessonUtil.getUserInfo().getUserId());
            pstmt.setString(3, orddt);
            pstmt.setInt(4, ordseq);
            pstmt.setInt(5, seq);
            pstmt.setString(6, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(7, brandcd);
        }
        YDMAStringUtil.Print("[updateClaimFromOrderDel]" + pstmt.toString());
        pstmt.addBatch();
        pstmt.clearParameters();
        pstmt.executeBatch();
        pstmt.clearBatch();
    }

    public int insertOrderList(int brandcd, String orddt, String ordseq, List<List<String>> orderList) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt_ordmst = null;
        PreparedStatement pstmt_orddtl = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql_ordmst = " insert into ordmst (compno, brandcd, orddt, ordseq, insertdt, insertid)  VALUES (?, ?, ?, ?, ?, ?) ";
                sql_ordmst = sql_ordmst.toUpperCase();
                pstmt_ordmst = connection.prepareStatement(sql_ordmst);
                statementlist.add(pstmt_ordmst);
                pstmt_ordmst.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_ordmst.setInt(2, brandcd);
                pstmt_ordmst.setString(3, orddt);
                pstmt_ordmst.setString(4, ordseq);
                pstmt_ordmst.setString(5, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt_ordmst.setString(6, YDMASessonUtil.getUserInfo().getUserId());
                pstmt_ordmst.executeUpdate();
                YDMAStringUtil.Print("[insertOrder-ordmst]" + pstmt_ordmst.toString());
                String sql_orddtl = " insert into orddtl (compno, brandcd, orddt, ordseq,  seq, rorddt, rcvnam, pstno, addr, clpno, telno, qty, shpfee, credit,   optdesc, prodcd, messge, pkgclss, shipcls, sabordno, shopid, ordnm, etcmsg, mallcd, ordamt,dlvid)     VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                sql_orddtl = sql_orddtl.toUpperCase();
                pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                statementlist.add(pstmt_orddtl);
                int rowIdx = 0;
                for (List<String> order : orderList) {
                    pstmt_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setInt(2, brandcd);
                    pstmt_orddtl.setString(3, orddt);
                    pstmt_orddtl.setString(4, ordseq);
                    pstmt_orddtl.setInt(5, ++rowIdx);
                    pstmt_orddtl.setString(6, order.get(1));
                    pstmt_orddtl.setString(7, order.get(2));
                    pstmt_orddtl.setString(8, order.get(3));
                    pstmt_orddtl.setString(9, order.get(4));
                    pstmt_orddtl.setString(10, order.get(5));
                    pstmt_orddtl.setString(11, order.get(6));
                    pstmt_orddtl.setString(12, order.get(7));
                    pstmt_orddtl.setString(13, order.get(8));
                    pstmt_orddtl.setString(14, order.get(9));
                    pstmt_orddtl.setString(15, order.get(10));
                    pstmt_orddtl.setString(16, order.get(11));
                    pstmt_orddtl.setString(17, order.get(12));
                    pstmt_orddtl.setString(18, order.get(13));
                    pstmt_orddtl.setString(19, order.get(14));
                    pstmt_orddtl.setString(20, order.get(15));
                    pstmt_orddtl.setString(21, order.get(16));
                    pstmt_orddtl.setString(22, order.get(17));
                    pstmt_orddtl.setString(23, order.get(18));
                    pstmt_orddtl.setString(24, order.get(19));
                    pstmt_orddtl.setString(25, order.get(20));
                    pstmt_orddtl.setString(26, order.get(23));
                    YDMAStringUtil.Print("[insertOrder-orddtl]" + pstmt_orddtl.toString());
                    pstmt_orddtl.addBatch();
                    pstmt_orddtl.clearParameters();
                }
                pstmt_orddtl.executeBatch();
                pstmt_orddtl.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public int insertOrderList1(int brandcd, String orddt, String ordseq, List<List<String>> orderList) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt_ordmst = null;
        PreparedStatement pstmt_orddtl = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                if (!this.existOrdmst(brandcd, orddt, ordseq)) {
                    String sql_ordmst = " insert into ordmst (compno, brandcd, orddt, ordseq, insertdt, insertid)  VALUES (?, ?, ?, ?, ?, ?) ";
                    sql_ordmst = sql_ordmst.toUpperCase();
                    pstmt_ordmst = connection.prepareStatement(sql_ordmst);
                    statementlist.add(pstmt_ordmst);
                    pstmt_ordmst.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_ordmst.setInt(2, brandcd);
                    pstmt_ordmst.setString(3, orddt);
                    pstmt_ordmst.setString(4, ordseq);
                    pstmt_ordmst.setString(5, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt_ordmst.setString(6, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt_ordmst.executeUpdate();
                    YDMAStringUtil.Print("[insertOrder-ordmst]" + pstmt_ordmst.toString());
                }
                String sql_orddtl = " insert into orddtl (compno, brandcd, orddt, ordseq,  seq, rorddt, rcvnam, pstno, addr, clpno, telno, qty, shpfee, credit,   optdesc, prodcd, messge, pkgclss, shipcls, sabordno, shopid, ordnm, etcmsg, mallcd, ordamt)     VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                sql_orddtl = sql_orddtl.toUpperCase();
                pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                statementlist.add(pstmt_orddtl);
                int rowIdx = this.getOrddtlSeq(brandcd, orddt, ordseq);
                for (List<String> order : orderList) {
                    int rowcnt = 0;
                    pstmt_orddtl.setString(++rowcnt, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setInt(++rowcnt, brandcd);
                    pstmt_orddtl.setString(++rowcnt, orddt);
                    pstmt_orddtl.setString(++rowcnt, ordseq);
                    pstmt_orddtl.setInt(++rowcnt, ++rowIdx);
                    pstmt_orddtl.setString(++rowcnt, order.get(1));
                    pstmt_orddtl.setString(++rowcnt, order.get(2));
                    pstmt_orddtl.setString(++rowcnt, order.get(3));
                    pstmt_orddtl.setString(++rowcnt, order.get(4));
                    pstmt_orddtl.setString(++rowcnt, order.get(5));
                    pstmt_orddtl.setString(++rowcnt, order.get(6));
                    pstmt_orddtl.setString(++rowcnt, order.get(7));
                    pstmt_orddtl.setString(++rowcnt, order.get(8));
                    pstmt_orddtl.setString(++rowcnt, order.get(9));
                    pstmt_orddtl.setString(++rowcnt, order.get(10));
                    pstmt_orddtl.setString(++rowcnt, order.get(11));
                    pstmt_orddtl.setString(++rowcnt, order.get(12));
                    pstmt_orddtl.setString(++rowcnt, order.get(13));
                    pstmt_orddtl.setString(++rowcnt, order.get(14));
                    pstmt_orddtl.setString(++rowcnt, order.get(15));
                    pstmt_orddtl.setString(++rowcnt, order.get(16));
                    pstmt_orddtl.setString(++rowcnt, order.get(17));
                    pstmt_orddtl.setString(++rowcnt, order.get(18));
                    pstmt_orddtl.setString(++rowcnt, order.get(19));
                    pstmt_orddtl.setString(++rowcnt, order.get(20));
                    YDMAStringUtil.Print("[insertOrder-orddtl]" + pstmt_orddtl.toString());
                    pstmt_orddtl.addBatch();
                    pstmt_orddtl.clearParameters();
                }
                pstmt_orddtl.executeBatch();
                pstmt_orddtl.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    private int getOrddtlSeq(int brandcd, String orddt, String ordseq) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int result = 0;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(MAX(SEQ),0) FROM ORDDTL WHERE compno = ? AND orddt = ? AND ordseq = ? and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, orddt);
                pstmt.setString(3, ordseq);
                pstmt.setInt(4, brandcd);
                YDMAStringUtil.Print("[getOrderListForOrderManage]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    new ArrayList();
                    result = Integer.parseInt(rs.getString(++i));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int updateloadOrderList(String orddt, String ordseq, List<List<String>> orderList) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt_delete_orddtl = null;
        PreparedStatement pstmt_insert_orddtl = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql_ordmst = " delete from orddtl where orddt=? and ordseq=? and compno = ? ";
                sql_ordmst = sql_ordmst.toUpperCase();
                pstmt_delete_orddtl = connection.prepareStatement(sql_ordmst);
                statementlist.add(pstmt_delete_orddtl);
                pstmt_delete_orddtl.setString(1, orddt);
                pstmt_delete_orddtl.setString(2, ordseq);
                pstmt_delete_orddtl.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[updateloadOrderList-ordmst]" + pstmt_delete_orddtl.toString());
                pstmt_delete_orddtl.executeUpdate();
                String sql_orddtl = " insert into orddtl (compno, orddt, ordseq, seq, rorddt, rcvnam, pstno, addr, clpno, telno, qty, shpfee, credit,   optdesc, prodcd, messge, pkgclss, shipcls, sabordno, shopid, ordnm, etcmsg, mallcd, ordamt)     VALUES (?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                sql_orddtl = sql_orddtl.toUpperCase();
                pstmt_insert_orddtl = connection.prepareStatement(sql_orddtl);
                statementlist.add(pstmt_insert_orddtl);
                int rowIdx = 0;
                for (List<String> order : orderList) {
                    pstmt_insert_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_insert_orddtl.setString(2, orddt);
                    pstmt_insert_orddtl.setString(3, ordseq);
                    pstmt_insert_orddtl.setInt(4, ++rowIdx);
                    int i = 1;
                    while (i < order.size() - 1) {
                        pstmt_insert_orddtl.setString(i + 4, order.get(i));
                        ++i;
                    }
                    YDMAStringUtil.Print("[updateloadOrderList-orddtl]" + pstmt_insert_orddtl.toString());
                    pstmt_insert_orddtl.addBatch();
                    pstmt_insert_orddtl.clearParameters();
                }
                pstmt_insert_orddtl.executeBatch();
                pstmt_insert_orddtl.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return result;
    }

    public List<List<String>> getOrderListForOrderManage(int brandcd, String orddt, String ordseq, String ord_eseq) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " select seq, ifnull(rorddt,''), ifnull(rcvnam,''), ifnull(pstno,''),  ";
                sql = String.valueOf(sql) + " ifnull(addr,''), ifnull(clpno,''), ifnull(telno,''), ifnull(qty,0),  ifnull(shpfee,''), ifnull(credit,''),";
                sql = String.valueOf(sql) + " ifnull(optdesc,''), ifnull(prodcd,'') prodcd, ifnull(messge,''), ifnull((SELECT max(expcd) FROM V_PRODUCTS b where b.prodcd=a.prodcd),'') as pkgclss, ";
                sql = String.valueOf(sql) + " ifnull(shipcls,''), ifnull(sabordno,''), ifnull(shopid,''), ifnull(ordnm,''),  ";
                sql = String.valueOf(sql) + " ifnull(etcmsg,''), ifnull(mallcd,''), ifnull(ordamt, 0),  ifnull(ECOUNTSNDYN,'N'), ";
                sql = String.valueOf(sql) + " ifnull(moveseq,''), ifnull(asigndt,''), ifnull(invno,''), ifnull(brandcd,'')  ";
                sql = String.valueOf(sql) + " FROM ORDDTL a";
                sql = ord_eseq.equals(ordseq) ? String.valueOf(sql) + " where orddt=? and ordseq=? and a.compno = ? " : String.valueOf(sql) + " where orddt=? and ordseq >=? and ordseq<=? and a.compno = ? ";
                if (brandcd != -1) {
                    sql = String.valueOf(sql) + "  and brandcd = ? ";
                }
                sql = String.valueOf(sql) + " order by seq ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                if (ord_eseq.equals(ordseq)) {
                    pstmt.setString(1, orddt);
                    pstmt.setString(2, ordseq);
                    pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (brandcd != -1) {
                        pstmt.setInt(4, brandcd);
                    }
                } else {
                    pstmt.setString(1, orddt);
                    pstmt.setString(2, ordseq);
                    pstmt.setString(3, ord_eseq);
                    pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (brandcd != -1) {
                        pstmt.setInt(5, brandcd);
                    }
                }
                YDMAStringUtil.Print("[getOrderListForOrderManage]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(ordseq);
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getOrderListForOrderManageByCondition(int brandcd, String orddt, String ordseq, String ord_eseq, int opt, String optStr) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select seq, ifnull(rorddt,''), ifnull(rcvnam,'') as rcvnam, ifnull(pstno,''),  ";
                sql = String.valueOf(sql) + " ifnull(addr,''), ifnull(clpno,''), ifnull(telno,''), ifnull(qty,0),  ifnull(shpfee,''), ifnull(credit,''),";
                sql = String.valueOf(sql) + " ifnull(optdesc,'') as optdesc, ifnull(prodcd,'') as prodcd, ifnull(messge,''), ifnull((SELECT max(expcd) FROM V_PRODUCTS b where b.prodcd=a.prodcd and b.compno = a.compno ),'') as pkgclss, ";
                sql = String.valueOf(sql) + " ifnull(shipcls,''), ifnull(sabordno,''), ifnull(shopid,''), ifnull(ordnm,'') as ordnm,  ";
                sql = String.valueOf(sql) + " ifnull(etcmsg,''), ifnull(mallcd,''), ifnull(ordamt,0),  ifnull(ECOUNTSNDYN,'N'), ";
                sql = String.valueOf(sql) + " ifnull(moveseq,''), ifnull(asigndt,''), ifnull(invno,''),ifnull(brandcd,'') ";
                sql = String.valueOf(sql) + " ,ordseq ";
                sql = String.valueOf(sql) + " FROM ORDDTL a";
                sql = ord_eseq.equals(ordseq) ? String.valueOf(sql) + " where orddt=? and ordseq=? and a.compno = ? " : String.valueOf(sql) + " where orddt=? and ordseq >=? and ordseq<=? and a.compno = ? ";
                if (brandcd != -1) {
                    sql = String.valueOf(sql) + "  and brandcd = ? ";
                }
                if (opt == 0) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  prodcd like ? ";
                    }
                    sql = String.valueOf(sql) + "  order by prodcd ";
                } else if (opt == 1) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  optdesc like ? ";
                    }
                    sql = String.valueOf(sql) + "  order by optdesc ";
                } else if (opt == 2) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  rcvnam like ? ";
                    }
                    sql = String.valueOf(sql) + "  order by rcvnam ";
                } else if (opt == 3) {
                    if (optStr.length() != 0) {
                        sql = String.valueOf(sql) + " and  ordnm like ? ";
                    }
                    sql = String.valueOf(sql) + "  order by ordnm ";
                }
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                if (ord_eseq.equals(ordseq)) {
                    pstmt.setString(1, orddt);
                    pstmt.setString(2, ordseq);
                    pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (brandcd != -1) {
                        pstmt.setInt(4, brandcd);
                        if (optStr.length() != 0) {
                            pstmt.setString(5, "%" + optStr + "%");
                        }
                    } else if (optStr.length() != 0) {
                        pstmt.setString(4, "%" + optStr + "%");
                    }
                } else {
                    pstmt.setString(1, orddt);
                    pstmt.setString(2, ordseq);
                    pstmt.setString(3, ord_eseq);
                    pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (brandcd != -1) {
                        pstmt.setInt(5, brandcd);
                        if (optStr.length() != 0) {
                            pstmt.setString(6, "%" + optStr + "%");
                        }
                    } else if (optStr.length() != 0) {
                        pstmt.setString(5, "%" + optStr + "%");
                    }
                }
                YDMAStringUtil.Print("[getOrderListForOrderManageByCondition]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString("ordseq"));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getOrderListEcountSend(String orddt, String ordseq, String chksend, int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        CallableStatement cStmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                cStmt = connection.prepareCall("{call YWM_WAREHOUSE_QTY(?, ?,?, ?, ?)}");
                cStmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                cStmt.setInt(2, brandcd);
                cStmt.setString(3, orddt);
                cStmt.setString(4, ordseq);
                cStmt.setString(5, chksend);
                YDMAStringUtil.Print("[getOrderListForEcount]" + cStmt.toString());
                rs = cStmt.executeQuery();
                while (rs.next()) {
                    int i = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
        return contents;
    }

    public List<String> insertOrdmst_Orddtl(int brandcd, String orddt, String ordseq, List<String> order) throws Exception {
        ArrayList<String> insertdNewOrder = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt_select_ordmst = null;
        PreparedStatement pstmt_select_seq = null;
        PreparedStatement pstmt_insert_orddtl = null;
        PreparedStatement pstmt_select_orddtl = null;
        ArrayList<PreparedStatement> pstmtlist = new ArrayList<PreparedStatement>();
        ArrayList<ResultSet> rslist = new ArrayList<ResultSet>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql_insert_ordmst = "insert into ORDMST (compno, brandcd, orddt, ordseq, insertdt, insertid) values (?,?,?,?,?,?) ";
                sql_insert_ordmst = sql_insert_ordmst.toUpperCase();
                pstmt_select_ordmst = connection.prepareStatement(sql_insert_ordmst);
                pstmtlist.add(pstmt_select_ordmst);
                pstmt_select_ordmst.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_ordmst.setInt(2, brandcd);
                pstmt_select_ordmst.setString(3, orddt);
                pstmt_select_ordmst.setString(4, ordseq);
                pstmt_select_ordmst.setString(5, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt_select_ordmst.setString(6, YDMASessonUtil.getUserInfo().getUserId());
                YDMAStringUtil.Print("[insertOrdmst_Orddtl-ordmst]" + pstmt_select_ordmst.toString());
                pstmt_select_ordmst.executeUpdate();
                int SEQ = -1;
                String sql_seq = "SELECT ifnull(MAX(SEQ)+1, 1)  FROM ORDDTL  WHERE ORDDT=? AND ORDSEQ=? and compno = ? and brandcd = ? ";
                sql_seq = sql_seq.toUpperCase();
                pstmt_select_seq = connection.prepareStatement(sql_seq);
                pstmtlist.add(pstmt_select_seq);
                pstmt_select_seq.setString(1, orddt);
                pstmt_select_seq.setString(2, ordseq);
                pstmt_select_seq.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_seq.setInt(4, brandcd);
                YDMAStringUtil.Print("[insertOrdmst_Orddtl-seq]" + pstmt_select_seq.toString());
                ResultSet rs_select_seq = pstmt_select_seq.executeQuery();
                rslist.add(rs_select_seq);
                SEQ = rs_select_seq.next() ? rs_select_seq.getInt(1) : 1;
                String sql_insert = " insert into orddtl (compno, brandcd, orddt, ordseq,  seq, rorddt, rcvnam, pstno, addr,  clpno, telno, qty, shpfee, credit,  optdesc, prodcd, messge, pkgclss, shipcls,  sabordno, shopid, ordnm, etcmsg, mallcd, ordamt)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                sql_insert = sql_insert.toUpperCase();
                pstmt_insert_orddtl = connection.prepareStatement(sql_insert);
                pstmtlist.add(pstmt_insert_orddtl);
                pstmt_insert_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_insert_orddtl.setInt(2, brandcd);
                pstmt_insert_orddtl.setString(3, orddt);
                pstmt_insert_orddtl.setString(4, ordseq);
                pstmt_insert_orddtl.setInt(5, SEQ);
                int i = 0;
                while (i < order.size()) {
                    pstmt_insert_orddtl.setString(i + 6, order.get(i));
                    ++i;
                }
                YDMAStringUtil.Print("[insertOrdmst_Orddtl-insert]" + pstmt_insert_orddtl.toString());
                pstmt_insert_orddtl.executeUpdate();
                String sql_select = " select seq, ifnull(rorddt,''), ifnull(rcvnam,''), ifnull(pstno,''),   ifnull(addr,''), ifnull(clpno,''), ifnull(telno,''), ifnull(qty,''),  ifnull(shpfee,''), ifnull(credit,''), ifnull(optdesc,''), ifnull(prodcd,''), ifnull(messge,''), ifnull((SELECT max(expcd) FROM V_PRODUCTS b where b.prodcd=prodcd),'') as pkgclss,  ifnull(shipcls,''), ifnull(sabordno,''), ifnull(shopid,''), ifnull(ordnm,''),   ifnull(etcmsg,''), ifnull(mallcd,''), ifnull(ordamt,''),  ifnull(ECOUNTSNDYN,'N'),  ifnull(moveseq,''), ifnull(asigndt,''), ifnull(invno,''),ifnull(brandcd,'')   FROM ORDDTL  where orddt=? and ordseq=? and seq=? and compno = ? and brandcd = ? ";
                sql_select = sql_select.toUpperCase();
                pstmt_select_orddtl = connection.prepareStatement(sql_select);
                pstmtlist.add(pstmt_select_orddtl);
                pstmt_select_orddtl.setString(1, orddt);
                pstmt_select_orddtl.setString(2, ordseq);
                pstmt_select_orddtl.setInt(3, SEQ);
                pstmt_select_orddtl.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_orddtl.setInt(5, brandcd);
                YDMAStringUtil.Print("[insertOrdmst_Orddtl-select]" + pstmt_insert_orddtl.toString());
                ResultSet rs_select_orddtl = pstmt_select_orddtl.executeQuery();
                rslist.add(rs_select_orddtl);
                int i2 = 0;
                if (rs_select_orddtl.next()) {
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, pstmtlist, rslist);
        }
        return insertdNewOrder;
    }

    public PickupDto insertOrdmst_Orddtl(int brandcd, String orddt, String ordseq, PickupDto order) throws Exception {
        PickupDto insertdNewOrder = new PickupDto();
        Connection connection = null;
        PreparedStatement pstmt_select_ordmst = null;
        PreparedStatement pstmt_select_seq = null;
        PreparedStatement pstmt_insert_orddtl = null;
        PreparedStatement pstmt_select_orddtl = null;
        ArrayList<PreparedStatement> pstmtlist = new ArrayList<PreparedStatement>();
        ArrayList<ResultSet> rslist = new ArrayList<ResultSet>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql_insert_ordmst = "insert into ORDMST (compno, brandcd, orddt, ordseq, insertdt, insertid) values (?,?,?,?,?,?) ";
                sql_insert_ordmst = sql_insert_ordmst.toUpperCase();
                pstmt_select_ordmst = connection.prepareStatement(sql_insert_ordmst);
                pstmtlist.add(pstmt_select_ordmst);
                pstmt_select_ordmst.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_ordmst.setInt(2, brandcd);
                pstmt_select_ordmst.setString(3, orddt);
                pstmt_select_ordmst.setString(4, ordseq);
                pstmt_select_ordmst.setString(5, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt_select_ordmst.setString(6, YDMASessonUtil.getUserInfo().getUserId());
                YDMAStringUtil.Print("[insertOrdmst_Orddtl-ordmst]" + pstmt_select_ordmst.toString());
                pstmt_select_ordmst.executeUpdate();
                int SEQ = -1;
                String sql_seq = "SELECT ifnull(MAX(SEQ)+1, 1)  FROM ORDDTL  WHERE ORDDT=? AND ORDSEQ=? and compno = ? and brandcd = ? ";
                sql_seq = sql_seq.toUpperCase();
                pstmt_select_seq = connection.prepareStatement(sql_seq);
                pstmtlist.add(pstmt_select_seq);
                pstmt_select_seq.setString(1, orddt);
                pstmt_select_seq.setString(2, ordseq);
                pstmt_select_seq.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_seq.setInt(4, brandcd);
                YDMAStringUtil.Print("[insertOrdmst_Orddtl-seq]" + pstmt_select_seq.toString());
                ResultSet rs_select_seq = pstmt_select_seq.executeQuery();
                rslist.add(rs_select_seq);
                SEQ = rs_select_seq.next() ? rs_select_seq.getInt(1) : 1;
                String sql_insert = " insert into orddtl (compno, brandcd, orddt, ordseq,  seq, rorddt, rcvnam, pstno, addr,  clpno, telno, qty, shpfee, credit,  optdesc, prodcd, messge, pkgclss, shipcls,  sabordno, shopid, ordnm, etcmsg, mallcd, ordamt)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                sql_insert = sql_insert.toUpperCase();
                pstmt_insert_orddtl = connection.prepareStatement(sql_insert);
                pstmtlist.add(pstmt_insert_orddtl);
                pstmt_insert_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_insert_orddtl.setInt(2, brandcd);
                pstmt_insert_orddtl.setString(3, orddt);
                pstmt_insert_orddtl.setString(4, ordseq);
                pstmt_insert_orddtl.setInt(5, SEQ);
                pstmt_insert_orddtl.setString(6, order.getRorddt());
                pstmt_insert_orddtl.setString(7, order.getRcvnam());
                pstmt_insert_orddtl.setString(8, order.getPstno());
                pstmt_insert_orddtl.setString(9, order.getAddr());
                pstmt_insert_orddtl.setString(10, order.getClpno());
                pstmt_insert_orddtl.setString(11, order.getTelno());
                pstmt_insert_orddtl.setString(12, order.getQty());
                pstmt_insert_orddtl.setString(13, order.getShpfee());
                pstmt_insert_orddtl.setString(14, order.getCredit());
                pstmt_insert_orddtl.setString(15, order.getOptdesc());
                pstmt_insert_orddtl.setString(16, order.getProdcd());
                pstmt_insert_orddtl.setString(17, order.getMessge());
                pstmt_insert_orddtl.setString(18, order.getPkgclss());
                pstmt_insert_orddtl.setString(19, order.getShipcls());
                pstmt_insert_orddtl.setString(20, order.getSabordno());
                pstmt_insert_orddtl.setString(21, order.getShopid());
                pstmt_insert_orddtl.setString(22, order.getOrdnm());
                pstmt_insert_orddtl.setString(23, order.getEtcmsg());
                pstmt_insert_orddtl.setString(24, order.getMallcd());
                pstmt_insert_orddtl.setString(25, order.getOrdamt());
                YDMAStringUtil.Print("[insertOrdmst_Orddtl-insert]" + pstmt_insert_orddtl.toString());
                pstmt_insert_orddtl.executeUpdate();
                String sql_select = " select seq, ifnull(rorddt,''), ifnull(rcvnam,''), ifnull(pstno,''),   ifnull(addr,''), ifnull(clpno,''), ifnull(telno,''), ifnull(qty,''),  ifnull(shpfee,''), ifnull(credit,''), ifnull(optdesc,''), ifnull(prodcd,''), ifnull(messge,''), ifnull((SELECT max(expcd) FROM V_PRODUCTS b where b.prodcd=prodcd),'') as pkgclss,  ifnull(shipcls,''), ifnull(sabordno,''), ifnull(shopid,''), ifnull(ordnm,''),   ifnull(etcmsg,''), ifnull(mallcd,''), ifnull(ordamt,''),  ifnull(ECOUNTSNDYN,'N'),  ifnull(moveseq,''), ifnull(asigndt,''), ifnull(invno,''),ifnull(brandcd,'')   FROM ORDDTL  where orddt=? and ordseq=? and seq=? and compno = ? and brandcd = ? ";
                sql_select = sql_select.toUpperCase();
                pstmt_select_orddtl = connection.prepareStatement(sql_select);
                pstmtlist.add(pstmt_select_orddtl);
                pstmt_select_orddtl.setString(1, orddt);
                pstmt_select_orddtl.setString(2, ordseq);
                pstmt_select_orddtl.setInt(3, SEQ);
                pstmt_select_orddtl.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_orddtl.setInt(5, brandcd);
                YDMAStringUtil.Print("[insertOrdmst_Orddtl-select]" + pstmt_insert_orddtl.toString());
                ResultSet rs_select_orddtl = pstmt_select_orddtl.executeQuery();
                rslist.add(rs_select_orddtl);
                if (rs_select_orddtl.next()) {
                    insertdNewOrder.setRorddt(rs_select_orddtl.getString(1));
                    insertdNewOrder.setRcvnam(rs_select_orddtl.getString(2));
                    insertdNewOrder.setPstno(rs_select_orddtl.getString(3));
                    insertdNewOrder.setAddr(rs_select_orddtl.getString(4));
                    insertdNewOrder.setClpno(rs_select_orddtl.getString(5));
                    insertdNewOrder.setTelno(rs_select_orddtl.getString(6));
                    insertdNewOrder.setQty(rs_select_orddtl.getString(7));
                    insertdNewOrder.setShpfee(rs_select_orddtl.getString(8));
                    insertdNewOrder.setCredit(rs_select_orddtl.getString(9));
                    insertdNewOrder.setOptdesc(rs_select_orddtl.getString(10));
                    insertdNewOrder.setProdcd(rs_select_orddtl.getString(11));
                    insertdNewOrder.setMessge(rs_select_orddtl.getString(12));
                    insertdNewOrder.setPkgclss(rs_select_orddtl.getString(13));
                    insertdNewOrder.setShipcls(rs_select_orddtl.getString(14));
                    insertdNewOrder.setSabordno(rs_select_orddtl.getString(15));
                    insertdNewOrder.setShopid(rs_select_orddtl.getString(16));
                    insertdNewOrder.setOrdnm(rs_select_orddtl.getString(17));
                    insertdNewOrder.setEtcmsg(rs_select_orddtl.getString(18));
                    insertdNewOrder.setMallcd(rs_select_orddtl.getString(19));
                    insertdNewOrder.setOrdamt(rs_select_orddtl.getString(20));
                    insertdNewOrder.setInvno(rs_select_orddtl.getString(24));
                    insertdNewOrder.setBrandcd(rs_select_orddtl.getString(25));
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, pstmtlist, rslist);
        }
        return insertdNewOrder;
    }

    public List<String> insertOrddtl(int brandcd, String orddt, String ordseq, List<String> order) throws Exception {
        ArrayList<String> insertdNewOrder = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt_select_seq = null;
        PreparedStatement pstmt_insert_orddtl = null;
        PreparedStatement pstmt_select_orddtl = null;
        ArrayList<PreparedStatement> pstmtlist = new ArrayList<PreparedStatement>();
        ArrayList<ResultSet> rslist = new ArrayList<ResultSet>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                int SEQ = -1;
                String sql_seq = "SELECT ifnull(MAX(SEQ)+1, 1)   FROM ORDDTL  WHERE ORDDT=? AND ORDSEQ=? and compno = ?  and brandcd = ? ";
                sql_seq = sql_seq.toUpperCase();
                pstmt_select_seq = connection.prepareStatement(sql_seq);
                pstmtlist.add(pstmt_select_seq);
                pstmt_select_seq.setString(1, orddt);
                pstmt_select_seq.setString(2, ordseq);
                pstmt_select_seq.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_seq.setInt(4, brandcd);
                YDMAStringUtil.Print("[insertOrddtl-seq]" + pstmt_select_seq.toString());
                ResultSet rs_select_seq = pstmt_select_seq.executeQuery();
                rslist.add(rs_select_seq);
                SEQ = rs_select_seq.next() ? rs_select_seq.getInt(1) : 1;
                String sql_insert = " insert into orddtl (compno, brandcd, orddt, ordseq,  seq, rorddt, rcvnam, pstno, addr,  clpno, telno, qty, shpfee, credit,  optdesc, prodcd, messge, pkgclss, shipcls,  sabordno, shopid, ordnm, etcmsg, mallcd, ordamt)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                sql_insert = sql_insert.toUpperCase();
                pstmt_insert_orddtl = connection.prepareStatement(sql_insert);
                pstmtlist.add(pstmt_insert_orddtl);
                pstmt_insert_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_insert_orddtl.setInt(2, brandcd);
                pstmt_insert_orddtl.setString(3, orddt);
                pstmt_insert_orddtl.setString(4, ordseq);
                pstmt_insert_orddtl.setInt(5, SEQ);
                int i = 0;
                while (i < order.size()) {
                    pstmt_insert_orddtl.setString(i + 6, order.get(i));
                    ++i;
                }
                YDMAStringUtil.Print("[insertOrddtl-insert]" + pstmt_insert_orddtl.toString());
                pstmt_insert_orddtl.executeUpdate();
                String sql_select = " select seq, ifnull(rorddt,''), ifnull(rcvnam,''), ifnull(pstno,''),   ifnull(addr,''), ifnull(clpno,''), ifnull(telno,''), ifnull(qty,''),  ifnull(shpfee,''), ifnull(credit,''), ifnull(optdesc,''), ifnull(prodcd,''), ifnull(messge,''), ifnull((SELECT max(expcd) FROM V_PRODUCTS b where b.prodcd=prodcd and b.compno = compno ),'') as pkgclss,  ifnull(shipcls,''), ifnull(sabordno,''), ifnull(shopid,''), ifnull(ordnm,''),   ifnull(etcmsg,''), ifnull(mallcd,''), ifnull(ordamt,''),  ifnull(ECOUNTSNDYN,'N'),  ifnull(moveseq,''), ifnull(asigndt,''), ifnull(invno,''),ifnull(brandcd,'')   FROM ORDDTL  where orddt=? and ordseq=? and seq=? and compno = ? and brandcd = ? ";
                sql_select = sql_select.toUpperCase();
                pstmt_select_orddtl = connection.prepareStatement(sql_select);
                pstmtlist.add(pstmt_select_orddtl);
                pstmt_select_orddtl.setString(1, orddt);
                pstmt_select_orddtl.setString(2, ordseq);
                pstmt_select_orddtl.setInt(3, SEQ);
                pstmt_select_orddtl.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_orddtl.setInt(5, brandcd);
                YDMAStringUtil.Print("[insertOrddtl-select]" + pstmt_insert_orddtl.toString());
                ResultSet rs_select_orddtl = pstmt_select_orddtl.executeQuery();
                rslist.add(rs_select_orddtl);
                int i2 = 0;
                if (rs_select_orddtl.next()) {
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                    insertdNewOrder.add(rs_select_orddtl.getString(++i2));
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, pstmtlist, rslist);
        }
        return insertdNewOrder;
    }

    public PickupDto insertOrddtl2(int brandcd, String orddt, String ordseq, PickupDto order) throws Exception {
        PickupDto insertdNewOrder = new PickupDto();
        Connection connection = null;
        PreparedStatement pstmt_select_seq = null;
        PreparedStatement pstmt_insert_orddtl = null;
        PreparedStatement pstmt_select_orddtl = null;
        ArrayList<PreparedStatement> pstmtlist = new ArrayList<PreparedStatement>();
        ArrayList<ResultSet> rslist = new ArrayList<ResultSet>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                int SEQ = -1;
                String sql_seq = "SELECT ifnull(MAX(SEQ)+1, 1)   FROM ORDDTL  WHERE ORDDT=? AND ORDSEQ=? and compno = ?  and brandcd = ? ";
                sql_seq = sql_seq.toUpperCase();
                pstmt_select_seq = connection.prepareStatement(sql_seq);
                pstmtlist.add(pstmt_select_seq);
                pstmt_select_seq.setString(1, orddt);
                pstmt_select_seq.setString(2, ordseq);
                pstmt_select_seq.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_seq.setInt(4, brandcd);
                YDMAStringUtil.Print("[insertOrddtl-seq]" + pstmt_select_seq.toString());
                ResultSet rs_select_seq = pstmt_select_seq.executeQuery();
                rslist.add(rs_select_seq);
                SEQ = rs_select_seq.next() ? rs_select_seq.getInt(1) : 1;
                String sql_insert = " insert into orddtl (compno, brandcd, orddt, ordseq,  seq, rorddt, rcvnam, pstno, addr,  clpno, telno, qty, shpfee, credit,  optdesc, prodcd, messge, pkgclss, shipcls,  sabordno, shopid, ordnm, etcmsg, mallcd, ordamt)  VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                sql_insert = sql_insert.toUpperCase();
                pstmt_insert_orddtl = connection.prepareStatement(sql_insert);
                pstmtlist.add(pstmt_insert_orddtl);
                pstmt_insert_orddtl.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_insert_orddtl.setInt(2, brandcd);
                pstmt_insert_orddtl.setString(3, orddt);
                pstmt_insert_orddtl.setString(4, ordseq);
                pstmt_insert_orddtl.setInt(5, SEQ);
                pstmt_insert_orddtl.setString(6, order.getRorddt());
                pstmt_insert_orddtl.setString(7, order.getRcvnam());
                pstmt_insert_orddtl.setString(8, order.getPstno());
                pstmt_insert_orddtl.setString(9, order.getAddr());
                pstmt_insert_orddtl.setString(10, order.getClpno());
                pstmt_insert_orddtl.setString(11, order.getTelno());
                pstmt_insert_orddtl.setString(12, order.getQty());
                pstmt_insert_orddtl.setString(13, order.getShpfee());
                pstmt_insert_orddtl.setString(14, order.getCredit());
                pstmt_insert_orddtl.setString(15, order.getOptdesc());
                pstmt_insert_orddtl.setString(16, order.getProdcd());
                pstmt_insert_orddtl.setString(17, order.getMessge());
                pstmt_insert_orddtl.setString(18, order.getPkgclss());
                pstmt_insert_orddtl.setString(19, order.getShipcls());
                pstmt_insert_orddtl.setString(20, order.getSabordno());
                pstmt_insert_orddtl.setString(21, order.getShopid());
                pstmt_insert_orddtl.setString(22, order.getOrdnm());
                pstmt_insert_orddtl.setString(23, order.getEtcmsg());
                pstmt_insert_orddtl.setString(24, order.getMallcd());
                pstmt_insert_orddtl.setString(25, order.getOrdamt());
                YDMAStringUtil.Print("[insertOrddtl-insert]" + pstmt_insert_orddtl.toString());
                pstmt_insert_orddtl.executeUpdate();
                String sql_select = " select seq, ifnull(rorddt,''), ifnull(rcvnam,''), ifnull(pstno,''),   ifnull(addr,''), ifnull(clpno,''), ifnull(telno,''), ifnull(qty,''),  ifnull(shpfee,''), ifnull(credit,''), ifnull(optdesc,''), ifnull(prodcd,''), ifnull(messge,''), ifnull((SELECT max(expcd) FROM V_PRODUCTS b where b.prodcd=prodcd and b.compno = compno ),'') as pkgclss,  ifnull(shipcls,''), ifnull(sabordno,''), ifnull(shopid,''), ifnull(ordnm,''),   ifnull(etcmsg,''), ifnull(mallcd,''), ifnull(ordamt,''),  ifnull(ECOUNTSNDYN,'N'),  ifnull(moveseq,''), ifnull(asigndt,''), ifnull(invno,''),ifnull(brandcd,'')   FROM ORDDTL  where orddt=? and ordseq=? and seq=? and compno = ? and brandcd = ? ";
                sql_select = sql_select.toUpperCase();
                pstmt_select_orddtl = connection.prepareStatement(sql_select);
                pstmtlist.add(pstmt_select_orddtl);
                pstmt_select_orddtl.setString(1, orddt);
                pstmt_select_orddtl.setString(2, ordseq);
                pstmt_select_orddtl.setInt(3, SEQ);
                pstmt_select_orddtl.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select_orddtl.setInt(5, brandcd);
                YDMAStringUtil.Print("[insertOrddtl-select]" + pstmt_insert_orddtl.toString());
                ResultSet rs_select_orddtl = pstmt_select_orddtl.executeQuery();
                rslist.add(rs_select_orddtl);
                int i = 0;
                if (rs_select_orddtl.next()) {
                    insertdNewOrder.setSeq(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setRorddt(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setRcvnam(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setPstno(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setAddr(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setClpno(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setTelno(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setQty(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setShpfee(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setCredit(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setOptdesc(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setProdcd(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setMessge(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setPkgclss(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setShipcls(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setSabordno(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setShopid(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setOrdnm(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setEtcmsg(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setMallcd(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setOrdamt(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setInvno(rs_select_orddtl.getString(++i));
                    insertdNewOrder.setBrandcd(rs_select_orddtl.getString(++i));
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, pstmtlist, rslist);
        }
        return insertdNewOrder;
    }

    public boolean isAssgined(int brandcd, String orddt, String ordseq, int seq) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT * FROM ORDDTL WHERE ORDDT = ? AND ORDSEQ = ? AND SEQ = ? AND COMPNO = ? AND BRANDCD = ? AND ASIGNDT IS NOT NULL";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, ordseq);
                pstmt.setInt(3, seq);
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(5, brandcd);
                YDMAStringUtil.Print("[isAssgined]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public List<String> updateOrderDetail(int brandcd, String orddt, String ordseq, int seq, List<String> order) throws Exception {
        ArrayList<String> insertdNewOrder = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt_update = null;
        PreparedStatement pstmt_select = null;
        ArrayList<PreparedStatement> pstmtlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql_update = " update orddtl set rorddt=?, rcvnam=?, pstno=?, addr=?,  clpno=?, telno=?, qty=?, shpfee=?, credit=?,  optdesc=?, prodcd=?,  messge=?, pkgclss=?, shipcls=?, sabordno=?, shopid=?, ordnm=?, etcmsg=?, mallcd=?, ordamt=?  where orddt =? and ordseq=? and seq=? and compno = ? and brandcd = ? ";
                sql_update = sql_update.toUpperCase();
                pstmt_update = connection.prepareStatement(sql_update);
                pstmtlist.add(pstmt_update);
                int idx = 0;
                for (String value : order) {
                    pstmt_update.setString(++idx, value);
                }
                pstmt_update.setString(++idx, orddt);
                pstmt_update.setString(++idx, ordseq);
                pstmt_update.setInt(++idx, seq);
                pstmt_update.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_update.setInt(++idx, brandcd);
                YDMAStringUtil.Print("[updateOrderDetail-update]" + pstmt_update.toString());
                pstmt_update.executeLargeUpdate();
                String sql_select = " select seq, ifnull(rorddt,''), ifnull(rcvnam,''), ifnull(pstno,''),   ifnull(addr,''), ifnull(clpno,''), ifnull(telno,''), ifnull(qty,''),  ifnull(shpfee,''), ifnull(credit,''), ifnull(optdesc,''), ifnull(prodcd,''), ifnull(messge,''), ifnull((SELECT max(expcd) FROM V_PRODUCTS b where b.prodcd=prodcd and b.compno = compno ),'') as pkgclss,  ifnull(shipcls,''), ifnull(sabordno,''), ifnull(shopid,''), ifnull(ordnm,''),   ifnull(etcmsg,''), ifnull(mallcd,''), ifnull(ordamt,''),  ifnull(ECOUNTSNDYN,'N'), ";
                sql_select = String.valueOf(sql_select) + " ifnull(moveseq,''), ifnull(asigndt,''), ifnull(invno,''),ifnull(brandcd,'') ";
                sql_select = String.valueOf(sql_select) + " FROM ORDDTL  where orddt=? and ordseq=? and seq=? and compno = ?  and brandcd = ? ";
                sql_select = sql_select.toUpperCase();
                pstmt_select = connection.prepareStatement(sql_select);
                pstmtlist.add(pstmt_select);
                pstmt_select.setString(1, orddt);
                pstmt_select.setString(2, ordseq);
                pstmt_select.setInt(3, seq);
                pstmt_select.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_select.setInt(5, brandcd);
                YDMAStringUtil.Print("[updateOrderDetail-select]" + pstmt_select.toString());
                rs = pstmt_select.executeQuery();
                if (rs.next()) {
                    int i = 0;
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(rs.getString(++i));
                    insertdNewOrder.add(ordseq);
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmtlist, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmtlist, rs);
        return insertdNewOrder;
    }

    public int checkStock1(String orddt, String prodcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        int stockCnt = 0;
        try {
            try {
                String sql = "SELECT YWM_FUNC_PRODWAREQTY(?, ?, ?) FROM DUAL;";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, orddt);
                pstmt.setString(3, prodcd);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    stockCnt = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return stockCnt;
    }

    public List<List<String>> getExpressCodeList() throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(DLVID,''), ifnull(DLVNM,''), ifnull(EXPCD_LOTT,'') from deliverys ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getExpressCodeList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<PickupDto> getExpressCodeList2() throws Exception {
        ArrayList<PickupDto> contents = new ArrayList<PickupDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(DLVID,''), ifnull(DLVNM,''), ifnull(EXPCD_LOTT,'') from deliverys ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                YDMAStringUtil.Print("[getExpressCodeList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    PickupDto list = new PickupDto();
                    list.setDlvid(rs.getString(++rowno));
                    list.setDlvnm(rs.getString(++rowno));
                    list.setExpcd_lott(rs.getString(++rowno));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public boolean isPhonenumber(String string) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select errno from errphone where errno = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, string);
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isExistProduct]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public void setOrderAutomation(List<String> list) throws Exception {
        Connection connection = null;
        CallableStatement cStmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                cStmt = connection.prepareCall("{CALL YWM_ORDERAUTO_PROC(?, ?,?,?,?,?)}");
                cStmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                cStmt.setString(2, list.get(0));
                cStmt.setString(3, list.get(1));
                cStmt.setString(4, list.get(2));
                cStmt.setInt(5, Integer.parseInt(list.get(3)));
                cStmt.setString(6, list.get(4));
                YDMAStringUtil.Print("[setOrderAutomation]" + cStmt.toString());
                rs = cStmt.executeQuery();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, cStmt, rs);
    }

    public List<List<String>> getMoveSeqList(String orddt, String ordseq, String seq, String moveseq, int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SABORDNO,'')  from ORDDTL where orddt = ? and ordseq = ? and seq = ? and moveseq = ? and compno = ? and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, ordseq);
                pstmt.setString(3, seq);
                pstmt.setString(4, moveseq);
                pstmt.setString(5, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(6, brandcd);
                YDMAStringUtil.Print("[getMoveSeqList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add(rs.getString(++rowno));
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    list.add("");
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<PickupDto> getMoveSeqList2(String orddt, String ordseq, String seq, String moveseq, int brandcd) throws Exception {
        ArrayList<PickupDto> contents = new ArrayList<PickupDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(SABORDNO,'')  from ORDDTL where orddt = ? and ordseq = ? and seq = ? and moveseq = ? and compno = ? and brandcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, ordseq);
                pstmt.setString(3, seq);
                pstmt.setString(4, moveseq);
                pstmt.setString(5, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(6, brandcd);
                YDMAStringUtil.Print("[getMoveSeqList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    PickupDto list = new PickupDto();
                    list.setSabordno(rs.getString(++rowno));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void setOrderAutoUpdate(String seq, String orddt, String ordseq) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        PreparedStatement pstmt = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql = "update orddtl set COMPLETEyn = 'Y' where ORDDT = ? and SEQ = ? and ordseq = ? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                pstmt.setString(++i, orddt);
                pstmt.setString(++i, seq);
                pstmt.setString(++i, ordseq);
                pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[setOrderAutoUpdate]" + pstmt.toString());
                pstmt.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<String> isExistComplate(String seq, String ordseq, String orddt) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(completeyn,'N') from orddtl where orddt = ? and ordseq = ? and seq =? and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, ordseq);
                pstmt.setString(3, seq);
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[isExistComplate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    list.add(rs.getString(++rowno));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<String> getExpcd_Lott(String exp) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(DLVID,''), ifnull(DLVNM,''), ifnull(EXPCD_LOTT,'') from deliverys where DLVNM = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, exp);
                YDMAStringUtil.Print("[isExistComplate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<List<String>> getCompleteyn(String orddt, String chkordseq) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(ORDDT,''), ifnull(ORDSEQ,'0'), ifnull(SEQ,'0'), ifnull(COMPLETEYN,'N'), ifnull(prodcd,'') from ORDDTL where ORDDT = ? and ORDSEQ=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, orddt);
                pstmt.setString(2, chkordseq);
                YDMAStringUtil.Print("[isExistComplate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int rowno = 0;
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<String> getDvlInfo(String dvlid) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(DVLID,''), ifnull(URL,''), ifnull(USER_ID,''),ifnull(PASSWD,'') from dvlinfo where compno = ? and dvlid = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, dvlid);
                YDMAStringUtil.Print("[isExistComplate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                    list.add(rs.getString(++rowno));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int updateOrd(int brandcd, String orddt, String ordseq, List<List<String>> contents_transf) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = " update EXPPRODMST set EXPFILE = '\uacf5\uc6a9',  EXPCD = '\uacf5\uc6a9' where compno = ? and prodcd = ? and brandcd = ? ";
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                while (i < contents_transf.size()) {
                    List<String> alllist = contents_transf.get(i);
                    String prodcd = this.getOriginProdcdProddtl(alllist.get(11));
                    prodcd = prodcd.equals("") ? alllist.get(11) : prodcd;
                    int idx = 0;
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++idx, prodcd);
                    pstmt.setInt(++idx, brandcd);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                YDMAStringUtil.Print("[setProductInInsert]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return 0;
    }

    private String getOriginProdcdProddtl(String proddtcd) throws Exception {
        String prodcd = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(prodcd,'') FROM PRODDTL WHERE compno = ? and PRODDTCD = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, proddtcd);
                YDMAStringUtil.Print("[getOriginProdcdProddtl]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int rowno = 0;
                    prodcd = rs.getString(++rowno);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return prodcd;
    }
}

