/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.AlimTalkChargeDao;
import com.kdjsystem.mlink.tot.data.dao.CompInfoDao;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.OrderDao;
import com.kdjsystem.mlink.tot.data.dao.PickupDto;
import com.kdjsystem.mlink.tot.data.dao.ProductMstDao;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PickupExpressAPIDao {
    public String REQ_METHOD = "POST";
    public String ACCEPT = "application/json";
    public String CONTENT_TYPE = "application/json";
    public String CONTENT_TYPE_HEADEL = "application/json; charset=utf-8";
    ChromeExtention chrome = ChromeExtention.getInstace();
    ChromeDriver driver = null;

    public List<List<String>> sendPickupExpress(List<List<String>> contents, Shell shell, String exp) throws Exception {
        ArrayList<List<String>> responContents = new ArrayList<List<String>>();
        try {
            String url = "https://receipt.sweettracker.net/put_reception";
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            CompInfoDao dao = new CompInfoDao();
            List<String> complist = dao.getCompNoImage();
            OrderDao ordao = new OrderDao();
            List<String> expcd = ordao.getExpcd_Lott(exp);
            httpConnection.setRequestMethod(this.REQ_METHOD);
            httpConnection.setRequestProperty("Accept", this.ACCEPT);
            httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
            httpConnection.setDoOutput(true);
            AlimTalkChargeDao aldao = new AlimTalkChargeDao();
            aldao.getAlimTalkChargeList(complist.get(25));
            StringBuffer payload = new StringBuffer();
            payload.append("{ \"tierCode\"").append(":\"").append("KDJSYSTEM").append("\",");
            payload.append("\"cipherType\"").append(":\"").append("0").append("\",");
            payload.append("\"data\": [ ");
            payload.append("\n");
            int i = 0;
            while (i < contents.size()) {
                payload.append("{");
                List<String> list = contents.get(i);
                payload.append("\"ordCde\"").append(":\"").append(String.valueOf(complist.get(24)) + list.get(0) + list.get(1) + list.get(2)).append("\",");
                payload.append("\"comCode\"").append(":\"").append(expcd.get(2)).append("\",");
                payload.append("\"addDat\"").append(":\"").append(this.splitMark(list.get(3))).append("\",");
                payload.append("\"cusCde\"").append(":\"").append("971786").append("\",");
                payload.append("\"cusSub\"").append(":\"").append("\",");
                payload.append("\"sndNme\"").append(":\"").append(complist.get(1)).append("\",");
                payload.append("\"sndZip\"").append(":\"").append(complist.get(13)).append("\",");
                payload.append("\"sndAd1\"").append(":\"").append(complist.get(14)).append("\",");
                payload.append("\"sndAd2\"").append(":\"").append("\",");
                payload.append("\"sndTel\"").append(":\"").append(complist.get(17)).append("\",");
                payload.append("\"sndMod\"").append(":\"").append("\",");
                payload.append("\"ownNme\"").append(":\"").append(list.get(4)).append("\",");
                payload.append("\"ownZip\"").append(":\"").append(list.get(5)).append("\",");
                payload.append("\"ownAd1\"").append(":\"").append(list.get(6)).append("\",");
                payload.append("\"ownAd2\"").append(":\"").append("\",");
                if (!list.get(7).equals("")) {
                    payload.append("\"ownTel\"").append(":\"").append(this.splitMark(list.get(7))).append("\",");
                } else {
                    payload.append("\"ownTel\"").append(":\"").append(this.splitMark(list.get(8))).append("\",");
                }
                payload.append("\"ownMod\"").append(":\"").append("\",");
                payload.append("\"adMemo\"").append(":\"").append(list.get(13)).append("\",");
                if (list.get(11).equals("\ud604\ubd88")) {
                    payload.append("\"wipGbn\"").append(":\"").append("1").append("\",");
                } else if (list.get(11).equals("\ucc29\ubd88")) {
                    payload.append("\"wipGbn\"").append(":\"").append("2").append("\",");
                } else {
                    payload.append("\"wipGbn\"").append(":\"").append("3").append("\",");
                }
                payload.append("\"dsoGbn\"").append(":\"").append("2").append("\",");
                payload.append("\"itmLst\"").append(":\"").append(list.get(12)).append("\",");
                payload.append("\"itmCnt\"").append(":\"").append(list.get(9)).append("\"");
                payload.append("} ");
                if (i < contents.size() - 1) {
                    payload.append(", ");
                }
                payload.append("\n");
                ++i;
            }
            payload.append("]}");
            YDMAStringUtil.Print(payload);
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            out.write(payload.toString().getBytes("UTF-8"));
            out.flush();
            out.close();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("\ud0dd\ubc30\uc0ac\uc804\uc1a1: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String inputLine = null;
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            httpConnection.disconnect();
            YDMAStringUtil.Print(response.toString());
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonObject = jsonParser.parse(response.toString());
            String statusCode = jsonObject.getAsJsonObject().get("result").getAsString();
            String ordCde = "";
            String stOrdCde = "";
            if (statusCode.equals("Y")) {
                JsonElement dataObject = jsonObject.getAsJsonObject().get("data");
                JsonArray jsonArray_result = dataObject.getAsJsonArray();
                int i2 = 0;
                while (i2 < jsonArray_result.size()) {
                    JsonElement jsonElement = jsonArray_result.get(i2);
                    String isSuccess = jsonElement.getAsJsonObject().get("result").getAsString();
                    String errMsg = "";
                    String errCde = "";
                    ArrayList<String> list = new ArrayList<String>();
                    if (isSuccess.equals("N")) {
                        errCde = jsonElement.getAsJsonObject().get("errCde").getAsString();
                        errMsg = jsonElement.getAsJsonObject().get("errMsg").getAsString();
                        list.add(errCde);
                        list.add(errMsg);
                    } else {
                        ordCde = jsonElement.getAsJsonObject().get("ordCde").getAsString();
                        stOrdCde = jsonElement.getAsJsonObject().get("stOrdCde").getAsString();
                        list.add(isSuccess);
                        list.add(ordCde);
                        list.add(stOrdCde);
                        list.add(errCde);
                        list.add(errMsg);
                        list.add(contents.get(i2).get(0));
                        list.add(contents.get(i2).get(1));
                        list.add(contents.get(i2).get(2));
                        list.add(expcd.get(0));
                        list.add(expcd.get(1));
                    }
                    responContents.add(list);
                    ++i2;
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(jsonObject.getAsJsonObject().get("result").getAsString());
                list.add(ordCde);
                list.add(stOrdCde);
                list.add(jsonObject.getAsJsonObject().get("errCde").getAsString());
                list.add(jsonObject.getAsJsonObject().get("errMsg").getAsString());
                responContents.add(list);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public List<List<String>> getPickupExpressReception(List<String> list2, Shell shell) {
        ArrayList<List<String>> responContents = new ArrayList<List<String>>();
        try {
            String url = "https://receipt.sweettracker.net/get_reception";
            URL obj = new URL(url);
            HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
            CompInfoDao dao = new CompInfoDao();
            List<String> complist = dao.getCompNoImage();
            httpConnection.setRequestMethod(this.REQ_METHOD);
            httpConnection.setRequestProperty("Accept", this.ACCEPT);
            httpConnection.setRequestProperty("Content-Type", this.CONTENT_TYPE);
            httpConnection.setDoOutput(true);
            AlimTalkChargeDao aldao = new AlimTalkChargeDao();
            aldao.getAlimTalkChargeList(complist.get(25));
            StringBuffer payload = new StringBuffer();
            payload.append("{ \"tierCode\"").append(":\"").append("KDJSYSTEM").append("\",");
            payload.append("\"cipherType\"").append(":\"").append("0").append("\",");
            payload.append("\"ordCde\"").append(":\"").append(String.valueOf(complist.get(24)) + list2.get(0) + list2.get(1) + list2.get(2)).append("\"");
            payload.append("} ");
            YDMAStringUtil.Print(payload);
            DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
            out.write(payload.toString().getBytes("UTF-8"));
            out.flush();
            out.close();
            int responseCode = httpConnection.getResponseCode();
            YDMAStringUtil.Print("\ud0dd\ubc30\uc0ac\uc1a1\uc7a5\uc218\uc2e0: " + responseCode);
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
            String inputLine = null;
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            httpConnection.disconnect();
            YDMAStringUtil.Print(response.toString());
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonObject = jsonParser.parse(response.toString());
            String statusCode = jsonObject.getAsJsonObject().get("result").getAsString();
            if (statusCode.equals("Y")) {
                JsonElement dataObject = jsonObject.getAsJsonObject().get("data");
                String result = jsonObject.getAsJsonObject().get("result").getAsString();
                JsonArray jsonArray_result = dataObject.getAsJsonArray();
                int i = 0;
                while (i < jsonArray_result.size()) {
                    JsonElement jsonElement = jsonArray_result.get(i);
                    String ownAd2 = jsonElement.getAsJsonObject().get("ownAd2").getAsString();
                    String ownAd1 = jsonElement.getAsJsonObject().get("ownAd1").getAsString();
                    String sndZip = jsonElement.getAsJsonObject().get("sndZip").getAsString();
                    String addDat = jsonElement.getAsJsonObject().get("addDat").getAsString();
                    String invoice = jsonElement.getAsJsonObject().get("invoice") == null ? "" : jsonElement.getAsJsonObject().get("invoice").getAsString();
                    String sndMod = jsonElement.getAsJsonObject().get("sndMod").getAsString();
                    String sndNme = jsonElement.getAsJsonObject().get("sndNme").getAsString();
                    String sndTel = jsonElement.getAsJsonObject().get("sndTel").getAsString();
                    String itmLst = jsonElement.getAsJsonObject().get("itmLst").getAsString();
                    String ownNme = jsonElement.getAsJsonObject().get("ownNme").getAsString();
                    String ownZip = jsonElement.getAsJsonObject().get("ownZip").getAsString();
                    String ownMod = jsonElement.getAsJsonObject().get("ownMod").getAsString();
                    String adMemo = jsonElement.getAsJsonObject().get("adMemo").getAsString();
                    String wipGbn = jsonElement.getAsJsonObject().get("wipGbn").getAsString();
                    String comCode = jsonElement.getAsJsonObject().get("comCode").getAsString();
                    String sndAd1 = jsonElement.getAsJsonObject().get("sndAd1").getAsString();
                    String ordCde = jsonElement.getAsJsonObject().get("ordCde").getAsString();
                    String trnYn = jsonElement.getAsJsonObject().get("trnYn").getAsString();
                    String ownTel = jsonElement.getAsJsonObject().get("ownTel").getAsString();
                    String dsoGbn = jsonElement.getAsJsonObject().get("dsoGbn").getAsString();
                    String sndAd2 = jsonElement.getAsJsonObject().get("sndAd2").getAsString();
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(result);
                    list.add(ownAd2);
                    list.add(ownAd1);
                    list.add(sndZip);
                    list.add(addDat);
                    list.add(invoice);
                    list.add(sndMod);
                    list.add(sndNme);
                    list.add(sndTel);
                    list.add(itmLst);
                    list.add(invoice);
                    list.add(ownNme);
                    list.add(ownZip);
                    list.add(ownMod);
                    list.add(adMemo);
                    list.add(wipGbn);
                    list.add(comCode);
                    list.add(sndAd1);
                    list.add(ordCde);
                    list.add(trnYn);
                    list.add(ownTel);
                    list.add(dsoGbn);
                    list.add(sndAd2);
                    list.add(list2.get(0));
                    list.add(list2.get(1));
                    list.add(list2.get(2));
                    responContents.add(list);
                    ++i;
                }
            } else {
                ArrayList<String> list = new ArrayList<String>();
                list.add(jsonObject.getAsJsonObject().get("result").getAsString());
                list.add(jsonObject.getAsJsonObject().get("tierCode").getAsString());
                list.add(jsonObject.getAsJsonObject().get("errMsg").getAsString());
                list.add(jsonObject.getAsJsonObject().get("errCde").getAsString());
                list.add(jsonObject.getAsJsonObject().get("ordCde").getAsString());
                responContents.add(list);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public String splitMark(String text) {
        String[] split = text.split("-| ");
        String complite = "";
        int j = 0;
        while (j < split.length) {
            complite = String.valueOf(complite) + split[j];
            complite = complite.trim();
            ++j;
        }
        return complite;
    }

    public void getPickupExpressInvnoUpdate(List<String> list, int brandcd) throws Exception {
        block5: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set INVNO = ?, EXPRECVDT = ?  where ORDDT = ?    and ORDSEQ =?    and seq = ?    and compno = ?    and brandcd = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int i = 0;
                    pstmt.setString(++i, list.get(3));
                    pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++i, list.get(0));
                    pstmt.setString(++i, list.get(1));
                    pstmt.setString(++i, list.get(2));
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++i, brandcd);
                    pstmt.executeUpdate();
                    YDMAStringUtil.Print("[getPickupExpressInvnoUpdate]" + pstmt.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void getPickupExpressInvnoUpdate(PickupDto list, int brandcd) throws Exception {
        block5: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set INVNO = ?, EXPRECVDT = ?  where ORDDT = ?    and ORDSEQ =?    and seq = ?    and compno = ?    and brandcd = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int i = 0;
                    pstmt.setString(++i, list.getRorddt());
                    pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++i, list.getOrddt());
                    pstmt.setString(++i, list.getOrdseq());
                    pstmt.setString(++i, list.getSeq());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++i, brandcd);
                    pstmt.executeUpdate();
                    YDMAStringUtil.Print("[getPickupExpressInvnoUpdate]" + pstmt.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setExpressSendDT(List<List<String>> sendResult) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set EXPSENDDT=?, expnm = ?  where orddt=?    and ordseq = ?    and seq = ?    and compno = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : sendResult) {
                        int i = 0;
                        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++i, String.valueOf(list.get(4)) + "_" + list.get(3));
                        pstmt.setString(++i, list.get(0));
                        pstmt.setString(++i, list.get(1));
                        pstmt.setString(++i, list.get(2));
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setExpressSendDT]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setExpressSendDTAndInvoiceUpdate(List<List<String>> sendResult, int brandcd) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set EXPSENDDT=?, expnm = ?, invno = ?, exprecvdt = ?  where orddt=?    and ordseq = ?    and seq = ?    and compno = ?    and brandcd = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : sendResult) {
                        int i = 0;
                        if (list.size() <= 2) continue;
                        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++i, String.valueOf(list.get(4)) + "_" + list.get(3));
                        pstmt.setString(++i, list.get(5));
                        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++i, list.get(0));
                        pstmt.setString(++i, list.get(1));
                        pstmt.setString(++i, list.get(2));
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[prodAttrvalInsert]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setMoveList(List<List<String>> contents, String menu, int brandcd) throws Exception {
        block24: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set EXPFILE=?, expcd =? where orddt=? and ordseq = ? and seq = ? and compno = ? and brandcd = ?";
                    String exp = "";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : contents) {
                        int i = 0;
                        if (menu.equals("\ub300\uc2e0\ud0dd\ubc30") || menu.equals("\ud0dd\ubc30\ube44\ucd08\uacfc") || menu.equals("\ub86f\ub370(3500\uc6d0\ubbf8\ub9cc)") || menu.equals("\ucc9c\uc77c\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\ud569\ub3d9\ud0dd\ubc30");
                        } else if (menu.equals("\ub86f\ub370\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\ub86f\ub370\ud0dd\ubc30");
                        } else if (menu.equals("\ud55c\uc9c4\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\ud55c\uc9c4\ud0dd\ubc30");
                        } else if (menu.equals("\uacbd\ub3d9\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\uacbd\ub3d9\ud0dd\ubc30");
                        } else if (menu.equals("\ub300\ud55c\ud1b5\uc6b4")) {
                            pstmt.setString(++i, "\ub300\ud55c\ud1b5\uc6b4");
                        } else if (menu.equals("\uc6b0\uccb4\uad6d\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\uc6b0\uccb4\uad6d\ud0dd\ubc30");
                        } else if (menu.equals("\ub85c\uc820\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\ub85c\uc820\ud0dd\ubc30");
                        } else if (menu.equals("\ud654\ubb3c")) {
                            pstmt.setString(++i, "\ud654\ubb3c");
                        } else if (menu.equals("\ubc30\uc1a1\ube44\ucd94\uac00\uc9c0\uc5ed")) {
                            pstmt.setString(++i, "\ubc30\uc1a1\ube44\ucd94\uac00\uc9c0\uc5ed");
                        } else {
                            pstmt.setString(++i, "\uacf5\uc6a9");
                        }
                        exp = menu.equals("\ub86f\ub370(3500\uc6d0\ubbf8\ub9cc)") ? "\ub86f\ub370\ud0dd\ubc30" : menu;
                        pstmt.setString(++i, exp);
                        pstmt.setString(++i, list.get(0));
                        pstmt.setString(++i, list.get(1));
                        pstmt.setString(++i, list.get(2));
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setMoveList]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block24;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setMoveList2(List<PickupDto> contents, String menu, int brandcd) throws Exception {
        block20: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set EXPFILE=?, expcd =? where orddt=? and ordseq = ? and seq = ? and compno = ? and brandcd = ?";
                    String exp = "";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (PickupDto list : contents) {
                        int i = 0;
                        if (menu.equals("\ub300\uc2e0\ud0dd\ubc30") || menu.equals("\ud0dd\ubc30\ube44\ucd08\uacfc") || menu.equals("\ub86f\ub370(3500\uc6d0\ubbf8\ub9cc)") || menu.equals("\ucc9c\uc77c\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\ud569\ub3d9\ud0dd\ubc30");
                        } else if (menu.equals("\ub86f\ub370\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\ub86f\ub370\ud0dd\ubc30");
                        } else if (menu.equals("\ud55c\uc9c4\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\ud55c\uc9c4\ud0dd\ubc30");
                        } else if (menu.equals("\uacbd\ub3d9\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\uacbd\ub3d9\ud0dd\ubc30");
                        } else if (menu.equals("\ub300\ud55c\ud1b5\uc6b4")) {
                            pstmt.setString(++i, "\ub300\ud55c\ud1b5\uc6b4");
                        } else if (menu.equals("\uc6b0\uccb4\uad6d\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\uc6b0\uccb4\uad6d\ud0dd\ubc30");
                        } else if (menu.equals("\ub85c\uc820\ud0dd\ubc30")) {
                            pstmt.setString(++i, "\ub85c\uc820\ud0dd\ubc30");
                        } else {
                            pstmt.setString(++i, "\uacf5\uc6a9");
                        }
                        exp = menu.equals("\ub86f\ub370(3500\uc6d0\ubbf8\ub9cc)") ? "\ub86f\ub370\ud0dd\ubc30" : menu;
                        pstmt.setString(++i, exp);
                        pstmt.setString(++i, list.getOrddt());
                        pstmt.setString(++i, list.getOrdseq());
                        pstmt.setString(++i, list.getSeq());
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setMoveList]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block20;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public List<List<String>> sendPickupChunilExpress(List<List<String>> cloneContents, String orddt, List<String> comlist) {
        ArrayList<List<String>> contents;
        block44: {
            contents = new ArrayList<List<String>>();
            String driver = "oracle.jdbc.driver.OracleDriver";
            String url = "jdbc:oracle:thin:@121.172.114.136:1521:TAEKBAE";
            String user = "yd";
            String password = "chunilps1001";
            Connection con = null;
            Statement pstmt = null;
            ResultSet rs = null;
            CallableStatement cstmt = null;
            Locale backup = Locale.getDefault();
            try {
                Class.forName(driver);
                YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc131\uacf5");
                Locale.setDefault(Locale.US);
                con = DriverManager.getConnection(url, user, password);
                int num = 1;
                for (List<String> list : cloneContents) {
                    long seq = Long.parseLong(String.valueOf(list.get(0)) + list.get(1) + list.get(2));
                    if (list.get(46).equals("X")) {
                        seq = Long.parseLong(YDMATimeUtil.getCurrentTime()) + (long)num++;
                    }
                    String prodnm = "";
                    prodnm = list.get(12).length() > 99 ? list.get(12).substring(0, 100) : list.get(12);
                    int code = this.getItemCode(list.get(10));
                    cstmt = con.prepareCall("{call NTB.INS_API(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
                    cstmt.setLong(1, seq);
                    cstmt.setString(2, orddt);
                    cstmt.setString(3, "KGB8");
                    cstmt.setString(4, "KGB80003");
                    cstmt.setString(5, list.get(4));
                    cstmt.setString(6, list.get(5));
                    cstmt.setString(7, list.get(6));
                    cstmt.setString(8, "");
                    cstmt.setString(9, list.get(7));
                    cstmt.setString(10, list.get(8));
                    cstmt.setString(11, comlist.get(1));
                    cstmt.setString(12, comlist.get(14));
                    cstmt.setString(13, "");
                    cstmt.setString(14, comlist.get(17));
                    cstmt.setString(15, "");
                    cstmt.setString(16, "KGB" + code);
                    cstmt.setString(17, prodnm);
                    cstmt.setInt(18, Integer.parseInt(list.get(9)));
                    cstmt.setString(19, list.get(11).equals("\ud604\ubd88") ? "1" : (list.get(11).equals("\uc120\ubd88") ? "1" : (list.get(11).equals("\uc2e0\uc6a9") ? "1" : "2")));
                    cstmt.setString(20, list.get(15).equals("\ud0dd\ubc30") ? "2" : "1");
                    cstmt.setString(21, list.get(13));
                    cstmt.setString(22, "");
                    cstmt.setString(23, YDMATimeUtil.getCurrentTimeByYDFormat());
                    cstmt.setString(24, "13");
                    cstmt.registerOutParameter(25, 12);
                    cstmt.execute();
                    list.add(0, cstmt.getString(25));
                    contents.add(list);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc2e4\ud328");
                Locale.setDefault(backup);
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {}
                }
                if (cstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                break block44;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    YDMAStringUtil.Print("\uc624\ub77c\ud074 \uc5f0\uacb0 \uc2e4\ud328");
                }
                catch (Throwable throwable) {
                    Locale.setDefault(backup);
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (cstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                Locale.setDefault(backup);
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {}
                }
                if (cstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                break block44;
            }
            Locale.setDefault(backup);
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
            if (cstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return contents;
    }

    public List<PickupDto> sendPickupChunilExpress2(List<PickupDto> cloneContents, String orddt, List<String> comlist) {
        ArrayList<PickupDto> contents;
        block44: {
            contents = new ArrayList<PickupDto>();
            String driver = "oracle.jdbc.driver.OracleDriver";
            String url = "jdbc:oracle:thin:@121.172.114.136:1521:TAEKBAE";
            String user = "yd";
            String password = "chunilps1001";
            Connection con = null;
            Statement pstmt = null;
            ResultSet rs = null;
            CallableStatement cstmt = null;
            Locale backup = Locale.getDefault();
            try {
                Class.forName(driver);
                YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc131\uacf5");
                Locale.setDefault(Locale.US);
                con = DriverManager.getConnection(url, user, password);
                int num = 1;
                for (PickupDto list : cloneContents) {
                    long seq = Long.parseLong(String.valueOf(list.getOrddt()) + list.getOrdseq() + list.getSeq());
                    if (list.getFlag().equals("X")) {
                        seq = Long.parseLong(YDMATimeUtil.getCurrentTime()) + (long)num++;
                    }
                    String prodnm = "";
                    prodnm = list.getExpprodnm().length() > 99 ? list.getExpprodnm().substring(0, 100) : list.getExpprodnm();
                    int code = this.getItemCode(list.getShpfee());
                    cstmt = con.prepareCall("{call NTB.INS_API(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
                    cstmt.setLong(1, seq);
                    cstmt.setString(2, orddt);
                    cstmt.setString(3, "KGB8");
                    cstmt.setString(4, "KGB80003");
                    cstmt.setString(5, list.getRcvnam());
                    cstmt.setString(6, list.getPstno());
                    cstmt.setString(7, list.getAddr());
                    cstmt.setString(8, "");
                    cstmt.setString(9, list.getClpno());
                    cstmt.setString(10, list.getTelno());
                    cstmt.setString(11, comlist.get(1));
                    cstmt.setString(12, comlist.get(14));
                    cstmt.setString(13, "");
                    cstmt.setString(14, comlist.get(17));
                    cstmt.setString(15, "");
                    cstmt.setString(16, "KGB" + code);
                    cstmt.setString(17, prodnm);
                    cstmt.setInt(18, Integer.parseInt(list.getQty()));
                    cstmt.setString(19, list.getCredit().equals("\ud604\ubd88") ? "1" : (list.getCredit().equals("\uc120\ubd88") ? "1" : (list.getCredit().equals("\uc2e0\uc6a9") ? "1" : "2")));
                    cstmt.setString(20, list.getShipcls().equals("\ud0dd\ubc30") ? "2" : "1");
                    cstmt.setString(21, list.getMessge());
                    cstmt.setString(22, "");
                    cstmt.setString(23, YDMATimeUtil.getCurrentTimeByYDFormat());
                    cstmt.setString(24, "13");
                    cstmt.registerOutParameter(25, 12);
                    cstmt.execute();
                    list.setEtcmsg(cstmt.getString(25));
                    contents.add(list);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc2e4\ud328");
                Locale.setDefault(backup);
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {}
                }
                if (cstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                break block44;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    YDMAStringUtil.Print("\uc624\ub77c\ud074 \uc5f0\uacb0 \uc2e4\ud328");
                }
                catch (Throwable throwable) {
                    Locale.setDefault(backup);
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (cstmt != null) {
                        try {
                            pstmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                Locale.setDefault(backup);
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Exception exception) {}
                }
                if (cstmt != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Exception exception) {}
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Exception exception) {}
                }
                break block44;
            }
            Locale.setDefault(backup);
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
            if (cstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return contents;
    }

    private int getItemCode(String delvcost) {
        int code = 0;
        switch (delvcost) {
            case "4500": {
                code = 80003037;
                break;
            }
            case "5000": {
                code = 80003038;
                break;
            }
            case "5500": {
                code = 80003039;
                break;
            }
            case "6000": {
                code = 80003040;
                break;
            }
            case "6500": {
                code = 80003041;
                break;
            }
            case "7000": {
                code = 80003042;
                break;
            }
            case "7500": {
                code = 80003043;
                break;
            }
            case "8000": {
                code = 80003044;
                break;
            }
            case "8500": {
                code = 80003045;
                break;
            }
            case "9000": {
                code = 80003046;
                break;
            }
            case "9500": {
                code = 80003047;
                break;
            }
            case "10000": {
                code = 80003048;
                break;
            }
            case "10500": {
                code = 80003049;
                break;
            }
            case "11000": {
                code = 80003050;
                break;
            }
            case "12000": {
                code = 80003051;
                break;
            }
            case "14000": {
                code = 80003053;
                break;
            }
            case "20000": {
                code = 80003059;
                break;
            }
            case "25000": {
                code = 80003060;
                break;
            }
            default: {
                code = 0;
            }
        }
        return code;
    }

    public List<List<String>> sendPickupExpressCrawl(List<List<String>> contents, Shell shell, String exp, List<String> addr) {
        ArrayList<List<String>> express = new ArrayList<List<String>>();
        ChromeDriver driver = ChromeExtention.getInstace().getDriver(false);
        int count = 1;
        try {
            OrderDao ordao = new OrderDao();
            List<String> expcd = ordao.getExpcd_Lott(exp);
            List<String> expidNpass = ordao.getDvlInfo(expcd.get(0));
            String URL2 = expidNpass.get(1);
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, 30L);
            driver.get(URL2);
            Thread.sleep(3000L);
            try {
                WebElement elementloginBox = driver.findElement(By.xpath((String)"/html/body/div[3]/div[2]"));
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"principal\"]/input")).sendKeys(new CharSequence[]{expidNpass.get(2)});
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"credential\"]/input")).sendKeys(new CharSequence[]{expidNpass.get(3)});
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"btn-login\"]")).click();
            }
            catch (Exception e) {
                YDMAProgressBar.get().setValue("\ub85c\uadf8\uc778\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc2dc\ub3c4 \ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.", 0);
                throw new Exception(e.getMessage());
            }
            wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]")));
            ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]/div[3]/i-button")))).click();
            Thread.sleep(1000L);
            ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"/html/body/div[3]/header/nav/div[3]/div/div[2]/div[2]/div[2]/ul/li[1]/a")))).click();
            driver.switchTo().frame(driver.findElement(By.id((String)"workframe_10781")));
            Thread.sleep(5000L);
            int i = 0;
            while (i < contents.size()) {
                if (!addr.get(i).contains("\uc624\ub958")) {
                    try {
                        List<String> list = contents.get(i);
                        String name = list.get(4);
                        if (list.get(7).equals("") && list.get(8).equals("")) {
                            throw new Exception("\uace0\uac1d\uba85 : " + name + "\ub2d8\uc758 \uc5f0\ub77d\ucc98\uac00 \uc5c6\uc5b4 \ub4f1\ub85d \ud558\uc2e4\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        }
                        if (list.get(4).equals("")) {
                            throw new Exception("No. : " + list.get(2) + "\uc758 \uace0\uac1d\uba85\uc774 \uc5c6\uc5b4 \ub4f1\ub85d \ud558\uc2e4\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        }
                        if (list.get(12).equals("")) {
                            throw new Exception("\uace0\uac1d\uba85 : " + name + "\ub2d8\uc758 \ubc30\uc1a1\uc0c1\ud488\uba85\uc774 \uc5c6\uc5b4 \ub4f1\ub85d \ud558\uc2e4\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        }
                        if (list.get(9).equals("") || list.get(9).equals("0")) {
                            throw new Exception("\uace0\uac1d\uba85 : " + name + "\ubc1c\uc1a1 \uc218\ub7c9\uc774 \uc5c6\uc5b4 \ub4f1\ub85d \ud558\uc2e4\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        }
                        if (list.get(10).equals("") || list.get(10).equals("0")) {
                            throw new Exception("\uace0\uac1d\uba85 : " + name + "\ub2d8\uc758 \ubc30\uc1a1\ube44\uc6a9\uc774 \uc5c6\uc5b4 \ub4f1\ub85d \ud558\uc2e4\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        }
                        ArrayList<String> output = new ArrayList<String>();
                        Thread.sleep(1000L);
                        new StringBuffer();
                        driver.executeScript(String.format("$('#edtAcperTel').val('%s'); ", list.get(7).equals("") ? list.get(8) : list.get(7)), new Object[]{""});
                        driver.executeScript(String.format("$('#edtAcperNm').val('%s'); ", list.get(4)), new Object[]{""});
                        driver.executeScript("$('#btnAcperBadr').click(); ", new Object[]{""});
                        Thread.sleep(1000L);
                        String strExcute = "(()=>{ " + String.format("$('#edtSrchAdrMultiPopGrid').val('%s'); \r\n", addr.get(i)) + "$('#btnAdrMultiSrchGrid').click();  \r\n" + " setTimeout( ()=>{ \r\n " + "    if(dsAdrMultiPopGrid.getRowCount() > 0) \r\n" + "    { " + String.format("dsAdrMultiPopGrid.setRowPosition(dsAdrMultiPopGrid.getRows().findIndex((p)=>p.basAreaNo === '%s'  || p.zipcd === '%s')); \r\n ", list.get(5), list.get(5)) + "$.popCallBack.popupCallBack_fn(dsAdrMultiPopGrid.getRow(dsAdrMultiPopGrid.getRowPosition()));  \r\n" + "}" + "},500);" + "})();";
                        driver.executeScript(strExcute, new Object[]{""});
                        Thread.sleep(1000L);
                        driver.executeScript("document.querySelector(\"body > div:nth-child(35) > div.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix > div > button:nth-child(1) > span\").click()", new Object[0]);
                        String result = ChromeScript.get().waitTiem(2000L).returnCallbackScripter("return document.querySelector(\"body > div:nth-child(35)\").style.display", driver);
                        if (result.equals("block")) {
                            String strExcute2 = "(()=>{ " + String.format("$('#edtSrchAdrMultiPopGrid').val('%s'); \r\n", addr.get(i)) + "$('#btnAdrMultiSrchGrid').click();  \r\n" + " setTimeout( ()=>{ \r\n " + "    if(dsAdrMultiPopGrid.getRowCount() > 0) \r\n" + "    { \r\n" + "$.popCallBack.popupCallBack_fn(dsAdrMultiPopGrid.getRow(0)); \r\n" + "}" + "},500);" + "})();";
                            driver.executeScript(strExcute2, new Object[]{""});
                            Thread.sleep(1000L);
                            driver.executeScript("document.querySelector(\"body > div:nth-child(35) > div.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix > div > button:nth-child(1) > span\").click()", new Object[0]);
                        }
                        Thread.sleep(1000L);
                        driver.executeScript(String.format("$('#edtAcperEtcAdr').val('%s'); ", list.get(6).substring(addr.get(i).length(), list.get(6).length())), new Object[]{""});
                        ProductMstDao mdao = new ProductMstDao();
                        String ecountcd = " (";
                        List<List<String>> mstlist = mdao.getERPCodeList(contents.get(i).get(0), contents.get(i).get(1), contents.get(i).get(2));
                        int e = 0;
                        while (e < mstlist.size()) {
                            ecountcd = String.valueOf(ecountcd) + mstlist.get(e).get(0);
                            if (e + 1 < mstlist.size()) {
                                ecountcd = String.valueOf(ecountcd) + ",";
                            }
                            ++e;
                        }
                        ecountcd = String.valueOf(ecountcd) + " )";
                        driver.executeScript(String.format("$('#edtGdsNm').val('%s');  ", String.valueOf(list.get(12)) + ecountcd), new Object[]{""});
                        driver.executeScript(String.format("$('#edtDlvMsgCont').val('%s');", list.get(13)), new Object[]{""});
                        Thread.sleep(1000L);
                        if (list.get(11).equals("\ucc29\ubd88")) {
                            driver.executeScript("$('#cboFareSctCd').val('02')", new Object[]{""});
                        } else {
                            driver.executeScript("$('#cboFareSctCd').val('03')", new Object[]{""});
                        }
                        Thread.sleep(1000L);
                        driver.executeScript(String.format("$('#maeDlvFare').val('%s')", list.get(10)), new Object[]{""});
                        Thread.sleep(1000L);
                        driver.executeScript("fnSave()", new Object[]{""});
                        Thread.sleep(1000L);
                        driver.executeScript("$('.msgButton').click()", new Object[]{""});
                        Thread.sleep(1500L);
                        driver.executeScript("$('.msgButton').click()", new Object[]{""});
                        output.add(list.get(0));
                        output.add(list.get(1));
                        output.add(list.get(2));
                        output.add(expcd.get(0));
                        output.add(expcd.get(1));
                        express.add(output);
                        Thread.sleep(1000L);
                        YDMAProgressBar.get().setValue("\uace0\uac1d\uba85 : " + list.get(4) + "\ub2d8\uc758 \ud0dd\ubc30 \uc811\uc218\uac00 \uc815\uc0c1\uc801\uc73c\ub85c \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", count++);
                    }
                    catch (Exception e) {
                        YDMAProgressBar.get().setValue(e.getMessage(), count++);
                    }
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return express;
    }

    public List<List<String>> sendPickupExpressCrawl2(List<PickupDto> contents, Shell shell, String exp) {
        ArrayList<List<String>> express = new ArrayList<List<String>>();
        ChromeDriver driver = ChromeExtention.getInstace().getDriver(false);
        int count = 1;
        try {
            OrderDao ordao = new OrderDao();
            List<String> expcd = ordao.getExpcd_Lott(exp);
            List<String> expidNpass = ordao.getDvlInfo(expcd.get(0));
            String URL2 = expidNpass.get(1);
            WebDriverWait wait = new WebDriverWait((WebDriver)driver, 30L);
            driver.get(URL2);
            Thread.sleep(3000L);
            try {
                WebElement elementloginBox = driver.findElement(By.xpath((String)"/html/body/div[3]/div[2]"));
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"principal\"]/input")).sendKeys(new CharSequence[]{expidNpass.get(2)});
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"credential\"]/input")).sendKeys(new CharSequence[]{expidNpass.get(3)});
                elementloginBox.findElement(By.xpath((String)"//*[@id=\"btn-login\"]")).click();
            }
            catch (Exception e) {
                YDMAProgressBar.get().setValue("\ub85c\uadf8\uc778\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc2dc\ub3c4 \ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.", 0);
                throw new Exception(e.getMessage());
            }
            wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]")));
            ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]/div[3]/i-button")))).click();
            Thread.sleep(1000L);
            ((WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.xpath((String)"/html/body/div[3]/header/nav/div[3]/div/div[2]/div[2]/div[2]/ul/li[1]/a")))).click();
            driver.switchTo().frame(driver.findElement(By.id((String)"workframe_10781")));
            Thread.sleep(5000L);
            for (PickupDto list : contents) {
                if (list.getParam2().contains("\uc624\ub958")) continue;
                try {
                    String name = list.getRcvnam();
                    if (list.getClpno().equals("") && list.getTelno().equals("")) {
                        throw new Exception("\uace0\uac1d\uba85 : " + name + "\ub2d8\uc758 \uc5f0\ub77d\ucc98\uac00 \uc5c6\uc5b4 \ub4f1\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    }
                    if (name.equals("")) {
                        throw new Exception("No. : " + list.getSeq() + "\uc758 \uace0\uac1d\uba85\uc774 \uc5c6\uc5b4 \ub4f1\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    }
                    if (list.getExpprodnm().equals("")) {
                        throw new Exception("\uace0\uac1d\uba85 : " + name + "\ub2d8\uc758 \ubc30\uc1a1\uc0c1\ud488\uba85\uc774 \uc5c6\uc5b4 \ub4f1\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    }
                    if (list.getQty().equals("") || list.getQty().equals("0")) {
                        throw new Exception("\uace0\uac1d\uba85 : " + name + "\ubc1c\uc1a1 \uc218\ub7c9\uc774 \uc5c6\uc5b4 \ub4f1\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    }
                    if (list.getShpfee().equals("") || list.getShpfee().equals("0")) {
                        throw new Exception("\uace0\uac1d\uba85 : " + name + "\ub2d8\uc758 \ubc30\uc1a1\ube44\uc6a9\uc774 \uc5c6\uc5b4 \ub4f1\ub85d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                    }
                    ArrayList<String> output = new ArrayList<String>();
                    Thread.sleep(1000L);
                    driver.executeScript(String.format("$('#edtAcperTel').val('%s'); ", list.getClpno().equals("") ? list.getTelno() : list.getClpno()), new Object[]{""});
                    driver.executeScript(String.format("$('#edtAcperNm').val('%s'); ", name), new Object[]{""});
                    driver.executeScript("$('#btnAcperBadr').click(); ", new Object[]{""});
                    Thread.sleep(1000L);
                    String strExcute = "(()=>{ " + String.format("$('#edtSrchAdrMultiPopGrid').val('%s'); \r\n", list.getParam2()) + "$('#btnAdrMultiSrchGrid').click();  \r\n" + " setTimeout( ()=>{ \r\n " + "    if(dsAdrMultiPopGrid.getRowCount() > 0) \r\n" + "    { " + String.format("dsAdrMultiPopGrid.setRowPosition(dsAdrMultiPopGrid.getRows().findIndex((p)=>p.basAreaNo === '%s'  || p.zipcd === '%s')); \r\n ", list.getPstno(), list.getPstno()) + "$.popCallBack.popupCallBack_fn(dsAdrMultiPopGrid.getRow(dsAdrMultiPopGrid.getRowPosition()));  \r\n" + "}" + "},500);" + "})();";
                    driver.executeScript(strExcute, new Object[]{""});
                    Thread.sleep(1000L);
                    driver.executeScript("document.querySelector(\"body > div:nth-child(35) > div.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix > div > button:nth-child(1) > span\").click()", new Object[0]);
                    String result = ChromeScript.get().waitTiem(2000L).returnCallbackScripter("return document.querySelector(\"body > div:nth-child(35)\").style.display", driver);
                    if (result.equals("block")) {
                        String strExcute2 = "(()=>{ " + String.format("$('#edtSrchAdrMultiPopGrid').val('%s'); \r\n", list.getParam2()) + "$('#btnAdrMultiSrchGrid').click();  \r\n" + " setTimeout( ()=>{ \r\n " + "    if(dsAdrMultiPopGrid.getRowCount() > 0) \r\n" + "    { \r\n" + "$.popCallBack.popupCallBack_fn(dsAdrMultiPopGrid.getRow(0)); \r\n" + "}" + "},500);" + "})();";
                        driver.executeScript(strExcute2, new Object[]{""});
                        Thread.sleep(1000L);
                        driver.executeScript("document.querySelector(\"body > div:nth-child(35) > div.ui-dialog-buttonpane.ui-widget-content.ui-helper-clearfix > div > button:nth-child(1) > span\").click()", new Object[0]);
                    }
                    Thread.sleep(1000L);
                    driver.executeScript(String.format("$('#edtAcperEtcAdr').val('%s'); ", list.getAddr().substring(list.getParam2().length(), list.getAddr().length())), new Object[]{""});
                    ProductMstDao mdao = new ProductMstDao();
                    String ecountcd = " (";
                    List<List<String>> mstlist = mdao.getERPCodeList(list.getOrddt(), list.getOrdseq(), list.getSeq());
                    int e = 0;
                    while (e < mstlist.size()) {
                        ecountcd = String.valueOf(ecountcd) + mstlist.get(e).get(0);
                        if (e + 1 < mstlist.size()) {
                            ecountcd = String.valueOf(ecountcd) + ",";
                        }
                        ++e;
                    }
                    ecountcd = String.valueOf(ecountcd) + " )";
                    driver.executeScript(String.format("$('#edtGdsNm').val('%s');  ", String.valueOf(list.getExpprodnm()) + ecountcd), new Object[]{""});
                    driver.executeScript(String.format("$('#edtDlvMsgCont').val('%s');", list.getMessge()), new Object[]{""});
                    Thread.sleep(1000L);
                    if (list.getCredit().equals("\ucc29\ubd88")) {
                        driver.executeScript("$('#cboFareSctCd').val('02')", new Object[]{""});
                    } else {
                        driver.executeScript("$('#cboFareSctCd').val('03')", new Object[]{""});
                    }
                    Thread.sleep(1000L);
                    driver.executeScript(String.format("$('#maeDlvFare').val('%s')", list.getShipcls()), new Object[]{""});
                    Thread.sleep(1000L);
                    driver.executeScript("fnSave()", new Object[]{""});
                    Thread.sleep(1000L);
                    driver.executeScript("$('.msgButton').click()", new Object[]{""});
                    Thread.sleep(1500L);
                    driver.executeScript("$('.msgButton').click()", new Object[]{""});
                    output.add(list.getOrddt());
                    output.add(list.getOrdseq());
                    output.add(list.getSeq());
                    output.add(expcd.get(0));
                    output.add(expcd.get(1));
                    express.add(output);
                    Thread.sleep(1000L);
                    YDMAProgressBar.get().setValue("\uace0\uac1d\uba85 : " + name + "\ub2d8\uc758 \ud0dd\ubc30 \uc811\uc218\uac00 \uc815\uc0c1\uc801\uc73c\ub85c \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", count++);
                }
                catch (Exception e) {
                    YDMAProgressBar.get().setValue(e.getMessage(), count++);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return express;
    }

    public int[] deletePickupList(List<List<String>> contents, int brandcd) throws Exception {
        int[] result;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql = "DELETE FROM pickupexp where compno=? and orddt=? and ordseq = ? and seq = ? and BRANDCD = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (List<String> list : contents) {
                    int i = 0;
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, list.get(0));
                    pstmt.setString(++i, list.get(1));
                    pstmt.setString(++i, list.get(2));
                    pstmt.setInt(++i, brandcd);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[ProductErrordataDelete]" + pstmt.toString());
                result = pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int[] deletePickupList2(List<PickupDto> contents, int brandcd) throws Exception {
        int[] result;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql = "DELETE FROM pickupexp where compno=? and orddt=? and ordseq = ? and seq = ? and BRANDCD = ? ";
                sql = sql.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (PickupDto list : contents) {
                    int i = 0;
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++i, list.getOrddt());
                    pstmt.setString(++i, list.getOrdseq());
                    pstmt.setString(++i, list.getSeq());
                    pstmt.setInt(++i, brandcd);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[ProductErrordataDelete]" + pstmt.toString());
                result = pstmt.executeBatch();
                pstmt.clearBatch();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<String> getNaverAddress(List<List<String>> contents, Shell shell, String exp) {
        ArrayList<String> list = new ArrayList<String>();
        ChromeExtention chrome = ChromeExtention.getInstace();
        ChromeDriver driver = null;
        try {
            try {
                driver = chrome.setFileDown(false).setHeadlessMode(false).getDriver();
                String URL2 = "https://search.naver.com/search.naver";
                driver.get(URL2);
                WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
                for (List<String> addr : contents) {
                    String addrerr = String.format("\uace0\uac1d\uba85 : %s ", addr.get(4));
                    try {
                        ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_query\"]")))).clear();
                        ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_query\"]")))).sendKeys(new CharSequence[]{addr.get(6)});
                        ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_search_form\"]/fieldset/button")))).click();
                        YDMAStringUtil.Print();
                        String address = ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"loc-main-section-root\"]/div/div/div[2]/div[2]/div/div[1]/div[1]")))).getText();
                        list.add(address);
                        YDMAProgressBar.get().setValue(String.valueOf(addrerr) + "\ub2d8\uc758 \uc8fc\uc18c[" + address + "] \ub97c \uac00\uc9c0\uace0 \uc654\uc2b5\ub2c8\ub2e4.", 0);
                    }
                    catch (Exception exception) {
                        YDMAProgressBar.get().setValue(String.valueOf(addrerr) + "\ub2d8\uc758 \uc8fc\uc18c\ub97c \uac00\uc9c0\uace0\uc624\ub294\ub370 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", 0);
                        list.add("\uc624\ub958");
                    }
                }
            }
            catch (Exception ex) {
                YDMAStringUtil.Print(ex.getMessage());
                driver.quit();
            }
        }
        finally {
            driver.quit();
        }
        return list;
    }

    public List<PickupDto> getNaverAddress2(List<PickupDto> contents, Shell shell, String exp) {
        ChromeExtention chrome = ChromeExtention.getInstace();
        ChromeDriver driver = null;
        try {
            try {
                driver = chrome.setFileDown(false).setHeadlessMode(false).getDriver();
                String URL2 = "https://search.naver.com/search.naver";
                driver.get(URL2);
                WebDriverWait wait = new WebDriverWait((WebDriver)driver, 10L);
                for (PickupDto addr : contents) {
                    String addrerr = String.format("\uace0\uac1d\uba85 : %s ", addr.getRcvnam());
                    try {
                        ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_query\"]")))).clear();
                        ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_query\"]")))).sendKeys(new CharSequence[]{addr.getAddr()});
                        ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"nx_search_form\"]/fieldset/button")))).click();
                        String address = ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"//*[@id=\"loc-main-section-root\"]/div/div/div[2]/div[2]/div/div[1]/div[1]")))).getText();
                        addr.setParam2(address);
                        YDMAProgressBar.get().setValue(String.valueOf(addrerr) + "\ub2d8\uc758 \uc8fc\uc18c[" + address + "] \ub97c \uac00\uc9c0\uace0 \uc654\uc2b5\ub2c8\ub2e4.", 0);
                    }
                    catch (Exception exception) {
                        YDMAProgressBar.get().setValue(String.valueOf(addrerr) + "\ub2d8\uc758 \uc8fc\uc18c\ub97c \uac00\uc9c0\uace0\uc624\ub294\ub370 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", 0);
                        addr.setParam2("\uc624\ub958");
                    }
                }
            }
            catch (Exception ex) {
                YDMAStringUtil.Print(ex.getMessage());
                driver.quit();
            }
        }
        finally {
            driver.quit();
        }
        return contents;
    }

    public int getPickupListMaxSeq(String orddt, String seq) throws Exception {
        int count = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT max(seq)  FROM pickupexp where compno = ? and orddt=? and ordseq=? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, orddt);
                pstmt.setString(3, seq);
                YDMAStringUtil.Print("[checkEcountSentOrder]" + pstmt.toString());
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getInt(1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return count + 1;
    }

    public List<List<String>> getPickupExpressCrawl(List<List<String>> contents, Shell shell, String exp) {
        ArrayList<List<String>> express = new ArrayList<List<String>>();
        int count = 1;
        try {
            try {
                OrderDao ordao = new OrderDao();
                List<String> expcd = ordao.getExpcd_Lott(exp);
                List<String> expidNpass = ordao.getDvlInfo(expcd.get(0));
                this.driver = this.chrome.setFileDown(false).setHeadlessMode(true).getDriver();
                String URL2 = expidNpass.get(1);
                WebDriverWait wait = new WebDriverWait((WebDriver)this.driver, 30L);
                ChromeScript.get().get(this.driver, URL2);
                Thread.sleep(1000L);
                try {
                    WebElement elementloginBox = this.driver.findElement(By.xpath((String)"/html/body/div[3]/div[2]"));
                    elementloginBox.findElement(By.xpath((String)"//*[@id=\"principal\"]/input")).sendKeys(new CharSequence[]{expidNpass.get(2)});
                    elementloginBox.findElement(By.xpath((String)"//*[@id=\"credential\"]/input")).sendKeys(new CharSequence[]{expidNpass.get(3)});
                    elementloginBox.findElement(By.xpath((String)"//*[@id=\"btn-login\"]")).click();
                }
                catch (Exception e) {
                    YDMAProgressBar.get().setValue("\ub85c\uadf8\uc778\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc2dc\ub3c4 \ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.", 0);
                    throw new Exception(e.getMessage());
                }
                wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]")));
                ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]/div[5]/i-button")))).click();
                Thread.sleep(1000L);
                ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[3]/div/div[2]/div[4]/div[1]/ul/li[1]/a")))).click();
                this.driver.switchTo().frame(this.driver.findElement(By.id((String)"workframe_21847")));
                int i = 0;
                while (i < contents.size()) {
                    try {
                        List<String> output = contents.get(i);
                        ArrayList<String> list = new ArrayList<String>();
                        ChromeScript.get().addScript("$('#cboSrchPrntSctCd').val('');").waitTiem(2000L).executeScripter(this.driver);
                        ChromeScript.get().addScript("$('#cboSrchCond').val('40');").waitTiem(2000L).executeScripter(this.driver);
                        ChromeScript.get().addScript(String.format("$('#edtSrchCondVal').val('%s'); ", output.get(7).equals("") ? output.get(8) : output.get(7))).waitTiem(2000L).executeScripter(this.driver);
                        ChromeScript.get().until((WebDriver)this.driver, () -> this.driver.findElementByCssSelector("body > div.container-fluid.frameArea > div.frameHeader > div.panelBox.searchBox.detailSearch > div.searchBtnGroup > i-button.funcBtn.ico.iconSearch.White.searchBtn")).click();
                        Thread.sleep(1000L);
                        try {
                            String invoice = ChromeScript.get().returnCallbackScripter("return grdRsrv.getRowData(0)[8];", this.driver);
                            if (invoice.equals("")) {
                                throw new Exception(String.valueOf(output.get(4)) + "\ub2d8\uc758 \uc1a1\uc7a5\ubc88\ud638\ub97c \uac00\uc9c0\uace0 \uc624\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                            }
                            YDMAStringUtil.Print(invoice);
                            list.add(output.get(0));
                            list.add(output.get(1));
                            list.add(output.get(2));
                            list.add(invoice);
                            list.add("Y");
                            express.add(list);
                            YDMAProgressBar.get().setValue(String.valueOf(output.get(4)) + "\ub2d8\uc758 \uc1a1\uc7a5\ubc88\ud638[" + invoice + "]\ub97c \uac00\uc9c0\uace0 \uc654\uc2b5\ub2c8\ub2e4.", count++);
                        }
                        catch (Exception exception) {
                            throw new Exception(String.valueOf(output.get(4)) + "\ub2d8\uc758 \ud734\ub300\ubc88\ud638\ub97c \uac80\uc0c9\ub41c \uac12\uc744 \ucc3e\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                        }
                    }
                    catch (Exception e) {
                        YDMAProgressBar.get().setValue(e.getMessage(), count++);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                YDMAStringUtil.Print(ex.getMessage());
                this.driver.quit();
            }
        }
        finally {
            this.driver.quit();
        }
        return express;
    }

    public List<List<String>> getPickupExpressCrawl2(List<PickupDto> contents, Shell shell, String exp) {
        ArrayList<List<String>> express = new ArrayList<List<String>>();
        int count = 1;
        try {
            try {
                OrderDao ordao = new OrderDao();
                List<String> expcd = ordao.getExpcd_Lott(exp);
                List<String> expidNpass = ordao.getDvlInfo(expcd.get(0));
                this.driver = this.chrome.setFileDown(false).setHeadlessMode(true).getDriver();
                String URL2 = expidNpass.get(1);
                WebDriverWait wait = new WebDriverWait((WebDriver)this.driver, 30L);
                ChromeScript.get().get(this.driver, URL2);
                Thread.sleep(1000L);
                try {
                    WebElement elementloginBox = this.driver.findElement(By.xpath((String)"/html/body/div[3]/div[2]"));
                    elementloginBox.findElement(By.xpath((String)"//*[@id=\"principal\"]/input")).sendKeys(new CharSequence[]{expidNpass.get(2)});
                    elementloginBox.findElement(By.xpath((String)"//*[@id=\"credential\"]/input")).sendKeys(new CharSequence[]{expidNpass.get(3)});
                    elementloginBox.findElement(By.xpath((String)"//*[@id=\"btn-login\"]")).click();
                }
                catch (Exception e) {
                    YDMAProgressBar.get().setValue("\ub85c\uadf8\uc778\uc2dc\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub2e4\uc2dc \uc2dc\ub3c4 \ud558\uc5ec \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.", 0);
                    throw new Exception(e.getMessage());
                }
                wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]")));
                ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[1]/div[5]/i-button")))).click();
                Thread.sleep(1000L);
                ((WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)By.xpath((String)"/html/body/div[3]/header/nav/div[3]/div/div[2]/div[4]/div[1]/ul/li[1]/a")))).click();
                this.driver.switchTo().frame(this.driver.findElement(By.id((String)"workframe_21847")));
                for (PickupDto content : contents) {
                    try {
                        ArrayList<String> list = new ArrayList<String>();
                        ChromeScript.get().addScript("$('#cboSrchPrntSctCd').val('');").waitTiem(2000L).executeScripter(this.driver);
                        ChromeScript.get().addScript("$('#cboSrchCond').val('40');").waitTiem(2000L).executeScripter(this.driver);
                        ChromeScript.get().addScript(String.format("$('#edtSrchCondVal').val('%s'); ", content.getClpno().equals("") ? content.getTelno() : content.getClpno())).waitTiem(2000L).executeScripter(this.driver);
                        ChromeScript.get().until((WebDriver)this.driver, () -> this.driver.findElementByCssSelector("body > div.container-fluid.frameArea > div.frameHeader > div.panelBox.searchBox.detailSearch > div.searchBtnGroup > i-button.funcBtn.ico.iconSearch.White.searchBtn")).click();
                        Thread.sleep(1000L);
                        try {
                            String invoice = ChromeScript.get().returnCallbackScripter("return grdRsrv.getRowData(0)[8];", this.driver);
                            if (invoice.equals("")) {
                                throw new Exception(String.valueOf(content.getRcvnam()) + "\ub2d8\uc758 \uc1a1\uc7a5\ubc88\ud638\ub97c \uac00\uc9c0\uace0 \uc624\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                            }
                            YDMAStringUtil.Print(invoice);
                            list.add(content.getOrddt());
                            list.add(content.getOrdseq());
                            list.add(content.getSeq());
                            list.add(invoice);
                            list.add("Y");
                            express.add(list);
                            YDMAProgressBar.get().setValue(String.valueOf(content.getRcvnam()) + "\ub2d8\uc758 \uc1a1\uc7a5\ubc88\ud638[" + invoice + "]\ub97c \uac00\uc9c0\uace0 \uc654\uc2b5\ub2c8\ub2e4.", count++);
                        }
                        catch (Exception exception) {
                            throw new Exception(String.valueOf(content.getRcvnam()) + "\ub2d8\uc758 \ud734\ub300\ubc88\ud638\ub97c \uac80\uc0c9\ub41c \uac12\uc744 \ucc3e\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                        }
                    }
                    catch (Exception e) {
                        YDMAProgressBar.get().setValue(e.getMessage(), count++);
                    }
                }
            }
            catch (Exception ex) {
                YDMAStringUtil.Print(ex.getMessage());
                this.driver.quit();
            }
        }
        finally {
            this.driver.quit();
        }
        return express;
    }

    public List<List<String>> getCategoryCodeSearch(String shopid) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT IFNULL(A.CODE,''),IFNULL(A.SHOPCD,''),IFNULL(A.SHOPCATNO,'') FROM CATEGLGMAP A WHERE A.compno = ? AND A.shopcd = ? UNION ALL  SELECT IFNULL(B.CODE,''),IFNULL(B.SHOPCD,''),IFNULL(B.SHOPCATNO,'') FROM CATEGMDMAP B WHERE B.compno = ? AND B.shopcd = ? UNION ALL  SELECT IFNULL(C.CODE,''),IFNULL(C.SHOPCD,''), IFNULL(C.SHOPCATNO,'') FROM CATEGSMMAP C WHERE C.compno = ? AND C.shopcd = ? UNION ALL  SELECT IFNULL(D.CODE,''),IFNULL(D.SHOPCD,'') ,IFNULL(D.SHOPCATNO,'') FROM CATEGDTLMAP D WHERE D.compno = ? AND D.shopcd = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopid);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(4, shopid);
                pstmt.setString(5, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(6, shopid);
                pstmt.setString(7, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(8, shopid);
                YDMAStringUtil.Print("[getShopMstSelectList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    ArrayList<String> list = new ArrayList<String>();
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<String> getShopCateInfo(String shopcd, String shopid, String catno) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ifnull(COMPNO,''),ifnull(SHOPCD,''),ifnull(SHOPCATNO,''),ifnull(SHOPCATNM,''),ifnull(SHOPLAGCATCD,''),ifnull(SHOPMIDCATCD,''),ifnull(SHOPSMLCATCD,''),ifnull(SHOPDETCATCD,''), ifnull(SERVICEPROD,''),ifnull(USE_YN,''),ifnull(SHOPGENERAL,'') ,ifnull(SHOPID,'')  FROM shopcatinf WHERE compno = ? and shopcd = ? and shopid = ? and SHOPCATNO = ?";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, shopcd);
                pstmt.setString(3, shopid);
                pstmt.setString(4, catno);
                YDMAStringUtil.Print("[getShopMstSelectList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public void removeGongyongFile(List<List<String>> search, int brandcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from pickupexp  where ordseq = ? AND Orddt = ? and compno = ? and expfile = '\uacf5\uc6a9' and BRANDCD = ? ";
                sql = sql.toUpperCase();
                YDMAStringUtil.Print(sql);
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                while (i < search.size()) {
                    pstmt.setString(1, search.get(0).get(1));
                    pstmt.setString(2, search.get(0).get(0));
                    pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(4, brandcd);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                YDMAStringUtil.Print("[removeGongyongFile]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void removeGongyongFile2(List<PickupDto> search, int brandcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "delete from pickupexp  where ordseq = ? AND Orddt = ? and compno = ? and expfile = '\uacf5\uc6a9' and BRANDCD = ? ";
                sql = sql.toUpperCase();
                YDMAStringUtil.Print(sql);
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (PickupDto dto : search) {
                    pstmt.setString(1, dto.getOrdseq());
                    pstmt.setString(2, dto.getOrddt());
                    pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(4, brandcd);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[removeGongyongFile]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void InsertGongyongFile(List<List<String>> search, int brandcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into pickupexp(COMPNO,ORDDT,ORDSEQ,SEQ,RORDDT,RCVNAM,PSTNO,ADDR,CLPNO,TELNO,QTY,SHPFEE,CREDIT,EXPPRODNM,MESSGE,PKGCLSS,SHIPCLS,SABORDNO,SHOPID,ORDNM,ETCMSG,MALLCD,ORDAMT, PRODCD,OPTDESC,EXPBUNDNM,BOXCNT,EXPFILE,EXPCD,FLAGSET,PRODCDM,EXPINVQTY,PRODNM,SPECDES,QTY2,RACKNM,OPTPRODCD,EXPINNER,EXPCOSTNM,EXPNM,INVNO,EXPSENDDT,EXPRECVDT,BRANDCD)  values(?, ?, ? ,? ,? ,? ,? ,? ,? ,? ,? , ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? , ?, ? , ?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                int i = 0;
                while (i < search.size()) {
                    int k = 0;
                    int idx = 0;
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setString(++idx, search.get(i).get(k++));
                    pstmt.setInt(++idx, brandcd);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++i;
                }
                YDMAStringUtil.Print("[InsertGongyongFile]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void InsertGongyongFile2(List<PickupDto> search, int brandcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "insert into pickupexp(COMPNO,ORDDT,ORDSEQ,SEQ,RORDDT,RCVNAM,PSTNO,ADDR,CLPNO,TELNO,QTY,SHPFEE,CREDIT,EXPPRODNM,MESSGE,PKGCLSS,SHIPCLS,SABORDNO,SHOPID,ORDNM,ETCMSG,MALLCD,ORDAMT, PRODCD,OPTDESC,EXPBUNDNM,BOXCNT,EXPFILE,EXPCD,FLAGSET,PRODCDM,EXPINVQTY,PRODNM,SPECDES,QTY2,RACKNM,OPTPRODCD,EXPINNER,EXPCOSTNM,EXPNM,INVNO,EXPSENDDT,EXPRECVDT,BRANDCD)  values(?, ?, ? ,? ,? ,? ,? ,? ,? ,? ,? , ? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? ,? , ?, ? , ?)";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (PickupDto dto : search) {
                    int idx = 0;
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++idx, dto.getOrddt());
                    pstmt.setString(++idx, dto.getOrdseq());
                    pstmt.setString(++idx, dto.getSeq());
                    pstmt.setString(++idx, dto.getRorddt());
                    pstmt.setString(++idx, dto.getRcvnam());
                    pstmt.setString(++idx, dto.getPstno());
                    pstmt.setString(++idx, dto.getAddr());
                    pstmt.setString(++idx, dto.getClpno());
                    pstmt.setString(++idx, dto.getTelno());
                    pstmt.setString(++idx, dto.getQty());
                    pstmt.setString(++idx, dto.getShpfee());
                    pstmt.setString(++idx, dto.getCredit());
                    pstmt.setString(++idx, dto.getExpprodnm());
                    pstmt.setString(++idx, dto.getMessge());
                    pstmt.setString(++idx, dto.getPkgclss());
                    pstmt.setString(++idx, dto.getShipcls());
                    pstmt.setString(++idx, dto.getSabordno());
                    pstmt.setString(++idx, dto.getShopid());
                    pstmt.setString(++idx, dto.getOrdnm());
                    pstmt.setString(++idx, dto.getEtcmsg());
                    pstmt.setString(++idx, dto.getMallcd());
                    pstmt.setString(++idx, dto.getOrdamt());
                    pstmt.setString(++idx, dto.getProdcd());
                    pstmt.setString(++idx, dto.getOptdesc());
                    pstmt.setString(++idx, dto.getExpbundnm());
                    pstmt.setString(++idx, dto.getBoxcnt());
                    pstmt.setString(++idx, dto.getExpfile());
                    pstmt.setString(++idx, dto.getExpcd());
                    pstmt.setString(++idx, dto.getFlagset());
                    pstmt.setString(++idx, dto.getProdcdm());
                    pstmt.setString(++idx, dto.getExpinvqty());
                    pstmt.setString(++idx, dto.getProdnm());
                    pstmt.setString(++idx, dto.getSpecdes());
                    pstmt.setString(++idx, dto.getQty2());
                    pstmt.setString(++idx, dto.getRacknm());
                    pstmt.setString(++idx, dto.getOptprodcd());
                    pstmt.setString(++idx, dto.getExpinner());
                    pstmt.setString(++idx, dto.getExpcostnm());
                    pstmt.setString(++idx, dto.getExpnm());
                    pstmt.setString(++idx, dto.getInvno());
                    pstmt.setString(++idx, dto.getExpsenddt());
                    pstmt.setString(++idx, dto.getExprecvdt());
                    pstmt.setInt(++idx, brandcd);
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[InsertGongyongFile]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void setExpressPrice(List<List<String>> changeprice, int brandcd) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set CREDIT=? where orddt=? and ordseq = ? and seq = ? and compno = ? and BRANDCD = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : changeprice) {
                        int i = 0;
                        pstmt.setString(++i, list.get(11));
                        pstmt.setString(++i, list.get(0));
                        pstmt.setString(++i, list.get(1));
                        pstmt.setString(++i, list.get(2));
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setMoveList]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setExpressPrice2(List<PickupDto> changeprice, int brandcd) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set CREDIT=? where orddt=? and ordseq = ? and seq = ? and compno = ? and BRANDCD = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (PickupDto list : changeprice) {
                        int i = 0;
                        pstmt.setString(++i, list.getCredit());
                        pstmt.setString(++i, list.getOrddt());
                        pstmt.setString(++i, list.getOrdseq());
                        pstmt.setString(++i, list.getSeq());
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setMoveList]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setDaesinHapPojang(List<String> list, int brandcd) throws Exception {
        block5: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set QTY = ?, SHPFEE = ?, EXPPRODNM = ? where ORDDT = ? and ORDSEQ =? and seq = ? and compno = ? and brandcd = ?  ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int i = 0;
                    pstmt.setString(++i, list.get(9));
                    pstmt.setString(++i, list.get(10));
                    pstmt.setString(++i, list.get(12));
                    pstmt.setString(++i, list.get(0));
                    pstmt.setString(++i, list.get(1));
                    pstmt.setString(++i, list.get(2));
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++i, brandcd);
                    pstmt.executeUpdate();
                    YDMAStringUtil.Print("[getPickupExpressInvnoUpdate]" + pstmt.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setDaesinHapPojang2(PickupDto list, int brandcd) throws Exception {
        block5: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set QTY = ?, SHPFEE = ?, EXPPRODNM = ? where ORDDT = ? and ORDSEQ =? and seq = ? and compno = ? and brandcd = ?  ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int i = 0;
                    pstmt.setString(++i, list.getQty());
                    pstmt.setString(++i, list.getShpfee());
                    pstmt.setString(++i, list.getExpprodnm());
                    pstmt.setString(++i, list.getOrddt());
                    pstmt.setString(++i, list.getOrdseq());
                    pstmt.setString(++i, list.getSeq());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++i, brandcd);
                    pstmt.executeUpdate();
                    YDMAStringUtil.Print("[getPickupExpressInvnoUpdate]" + pstmt.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public List<List<String>> sendPickupHanjinExpress(List<List<String>> cloneContents, String orddt, List<String> comlist) {
        ArrayList<List<String>> contents;
        block41: {
            Statement cstmt;
            ResultSet rs;
            block43: {
                contents = new ArrayList<List<String>>();
                String driver = "oracle.jdbc.driver.OracleDriver";
                String url = "jdbc:oracle:thin:@ebbeip.hjt.co.kr:1531:HDDWEB";
                String user = "YUYOUNG";
                String password = "YUYOUNG2001";
                Connection con = null;
                rs = null;
                cstmt = null;
                try {
                    Class.forName(driver);
                    YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc131\uacf5");
                    con = DriverManager.getConnection(url, user, password);
                    for (List<String> list : cloneContents) {
                        String ordnum = String.valueOf(list.get(0)) + list.get(1) + list.get(2);
                        String box = this.getBoxCode(list.get(10));
                        cstmt = con.prepareCall("{call INSERT_CST_ORD_MTR_MM(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
                        cstmt.setString(1, "YUYOUNG");
                        cstmt.setString(2, ordnum);
                        cstmt.setString(3, "");
                        cstmt.setString(4, "F");
                        cstmt.setString(5, "9127150");
                        cstmt.setString(6, YDMATimeUtil.getCurrentDateHanjin());
                        cstmt.setString(7, comlist.get(13));
                        cstmt.setString(8, comlist.get(14));
                        cstmt.setString(9, "");
                        cstmt.setString(10, comlist.get(1));
                        cstmt.setString(11, this.splitMark(comlist.get(17)));
                        cstmt.setString(12, this.splitMark(comlist.get(18)));
                        cstmt.setString(13, "");
                        cstmt.setString(14, list.get(5));
                        cstmt.setString(15, list.get(6));
                        cstmt.setString(16, "");
                        cstmt.setString(17, list.get(4));
                        cstmt.setString(18, this.splitMark(list.get(7).equals("") ? list.get(8) : list.get(7)));
                        cstmt.setString(19, this.splitMark(list.get(7).equals("") ? list.get(8) : list.get(7)));
                        cstmt.setString(20, "");
                        cstmt.setString(21, list.get(13));
                        cstmt.setString(22, list.get(12));
                        cstmt.setInt(23, Integer.parseInt(list.get(9)));
                        cstmt.setString(24, list.get(11).equals("\ucc29\ubd88") ? "CC" : "CD");
                        cstmt.setString(25, box);
                        cstmt.setString(26, "");
                        cstmt.setString(27, "");
                        cstmt.setString(28, "");
                        cstmt.setString(29, "");
                        cstmt.registerOutParameter(30, 12);
                        cstmt.registerOutParameter(31, 12);
                        cstmt.registerOutParameter(32, 12);
                        cstmt.execute();
                        list.add(0, cstmt.getString(30));
                        list.add(1, cstmt.getString(31));
                        list.add(2, cstmt.getString(32));
                        contents.add(list);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc2e4\ud328");
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (cstmt != null) {
                        try {
                            cstmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block41;
                }
                catch (SQLException e) {
                    block42: {
                        try {
                            e.printStackTrace();
                            YDMAStringUtil.Print("\uc624\ub77c\ud074 \uc5f0\uacb0 \uc2e4\ud328");
                            if (con == null) break block42;
                        }
                        catch (Throwable throwable) {
                            if (con != null) {
                                try {
                                    con.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (cstmt != null) {
                                try {
                                    cstmt.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                            }
                            throw throwable;
                        }
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (cstmt != null) {
                        try {
                            cstmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block41;
                }
                if (con == null) break block43;
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return contents;
    }

    public List<PickupDto> sendPickupHanjinExpress2(List<PickupDto> cloneContents, String orddt, List<String> comlist) {
        ArrayList<PickupDto> contents;
        block41: {
            Statement cstmt;
            ResultSet rs;
            block43: {
                contents = new ArrayList<PickupDto>();
                String driver = "oracle.jdbc.driver.OracleDriver";
                String url = "jdbc:oracle:thin:@ebbeip.hjt.co.kr:1531:HDDWEB";
                String user = "YUYOUNG";
                String password = "YUYOUNG2001";
                Connection con = null;
                rs = null;
                cstmt = null;
                try {
                    Class.forName(driver);
                    YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc131\uacf5");
                    con = DriverManager.getConnection(url, user, password);
                    for (PickupDto list : cloneContents) {
                        String ordnum = "";
                        ordnum = list.getOrddt() == null ? list.getEtc() : String.valueOf(list.getOrddt()) + list.getOrdseq() + list.getSeq();
                        String box = this.getBoxCode(list.getShpfee());
                        cstmt = con.prepareCall("{call INSERT_CST_ORD_MTR_MM(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
                        cstmt.setString(1, "YUYOUNG");
                        cstmt.setString(2, ordnum);
                        cstmt.setString(3, "");
                        cstmt.setString(4, "F");
                        cstmt.setString(5, "9127150");
                        cstmt.setString(6, YDMATimeUtil.getCurrentDateHanjin());
                        cstmt.setString(7, comlist.get(13));
                        cstmt.setString(8, comlist.get(14));
                        cstmt.setString(9, "");
                        cstmt.setString(10, comlist.get(1));
                        cstmt.setString(11, this.splitMark(comlist.get(17)));
                        cstmt.setString(12, this.splitMark(comlist.get(18)));
                        cstmt.setString(13, "");
                        cstmt.setString(14, list.getPstno());
                        cstmt.setString(15, list.getAddr());
                        cstmt.setString(16, "");
                        cstmt.setString(17, list.getRcvnam());
                        cstmt.setString(18, this.splitMark(list.getClpno().equals("") ? list.getTelno() : list.getClpno()));
                        cstmt.setString(19, this.splitMark(list.getClpno().equals("") ? list.getTelno() : list.getClpno()));
                        cstmt.setString(20, "");
                        cstmt.setString(21, list.getMessge());
                        cstmt.setString(22, list.getExpprodnm());
                        cstmt.setInt(23, Integer.parseInt(list.getQty()));
                        cstmt.setString(24, list.getCredit().equals("\ucc29\ubd88") ? "CC" : "CD");
                        cstmt.setString(25, box);
                        cstmt.setString(26, "");
                        cstmt.setString(27, "");
                        cstmt.setString(28, "");
                        cstmt.setString(29, "");
                        cstmt.registerOutParameter(30, 12);
                        cstmt.registerOutParameter(31, 12);
                        cstmt.registerOutParameter(32, 12);
                        cstmt.execute();
                        list.setParam1(cstmt.getString(30));
                        list.setParam2(cstmt.getString(31));
                        list.setParam3(cstmt.getString(32));
                        contents.add(list);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc2e4\ud328");
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (cstmt != null) {
                        try {
                            cstmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block41;
                }
                catch (SQLException e) {
                    block42: {
                        try {
                            e.printStackTrace();
                            YDMAStringUtil.Print("\uc624\ub77c\ud074 \uc5f0\uacb0 \uc2e4\ud328");
                            if (con == null) break block42;
                        }
                        catch (Throwable throwable) {
                            if (con != null) {
                                try {
                                    con.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (cstmt != null) {
                                try {
                                    cstmt.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                            }
                            throw throwable;
                        }
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (cstmt != null) {
                        try {
                            cstmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block41;
                }
                if (con == null) break block43;
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return contents;
    }

    public List<PickupDto> sendPickupHanjinExpress2(List<PickupDto> cloneContents, String orddt, List<String> comlist, String userid, String userpw) {
        ArrayList<PickupDto> contents;
        block41: {
            Statement cstmt;
            ResultSet rs;
            block43: {
                contents = new ArrayList<PickupDto>();
                String driver = "oracle.jdbc.driver.OracleDriver";
                String url = "jdbc:oracle:thin:@ebbeip.hjt.co.kr:1531:HDDWEB";
                String user = userid;
                String password = userpw;
                Connection con = null;
                rs = null;
                cstmt = null;
                try {
                    Class.forName(driver);
                    YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc131\uacf5");
                    con = DriverManager.getConnection(url, user, password);
                    for (PickupDto list : cloneContents) {
                        String ordnum = "";
                        ordnum = list.getOrddt() == null ? list.getEtc() : String.valueOf(list.getOrddt()) + list.getOrdseq() + list.getSeq();
                        String box = this.getBoxCode(list.getShpfee());
                        cstmt = con.prepareCall("{call INSERT_CST_ORD_MTR_MM(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
                        cstmt.setString(1, "YUYOUNG");
                        cstmt.setString(2, ordnum);
                        cstmt.setString(3, "");
                        cstmt.setString(4, "F");
                        cstmt.setString(5, "9127150");
                        cstmt.setString(6, YDMATimeUtil.getCurrentDateHanjin());
                        cstmt.setString(7, comlist.get(13));
                        cstmt.setString(8, comlist.get(14));
                        cstmt.setString(9, "");
                        cstmt.setString(10, comlist.get(1));
                        cstmt.setString(11, this.splitMark(comlist.get(17)));
                        cstmt.setString(12, this.splitMark(comlist.get(18)));
                        cstmt.setString(13, "");
                        cstmt.setString(14, list.getPstno());
                        cstmt.setString(15, list.getAddr());
                        cstmt.setString(16, "");
                        cstmt.setString(17, list.getRcvnam());
                        cstmt.setString(18, this.splitMark(list.getClpno().equals("") ? list.getTelno() : list.getClpno()));
                        cstmt.setString(19, this.splitMark(list.getClpno().equals("") ? list.getTelno() : list.getClpno()));
                        cstmt.setString(20, "");
                        cstmt.setString(21, list.getMessge());
                        cstmt.setString(22, list.getExpprodnm());
                        cstmt.setInt(23, Integer.parseInt(list.getQty()));
                        cstmt.setString(24, list.getCredit().equals("\ucc29\ubd88") ? "CC" : "CD");
                        cstmt.setString(25, box);
                        cstmt.setString(26, "");
                        cstmt.setString(27, "");
                        cstmt.setString(28, "");
                        cstmt.setString(29, "");
                        cstmt.registerOutParameter(30, 12);
                        cstmt.registerOutParameter(31, 12);
                        cstmt.registerOutParameter(32, 12);
                        cstmt.execute();
                        list.setParam1(cstmt.getString(30));
                        list.setParam2(cstmt.getString(31));
                        list.setParam3(cstmt.getString(32));
                        contents.add(list);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc2e4\ud328");
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (cstmt != null) {
                        try {
                            cstmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block41;
                }
                catch (SQLException e) {
                    block42: {
                        try {
                            e.printStackTrace();
                            YDMAStringUtil.Print("\uc624\ub77c\ud074 \uc5f0\uacb0 \uc2e4\ud328");
                            if (con == null) break block42;
                        }
                        catch (Throwable throwable) {
                            if (con != null) {
                                try {
                                    con.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (cstmt != null) {
                                try {
                                    cstmt.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                            }
                            throw throwable;
                        }
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (cstmt != null) {
                        try {
                            cstmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block41;
                }
                if (con == null) break block43;
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
            if (cstmt != null) {
                try {
                    cstmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return contents;
    }

    public String getBoxCode(String delvcost) {
        String code = "";
        switch (delvcost) {
            case "2500": {
                code = "A";
                break;
            }
            case "3000": {
                code = "B";
                break;
            }
            case "4000": {
                code = "C";
                break;
            }
            case "5000": {
                code = "D";
                break;
            }
            default: {
                code = "";
            }
        }
        return code;
    }

    public List<List<String>> getHanjinInvoiceNo() {
        ArrayList<List<String>> contents_tarket;
        block41: {
            Statement stmt;
            ResultSet rs;
            block43: {
                contents_tarket = new ArrayList<List<String>>();
                String driver = "oracle.jdbc.driver.OracleDriver";
                String url = "jdbc:oracle:thin:@211.210.94.2:1531:HDDWEB";
                String user = "YUYOUNG";
                String password = "YUYOUNG2001";
                String sql = "select * from cst_pod_mtr_vw";
                sql = sql.toUpperCase();
                Connection con = null;
                rs = null;
                stmt = null;
                try {
                    Class.forName(driver);
                    YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc131\uacf5");
                    con = DriverManager.getConnection(url, user, password);
                    stmt = con.createStatement();
                    rs = stmt.executeQuery(sql);
                    while (rs.next()) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.add(rs.getString(1));
                        list.add(this.JobStats(rs.getString(2) == null ? "" : rs.getString(2)));
                        list.add(rs.getString(3));
                        list.add(rs.getString(4));
                        list.add(rs.getString(5));
                        list.add(this.Rgtymd(rs.getString(2) == null ? "" : rs.getString(2), rs.getString(6) == null ? "" : rs.getString(6)));
                        list.add(rs.getString(7));
                        list.add(rs.getString(8));
                        list.add(rs.getString(9));
                        list.add(rs.getString(10));
                        list.add(rs.getString(11));
                        contents_tarket.add(list);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    YDMAStringUtil.Print("jdbc driver \ub85c\ub529 \uc2e4\ud328");
                    if (con != null) {
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block41;
                }
                catch (SQLException e) {
                    block42: {
                        try {
                            e.printStackTrace();
                            YDMAStringUtil.Print("\uc624\ub77c\ud074 \uc5f0\uacb0 \uc2e4\ud328");
                            if (con == null) break block42;
                        }
                        catch (Throwable throwable) {
                            if (con != null) {
                                try {
                                    con.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (stmt != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Exception exception) {}
                            }
                            if (rs != null) {
                                try {
                                    rs.close();
                                }
                                catch (Exception exception) {}
                            }
                            throw throwable;
                        }
                        try {
                            con.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block41;
                }
                if (con == null) break block43;
                try {
                    con.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
        }
        return contents_tarket;
    }

    private String Rgtymd(String code, String string) {
        String stats;
        block67: {
            block65: {
                stats = "";
                if (!code.equals("92")) break block65;
                switch (string) {
                    case "01": {
                        stats = "\uc218\ucde8 \uac70\ubd80";
                        break;
                    }
                    case "02": {
                        stats = "\uc218\ud558\uc778 \uc774\uc0ac";
                        break;
                    }
                    case "03": {
                        stats = "\uc545\ucc9c\ud6c4";
                        break;
                    }
                    case "04": {
                        stats = "\uc218\ud558\uc778 \uc8fc\uc18c \ubd80\uc815\ud655";
                        break;
                    }
                    case "05": {
                        stats = "\uace0\uac1d\ubd80\uc7ac";
                        break;
                    }
                    case "06": {
                        stats = "\uc1a1\ud558\uc778 \uc694\uccad";
                        break;
                    }
                }
                break block67;
            }
            switch (string) {
                case "01": {
                    stats = "\uc1a1\ud558\uc778 \ubd80\uc7ac";
                    break;
                }
                case "02": {
                    stats = "\ud654\ubb3c\ubbf8\uc900\ube44 \ubc0f \uc7ac\uace0 \ubd80\uc871";
                    break;
                }
                case "03": {
                    stats = "\ucde8\uae09\ubd88\uac00 \ud654\ubb3c";
                    break;
                }
                case "04": {
                    stats = "\uc1a1\ud558\uc778 \ubc1c\uc1a1\ucde8\uc18c";
                    break;
                }
                case "05": {
                    stats = "\uace0\uac1d\ubd84\uc2e4";
                    break;
                }
                case "06": {
                    stats = "\uae30 \uc9d1\ud558";
                    break;
                }
                case "07": {
                    stats = "\uace0\uac1d \ud30c\uc190";
                    break;
                }
                case "08": {
                    stats = "\ud0c0\uc778 \uc591\ub3c4";
                    break;
                }
                case "09": {
                    stats = "\ubc30\uc1a1\ubd88\uac00";
                    break;
                }
                case "10": {
                    stats = "\ubc30\uc1a1\ubd88\uac00";
                    break;
                }
                case "11": {
                    stats = "\ubc30\uc1a1\ubd88\uac00";
                    break;
                }
                case "12": {
                    stats = "\ubc30\uc1a1\ubd88\uac00";
                    break;
                }
                case "99": {
                    stats = "\ubc30\uc1a1\ubd88\uac00";
                    break;
                }
            }
        }
        return stats;
    }

    private String JobStats(String string) {
        String stats = "";
        switch (string) {
            case "03": {
                stats = "\uc608\uc57d\ucde8\uc18c";
                break;
            }
            case "10": {
                stats = "\uc6b4\uc1a1\uc7a5 \ub4f1\ub85d";
                break;
            }
            case "20": {
                stats = "\uc9d1\ud558\uc644\ub8cc";
                break;
            }
            case "30": {
                stats = "\ubc30\uc1a1\uc644\ub8cc";
                break;
            }
            case "08": {
                stats = "\ubbf8\uc9d1\ud558";
                break;
            }
            case "92": {
                stats = "\ubc30\uc1a1\ubd88\uac00";
                break;
            }
        }
        return stats;
    }

    public List<List<String>> sendPickupKyungdongExpress(List<List<String>> cloneContents, String orddt, List<String> comlist) {
        ArrayList<List<String>> responContents = new ArrayList<List<String>>();
        try {
            String url = "https://kdapi.kditlab.com/v1/Send2";
            int i = 0;
            while (i < cloneContents.size()) {
                URL obj = new URL(url);
                HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
                httpConnection.setRequestMethod("POST");
                httpConnection.setRequestProperty("Content-Type", "application/json");
                httpConnection.setRequestProperty("Accept-Charset", "UTF-8");
                httpConnection.setDoOutput(true);
                JsonObject object = new JsonObject();
                JsonArray jsonarray = new JsonArray();
                object.addProperty("API_KEY", "93DA0E4789FA431F97BC60D1743D6510");
                object.addProperty("BR_END_NM", "");
                object.addProperty("COM_NM", "");
                object.addProperty("RECV_NM", cloneContents.get(i).get(4));
                object.addProperty("RECV_TEL1", cloneContents.get(i).get(7).equals("") ? cloneContents.get(i).get(8) : cloneContents.get(i).get(7));
                object.addProperty("RECV_TEL2", "");
                object.addProperty("RECV_ZIPCODE", cloneContents.get(i).get(5));
                String addr3 = "";
                String addr4 = "";
                byte[] strByte = cloneContents.get(i).get(6).getBytes();
                int totLen = strByte.length;
                int middel_Len = totLen - 63;
                if (totLen > 59) {
                    addr3 = YDMAStringUtil.setTextStrtok(cloneContents.get(i).get(6), 59);
                    if (totLen - 60 > 63) {
                        middel_Len = totLen - 63;
                        addr4 = new String(strByte, middel_Len, totLen - middel_Len);
                    } else if (totLen - 60 <= 63) {
                        middel_Len = 59;
                        addr4 = new String(strByte, middel_Len, totLen - middel_Len);
                    }
                } else {
                    addr3 = cloneContents.get(i).get(6);
                }
                object.addProperty("RECV_ADDR1", addr3);
                object.addProperty("RECV_ADDR2", addr4);
                object.addProperty("SEND_NM", comlist.get(1));
                object.addProperty("SEND_TEL1", comlist.get(17));
                object.addProperty("SEND_TEL2", "");
                object.addProperty("SEND_ZIPCODE", comlist.get(13));
                object.addProperty("SEND_ADDR1", comlist.get(14));
                object.addProperty("SEND_ADDR2", "");
                object.addProperty("PD_CNT", cloneContents.get(i).get(9));
                object.addProperty("PD_DELI_GUBUN", cloneContents.get(i).get(11).equals("\ucc29\ubd88") ? "\ucc29\ud0dd" : "\ud604\ud0dd");
                object.addProperty("PD_DELI_PAY", (Number)(Integer.parseInt(cloneContents.get(i).get(9)) * Integer.parseInt(cloneContents.get(i).get(10))));
                object.addProperty("PD_INSURANCE_PAY", (Number)100);
                object.addProperty("PD_MEMO", cloneContents.get(i).get(13));
                String prodnm = "";
                if (cloneContents.get(i).get(12).length() > 50) {
                    strByte = cloneContents.get(i).get(12).getBytes();
                    prodnm = new String(strByte, 0, 50);
                } else {
                    prodnm = cloneContents.get(i).get(12);
                }
                object.addProperty("PD_NM", prodnm);
                object.addProperty("PD_PACK", "\ubc15\uc2a4");
                int maxcnt = Integer.parseInt(cloneContents.get(i).get(9));
                String pdprice = "";
                int cnt = 0;
                while (cnt < maxcnt) {
                    pdprice = String.valueOf(pdprice) + "30|";
                    ++cnt;
                }
                object.addProperty("PD_PRICE", pdprice);
                YDMAStringUtil.Print(pdprice);
                jsonarray.add((JsonElement)object);
                YDMAStringUtil.Print(jsonarray.toString());
                DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
                out.write(jsonarray.toString().getBytes("UTF-8"));
                out.flush();
                out.close();
                int responseCode = httpConnection.getResponseCode();
                YDMAStringUtil.Print("\ud0dd\ubc30\uc0ac\uc1a1\uc7a5\uc218\uc2e0: " + responseCode);
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
                String inputLine = null;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                YDMAStringUtil.Print(response.toString());
                String xml = response.toString();
                if (xml != null) {
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    factory.setNamespaceAware(true);
                    InputSource is = new InputSource(new StringReader(response.toString()));
                    Document document = builder.parse(is);
                    NodeList nList = document.getElementsByTagName("Response");
                    int j = 0;
                    while (j < nList.getLength()) {
                        Node nNode = nList.item(j);
                        ArrayList<String> list = new ArrayList<String>();
                        if (nNode.getNodeType() == 1) {
                            Element eElement = (Element)nNode;
                            int idx = 0;
                            list.add(idx++, cloneContents.get(i).get(0));
                            list.add(idx++, cloneContents.get(i).get(1));
                            list.add(idx++, cloneContents.get(i).get(2));
                            String statuscode = PickupExpressAPIDao.getTagValue("CODE", eElement);
                            list.add(idx++, statuscode);
                            list.add(idx++, this.KyunddongJobStats(statuscode));
                            list.add(idx++, PickupExpressAPIDao.getTagValue("PD_BARCODE", eElement));
                        }
                        responContents.add(list);
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public List<String> sendPickupKyungdongExpress33(List<String> cloneContents, String orddt, List<String> comlist) {
        ArrayList<String> responContents = new ArrayList<String>();
        ProductMstDao dao = new ProductMstDao();
        try {
            String prodnm;
            String json = "";
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            listMain group = new listMain();
            List<String> prodlist = dao.getProductMstKyungdong(cloneContents.get(29));
            String string = prodnm = prodlist.get(1).equals("") ? prodlist.get(0) : prodlist.get(0).concat(" ").concat(prodlist.get(1));
            if (Integer.parseInt(prodlist.get(3)) == 0) {
                int idx = 0;
                responContents.add(idx++, "");
                responContents.add(idx++, "");
                responContents.add(idx++, cloneContents.get(29).concat(" ").concat(prodnm));
                responContents.add(idx++, "N");
                responContents.add(idx++, "\uacc4\uc57d\ub41c \ud488\ubaa9\uc774 \uc544\ub2d8\ub2c8\ub2e4.");
                return responContents;
            }
            int maxcnt = Integer.parseInt(cloneContents.get(9));
            int cnt = 0;
            while (cnt < maxcnt) {
                ListValue value = new ListValue();
                value.domeOverType = "D";
                value.isDealItem = "Y";
                value.prodCode = null;
                value.prodRegNo = String.format("%s-%s-%s-%s", cloneContents.get(0).substring(4), cloneContents.get(1), cloneContents.get(2), Integer.toString(cnt));
                value.prodName = prodnm;
                value.prodMemo = cloneContents.get(13);
                value.wrapStatus = "\ubc15\uc2a4";
                value.calcType = "0001";
                value.width = Integer.parseInt(prodlist.get(2));
                value.vertical = Integer.parseInt(prodlist.get(3));
                value.height = Integer.parseInt(prodlist.get(4));
                value.weight = Integer.parseInt(prodlist.get(5));
                value.custSndrNo = "C310006623";
                value.price = 50;
                value.count = null;
                value.branSndnCode = null;
                value.branArvlCode = null;
                value.custSndrName = comlist.get(1);
                value.custSndrTelno = comlist.get(17);
                value.custSndrEtcTelno = null;
                value.custSndrZip = comlist.get(13);
                value.custSndrAddr = comlist.get(14);
                value.custSndrDaddr = null;
                value.custRcvrName = cloneContents.get(4);
                value.custRcvrTelno = cloneContents.get(7).equals("") ? cloneContents.get(8) : cloneContents.get(7);
                value.custRcvrEtcTelno = null;
                value.custRcvrZip = cloneContents.get(5);
                String addr3 = "";
                String addr4 = "";
                byte[] strByte = cloneContents.get(6).getBytes();
                int totLen = strByte.length;
                int middel_Len = totLen - 63;
                if (totLen > 59) {
                    addr3 = YDMAStringUtil.setTextStrtok(cloneContents.get(6), 59);
                    if (totLen - 60 > 63) {
                        middel_Len = totLen - 63;
                        addr4 = new String(strByte, middel_Len, totLen - middel_Len);
                    } else if (totLen - 60 <= 63) {
                        middel_Len = 59;
                        addr4 = new String(strByte, middel_Len, totLen - middel_Len);
                    }
                } else {
                    addr3 = cloneContents.get(6);
                }
                value.custRcvrAddr = addr3;
                value.custRcvrDaddr = addr4;
                value.etcPay = 0;
                value.otherPay = 0;
                value.payType = cloneContents.get(11).equals("\ucc29\ubd88") ? "0002" : "0001";
                group.list.add(value);
                ++cnt;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)group);
            String Host = "https://ong-api.kdexp.com:443/api/v1";
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/express/receipts")).method("PUT", body).addHeader("Content-Type", "application/json;charset=UTF-8").addHeader("X-AUTH-SECRET-KEY", "GGU/afCtgb9MT5jQK7wuW2C3iMFo7l3iiU7ULecTIV++GXjwzYW3p/gGjW5m/Aa+qb8uhF4kzmonBmJnxm6imtVHVN1Ug/lsHUYpx0njFtbZrtat5T66Kr5TcY7NerDKvxff2/syx3P5yMTLZS0hVw==").addHeader("Accept", "application/json").addHeader("application", "json").build();
            String data2 = "";
            Throwable middel_Len = null;
            Object var19_25 = null;
            try (Response response = client.newCall(request2).execute();){
                data2 = response.body().string();
            }
            catch (Throwable throwable) {
                if (middel_Len == null) {
                    middel_Len = throwable;
                } else if (middel_Len != throwable) {
                    middel_Len.addSuppressed(throwable);
                }
                throw middel_Len;
            }
            group.list.size();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
            String code = jsonObject.get("code").getAsString();
            if (code.equals("API_PRC_S000")) {
                JsonObject value = (JsonObject)jsonObject.get("data");
                int j = 0;
                while (j < value.get("list").getAsJsonArray().size()) {
                    JsonObject valueLst = value.get("list").getAsJsonArray().get(j).getAsJsonObject();
                    String result = valueLst.get("result").getAsString();
                    String message = valueLst.get("message").getAsString();
                    if (result.equals("Y")) {
                        String orderNos = valueLst.get("content").getAsJsonObject().get("prodRegNo").getAsString();
                        String[] orderNo = orderNos.split("-");
                        if (orderNo[3].equals("0")) {
                            int idx = 0;
                            responContents.add(idx++, cloneContents.get(0).substring(0, 4).concat(orderNo[0]));
                            responContents.add(idx++, orderNo[1]);
                            responContents.add(idx++, orderNo[2]);
                            responContents.add(idx++, result);
                            responContents.add(idx++, this.KyunddongJobStats(result));
                            responContents.add(idx++, valueLst.get("content").getAsJsonObject().get("prodCode").getAsString());
                            String strDevPay = valueLst.get("content").getAsJsonObject().get("fare").getAsJsonObject().get("deliTotalPay").getAsString();
                            int intDevPay = Integer.parseInt(strDevPay) * maxcnt;
                            responContents.add(idx++, Integer.toString(intDevPay));
                        }
                    } else {
                        int idx = 0;
                        responContents.add(idx++, "");
                        responContents.add(idx++, "");
                        responContents.add(idx++, cloneContents.get(29).concat(" ").concat(prodnm));
                        responContents.add(idx++, result);
                        responContents.add(idx++, message);
                    }
                    ++j;
                }
            } else {
                int idx = 0;
                responContents.add(idx++, "");
                responContents.add(idx++, "");
                responContents.add(idx++, cloneContents.get(29).concat(" ").concat(prodnm));
                responContents.add(idx++, code);
                responContents.add(idx++, this.KyunddongJobStats(code));
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public List<List<String>> sendPickupKyungdongExpress22(List<List<String>> cloneContents, String orddt, List<String> comlist) {
        ArrayList<List<String>> responContents = new ArrayList<List<String>>();
        ProductMstDao dao = new ProductMstDao();
        try {
            String addr52;
            Object addr3;
            String json = "";
            ObjectMapper mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            listMain group = new listMain();
            int i = 0;
            while (i < cloneContents.size()) {
                String prodnm;
                List<String> list = dao.getProductMstKyungdong(cloneContents.get(i).get(29));
                String string = prodnm = list.get(1).equals("") ? list.get(0) : list.get(0).concat(" ").concat(list.get(1));
                if (Integer.parseInt(list.get(3)) != 0) {
                    int maxcnt = Integer.parseInt(cloneContents.get(i).get(9));
                    int cnt = 0;
                    while (cnt < maxcnt) {
                        ListValue value = new ListValue();
                        value.domeOverType = "D";
                        value.isDealItem = "Y";
                        value.prodCode = null;
                        value.prodRegNo = String.format("%s-%s-%s-%s", cloneContents.get(i).get(0).substring(4), cloneContents.get(i).get(1), cloneContents.get(i).get(2), Integer.toString(cnt));
                        value.prodName = prodnm;
                        value.prodMemo = cloneContents.get(i).get(13);
                        value.wrapStatus = "\ubc15\uc2a4";
                        value.calcType = "0001";
                        value.width = Integer.parseInt(list.get(2));
                        value.vertical = Integer.parseInt(list.get(3));
                        value.height = Integer.parseInt(list.get(4));
                        value.weight = Integer.parseInt(list.get(5));
                        value.custSndrNo = "C310000018";
                        value.price = 50;
                        value.count = null;
                        value.branSndnCode = null;
                        value.branArvlCode = null;
                        value.custSndrName = comlist.get(1);
                        value.custSndrTelno = comlist.get(17);
                        value.custSndrEtcTelno = null;
                        value.custSndrZip = comlist.get(13);
                        value.custSndrAddr = comlist.get(14);
                        value.custSndrDaddr = null;
                        value.custRcvrName = cloneContents.get(i).get(4);
                        value.custRcvrTelno = cloneContents.get(i).get(7).equals("") ? cloneContents.get(i).get(8) : cloneContents.get(i).get(7);
                        value.custRcvrEtcTelno = null;
                        value.custRcvrZip = cloneContents.get(i).get(5);
                        addr3 = "";
                        addr52 = "";
                        byte[] strByte = cloneContents.get(i).get(6).getBytes();
                        int totLen = strByte.length;
                        int middel_Len = totLen - 63;
                        if (totLen > 59) {
                            addr3 = YDMAStringUtil.setTextStrtok(cloneContents.get(i).get(6), 59);
                            if (totLen - 60 > 63) {
                                middel_Len = totLen - 63;
                                addr52 = new String(strByte, middel_Len, totLen - middel_Len);
                            } else if (totLen - 60 <= 63) {
                                middel_Len = 59;
                                addr52 = new String(strByte, middel_Len, totLen - middel_Len);
                            }
                        } else {
                            addr3 = cloneContents.get(i).get(6);
                        }
                        value.custRcvrAddr = (String)addr3;
                        value.custRcvrDaddr = addr52;
                        value.etcPay = 0;
                        value.otherPay = 0;
                        value.payType = cloneContents.get(i).get(11).equals("\ucc29\ubd88") ? "0002" : "0001";
                        group.list.add(value);
                        ++cnt;
                    }
                }
                ++i;
            }
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)group);
            String Host = "http://211.62.97.193:8050/api/v1";
            OkHttpClient client = new OkHttpClient().newBuilder().build();
            MediaType mediaType = MediaType.parse((String)"application/json");
            RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
            Request request2 = new Request.Builder().url(Host.concat("/express/receipts")).method("PUT", body).addHeader("Content-Type", "application/json;charset=UTF-8").addHeader("X-AUTH-SECRET-KEY", "bwCx84B0bx8FD7u2h7av2oboFAAQ8II/Mcc6BycuYK7FPdODAtI62/aJkljvv0/zSa33TFrs/6Y+G2/cBU6ZMDrWM69VuMF3FBqeOVS7Jn2lZebq/EJ1YCr+kqwBDaAxD8vf+K/ZJWi4z73UviiGtA==").addHeader("Accept", "application/json").addHeader("application", "json").build();
            String data2 = "";
            addr3 = null;
            addr52 = null;
            try (Response response = client.newCall(request2).execute();){
                data2 = response.body().string();
            }
            catch (Throwable addr52) {
                if (addr3 == null) {
                    addr3 = addr52;
                } else if (addr3 != addr52) {
                    ((Throwable)addr3).addSuppressed(addr52);
                }
                throw addr3;
            }
            group.list.size();
            JsonParser jsonParser = new JsonParser();
            JsonObject jsonObject = (JsonObject)jsonParser.parse(data2);
            String code = jsonObject.get("code").getAsString();
            if (code.equals("API_PRC_S000")) {
                JsonObject value = (JsonObject)jsonObject.get("data");
                int j = 0;
                while (j < value.get("list").getAsJsonArray().size()) {
                    JsonObject valueLst = value.get("list").getAsJsonArray().get(j).getAsJsonObject();
                    String result = valueLst.get("result").getAsString();
                    String message = valueLst.get("message").getAsString();
                    ArrayList<String> list = new ArrayList<String>();
                    if (result.equals("Y")) {
                        String orderNos = valueLst.get("content").getAsJsonObject().get("prodRegNo").getAsString();
                        String[] orderNo = orderNos.split("-");
                        if (orderNo[3].equals("0")) {
                            int idx = 0;
                            list.add(idx++, cloneContents.get(0).get(0).substring(0, 4).concat(orderNo[0]));
                            list.add(idx++, orderNo[1]);
                            list.add(idx++, orderNo[2]);
                            list.add(idx++, result);
                            list.add(idx++, message);
                            list.add(idx++, valueLst.get("content").getAsJsonObject().get("prodCode").getAsString());
                            list.add(idx++, valueLst.get("content").getAsJsonObject().get("fare").getAsJsonObject().get("deliTotalPay").getAsString());
                            responContents.add(list);
                        }
                    } else {
                        int idx = 0;
                        list.add(idx++, "");
                        list.add(idx++, "");
                        list.add(idx++, "");
                        list.add(idx++, result);
                        list.add(idx++, message);
                        responContents.add(list);
                    }
                    ++j;
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public List<PickupDto> sendPickupKyungdongExpress2(List<PickupDto> cloneContents, String orddt, List<String> comlist) {
        ArrayList<PickupDto> responContents = new ArrayList<PickupDto>();
        try {
            String url = "https://kdapi.kditlab.com/v1/Send2";
            for (PickupDto content : cloneContents) {
                URL obj = new URL(url);
                HttpURLConnection httpConnection = (HttpURLConnection)obj.openConnection();
                httpConnection.setRequestMethod("POST");
                httpConnection.setRequestProperty("Content-Type", "application/json");
                httpConnection.setRequestProperty("Accept-Charset", "UTF-8");
                httpConnection.setDoOutput(true);
                JsonObject object = new JsonObject();
                JsonArray jsonarray = new JsonArray();
                object.addProperty("API_KEY", "93DA0E4789FA431F97BC60D1743D6510");
                object.addProperty("BR_END_NM", "");
                object.addProperty("COM_NM", "");
                object.addProperty("RECV_NM", content.getRcvnam());
                object.addProperty("RECV_TEL1", content.getClpno().equals("") ? content.getTelno() : content.getClpno());
                object.addProperty("RECV_TEL2", "");
                object.addProperty("RECV_ZIPCODE", content.getPstno());
                String addr3 = "";
                String addr4 = "";
                byte[] strByte = content.getAddr().getBytes();
                int totLen = strByte.length;
                int middel_Len = totLen - 63;
                if (totLen > 59) {
                    addr3 = YDMAStringUtil.setTextStrtok(content.getAddr(), 59);
                    if (totLen - 60 > 63) {
                        middel_Len = totLen - 63;
                        addr4 = new String(strByte, middel_Len, totLen - middel_Len);
                    } else if (totLen - 60 <= 63) {
                        middel_Len = 59;
                        addr4 = new String(strByte, middel_Len, totLen - middel_Len);
                    }
                } else {
                    addr3 = content.getAddr();
                }
                object.addProperty("RECV_ADDR1", addr3);
                object.addProperty("RECV_ADDR2", addr4);
                object.addProperty("SEND_NM", comlist.get(1));
                object.addProperty("SEND_TEL1", comlist.get(17));
                object.addProperty("SEND_TEL2", "");
                object.addProperty("SEND_ZIPCODE", comlist.get(13));
                object.addProperty("SEND_ADDR1", comlist.get(14));
                object.addProperty("SEND_ADDR2", "");
                object.addProperty("PD_CNT", content.getQty());
                object.addProperty("PD_DELI_GUBUN", content.getCredit().equals("\ucc29\ubd88") ? "\ucc29\ud0dd" : "\ud604\ud0dd");
                object.addProperty("PD_DELI_PAY", (Number)(Integer.parseInt(content.getQty()) * Integer.parseInt(content.getShpfee())));
                object.addProperty("PD_INSURANCE_PAY", (Number)100);
                object.addProperty("PD_MEMO", content.getMessge());
                String prodnm = "";
                if (content.getExpprodnm().length() > 50) {
                    strByte = content.getExpprodnm().getBytes();
                    prodnm = new String(strByte, 0, 50);
                } else {
                    prodnm = content.getExpprodnm();
                }
                object.addProperty("PD_NM", prodnm);
                object.addProperty("PD_PACK", "\ubc15\uc2a4");
                int maxcnt = Integer.parseInt(content.getQty());
                String pdprice = "";
                int cnt = 0;
                while (cnt < maxcnt) {
                    pdprice = String.valueOf(pdprice) + "30|";
                    ++cnt;
                }
                object.addProperty("PD_PRICE", pdprice);
                YDMAStringUtil.Print(pdprice);
                jsonarray.add((JsonElement)object);
                YDMAStringUtil.Print(jsonarray.toString());
                DataOutputStream out = new DataOutputStream(httpConnection.getOutputStream());
                out.write(jsonarray.toString().getBytes("UTF-8"));
                out.flush();
                out.close();
                int responseCode = httpConnection.getResponseCode();
                YDMAStringUtil.Print("\ud0dd\ubc30\uc0ac\uc1a1\uc7a5\uc218\uc2e0: " + responseCode);
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConnection.getInputStream(), "UTF-8"));
                String inputLine = null;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                YDMAStringUtil.Print(response.toString());
                String xml = response.toString();
                if (xml == null) continue;
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                factory.setNamespaceAware(true);
                InputSource is = new InputSource(new StringReader(response.toString()));
                Document document = builder.parse(is);
                NodeList nList = document.getElementsByTagName("Response");
                int j = 0;
                while (j < nList.getLength()) {
                    Node nNode = nList.item(j);
                    PickupDto list = new PickupDto();
                    if (nNode.getNodeType() == 1) {
                        Element eElement = (Element)nNode;
                        list.setOrddt(content.getOrddt());
                        list.setOrdseq(content.getOrdseq());
                        list.setSeq(content.getSeq());
                        String statuscode = PickupExpressAPIDao.getTagValue("CODE", eElement);
                        list.setStatus_cd(statuscode);
                        list.setStatus_msg(this.KyunddongJobStats(statuscode));
                        list.setInvno(PickupExpressAPIDao.getTagValue("PD_BARCODE", eElement));
                    }
                    responContents.add(list);
                    ++j;
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    public List<PickupDto> sendPickupLogenExpress(List<PickupDto> cloneContents, String orddt, List<String> comlist) {
        ArrayList<PickupDto> responContents = new ArrayList<PickupDto>();
        new JsonParser();
        try {
            for (PickupDto shipping : cloneContents) {
                URL url = new URL("https://trace-api-dev.sweettracker.net/reception");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Accept-Charset", "UTF-8");
                conn.setDoOutput(true);
                JsonObject object = new JsonObject();
                object.addProperty("tierCode", "kdjsystem");
                object.addProperty("cipherType", "0");
                JsonObject data2 = new JsonObject();
                JsonArray jsonarray = new JsonArray();
                data2.addProperty("ordCde", String.valueOf(shipping.getOrddt()) + shipping.getOrdseq() + shipping.getSeq());
                data2.addProperty("comCode", "06");
                data2.addProperty("cusCde", "10320029");
                data2.addProperty("comDivCde", "");
                data2.addProperty("sndNme", comlist.get(1));
                data2.addProperty("sndZip", comlist.get(13));
                data2.addProperty("sndAd1", comlist.get(14));
                data2.addProperty("sndAd2", " ");
                data2.addProperty("sndMod", comlist.get(17));
                data2.addProperty("ownNme", shipping.getRcvnam());
                data2.addProperty("ownZip", shipping.getPstno());
                data2.addProperty("ownMod", shipping.getClpno().equals("") ? shipping.getTelno() : shipping.getClpno());
                String addr3 = "";
                String addr4 = "";
                if (shipping.getAddr().getBytes().length >= 60) {
                    addr3 = YDMAStringUtil.setTextStrtok(shipping.getAddr(), 60);
                    addr4 = shipping.getAddr().substring(addr3.length(), shipping.getAddr().length());
                } else {
                    addr3 = shipping.getAddr();
                }
                data2.addProperty("ownAd1", String.valueOf(addr3) + " " + addr4);
                data2.addProperty("ownAd2", " ");
                data2.addProperty("boxQty", shipping.getQty());
                data2.addProperty("wipGbn", shipping.getCredit().equals("\ucc29\ubd88") ? "2" : "3");
                data2.addProperty("adMemo", shipping.getMessge());
                String prodnm = "";
                if (shipping.getExpprodnm().length() > 50) {
                    byte[] strByte = shipping.getExpprodnm().getBytes();
                    prodnm = new String(strByte, 0, 50);
                } else {
                    prodnm = shipping.getExpprodnm();
                }
                data2.addProperty("itmLst", prodnm);
                jsonarray.add((JsonElement)data2);
                object.add("data", (JsonElement)jsonarray);
                YDMAStringUtil.Print(object.toString());
                DataOutputStream out = new DataOutputStream(conn.getOutputStream());
                out.write(object.toString().getBytes("UTF-8"));
                out.flush();
                out.close();
                int responseCode = conn.getResponseCode();
                YDMAStringUtil.Print("\ud0dd\ubc30\uc0ac\uc1a1\uc7a5\uc218\uc2e0: " + responseCode);
                BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
                String inputLine = null;
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                if (responseCode != 200 || !response.toString().contains("\"result\":\"Y\"")) continue;
                responContents.add(shipping);
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
        return responContents;
    }

    private static String getTagValue(String tag, Element eElement) {
        NodeList nlList = eElement.getElementsByTagName(tag).item(0).getChildNodes();
        Node nValue = nlList.item(0);
        if (nValue == null) {
            return null;
        }
        return nValue.getNodeValue();
    }

    private String KyunddongJobStats(String string) {
        String stats = "";
        switch (string) {
            case "0": {
                stats = "\ubcf4\ub0b4\ub294 \ub370\uc774\ud130\uac00 \ud615\uc2dd\uc774 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "1": {
                stats = "DB\uc5d0 \uc811\uc18d\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc804\uc0b0\uc2e4\uc5d0 \ubb38\uc758\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
                break;
            }
            case "2": {
                stats = "Request\uc5d0 \ub3c4\ucc29 \uc601\uc5c5\uc18c\uba85\uc774 \uc5c6\ub294 \uacbd\uc6b0 \ub2f9\uc0ac\uc758 \ubc30\ub2ec\uad6c\uc5ed\uc5d0\uc11c\uc758 \ub3c4\ucc29\uc601\uc5c5\uc18c \uc815 \ubcf4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. \uc804\uc0b0\uc2e4\uc5d0 \ubb38\uc758\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
                break;
            }
            case "3": {
                stats = "Request\uc5d0 \ub3c4\ucc29 \uc601\uc5c5\uc18c\uba85(BR_END_NM )\uc774 \ub2f9\uc0ac\uc758 \uc601\uc5c5\uc18c\uba85\uacfc \uc77c\uce58\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4. ";
                break;
            }
            case "4": {
                stats = "\ubcf4\ub0b4\ub294 \ud0dd\ubc30\ube44 \uc6b4\uc784 \uac12\uc774 \ud604\ud0dd / \ucc29\ud0dd / \ud604\ubd88 / \ucc29\ubd88 \uc774 \uc544\ub2d9\ub2c8\ub2e4. ";
                break;
            }
            case "5": {
                stats = "\ubcf4\ub0b4\ub294\ubd84\uc758 \uc131\ud568\uc774 \uc5c6\uac70\ub098 \ub370\uc774\ud130 \ud06c\uae30\ub97c \ub118\uc5b4\uc130\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "6": {
                stats = "\ubcf4\ub0b4\ub294\ubd84 \uc804\ud654\ubc88\ud638\uac00 \uc5c6\uac70\ub098 \uc798\ubabb\ub41c \ud615\uc2dd\uc785\ub2c8\ub2e4.";
                break;
            }
            case "7": {
                stats = "\ubcf4\ub0b4\ub294\ubd84 \uae30\ud0c0\uc804\ud654\ubc88\ud638\uac00 \uc798\ubabb\ub41c \ud615\uc2dd\uc785\ub2c8\ub2e4.";
                break;
            }
            case "8": {
                stats = "\uc6b0\ud3b8\ubc88\ud638\uac00 \uc5c6\uac70\ub098 \ud615\uc2dd\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "9": {
                stats = "\uc8fc\uc18c\uac00 \uc5c6\uac70\ub098 \ud5c8\uc6a9\ub418\ub294 \ud06c\uae30\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "10": {
                stats = "\uc0c1\uc138\uc8fc\uc18c\uac00 \ud5c8\uc6a9\ub418\ub294 \ud06c\uae30\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "11": {
                stats = "\ubc1b\ub294\ubd84 \uc131\ud568\uc774 \uc5c6\uac70\ub098 \ud5c8\uc6a9\ub418\ub294 \ud06c\uae30\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "12": {
                stats = "\ubc1b\ub294\ubd84 \uc804\ud654\ubc88\ud638\uac00 \uc5c6\uac70\ub098 \uc798\ubabb\ub41c \ud615\uc2dd\uc785\ub2c8\ub2e4.";
                break;
            }
            case "13": {
                stats = "\ubc1b\ub294\ubd84 \uae30\ud0c0\uc804\ud654\ubc88\ud638\uac00 \uc798\ubabb\ub41c \ud615\uc2dd\uc785\ub2c8\ub2e4.";
                break;
            }
            case "14": {
                stats = "\ubc1b\ub294\ubd84 \uc6b0\ud3b8\ubc88\ud638\uac00 \uc5c6\uac70\ub098 \ud615\uc2dd\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "15": {
                stats = "\ubc1b\ub294\ubd84 \uc8fc\uc18c\uac00 \uc5c6\uac70\ub098 \ud5c8\uc6a9\ub418\ub294 \ud06c\uae30\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "16": {
                stats = "\ubc1b\ub294\ubd84 \uc0c1\uc138\uc8fc\uc18c\uac00 \ud5c8\uc6a9\ub418\ub294 \ud06c\uae30\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "17": {
                stats = "\uc0c1\ud488\uc758 \ud488\ubaa9\uba85\uc774 \uc5c6\uac70\ub098 \ud5c8\uc6a9\ub418\ub294 \ud06c\uae30\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "18": {
                stats = "\ud3ec\uc7a5\uc0c1\ud0dc\uac00 \uc5c6\uac70\ub098 \ud5c8\uc6a9\ub418\ub294 \ud06c\uae30\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "19": {
                stats = "\uc6b4\uc784\uc774 \ub2f9\uc0ac\uc758 \ucd5c\uc800\uc6b4\uc784 \ubc29\uce68\ubcf4\ub2e4 \uc791\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "20": {
                stats = "\uc218\ub7c9\uc774 1\uac1c\ubbf8\ub9cc\uc774\uac70\ub098 100\uac1c\ub97c \ucd08\uacfc\ud558\uc600\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "21": {
                stats = "\uac1c\ubcc4\ub2e8\uac00\uac00 \uc218\ub7c9\uacfc \ub9de\uc9c0 \uc54a\uac70\ub098 \ud615\uc2dd\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "22": {
                stats = "\ubd80\ud53c\uac00 \uc218\ub7c9\uacfc \ub9de\uc9c0 \uc54a\uac70\ub098 \ud615\uc2dd\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "23": {
                stats = "\ubb34\uac8c\uac00 \uc218\ub7c9\uacfc \ub9de\uc9c0 \uc54a\uac70\ub098 \ud615\uc2dd\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "24": {
                stats = "\uba54\ubaa8\uac00 \ud5c8\uc6a9\ub418\ub294 \ud06c\uae30\ub97c \ubc97\uc5b4\ub0ac\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "25": {
                stats = "\uc218\ud0c1\ubc88\ud638 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc804\uc0b0\uc2e4\uc5d0 \ubb38\uc758\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
                break;
            }
            case "26": {
                stats = "\ud574\ub2f9 \uc9c0\uc5ed\uc744 \ubc30\ub2ec\uad6c\uc5ed\uc5d0\uc11c \ucc3e\uc9c0 \ubabb \ud558\uc600\uac70\ub098 \uc62c\ubc14\ub978 \uc6b0\ud3b8\ubc88\ud638\uac00 \uc544\ub2d9\ub2c8\ub2e4.";
                break;
            }
            case "27": {
                stats = "\ub178\uc120 \ud560\ub2f9\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc804\uc0b0\uc2e4\uc5d0 \ubb38\uc758\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
                break;
            }
            case "28": {
                stats = "\ub3c4\ud06c \ud560\ub2f9\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc804\uc0b0\uc2e4\uc5d0 \ubb38\uc758\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
                break;
            }
            case "29": {
                stats = "\ubc30\ucc28 \uc815\ubcf4\uc77d\uae30\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc804\uc0b0\uc2e4\uc5d0 \ubb38\uc758\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
                break;
            }
            case "30": {
                stats = "\ubc1c\uc1a1 \uc815\ubcf4 \uc785\ub825\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc804\uc0b0\uc2e4\uc5d0 \ubb38\uc758\ud558\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.";
                break;
            }
            case "200": {
                stats = "\ud0dd\ubc30 \uc804\uc1a1\uc774 \uc131\uacf5\uc801\uc73c\ub85c \uc804\uc1a1\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "900": {
                stats = "\ud654\ubb3c\uc778 \uacbd\uc6b0 \ucc3e\uc744 \uc218 \uc5c6\ub294 \uc601\uc5c5\uc18c\uba85\uc778 \uacbd\uc6b0\uc785\ub2c8\ub2e4.";
                break;
            }
            case "901": {
                stats = "API\ud0a4\uac00 \uc5c6\uc5b4\uac00 \uc778\uc99d\ub418\uc9c0 \uc54a\uc740 \ud0a4 \uc785\ub2c8\ub2e4";
                break;
            }
            case "902": {
                stats = "\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uac70\ub798\ucc98\uba85\uc785\ub2c8\ub2e4.";
                break;
            }
            case "903": {
                stats = "\uc6b4\uc1a1\uc7a5\ubc88\ud638\ub97c \uc790\uccb4 \uc0dd\uc131\ud558\uc5ec \uc0ac\uc6a9\ud558\uc2dc\ub294 \uacbd\uc6b0\uc5d0 \uc0dd\uc131 \uaddc\uce59\uc5d0 \ub9de\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "904": {
                stats = "\uc6b4\uc1a1\uc7a5\ubc88\ud638\ub97c \uc790\uccb4 \uc0dd\uc0c1\ud558\uc5ec \uc0ac\uc6a9\ud558\uc2dc\ub294 \uacbd\uc6b0\uc5d0 \uc0ac\uc6a9\ub41c \uc6b4\uc1a1\uc7a5 \ubc88\ud638\uc785\ub2c8\ub2e4.";
                break;
            }
            case "905": {
                stats = "\uc815\uc758\ub418\uc9c0 \uc54a\uc740 \uc608\uc678\uc785\ub2c8\ub2e4.";
                break;
            }
            case "906": {
                stats = "\uc77c\uc694\uc77c\uc5d0\ub294 \uc804\uc0b0\uc2e4\uc5d0\uc11c \ud5c8\uc6a9\ud55c ID\uc678\uc5d0\ub294 \ubc1c\uc1a1 \uc790\ub8cc\uc800\uc7a5\uc774 \ubd88\uac00\ud569\ub2c8\ub2e4.";
                break;
            }
        }
        return stats;
    }

    private String KyunddongJobStats22(String string) {
        String stats = "";
        switch (string) {
            case "API_PRC_S000": {
                stats = "\uc11c\ube44\uc2a4\uac00 \uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "API_REQ_E001": {
                stats = "\ud544\uc218\uac12 \ub204\ub77d.";
                break;
            }
            case "API_REQ_E002": {
                stats = "\ud5c8\uc6a9 \uae38\uc774 \uc624\ub958.";
                break;
            }
            case "API_REQ_E003": {
                stats = "\ucd5c\ub300 \uae38\uc774 \ucd08\uacfc.";
                break;
            }
            case "API_REQ_E004": {
                stats = "\ucd5c\uc18c \uae38\uc774 \ubbf8\ub2ec.";
                break;
            }
            case "API_REQ_E005": {
                stats = "\ud615\uc2dd \uc624\ub958.";
                break;
            }
            case "API_REQ_E098": {
                stats = "XSS or SQL Injection \ud0d0\uc9c0.";
                break;
            }
            case "API_REQ_E099": {
                stats = "\uc54c \uc218 \uc5c6\ub294 \ud30c\ub77c\uba54\ud130 \uac80\uc99d.";
                break;
            }
            case "API_ATH_E001": {
                stats = "Http - \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc740 IP Address.";
                break;
            }
            case "API_ATH_E002": {
                stats = "Http - \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc740 Domain.";
                break;
            }
            case "API_ATH_E003": {
                stats = "Http Headers - Secret Key \ub204\ub77d";
                break;
            }
            case "API_ATH_E004": {
                stats = "\uad8c\ud55c\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.";
                break;
            }
            case "API_ATH_E008": {
                stats = "Http - \ud5c8\uc6a9\ub418\uc9c0 \uc54a\uc740 APP \ubc84\uc804\uc785\ub2c8\ub2e4.";
                break;
            }
            case "API_ATH_E009": {
                stats = "\uc778\uc99d \uc2e4\ud328.";
                break;
            }
            case "API_HAD_E001": {
                stats = "Http Headers - \ud544\uc218\uac12 \ub204\ub77d.";
                break;
            }
            case "API_HAD_E002": {
                stats = "Http Headers - Partner Code \ub204\ub77d.";
                break;
            }
            case "API_HAD_E003": {
                stats = "Http Headers - Partner Code \ud5c8\uc6a9 \ubd88\uac00.";
                break;
            }
            case "API_HAD_E004": {
                stats = "Http Headers - Transaction ID \ub204\ub77d.";
                break;
            }
            case "API_SVR_E001": {
                stats = "\uc11c\ubc84 \uc5f0\uacb0 \uc624\ub958.";
                break;
            }
            case "API_FIL_E001": {
                stats = "File \ucc98\ub9ac \uc624\ub958.";
                break;
            }
            case "API_SQL_E001": {
                stats = "DB \uc0ac\uc6a9 \uc624\ub958.";
                break;
            }
            case "API_PRC_E001": {
                stats = "JSON Processing \uc624\ub958.";
                break;
            }
            case "API_PRC_E002": {
                stats = "\uc751\ub2f5 NULL \uc624\ub958.";
                break;
            }
            case "API_PRC_E003": {
                stats = "\ub370\uc774\ud130\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc74c.";
                break;
            }
            case "API_PRC_E004": {
                stats = "token \ubc1c\uae09 \uc2e4\ud328.";
                break;
            }
            case "API_PRC_E005": {
                stats = "\uc774\ubbf8 \ub4f1\ub85d\ub41c \uc790\ub8cc.";
                break;
            }
            case "API_PRC_E009": {
                stats = "\ucc98\ub9ac \uc911 \uc624\ub958 \ubc1c\uc0dd";
                break;
            }
            case "API_ETC_E001": {
                stats = "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958.";
                break;
            }
        }
        return stats;
    }

    public void setExpressErrorUpdate(List<List<String>> errorResult, int brandcd) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set EXPSENDDT=?, expnm = ?, exprecvdt = ?, flag = ? where orddt=? and ordseq = ? and seq = ? and compno = ? and brandcd = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : errorResult) {
                        int i = 0;
                        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++i, String.valueOf(list.get(4)) + "_" + list.get(3));
                        pstmt.setString(++i, YDMATimeUtil.getCurrentTimeByYDFormat());
                        pstmt.setString(++i, "X");
                        pstmt.setString(++i, list.get(0));
                        pstmt.setString(++i, list.get(1));
                        pstmt.setString(++i, list.get(2));
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setExpressErrorUpdate]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setOrderMoveseq(List<List<String>> moveseq, int brandcd) throws Exception {
        block7: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update orddtl set moveseq=? where orddt=? and ordseq = ? and seq = ? and compno = ? and BRANDCD = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : moveseq) {
                        if (list.size() <= 49) continue;
                        String strTemp = list.get(2);
                        if (strTemp.length() == 9) {
                            strTemp = strTemp.substring(2);
                        }
                        int num = Integer.parseInt(strTemp);
                        int ordseq = (int)Math.floor(num / 1000000);
                        int seq = num % 1000000;
                        int i = 0;
                        pstmt.setString(++i, list.get(49));
                        pstmt.setString(++i, list.get(0));
                        pstmt.setInt(++i, ordseq);
                        pstmt.setInt(++i, seq);
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setOrderMoveseq]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setOrderMoveseq2(List<PickupDto> moveseq, int brandcd) throws Exception {
        block7: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update orddtl set moveseq=? where orddt=? and ordseq = ? and seq = ? and compno = ? and BRANDCD = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (PickupDto list : moveseq) {
                        if (list.getParam3() == null) continue;
                        String strTemp = list.getSeq();
                        if (strTemp.length() == 9) {
                            strTemp = strTemp.substring(2);
                        }
                        int num = Integer.parseInt(strTemp);
                        int ordseq = (int)Math.floor(num / 1000000);
                        int seq = num % 1000000;
                        int i = 0;
                        pstmt.setString(++i, list.getParam3());
                        pstmt.setString(++i, list.getOrddt());
                        pstmt.setInt(++i, ordseq);
                        pstmt.setInt(++i, seq);
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setOrderMoveseq]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setDeliveryMethod(List<List<String>> moveseq, int brandcd) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set CREDIT=? where orddt=? and ordseq = ? and seq = ? and compno = ? and BRANDCD = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : moveseq) {
                        int i = 0;
                        pstmt.setString(++i, list.get(11));
                        pstmt.setString(++i, list.get(0));
                        pstmt.setString(++i, list.get(1));
                        pstmt.setString(++i, list.get(2));
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setDeliveryMethod]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setDeliveryMethod2(List<PickupDto> moveseq, int brandcd) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set CREDIT=? where orddt=? and ordseq = ? and seq = ? and compno = ? and BRANDCD = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (PickupDto list : moveseq) {
                        int i = 0;
                        pstmt.setString(++i, list.getCredit());
                        pstmt.setString(++i, list.getOrddt());
                        pstmt.setString(++i, list.getOrdseq());
                        pstmt.setString(++i, list.getSeq());
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setDeliveryMethod]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public boolean isSuppdtNotnull(List<String> list, int brandcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ORDSEQ from pickupexp  where ORDDT = ? and ORDSEQ = ? and SEQ = ? and compno = ? and brandcd= ?    and suppdt is not null";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, list.get(0));
                pstmt.setString(2, list.get(1));
                pstmt.setString(3, list.get(2));
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(5, brandcd);
                YDMAStringUtil.Print("[isCanExpPickUpListReset]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public boolean isSuppdtNotnull(PickupDto list, int brandcd) throws Exception {
        boolean flag = false;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "select ORDSEQ from pickupexp  where ORDDT = ? and ORDSEQ = ? and SEQ = ? and compno = ? and brandcd= ?    and suppdt is not null";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, list.getOrddt());
                pstmt.setString(2, list.getOrdseq());
                pstmt.setString(3, list.getSeq());
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(5, brandcd);
                YDMAStringUtil.Print("[isCanExpPickUpListReset]" + pstmt.toString());
                rs = pstmt.executeQuery();
                flag = rs.next();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return flag;
    }

    public void setSuppdtUpdate(List<List<String>> delContents, int brandcd) throws Exception {
        block7: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update orddtl set ASIGNDT = null, ASIGNSEQ = null, ASIGNHSEQ = null where compno = ?   and brandcd = ?  and ORDDT = ?   and ORDSEQ = ?  and SEQ = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (List<String> list : delContents) {
                        String strTemp = list.get(2);
                        if (strTemp.length() == 9) {
                            strTemp = strTemp.substring(2);
                        }
                        int num = Integer.parseInt(strTemp);
                        int ordseq = (int)Math.floor(num / 1000000);
                        int seq = num % 1000000;
                        int i = 0;
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.setString(++i, list.get(0));
                        pstmt.setInt(++i, ordseq);
                        pstmt.setInt(++i, seq);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setMoveList]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setSuppdtUpdate2(List<PickupDto> delContents, int brandcd) throws Exception {
        block7: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update orddtl set ASIGNDT = null, ASIGNSEQ = null, ASIGNHSEQ = null where compno = ?   and brandcd = ?  and ORDDT = ?   and ORDSEQ = ?  and SEQ = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (PickupDto list : delContents) {
                        String strTemp = list.getSeq();
                        if (strTemp.length() == 9) {
                            strTemp = strTemp.substring(2);
                        }
                        int num = Integer.parseInt(strTemp);
                        int ordseq = (int)Math.floor(num / 1000000);
                        int seq = num % 1000000;
                        int i = 0;
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.setString(++i, list.getOrddt());
                        pstmt.setInt(++i, ordseq);
                        pstmt.setInt(++i, seq);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setMoveList]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setOrderMoveseqUpdate(List<List<String>> subContents, List<String> list, int brandcd) throws Exception {
        block7: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update orddtl set moveseq=? where orddt=? and ordseq = ? and seq = ? and compno = ? and BRANDCD = ? ";
                    subContents.remove(subContents.size() - 1);
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int numq = Integer.parseInt(list.get(2));
                    int cfr_ignored_0 = numq % 1000000;
                    for (List<String> subList : subContents) {
                        int i = 0;
                        String strTemp = subList.get(2);
                        if (strTemp.length() == 9) {
                            strTemp = strTemp.substring(2);
                        }
                        int num = Integer.parseInt(strTemp);
                        int ordseq = (int)Math.floor(num / 1000000);
                        int seq = num % 1000000;
                        pstmt.setInt(++i, Integer.parseInt(list.get(2)));
                        pstmt.setString(++i, subList.get(0));
                        pstmt.setInt(++i, ordseq);
                        pstmt.setInt(++i, seq);
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setOrderMoveseq]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setOrderMoveseqUpdate2(List<PickupDto> subContents, PickupDto list, int brandcd) throws Exception {
        block7: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update orddtl set moveseq=? where orddt=? and ordseq = ? and seq = ? and compno = ? and BRANDCD = ? ";
                    subContents.remove(subContents.size() - 1);
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int numq = Integer.parseInt(list.getSeq());
                    int cfr_ignored_0 = numq % 1000000;
                    for (PickupDto subList : subContents) {
                        int i = 0;
                        String strTemp = subList.getSeq();
                        if (strTemp.length() == 9) {
                            strTemp = strTemp.substring(2);
                        }
                        int num = Integer.parseInt(strTemp);
                        int ordseq = (int)Math.floor(num / 1000000);
                        int seq = num % 1000000;
                        pstmt.setInt(++i, Integer.parseInt(list.getSeq()));
                        pstmt.setString(++i, subList.getOrddt());
                        pstmt.setInt(++i, ordseq);
                        pstmt.setInt(++i, seq);
                        pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++i, brandcd);
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    YDMAStringUtil.Print("[setOrderMoveseq]" + pstmt.toString());
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void pickupQtyUpdate(List<String> list, int sum, int brandcd) throws Exception {
        block5: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set QTY2 = ? where ORDDT = ? and ORDSEQ =? and seq = ? and compno = ? and brandcd = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int i = 0;
                    pstmt.setInt(++i, sum);
                    pstmt.setString(++i, list.get(0));
                    pstmt.setString(++i, list.get(1));
                    pstmt.setString(++i, list.get(2));
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++i, brandcd);
                    pstmt.executeUpdate();
                    YDMAStringUtil.Print("[getPickupExpressInvnoUpdate]" + pstmt.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void pickupQtyUpdate2(PickupDto list, int sum, int brandcd) throws Exception {
        block5: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = "update pickupexp set QTY2 = ? where ORDDT = ? and ORDSEQ =? and seq = ? and compno = ? and brandcd = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    int i = 0;
                    pstmt.setInt(++i, sum);
                    pstmt.setString(++i, list.getOrddt());
                    pstmt.setString(++i, list.getOrdseq());
                    pstmt.setString(++i, list.getSeq());
                    pstmt.setString(++i, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++i, brandcd);
                    pstmt.executeUpdate();
                    YDMAStringUtil.Print("[getPickupExpressInvnoUpdate]" + pstmt.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void setExpressNInvoiceUpdate(String expnm, List<List<String>> contents) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update pickupexp set EXPNM = ? , invno=? where compno = ? and orddt = ? and ordseq = ? and seq = ? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (List<String> list : contents) {
                    int idx = 0;
                    pstmt.setString(++idx, expnm);
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentDateHanjin());
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++idx, list.get(0));
                    pstmt.setString(++idx, list.get(1));
                    pstmt.setString(++idx, list.get(2));
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setExpressNInvoiceUpdate]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void setExpressNInvoiceUpdate2(String expnm, List<PickupDto> contents) throws Exception {
        Connection connection = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "update pickupexp set EXPNM = ? , invno=? where compno = ? and orddt = ? and ordseq = ? and seq = ? ";
                sql = sql.toUpperCase();
                PreparedStatement pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                for (PickupDto list : contents) {
                    int idx = 0;
                    pstmt.setString(++idx, expnm);
                    pstmt.setString(++idx, YDMATimeUtil.getCurrentDateHanjin());
                    pstmt.setString(++idx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(++idx, list.getOrddt());
                    pstmt.setString(++idx, list.getOrdseq());
                    pstmt.setString(++idx, list.getSeq());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                }
                YDMAStringUtil.Print("[setExpressNInvoiceUpdate]" + pstmt.toString());
                pstmt.executeBatch();
                pstmt.clearParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
                DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    private static class ListValue {
        private String domeOverType;
        private String isDealItem;
        private String prodCode;
        private String prodRegNo;
        private String prodName;
        private String prodMemo;
        private String wrapStatus;
        private String calcType;
        private int width;
        private int vertical;
        private int height;
        private double weight;
        private int price;
        private String count;
        private String branSndnCode;
        private String branArvlCode;
        private String custSndrNo;
        private String custSndrName;
        private String custSndrTelno;
        private String custSndrEtcTelno;
        private String custSndrZip;
        private String custSndrAddr;
        private String custSndrDaddr;
        private String custRcvrName;
        private String custRcvrTelno;
        private String custRcvrEtcTelno;
        private String custRcvrZip;
        private String custRcvrAddr;
        private String custRcvrDaddr;
        private int etcPay;
        private int otherPay;
        private String payType;

        private ListValue() {
        }
    }

    private static class listMain {
        private List<ListValue> list = new ArrayList<ListValue>();

        private listMain() {
        }
    }
}

