/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.logging;

import com.kdjsystem.mlink.tot.Activator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public final class AppLog {
    private static File file;
    private static volatile boolean initialized;
    private static final boolean DEBUG;

    static {
        initialized = false;
        DEBUG = Boolean.getBoolean("mlink.debug");
    }

    private AppLog() {
    }

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        IPath state = Platform.getStateLocation((Bundle)Activator.getDefault().getBundle());
        file = state.append("runtime.log").toFile();
        file.getParentFile().mkdirs();
        initialized = true;
        AppLog.info("[BOOT] AppLog initialized. File: " + file.getAbsolutePath());
    }

    public static void info(String msg) {
        AppLog.log(1, msg, null);
    }

    public static void warn(String msg) {
        AppLog.log(2, msg, null);
    }

    public static void error(String msg, Throwable t) {
        AppLog.log(4, msg, t);
    }

    public static void debug(String msg) {
        if (DEBUG) {
            AppLog.log(0, "[DEBUG] " + msg, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void log(int sev, String msg, Throwable t) {
        String line;
        block23: {
            if (!initialized) {
                AppLog.init();
            }
            line = String.valueOf(AppLog.ts()) + " " + msg + (t != null ? " :: " + t : "");
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    FileWriter fw = new FileWriter(file, true);
                    try {
                        block22: {
                            BufferedWriter bw = new BufferedWriter(fw);
                            try {
                                try (PrintWriter pw = new PrintWriter(bw);){
                                    pw.println(line);
                                    if (t != null) {
                                        t.printStackTrace(pw);
                                    }
                                }
                                if (bw == null) break block22;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (bw == null) throw throwable;
                                bw.close();
                                throw throwable;
                            }
                            bw.close();
                        }
                        if (fw == null) break block23;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (fw == null) throw throwable;
                        fw.close();
                        throw throwable;
                    }
                    fw.close();
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                        throw throwable;
                    }
                    if (throwable == throwable4) throw throwable;
                    throwable.addSuppressed(throwable4);
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
        Activator.getDefault().getLog().log((IStatus)new Status(sev, "com.kdjsystem.mlink.tot", msg, t));
        System.out.println(line);
        if (t == null) return;
        t.printStackTrace(System.out);
    }

    public static File getLogFile() {
        if (!initialized) {
            AppLog.init();
        }
        return file;
    }

    private static String ts() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date());
    }
}

