/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.ImageUpload;

import com.kdjsystem.mlink.shop.ImageUpload.NaverUploadImageDto;
import com.kdjsystem.mlink.shop.ImageUpload.UploadTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NaverImageUploadManager {
    private final ExecutorService executor;
    private final Map<String, String> loginCookie;

    public NaverImageUploadManager(Map<String, String> loginCookie) {
        this.loginCookie = loginCookie;
        this.executor = Executors.newFixedThreadPool(3);
    }

    public List<NaverUploadImageDto> uploadAll(List<String> imagePaths) {
        ArrayList<Future<NaverUploadImageDto>> futures = new ArrayList<Future<NaverUploadImageDto>>();
        for (String path : imagePaths) {
            futures.add(this.executor.submit(new UploadTask(path, this.loginCookie)));
        }
        ArrayList<NaverUploadImageDto> results = new ArrayList<NaverUploadImageDto>();
        for (Future future : futures) {
            try {
                results.add((NaverUploadImageDto)future.get());
            }
            catch (Exception e) {
                System.err.println("\uc774\ubbf8\uc9c0 \uc5c5\ub85c\ub4dc \uc2e4\ud328: " + e.getMessage());
            }
        }
        return results;
    }

    public void shutdown() {
        this.executor.shutdown();
    }
}

