/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.common;

import com.kdjsystem.mlink.shop.common.CodeItem;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDtoList;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.swt.SWTResourceManager;

public class QuestionStatus {
    public static final String WEB_DRIVER_ID = "webdriver.chrome.driver";
    public static final String WEB_DRIVER_PATH = YDMASessonUtil.getAppPath() + "\\YDwmsData\\chromedriver.exe";
    public static final String \uc2e0\uaddc = "100";
    public static final String \ub2f5\ubcc0\uc644\ub8cc = "101";
    public static final String \ubcf4\ub958 = "102";
    public static final String \ubcf4\ub958\ud574\uc81c = "202";
    public static final String \uc804\uc1a1\uc644\ub8cc = "103";
    public static final String \ud655\uc778\uc644\ub8cc = "104";
    public static final String \uc870\ud68c = "1000";
    public static final String \uc800\uc7a5 = "2000";
    public static final String \uc5c5\ub370\uc774\ud2b8 = "3000";
    public static final String \ub370\uc774\ud0c0\uc5c6\uc74c = "0";
    public static final String \uc5d0\ub7ec\ubc1c\uc0dd = "-1";
    public static final String \uc815\uc0c1\ucc98\ub9ac = "1";
    String result = "";
    private static QuestionStatus instance = new QuestionStatus();
    private List<OrderCodeMapperDto> items = new ArrayList<OrderCodeMapperDto>();

    private QuestionStatus() {
    }

    public static QuestionStatus getInstance() {
        if (QuestionStatus.instance.items.size() == 0) {
            instance.bind();
        }
        return instance;
    }

    public static String validate(String status2, String changeStatus) {
        String ret = \ub370\uc774\ud0c0\uc5c6\uc74c;
        block4 : switch (changeStatus) {
            case "202": {
                if (status2.equals(\ubcf4\ub958)) {
                    ret = \ub370\uc774\ud0c0\uc5c6\uc74c;
                    break;
                }
                ret = "\ud604\uc81c \uc0c1\ud0dc\uac00 \ubcf4\ub958\uac00 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud0dc\uac12\uc744 \ud655\uc778\ud574\uc8fc\uc138\uc694";
                break;
            }
            case "102": {
                switch (status2) {
                    case "100": 
                    case "101": 
                    case "104": {
                        ret = \ub370\uc774\ud0c0\uc5c6\uc74c;
                        break block4;
                    }
                }
                ret = "(\uc2e0\uaddc, \ud655\uc778\uc644\ub8cc, \ub2f5\ubcc0\uc644\ub8cc) \uc0c1\ud0dc\uac00 \uc544\ub2cc\uac12\uc740 \ubcf4\ub958\ub97c \ud560\uc218 \uc5c6\uc2b5\ub2c8\ub2e4.";
            }
        }
        return ret;
    }

    public String findCode(String code) {
        String result = "";
        switch (code) {
            case "100": {
                result = "\uc2e0\uaddc";
                break;
            }
            case "101": {
                result = "\ub2f5\ubcc0\uc644\ub8cc";
                break;
            }
            case "102": {
                result = "\ubcf4\ub958";
                break;
            }
            case "103": {
                result = "\uc804\uc1a1\uc644\ub8cc";
                break;
            }
            case "104": {
                result = "\ud655\uc778\uc644\ub8cc";
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public Color findColor(String code) {
        Color bgColor = null;
        switch (code) {
            case "100": {
                bgColor = SWTResourceManager.getColor(255, 255, 0);
                break;
            }
            case "101": {
                bgColor = SWTResourceManager.getColor(255, 248, 191);
                break;
            }
            case "102": {
                bgColor = SWTResourceManager.getColor(255, 188, 62);
                break;
            }
            case "103": {
                bgColor = SWTResourceManager.getColor(246, 246, 246);
                break;
            }
            case "104": {
                bgColor = SWTResourceManager.getColor(255, 255, 255);
                break;
            }
            default: {
                bgColor = SWTResourceManager.getColor(1);
            }
        }
        return bgColor;
    }

    public CodeItem findCode(String shopcd, String mall_code) {
        CodeItem item = new CodeItem();
        OrderCodeMapperDto dto = (OrderCodeMapperDto)this.items.stream().filter(p -> p.getShopid().equals(shopcd) && p.mall_code.equals(mall_code)).collect(Collectors.toList()).get(0);
        item.setCode(dto.code);
        item.setName(dto.getName());
        return item;
    }

    public String findCodeString(String shopcd, String mall_code) {
        String result = "";
        for (OrderCodeMapperDto dto : this.items) {
            if (!dto.getShopid().equals(shopcd) || !dto.getMall_code().trim().equals(mall_code)) continue;
            result = dto.getCode();
            break;
        }
        if (result == "") {
            result = mall_code;
        }
        return result;
    }

    public void setStatusShopMst(String code, ShopOrderMstDtoList list) {
        for (ShopOrderMstDto dto : list.getList()) {
            dto.setOrder_status(code);
        }
    }

    public void setMappingStatusShopMst(String shopID, ShopOrderMstDtoList list) {
        for (ShopOrderMstDto dto : list.getList()) {
            String code = this.findCodeString(shopID, dto.getOrder_status());
            dto.setOrder_status(code);
        }
    }

    public QuestionStatus bind() {
        this.items.clear();
        this.setCodeMapper();
        return this;
    }

    public void setCodeMapper() {
        block12: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuffer sql = new StringBuffer();
                    sql.append(" SELECT \r\n");
                    sql.append("IFNULL(SHOPID,  '' ) AS SHOPID,  \r\n");
                    sql.append("IFNULL(CODE,  '' ) AS CODE,  \r\n");
                    sql.append("IFNULL(MALL_CODE,  '' ) AS MALL_CODE,  \r\n");
                    sql.append("IFNULL(NAME,  '' ) AS NAME  \r\n");
                    sql.append(" FROM shopordstatus  \r\n");
                    pstmt = connection.prepareStatement(sql.toString().toUpperCase());
                    YDMAStringUtil.Print("[ShopOrderStatus]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        OrderCodeMapperDto dto = new OrderCodeMapperDto();
                        dto.setShopid(rs.getString("SHOPID"));
                        dto.setCode(rs.getString("CODE"));
                        dto.setMall_code(rs.getString("MALL_CODE"));
                        dto.setName(rs.getString("NAME"));
                        this.items.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    try {
                        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    class OrderCodeMapperDto {
        private String shopid;
        private String code;
        private String name;
        private String mall_code;

        OrderCodeMapperDto() {
        }

        public String getShopid() {
            return this.shopid;
        }

        public void setShopid(String shopid) {
            this.shopid = shopid;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMall_code() {
            return this.mall_code;
        }

        public void setMall_code(String mall_code) {
            this.mall_code = mall_code;
        }

        public QuestionStatus getInstance() {
            return instance;
        }
    }
}

