/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.coupang;

import com.coupang.openapi.sdk.Hmac;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.coupang.IShopOrderCoupangCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class CoupangOrderConfirmCommand
extends IShopOrderCoupangCommand {
    private static IShopOrderCommand instance = new CoupangOrderConfirmCommand();
    JsonParser parser = new JsonParser();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private CoupangOrderConfirmCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        String vendorid = param.get(0).getVendorId();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        OrderOkParm data2 = new OrderOkParm();
        data2.setVendorId(vendorid);
        List<Long> shipmentBoxIds = param.stream().map(p -> YDMAStringUtil.convertToLong(p.getCopy_idx())).collect(Collectors.toList());
        data2.setShipmentBoxIds(shipmentBoxIds);
        String json = mapper.writeValueAsString((Object)data2);
        List<ShopOrderMstDto> retlist = this.getApiList(param, json);
        return retlist;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<ShopOrderMstDto> getApiList(List<ShopOrderMstDto> param, String json) throws Exception {
        CloseableHttpClient client;
        CloseableHttpResponse response;
        ArrayList<ShopOrderMstDto> ret_list;
        block23: {
            List<ShopOrderMstDto> list;
            block24: {
                ret_list = new ArrayList<ShopOrderMstDto>();
                response = null;
                client = null;
                try {
                    String URL2 = "/v2/providers/openapi/apis/api/v4/vendors/%s/ordersheets/acknowledgement";
                    String acessKey = param.get(0).getAuthkey1();
                    String secretKey = param.get(0).getAuthKey2();
                    String vendorid = param.get(0).getVendorId();
                    URL2 = String.format(URL2, vendorid);
                    URIBuilder uriBuilder = new URIBuilder().setPath(URL2);
                    String authorization = Hmac.generate((String)"PATCH", (String)uriBuilder.build().toString(), (String)secretKey, (String)acessKey);
                    uriBuilder.setScheme("https").setHost("api-gateway.coupang.com").setPort(443);
                    StringEntity params = new StringEntity(json, "UTF-8");
                    HttpPatch requestPatch = new HttpPatch(uriBuilder.build().toString());
                    requestPatch.addHeader("Authorization", authorization);
                    requestPatch.addHeader("content-type", "application/json");
                    requestPatch.setEntity((HttpEntity)params);
                    client = HttpClients.createDefault();
                    response = client.execute((HttpUriRequest)requestPatch);
                    int status2 = response.getStatusLine().getStatusCode();
                    if (status2 != 200) break block23;
                    InputStream is = response.getEntity().getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    JsonObject resObject = this.parser.parse((Reader)br).getAsJsonObject();
                    JsonObject data2 = resObject.get("data").getAsJsonObject();
                    if (data2.size() > 0) {
                        JsonArray responseList = data2.get("responseList").getAsJsonArray();
                        for (JsonElement ele : responseList) {
                            JsonObject result = ele.getAsJsonObject();
                            String boxId = this.jsonElementNullStr(result.get("shipmentBoxId"));
                            boolean isSucced = result.get("succeed").getAsBoolean();
                            String resultMessage = this.jsonElementNullStr(result.get("resultMessage"));
                            for (ShopOrderMstDto dto : param) {
                                if (!dto.getCopy_idx().equals(boxId)) continue;
                                if (isSucced) {
                                    dto.setResult_code("1");
                                    dto.setResult_text("\uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                } else {
                                    dto.setResult_code("-1");
                                    dto.setResult_text(resultMessage);
                                }
                                ret_list.add(dto);
                            }
                        }
                        break block23;
                    }
                    param.get(0).setResult_code("0");
                    param.get(0).setResult_text("\uc870\ud68c\ud560 \ub370\uc774\ud0c0\uac00 \uc5c6\uc2b5\ub2c8\ub2e4. ");
                    list = param;
                    if (response == null) break block24;
                }
                catch (Exception e) {
                    try {
                        throw e;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (client == null) throw throwable;
                        try {
                            client.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (client == null) return list;
            try {
                client.close();
                return list;
            }
            catch (IOException iOException) {}
            return list;
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        if (client == null) return ret_list;
        try {
            client.close();
            return ret_list;
        }
        catch (IOException iOException) {}
        return ret_list;
    }

    static class OrderOkParm {
        private String vendorId;
        private List<Long> shipmentBoxIds;

        OrderOkParm() {
        }

        public String getVendorId() {
            return this.vendorId;
        }

        public void setVendorId(String vendorId) {
            this.vendorId = vendorId;
        }

        public List<Long> getShipmentBoxIds() {
            return this.shipmentBoxIds;
        }

        public void setShipmentBoxIds(List<Long> shipmentBoxIds) {
            this.shipmentBoxIds = shipmentBoxIds;
        }
    }
}

