/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.kdjsystem.mlink.shop.common.MarketPriceCalc;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDto;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.util.ArrayList;
import java.util.List;

public class ShopProductSendDto {
    List<ShopProductDto> shopProductDto;
    ShopProductAdditionDto productAdditionDto;
    ShoppingMallDetailDto shoppingMallDetailDto;
    WorkMngDto workMngDto;
    private boolean isManual = true;
    String workgrp = "";
    private int multicnt;
    private boolean Isshopprodin;
    private String mode = "";
    private List<String> updateFlag;

    public ShopProductSendDto() {
    }

    public ShopProductSendDto(List<ShopProductDto> shopProductDto, ShopProductAdditionDto productAdditionDto, ShoppingMallDetailDto shoppingMallDetailDto) {
        this.shopProductDto = shopProductDto;
        this.productAdditionDto = productAdditionDto;
        this.shoppingMallDetailDto = shoppingMallDetailDto;
        this.setWorkMngDto();
    }

    public WorkMngDto getWorkMngDto() {
        return this.workMngDto;
    }

    public void setWorkMngDto() {
        this.workMngDto = new WorkMngDto();
        this.workMngDto.setWorkgrp(this.workgrp);
        this.workMngDto.setCompno(YDMASessonUtil.getCompnoInfo().getCompno());
        this.workMngDto.setShopcd(this.shoppingMallDetailDto.getShopcd());
        this.workMngDto.setShopseq(this.shoppingMallDetailDto.getShopseq());
        this.workMngDto.setShop_user_id(this.shoppingMallDetailDto.getShoppingid());
        boolean isReg = this.shopProductDto.stream().allMatch(p -> YDMAStringUtil.convertToInt(p.getSendstats()) == 9000 || YDMAStringUtil.convertToInt(p.getSendstats()) == 6100 || YDMAStringUtil.convertToInt(p.getSendstats()) == 9100 || YDMAStringUtil.convertToInt(p.getSendstats()) == -9000);
        if (isReg) {
            this.workMngDto.setWorkcd("100");
            this.workMngDto.setWork_status("W01");
        } else {
            boolean ismodify = this.shopProductDto.stream().allMatch(p -> YDMAStringUtil.convertToInt(p.getSendstats()) == 4000 || YDMAStringUtil.convertToInt(p.getSendstats()) == 2000);
            if (ismodify) {
                boolean isSoldout = this.shopProductDto.stream().allMatch(p -> YDMAStringUtil.convertToInt(p.getSendstats()) == 4000);
                if (isSoldout) {
                    this.workMngDto.setWorkcd("500");
                    this.workMngDto.setWork_status("W01");
                } else {
                    this.workMngDto.setWorkcd("600");
                    this.workMngDto.setWork_status("W01");
                }
            } else {
                this.workMngDto.setWorkcd("200");
                this.workMngDto.setWork_status("W01");
            }
        }
        this.workMngDto.setWork_userid(YDMASessonUtil.getCompnoInfo().getUserId());
        this.workMngDto.setProgress_rate(0);
        ArrayList<WorkMngDetailDto> workMngDetailDtos = new ArrayList<WorkMngDetailDto>();
        for (ShopProductDto dto : this.shopProductDto) {
            WorkMngDetailDto workMngDetailDto = new WorkMngDetailDto();
            workMngDetailDto.setWorkgrp(this.workgrp);
            workMngDetailDto.setSeq(dto.getWorkseq());
            workMngDetailDto.setProdseq(dto.getCompayny_goods_cd());
            workMngDetailDto.setStatus("W01");
            workMngDetailDtos.add(workMngDetailDto);
        }
        this.workMngDto.setWork_detail(workMngDetailDtos);
    }

    public boolean isManual() {
        return this.isManual;
    }

    public void setManual(boolean isManual) {
        this.isManual = isManual;
    }

    public String getWorkgrp() {
        return this.workgrp;
    }

    public void setWorkgrp(String workgrp) {
        this.workgrp = workgrp;
    }

    public String getShopCd() {
        return this.shoppingMallDetailDto.getShopcd();
    }

    public int getMulticnt() {
        return this.multicnt;
    }

    public void setMulticnt(int multicnt) {
        this.multicnt = multicnt;
    }

    public boolean getIsshopprodin() {
        return this.Isshopprodin;
    }

    public void setIsshopprodin(boolean isshopprodin) {
        this.Isshopprodin = isshopprodin;
    }

    public String getMode() {
        return this.mode;
    }

    public void addUpdateFlag(String flag) {
        if (this.updateFlag == null) {
            this.updateFlag = new ArrayList<String>();
        }
        this.updateFlag.add(flag);
    }

    public List<String> getUpdateFlag() {
        return this.updateFlag;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<ShopProductDto> getShopProductDto() {
        return this.shopProductDto;
    }

    public void setShopProductDto(List<ShopProductDto> shopProductDto) {
        for (ShopProductDto dto : shopProductDto) {
            this.getMarketCalcate(YDMAStringUtil.convertToInt(dto.getLimit_price()), YDMAStringUtil.convertToInt(dto.getGoods_price()));
        }
        this.shopProductDto = shopProductDto;
    }

    public void setShopProductDto(ShopProductAdditionDto productAdditionDto, List<ShopProductDto> shopProductDto) {
        this.productAdditionDto = productAdditionDto;
        for (ShopProductDto dto : shopProductDto) {
            this.getMarketCalcate(YDMAStringUtil.convertToInt(dto.getLimit_price()), YDMAStringUtil.convertToInt(dto.getGoods_price()));
        }
        this.shopProductDto = shopProductDto;
    }

    public ShopProductAdditionDto getProductAdditionDto() {
        return this.productAdditionDto;
    }

    public void setProductAdditionDto(ShopProductAdditionDto productAdditionDto) {
        this.productAdditionDto = productAdditionDto;
    }

    public ShoppingMallDetailDto getShoppingMallDetailDto() {
        return this.shoppingMallDetailDto;
    }

    public void setShoppingMallDetailDto(ShoppingMallDetailDto shoppingMallDetailDto) {
        this.shoppingMallDetailDto = shoppingMallDetailDto;
    }

    public String getMarketCalcate(float compliancePrice, long testPrice) {
        if (this.productAdditionDto == null) {
            return String.valueOf(testPrice);
        }
        return MarketPriceCalc.get().setCompliancePrice(compliancePrice).setTestPrice(testPrice).setSellerDc(this.productAdditionDto.getSellerDc()).setDc(this.productAdditionDto.getDc()).setFlatDc(this.productAdditionDto.getFlatDc()).setMargin(this.productAdditionDto.getMargin()).setCommission(this.productAdditionDto.getCommission()).calculate().getConsumer_if_sale_price();
    }

    public static ResultMarketPrice getMarketCalcate(ShopProductAdditionDto productAdditionDto, float compliancePrice, long testPrice) {
        if (productAdditionDto == null) {
            ResultMarketPrice dto = new ResultMarketPrice();
            dto.setConsumer_if_sale_price(String.valueOf(testPrice));
            dto.setTotal_sale_discount(String.valueOf(testPrice));
            return dto;
        }
        return MarketPriceCalc.get().setCompliancePrice(compliancePrice).setTestPrice(testPrice).setSellerDc(productAdditionDto.getSellerDc()).setDc(productAdditionDto.getDc()).setFlatDc(productAdditionDto.getFlatDc()).setMargin(productAdditionDto.getMargin()).setCommission(productAdditionDto.getCommission()).calculate();
    }
}

