/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.alwayz;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzAccessToken;
import com.kdjsystem.mlink.shop.data.alwayz.ShopAlwayzQuestionContext;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.QuestListDto;
import java.net.URLEncoder;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Request;
import okhttp3.Response;

public class ShopAlwayzQuestionSearch
extends ShopAlwayzQuestionContext {
    JsonParser jsonParser = new JsonParser();

    @Override
    public List<QuestListDto> excute(List<QuestListDto> questListDto) throws Exception {
        ArrayList<QuestListDto> dtoArray = new ArrayList<QuestListDto>();
        try {
            String listtp = questListDto.get(0).getBtnstats().equals("\uc804\uccb4") ? "00" : (questListDto.get(0).getBtnstats().equals("\ubb38\uc758") ? "01" : "02");
            String token = AlwayzAccessToken.get().getAccessToken(questListDto.get(0).getShopid(), questListDto.get(0).getShopPw());
            Info itmeQuestionInfo = new Info();
            Info questionFromAdminInfo = new Info();
            String startDt = questListDto.get(0).getStartDt().substring(0, 4) + "-" + questListDto.get(0).getStartDt().substring(4, 6) + "-" + questListDto.get(0).getStartDt().substring(6, 8);
            String endDt = questListDto.get(0).getEndDt().substring(0, 4) + "-" + questListDto.get(0).getEndDt().substring(4, 6) + "-" + questListDto.get(0).getEndDt().substring(6, 8);
            itmeQuestionInfo.type = "ITEM_QUESTION";
            itmeQuestionInfo.dateRange.start = startDt;
            itmeQuestionInfo.dateRange.end = endDt;
            questionFromAdminInfo.type = "QUESTION_FROM_ADMIN";
            questionFromAdminInfo.dateRange.start = startDt;
            questionFromAdminInfo.dateRange.end = endDt;
            ObjectMapper mapper = new ObjectMapper();
            String itmeQuestionJson = mapper.writeValueAsString((Object)itmeQuestionInfo);
            String questionFromAdminJson = mapper.writeValueAsString((Object)questionFromAdminInfo);
            if (listtp.equals("00")) {
                this.Allinquiry(token, questListDto, itmeQuestionJson, dtoArray);
                this.Allinquiry(token, questListDto, questionFromAdminJson, dtoArray);
            } else if (listtp.equals("01")) {
                this.Allinquiry(token, questListDto, itmeQuestionJson, dtoArray);
            } else if (listtp.equals("02")) {
                this.Allinquiry(token, questListDto, questionFromAdminJson, dtoArray);
            }
        }
        catch (Exception e) {
            throw new Exception("\uc62c\uc6e8\uc774\uc988 \ubb38\uc758 \uc218\uc9d1 \uc911\uc5d0 \uc5d0\ub7ec \ubc1c\uc0dd :" + String.valueOf(e));
        }
        return dtoArray;
    }

    private List<QuestListDto> Allinquiry(String token, List<QuestListDto> questListDto, String json, List<QuestListDto> dtoArray) throws Exception {
        Request request2 = new Request.Builder().url("https://alwayz-seller-back.ilevit.com/sellers/questions-by-condition?condition=" + URLEncoder.encode(json, "UTF-8") + "&limit=-1&skip=0").header("Connection", "keep-alive").header("x-access-token", token).header("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/138.0.0.0 Safari/537.36").header("Content-Type", "application/json").get().build();
        Throwable throwable = null;
        Object var7_10 = null;
        try (Response response = AlwayzAccessToken.getOkhttpClient().newCall(request2).execute();){
            JsonObject jsonObject;
            int status2;
            if (response.isSuccessful() && (status2 = (jsonObject = (JsonObject)this.jsonParser.parse(response.body().string())).get("status").getAsInt()) == 200) {
                JsonArray dataArray = (JsonArray)jsonObject.get("data");
                if (dataArray.size() == 0) {
                    return dtoArray;
                }
                this.setNewOrdersData(dataArray, questListDto, dtoArray);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return dtoArray;
    }

    private List<QuestListDto> setNewOrdersData(JsonArray dataArray, List<QuestListDto> questListDto, List<QuestListDto> dtoArray) throws Exception {
        try {
            int i = 0;
            while (i < dataArray.size()) {
                QuestListDto dto = new QuestListDto();
                JsonObject object = (JsonObject)dataArray.get(i);
                JsonObject questionInfo = (JsonObject)object.get("questionInfo");
                dto.setQuests(questionInfo.get("text").getAsString());
                dto.setStat(questionInfo.get("type").getAsString().equals("item") ? "\uc0c1\ud488\ubb38\uc758" : (questionInfo.get("type").getAsString().equals("order") ? "\uc8fc\ubb38\ubb38\uc758" : ""));
                dto.setInsnm(questionInfo.get("userName").getAsString());
                dto.setQnaseq(questionInfo.get("questionId").getAsString());
                dto.setMprodid(object.get("itemId").getAsString());
                dto.setQgubun(questionInfo.get("type").getAsString().equals("order") ? questionInfo.get("mainReason").getAsString() : "\uc0c1\ud488 \ubb38\uc758");
                dto.setInsdm(this.dateFormat(questionInfo.get("createdAt").getAsString()));
                dto.setRegdm(YDMATimeUtil.getCurrentTime());
                dto.setShopid(questListDto.get(0).getShopid());
                dto.setShopnm(questListDto.get(0).getShopnm());
                dto.setProdnm(questionInfo.get("itemTitle").getAsString());
                dto.setSubject(questionInfo.has("title") && !questionInfo.get("title").isJsonNull() ? questionInfo.get("title").getAsString() : "\ubb38\uc758");
                dto.setOrdid(questionInfo.has("orderId") && !questionInfo.get("orderId").isJsonNull() ? questionInfo.get("orderId").getAsString() : "");
                if (object.has("answerInfo") && !object.get("answerInfo").isJsonNull()) {
                    JsonObject answerInfo = (JsonObject)object.get("answerInfo");
                    dto.setQnastat("103");
                    dto.setAnsws(answerInfo.get("text").getAsString());
                    dto.setSenddt(this.dateFormat(answerInfo.get("createdAt").getAsString()));
                } else {
                    dto.setQnastat("100");
                }
                dtoArray.add(dto);
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc62c\uc6e8\uc774\uc988 \uace0\uac1d\ubb38\uc758 \uc218\uc9d1 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtoArray;
    }

    private String dateFormat(String inputDate) {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX");
        DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(inputDate, inputFormatter);
        String formattedDate = zonedDateTime.format(outputFormatter);
        return formattedDate;
    }

    private class Info {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="dateRange")
        private DateRange dateRange = new DateRange();

        private Info() {
        }

        private class DateRange {
            @JsonProperty(value="start")
            private String start;
            @JsonProperty(value="end")
            private String end;

            private DateRange() {
            }
        }
    }
}

