/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.cafe24;

import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstNewDto;
import com.kdjsystem.mlink.shop.data.cafe24.IShopOrderCafe24Command;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class Cafe24LiteOrderCommand
extends IShopOrderCafe24Command {
    private static IShopOrderCommand instance = new Cafe24LiteOrderCommand();
    boolean flag;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private Cafe24LiteOrderCommand() {
    }

    @Override
    public List<ShopOrderMstNewDto> CompletedLite(ShopOrderMstNewDto dto) throws Exception {
        ArrayList<ShopOrderMstNewDto> retList = new ArrayList<ShopOrderMstNewDto>();
        String start = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String end = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        Map<String, String> cookies = this.getLoginCookieLite(dto);
        List<String> statusList = Arrays.asList("\ucde8\uc18c", "\uad50\ud658", "\ubc18\ud488");
        if (statusList.contains(dto.getSpecificStatus())) {
            this.getClaimList(dto, start, end, cookies, retList);
            return retList;
        }
        List<String> orderNoList = this.newOrder(dto, start, end, cookies);
        if (orderNoList.size() > 0) {
            this.getOrderList(dto, retList, cookies, orderNoList);
        }
        return retList;
    }

    private List<String> newOrder(ShopOrderMstNewDto dto, String start, String end, Map<String, String> cookies) throws Exception {
        ArrayList<String> orderNoList = new ArrayList<String>();
        String url = "https://" + dto.getShop_userid() + ".cafe24.com/admin/php/shop1/s_new/order_list.php";
        Connection conn = Jsoup.connect((String)url);
        conn.cookies(cookies).data("realclick", "T").data("tabclick", "F").data("queryString", "").data("navi_hide", "").data("searchPage", "AllOrder").data("menu_no", "74").data("sSearchDetailView", "F").data("searched_shop_no", "1").data("sIsBusanCallCenter", "").data("sOrderSearchLimit", "F").data("sOrderSearchLimitWhole", "F").data("sIsOrderSearchNotAllowed", "F").data("sIsSearchWordLength", "").data("searchTimeUsed", "F").data("bExistColdData", "").data("MSK[]", "order_id").data("MSV[]", "").data("date_type", "order_date").data("start_date", start).data("btnDate", "").data("year1", start.substring(0, 4)).data("month1", start.substring(5, 7)).data("day1", start.substring(8, 10)).data("end_date", end).data("year2", end.substring(0, 4)).data("month2", end.substring(5, 7)).data("day2", end.substring(8, 10)).data("today", YDMATimeUtil.getCurrentDateScheduler()).data("product_search_type", "product_name").data("order_product_text", "").data("order_product_no", "").data("find_option", "product_no");
        this.setOrderStatus(conn, dto.getSpecificStatus());
        conn.data("orderStatusNotPayCancel", "N").data("orderStatusCancel", "N").data("orderStatusExchange", "N").data("orderStatusReturn", "N").data("orderStatusRefund", "N").data("orderStatusPayment", "all").data("memberType", "1").data("shipment_type", "all").data("paystandard", "choice").data("product_total_price1", "").data("product_total_price2", "").data("item_count_start", "").data("item_count_end", "").data("paymethodType", "A").data("pgListType", "A").data("orderPathType", "A").data("inflowPathType", "A").data("main_search", "").data("mkSaleTypeChg", "").data("mkSaleType", "M").data("inflowPathDetail", "0000000000000000000000000000000000").data("radio11", "on").data("checkAllOrderPath", "on").data("searchSorting", "order_desc").data("rows", "500").referrer(url).method(Connection.Method.POST).followRedirects(true).ignoreContentType(true);
        Connection.Response rs = conn.execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements ele = doc.select("#searchResultList");
        Elements datas = ele.select("table");
        int i = 0;
        while (i < datas.size()) {
            String orderno = ((Element)datas.get(i)).select("tbody").attr("order_id");
            if (!orderno.equals("")) {
                orderNoList.add(orderno);
            }
            ++i;
        }
        return orderNoList;
    }

    private void setOrderStatus(Connection conn, String specificStatus) {
        switch (specificStatus) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                conn.data("orderStatus[]", "N10");
                break;
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                conn.data("orderStatus[]", "N20");
                conn.data("orderStatus[]", "N21");
                break;
            }
            case "\ubc30\uc1a1\uc911": {
                conn.data("orderStatus[]", "N30");
                break;
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                conn.data("orderStatus[]", "N40");
                break;
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                conn.data("orderStatus[]", "N50");
            }
        }
    }

    private void getOrderList(ShopOrderMstNewDto ordDto, List<ShopOrderMstNewDto> retList, Map<String, String> cookies, List<String> orderNoList) throws Exception {
        String urlTemplate = "https://%s.cafe24.com/admin/php/s_new/order_detail.php?order_id=%s&menu_no=2057";
        String userId = ordDto.getShop_userid();
        for (String orderno : orderNoList) {
            try {
                Document ordDtl = Jsoup.connect((String)String.format(urlTemplate, userId, orderno)).cookies(cookies).get();
                Elements hiddens = ordDtl.select("input[type=hidden]");
                Elements e_orders = ordDtl.select("#tabNumber > div.mBoard.typeOrder.gScroll.gCellSingle > table > tbody> tr");
                Elements payment = ordDtl.select(".detailView");
                Elements orderer = ordDtl.select("#QA_detail4 > div.mBoard > table > tbody > tr");
                Elements Recipient = ordDtl.select("#QA_detail5 > div.mBoard > table > tbody > tr");
                int j = 0;
                while (j < e_orders.size()) {
                    ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                    String orderNoSeq = this.removeTag(String.valueOf(((Element)((Element)e_orders.get(j)).select("td").get(1)).childNode(1)));
                    String optionName = this.removeTag(String.valueOf(((Element)((Element)e_orders.get(j)).select("td").get(3)).select(".productDisplay>li")));
                    dto.setOrder_status(this.removeTag(this.getStatus(((Element)((Element)e_orders.get(j)).select("td").get(9)).selectFirst("a").text())));
                    dto.setMall_exp_cd(orderNoSeq);
                    dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                    String orderdate = this.removeTag(((Element)ordDtl.select(".detail").get(1)).childNode(3).toString());
                    dto.setOrder_date(orderdate.substring(orderdate.indexOf(":") + 2));
                    dto.setShopid(ordDto.getShopid());
                    dto.setShop_userid(userId);
                    dto.setP_product_name(((Element)((Element)((Element)e_orders.get(j)).select("td").get(3)).select(".productDisplay").get(0)).text());
                    dto.setProduct_name(((Element)((Element)((Element)e_orders.get(j)).select("td").get(3)).select(".productDisplay").get(0)).text());
                    dto.setP_sku_value(optionName);
                    dto.setOrder_id(orderno);
                    dto.setSale_cnt(((Element)((Element)e_orders.get(j)).select("td").get(4)).text());
                    dto.setMall_product_id(((Element)((Element)e_orders.get(j)).select("td").get(3)).select(".eProductFrontView").attr("product_no"));
                    dto.setProduct_id(((Element)((Element)e_orders.get(j)).select("td").get(3)).select("a").attr("product_no"));
                    dto.setCopy_idx("");
                    dto.setWon_cost("0");
                    dto.setMall_won_cost("0");
                    dto.setSale_cost(((Element)((Element)e_orders.get(j)).select("td").get(5)).text().replace(",", ""));
                    dto.setDelv_cost(((Element)((Element)e_orders.get(j)).select("td").get(8)).text().substring(0, 5).replace(",", ""));
                    dto.setTotal_cost(((Element)((Element)e_orders.get(j)).select("td").get(6)).text().replace(",", ""));
                    dto.setPay_cost(((Element)payment.select(".total > li").get(2)).select("span").text().replace(",", ""));
                    dto.setBox_ea("0");
                    String orderid = ((Element)orderer.get(0)).select("td").text();
                    dto.setUser_id(orderid.substring(orderid.lastIndexOf("(") + 1, orderid.lastIndexOf(")")).trim());
                    dto.setUser_name(orderid.substring(0, orderid.indexOf("(") - 1).trim());
                    dto.setUser_tel(hiddens.select("input[name=o_phone1]").val().trim());
                    dto.setUser_cel(hiddens.select("input[name=o_phone2]").val().trim());
                    dto.setUser_email(hiddens.select("input[name=o_email]").val().trim());
                    dto.setReceive_name(((Node)((Node)((Element)Recipient.get(1)).childNodes().get(3)).childNodes().get(0)).toString().trim());
                    dto.setReceive_tel(hiddens.select("input[name=r_phone1]").val().trim());
                    dto.setReceive_cel(hiddens.select("input[name=r_phone2]").val().trim());
                    dto.setDelv_msg(Recipient.select("#DeliveryMemo").text());
                    dto.setDelivery_id("");
                    dto.setInvoice_no("");
                    dto.setLabel(((Element)((Element)e_orders.get(j)).select("td").get(9)).select("input[name=nom_no[]]").val());
                    dto.setCompno(ordDto.getCompno());
                    String delv = ((Element)((Element)payment.select(".bill").get(0)).select("span").get(1)).text();
                    if (!delv.equals("0")) {
                        dto.setDelivery_method_str2("");
                    } else {
                        dto.setDelivery_method_str2("\uc120\ubd88");
                    }
                    dto.setReceive_email("");
                    String addr = ((Element)Recipient.select("td[colspan=3]").get(2)).text();
                    dto.setReceive_zipcode(addr.substring(addr.indexOf("(") + 1, addr.indexOf(")")));
                    dto.setReceive_addr(addr.substring(addr.indexOf(")") + 2));
                    dto.setAuthkey1(ordDto.getAuthkey1());
                    dto.setResult_code("1");
                    retList.add(dto);
                    ++j;
                }
            }
            catch (Exception exception) {}
        }
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "\ubc30\uc1a1\uc900\ube44\uc911": 
            case "\uc0c1\ud488\uc900\ube44\uc911": 
            case "\ubc30\uc1a1\ub300\uae30": 
            case "\ubc30\uc1a1\ubcf4\ub958": {
                return "100";
            }
            case "\uc785\uae08\uc804": {
                return "";
            }
            case "\ubc30\uc1a1\uc911": {
                return "403";
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                return "410";
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                return "901";
            }
        }
        return "";
    }

    public String removeTag(String html) throws Exception {
        return html.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
    }

    private void getClaimList(ShopOrderMstNewDto dto, String start, String end, Map<String, String> cookies, List<ShopOrderMstNewDto> retList) throws Exception {
        switch (dto.getSpecificStatus()) {
            case "\ucde8\uc18c": {
                List<String> orderNoList = this.cancel(dto, start, end, cookies);
                if (orderNoList.size() <= 0) break;
                this.getClaimOrderList(dto, retList, cookies, orderNoList);
                break;
            }
            case "\uad50\ud658": {
                List<String> orderNoList = this.exChange(dto, start, end, cookies);
                if (orderNoList.size() <= 0) break;
                this.getClaimOrderList(dto, retList, cookies, orderNoList);
                break;
            }
            case "\ubc18\ud488": {
                List<String> orderNoList = this.ordReturn(dto, start, end, cookies);
                if (orderNoList.size() <= 0) break;
                this.getClaimOrderList(dto, retList, cookies, orderNoList);
            }
        }
    }

    private void getClaimOrderList(ShopOrderMstNewDto ordDto, List<ShopOrderMstNewDto> retList, Map<String, String> cookies, List<String> orderNoList) {
        String urlTemplate = "https://%s.cafe24.com/admin/php/s_new/order_detail.php?order_id=%s&menu_no=2057";
        String userId = ordDto.getShop_userid();
        String tab = "";
        boolean isReturn = false;
        switch (ordDto.getSpecificStatus()) {
            case "\ucde8\uc18c": {
                tab = "#tabCancel";
                break;
            }
            case "\ubc18\ud488": {
                tab = "#tabExchange";
                break;
            }
            case "\uad50\ud658": {
                tab = "#tabReturn";
                isReturn = true;
            }
        }
        for (String orderno : orderNoList) {
            try {
                Document ordDtl = Jsoup.connect((String)String.format(urlTemplate, userId, orderno)).cookies(cookies).get();
                Elements hiddens = ordDtl.select("input[type=hidden]");
                Elements e_orders = ordDtl.select(tab + " > div.mBoard.typeOrder.gScroll.gCellSingle > table > tbody> tr");
                Elements payment = ordDtl.select(".detailView");
                Elements orderer = ordDtl.select("#QA_detail4 > div.mBoard > table > tbody > tr");
                Elements Recipient = ordDtl.select("#QA_detail5 > div.mBoard > table > tbody > tr");
                int j = 0;
                while (j < e_orders.size()) {
                    ShopOrderMstNewDto dto = new ShopOrderMstNewDto();
                    String orderNoSeq = isReturn ? this.removeTag(String.valueOf(((Element)((Element)e_orders.get(j)).select("td").get(1)).childNode(1))) : this.removeTag(String.valueOf(((Element)((Element)e_orders.get(j)).select("td").get(0)).childNode(1)));
                    dto.setMall_exp_cd(orderNoSeq);
                    String status2 = isReturn ? this.removeTag(((Element)((Element)e_orders.get(j)).select("td").get(8)).selectFirst("a").text()) : this.removeTag(((Element)((Element)e_orders.get(j)).select("td").get(7)).selectFirst("a").text());
                    dto.setOrder_status(status2);
                    dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                    String orderdate = this.removeTag(((Element)ordDtl.select(".detail").get(1)).childNode(3).toString());
                    dto.setOrder_date(orderdate.substring(orderdate.indexOf(":") + 2));
                    dto.setShopid(ordDto.getShopid());
                    dto.setShop_userid(userId);
                    String productName = isReturn ? ((Element)((Element)((Element)e_orders.get(j)).select("td").get(3)).select(".productDisplay").get(0)).text() : ((Element)((Element)((Element)e_orders.get(j)).select("td").get(2)).select(".productDisplay").get(0)).text();
                    String optionName = isReturn ? this.removeTag(String.valueOf(((Element)((Element)e_orders.get(j)).select("td").get(3)).select(".productDisplay>li"))) : this.removeTag(String.valueOf(((Element)((Element)e_orders.get(j)).select("td").get(2)).select(".productDisplay>li")));
                    dto.setP_product_name(productName);
                    dto.setProduct_name(productName);
                    dto.setP_sku_value(optionName);
                    dto.setOrder_id(orderno);
                    String saleCnt = isReturn ? ((Element)((Element)e_orders.get(j)).select("td").get(4)).text() : ((Element)((Element)e_orders.get(j)).select("td").get(3)).text();
                    dto.setSale_cnt(saleCnt);
                    String mallProductId = isReturn ? ((Element)((Element)e_orders.get(j)).select("td").get(3)).select(".eProductFrontView").attr("product_no") : ((Element)((Element)e_orders.get(j)).select("td").get(2)).select(".eProductFrontView").attr("product_no");
                    dto.setMall_product_id(mallProductId);
                    String productId = isReturn ? ((Element)((Element)e_orders.get(j)).select("td").get(3)).select("a").attr("product_no") : ((Element)((Element)e_orders.get(j)).select("td").get(2)).select("a").attr("product_no");
                    dto.setProduct_id(productId);
                    Element td = isReturn ? (Element)((Element)e_orders.get(j)).select("td").get(5) : (Element)((Element)e_orders.get(j)).select("td").get(4);
                    String totalCost = td.ownText().replace(",", "");
                    String saleCost = td.select("span").text().replace(",", "").replace("(", "").replace(")", "");
                    String payCost = ((Element)payment.select(".total > li").get(2)).select("span").text().replace(",", "");
                    dto.setSale_cost(saleCost);
                    dto.setTotal_cost(totalCost);
                    dto.setPay_cost(payCost);
                    dto.setDelv_cost(String.valueOf(Integer.parseInt(payCost) - Integer.parseInt(totalCost)));
                    dto.setCopy_idx("");
                    dto.setWon_cost("0");
                    dto.setMall_won_cost("0");
                    dto.setBox_ea("0");
                    String orderid = ((Element)orderer.get(0)).select("td").text();
                    dto.setUser_id(orderid.substring(orderid.lastIndexOf("(") + 1, orderid.lastIndexOf(")")).trim());
                    dto.setUser_name(orderid.substring(0, orderid.indexOf("(") - 1).trim());
                    dto.setUser_tel(hiddens.select("input[name=o_phone1]").val().trim());
                    dto.setUser_cel(hiddens.select("input[name=o_phone2]").val().trim());
                    dto.setUser_email(hiddens.select("input[name=o_email]").val().trim());
                    dto.setReceive_name(((Node)((Node)((Element)Recipient.get(1)).childNodes().get(3)).childNodes().get(0)).toString().trim());
                    dto.setReceive_tel(hiddens.select("input[name=r_phone1]").val().trim());
                    dto.setReceive_cel(hiddens.select("input[name=r_phone2]").val().trim());
                    dto.setDelv_msg(Recipient.select("#DeliveryMemo").text());
                    dto.setDelivery_id("");
                    dto.setInvoice_no("");
                    dto.setCompno(ordDto.getCompno());
                    String delv = ((Element)((Element)payment.select(".bill").get(0)).select("span").get(1)).text();
                    if (!delv.equals("0")) {
                        dto.setDelivery_method_str2("");
                    } else {
                        dto.setDelivery_method_str2("\uc120\ubd88");
                    }
                    dto.setReceive_email("");
                    String addr = ((Element)Recipient.select("td[colspan=3]").get(2)).text();
                    dto.setReceive_zipcode(addr.substring(addr.indexOf("(") + 1, addr.indexOf(")")));
                    dto.setReceive_addr(addr.substring(addr.indexOf(")") + 2));
                    dto.setAuthkey1(ordDto.getAuthkey1());
                    dto.setResult_code("1");
                    retList.add(dto);
                    ++j;
                }
            }
            catch (Exception exception) {}
        }
    }

    private List<String> cancel(ShopOrderMstNewDto dto, String start, String end, Map<String, String> cookies) throws Exception {
        ArrayList<String> orderNoList = new ArrayList<String>();
        Connection.Response rs = Jsoup.connect((String)("https://" + dto.getShop_userid() + ".cafe24.com/admin/php/shop1/s/order_cancel.php")).cookies(cookies).data("realclick", "T").data("tabclick", "F").data("queryString", "").data("tabStatus", "all").data("searchPage", "order_cancel").data("menu_no", "76").data("sSearchDetailView", "F").data("searched_shop_no", "1").data("sIsBusanCallCenter", "").data("sOrderSearchLimit", "").data("sOrderSearchLimitWhole", "").data("sIsOrderSearchNotAllowed", "F").data("sIsSearchWordLength", "").data("searchTimeUsed", "F").data("bExistColdData", "").data("MSK[]", "order_id").data("MSV[]", "").data("date_type", "order_date").data("start_date", start).data("btnDate", "").data("year1", start.substring(0, 4)).data("month1", start.substring(5, 7)).data("day1", start.substring(8, 10)).data("end_date", end).data("year2", end.substring(0, 4)).data("month2", end.substring(5, 7)).data("day2", end.substring(8, 10)).data("today", YDMATimeUtil.getCurrentDateScheduler()).data("product_search_type", "product_name").data("order_product_text", "").data("order_product_no", "").data("find_option", "product_no").data("orderStatus[]", "all").data("orderStatus[]", "CR").data("orderStatus[]", "CD").data("orderStatus[]", "CC").data("memberType", "1").data("shipment_type", "all").data("paystandard", "choice").data("product_total_price1", "").data("product_total_price2", "").data("item_count_start", "").data("item_count_end", "").data("paymethodType", "A").data("pgListType", "A").data("orderPathType", "A").data("inflowPathType", "A").data("main_search", "").data("mkSaleTypeChg", "").data("mkSaleType", "M").data("inflowPathDetail", "0000000000000000000000000000000000").data("radio11", "on").data("checkAllOrderPath", "on").data("searchSorting", "order_desc").data("rows", "500").referrer("https://" + dto.getShop_userid() + ".cafe24.com/admin/php/shop1/s/order_cancel.php").method(Connection.Method.POST).followRedirects(true).ignoreContentType(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements ele = doc.select("#searchResultList");
        Elements datas = ele.select("tbody > tr");
        int i = 0;
        while (i < datas.size()) {
            String orderno = ((Element)datas.get(i)).select("input[name=order_id[]]").val();
            if (!orderno.equals("")) {
                orderNoList.add(orderno);
            }
            ++i;
        }
        return orderNoList;
    }

    private List<String> exChange(ShopOrderMstNewDto dto, String start, String end, Map<String, String> cookies) throws Exception {
        ArrayList<String> orderNoList = new ArrayList<String>();
        Connection.Response rs = Jsoup.connect((String)("https://" + dto.getShop_userid() + ".cafe24.com/admin/php/shop1/s/order_change.php")).cookies(cookies).data("date_type", "order_date").data("start_date", start).data("year1", start.substring(0, 4)).data("month1", start.substring(5, 7)).data("day1", start.substring(8, 10)).data("end_date", end).data("year2", end.substring(0, 4)).data("month2", end.substring(5, 7)).data("day2", end.substring(8, 10)).data("today", YDMATimeUtil.getCurrentDateScheduler()).data("realclick", "T").data("tabclick", "F").data("queryString", "").data("tabStatus", "all").data("cs_type", "exchange").data("searchPage", "order_change").data("menu_no", "77").data("sSearchDetailView", "F").data("searched_shop_no", "1").data("sIsBusanCallCenter", "").data("sOrderSearchLimit", "").data("sOrderSearchLimitWhole", "").data("sIsOrderSearchNotAllowed", "F").data("sIsSearchWordLength", "").data("searchTimeUsed", "F").data("bExistColdData", "").data("MSK[]", "order_id").data("MSV[]", "").data("orderStatus[]", "all").data("orderStatus[]", "ER").data("orderStatus[]", "ED").data("orderStatus[]", "EC").data("orderStatus[]", "ES").data("orderStatus[]", "EW").data("product_search_type", "product_name").data("order_product_text", "").data("order_product_no", "").data("find_option", "product_no").data("ShipCompanyId", "all").data("PostExpressReturn", "all").data("memberType", "1").data("shipment_type", "all").data("paystandard", "choice").data("product_total_price1", "").data("product_total_price2", "").data("item_count_start", "").data("item_count_end", "").data("paymethodType", "A").data("pgListType", "A").data("orderPathType", "A").data("inflowPathType", "A").data("main_search", "").data("mkSaleTypeChg", "").data("mkSaleType", "M").data("inflowPathDetail", "0000000000000000000000000000000000").data("radio11", "on").data("checkAllOrderPath", "on").data("searchSorting", "order_desc").data("rows", "500").referrer("https://" + dto.getShop_userid() + ".cafe24.com/admin/php/shop1/s/order_change.php").method(Connection.Method.POST).followRedirects(true).ignoreContentType(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements ele = doc.select("#QA_returnExchange2");
        Elements datas = ele.select("tbody > tr");
        int i = 0;
        while (i < datas.size()) {
            String orderno = ((Element)datas.get(i)).select("input[name=order_id[]]").val();
            if (!orderno.equals("")) {
                orderNoList.add(orderno);
            }
            ++i;
        }
        return orderNoList;
    }

    private List<String> ordReturn(ShopOrderMstNewDto dto, String start, String end, Map<String, String> cookies) throws Exception {
        ArrayList<String> orderNoList = new ArrayList<String>();
        Connection.Response rs = Jsoup.connect((String)("https://" + dto.getShop_userid() + ".cafe24.com/admin/php/shop1/s_new/order_returns.php")).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36").data("date_type", "order_date").data("start_date", start).data("year1", start.substring(0, 4)).data("month1", start.substring(5, 7)).data("day1", start.substring(8, 10)).data("end_date", end).data("year2", end.substring(0, 4)).data("month2", end.substring(5, 7)).data("day2", end.substring(8, 10)).data("today", YDMATimeUtil.getCurrentDateScheduler()).data("realclick", "T").data("tabclick", "F").data("queryString", "").data("tabStatus", "all").data("cs_type", "return").data("searchPage", "order_returns").data("menu_no", "78").data("sSearchDetailView", "F").data("searched_shop_no", "1").data("sIsBusanCallCenter", "").data("sOrderSearchLimit", "").data("sOrderSearchLimitWhole", "").data("sIsOrderSearchNotAllowed", "F").data("sIsSearchWordLength", "").data("searchTimeUsed", "F").data("bExistColdData", "").data("MSK[]", "order_id").data("MSV[]", "").data("orderStatus[]", "all").data("orderStatus[]", "RR").data("orderStatus[]", "RD").data("orderStatus[]", "RB").data("orderStatus[]", "RS").data("orderStatus[]", "RC").data("orderStatus[]", "RW").data("product_search_type", "product_name").data("order_product_text", "").data("order_product_no", "").data("find_option", "product_no").data("memberType", "1").data("ShipCompanyId", "all").data("PostExpressReturn", "all").data("shipment_type", "all").data("paystandard", "choice").data("paymethodType", "A").data("product_total_price1", "").data("product_total_price2", "").data("item_count_start", "").data("item_count_end", "").data("pgListType", "A").data("orderPathType", "A").data("inflowPathType", "A").data("main_search", "").data("mkSaleTypeChg", "").data("mkSaleType", "M").data("inflowPathDetail", "0000000000000000000000000000000000").data("radio11", "on").data("checkAllOrderPath", "on").data("searchSorting", "order_desc").data("rows", "500").referrer("https://" + dto.getShop_userid() + ".cafe24.com/admin/php/shop1/s_new/order_returns.php").method(Connection.Method.POST).followRedirects(true).ignoreContentType(true).execute();
        Document doc = Jsoup.parseBodyFragment((String)rs.body());
        Elements ele = doc.select("#QA_returnReturn2");
        Elements datas = ele.select("tbody > tr");
        int i = 0;
        while (i < datas.size()) {
            String orderno = ((Element)datas.get(i)).select("input[name=order_id[]]").val();
            if (!orderno.equals("")) {
                orderNoList.add(orderno);
            }
            ++i;
        }
        return orderNoList;
    }
}

