/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.tossShopping.IShopOrderTossShoppingCommand;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class TossShoppingOrderExpressCommand
extends IShopOrderTossShoppingCommand {
    private static IShopOrderCommand instance = new TossShoppingOrderExpressCommand();

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private TossShoppingOrderExpressCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        try {
            String id = param.get(0).getShop_userid();
            String pw = param.get(0).getShopPw();
            String merchantId = param.get(0).getApikey();
            cookies = is.getTossCookiesExistMerchantID(id, pw, merchantId);
            for (ShopOrderMstDto dto : param) {
                try {
                    List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
                    String deliveryCompanyName = datasource.stream().filter(d -> d.getDlvID().equals(dto.getDelivery_id())).map(ShopDeliveryDto::getDivNM).findFirst().orElse(null);
                    if (deliveryCompanyName == null) {
                        dto.setResult_code("-1");
                        dto.setResult_text("\ubc30\uc1a1\uc0ac \uc815\ubcf4\ub97c \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                        retList.add(dto);
                        continue;
                    }
                    JsonObject requestBody = new JsonObject();
                    requestBody.addProperty("merchantId", dto.getApikey());
                    requestBody.addProperty("orderProductId", dto.getMall_order_id());
                    requestBody.addProperty("deliveryCompany", deliveryCompanyName);
                    requestBody.addProperty("shippingTrackingNumber", dto.getInvoice_no());
                    Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/order/shipping-number").cookies(cookies).header("Content-Type", "application/json").requestBody(requestBody.toString()).method(Connection.Method.PUT).ignoreContentType(true).execute();
                    if (response.body().contains("\"success\":true")) {
                        dto.setResult_code("1");
                        dto.setResult_text("\uc815\uc0c1 \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                        dto.setOrder_status("403");
                    } else {
                        JsonParser parser = new JsonParser();
                        JsonObject object = (JsonObject)parser.parse(response.body());
                        object = object.getAsJsonObject("error");
                        String errorType = object.get("errorType").getAsString();
                        String reason = object.get("reason").getAsString();
                        dto.setResult_code("-1");
                        dto.setResult_text("\ubc1c\uc1a1 \uc2e4\ud328 :" + reason + errorType);
                    }
                }
                catch (Exception e) {
                    dto.setResult_code("-1");
                    dto.setResult_text("\ucc98\ub9ac \uc911 \uc608\uc678 \ubc1c\uc0dd: " + e.getMessage());
                }
                retList.add(dto);
            }
        }
        catch (Exception e) {
            throw new Exception("\ud1a0\uc2a4\uc1fc\ud551 \ubc30\uc1a1\ucc98\ub9ac \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.", e);
        }
        return retList;
    }
}

