/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.job;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.coupang.CoupangExitsProductCd;
import com.kdjsystem.mlink.shop.dao.CoupangItemWinnerRequestDTO;
import com.kdjsystem.mlink.shop.dao.CoupangReturnProductRequestDTO;
import com.kdjsystem.mlink.shop.dao.MallDTO;
import com.kdjsystem.mlink.shop.dao.NaverCatalogRequestDTO;
import com.kdjsystem.mlink.shop.dao.NaverCatalogViewDataRequestDTO;
import com.kdjsystem.mlink.shop.dao.NaverSearchRequestDTO;
import com.kdjsystem.mlink.shop.dao.ProductSchedulerSyncDTO;
import com.kdjsystem.mlink.shop.dao.RegProductOption;
import com.kdjsystem.mlink.shop.dao.ResultDto;
import com.kdjsystem.mlink.shop.dao.SchSearchOptionDTO;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDao;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductShortDto;
import com.kdjsystem.mlink.shop.dao.ShopWorkDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.data.Melchi.MelchiExitsProductCd;
import com.kdjsystem.mlink.shop.data.Tmon.TmonExitsProductCd;
import com.kdjsystem.mlink.shop.data.alwayz.AlwayzExitsProductCd;
import com.kdjsystem.mlink.shop.data.auction.AuctionExitsProductCd;
import com.kdjsystem.mlink.shop.data.cafe24.Cafe24ExistProductCd;
import com.kdjsystem.mlink.shop.data.elevenst.ElevenstExitsProductCd;
import com.kdjsystem.mlink.shop.data.interpark.InterparkExitsProductCd;
import com.kdjsystem.mlink.shop.data.kakaostore.KakaoExitsProductCd;
import com.kdjsystem.mlink.shop.data.lotteon.LotteOnExitsProductCd;
import com.kdjsystem.mlink.shop.data.naverstore.NaverisExitsProductCd;
import com.kdjsystem.mlink.shop.data.ssgmarket.SsgmarketExitsProductCd;
import com.kdjsystem.mlink.shop.data.tossShopping.tossShoppingExitsProductCd;
import com.kdjsystem.mlink.shop.data.wemakeprice.WemarketExitsProductCd;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkProductConnection;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class JobProduct
implements Job {
    private static volatile boolean isCanceled = false;
    IShopCommonLogin i = new IShopCommonLogin(){};
    String userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36";
    JsonParser jsonparser = new JsonParser();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        YDMAProgressBar.get().setOperationCanceledListener(new YDMAProgressBar.OperationCanceledListener(){

            @Override
            public void onOperationCanceled() {
                isCanceled = true;
            }
        });
        JobDataMap data2 = context.getJobDetail().getJobDataMap();
        String group = (String)data2.get((Object)"WORK_GROUP");
        String execKey = (String)data2.get((Object)"EXEC_KEY");
        List<String> macAddressList = IShopCommonLogin.getLocalMacAddressListNotVirtual();
        if (!macAddressList.contains(execKey)) {
            return;
        }
        if (group.contains("OLD_PROD")) {
            List schedulerInfos = (List)data2.get((Object)"PRODUCT");
            this.changeProductState(schedulerInfos);
        } else if (group.contains("SYNC")) {
            List syncInfos = (List)data2.get((Object)"PRODUCT");
            this.syncProduct(syncInfos);
        } else if (group.contains("CLEAR")) {
            List schedulerInfos = (List)data2.get((Object)"PRODUCT");
            this.clearProductInfo(schedulerInfos);
        }
    }

    private void changeProductState(List<ScheduleInfoDto> schedulerInfos) {
        YDMAProgressBar console = new YDMAProgressBar();
        console.startToBack("\uc2a4\ucf00\uc974\ub7ec(\uc0c1\ud488)", 100, 100, true);
        String shopString = "";
        try {
            List<ShoppingMallDetailDto> shopInfos = ShopCommonDao.get().ShoppingMallDetailList();
            ScheduleInfoDto oneScheduInfo = schedulerInfos.get(0);
            if (oneScheduInfo.getSitechk().equals("Y")) {
                this.oldModifyProcess(console, schedulerInfos, shopInfos);
                if (oneScheduInfo.getAutoprodregchk().equals("Y")) {
                    this.regProcess(console, schedulerInfos, shopInfos);
                }
            }
            if (oneScheduInfo.getCoupprodchk().equals("Y")) {
                this.coupangItemWinnerProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getCoupprodchk2().equals("Y")) {
                this.coupangReturnItemProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getCoupprodchk3().equals("Y")) {
                this.coupangExposureLimitItemProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getNaverprodchk().equals("Y")) {
                this.naverCatalogProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getNaverprodchk2().equals("Y")) {
                this.naverDiscountItemProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getNaverstopsellingprodchk().equals("Y")) {
                this.naverStopSellingItemProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getTossprodchk().equals("Y")) {
                this.tossReturnItemProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getMelprodchk().equals("Y")) {
                this.melchiWaitItemProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getElevenstprodchk().equals("Y")) {
                this.elevenstDuplicationProductProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getElevenstprodchk2().equals("Y")) {
                this.elevenstCleanProductProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getElevenststopsellingprodchk().equals("Y")) {
                this.elevenstStopSellingProductProcess(console, schedulerInfos, shopInfos);
            }
            if (oneScheduInfo.getKakaostoreprodchk().equals("Y")) {
                this.kakaoStoreStopProductProcess(console, schedulerInfos, shopInfos);
            }
            console.setValueBack("\uc124\uc815\ud558\uc2e0 \ubaa8\ub4e0 \uc2a4\ucf00\uc974\ub7ec \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 100);
            console.setValueBack("5\ucd08 \ud6c4 \ucc3d\uc774 \uc790\ub3d9\uc73c\ub85c \ub2eb\ud799\ub2c8\ub2e4.", 100);
            InterruptSource.Thread.sleep((long)5000L);
            console.end();
        }
        catch (Exception e) {
            console.setValueBack(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 100);
            console.end();
        }
    }

    private void oldModifyProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValueBack("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \ud310\ub9e4\uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 14);
        int totalCount = schedulerInfos.size();
        int processedCount = 0;
        String shopString = "";
        try {
            for (ScheduleInfoDto schedulerInfo : schedulerInfos) {
                shopString = this.getShopString(schedulerInfo, shopInfos);
                List<ShopProductDto> sendseqs = ShopProductDao.get().getProductDeleteSchedulerList(schedulerInfo.getShopcd(), schedulerInfo.getShopseq(), Integer.parseInt(schedulerInfo.getExcludeDate()), schedulerInfo.getProdQty());
                if (sendseqs.size() <= 0) continue;
                int result = 0;
                for (ShopProductDto sendseq : sendseqs) {
                    result += ShopCommonDao.get().setProductStatusIn(sendseq, 7000);
                    int progress = (int)((double)(++processedCount) * 100.0 / (double)totalCount);
                    String comment = String.format(" %s [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, sendseq.getCompayny_goods_cd());
                    console.setValueBackAndJobLogForProdIn(comment, progress, sendseq, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", "[\uc2a4\ucf00\uc974\ub7ec] \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                }
                console.setValueBack(String.format("%s %s\uac74\uc758 \uc0c1\ud488\uc744 \uc218\uc815\ub300\uae30\ub85c \ubcc0\uacbd\ud588\uc2b5\ub2c8\ub2e4.", shopString, result), 14);
            }
            console.setValueBack("--------------------------------------------------------------------------------------", 14);
            console.setValueBack("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \ud310\ub9e4\uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \r\n", 14);
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd : %s", shopString, e.getMessage()), 14);
        }
    }

    private void regProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        console.setValueBack("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \uc0c1\ud488 \uc790\ub3d9 \ub4f1\ub85d\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 28);
        String shopString = "";
        try {
            String runId = UUID.randomUUID().toString();
            ShopWorkDao.get().setSchProdinfoDeleteByNotCompno(runId);
            ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
            for (ScheduleInfoDto schedulerInfo : schedulerInfos) {
                try {
                    shopString = this.getShopString(schedulerInfo, shopInfos);
                    console.setValueBack(shopString + " \uc790\ub3d9 \ub4f1\ub85d \ud504\ub85c\uc138\uc2a4\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", 20);
                    if (schedulerInfo.getRegqty() == 0 || schedulerInfo.getAddition_seq() < 1) {
                        console.setValueBack(shopString + " \ub4f1\ub85d \uac1c\uc218 0\uc774\uac70\ub098 \ubd80\uac00\uc815\ubcf4\uac00 \uc124\uc815\ub418\uc9c0 \uc54a\uc544 \uc791\uc5c5\uc5d0\uc11c \uc81c\uc678\ub429\ub2c8\ub2e4.", 20);
                        continue;
                    }
                    console.setValueBack(shopString + " \ub4f1\ub85d\ud560 \uc0c1\ud488 " + schedulerInfo.getRegqty() + "\uac74\uc744 DB\uc5d0\uc11c \uc870\ud68c\ud569\ub2c8\ub2e4.", 20);
                    SchSearchOptionDTO schSearchOptionDTO = ScheduleInfoDao.get().selectSch_search_option(schedulerInfo.getSearch_option_seq());
                    int sendState = 0;
                    if (schedulerInfo.getReg_target().equals("WAIT")) {
                        sendState = 9000;
                    } else if (schedulerInfo.getReg_target().equals("SELF")) {
                        sendState = 6100;
                    } else {
                        if (!schedulerInfo.getReg_target().equals("")) continue;
                        sendState = schSearchOptionDTO.getShopsendstatus();
                    }
                    List<Object> prods = new ArrayList();
                    prods = schedulerInfo.getSearch_option_seq() != 0 ? ShopProductDao.get().getShopProductInfoList(schSearchOptionDTO.getDomemall(), schSearchOptionDTO.getFolder(), schSearchOptionDTO.getCategory(), schSearchOptionDTO.getSearch_gubun(), schSearchOptionDTO.getSearch_text(), schSearchOptionDTO.getDate_from(), schSearchOptionDTO.getDate_to(), schedulerInfo.getRegqty(), 1, "U", schedulerInfo.getShopcd(), schedulerInfo.getShopseq(), sendState, true, runId) : ShopProductDao.get().getShopProductInfoList("", "", "", "COMPAYNY_GOODS_CD", "", "", "", schedulerInfo.getRegqty(), 1, "U", schedulerInfo.getShopcd(), schedulerInfo.getShopseq(), sendState, true, runId);
                    console.setValueBack(shopString + " DB\uc5d0\uc11c \uc870\uac74\uc5d0 \ub9de\ub294 " + prods.size() + "\uac74\uc774 \uc870\ud68c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", 20);
                    prods = MLinkCommon.get().getCategorysShopCidSetting(null, prods);
                    ArrayList<MallDTO> malls = new ArrayList<MallDTO>();
                    malls.add(new MallDTO(schedulerInfo.getShopcd(), schedulerInfo.getShopseq(), String.valueOf(schedulerInfo.getAddition_seq())));
                    List<ShopProductDto> filterProds = MLinkProductConnection.get().getQueueRegProductSendList(prods, malls);
                    if (filterProds == null || filterProds.size() == 0) {
                        console.setValueBack(shopString + " \uc791\uc5c5\ub9ac\uc2a4\ud2b8\uc5d0 \ub4f1\ub85d\ud560 \uac74\uc774 \uc5c6\uc2b5\ub2c8\ub2e4. \ub2e4\uc74c \uc1fc\ud551\ubab0 \uc791\uc5c5\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 20);
                        continue;
                    }
                    console.setValueBack(shopString + " \uce74\ud14c\uace0\ub9ac \ubc0f \uc791\uc5c5 \ub9ac\uc2a4\ud2b8 \ud544\ud130\ub9c1 \uc644\ub8cc(\uc720\uc9c0 " + filterProds.size() + "\uac74)", 20);
                    ResultDto ret = MLinkProductConnection.get().sendQueueRegProduct(malls, shopInfos, filterProds, conf, new RegProductOption("N", "N", "N", "N"), console, shopString);
                    List<Object> filters = new ArrayList();
                    List sendList = (List)ret.getItems();
                    if (sendList != null) {
                        List sendProdNums = sendList.stream().map(p -> p.getCompayny_goods_cd()).collect(Collectors.toList());
                        filters = filterProds.stream().filter(p -> !sendProdNums.contains(p.getCompayny_goods_cd())).collect(Collectors.toList());
                    } else {
                        filters = filterProds;
                    }
                    ShopWorkDao.get().setSchProdinfoInsert(runId, filterProds);
                    int sendSize = sendList != null ? sendList.size() : 0;
                    int filterSize = filters != null ? filters.size() : 0;
                    console.setValueBack(String.format("%s %s\uac74\uc758 \uc0c1\ud488\uc774 \uc791\uc5c5\ub9ac\uc2a4\ud2b8\uc5d0 \ub4f1\ub85d\ub418\uace0 %s\uac74\uc774 \ud544\ud130\ub9c1 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, sendSize, filterSize), 28);
                    console.setValueBack(shopString + " 10\ucd08 \ub300\uae30 \ud6c4 \uc2dc\uc791\ud569\ub2c8\ub2e4.", 28);
                    InterruptSource.Thread.sleep((long)10000L);
                }
                catch (Exception e) {
                    console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd : %s", shopString, e.getMessage()), 28);
                }
            }
            ShopWorkDao.get().setSchProdinfoDeleteByNotCompno(runId);
            console.setValueBack("--------------------------------------------------------------------------------------", 28);
            console.setValueBack("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \uc0c1\ud488 \uc790\ub3d9 \ub4f1\ub85d\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc791\uc5c5\uad00\ub9ac \uba54\ub274\uc5d0\uc11c \ub4f1\ub85d \ub0b4\uc5ed\uc744 \ud655\uc778\ud558\uc2e4 \uc218 \uc788\uc2b5\ub2c8\ub2e4. \r\n", 28);
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd : %s", shopString, e.getMessage()), 28);
        }
    }

    private void coupangItemWinnerProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 42;
        console.setValueBack("[INFO] \ucfe0\ud321 \uc544\uc774\ud15c\uc704\ub108\uac00 \uc544\ub2cc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \uc544\uc774\ud15c\uc704\ub108\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List coupangInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0075")).collect(Collectors.toList());
            if (coupangInfos != null) {
                for (ShoppingMallDetailDto coupangInfo : coupangInfos) {
                    List<String> shopprodnos;
                    shopString = this.getShopString(coupangInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \uc544\uc774\ud15c\uc704\ub108\uac00 \uc544\ub2cc \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    Map<String, String> cookies = this.getCookie(console, coupangInfo, shopString);
                    if (cookies == null) continue;
                    ArrayList<String> notExistMlinkShopprodno = new ArrayList<String>();
                    int page = 0;
                    do {
                        shopprodnos = this.getCoupangItemWinnerProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(coupangInfo.getShopcd(), coupangInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \ucfe0\ud321 \uc0ad\uc81c\ud56d\ubaa9\uc73c\ub85c \ubd84\ub958\ub418\uc5b4 \uc0ad\uc81c\ub429\ub2c8\ub2e4.", shopString, shopprodno), value);
                            notExistMlinkShopprodno.add(shopprodno);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                    if (notExistMlinkShopprodno.size() <= 0) continue;
                    console.setValueBack("\uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc740 \uc544\uc774\ud15c\uc704\ub108\uac00 \uc544\ub2cc \uc0c1\ud488  " + notExistMlinkShopprodno.size() + "\uac74\uc758 \uc0ad\uc81c \ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                    cookies = this.getCookie(console, coupangInfo, shopString);
                    this.coupangDirectDelete(cookies, notExistMlinkShopprodno, console, value, coupangInfo, shopString, logMsg);
                }
            }
            console.setValueBack("--------------------------------------------------------------------------------------", value);
            console.setValueBack("[INFO] \ucfe0\ud321 \uc544\uc774\ud15c\uc704\ub108\uac00 \uc544\ub2cc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \r\n", value);
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), value);
        }
    }

    private void coupangReturnItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 86;
        console.setValueBack("[INFO] \ucfe0\ud321 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \ubc18\ub824\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List coupangInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0075")).collect(Collectors.toList());
            if (coupangInfos != null) {
                for (ShoppingMallDetailDto coupangInfo : coupangInfos) {
                    List<String> shopprodnos;
                    shopString = this.getShopString(coupangInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    Map<String, String> cookies = this.getCookie(console, coupangInfo, shopString);
                    if (cookies == null) continue;
                    ArrayList<String> notExistMlinkShopprodno = new ArrayList<String>();
                    int page = 1;
                    do {
                        shopprodnos = this.getCoupangReturnProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(coupangInfo.getShopcd(), coupangInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, prodIn.getCompayny_goods_cd());
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \ucfe0\ud321 \uc0ad\uc81c\ud56d\ubaa9\uc73c\ub85c \ubd84\ub958\ub418\uc5b4 \uc0ad\uc81c\ub429\ub2c8\ub2e4.", shopString, shopprodno), value);
                            notExistMlinkShopprodno.add(shopprodno);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                    if (notExistMlinkShopprodno.size() <= 0) continue;
                    console.setValueBack("\uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc740 \ucfe0\ud321 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \ucd1d " + notExistMlinkShopprodno.size() + "\uac74\uc758 \uc0ad\uc81c \ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                    cookies = this.getCookie(console, coupangInfo, shopString);
                    this.coupangDirectDelete(cookies, notExistMlinkShopprodno, console, value, coupangInfo, shopString, logMsg);
                }
            }
            console.setValueBack("--------------------------------------------------------------------------------------", value);
            console.setValueBack("[INFO] \ucfe0\ud321 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \r\n", value);
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), value);
        }
    }

    private void coupangExposureLimitItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 86;
        console.setValueBack("[INFO] \ucfe0\ud321 \ub178\ucd9c\uc81c\ud55c \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \ub178\ucd9c\uc81c\ud55c\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List coupangInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0075")).collect(Collectors.toList());
            if (coupangInfos != null) {
                for (ShoppingMallDetailDto coupangInfo : coupangInfos) {
                    List<String> shopprodnos;
                    shopString = this.getShopString(coupangInfo);
                    console.setValueBack(String.format("[%s] \uc1fc\ud551\ubab0\uc758 \ub178\ucd9c\uc81c\ud55c \uc0c1\ud0dc \uc0c1\ud488 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    Map<String, String> cookies = this.getCookie(console, coupangInfo, shopString);
                    if (cookies == null) continue;
                    ArrayList<String> notExistMlinkShopprodno = new ArrayList<String>();
                    int page = 0;
                    do {
                        shopprodnos = this.getCoupangExposureLimitProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(coupangInfo.getShopcd(), coupangInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \ucfe0\ud321 \uc0ad\uc81c\ud56d\ubaa9\uc73c\ub85c \ubd84\ub958\ub418\uc5b4 \uc0ad\uc81c\ub429\ub2c8\ub2e4.", shopString, shopprodno), value);
                            notExistMlinkShopprodno.add(shopprodno);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                    if (notExistMlinkShopprodno.size() <= 0) continue;
                    console.setValueBack("\uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc740 \ub178\ucd9c\uc81c\ud55c \uc0c1\ud488 \ucd1d  " + notExistMlinkShopprodno.size() + "\uac74\uc758 \uc0ad\uc81c \ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                    cookies = this.getCookie(console, coupangInfo, shopString);
                    this.coupangDirectDelete(cookies, notExistMlinkShopprodno, console, value, coupangInfo, shopString, logMsg);
                }
            }
            console.setValueBack("--------------------------------------------------------------------------------------", value);
            console.setValueBack("[INFO] \ucfe0\ud321 \ub178\ucd9c\uc81c\ud55c \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \r\n", value);
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), value);
        }
    }

    private void naverCatalogProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 56;
        console.setValueBack("[INFO] \ub124\uc774\ubc84 \uce74\ud0c8\ub85c\uadf8 \uac00\uaca9\uad00\ub9ac \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \uce74\ud0c8\ub85c\uadf8\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List naverInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0055")).collect(Collectors.toList());
            if (naverInfos != null) {
                for (ShoppingMallDetailDto naverInfo : naverInfos) {
                    List<String> shopprodnos;
                    shopString = this.getShopString(naverInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \uce74\ud0c8\ub85c\uadf8 \uac00\uaca9\uad00\ub9ac \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    Map<String, String> cookies = this.getCookie(console, naverInfo, shopString);
                    if (cookies == null) continue;
                    int page = 0;
                    do {
                        shopprodnos = this.getNaverCatalogProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(naverInfo.getShopcd(), naverInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4\uc5d0\uc11c \uc9c1\uc811 \uc0ad\uc81c \ucc98\ub9ac\ud569\ub2c8\ub2e4.", shopString, shopprodno), value);
                            this.naverProductDelete(cookies, shopprodno, console, value, naverInfo, shopString, logMsg);
                            InterruptSource.Thread.sleep((long)300L);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                }
                console.setValueBack("--------------------------------------------------------------------------------------", value);
                console.setValueBack("[INFO] \ub124\uc774\ubc84 \uce74\ud0c8\ub85c\uadf8 \uac00\uaca9\uad00\ub9ac \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4  \r\n", value);
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), value);
        }
    }

    private void tossReturnItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 72;
        console.setValueBack("[INFO] \ud1a0\uc2a4\uc1fc\ud551 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] \ud1a0\uc2a4 \ubc18\ub824\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List tossInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop9982")).collect(Collectors.toList());
            if (tossInfos != null) {
                for (ShoppingMallDetailDto tossInfo : tossInfos) {
                    List<String> shopprodnos;
                    shopString = this.getShopString(tossInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    Map<String, String> cookies = this.getCookie(console, tossInfo, shopString);
                    int page = 0;
                    String[] merchantInfo = this.getMerchantID(cookies, tossInfo);
                    String merchantID = merchantInfo[0];
                    String merchantUserID = merchantInfo[1];
                    ArrayList<Integer> notExistMlinkShopprodno = new ArrayList<Integer>();
                    do {
                        shopprodnos = this.getTossReturnProducts(cookies, tossInfo, page, merchantID);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(tossInfo.getShopcd(), tossInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \ud1a0\uc2a4 \uc0ad\uc81c\ud56d\ubaa9\uc73c\ub85c \ubd84\ub958\ub418\uc5b4 \uc0ad\uc81c\ub429\ub2c8\ub2e4.", shopString, shopprodno), value);
                            notExistMlinkShopprodno.add(Integer.parseInt(shopprodno));
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                    if (notExistMlinkShopprodno.size() <= 0) continue;
                    console.setValueBack("\uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc740 \ud1a0\uc2a4\ubc18\ub824 \uc0c1\ud488 \ucd1d  " + notExistMlinkShopprodno.size() + "\uac74 \uc0ad\uc81c\ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                    this.sendDeleteRequestsToToss(cookies, notExistMlinkShopprodno, merchantID, merchantUserID, console, value, tossInfo, shopString, logMsg);
                }
            }
            console.setValueBack("--------------------------------------------------------------------------------------", value);
            console.setValueBack("[INFO] \ud1a0\uc2a4\uc1fc\ud551 \ubc18\ub824\uc0c1\ud0dc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \r\n", value);
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), value);
        }
    }

    private void melchiWaitItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 99;
        console.setValueBack("[INFO] \uba78\uce58\uc1fc\ud551 \ud310\ub9e4\ub300\uae30 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        Object shopString = "";
        try {
            List melchiInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0106")).collect(Collectors.toList());
            if (melchiInfos != null) {
                for (ShoppingMallDetailDto melchiInfo : melchiInfos) {
                    String start;
                    List<String> shopprodnos;
                    String shopName = ShopCommon.getShoppingMallName(melchiInfo.getShopcd());
                    String shopNickName = melchiInfo.getNicknm1();
                    shopString = shopName + "-" + shopNickName;
                    console.setValueBack(String.format("[%s] \uc1fc\ud551\ubab0\uc758 \ud310\ub9e4\ub300\uae30 \uc0c1\ud488 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    String standardDate = YDMATimeUtil.getDateMinusDays(30);
                    Map<String, String> cookies = this.getCookie(console, melchiInfo, (String)shopString);
                    if (cookies == null) continue;
                    while ((shopprodnos = this.getMelchiWaitProducts(cookies, start = YDMATimeUtil.subtractDays(standardDate, 30), standardDate)).size() > 0) {
                        ArrayList<String> notExistMlinkShopprodno = new ArrayList<String>();
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(melchiInfo.getShopcd(), melchiInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                console.setValueBack(String.format("[%s] \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\uc744 \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.", shopString), value);
                                console.setValueBack(String.format("  - \uc0c1\ud488\ubc88\ud638: %s", shopprodno), value);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format("[%s] \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \uba78\uce58 \uc0ad\uc81c\ud56d\ubaa9\uc73c\ub85c \ubd84\ub958\ub418\uc5b4 \uc0ad\uc81c\ub429\ub2c8\ub2e4.", shopString), value);
                            console.setValueBack(String.format("  - \uc0c1\ud488\ubc88\ud638: %s", shopprodno), value);
                            notExistMlinkShopprodno.add(shopprodno);
                        }
                        if (notExistMlinkShopprodno.size() > 0) {
                            int n = 1;
                            console.setValueBack("\uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc740\uba78\uce58 \ud310\ub9e4\ub300\uae30 \uc0c1\ud488 \ucd1d  " + notExistMlinkShopprodno.size() + "\uac74 \uc0ad\uc81c\ucc98\ub9ac \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                            int maxSize = 50;
                            int i = 0;
                            while (i < notExistMlinkShopprodno.size()) {
                                int end = Math.min(i + maxSize, notExistMlinkShopprodno.size());
                                List subList = notExistMlinkShopprodno.subList(i, end);
                                String nonExistShoppronos = String.join((CharSequence)",", subList);
                                console.setValueBack("Page " + n++ + "\ucc98\ub9ac\ud560 \uc0c1\ud488\ubc88\ud638 \ub9ac\uc2a4\ud2b8: [" + nonExistShoppronos + "]", value);
                                this.melchiProductDelete(cookies, nonExistShoppronos, console);
                                console.setValueBack("", value);
                                i += maxSize;
                            }
                        }
                        standardDate = YDMATimeUtil.subtractDays(standardDate, 30);
                    }
                }
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 100);
        }
    }

    private void naverDiscountItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 99;
        console.setValueBack("[INFO] \ub124\uc774\ubc84\uc1fc\ud551 \ud310\ub9e4\uc885\ub8cc \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc885\ub8cc\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List naverInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0055")).collect(Collectors.toList());
            if (naverInfos != null) {
                for (ShoppingMallDetailDto naverInfo : naverInfos) {
                    List<String> shopprodnos;
                    shopString = this.getShopString(naverInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \ud310\ub9e4\uc885\ub8cc \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    Map<String, String> cookies = this.getCookie(console, naverInfo, shopString);
                    if (cookies == null) continue;
                    int page = 0;
                    do {
                        shopprodnos = this.getNaverDiscountProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(naverInfo.getShopcd(), naverInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4\uc5d0\uc11c \uc9c1\uc811 \uc0ad\uc81c \ucc98\ub9ac\ud569\ub2c8\ub2e4.", shopString, shopprodno), value);
                            this.naverProductDelete(cookies, shopprodno, console, value, naverInfo, shopString, logMsg);
                            InterruptSource.Thread.sleep((long)300L);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                }
                console.setValueBack("--------------------------------------------------------------------------------------", value);
                console.setValueBack("[INFO] \ub124\uc774\ubc84 \ud310\ub9e4\uc885\ub8cc \uc0c1\ud488 \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.  \r\n", value);
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 100);
        }
    }

    private void naverStopSellingItemProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 99;
        console.setValueBack("[INFO] \ub124\uc774\ubc84\uc1fc\ud551 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List naverInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0055")).collect(Collectors.toList());
            if (naverInfos != null) {
                for (ShoppingMallDetailDto naverInfo : naverInfos) {
                    List<String> shopprodnos;
                    shopString = this.getShopString(naverInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    Map<String, String> cookies = this.getCookie(console, naverInfo, shopString);
                    if (cookies == null) continue;
                    int page = 0;
                    do {
                        shopprodnos = this.getNaverStopSellingProducts(cookies, page);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(naverInfo.getShopcd(), naverInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4\uc5d0\uc11c \uc9c1\uc811 \uc0ad\uc81c \ucc98\ub9ac\ud569\ub2c8\ub2e4.", shopString, shopprodno), value);
                            this.naverProductDelete(cookies, shopprodno, console, value, naverInfo, shopString, logMsg);
                            InterruptSource.Thread.sleep((long)300L);
                        }
                        ++page;
                    } while (shopprodnos.size() >= 100);
                }
                console.setValueBack("--------------------------------------------------------------------------------------", value);
                console.setValueBack("[INFO] \ub124\uc774\ubc84 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488 \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", value);
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 100);
        }
    }

    private void naverProductDelete(Map<String, String> cookies, String shopprodno, YDMAProgressBar console, int value, ShoppingMallDetailDto shoppingMallDetailDto, String shopString, String logMsg) throws Exception {
        String json = String.format("{\"productNos\":[%s],\"productStatusType\":\"DELETE\",\"productBulkUpdateType\":\"DELETE\"}", shopprodno);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPatch httpPatch = new HttpPatch("https://sell.smartstore.naver.com/api/products/bulk-update?_action=updateProductStatusType");
        String cookie = this.ConvertDictionaryToParameter(cookies);
        httpPatch.setHeader("Cookie", cookie);
        httpPatch.setHeader("x-to-stateName", "main.product.origin-list");
        httpPatch.setHeader("Origin", "https://sell.smartstore.naver.com");
        httpPatch.setHeader("Pragma", "no-cache");
        httpPatch.setHeader("Cache-Control", "no-cache");
        httpPatch.setHeader("x-current-stateName", "main.product.origin-list");
        httpPatch.setHeader("x-current-state", "https://sell.smartstore.naver.com/#/products/origin-list");
        httpPatch.setHeader("Sec-Fetch-Site", "same-origin");
        httpPatch.setHeader("Sec-Fetch-Mode", "cors");
        httpPatch.setHeader("Sec-Fetch-Dest", "empty");
        httpPatch.setHeader("Referer", "https://sell.smartstore.naver.com/");
        httpPatch.setHeader("Content-Type", "application/json;charset=UTF-8");
        httpPatch.setHeader("Origin", "https://sell.smartstore.naver.com");
        ByteArrayEntity entity = new ByteArrayEntity(json.getBytes("UTF-8"));
        try {
            httpPatch.setEntity((HttpEntity)entity);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPatch);
        HttpEntity respEntity = response.getEntity();
        String content = "";
        try {
            content = EntityUtils.toString((HttpEntity)respEntity);
            JsonObject jsonobject = (JsonObject)this.jsonparser.parse(content);
            String message = jsonobject.get("status").toString();
            YDMAStringUtil.Print(message);
            if (message.contains("STARTED")) {
                this.logProductInDetail(shoppingMallDetailDto, shopprodno, "PROD_DEL", "SCHEDULER", "\uc131\uacf5", logMsg, shopString, console, "", value);
            } else {
                String errMsg;
                if (message.contains("PATCH")) {
                    errMsg = " \uc0ad\uc81c \uc2e4\ud328 : \uc77c\uc2dc\uc801\uc778 \uc624\ub958\uc785\ub2c8\ub2e4. \uc7a0\uc2dc \ud6c4 \ub2e4\uc2dc \uc2dc\ub3c4\ud574 \uc8fc\uc138\uc694.";
                    this.logProductInDetail(shoppingMallDetailDto, shopprodno, "PROD_DEL", "SCHEDULER", "\uc2e4\ud328", "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, console, errMsg, value);
                }
                errMsg = " \uc0ad\uc81c \uc2e4\ud328";
                this.logProductInDetail(shoppingMallDetailDto, shopprodno, "PROD_DEL", "SCHEDULER", "\uc2e4\ud328", "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, console, errMsg, value);
            }
        }
        catch (Exception e) {
            String errMsg = " \uc0ad\uc81c \ub3c4\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc0c1\uc138 \uc815\ubcf4: " + e.getMessage();
            this.logProductInDetail(shoppingMallDetailDto, shopprodno, "PROD_DEL", "SCHEDULER", "\uc2e4\ud328", "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, console, errMsg, value);
        }
    }

    private void coupangDirectDelete(Map<String, String> cookies, List<String> shopprodnos, YDMAProgressBar console, int value, ShoppingMallDetailDto shoppingMallDetailDto, String shopString, String logMsg) {
        int chunkSize = 50;
        int page = 1;
        int i = 0;
        while (i < shopprodnos.size()) {
            try {
                int end = Math.min(i + chunkSize, shopprodnos.size());
                List<String> subList = shopprodnos.subList(i, end);
                String nonExistShoppronos = String.join((CharSequence)",", subList);
                console.setValueBack(" Page " + page + " : " + subList.size() + "\uac74\uc758 \uc0c1\ud488 \uc0ad\uc81c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4. ", value);
                console.setValueBack(" \u2192 \uc0c1\ud488\ubc88\ud638 \ub9ac\uc2a4\ud2b8 : [" + nonExistShoppronos + "]", value);
                Connection connection = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-web/v2/vendor-inventories/delete").header("Content-Type", "application/x-www-form-urlencoded").cookies(cookies).method(Connection.Method.POST).timeout(180000).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true);
                for (String id : subList) {
                    connection.data("vendorInventoryIds[]", id);
                }
                Connection.Response rsPost = connection.execute();
                int statusCode = rsPost.statusCode();
                if (statusCode == 200) {
                    this.logProductInDetail(shoppingMallDetailDto, subList, "PROD_DEL", "SCHEDULER", "\uc131\uacf5", logMsg, shopString, console, "", value);
                    InterruptSource.Thread.sleep((long)1000L);
                } else {
                    String errMsg = " \uc0ad\uc81c \ub3c4\uc911 \uc0c1\ud0dc\ucf54\ub4dc \uc774\uc0c1 CODE [" + statusCode + "]";
                    this.logProductInDetail(shoppingMallDetailDto, subList, "PROD_DEL", "SCHEDULER", "\uc2e4\ud328", "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, console, errMsg, value);
                }
            }
            catch (Exception e) {
                console.setValueBack(" Page " + page + " : \uc0ad\uc81c \ub3c4\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + String.valueOf(e) + "]", value);
            }
            ++page;
            i += chunkSize;
        }
    }

    private void logProductInDetail(ShoppingMallDetailDto shoppingMallDetailDto, List<String> shopprodnos, String jobType, String jobDetail, String result, String logMsg, String shopString, YDMAProgressBar console, String errMsg, int value) {
        boolean isSuccess = errMsg == null || errMsg.isEmpty();
        for (String shopprodno : shopprodnos) {
            String comment = "";
            comment = logMsg.equals("[\uc2a4\ucf00\uc974\ub7ec] \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.") ? String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 %s", shopString, shopprodno, isSuccess ? "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4." : errMsg) : String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 %s", shopString, shopprodno, isSuccess ? "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4." : errMsg);
            console.setValueAndJobLogForProdIn(comment, value, shopprodno, shoppingMallDetailDto, jobType, jobDetail, result, logMsg);
        }
    }

    private void logProductInDetail(ShoppingMallDetailDto shoppingMallDetailDto, String shopprodno, String jobType, String jobDetail, String result, String logMsg, String shopString, YDMAProgressBar console, String errMsg, int value) {
        boolean isSuccess = errMsg == null || errMsg.isEmpty();
        String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 %s", shopString, shopprodno, isSuccess ? "\uc0c1\ud488\uc744 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c \ucc98\ub9ac\ud588\uc2b5\ub2c8\ub2e4." : errMsg);
        console.setValueAndJobLogForProdIn(comment, value, shopprodno, shoppingMallDetailDto, jobType, jobDetail, result, logMsg);
    }

    private void sendDeleteRequestsToToss(Map<String, String> cookies, List<Integer> shopprodnos, String merchantID, String merchantUserID, YDMAProgressBar console, int value, ShoppingMallDetailDto shoppingMallDetailDto, String shopString, String logMsg) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        int chunkSize = 50;
        int page = 1;
        int i = 0;
        while (i < shopprodnos.size()) {
            block5: {
                try {
                    int end = Math.min(i + chunkSize, shopprodnos.size());
                    List<Integer> subList = shopprodnos.subList(i, end);
                    String nonExistShoppronos = subList.stream().map(String::valueOf).collect(Collectors.joining(","));
                    console.setValueBack(" Page " + page + ": " + subList.size() + "\uac74 \ud1a0\uc2a4\uc1fc\ud551 \uc0ad\uc81c\ub97c \uc9c4\ud589\ud569\ub2c8\ub2e4.", 30);
                    console.setValueBack(" \u2192 \uc0c1\ud488\ubc88\ud638 \ub9ac\uc2a4\ud2b8 : [" + nonExistShoppronos + "]", 30);
                    DeleteJson deleteJson = new DeleteJson();
                    deleteJson.merchantId = Integer.parseInt(merchantID);
                    deleteJson.merchantUserId = Integer.parseInt(merchantUserID);
                    deleteJson.productIds = subList;
                    String json = mapper.writeValueAsString((Object)deleteJson);
                    String url = "https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/" + deleteJson.merchantId + "/v1/delete-products";
                    Connection.Response rsPost = Jsoup.connect((String)url).header("Content-Type", "application/json").cookies(cookies).method(Connection.Method.POST).requestBody(json).timeout(60000).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                    JsonObject object = (JsonObject)this.jsonparser.parse(rsPost.body());
                    String resultType = object.get("resultType").getAsString();
                    List<String> strProdNos = shopprodnos.stream().map(String::valueOf).collect(Collectors.toList());
                    if ("SUCCESS".equals(resultType)) {
                        this.logProductInDetail(shoppingMallDetailDto, strProdNos, "PROD_DEL", "SCHEDULER", "\uc131\uacf5", logMsg, shopString, console, "", value);
                    } else {
                        JsonObject error = (JsonObject)object.get("error");
                        String errMsg = this.getErrorMessage(error.get("reason").getAsString());
                        this.logProductInDetail(shoppingMallDetailDto, strProdNos, "PROD_DEL", "SCHEDULER", "\uc2e4\ud328", "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, console, errMsg, value);
                    }
                }
                catch (Exception e) {
                    console.setValueBack(" Page " + page + " : \ud1a0\uc2a4\uc1fc\ud551 \uc0ad\uc81c \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \ub2e4\uc74c \ud398\uc774\uc9c0 SKIP : " + String.valueOf(e), 30);
                    break block5;
                }
                ++page;
                InterruptSource.Thread.sleep((long)10000L);
            }
            i += chunkSize;
        }
    }

    private String getErrorMessage(String reason) {
        switch (reason) {
            case "AUTHENTICATION FAIL01": {
                return "[01] \uc778\uc99d\uc815\ubcf4 \uc5c6\uc74c \ub85c\uadf8\uc778 \ud6c4 \uc2dc\ub3c4\ud558\uc138\uc694";
            }
            case "AUTHENTICATION FAIL04": {
                return "[04] \ub85c\uadf8\uc778 \ub9cc\ub8cc \ub418\uc5c8\uc2b5\ub2c8\ub2e4. \uc7ac\ub85c\uadf8\uc778 \ud6c4 \uc2dc\ub3c4\ud558\uc138\uc694.";
            }
        }
        return reason;
    }

    private void melchiProductDelete(Map<String, String> cookies, String shopprodnos, YDMAProgressBar console) throws Exception {
        console.setValueBack("\uba78\uce58\uc1fc\ud551 \ud310\ub9e4\uc911\uc9c0 \uc791\uc5c5 \uc2dc\uc791\ud569\ub2c8\ub2e4. ", 99);
        if (this.changeProductStatus(cookies, shopprodnos, "03", "\ud310\ub9e4\uc911\uc9c0", console)) {
            InterruptSource.Thread.sleep((long)5000L);
            console.setValueBack("\uba78\uce58\uc1fc\ud551 \ud310\ub9e4\uc911\uc9c0\ud55c \uc0c1\ud488 \uc0ad\uc81c\ucc98\ub9ac \uc2dc\uc791\ud569\ub2c8\ub2e4. ", 99);
            if (this.changeProductStatus(cookies, shopprodnos, "04", "\uc0ad\uc81c", console)) {
                InterruptSource.Thread.sleep((long)5000L);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean changeProductStatus(Map<String, String> cookies, String shopprodno, String statusCode, String statusDesc, YDMAProgressBar console) {
        try {
            Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/register/changeStatus.json").userAgent(this.userAgent).header("Host", "scm.smelchi.com").cookies(cookies).data("field", "status").data("status", statusCode).data("productCds", shopprodno).method(Connection.Method.POST).timeout(120000).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            if (response.statusCode() != 200) {
                console.setValueBack("\uba78\uce58\uc1fc\ud551 " + statusDesc + " \uc2e4\ud328: " + response.body(), 30);
                return false;
            }
            if ("{}".equals(response.body())) {
                console.setValueBack("\uba78\uce58\uc1fc\ud551 " + statusDesc + " \uc791\uc5c5 \uc815\uc0c1 \uc644\ub8cc\ud588\uc2b5\ub2c8\ub2e4.. ", 30);
                return true;
            }
            console.setValueBack("\uba78\uce58\uc1fc\ud551 " + statusDesc + " \uc2e4\ud328: " + response.body(), 30);
            return false;
        }
        catch (Exception e) {
            console.setValueBack("\uba78\uce58\uc1fc\ud551 " + statusDesc + " \uc911 \uc608\uc678 \ubc1c\uc0dd: " + e.getMessage(), 30);
        }
        return false;
    }

    private void elevenstCleanProductProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 99;
        console.setValueBack("[INFO] 11\ubc88\uac00 \ud074\ub9b0\ub300\uc0c1 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \ud074\ub9b0\ub300\uc0c1\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List elevenstStoreInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop00031")).collect(Collectors.toList());
            if (elevenstStoreInfos != null) {
                ShopCommon.getShoppingMallName("shop00031");
                for (ShoppingMallDetailDto elevenstStoreInfo : elevenstStoreInfos) {
                    List<String> shopprodnos;
                    shopString = this.getShopString(elevenstStoreInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \ud074\ub9b0\ub300\uc0c1 \uc0c1\ud488 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
                    if (!conf.getSecondAuth11styn().equals("Y")) {
                        console.setValueBack("11\ubc88\uac00 \ud074\ub9b0\ub300\uc0c1  \uc0c1\ud488 \uc870\ud68c\ud558\uae30 \uc704\ud574 \ub85c\uadf8\uc778\uc774 \ud544\uc694\ud558\uc9c0\ub9cc, \ud604\uc7ac 2\ucc28 \uc778\uc99d \ubbf8\uc0ac\uc6a9 \uc124\uc815\uc774\ubbc0\ub85c \uc791\uc5c5\uc744 \uc0dd\ub7b5\ud569\ub2c8\ub2e4.", value);
                        return;
                    }
                    Map<String, String> cookies = this.getCookie(console, elevenstStoreInfo, shopString);
                    if (cookies == null) continue;
                    int start = 0;
                    ArrayList<String> notExistMlinkShopprodno = new ArrayList<String>();
                    do {
                        shopprodnos = this.getElevenstCleanProducts(start, cookies);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList("shop00031", elevenstStoreInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                InterruptSource.Thread.sleep((long)300L);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, 11\ubc88\uac00 \uc0ad\uc81c\ud56d\ubaa9\uc73c\ub85c \ubd84\ub958\ub418\uc5b4 \uc0ad\uc81c\ub429\ub2c8\ub2e4.", shopString, shopprodno), value);
                            notExistMlinkShopprodno.add(shopprodno);
                        }
                        start += 100;
                    } while (shopprodnos.size() >= 100);
                    if (notExistMlinkShopprodno.size() <= 0) continue;
                    console.setValueBack("\uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc740 11\ubc88\uac00 \ud074\ub9b0\ub300\uc0c1 \uc0c1\ud488 \ucd1d  " + notExistMlinkShopprodno.size() + "\uac74 \uc0ad\uc81c \ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                    this.sendDeleteRequestsToElevenst(cookies, notExistMlinkShopprodno, console, true, value, elevenstStoreInfo, shopString, logMsg);
                }
                console.setValueBack("--------------------------------------------------------------------------------------", value);
                console.setValueBack("[INFO] 11\ubc88\uac00 \ud074\ub9b0 \ub300\uc0c1 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \r\n", value);
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd : %s", shopString, e.getMessage()), 100);
        }
    }

    private void elevenstDuplicationProductProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 99;
        console.setValueBack("[INFO] 11\ubc88\uac00 \uc911\ubcf5\ub4f1\ub85d \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \uc911\ubcf5\ub4f1\ub85d\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List elevenstStoreInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop00031")).collect(Collectors.toList());
            if (elevenstStoreInfos != null) {
                ShopCommon.getShoppingMallName("shop00031");
                LocalDate today = LocalDate.now();
                LocalDate lastYear = today.minusYears(1L);
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                String todayStr = today.format(formatter);
                String lastYearStr = lastYear.format(formatter);
                for (ShoppingMallDetailDto elevenstStoreInfo : elevenstStoreInfos) {
                    shopString = this.getShopString(elevenstStoreInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \uc911\ubcf5\ub4f1\ub85d \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
                    if (!conf.getSecondAuth11styn().equals("Y")) {
                        console.setValueBack("11\ubc88\uac00 \uc911\ubcf5\ub4f1\ub85d \uc0c1\ud488 \uc870\ud68c\ub97c \uc704\ud574 \ub85c\uadf8\uc778\uc774 \ud544\uc694\ud558\uc9c0\ub9cc, \ud604\uc7ac 2\ucc28 \uc778\uc99d \ubbf8\uc0ac\uc6a9 \uc124\uc815\uc774\ubbc0\ub85c \uc791\uc5c5\uc744 \uc0dd\ub7b5\ud569\ub2c8\ub2e4.", value);
                        return;
                    }
                    Map<String, String> cookies = this.getCookie(console, elevenstStoreInfo, shopString);
                    if (cookies == null) continue;
                    int page = 1;
                    ArrayList<String> notExistMlinkShopprodno = new ArrayList<String>();
                    while (true) {
                        List<String> shopprodnos = this.getElevenstDuplicationProduct(page, cookies, todayStr, lastYearStr);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList("shop00031", elevenstStoreInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result == 1) {
                                    String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                    console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                    InterruptSource.Thread.sleep((long)300L);
                                }
                                console.setValueBack(String.format(" \u2192 \ud310\ub9e4\uae08\uc9c0 \uc0c1\ud0dc\uc774\uae30\uc5d0 \uc9c1\uc811 \uc0ad\uc81c \ud56d\ubaa9\uc73c\ub85c \ub4e4\uc5b4\uac00 \uc0ad\uc81c\uc791\uc5c5\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopprodno), value);
                                notExistMlinkShopprodno.add(shopprodno);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, 11\ubc88\uac00 \uc0ad\uc81c\ud56d\ubaa9\uc73c\ub85c \ubd84\ub958\ub418\uc5b4 \uc0ad\uc81c\ub429\ub2c8\ub2e4.", shopString, shopprodno), value);
                            notExistMlinkShopprodno.add(shopprodno);
                        }
                        if (shopprodnos.size() < 100) break;
                        ++page;
                    }
                    if (notExistMlinkShopprodno.size() <= 0) continue;
                    console.setValueBack("11\ubc88\uac00 \uc911\ubcf5 \uc0c1\ud488 \ucd1d  " + notExistMlinkShopprodno.size() + "\uac74 \uc0ad\uc81c \ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                    this.sendDeleteRequestsToElevenst(cookies, notExistMlinkShopprodno, console, false, value, elevenstStoreInfo, shopString, logMsg);
                }
                console.setValueBack("--------------------------------------------------------------------------------------", value);
                console.setValueBack("[INFO] 11\ubc88\uac00  \uc911\ubcf5\uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \r\n", value);
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd : %s", shopString, e.getMessage()), 100);
        }
    }

    private void elevenstStopSellingProductProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 99;
        console.setValueBack("[INFO] 11\ubc88\uac00 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List elevenstStoreInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop00031")).collect(Collectors.toList());
            if (elevenstStoreInfos != null) {
                ShopCommon.getShoppingMallName("shop00031");
                for (ShoppingMallDetailDto elevenstStoreInfo : elevenstStoreInfos) {
                    shopString = this.getShopString(elevenstStoreInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    ShopPreferencesDto conf = ShopCommonDao.get().getSystemConf();
                    if (!conf.getSecondAuth11styn().equals("Y")) {
                        console.setValueBack("11\ubc88\uac00 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488 \uc870\ud68c\ud558\uae30 \uc704\ud574 \ub85c\uadf8\uc778\uc774 \ud544\uc694\ud558\uc9c0\ub9cc, \ud604\uc7ac 2\ucc28 \uc778\uc99d \ubbf8\uc0ac\uc6a9 \uc124\uc815\uc774\ubbc0\ub85c \uc791\uc5c5\uc744 \uc0dd\ub7b5\ud569\ub2c8\ub2e4.", value);
                        return;
                    }
                    Map<String, String> cookies = this.getCookie(console, elevenstStoreInfo, shopString);
                    if (cookies == null) continue;
                    int page = 0;
                    ArrayList<String> notExistMlinkShopprodno = new ArrayList<String>();
                    while (true) {
                        List<String> shopprodnos = this.getElevenstStopSellingProduct(page, cookies);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList("shop00031", elevenstStoreInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result == 1) {
                                    String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                    console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                    InterruptSource.Thread.sleep((long)300L);
                                }
                                console.setValueBack(" \u2192 \ud310\ub9e4\uae08\uc9c0 \uc0c1\ud0dc\uc774\uae30\uc5d0 \uc9c1\uc811 \uc0ad\uc81c \ud56d\ubaa9\uc73c\ub85c \ub4e4\uc5b4\uac00 \uc0ad\uc81c\uc791\uc5c5\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                                notExistMlinkShopprodno.add(shopprodno);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, 11\ubc88\uac00 \uc0ad\uc81c\ud56d\ubaa9\uc73c\ub85c \ubd84\ub958\ub418\uc5b4 \uc0ad\uc81c\ub429\ub2c8\ub2e4.", shopString, shopprodno), value);
                            notExistMlinkShopprodno.add(shopprodno);
                        }
                        if (shopprodnos.size() < 100) break;
                        page += 100;
                    }
                    if (notExistMlinkShopprodno.size() <= 0) continue;
                    console.setValueBack("11\ubc88\uac00 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488 \ucd1d  " + notExistMlinkShopprodno.size() + "\uac74 \uc0ad\uc81c \ucc98\ub9ac\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", value);
                    this.sendDeleteRequestsToElevenst(cookies, notExistMlinkShopprodno, console, false, value, elevenstStoreInfo, shopString, logMsg);
                }
                console.setValueBack("[INFO] 11\ubc88\uac00  \ud310\ub9e4\uc911\uc9c0 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \ubc0f \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4..", value);
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("[%s] \uc5d0\ub7ec\ubc1c\uc0dd: %s", shopString, e.getMessage()), 100);
        }
    }

    private void sendDeleteRequestsToElevenst(Map<String, String> cookies, List<String> notExistMlinkShopprodno, YDMAProgressBar console, boolean isSale, int value, ShoppingMallDetailDto shoppingMallDetailDto, String shopString, String logMsg) {
        int chunkSize = 50;
        int page = 1;
        String saleStopURL = "https://soffice.11st.co.kr/product/SellProductAction.tmall?method=updateProductSelStat&prdStatCd=SELL_STOP";
        String deleteURL = "https://soffice.11st.co.kr/product/SellProductAjaxAction.tmall?method=updateProductHideListJSON&hideYN=Y";
        JsonObject jsonobject = new JsonObject();
        int i = 0;
        while (i < notExistMlinkShopprodno.size()) {
            try {
                Connection.Response rs;
                String body;
                int end = Math.min(i + chunkSize, notExistMlinkShopprodno.size());
                List<String> splitList = notExistMlinkShopprodno.subList(i, end);
                String splitShopprodnos = String.join((CharSequence)",", splitList);
                console.setValueBack(" Page " + page + ": " + splitList.size() + "\uac74 11\ubc88\uac00 \uc0ad\uc81c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4. ", 30);
                console.setValueBack(" \u2192 \uc0c1\ud488\ubc88\ud638 \ub9ac\uc2a4\ud2b8 : [" + splitShopprodnos + "]", 30);
                if (isSale && (body = (rs = Jsoup.connect((String)saleStopURL).cookies(cookies).userAgent(this.userAgent).data("trgtPrdNos", splitShopprodnos).data("chkPrdNoCount", String.valueOf(splitList.size())).data("content", "").referrer("http://soffice.11st.co.kr/product/SellProductAction.tmall?method=getSellProductList").ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).timeout(30000).method(Connection.Method.POST).execute()).body()).contains("\ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac \ub418\uc5c8\uc2b5\ub2c8\ub2e4")) {
                    this.logProductInDetail(shoppingMallDetailDto, splitList, "PROD_DEL", "SCHEDULER", "\uc131\uacf5", "[\uc2a4\ucf00\uc974\ub7ec] \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, console, "", value);
                }
                rs = Jsoup.connect((String)deleteURL).cookies(cookies).userAgent(this.userAgent).data("chkPrdNoList", splitShopprodnos).data("chkPrdNoCount", String.valueOf(splitList.size())).referrer("http://soffice.11st.co.kr/product/SellProductAction.tmall?method=getSellProductList").ignoreContentType(true).ignoreHttpErrors(true).followRedirects(true).timeout(30000).method(Connection.Method.POST).execute();
                YDMAStringUtil.Print(rs.body());
                jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
                if (jsonobject.get("success").getAsBoolean()) {
                    this.logProductInDetail(shoppingMallDetailDto, splitList, "PROD_DEL", "SCHEDULER", "\uc131\uacf5", logMsg, shopString, console, "", value);
                } else {
                    String errMsg = "\uc0ad\uc81c \ub3c4\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.";
                    this.logProductInDetail(shoppingMallDetailDto, splitList, "PROD_DEL", "SCHEDULER", "\uc2e4\ud328", logMsg, shopString, console, errMsg, value);
                }
                ++page;
            }
            catch (Exception exception) {
                console.setValueBack(" Page " + page + " : 11\ubc88\uac00 \uc0ad\uc81c \ub3c4\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", 99);
            }
            i += chunkSize;
        }
    }

    private void kakaoStoreStopProductProcess(YDMAProgressBar console, List<ScheduleInfoDto> schedulerInfos, List<ShoppingMallDetailDto> shopInfos) {
        int value = 99;
        console.setValueBack("[INFO] \uce74\uce74\uc624\ud1a1\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488 \uc0ad\uc81c\ub300\uc0c1 \uad6c\ubd84 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", value);
        String shopString = "";
        String logMsg = "[\uc2a4\ucf00\uc974\ub7ec] \ud1a1\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
        try {
            List kakaoStoreInfos = shopInfos.stream().filter(p -> p.getShopcd().equals("shop0273")).collect(Collectors.toList());
            if (kakaoStoreInfos != null) {
                ShopCommon.getShoppingMallName("shop0273");
                block2: for (ShoppingMallDetailDto kakaoStoreInfo : kakaoStoreInfos) {
                    shopString = this.getShopString(kakaoStoreInfo);
                    console.setValueBack(String.format("%s \uc1fc\ud551\ubab0\uc758 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488\uc744 \uc870\ud68c\ub97c \uc2dc\uc791\ud569\ub2c8\ub2e4.", shopString), value);
                    String apikey = kakaoStoreInfo.getApikey();
                    int page = 1;
                    while (true) {
                        List<String> shopprodnos = this.getKakaoSuspendedProducts(page, apikey);
                        for (String shopprodno : shopprodnos) {
                            ShopProductDto prodIn = ShopProductDao.get().getProductDeleteSchedulerList(kakaoStoreInfo.getShopcd(), kakaoStoreInfo.getShopseq(), shopprodno);
                            if (!"".equals(prodIn.getSendseq())) {
                                int result = ShopCommonDao.get().setProductStatusIn(prodIn, 7000);
                                if (result != 1) continue;
                                String comment = String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc218\uc815\ub300\uae30\ub85c \uc0c1\ud0dc \ubcc0\uacbd \uc644\ub8cc", shopString, shopprodno);
                                console.setValueBackAndJobLogForProdIn(comment, value, prodIn, "PROD_MODI", "SCHEDULER", "\uc131\uacf5", logMsg);
                                continue;
                            }
                            console.setValueBack(String.format(" %s \uc0c1\ud488\ubc88\ud638 [%s]\n \u2192 \uc5e0\ub9c1\ud06c\uc5d0 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc544, \ud1a1\uc2a4\ud1a0\uc5b4\uc5d0\uc11c \uc9c1\uc811 \uc0ad\uc81c \ucc98\ub9ac\ud569\ub2c8\ub2e4.", shopString, shopprodno), value);
                            this.sendDeleteRequestsToKakaoStore(shopprodno, apikey, console, value, kakaoStoreInfo, shopString, logMsg);
                        }
                        if (shopprodnos.size() < 100) continue block2;
                        ++page;
                    }
                }
                console.setValueBack("--------------------------------------------------------------------------------------", value);
                console.setValueBack("[INFO] \uce74\uce74\uc624\ud1a1\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0 \uc0c1\ud488 \uc0c1\ud0dc\ubcc0\uacbd \uc791\uc5c5\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4. \r\n", value);
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("%s \uc5d0\ub7ec\ubc1c\uc0dd : %s", shopString, e.getMessage()), 100);
        }
    }

    private List<String> getKakaoSuspendedProducts(int page, String apiKey) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append("https://kapi.kakao.com/v2/store/products/by-page").append("?page=").append(page).append("&size=100").append("&sortProperty=CREATED_AT").append("&sortOrder=ASC").append("&displayedSaleStatus=SUSPENSION");
        try {
            Connection.Response response = Jsoup.connect((String)urlBuilder.toString()).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apiKey).header("channel_ids", "101").header("Content-Type", "application/json;charset=UTF-8").method(Connection.Method.GET).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).timeout(20000).execute();
            JsonObject object = (JsonObject)this.jsonparser.parse(response.body());
            JsonArray contents = (JsonArray)object.get("contents");
            int i = 0;
            while (i < contents.size()) {
                JsonObject item = (JsonObject)contents.get(i);
                String shopprodno = item.get("productId").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
        return result;
    }

    private void sendDeleteRequestsToKakaoStore(String shopprodno, String apikey, YDMAProgressBar console, int value, ShoppingMallDetailDto shoppingMallDetailDto, String shopString, String logMsg) {
        String json = "{\"productIds\":[" + Integer.parseInt(shopprodno) + "]}";
        try {
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v2/store/products/delete").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).method(Connection.Method.PUT).execute();
            if (response.body().contains(shopprodno) && response.statusCode() == 200) {
                this.logProductInDetail(shoppingMallDetailDto, shopprodno, "PROD_DEL", "SCHEDULER", "\uc131\uacf5", logMsg, shopString, console, "", value);
            } else {
                String errMsg = "\uc0ad\uc81c \ub3c4\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. \uc0c1\uc138\u3154\uc815\ubcf4 : " + response.body() + "]";
                this.logProductInDetail(shoppingMallDetailDto, shopprodno, "PROD_DEL", "SCHEDULER", "\uc2e4\ud328", "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", shopString, console, errMsg, value);
            }
        }
        catch (IOException iOException) {
            console.setValueBack("\uc0ad\uc81c \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", value);
        }
    }

    private List<String> getElevenstCleanProducts(int page, Map<String, String> cookies) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("https://soffice.11st.co.kr/product/ProductClnsgMngAjaxAction.tmall?");
        sb.append("method=getUnsuitablePrdClnsgListJSON");
        sb.append("&prdNoList=");
        sb.append("&startDt=");
        sb.append("&endDt=");
        sb.append("&impptRsnCont=");
        sb.append("&istTypCdList=01,02,03,04");
        sb.append("&selStatCdList=103");
        sb.append("&start=").append(page);
        sb.append("&limit=100");
        try {
            Connection.Response rs = Jsoup.connect((String)sb.toString()).cookies(cookies).userAgent(this.userAgent).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.GET).execute();
            String body = rs.body();
            body = body.substring(body.indexOf("(") + 1, body.lastIndexOf(")"));
            JsonObject object = (JsonObject)this.jsonparser.parse(body);
            JsonArray dataList = (JsonArray)object.get("DATA_LIST");
            int i = 0;
            while (i < dataList.size()) {
                JsonObject item = (JsonObject)dataList.get(i);
                String shopprodno = item.get("prdNo").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception e) {
            YDMAStringUtil.Print(e.getMessage());
        }
        return result;
    }

    private List<String> getElevenstDuplicationProduct(int page, Map<String, String> cookies, String todayStr, String lastYearStr) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("https://soffice.11st.co.kr/product/SellProductAjaxAction.tmall?");
        sb.append("method=getDuplicateProductListJSON");
        sb.append("&startDate=").append(lastYearStr);
        sb.append("&endDate=").append(todayStr);
        sb.append("&pageNo=").append(page);
        sb.append("&pageSize=100");
        try {
            Connection.Response rs = Jsoup.connect((String)sb.toString()).cookies(cookies).userAgent(this.userAgent).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.GET).execute();
            JsonObject object = (JsonObject)this.jsonparser.parse(rs.body());
            JsonArray dataList = (JsonArray)object.get("DATA_LIST");
            int i = 0;
            while (i < dataList.size()) {
                JsonObject item = (JsonObject)dataList.get(i);
                String shopprodno = item.get("productNumber").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private List<String> getElevenstStopSellingProduct(int page, Map<String, String> cookies) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        sb.append("https://soffice.11st.co.kr/product/SellProductAjaxAction.tmall?");
        sb.append("method=getSellProductListJSON");
        sb.append("&srchTyp=prdNew");
        sb.append("&start=").append(page);
        sb.append("&limit=100");
        sb.append("&prdNo=");
        sb.append("&prdNm=");
        sb.append("&searchType=PRDNO");
        sb.append("&dateType=CREATE");
        sb.append("&category1=");
        sb.append("&category2=");
        sb.append("&category3=");
        sb.append("&category4=");
        sb.append("&chkSelStatCds=105");
        sb.append("&selMthdCd=");
        sb.append("&createDt=");
        sb.append("&createDtTo=");
        sb.append("&stckQty=");
        sb.append("&remainSelDt=");
        sb.append("&premiumAplDt=");
        sb.append("&dlvCstInstBasiCd=");
        sb.append("&dlvCstPayTypCd=");
        sb.append("&premiumPlusAplDt=");
        sb.append("&dlvClf=");
        sb.append("&data=");
        sb.append("&searchListingItemClsf=");
        sb.append("&mobilePrdYn=");
        sb.append("&shopNo=");
        sb.append("&prdTypCd=");
        sb.append("&omPrdYn=");
        sb.append("&svcAreaCd=");
        sb.append("&gblDlvYn=");
        sb.append("&engDispYn=");
        sb.append("&isPaging=Y");
        sb.append("&reglDlvYn=N");
        sb.append("&mnbdClfCd=");
        sb.append("&stdPrdYn=");
        sb.append("&sendClfCd=ALL");
        sb.append("&selStopRsnCd=");
        try {
            Connection.Response rs = Jsoup.connect((String)sb.toString()).cookies(cookies).userAgent(this.userAgent).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.GET).execute();
            String body = rs.body();
            body = body.substring(body.indexOf("(") + 1, body.lastIndexOf(")"));
            JsonObject object = (JsonObject)this.jsonparser.parse(body);
            JsonArray dataList = (JsonArray)object.get("DATA_LIST");
            int i = 0;
            while (i < dataList.size()) {
                JsonObject item = (JsonObject)dataList.get(i);
                String shopprodno = item.get("prdNo").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private String ConvertDictionaryToParameter(Map<String, String> parameters) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            list.add((CallSite)((Object)(key + "=" + value)));
        }
        return list.stream().collect(Collectors.joining(";"));
    }

    private void syncProduct(List<ProductSchedulerSyncDTO> syncInfos) {
        YDMAProgressBar console = new YDMAProgressBar();
        console.startTest("\uc2a4\ucf00\uc974\ub7ec(\uc0c1\ud488)", 100, 100, true);
        console.setValueBack("[INFO] \uc1fc\ud551\ubab0 \ubcc4 \ub3d9\uae30\ud654 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 0);
        String shopString = "";
        try {
            List<ShoppingMallDetailDto> shopInfos = ShopCommonDao.get().ShoppingMallDetailList();
            for (ProductSchedulerSyncDTO syncInfo : syncInfos) {
                if (isCanceled) {
                    YDMAProgressBar.get().end();
                    return;
                }
                ShoppingMallDetailDto shopInfo = shopInfos.stream().filter(p -> p.getShopcd().equals(syncInfo.getShopcd()) && p.getShopseq().equals(String.valueOf(syncInfo.getShopseq()))).findFirst().orElse(null);
                if (shopInfo == null) continue;
                String shopName = ShopCommon.getShoppingMallName(syncInfo.getShopcd());
                String shopNickName = syncInfo.getNickname();
                String shopUserId = syncInfo.getShoppingid();
                shopString = String.format("%s - %s(%s)", shopName, shopUserId, shopNickName);
                List<ShopProductDto> prodIns = ShopProductDao.get().getScheduleSyncProductIn(syncInfo.getShopcd(), String.valueOf(syncInfo.getShopseq()), 8000);
                if (prodIns.size() > 0) {
                    console.setValueBack(String.format("[%s] \ucd1d %s\uac74\uc758 \uc0c1\ud488 \ub3d9\uae30\ud654 \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", shopString, prodIns.size()), 50);
                    ArrayList<ShopProductShortDto> syncProds = new ArrayList<ShopProductShortDto>();
                    Map<String, String> cookie = null;
                    List<String> notNeedCookiesShops = Arrays.asList("shop00031", "shop0287", "shop0372", "shop0075", "shop0273", "shop9984", "shop9982");
                    if (!notNeedCookiesShops.contains(shopInfo.getShopcd()) && (cookie = this.getCookie(console, shopInfo, shopString)) == null) continue;
                    int allCount = prodIns.size();
                    int processedCount = 0;
                    int i = 0;
                    while (i < prodIns.size()) {
                        if (isCanceled) {
                            YDMAProgressBar.get().end();
                            return;
                        }
                        String shopprodno = this.getShopprodno(cookie, shopInfo, prodIns.get(i));
                        if (shopprodno.equals("\uc5d0\ub7ec\ubc1c\uc0dd") || shopprodno.toUpperCase().contains("ERROR") || shopprodno.contains("\uc624\ub958")) {
                            console.setValueBack(String.format(" [%s] [%s] \uc5d0\ub7ec \ubc1c\uc0dd", shopString, prodIns.get(i).getCompayny_goods_cd()), 50);
                        } else if (!prodIns.get(i).getShopprodno().equals(shopprodno)) {
                            console.setValueBack(String.format(" [%s] [%s] \ub3d9\uae30\ud654 \ub300\uc0c1\uc744 \ucc3e\uc558\uc2b5\ub2c8\ub2e4.", shopString, prodIns.get(i).getCompayny_goods_cd()), 50);
                            ShopProductShortDto syncProd = new ShopProductShortDto();
                            syncProd.setCompayny_goods_cd(prodIns.get(i).getCompayny_goods_cd());
                            syncProd.setSendseq(prodIns.get(i).getSendseq());
                            syncProd.setShopcd(prodIns.get(i).getShopcd());
                            syncProd.setShopseq(prodIns.get(i).getShopseq());
                            syncProd.setShopsendstatus(prodIns.get(i).getSendstats());
                            syncProd.setShopprodno(shopprodno);
                            syncProds.add(syncProd);
                        } else {
                            console.setValueBack(String.format(" [%s] [%s] \uc870\ud68c \uc911..", shopString, prodIns.get(i).getCompayny_goods_cd()), 50);
                        }
                        if (++processedCount % 100 == 0 || processedCount == allCount) {
                            console.setValueBack(String.format(" [%s] \ucd1d %s\uac1c\uc758 \uc0c1\ud488 \uc911 %s\uac1c\ub97c \uc870\ud68c\ud588\uc2b5\ub2c8\ub2e4.", shopString, allCount, processedCount), 50);
                        }
                        ++i;
                    }
                    if (syncProds.size() > 0) {
                        int result = ShopProductDao.get().setProductInUpdate(syncProds);
                        if (result <= 0) continue;
                        for (ShopProductShortDto dto : syncProds) {
                            String comment = String.format(" [%s] [%s] \ub3d9\uae30\ud654 \uc644\ub8cc", shopString, dto.getCompayny_goods_cd(), result);
                            console.setValueBackAndJobLogForProdSync(comment, 50, dto, syncInfo, "\uc131\uacf5");
                        }
                        console.setValueBack("--------------------------------------------------------------------------------------", 100);
                        console.setValueBack(String.format("[%s] \ucd1d %s\uac74\uc758 \uc0c1\ud488\uc744 \ub3d9\uae30\ud654\ud588\uc2b5\ub2c8\ub2e4.", shopString, result), 100);
                        continue;
                    }
                    console.setValueBack(String.format("[%s] \ub3d9\uae30\ud654\ud560 \uc0c1\ud488 \ub370\uc774\ud130 \uba85\uc138\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", shopString), 100);
                    continue;
                }
                console.setValueBack(String.format("[%s] \ub3d9\uae30\ud654\ud560 \uc0c1\ud488\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", shopString), 100);
            }
            console.setValueBack("5\ucd08 \ud6c4 \ucc3d\uc774 \uc790\ub3d9\uc73c\ub85c \ub2eb\ud799\ub2c8\ub2e4.", 100);
            InterruptSource.Thread.sleep((long)5000L);
            console.end();
        }
        catch (Exception exception) {
            console.dispose();
        }
    }

    private void clearProductInfo(List<ScheduleInfoDto> schedulerInfos) {
        YDMAProgressBar console = new YDMAProgressBar();
        console.startToBack("\uc2a4\ucf00\uc974\ub7ec(\uc0c1\ud488)", 100, 100, true);
        console.setValueBack("[INFO] \ud488\ub2e8\uc885 \uc0c1\ud488\uc815\ubcf4 \uc0ad\uc81c \uc791\uc5c5\uc744 \uc9c4\ud589\ud569\ub2c8\ub2e4.", 0);
        try {
            List<ShopProductDto> prodInfos = ShopProductDao.get().setProductInfoConditionDelete("", "STATUS", "1,2,3", "", "");
            int totalCount = prodInfos.size();
            int processedCount = 0;
            if (prodInfos.size() > 0) {
                console.setValueBack(String.format("\uc1fc\ud551\ubab0\uc5d0 \ub4f1\ub85d\ub418\uc788\uc9c0 \uc54a\uc740 \ud488\ub2e8\uc885 \uc0c1\ud488 \uae30\ubcf8\uc815\ubcf4 %s\uac74\uc744 \uc0ad\uc81c\ud569\ub2c8\ub2e4.", prodInfos.size()), 50);
                int retInfo = 0;
                if (prodInfos.size() > 0) {
                    retInfo = ShopProductDao.get().setProductInfoDelete(prodInfos);
                }
                if (retInfo > 0) {
                    for (ShopProductDto dto : prodInfos) {
                        int progress = (int)((double)(++processedCount) * 100.0 / (double)totalCount);
                        String comment = String.format(" [%s] \uc0ad\uc81c \uc644\ub8cc", dto.getCompayny_goods_cd());
                        console.setValueBackAndJobLogForProdInfo(comment, progress, dto, "PROD_DEL", "SCHEDULER", "\uc131\uacf5", "[\uc2a4\ucf00\uc974\ub7ec] \ud488\ub2e8\uc885 \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                    }
                    console.setValueBack("--------------------------------------------------------------------------------------", 100);
                    console.setValueBack(String.format("\ucd1d %s\uac74\uc758 \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.", retInfo), 100);
                }
            } else {
                console.setValueBack("[INFO] \uc0ad\uc81c \ub300\uc0c1\uc774 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.", 100);
            }
            console.setValueBack("5\ucd08 \ud6c4 \ucc3d\uc774 \uc790\ub3d9\uc73c\ub85c \ub2eb\ud799\ub2c8\ub2e4.", 100);
            InterruptSource.Thread.sleep((long)5000L);
            console.end();
        }
        catch (Exception exception) {
            console.dispose();
        }
    }

    private Map<String, String> getCookie(YDMAProgressBar console, ShoppingMallDetailDto shopInfo, String shopString) {
        Map<String, String> cookie = null;
        String shopcd = shopInfo.getShopcd();
        String id = shopInfo.getShoppingid();
        String pw = shopInfo.getPassword();
        String authkey = shopInfo.getAuthkey1();
        try {
            if (!(shopcd.equals("shop0287") || shopcd.equals("shop0372") || shopcd.equals("shop0273") || shopcd.equals("shop9984"))) {
                if (shopcd.equals("shop9982")) {
                    cookie = this.i.getTossCookies(id, pw);
                } else {
                    List<String> list;
                    cookie = shopcd.equals("shop0055") ? ((list = Arrays.asList(shopInfo.getApikey().split(","))) != null && list.size() > 1 ? this.i.loginCookie(id, pw, shopcd, true, authkey, list.get(0), list.get(1)) : this.i.loginCookie(id, pw, shopcd, true, authkey)) : this.i.loginCookie(id, pw, shopcd, true, authkey);
                    if (cookie == null || cookie.size() == 0) {
                        console.setValueBack(String.format("[%s] \ud574\ub2f9 \uc1fc\ud551\ubab0\uc5d0 \uc811\uc18d \ubd88\uac00\ud569\ub2c8\ub2e4.. \uc1fc\ud551\ubab0 \uc811\uc18d\uc815\ubcf4 \ud655\uc778 \ud544\uc694..", shopString), 50);
                        return null;
                    }
                }
            }
        }
        catch (Exception e) {
            console.setValueBack(String.format("[%s] \ud574\ub2f9 \uc1fc\ud551\ubab0 \uc811\uc18d\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.. %s", shopString, e.getMessage()), 50);
            return null;
        }
        return cookie;
    }

    private String getShopprodno(Map<String, String> cookie, ShoppingMallDetailDto shopInfo, ShopProductDto prodIn) {
        try {
            String compaynyGoodsCd = prodIn.getCompayny_goods_cd();
            String shopcd = shopInfo.getShopcd();
            String apiKey = shopInfo.getApikey();
            String id = shopInfo.getShoppingid();
            String pw = shopInfo.getPassword();
            String authKey1 = shopInfo.getAuthkey1();
            String authKey2 = shopInfo.getAuthkey2();
            switch (shopcd) {
                case "shop0004": {
                    return InterparkExitsProductCd.get().getisExistsProdNo(compaynyGoodsCd, cookie);
                }
                case "shop0055": {
                    return NaverisExitsProductCd.get().getisExistsProdNo(compaynyGoodsCd, cookie);
                }
                case "shop00031": {
                    return ElevenstExitsProductCd.get().getIsExistsProdNo_API(compaynyGoodsCd, apiKey);
                }
                case "shop00671": 
                case "shop00681": {
                    return AuctionExitsProductCd.get().getisExistsProdNoV2_New(compaynyGoodsCd, cookie, shopcd, id);
                }
                case "shop0076": {
                    return TmonExitsProductCd.get().getisExistsProdNo(compaynyGoodsCd, cookie);
                }
                case "shop0075": {
                    return CoupangExitsProductCd.get().getisExistsProdNo(authKey2, authKey1, compaynyGoodsCd);
                }
                case "shop0273": {
                    return KakaoExitsProductCd.get().getisExistsProdNo(compaynyGoodsCd, apiKey);
                }
                case "shop0287": {
                    return WemarketExitsProductCd.get().getisExistsProdNo(compaynyGoodsCd, apiKey);
                }
                case "shop0411": {
                    return SsgmarketExitsProductCd.get().getisExistsProdNo(compaynyGoodsCd, cookie, authKey1);
                }
                case "shop0110": {
                    return Cafe24ExistProductCd.get().getisExistsProdNo(shopInfo, compaynyGoodsCd);
                }
                case "shop0372": {
                    return LotteOnExitsProductCd.get().getisExistsProdNo(shopInfo, prodIn);
                }
                case "shop0106": {
                    return MelchiExitsProductCd.get().getisExistsProdNo(compaynyGoodsCd, cookie);
                }
                case "shop9984": {
                    return AlwayzExitsProductCd.get().getIsExistProdNo(compaynyGoodsCd, id, pw, shopcd);
                }
                case "shop9982": {
                    return tossShoppingExitsProductCd.get().getisScheduleExistsProdNo(prodIn.getShopprodno(), id, pw, authKey1);
                }
            }
            return "";
        }
        catch (Exception exception) {
            return "\uc5d0\ub7ec\ubc1c\uc0dd";
        }
    }

    private List<String> getCoupangItemWinnerProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String json = this.getCoupangItemWinnerJson(page);
            Connection.Response response = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-price-management/getProductList").userAgent(this.userAgent).cookies(cookies).header("Host", "wing.coupang.com").header("Content-Type", "application/json").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonObject object = (JsonObject)this.jsonparser.parse(response.body());
            JsonArray resultArr = (JsonArray)object.get("result");
            int i = 0;
            while (i < resultArr.size()) {
                JsonObject item = (JsonObject)resultArr.get(i);
                String shopprodno = item.get("vendorInventoryId").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private List<String> getCoupangExposureLimitProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String json = this.getCoupangExposureLimitJson(page);
            Connection.Response response = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-price-management/getProductList").userAgent(this.userAgent).cookies(cookies).header("Host", "wing.coupang.com").header("Content-Type", "application/json").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonObject object = (JsonObject)this.jsonparser.parse(response.body());
            JsonArray resultArr = (JsonArray)object.get("result");
            int i = 0;
            while (i < resultArr.size()) {
                JsonObject item = (JsonObject)resultArr.get(i);
                String shopprodno = item.get("vendorInventoryId").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private List<String> getCoupangReturnProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result;
        block4: {
            result = new ArrayList<String>();
            try {
                String json = this.getCoupangReturnProductJson(page);
                Connection.Response response = Jsoup.connect((String)"https://wing.coupang.com/tenants/seller-web/v2/vendor-inventory/search").userAgent(this.userAgent).cookies(cookies).header("Host", "wing.coupang.com").header("Content-Type", "application/json").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                JsonObject object = this.jsonparser.parse(response.body()).getAsJsonObject();
                boolean success = object.get("success").getAsBoolean();
                if (success) {
                    JsonObject data2 = object.get("data").getAsJsonObject();
                    JsonArray productList = data2.get("productList").getAsJsonArray();
                    int i = 0;
                    while (i < productList.size()) {
                        JsonObject item = productList.get(i).getAsJsonObject();
                        String shopprodno = item.get("vendorInventoryId").getAsString();
                        result.add(shopprodno);
                        ++i;
                    }
                    break block4;
                }
                return result;
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private List<String> getTossReturnProducts(Map<String, String> cookies, ShoppingMallDetailDto shopInfo, int page, String merchantID) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String url = this.getTossReturnProductURL(merchantID, page);
            Connection.Response response = Jsoup.connect((String)url).cookies(cookies).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            JsonObject body = (JsonObject)this.jsonparser.parse(response.body());
            JsonObject success = body.get("success").getAsJsonObject();
            JsonArray results = success.get("results").getAsJsonArray();
            int i = 0;
            while (i < results.size()) {
                JsonObject item = results.get(i).getAsJsonObject();
                String shopprodno = item.get("productId").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private List<String> getMelchiWaitProducts(Map<String, String> cookies, String start, String end) {
        ArrayList<String> result = new ArrayList<String>();
        int page = 1;
        try {
            while (true) {
                Map<String, String> map = this.getMelchiWaitProductMap(start, end, page);
                Connection.Response response = Jsoup.connect((String)"https://scm.smelchi.com/product/register/productList/list").userAgent(this.userAgent).cookies(cookies).data(map).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response.body());
                Elements datas = body.select("div.sub_section_01 table#table_style04 tbody tr");
                if (datas.size() <= 2) continue;
                Elements stop = ((Element)datas.get(2)).select("td.alCt");
                if (stop.size() <= 0) {
                    int i = 2;
                    while (i < datas.size()) {
                        if (i % 2 == 0) {
                            Elements aa = ((Element)datas.get(i)).getAllElements();
                            String shopprodno = ((Element)aa.get(11)).text();
                            result.add(shopprodno);
                        }
                        ++i;
                    }
                    ++page;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private String[] getMerchantID(Map<String, String> cookies, ShoppingMallDetailDto shopInfo) throws Exception {
        Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/my-info").cookies(cookies).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
        JsonObject object = (JsonObject)this.jsonparser.parse(response.body());
        String resultType = object.get("resultType").getAsString();
        if (resultType.equals("SUCCESS")) {
            JsonObject success = (JsonObject)object.get("success");
            JsonArray merchantMappingArray = (JsonArray)success.get("merchantMappingInfo");
            JsonObject merchantMappingInfo = Integer.parseInt(shopInfo.getAuthkey1()) == 0 ? merchantMappingArray.get(0).getAsJsonObject() : merchantMappingArray.get(Integer.parseInt(shopInfo.getAuthkey1()) - 1).getAsJsonObject();
            JsonObject merchantUser = (JsonObject)success.get("merchantUser");
            String merchantID = merchantMappingInfo.get("merchantId").getAsString();
            String merchantUserID = merchantUser.get("id").getAsString();
            String[] merchantInfo = new String[]{merchantID, merchantUserID};
            return merchantInfo;
        }
        throw new Exception("MerchantID\ub97c \uac00\uc838\uc624\ub358 \uc911 \uc5d0\ub7ec\ubc1c\uc0dd . . .");
    }

    private List<String> getNaverCatalogProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String json = this.getNaverCatalogProudctJson(page);
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/best-price/products?_action=getBestPriceProductsListByAccountNo").userAgent(this.userAgent).referrer("https://sell.smartstore.naver.com/").cookies(cookies).header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json;charset=UTF-8").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonObject object = (JsonObject)this.jsonparser.parse(response.body());
            JsonArray content = (JsonArray)object.get("content");
            int i = 0;
            while (i < content.size()) {
                JsonObject item = (JsonObject)content.get(i);
                String shopprodno = item.get("productId").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private String getCoupangItemWinnerJson(int page) {
        String json = "";
        try {
            CoupangItemWinnerRequestDTO request2 = new CoupangItemWinnerRequestDTO();
            request2.setSearchIds("");
            request2.setSortType("MY_VI_SALES_DESC");
            request2.setKeywords("");
            request2.setRevamp("B");
            request2.setDisplayCategoryIds(new ArrayList<String>());
            request2.setProductName("");
            request2.setBrandName("");
            request2.setAlarmStatus("ALL");
            request2.setAutoPriceStatus("ALL");
            request2.setVendorItemStatus("ON_SALE");
            request2.setItemWinnerStatus("LOSE_NOT_SUPPRESSED");
            request2.setRodBadge("ALL");
            request2.setPageSize("100");
            request2.setPage(page);
            request2.setSearchPresets(null);
            request2.setIsTopGmv(null);
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request2);
        }
        catch (Exception exception) {
            return "";
        }
        return json;
    }

    private String getCoupangExposureLimitJson(int page) {
        String json = "";
        try {
            CoupangItemWinnerRequestDTO request2 = new CoupangItemWinnerRequestDTO();
            request2.setSearchIds("");
            request2.setSortType("MY_VI_SALES_DESC");
            request2.setKeywords("");
            request2.setRevamp("B");
            request2.setDisplayCategoryIds(new ArrayList<String>());
            request2.setProductName("");
            request2.setBrandName("");
            request2.setAlarmStatus("ALL");
            request2.setAutoPriceStatus("ALL");
            request2.setVendorItemStatus("ON_SALE");
            request2.setItemWinnerStatus("ANY_SUPPRESSED");
            request2.setRodBadge("ALL");
            request2.setPageSize("100");
            request2.setPage(page);
            request2.setSearchPresets(null);
            request2.setIsTopGmv(null);
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request2);
        }
        catch (Exception exception) {
            return "";
        }
        return json;
    }

    private String getNaverCatalogProudctJson(int page) {
        String json = "";
        try {
            ArrayList<String> productStatusTypes = new ArrayList<String>();
            productStatusTypes.add("SALE");
            productStatusTypes.add("REJECTION");
            ArrayList<String> channelServiceTypes = new ArrayList<String>();
            channelServiceTypes.add("STOREFARM");
            channelServiceTypes.add("WINDOW");
            NaverCatalogViewDataRequestDTO viewData = new NaverCatalogViewDataRequestDTO();
            viewData.setProductStatusTypes(productStatusTypes);
            viewData.setChannelServiceTypes(channelServiceTypes);
            viewData.setPageSize(100);
            NaverCatalogRequestDTO request2 = new NaverCatalogRequestDTO();
            request2.setSearchKeyword("");
            request2.setProductName(null);
            request2.setModelName(null);
            request2.setMakerName(null);
            request2.setBrandName(null);
            request2.setAlarm("");
            request2.setSearchPeriodType("PROD_REG_DAY");
            request2.setBestPriceProductsSearchKeywordType("CHANNEL_PRODUCT_NO");
            request2.setFromDate("");
            request2.setToDate("");
            request2.setViewData(viewData);
            request2.setBestPriceProductSearchOrderType("HIGH_PRICE_POWER");
            request2.setBestPriceProductStatusType("ALL");
            request2.setProductStatusTypes(productStatusTypes);
            request2.setChannelServiceTypes(channelServiceTypes);
            request2.setPage(page);
            request2.setSize(100);
            request2.setSort(new ArrayList<String>());
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request2);
        }
        catch (Exception exception) {
            return "";
        }
        return json;
    }

    private String getTossReturnProductURL(String merchantID, int page) {
        StringBuilder url = new StringBuilder();
        try {
            url.append("https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/");
            url.append(merchantID);
            url.append("/v1/products?page=");
            url.append(String.valueOf(page));
            url.append("&size=100&reviewStatuses=REJECT&displayStatuses=");
        }
        catch (Exception exception) {
            return "";
        }
        return url.toString();
    }

    private String getCoupangReturnProductJson(int page) {
        String json = "";
        try {
            ArrayList<String> productStatus = new ArrayList<String>();
            productStatus.add("REJECTED");
            CoupangReturnProductRequestDTO request2 = new CoupangReturnProductRequestDTO();
            request2.setSearchKeywordType("ALL");
            request2.setSearchKeywords("");
            request2.setSalesMethod("ALL");
            request2.setProductStatus(productStatus);
            request2.setStockSearchType("ALL");
            request2.setShippingFeeSearchType("ALL");
            request2.setDisplayCategoryCodes(new ArrayList<String>());
            request2.setListingStartTime(null);
            request2.setListingEndTime(null);
            request2.setSaleEndDateSearchType("ALL");
            request2.setBundledShippingSearchType("ALL");
            request2.setDisplayDeletedProduct(false);
            request2.setShippingMethod("ALL");
            request2.setExposureStatus("ALL");
            request2.setSortMethod("SORT_BY_ITEM_LEVEL_UNIT_SOLD");
            request2.setCountPerPage(100);
            request2.setPage(page);
            request2.setLocale("ko_KR");
            request2.setCoupangAttributeOptimized(false);
            request2.setUpBundleSearchOption("ALL");
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request2);
        }
        catch (Exception exception) {
            return "";
        }
        return json;
    }

    private Map<String, String> getMelchiWaitProductMap(String start, String end, int page) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            map.put("schYn", "Y");
            map.put("listType", "list");
            map.put("searchDateType", "01");
            map.put("searchDateStart", start);
            map.put("searchDateEnd", end);
            map.put("searchOptional", "01");
            map.put("searchStatus", "01");
            map.put("searchListCountType", "02");
            map.put("page", String.valueOf(page));
        }
        catch (Exception exception) {
            return new HashMap<String, String>();
        }
        return map;
    }

    private List<String> getNaverDiscountProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String json = this.getNaverDiscountProudctJson(page);
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").userAgent(this.userAgent).referrer("https://sell.smartstore.naver.com/").cookies(cookies).header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json;charset=UTF-8").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonObject object = (JsonObject)this.jsonparser.parse(response.body());
            JsonArray content = (JsonArray)object.get("content");
            int i = 0;
            while (i < content.size()) {
                JsonObject item = (JsonObject)content.get(i);
                String shopprodno = item.get("id").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private String getNaverDiscountProudctJson(int page) {
        String json = "";
        try {
            ArrayList<String> productStatusTypes = new ArrayList<String>();
            productStatusTypes.add("CLOSE");
            ArrayList<String> channelServiceTypes = new ArrayList<String>();
            channelServiceTypes.add("STOREFARM");
            channelServiceTypes.add("WINDOW");
            NaverCatalogViewDataRequestDTO viewData = new NaverCatalogViewDataRequestDTO();
            viewData.setProductStatusTypes(productStatusTypes);
            viewData.setChannelServiceTypes(channelServiceTypes);
            viewData.setPageSize(100);
            NaverSearchRequestDTO request2 = new NaverSearchRequestDTO();
            request2.setSearchKeywordType("CHANNEL_PRODUCT_NO");
            request2.setSearchKeyword("");
            request2.setProductName("");
            request2.setModelName("");
            request2.setManufacturerName("");
            request2.setBrandName("");
            request2.setSearchPaymentType("ALL");
            request2.setSearchPeriodType("PROD_REG_DAY");
            request2.setDeliveryAttributeType("");
            request2.setProductKindType("");
            request2.setEtcCondition("");
            request2.setSubscriptionType("");
            request2.setLogisticsCompanyNo("");
            request2.setUseProductLogistics(true);
            request2.setDeliveryCompanyId("");
            request2.setUseDeliveryCompany(true);
            request2.setFromDate("");
            request2.setToDate("");
            request2.setViewData(viewData);
            request2.setUseSizeType("");
            request2.setGroupProductSearchType("");
            request2.setSearchOrderType("REG_DATE");
            request2.setProductStatusTypes(productStatusTypes);
            request2.setChannelServiceTypes(channelServiceTypes);
            request2.setPage(page);
            request2.setSize(100);
            request2.setSort(new ArrayList<String>());
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request2);
        }
        catch (Exception exception) {
            return "";
        }
        return json;
    }

    private List<String> getNaverStopSellingProducts(Map<String, String> cookies, int page) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String json = this.getNaverStopSellingProudctJson(page);
            Connection.Response response = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products/list/search").userAgent(this.userAgent).referrer("https://sell.smartstore.naver.com/").cookies(cookies).header("Host", "sell.smartstore.naver.com").header("Content-Type", "application/json;charset=UTF-8").requestBody(json).method(Connection.Method.POST).followRedirects(true).ignoreHttpErrors(true).ignoreContentType(true).execute();
            JsonObject object = (JsonObject)this.jsonparser.parse(response.body());
            JsonArray content = (JsonArray)object.get("content");
            int i = 0;
            while (i < content.size()) {
                JsonObject item = (JsonObject)content.get(i);
                String shopprodno = item.get("id").getAsString();
                result.add(shopprodno);
                ++i;
            }
        }
        catch (Exception exception) {}
        return result;
    }

    private String getNaverStopSellingProudctJson(int page) {
        String json = "";
        try {
            ArrayList<String> productStatusTypes = new ArrayList<String>();
            productStatusTypes.add("SUSPENSION");
            ArrayList<String> channelServiceTypes = new ArrayList<String>();
            channelServiceTypes.add("STOREFARM");
            channelServiceTypes.add("WINDOW");
            NaverCatalogViewDataRequestDTO viewData = new NaverCatalogViewDataRequestDTO();
            viewData.setProductStatusTypes(productStatusTypes);
            viewData.setChannelServiceTypes(channelServiceTypes);
            viewData.setPageSize(100);
            NaverSearchRequestDTO request2 = new NaverSearchRequestDTO();
            request2.setSearchKeywordType("CHANNEL_PRODUCT_NO");
            request2.setSearchKeyword("");
            request2.setProductName("");
            request2.setModelName("");
            request2.setManufacturerName("");
            request2.setBrandName("");
            request2.setSearchPaymentType("ALL");
            request2.setSearchPeriodType("PROD_REG_DAY");
            request2.setDeliveryAttributeType("");
            request2.setProductKindType("");
            request2.setEtcCondition("");
            request2.setSubscriptionType("");
            request2.setLogisticsCompanyNo("");
            request2.setUseProductLogistics(true);
            request2.setDeliveryCompanyId("");
            request2.setUseDeliveryCompany(true);
            request2.setFromDate("");
            request2.setToDate("");
            request2.setViewData(viewData);
            request2.setUseSizeType("");
            request2.setGroupProductSearchType("");
            request2.setSearchOrderType("REG_DATE");
            request2.setProductStatusTypes(productStatusTypes);
            request2.setChannelServiceTypes(channelServiceTypes);
            request2.setPage(page);
            request2.setSize(100);
            request2.setSort(new ArrayList<String>());
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString((Object)request2);
        }
        catch (Exception exception) {
            return "";
        }
        return json;
    }

    private String getShopString(ScheduleInfoDto schedulerInfo, List<ShoppingMallDetailDto> shopInfos) {
        String shopString = "";
        String shopName = ShopCommon.getShoppingMallName(schedulerInfo.getShopcd());
        String shopNickName = shopInfos.stream().filter(p -> p.getShopcd().equals(schedulerInfo.getShopcd()) && p.getShopseq().equals(schedulerInfo.getShopseq())).map(p -> p.getNicknm1()).findFirst().orElse("");
        String shopId = shopInfos.stream().filter(p -> p.getShopcd().equals(schedulerInfo.getShopcd()) && p.getShopseq().equals(schedulerInfo.getShopseq())).map(p -> p.getShoppingid()).findFirst().orElse("");
        shopString = String.format("[%s - %s(%s)]", shopName, shopId, shopNickName);
        return shopString;
    }

    private String getShopString(ShoppingMallDetailDto dto) {
        String shopString = "";
        String shopName = ShopCommon.getShoppingMallName(dto.getShopcd());
        String shopNickName = dto.getNicknm1();
        String shopId = dto.getShoppingid();
        shopString = String.format("[%s - %s(%s)]", shopName, shopId, shopNickName);
        return shopString;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private static final class DeleteJson {
        private List<Integer> productIds = new ArrayList<Integer>();
        private int merchantId;
        private int merchantUserId;

        private DeleteJson() {
        }
    }
}

