/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.sellerfriend;

import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.chrome.ChromeDriver;

public class SellerfriendOrderCommon {
    public static SellerfriendOrderCommon instance = new SellerfriendOrderCommon();

    private SellerfriendOrderCommon() {
    }

    public static SellerfriendOrderCommon get() {
        return instance;
    }

    public List<ShopOrderMstDto> getSearchSellerfriendProd(Map<String, String> cookies, List<ShopOrderMstDto> list, ChromeDriver driver) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        try {
            for (ShopOrderMstDto dto : list) {
                Connection.Response response = Jsoup.connect((String)("https://www.sellerfriend.co.kr/goods/goods_search.php?key=goodsCd&keyword=" + dto.getCompayny_goods_cd().replaceAll("SF", ""))).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").header("Origin", "https://sellerfriend.co.kr").referrer("https://sellerfriend.co.kr/goods/goods_search.php").data("key", "goodsCd").data("keyword", dto.getCompayny_goods_cd().replaceAll("SF", "")).method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                Document body = Jsoup.parseBodyFragment((String)response.body());
                Elements productElements = body.select("div.item_gallery_type ul li");
                for (Element productElement : productElements) {
                    boolean isSoldOut;
                    String imageUrl = productElement.select("div.item_photo_box img").attr("src");
                    String productTitle = productElement.select("div.item_tit_box a strong").text();
                    String productLink = productElement.select("div.item_tit_box a").attr("href");
                    String productCodeInImageUrl = imageUrl.replaceAll("[^\\d]", "");
                    if (!dto.getCompayny_goods_cd().replaceAll("SF", "").equals(productCodeInImageUrl)) continue;
                    String goodsNo = "";
                    Pattern pattern = Pattern.compile("goodsNo=(\\d+)");
                    Matcher matcher = pattern.matcher(productLink);
                    if (matcher.find()) {
                        goodsNo = matcher.group(1);
                    }
                    String price2 = productElement.select("div.item_money_box strong span").text().replaceAll("[^\\d]", "");
                    dto.setOrdimg(imageUrl);
                    dto.setDsGoods_cost(price2);
                    dto.setProduct_name(productTitle);
                    dto.setGoodsNo(goodsNo);
                    dto.setGoods_keyword("shop9989");
                    Connection.Response response2 = Jsoup.connect((String)("https://sellerfriend.co.kr/goods/goods_view.php?goodsNo=" + goodsNo)).cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").method(Connection.Method.GET).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
                    Document detailBody = Jsoup.parseBodyFragment((String)response2.body());
                    String productCode = detailBody.select("dl:contains(\uc790\uccb4\uc0c1\ud488\ucf54\ub4dc)  dd").text();
                    String deliveryFee = detailBody.select("dl:contains(\ubc30\uc1a1\ube44) dd strong").text().replaceAll("[^\\d]", "");
                    Element deliveryDetail = detailBody.select("div.delivery-detail").first();
                    String deliveryTypeText = deliveryDetail.select("select[name=deliveryCollectFl] option[value=pre]").text();
                    if (deliveryTypeText.equals("\uc8fc\ubb38\uc2dc\uacb0\uc81c(\uc120\uacb0\uc81c)")) {
                        dto.setDsdelv_type("0");
                    }
                    dto.setCompayny_goods_cd("SF" + productCode);
                    dto.setDsdelv_cost(deliveryFee);
                    dto.setDosinoption("");
                    dto.setSku_value("\ub2e8\ud488");
                    boolean bl = isSoldOut = detailBody.select("div.btn_choice_box.btn_restock_box button.btn_add_soldout").size() > 0;
                    if (isSoldOut) {
                        dto.setDosinstatus("\ud488\uc808");
                    } else {
                        dto.setDosinstatus("\ud310\ub9e4\uc911");
                    }
                    ret.add(dto);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

