/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.MoveWareDto;
import com.kdjsystem.mlink.tot.data.dao.RackDao;
import com.kdjsystem.mlink.tot.data.dao.WarehouseDto;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class HousingDao {
    public void refreshWarehouseProductList(int brandcd) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt_orddtl = null;
        CallableStatement pstmt_sum = null;
        CallableStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                pstmt_sum = connection.prepareCall("delete from SUM_PRODWAREQTY where compno=? and brandcd=? ");
                pstmt_sum.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt_sum.setInt(2, brandcd);
                pstmt_sum.execute();
                pstmt = connection.prepareCall("{call YWM_PRODWAREQTY_LIST_REFRESH(?,?)}");
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                rs = pstmt.executeQuery();
                String sql_orddtl = " insert into SUM_PRODWAREQTY values(?,?,?, ?,?,?,?,?,?,?) ";
                pstmt_orddtl = connection.prepareStatement(sql_orddtl);
                statementlist.add(pstmt_orddtl);
                while (rs.next()) {
                    int rowIdx = 0;
                    pstmt_orddtl.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt_orddtl.setInt(++rowIdx, brandcd);
                    pstmt_orddtl.setString(++rowIdx, rs.getString(1));
                    pstmt_orddtl.setString(++rowIdx, rs.getString(4));
                    pstmt_orddtl.setString(++rowIdx, rs.getString(5));
                    pstmt_orddtl.setString(++rowIdx, rs.getString(6));
                    pstmt_orddtl.setString(++rowIdx, rs.getString(7));
                    pstmt_orddtl.setString(++rowIdx, rs.getString(8));
                    pstmt_orddtl.setString(++rowIdx, rs.getString(9));
                    pstmt_orddtl.setString(++rowIdx, rs.getString(10));
                    pstmt_orddtl.addBatch();
                    pstmt_orddtl.clearParameters();
                }
                pstmt_orddtl.executeBatch();
                pstmt_orddtl.clearParameters();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
    }

    public List<List<String>> getSaleWareQtyList(String strdt, int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        CallableStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareCall("{call YWM_EXCEL_ORDER(?,?,?)}");
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, strdt);
                rs = pstmt.executeQuery();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getWarehouseProductList(int opt, String optStr) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        CallableStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareCall("{call YWM_PRODWAREQTY_LIST_WSUM(?, ?,?)}");
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, opt);
                pstmt.setString(3, "%" + optStr + "%");
                YDMAStringUtil.Print("[YWM_PRODWAREQTY_LIST_WSUM]" + pstmt.toString());
                rs = pstmt.executeQuery();
                contents = new ArrayList();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getWarehouseProductList1(int opt, String optStr, int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        CallableStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareCall("{call YWM_PRODWAREQTY_LIST_WSUM(?,?,?,?)}");
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setInt(3, opt);
                pstmt.setString(4, "%" + optStr + "%");
                YDMAStringUtil.Print("[YWM_PRODWAREQTY_LIST_WSUM]" + pstmt.toString());
                rs = pstmt.executeQuery();
                contents = new ArrayList();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getInventoryDetail(String prodcd, String sDate, String eDate, int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        CallableStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareCall("{call YWM_INVENTORY_DETAIL(?,?, ?,?,?)}");
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, prodcd);
                pstmt.setString(4, sDate);
                pstmt.setString(5, eDate);
                rs = pstmt.executeQuery();
                contents = new ArrayList();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getWarePeriodProdList(String bDate, String sDate, String eDate, int opt, String optStr, int brandcd) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        CallableStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareCall("{call YWM_PERIOD_PRODWARE_LIST(?,?,?,?,?,?,?)}");
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, bDate);
                pstmt.setString(4, sDate);
                pstmt.setString(5, eDate);
                pstmt.setInt(6, opt);
                pstmt.setString(7, "%" + optStr + "%");
                rs = pstmt.executeQuery();
                contents = new ArrayList();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getOverStockList(String date) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        CallableStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                pstmt = connection.prepareCall("{call YWM_OVERSTOCK_LIST(?)}");
                pstmt.setString(1, date);
                YDMAStringUtil.Print("[getOverStockList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                contents = new ArrayList();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public String getOverStockListDate(String date) throws Exception {
        String start_date = "";
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT DATE_FORMAT(DATE_ADD(?, INTERVAL -120 DAY),'%Y-%m-%d') ";
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, date);
                YDMAStringUtil.Print("[getOverStockListDate]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    start_date = rs.getString(++columnIndex);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return start_date;
    }

    public List<MoveWareDto> getMoveMstByOption(int brandcd, String recvdtFrom, String recvdtTo, int opt, String optStr) throws Exception {
        ArrayList<MoveWareDto> contents = new ArrayList<MoveWareDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "SELECT A.COMPNO, A.BRANDCD, MOVEDT, MOVESEQ, A.PRODCD, \r\n" + String.format("\t\tYWM_FUNC_BOSSPRODCD(%s,%s,A.prodcd) as img, \r\n", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + "       B.PRODNM,\r\n       OLD_WARECD, \r\n\t\t (select warenm from warehouse as C where A.compno=C.compno and A.brandcd=C.brandcd and A.OLD_WARECD=C.warecd) as warenm, \r\n\t\t OLD_NECCD1, OLD_NECCD2, OLD_NECCD3, QTY\r\n  FROM MOVEMST AS A JOIN PRODMST AS B ON A.prodcd=B.prodcd\r\n WHERE A.compno = ? \r\n";
                if (brandcd != -1) {
                    sql = (String)sql + "  AND A.brandcd = ? \r\n";
                }
                sql = (String)sql + "  AND A.movedt BETWEEN ? AND ? \r\n";
                if (opt == 0 && optStr.length() != 0) {
                    sql = (String)sql + " AND A.PRODCD LIKE ? \r\n";
                } else if (optStr.length() != 0) {
                    sql = (String)sql + " AND B.PRODNM LIKE ? \r\n";
                }
                sql = (String)sql + " order by A.MOVEDT desc, A.MOVESEQ desc ";
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (brandcd != -1) {
                    pstmt.setInt(2, brandcd);
                    pstmt.setString(3, recvdtFrom);
                    pstmt.setString(4, recvdtTo);
                    if (opt == 0 && optStr.length() != 0) {
                        pstmt.setString(5, "%" + optStr + "%");
                    } else if (optStr.length() != 0) {
                        pstmt.setString(5, "%" + optStr + "%");
                    }
                } else {
                    pstmt.setString(2, recvdtFrom);
                    pstmt.setString(3, recvdtTo);
                    if (opt == 0 && optStr.length() != 0) {
                        pstmt.setString(4, "%" + optStr + "%");
                    } else if (optStr.length() != 0) {
                        pstmt.setString(4, "%" + optStr + "%");
                    }
                }
                YDMAStringUtil.Print("[getRecvMstByOption]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    MoveWareDto list = new MoveWareDto();
                    list.setRownum(rowNum++);
                    list.setCompno(rs.getInt(++columnIndex));
                    list.setBrandcd(rs.getInt(++columnIndex));
                    list.setMovedt(rs.getString(++columnIndex));
                    list.setMoveseq(rs.getInt(++columnIndex));
                    list.setProdcd(rs.getString(++columnIndex));
                    list.setImg(rs.getString(++columnIndex));
                    list.setProdnm(rs.getString(++columnIndex));
                    list.setOld_warecd(rs.getInt(++columnIndex));
                    list.setOld_warenm(rs.getString(++columnIndex));
                    list.setOld_neccd1(rs.getString(++columnIndex));
                    list.setOld_neccd2(rs.getInt(++columnIndex));
                    list.setOld_neccd3(rs.getInt(++columnIndex));
                    list.setQty(rs.getInt(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getRecvMstByOption(int brandcd, String recvdtFrom, String recvdtTo, String recvgubun, String extra, String optStr) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "Select recvgubun, recvdt, recvseq, ifnull(recvdesc,''), ifnull(befqty,0), ifnull(realdt,''), ifnull(aftqty,0),  ifnull(confnam,'') , ifnull(contno,'') , ifnull(autochk, '')  From recvmst  where compno = ? ";
                if (brandcd != -1) {
                    sql = (String)sql + "  and brandcd = ? ";
                }
                sql = (String)sql + "  and recvdt between ? and ? ";
                if (recvgubun.trim().length() != 0) {
                    sql = (String)sql + "\tand recvgubun=? ";
                }
                if (extra.trim().equals("\ud655\uc815")) {
                    sql = (String)sql + "\tand ifnull(aftqty,0) <> 0 and ifnull(realdt,'') <>'' and ifnull(confnam,'')<>''";
                } else {
                    extra.trim().equals("\uc608\uc815");
                }
                if (optStr.length() != 0) {
                    sql = (String)sql + " and recvdesc like ?";
                }
                sql = (String)sql + " order by recvdt desc, recvseq desc ";
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (brandcd != -1) {
                    pstmt.setInt(2, brandcd);
                    pstmt.setString(3, recvdtFrom);
                    pstmt.setString(4, recvdtTo);
                    if (recvgubun.trim().length() != 0) {
                        pstmt.setString(5, recvgubun);
                    }
                    if (optStr.length() != 0) {
                        pstmt.setString(6, "%" + optStr + "%");
                    }
                } else {
                    pstmt.setString(2, recvdtFrom);
                    pstmt.setString(3, recvdtTo);
                    if (recvgubun.trim().length() != 0) {
                        pstmt.setString(4, recvgubun);
                    }
                    if (optStr.length() != 0) {
                        pstmt.setString(5, "%" + optStr + "%");
                    }
                }
                YDMAStringUtil.Print("[getRecvMstByOption]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<String> getRecvMstInfo(int brandcd, String recvdt, String recvseq) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "Select A.recvgubun, A.recvdt,  ifnull(A.befqty,0), ifnull(A.realdt,''), ifnull(A.aftqty,0),  ifnull(A.confnam,'') , ifnull(A.contno,'') ,  A.recvdt, A.recvseq , ifnull(AUTOCHK,'')  From recvmst A  where recvdt=?    and recvseq=?    and A.compno = ? ";
                if (brandcd != -1) {
                    sql = (String)sql + "  and A.brandcd = ? ";
                }
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, recvdt);
                pstmt.setString(2, recvseq);
                pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
                if (brandcd != -1) {
                    pstmt.setInt(4, brandcd);
                }
                YDMAStringUtil.Print("[getRecvMstInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public List<MoveWareDto> getMoveDtl(int brandcd, String movedt, int moveseq) throws Exception {
        ArrayList<MoveWareDto> contents = new ArrayList<MoveWareDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "SELECT COMPNO, BRANDCD, MOVEDT, MOVESEQ, SEQ, PRODCD, \t\t (select prodnm from prodmst as C where B.compno=C.compno and B.brandcd=C.brandcd and B.prodcd=C.prodcd) as prodnm, \t\t OLD_WARECD, \t\t (select warenm from warehouse as C where B.compno=C.compno and B.brandcd=C.brandcd and B.OLD_WARECD=C.warecd) as old_warenm,        OLD_NECCD1, OLD_NECCD2, OLD_NECCD3,\r\n\t\t NEW_WARECD, \t\t (select warenm from warehouse as C where B.compno=C.compno and B.brandcd=C.brandcd and B.NEW_WARECD=C.warecd) as new_warenm,  \t\t NEW_NECCD1, NEW_NECCD2, NEW_NECCD3, QTY\r\n\tFROM MOVEDTL as B\r\n where compno = ?";
                if (brandcd != -1) {
                    sql = (String)sql + "  and brandcd = ? ";
                }
                sql = (String)sql + "  and movedt = ? and moveseq=? ORDER BY seq ";
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (brandcd != -1) {
                    pstmt.setInt(2, brandcd);
                    pstmt.setString(3, movedt);
                    pstmt.setInt(4, moveseq);
                } else {
                    pstmt.setString(2, movedt);
                    pstmt.setInt(3, moveseq);
                }
                YDMAStringUtil.Print("[getMoveDtl]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    MoveWareDto list = new MoveWareDto();
                    list.setRownum(rowNum++);
                    list.setCompno(rs.getInt(++columnIndex));
                    list.setBrandcd(rs.getInt(++columnIndex));
                    list.setMovedt(rs.getString(++columnIndex));
                    list.setMoveseq(rs.getInt(++columnIndex));
                    list.setSeq(rs.getInt(++columnIndex));
                    list.setProdcd(rs.getString(++columnIndex));
                    list.setProdnm(rs.getString(++columnIndex));
                    list.setOld_warecd(rs.getInt(++columnIndex));
                    list.setOld_warenm(rs.getString(++columnIndex));
                    list.setOld_neccd1(rs.getString(++columnIndex));
                    list.setOld_neccd2(rs.getInt(++columnIndex));
                    list.setOld_neccd3(rs.getInt(++columnIndex));
                    list.setNew_warecd(rs.getInt(++columnIndex));
                    list.setNew_warenm(rs.getString(++columnIndex));
                    list.setNew_neccd1(rs.getString(++columnIndex));
                    list.setNew_neccd2(rs.getInt(++columnIndex));
                    list.setNew_neccd3(rs.getInt(++columnIndex));
                    list.setQty(rs.getInt(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getRecvDtl(int brandcd, String recvdt, String recvseq) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "Select A.seq,  A.prodcd, " + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,A.prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + "ifnull(B.prodnm,''), ifnull(B.specdes,''),  ifnull(A.befqty,0), ifnull(A.aftqty, 0), ifnull(A.sparerack1,''),ifnull(A.sparerack2,''),ifnull(A.sparerack3,''),ifnull(A.sparerack4,''),ifnull(A.sparerack5,''), ifnull(A.remark,'') ,  ifnull(A.realdt, ''), ifnull(A.plandt,'')  From recvdtl A Left Join v_products B on A.prodcd = B.prodcd and A.compno = B.compno AND ifnull(B.DELYN,'N') ='N' where A.compno = ? ";
                if (brandcd != -1) {
                    sql = (String)sql + "  and A.brandcd = ? ";
                }
                sql = (String)sql + "  and A.recvdt=?   and A.recvseq=?  ORDER BY seq ";
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (brandcd != -1) {
                    pstmt.setInt(2, brandcd);
                    pstmt.setString(3, recvdt);
                    pstmt.setString(4, recvseq);
                } else {
                    pstmt.setString(2, recvdt);
                    pstmt.setString(3, recvseq);
                }
                YDMAStringUtil.Print("[getRecvDtl]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex).equals("0") ? "" : rs.getString(columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add("T");
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public List<List<String>> getRecvDtl_AftqtyNozero(int brandcd, String recvdt, String recvseq, String gubun, String aftqty) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "Select recvdt,  A.seq,   '', '', '', '', '', '', '' ,   ifnull(B.ecountcd,''), ifnull(B.prodnm,''), ifnull(B.specdes,''),   ifnull(A.aftqty,0),    '', '', '', '', '', '', ifnull(A.brandcd,'')    From recvdtl A Left Join prodmst B on A.prodcd = B.prodcd and A.compno = B.compno  where A.compno = ? and A.recvdt=? and A.recvseq=?  and ifnull(A.aftqty,0) > 0";
                if (brandcd != -1) {
                    sql = (String)sql + "  and A.brandcd = ? ";
                }
                sql = (String)sql + " ORDER BY A.seq ";
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, recvdt);
                pstmt.setString(3, recvseq);
                if (brandcd != -1) {
                    pstmt.setInt(4, brandcd);
                }
                YDMAStringUtil.Print("[getRecvDtl_AftqtyNozero]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public int processRecvInsert(int brandcd, List<List<String>> contents, String recvdt, String gubun, String recvdesc, int beforeQty, int afterQty, String confnam, String contno, String realdt, String plandt) throws Exception {
        int recvseq;
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                recvseq = this.getMaxRecvSeq(connection, statementlist, brandcd);
                this.insertRecvMst(brandcd, connection, statementlist, contents, recvdt, recvseq, gubun, recvdesc, beforeQty, afterQty, confnam, contno, realdt);
                this.insertRecvDtl(brandcd, connection, statementlist, contents, recvdt, recvseq, realdt, plandt);
                this.recvWareInsert(connection, statementlist, contents, recvdt, recvseq, brandcd, realdt);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return recvseq;
    }

    public int get3DayInventoryCnt(String strDate, String prodcd) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT YWM_FUNC_TOTAL_WEEKDAYS(?,min(A.plandt))  FROM RECVDTL A, RECVMST B  WHERE ifnull(A.befqty,0) <> 0   AND ifnull(A.aftqty,0) = 0   AND A.RECVDT =B.RECVDT   AND A.RECVSEQ=B.RECVSEQ   AND B.RECVGUBUN <> '\ubc18\ud488'   AND A.plandt >= ?   AND A.plandt <= YWM_FUNC_WORKING_DAY(?,3)    AND A.prodcd = ? and A.compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, strDate);
                pstmt.setString(2, strDate);
                pstmt.setString(3, strDate);
                pstmt.setString(4, prodcd);
                pstmt.setString(5, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[get3DayInventoryCnt]" + pstmt.toString());
                rs = pstmt.executeQuery();
                result = rs.next() ? rs.getInt(1) : 0;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public int getMaxMoveSeq(Connection connection, List<PreparedStatement> statementlist, int brandcd) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT ifnull(MAX(MOVESEQ), 0)+1 FROM MOVEMST WHERE MOVEDT=? and compno = ? and brandcd = ? ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        pstmt.setString(1, YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd"));
        pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(3, brandcd);
        YDMAStringUtil.Print("[getMaxMoveSeq]" + pstmt.toString());
        rs = pstmt.executeQuery();
        result = rs.next() ? rs.getInt(1) : 1;
        return result;
    }

    public int getMaxRecvSeq(Connection connection, List<PreparedStatement> statementlist, int brandcd) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT ifnull(MAX(RECVSEQ), 0)+1 FROM RECVMST WHERE RECVDT=? and compno = ? and BRANDCD = ? ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        pstmt.setString(1, YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd"));
        pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(3, brandcd);
        YDMAStringUtil.Print("[getMaxRecvSeq]" + pstmt.toString());
        rs = pstmt.executeQuery();
        result = rs.next() ? rs.getInt(1) : 1;
        return result;
    }

    public int getMaxNecSeq(Connection connection, List<PreparedStatement> statementlist, int brandcd, String recvdt, int recvseq, int seq) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "SELECT ifnull(MAX(NECSEQ), 0)+1 FROM RECVWARE WHERE COMPNO=? and BRANDCD = ? and RECVDT = ? and RECVSEQ = ? and SEQ = ? ";
        sql = sql.toUpperCase();
        pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(2, brandcd);
        pstmt.setString(3, recvdt);
        pstmt.setInt(4, recvseq);
        pstmt.setInt(5, seq);
        YDMAStringUtil.Print("[getMaxRecvSeq]" + pstmt.toString());
        rs = pstmt.executeQuery();
        result = rs.next() ? rs.getInt(1) : 1;
        return result;
    }

    public void insertRecvMst(int brandcd, Connection connection, List<PreparedStatement> statementlist, List<List<String>> contents, String recvdt, int recvseq, String gubun, String recvdesc, int befqty, int aftqty, String confnam, String contno, String realdt) throws Exception {
        PreparedStatement pstmt = null;
        String sql_orddtl = " insert into recvmst (compno, brandcd, recvdt, recvseq, entdt, recvgubun, recvdesc, befqty, aftqty, confnam, contno, realdt, INSERTDT, INSERTID)   VALUES (?, ?, ?, ?, ? , ? , ? , ? , ? , ?, ?, ?, ?, ?)";
        sql_orddtl = sql_orddtl.toUpperCase();
        pstmt = connection.prepareStatement(sql_orddtl);
        statementlist.add(pstmt);
        int rowIdx = 0;
        pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(++rowIdx, brandcd);
        pstmt.setString(++rowIdx, recvdt);
        pstmt.setInt(++rowIdx, recvseq);
        pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMddHHmm"));
        pstmt.setString(++rowIdx, gubun);
        pstmt.setString(++rowIdx, recvdesc);
        pstmt.setInt(++rowIdx, befqty);
        pstmt.setInt(++rowIdx, aftqty);
        pstmt.setString(++rowIdx, confnam);
        pstmt.setString(++rowIdx, contno);
        pstmt.setString(++rowIdx, realdt);
        pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
        YDMAStringUtil.Print("[insertRecvMst]" + pstmt.toString());
        pstmt.execute();
    }

    public int insertRecvDtl(int brandcd, Connection connection, List<PreparedStatement> statementlist, List<List<String>> contents, String recvdt, int recvseq, String realdt, String plandt) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        String sql_orddtl = " insert into recvdtl ( compno, brandcd, recvdt, recvseq,  seq, prodcd, befqty, AFTQTY, realdt, remark, plandt,sparerack1,sparerack2,sparerack3,sparerack4,sparerack5, INSERTDT, INSERTID)  VALUES (  ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ?, ?, ?, ?, ?, ?)";
        sql_orddtl = sql_orddtl.toUpperCase();
        pstmt = connection.prepareStatement(sql_orddtl);
        statementlist.add(pstmt);
        for (List<String> claim : contents) {
            int rowIdx = 0;
            pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(++rowIdx, brandcd);
            pstmt.setString(++rowIdx, recvdt);
            pstmt.setInt(++rowIdx, recvseq);
            pstmt.setInt(++rowIdx, Integer.parseInt(claim.get(0)));
            pstmt.setString(++rowIdx, claim.get(1));
            pstmt.setInt(++rowIdx, Integer.parseInt(claim.get(5)));
            pstmt.setInt(++rowIdx, Integer.parseInt(claim.get(6)));
            pstmt.setString(++rowIdx, realdt);
            pstmt.setString(++rowIdx, claim.get(12));
            pstmt.setString(++rowIdx, plandt);
            pstmt.setString(++rowIdx, claim.get(7));
            pstmt.setString(++rowIdx, claim.get(8));
            pstmt.setString(++rowIdx, claim.get(9));
            pstmt.setString(++rowIdx, claim.get(10));
            pstmt.setString(++rowIdx, claim.get(11));
            pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
            pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
            YDMAStringUtil.Print("[insertRecvDtl]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearParameters();
        return result;
    }

    public List<List<String>> getHousingListByOption(int opt, String optStr) throws Exception {
        ArrayList<List<String>> contents = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "SELECT ifnull(A.recvdt,''), ifnull(A.recvseq,''), ifnull(A.recvgubun,''), ifnull(A.entdt,''),  ifnull(A.recvdesc,''), ifnull(A.befqty,''),  ifnull(A.realdt,''), ifnull(A.aftqty,''),  ifnull(A.confnam,''), ifnull(A.contno,''),  ifnull(A.autochk,'')  FROM recvmst A where A.compno = ? ";
                if (opt == 0) {
                    if (optStr.length() != 0) {
                        sql = (String)sql + " and  A.rcvnam like ? ";
                    }
                    sql = (String)sql + " order by A.rcvnam ";
                } else if (opt != 1 && opt == 2) {
                    if (optStr.length() != 0) {
                        sql = (String)sql + " and B.prodnm like ? ";
                    }
                    sql = (String)sql + "  order by B.prodnm ";
                }
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                if (optStr.length() != 0) {
                    pstmt.setString(2, "%" + optStr + "%");
                }
                YDMAStringUtil.Print("[getHousingListByOption]" + pstmt.toString());
                rs = pstmt.executeQuery();
                int rowNum = 1;
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    list.add(String.valueOf(rowNum++));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    contents.add(list);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return contents;
    }

    public void processRecvUpdate(int brandcd, List<List<String>> contents, String recvdt, int recvseq, String gubun, String recvdesc, int beforeQty, int afterQty, String confnam, String contno, String realdt, String plandt) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.updateRecvMst(brandcd, connection, statementlist, contents, recvdt, recvseq, gubun, recvdesc, beforeQty, afterQty, confnam, contno, realdt);
                this.deleteRecvDtl(brandcd, connection, statementlist, recvdt, recvseq);
                this.insertUpdateRecvDtl(brandcd, connection, statementlist, contents, recvdt, recvseq, realdt, plandt);
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public void updateRecvMst(int brandcd, Connection connection, List<PreparedStatement> statementlist, List<List<String>> contents, String recvdt, int recvseq, String gubun, String recvdesc, int befqty, int aftQty, String confnam, String contno, String realdt) throws Exception {
        PreparedStatement pstmt = null;
        String sql_orddtl = "update recvmst set entdt=?, recvgubun=?, recvdesc=?, befqty=?, aftQty=?, confnam=?, contno=?, realdt=?, UPDATEDT=?, UPDATEID=?  where recvdt=? and recvseq=?  and compno = ?  and brandcd = ? ";
        sql_orddtl = sql_orddtl.toUpperCase();
        pstmt = connection.prepareStatement(sql_orddtl);
        statementlist.add(pstmt);
        int rowIdx = 0;
        pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMddHHmm"));
        pstmt.setString(++rowIdx, gubun);
        pstmt.setString(++rowIdx, recvdesc);
        pstmt.setInt(++rowIdx, befqty);
        pstmt.setInt(++rowIdx, aftQty);
        pstmt.setString(++rowIdx, confnam);
        pstmt.setString(++rowIdx, contno);
        pstmt.setString(++rowIdx, realdt);
        pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
        pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
        pstmt.setString(++rowIdx, recvdt);
        pstmt.setInt(++rowIdx, recvseq);
        pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(++rowIdx, brandcd);
        YDMAStringUtil.Print("[updateRecvMst]" + pstmt.toString());
        pstmt.execute();
    }

    public int insertUpdateRecvDtl(int brandcd, Connection connection, List<PreparedStatement> statementlist, List<List<String>> contents, String recvdt, int recvseq, String realdt, String plandt) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        String sql_orddtl = " insert into recvdtl ( compno ,brandcd, recvdt, recvseq,  seq, prodcd, befqty, AFTQTY, remark, plandt, realdt,sparerack1, sparerack2,sparerack3,sparerack4,sparerack5, UPDATEDT, UPDATEID)   VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        sql_orddtl = sql_orddtl.toUpperCase();
        pstmt = connection.prepareStatement(sql_orddtl);
        statementlist.add(pstmt);
        for (List<String> claim : contents) {
            int rowIdx = 0;
            pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(++rowIdx, brandcd);
            pstmt.setString(++rowIdx, recvdt);
            pstmt.setInt(++rowIdx, recvseq);
            pstmt.setInt(++rowIdx, Integer.parseInt(claim.get(0)));
            pstmt.setString(++rowIdx, claim.get(1));
            pstmt.setInt(++rowIdx, Integer.parseInt(claim.get(5)));
            pstmt.setInt(++rowIdx, Integer.parseInt(claim.get(6)));
            pstmt.setString(++rowIdx, claim.get(12));
            pstmt.setString(++rowIdx, plandt);
            pstmt.setString(++rowIdx, realdt);
            pstmt.setString(++rowIdx, claim.get(7));
            pstmt.setString(++rowIdx, claim.get(8));
            pstmt.setString(++rowIdx, claim.get(9));
            pstmt.setString(++rowIdx, claim.get(10));
            pstmt.setString(++rowIdx, claim.get(11));
            pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
            pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
            YDMAStringUtil.Print("[insertUpdateRecvDtl]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearParameters();
        return result;
    }

    public void deleteRecvDtl(int brandcd, Connection connection, List<PreparedStatement> statementlist, String recvdt, int recvseq) throws Exception {
        String sql = " delete from recvdtl where recvdt=? and recvseq=? and compno = ? and brandcd = ? ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        pstmt.setString(1, recvdt);
        pstmt.setInt(2, recvseq);
        pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(4, brandcd);
        YDMAStringUtil.Print("[deleteRecvDtl]" + pstmt.toString());
        pstmt.execute();
    }

    public void deleteRecvMst(int brandcd, Connection connection, List<PreparedStatement> statementlist, String recvdt, int recvseq) throws Exception {
        String sql = " delete from recvmst where recvdt=? and recvseq=? and compno = ? and brandcd = ? ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        pstmt.setString(1, recvdt);
        pstmt.setInt(2, recvseq);
        pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(4, brandcd);
        YDMAStringUtil.Print("[deleteRecvMst]" + pstmt.toString());
        pstmt.execute();
    }

    public void updateBasstkMstFromRecvDel(int brandcd, Connection connection, List<PreparedStatement> statementlist, String recvdt, int recvseq) throws Exception {
        String sql = "update basstkmst set recvdt=null, recvseq=null  where recvdt=? and recvseq=?     and compno = ?     and brandcd = ? ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        pstmt.setString(1, recvdt);
        pstmt.setInt(2, recvseq);
        pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(4, brandcd);
        YDMAStringUtil.Print("[updateBasstkMstFromRecvDel]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void updateClaimFromRecvDel(int brandcd, Connection connection, List<PreparedStatement> statementlist, String recvdt, int recvseq) throws Exception {
        String sql = "update clmlist set recvdt=null, recvseq=null  where recvdt=? and recvseq=?    and compno = ?    and brandcd = ? ";
        sql = sql.toUpperCase();
        PreparedStatement pstmt = connection.prepareStatement(sql);
        statementlist.add(pstmt);
        pstmt.setString(1, recvdt);
        pstmt.setInt(2, recvseq);
        pstmt.setString(3, YDMASessonUtil.getCompnoInfo().getCompno());
        pstmt.setInt(4, brandcd);
        YDMAStringUtil.Print("[updateClaimFromRecvDel]" + pstmt.toString());
        pstmt.executeUpdate();
    }

    public void processRecvDelete(int brandcd, String recvdt, int recvseq, String autochk, String gubun) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                this.deleteRecvDtl(brandcd, connection, statementlist, recvdt, recvseq);
                this.deleteRecvMst(brandcd, connection, statementlist, recvdt, recvseq);
                if (autochk.equals("1") && gubun.equals("\uc7ac\uace0\ucc28\uc774")) {
                    this.updateBasstkMstFromRecvDel(brandcd, connection, statementlist, recvdt, recvseq);
                }
                if (autochk.equals("1") && gubun.equals("\ubc18\ud488")) {
                    this.updateClaimFromRecvDel(brandcd, connection, statementlist, recvdt, recvseq);
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
    }

    public List<String> getSpareRack(String prodcd, String date, String qty) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT ifnull(sparerack1,''), ifnull(sparerack2,''), ifnull(sparerack3,''), ifnull(sparerack4,''), ifnull(sparerack5,'')  from recvdtl where prodcd = ? and realdt = ? and aftqty = ?  and compno = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, prodcd);
                pstmt.setString(2, date);
                pstmt.setInt(3, Integer.parseInt(qty));
                pstmt.setString(4, YDMASessonUtil.getCompnoInfo().getCompno());
                YDMAStringUtil.Print("[getHousingListByOption]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                    list.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int processRecvDtlUpdate(int brandcd, int warecd, String recvdt, int recvseq, String gubun, String seq, String sp1, String sp2, String sp3, String sp4, String sp5) throws Exception {
        int result = 0;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql_orddtl = " update recvdtl set sparerack1 = ?, sparerack2 = ? ,  sparerack3=?, sparerack4=?, sparerack5=?,updatedt = ?, \t\t\t\t\t\t  updateid = ?, warecd = ?  where recvdt = ? and recvseq = ? and seq =?  and compno = ? and brandcd = ? ";
                sql_orddtl = sql_orddtl.toUpperCase();
                pstmt = connection.prepareStatement(sql_orddtl);
                statementlist.add(pstmt);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, sp1);
                pstmt.setString(++rowIdx, sp2);
                pstmt.setString(++rowIdx, sp3);
                pstmt.setString(++rowIdx, sp4);
                pstmt.setString(++rowIdx, sp5);
                pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setInt(++rowIdx, warecd);
                pstmt.setString(++rowIdx, recvdt);
                pstmt.setInt(++rowIdx, recvseq);
                pstmt.setInt(++rowIdx, Integer.parseInt(seq));
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(++rowIdx, brandcd);
                result = pstmt.executeUpdate();
                YDMAStringUtil.Print("[processRecvDtlUpdate]" + pstmt.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return result;
    }

    public List<String> getSpareRackList(List<String> list) throws Exception {
        ArrayList<String> rack = new ArrayList<String>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT distinct recvdt, ifnull(sparerack1,''), ifnull(sparerack2,''), ifnull(sparerack3,''), ifnull(sparerack4,''), ifnull(sparerack5,'') FROM RECVDTL  WHERE compno = ? and prodcd= ?  AND ifnull(sparerack1,'') <> '' ORDER BY recvdt DESC LIMIT 1";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(2, list.get(1));
                YDMAStringUtil.Print("[getSpareRackList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    rack.add(rs.getString(++columnIndex));
                    rack.add(rs.getString(++columnIndex));
                    rack.add(rs.getString(++columnIndex));
                    rack.add(rs.getString(++columnIndex));
                    rack.add(rs.getString(++columnIndex));
                    rack.add(rs.getString(++columnIndex));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return rack;
    }

    public List<String> getSafetyStock(List<List<String>> contents, int brandcd) throws Exception {
        ArrayList<String> con;
        block6: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            con = new ArrayList<String>();
            new ArrayList();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String param = contents.stream().map(p -> "'" + (String)p.get(1) + "'").collect(Collectors.joining(","));
                    Object sql = String.format("SELECT ifnull(APROINVT,'0') FROM prodmst where prodcd in(%s)", param) + " AND compno = ? and brandcd = ?";
                    sql = ((String)sql).toUpperCase();
                    pstmt = connection.prepareStatement((String)sql);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(2, brandcd);
                    YDMAStringUtil.Print("[getProductMstList]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        con.add(rs.getString(1));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return con;
    }

    public void recvWareInsert(Connection connection, List<PreparedStatement> statementlist, List<List<String>> chekedContents, String recvdt, int recvseq, int brandcd, String realdt) throws Exception {
        PreparedStatement pstmt = null;
        RackDao hDao = new RackDao();
        String sql_orddtl = " insert into recvware ( COMPNO ,BRANDCD, RECVDT, RECVSEQ,  SEQ, NECSEQ, WARECD,  NECCD1, NECCD2, NECCD3,BEFQTY,PRODCD,AFTQTY,REALDT )   VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,? , ?,?)";
        sql_orddtl = sql_orddtl.toUpperCase();
        pstmt = connection.prepareStatement(sql_orddtl);
        statementlist.add(pstmt);
        for (List<String> list : chekedContents) {
            List<String> ract = hDao.selectRackInfo(connection, brandcd, list.get(1));
            int necseq = this.getMaxNecSeq(connection, statementlist, brandcd, recvdt, recvseq, Integer.parseInt(list.get(0)));
            if (necseq > 1) continue;
            int rowIdx = 0;
            pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
            pstmt.setInt(++rowIdx, brandcd);
            pstmt.setString(++rowIdx, recvdt);
            pstmt.setInt(++rowIdx, recvseq);
            pstmt.setInt(++rowIdx, Integer.parseInt(list.get(0)));
            pstmt.setInt(++rowIdx, 1);
            pstmt.setString(++rowIdx, ract.get(0));
            pstmt.setString(++rowIdx, ract.get(3));
            pstmt.setString(++rowIdx, ract.get(4));
            pstmt.setString(++rowIdx, ract.get(5));
            pstmt.setString(++rowIdx, list.get(5));
            pstmt.setString(++rowIdx, list.get(1));
            pstmt.setString(++rowIdx, list.get(5));
            pstmt.setString(++rowIdx, realdt);
            YDMAStringUtil.Print("[insertUpdateRecvDtl]" + pstmt.toString());
            pstmt.addBatch();
            pstmt.clearParameters();
        }
        pstmt.executeBatch();
        pstmt.clearParameters();
    }

    public void deleteRecvWare(String recvdt, int recvseq, int brandcd) throws Exception {
        block5: {
            PreparedStatement pstmt = null;
            Connection connection = null;
            ResultSet rs = null;
            new ArrayList();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
                    String sql = " delete from recvware where COMPNO=? and BRANDCD=? and RECVDT = ? and RECVSEQ = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(2, brandcd);
                    pstmt.setString(3, recvdt);
                    pstmt.setInt(4, recvseq);
                    YDMAStringUtil.Print("[deleteRecvWare]" + pstmt.toString());
                    pstmt.execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public List<MoveWareDto> setLocationMoveMst(List<MoveWareDto> wareList) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    String sql_orddtl = "INSERT INTO movemst \r\n\t(COMPNO, BRANDCD, MOVEDT, MOVESEQ, PRODCD, OLD_WARECD, OLD_NECCD1, OLD_NECCD2, OLD_NECCD3, QTY, INSERTDT, INSERTID)\r\n\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    connection = DBCPInit.getInstance().getConnection();
                    connection.setAutoCommit(false);
                    if (wareList.get(0).getMoveseq() == -1) {
                        wareList.get(0).setMoveseq(this.getMaxMoveSeq(connection, statementlist, wareList.get(0).getBrandcd()));
                        wareList.get(0).setMovedt(YDMATimeUtil.getCurrentTimeByFreeFormat("yyyyMMdd"));
                    }
                    pstmt = connection.prepareStatement(sql_orddtl);
                    statementlist.add(pstmt);
                    int rowIdx = 0;
                    pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++rowIdx, wareList.get(0).getBrandcd());
                    pstmt.setString(++rowIdx, wareList.get(0).getMovedt());
                    pstmt.setInt(++rowIdx, wareList.get(0).getMoveseq());
                    pstmt.setString(++rowIdx, wareList.get(0).getProdcd());
                    pstmt.setInt(++rowIdx, wareList.get(0).getOld_warecd());
                    pstmt.setString(++rowIdx, wareList.get(0).getOld_neccd1());
                    pstmt.setInt(++rowIdx, wareList.get(0).getOld_neccd2());
                    pstmt.setInt(++rowIdx, wareList.get(0).getOld_neccd3());
                    pstmt.setInt(++rowIdx, wareList.get(0).getQty());
                    pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    YDMAStringUtil.Print("[setLocationMoveMst]" + pstmt.toString());
                    pstmt.execute();
                    connection.commit();
                }
                catch (Exception e) {
                    connection.rollback();
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return wareList;
    }

    public void setLocationMoveDtl(List<MoveWareDto> wareList) throws Exception {
        block6: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    String sql = " INSERT INTO movedtl\r\n\t(COMPNO, BRANDCD, MOVEDT, MOVESEQ, SEQ, PRODCD, OLD_WARECD, OLD_NECCD1, OLD_NECCD2, OLD_NECCD3,     NEW_WARECD, NEW_NECCD1, NEW_NECCD2, NEW_NECCD3, QTY)\r\n\tVALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
                    sql = sql.toUpperCase();
                    connection = DBCPInit.getInstance().getConnection();
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement(sql);
                    statementlist.add(pstmt);
                    for (MoveWareDto dto : wareList) {
                        int rowIdx = 0;
                        pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                        pstmt.setInt(++rowIdx, wareList.get(0).getBrandcd());
                        pstmt.setString(++rowIdx, wareList.get(0).getMovedt());
                        pstmt.setInt(++rowIdx, wareList.get(0).getMoveseq());
                        pstmt.setInt(++rowIdx, dto.getSeq());
                        pstmt.setString(++rowIdx, dto.getProdcd());
                        pstmt.setInt(++rowIdx, dto.getOld_warecd());
                        pstmt.setString(++rowIdx, dto.getOld_neccd1());
                        pstmt.setInt(++rowIdx, dto.getOld_neccd2());
                        pstmt.setInt(++rowIdx, dto.getOld_neccd3());
                        pstmt.setInt(++rowIdx, dto.getNew_warecd());
                        pstmt.setString(++rowIdx, dto.getNew_neccd1());
                        pstmt.setInt(++rowIdx, dto.getNew_neccd2());
                        pstmt.setInt(++rowIdx, dto.getNew_neccd3());
                        pstmt.setInt(++rowIdx, dto.getQty());
                        YDMAStringUtil.Print("[setLocationMoveDtl]" + pstmt.toString());
                        pstmt.addBatch();
                        pstmt.clearParameters();
                    }
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                    connection.commit();
                }
                catch (Exception e) {
                    connection.rollback();
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    public void recvWareInsert(List<WarehouseDto> wareList, List<String> list, String recvdt, int recvseq, int brandcd, int warecd, String befqty, String realdt) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                String sql_orddtl = " insert into recvware ( COMPNO ,BRANDCD, RECVDT, RECVSEQ,  SEQ, NECSEQ, WARECD,  NECCD1, NECCD2, NECCD3,BEFQTY,PRODCD,AFTQTY,REALDT)   VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
                sql_orddtl = sql_orddtl.toUpperCase();
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                if (recvseq == -1) {
                    recvseq = this.getMaxRecvSeq(connection, statementlist, brandcd);
                }
                if (recvdt.equals("")) {
                    recvdt = YDMATimeUtil.getCurrentDateHanjin();
                }
                pstmt = connection.prepareStatement(sql_orddtl);
                statementlist.add(pstmt);
                wareList.stream().filter(d -> d.getQty().equals("0")).count();
                int idx = 0;
                for (WarehouseDto dto : wareList) {
                    int rowIdx = 0;
                    int qty = 0;
                    qty = idx == 0 ? Integer.parseInt(befqty) : 0;
                    pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(++rowIdx, brandcd);
                    pstmt.setString(++rowIdx, recvdt);
                    pstmt.setInt(++rowIdx, recvseq);
                    pstmt.setInt(++rowIdx, Integer.parseInt(list.get(0)));
                    pstmt.setString(++rowIdx, dto.getNecseq());
                    pstmt.setInt(++rowIdx, dto.getWarecd());
                    pstmt.setString(++rowIdx, dto.getNeccd1());
                    pstmt.setString(++rowIdx, dto.getNeccd2());
                    pstmt.setString(++rowIdx, dto.getNeccd3());
                    pstmt.setInt(++rowIdx, qty);
                    pstmt.setString(++rowIdx, list.get(1));
                    pstmt.setString(++rowIdx, dto.getQty());
                    pstmt.setString(++rowIdx, realdt);
                    YDMAStringUtil.Print("[insertUpdateRecvDtl]" + pstmt.toString());
                    pstmt.addBatch();
                    pstmt.clearParameters();
                    ++idx;
                }
                pstmt.executeBatch();
                pstmt.clearParameters();
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                e.printStackTrace();
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void deleteRecvWare(List<String> list, String recvdt, int recvseq, int brandcd, int warecd) throws Exception {
        PreparedStatement pstmt = null;
        Connection connection = null;
        ResultSet rs = null;
        new ArrayList();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
                String sql = " delete from recvware where COMPNO=? and BRANDCD=? and RECVDT = ? and RECVSEQ = ? and SEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                statementlist.add(pstmt);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, recvdt);
                pstmt.setInt(4, recvseq);
                pstmt.setString(5, list.get(0));
                YDMAStringUtil.Print("[deleteRecvWare]" + pstmt.toString());
                pstmt.execute();
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void updateRecvDtlQty(String befqty, String realqty, String recvdt, int recvseq, List<String> list, int brandcd, String beforeqty, String afterqty) throws Exception {
        Connection connection = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmtmst = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                String sql_orddtl = " update recvdtl set BEFQTY = ?, AFTQTY = ?, UPDATEDT = ?, UPDATEID = ?  where recvdt = ? and recvseq = ? and seq =?  and compno = ? and brandcd = ? ";
                sql_orddtl = sql_orddtl.toUpperCase();
                pstmt = connection.prepareStatement(sql_orddtl);
                statementlist.add(pstmt);
                int rowIdx = 0;
                pstmt.setString(++rowIdx, befqty);
                pstmt.setString(++rowIdx, realqty);
                pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                pstmt.setString(++rowIdx, recvdt);
                pstmt.setInt(++rowIdx, recvseq);
                pstmt.setString(++rowIdx, list.get(0));
                pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(++rowIdx, brandcd);
                pstmt.executeUpdate();
                YDMAStringUtil.Print("[processRecvDtlUpdate]" + pstmt.toString());
                String sql_ordmst = " update recvmst set BEFQTY = ?, AFTQTY = ?, UPDATEDT = ?, UPDATEID = ?  where recvdt = ? and recvseq = ? and compno = ? and brandcd = ? ";
                sql_ordmst = sql_ordmst.toUpperCase();
                pstmtmst = connection.prepareStatement(sql_ordmst);
                statementlist.add(pstmtmst);
                rowIdx = 0;
                pstmtmst.setString(++rowIdx, beforeqty);
                pstmtmst.setString(++rowIdx, afterqty);
                pstmtmst.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                pstmtmst.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                pstmtmst.setString(++rowIdx, recvdt);
                pstmtmst.setInt(++rowIdx, recvseq);
                pstmtmst.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmtmst.setInt(++rowIdx, brandcd);
                pstmtmst.executeUpdate();
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
    }

    public void recvWareUpdate(List<List<String>> chekedContents, String recvdt, int recvseq, int brandcd, String realdt) throws Exception {
        block11: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
            try {
                try {
                    String sql_orddtl = " UPDATE RECVWARE SET AFTQTY = ?, REALDT = ? WHERE COMPNO = ? AND BRANDCD = ? AND RECVDT = ? AND RECVSEQ = ? AND SEQ = ? AND NECSEQ = ? ";
                    sql_orddtl = sql_orddtl.toUpperCase();
                    connection = DBCPInit.getInstance().getConnection();
                    connection.setAutoCommit(false);
                    if (recvseq == -1) {
                        recvseq = this.getMaxRecvSeq(connection, statementlist, brandcd);
                    }
                    if (recvdt.equals("")) {
                        recvdt = YDMATimeUtil.getCurrentDateHanjin();
                    }
                    pstmt = connection.prepareStatement(sql_orddtl);
                    statementlist.add(pstmt);
                    for (List<String> list : chekedContents) {
                        List<List<String>> recvContents = this.getRecvWareList(brandcd, recvdt, recvseq, list);
                        for (List<String> recvList : recvContents) {
                            int rowIdx = 0;
                            pstmt.setString(++rowIdx, recvList.get(10));
                            if (Integer.parseInt(list.get(6)) > 0) {
                                pstmt.setString(++rowIdx, realdt);
                            } else {
                                pstmt.setString(++rowIdx, "");
                            }
                            pstmt.setString(++rowIdx, YDMASessonUtil.getCompnoInfo().getCompno());
                            pstmt.setInt(++rowIdx, brandcd);
                            pstmt.setString(++rowIdx, recvList.get(0));
                            pstmt.setString(++rowIdx, recvList.get(1));
                            pstmt.setString(++rowIdx, recvList.get(2));
                            pstmt.setString(++rowIdx, recvList.get(3));
                            pstmt.addBatch();
                            pstmt.clearParameters();
                        }
                    }
                    pstmt.executeBatch();
                    pstmt.clearParameters();
                    connection.commit();
                }
                catch (Exception e) {
                    connection.rollback();
                    e.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
    }

    private List<List<String>> getRecvWareList(int brandcd, String recvdt, int recvseq, List<String> list) throws Exception {
        ArrayList<List<String>> rack = new ArrayList<List<String>>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                String sql = "SELECT RECVDT, ifnull(RECVSEQ,''), ifnull(SEQ,''), ifnull(NECSEQ,''), ifnull(PRODCD,''), ifnull(WARECD,''),  ifnull(NECCD1,''), ifnull(NECCD2,''), ifnull(NECCD3,''), ifnull(BEFQTY,'0'), ifnull(AFTQTY,'0') FROM RECVWARE  WHERE compno = ? and BRANDCD= ?  AND RECVDT = ? AND RECVSEQ = ? AND SEQ = ? ";
                sql = sql.toUpperCase();
                pstmt = connection.prepareStatement(sql);
                pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setInt(2, brandcd);
                pstmt.setString(3, recvdt);
                pstmt.setInt(4, recvseq);
                pstmt.setString(5, list.get(0));
                YDMAStringUtil.Print("[getSpareRackList]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int columnIndex = 0;
                    ArrayList<String> rac = new ArrayList<String>();
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rac.add(rs.getString(++columnIndex));
                    rack.add(rac);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return rack;
    }

    public void recvWareDelete(List<List<String>> deleteContents) {
    }

    public int insertRecvManager(int brandcd, List<List<String>> contents, String recvdt, String gubun, String recvdesc, int totalBeforeQty, int totalAfterQty, String confnam, String contno, String realdt, String plandt, int recvseq) throws Exception {
        Connection connection = null;
        ResultSet rs = null;
        ArrayList<PreparedStatement> statementlist = new ArrayList<PreparedStatement>();
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                connection.setAutoCommit(false);
                if (recvseq == -1) {
                    recvseq = this.getMaxRecvSeq(connection, statementlist, brandcd);
                    this.insertRecvMst(brandcd, connection, statementlist, contents, recvdt, recvseq, gubun, recvdesc, totalBeforeQty, totalAfterQty, confnam, contno, realdt);
                    this.insertRecvDtl(brandcd, connection, statementlist, contents, recvdt, recvseq, realdt, plandt);
                } else {
                    this.updateRecvMst(brandcd, connection, statementlist, contents, recvdt, recvseq, gubun, recvdesc, totalBeforeQty, totalAfterQty, confnam, contno, realdt);
                    this.insertRecvDtl(brandcd, connection, statementlist, contents, recvdt, recvseq, realdt, plandt);
                }
                connection.commit();
            }
            catch (Exception ex) {
                connection.rollback();
                ex.printStackTrace();
                throw ex;
            }
        }
        finally {
            DBCPInit.getInstance().freeConnection(connection, statementlist, rs);
        }
        return recvseq;
    }
}

