/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.data.dao;

import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import com.kdjsystem.mlink.tot.data.dao.WarehouseDto;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class WarehouseDao {
    public static WarehouseDao instance = new WarehouseDao();

    private WarehouseDao() {
    }

    public static WarehouseDao get() {
        return instance;
    }

    public List<WarehouseDto> getWaresByAll(int brandcd) throws Exception {
        ArrayList<WarehouseDto> list;
        block8: {
            list = new ArrayList<WarehouseDto>();
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    Object sql = " select warecd,warenm,dspseq   from warehouse where compno = ? ";
                    if (brandcd != -1) {
                        sql = (String)sql + "  and brandcd = ? ";
                    }
                    sql = (String)sql + " order by dspseq ";
                    sql = ((String)sql).toUpperCase();
                    pstmt = connection.prepareStatement((String)sql);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    if (brandcd != -1) {
                        pstmt.setInt(2, brandcd);
                    }
                    YDMAStringUtil.Print("[getWaresByAll]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int columnIndex = 0;
                        WarehouseDto dto = new WarehouseDto();
                        dto.setWarecd(rs.getInt(++columnIndex));
                        dto.setWarenm(rs.getString(++columnIndex));
                        dto.setDspseq(rs.getInt(++columnIndex));
                        list.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return list;
    }

    public List<WarehouseDto> getWareRack(int brandcd, String recvdt, int recvseq, String seq) throws Exception {
        ArrayList<WarehouseDto> list;
        block6: {
            list = new ArrayList<WarehouseDto>();
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = " select COMPNO,BRANDCD,RECVDT,RECVSEQ,SEQ,NECSEQ,WARECD,NECCD1,NECCD2,NECCD3,BEFQTY,AFTQTY   from recvware where compno = ? and BRANDCD = ? and RECVDT = ? and RECVSEQ = ? and SEQ = ? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setInt(2, brandcd);
                    pstmt.setString(3, recvdt);
                    pstmt.setInt(4, recvseq);
                    pstmt.setString(5, seq);
                    YDMAStringUtil.Print("[getWaresByAll]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int columnIndex = 0;
                        WarehouseDto dto = new WarehouseDto();
                        dto.setCompno(rs.getInt(++columnIndex));
                        dto.setBrandcd(rs.getInt(++columnIndex));
                        dto.setRecvdt(rs.getString(++columnIndex));
                        dto.setRecvseq(rs.getString(++columnIndex));
                        dto.setSeq(rs.getString(++columnIndex));
                        dto.setNecseq(rs.getString(++columnIndex));
                        dto.setWarecd(rs.getInt(++columnIndex));
                        dto.setNeccd1(rs.getString(++columnIndex));
                        dto.setNeccd2(rs.getString(++columnIndex));
                        dto.setNeccd3(rs.getString(++columnIndex));
                        dto.setQty(rs.getString(++columnIndex));
                        dto.setAftqty(rs.getString(++columnIndex));
                        list.add(dto);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return list;
    }

    public boolean isexist(String prodcd) throws Exception {
        boolean flag;
        block7: {
            int result = 0;
            flag = true;
            Connection connection = null;
            PreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    String sql = " select count(prodcd) AS CNT   from necprodmst where compno = ?  and prodcd =? ";
                    sql = sql.toUpperCase();
                    pstmt = connection.prepareStatement(sql);
                    pstmt.setString(1, YDMASessonUtil.getCompnoInfo().getCompno());
                    pstmt.setString(2, prodcd);
                    YDMAStringUtil.Print("[getWaresByAll]" + pstmt.toString());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        result = rs.getInt("CNT");
                    }
                    if (result > 0) {
                        flag = false;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        }
        return flag;
    }

    public List<String> getProdcutListforRack(int brandcd, List<String> listTemp) throws Exception {
        ArrayList<String> list = null;
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                Object sql = "select  (select warenm from warehouse as C where A.compno=C.compno and A.brandcd=C.brandcd and C.warecd = ?) as warenm, " + String.format("YWM_FUNC_BOSSPRODCD(%s,%s,A.prodcd) as img,", YDMASessonUtil.getCompnoInfo().getCompno(), brandcd) + "case ifnull(A.SPECDES,'') when '' then A.ProdNm ELSE CONCAT(A.prodnm ,'_',A.SPECDES) end  from prodmst as A  left join necprodmst B  on A.prodcd=B.prodcd and A.compno = B.compno and A.brandcd = B.brandcd where A.compno = ? and A.prodcd = ? and A.brandcd = ?";
                sql = ((String)sql).toUpperCase();
                pstmt = connection.prepareStatement((String)sql);
                pstmt.setString(1, listTemp.get(1));
                pstmt.setString(2, YDMASessonUtil.getCompnoInfo().getCompno());
                pstmt.setString(3, listTemp.get(2).toString());
                pstmt.setInt(4, brandcd);
                rs = pstmt.executeQuery();
                YDMAStringUtil.Print("[getProdcutListforRack]" + pstmt.toString());
                int rowno = 0;
                while (rs.next()) {
                    int i = 0;
                    list = new ArrayList<String>();
                    list.add("" + ++rowno);
                    list.add(listTemp.get(1));
                    list.add(rs.getString(++i));
                    list.add(listTemp.get(2));
                    list.add(rs.getString(++i));
                    list.add(rs.getString(++i));
                    list.add(listTemp.get(3));
                    list.add(listTemp.get(4));
                    list.add(listTemp.get(5));
                    list.add(String.valueOf(brandcd));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }
}

