/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.tot.ui;

import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.ProductSchedulerSyncDTO;
import com.kdjsystem.mlink.shop.dao.ScheduleInfoDao;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.ui.CommandDialog;
import com.kdjsystem.mlink.tot.ui.MyCellRenderer;
import com.kdjsystem.mlink.tot.ui.MyColumnHeaderRenderer;
import com.kdjsystem.mlink.tot.ui.ProductSchedulerDialog;
import com.kdjsystem.mlink.tot.ui.ProductSchedulerSyncClearSiteDetailDialog;
import com.kdjsystem.mlink.tot.ui.ProductSchedulerSyncClearSiteSelectDialog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridCellRenderer;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.nebula.widgets.grid.GridHeaderRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;

public class ProductSchedulerSyncClearSiteDialog
extends CommandDialog {
    public static String TITLE = "\uc0ac\uc774\ud2b8 \uc124\uc815";
    String[][] column_name_shop = new String[][]{{"\uc1fc\ud551\ubab0\uba85", "150"}, {"ID", "150"}, {"\ub2c9\ub124\uc784", "150"}, {"\uc791\uc5c5\uc77c\uc790", "270"}};
    private ProductSchedulerDialog _opener;
    private Button btn_siteAdd;
    private Button btn_siteModify;
    private Button btn_siteDelete;
    private GridTableViewer gridTableViewer_shop;
    private Grid grid_shop;
    private boolean _set_flag = false;
    private int _set_seq = 0;

    public ProductSchedulerSyncClearSiteDialog(Shell parentShell, ProductSchedulerDialog opener, boolean set_flag, int set_seq) {
        super(parentShell);
        this._opener = opener;
        this._set_flag = set_flag;
        this._set_seq = set_seq;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 2048);
        container.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite_header = new Composite(container, 0);
        composite_header.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        composite_header.setLayout((Layout)new GridLayout(3, false));
        this.btn_siteAdd = new Button(composite_header, 0);
        this.btn_siteAdd.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btn_siteAdd.setText("\ucd94\uac00");
        this.btn_siteAdd.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ub4f1\ub85d.png"));
        this.btn_siteAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductSchedulerSyncClearSiteDialog.this.btn_siteAdd_selectionEvent();
            }
        });
        this.btn_siteModify = new Button(composite_header, 0);
        this.btn_siteModify.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btn_siteModify.setText("\uc218\uc815");
        this.btn_siteModify.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc218\uc815.png"));
        this.btn_siteModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductSchedulerSyncClearSiteDialog.this.btn_siteModify_selectionEvent();
            }
        });
        this.btn_siteDelete = new Button(composite_header, 0);
        this.btn_siteDelete.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btn_siteDelete.setText("\uc0ad\uc81c");
        this.btn_siteDelete.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\uc0ad\uc81c.png"));
        this.btn_siteDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProductSchedulerSyncClearSiteDialog.this.btn_siteDelete_selectionEvent();
            }
        });
        Composite composite_body = new Composite(container, 0);
        composite_body.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite_body.setLayout((Layout)new GridLayout(1, false));
        this.gridTableViewer_shop = new GridTableViewer(composite_body, 780);
        this.gridTableViewer_shop.setContentProvider((IContentProvider)new MyContentProvider());
        this.gridTableViewer_shop.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.gridTableViewer_shop.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProductSchedulerSyncClearSiteDialog.this.btn_siteModify_selectionEvent();
            }
        });
        this.grid_shop = this.gridTableViewer_shop.getGrid();
        this.grid_shop.setLayoutData((Object)new GridData(4, 4, true, true, 11, 1));
        this.grid_shop.setFont(SWTResourceManager.getFont("\ub9d1\uc740 \uace0\ub515", 10, 0));
        this.grid_shop.setLineColor(SWTResourceManager.getColor(18));
        this.grid_shop.setLinesVisible(true);
        this.grid_shop.setHeaderVisible(true);
        MyColumnHeaderRenderer myHeaderRender = new MyColumnHeaderRenderer();
        myHeaderRender.setRGB(68, 80, 94);
        myHeaderRender.setFGC(1);
        MyCellRenderer myCellRenderer = new MyCellRenderer();
        myCellRenderer.setColumnAlign(0x1000000);
        int i = 0;
        while (i < this.column_name_shop.length) {
            String[] column = this.column_name_shop[i];
            GridColumn tableViewerColumn_x = new GridColumn(this.grid_shop, 0x1000000);
            tableViewerColumn_x.setHeaderRenderer((GridHeaderRenderer)myHeaderRender);
            tableViewerColumn_x.setCellRenderer((GridCellRenderer)myCellRenderer);
            tableViewerColumn_x.setWidth(Integer.parseInt(column[1]));
            tableViewerColumn_x.setText(column[0]);
            ++i;
        }
        this.initGrid();
        return container;
    }

    private void initGrid() {
        int compno = Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno());
        int jobCode = 1;
        List<Object> syncInfo = new ArrayList();
        try {
            syncInfo = ScheduleInfoDao.get().getProductScheduleSyncSiteByJobcd(compno, jobCode);
            this.gridTableViewer_shop.setInput(null);
            this.gridTableViewer_shop.setInput(syncInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btn_siteAdd_selectionEvent() {
        ProductSchedulerSyncClearSiteSelectDialog dialog = new ProductSchedulerSyncClearSiteSelectDialog(this.getShell(), "ADD", null);
        dialog.open();
        this.initGrid();
    }

    private void btn_siteModify_selectionEvent() {
        if (this.grid_shop.getSelectionIndex() > -1) {
            ProductSchedulerSyncDTO item = (ProductSchedulerSyncDTO)((List)this.gridTableViewer_shop.getInput()).get(this.grid_shop.getSelectionIndex());
            if (item != null) {
                ProductSchedulerSyncClearSiteDetailDialog dialog = new ProductSchedulerSyncClearSiteDetailDialog(this.getShell(), "MODIFY", item);
                dialog.open();
                this.initGrid();
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc120\ud0dd\ub41c \uc815\ubcf4\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
        } else {
            List items = (List)this.gridTableViewer_shop.getInput();
            if (items != null) {
                ProductSchedulerSyncClearSiteSelectDialog dialog = new ProductSchedulerSyncClearSiteSelectDialog(this.getShell(), "MODIFY", items);
                dialog.open();
                this.initGrid();
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc120\ud0dd\ub41c \uc815\ubcf4\uac00 \uc874\uc7ac\ud558\uc9c0 \uc54a\uc2b5\ub2c8\ub2e4.");
            }
        }
    }

    private void btn_siteDelete_selectionEvent() {
        boolean flag;
        ProductSchedulerSyncDTO item = (ProductSchedulerSyncDTO)((List)this.gridTableViewer_shop.getInput()).get(this.grid_shop.getSelectionIndex());
        if (item != null && (flag = MessageDialog.openQuestion((Shell)this.getShell(), (String)TITLE, (String)"\uc120\ud0dd\ud558\uc2e0 \uc815\ubcf4\ub97c \uc0ad\uc81c\ud558\uc2dc\uaca0\uc2b5\ub2c8\uae4c ?"))) {
            try {
                int result = ScheduleInfoDao.get().deleteScheduleSyncSite(1, item.getShopcd(), String.valueOf(item.getShopseq()));
                if (result > 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc815\uc0c1\uc801\uc73c\ub85c \uc0ad\uc81c\uac00 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)"\uc0ad\uc81c\uc5d0 \uc2e4\ud328\ud588\uc2b5\ub2c8\ub2e4.");
                }
                this.initGrid();
            }
            catch (Exception e) {
                e.printStackTrace();
                MessageDialog.openInformation((Shell)this.getShell(), (String)TITLE, (String)e.getMessage());
            }
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button btnCancel = this.createButton(parent, 1, "\ub2eb\uae30", false);
        btnCancel.setImage(ResourceManager.getPluginImage("com.kdjsystem.mlink.tot", "icons/N\ucde8\uc18c.png"));
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(TITLE);
        super.configureShell(newShell);
    }

    protected Point getInitialSize() {
        return new Point(750, 550);
    }

    private class MyContentProvider
    implements IStructuredContentProvider {
        private MyContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Object[]) {
                return (Object[])inputElement;
            }
            if (inputElement instanceof Collection) {
                return ((Collection)inputElement).toArray();
            }
            return new Object[0];
        }
    }

    private class MyLabelProvider
    extends ColumnLabelProvider
    implements ITableLabelProvider {
        private MyLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            ProductSchedulerSyncDTO dto = (ProductSchedulerSyncDTO)element;
            switch (columnIndex) {
                case 0: {
                    return ShopCommon.getShoppingMallName(dto.getShopcd());
                }
                case 1: {
                    return dto.getShoppingid();
                }
                case 2: {
                    return dto.getNickname();
                }
                case 3: {
                    return String.format("\ub9e4\uc8fc %s\uc694\uc77c %s\uc2dc %s\ubd84\uc5d0 \uc791\ub3d9", ShopCommon.getDayString(dto.getSyncday()), dto.getSynchour(), dto.getSyncmin());
                }
            }
            return "";
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

