/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.coupang;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.coupang.IShopOrderCoupangCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

class CoupangOrderNewCommand
extends IShopOrderCoupangCommand {
    private static IShopOrderCommand instance = new CoupangOrderNewCommand();
    IShopCommonLogin login = new IShopCommonLogin(){};
    JsonParser parser = new JsonParser();
    private boolean isBasic = false;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private CoupangOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret_list = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto dto = param.get(0);
        String startdt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse(startdt);
        Date edate = formatter.parse(enddt);
        long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
        int num = (int)range % 30 == 0 ? (int)range / 30 : (int)range / 30 + 1;
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(sdate);
        if (num > 1) {
            cal2.add(5, 29);
            enddt = formatter.format(cal2.getTime());
        }
        this.isBasic = dto.getSpecificStatus() == null || dto.getSpecificStatus().equals("");
        int i = 0;
        while (i < num) {
            if (this.isBasic) {
                this.getApiList(dto, "ACCEPT", ret_list, startdt, enddt);
                this.getApiList(dto, "INSTRUCT", ret_list, startdt, enddt);
                this.getApiList(dto, "FINAL_DELIVERY", ret_list, startdt, enddt);
            } else {
                this.getOrderLite(dto, ret_list, startdt, enddt);
            }
            cal1.add(5, 30);
            startdt = formatter.format(cal1.getTime());
            if (i == num - 2) {
                enddt = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
            } else {
                cal2.add(5, 30);
                enddt = formatter.format(cal2.getTime());
            }
            ++i;
        }
        return ret_list;
    }

    /*
     * Exception decompiling
     */
    private void getOrderLite(ShopOrderMstDto dto, List<ShopOrderMstDto> ret_list, String startdt, String enddt) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[10] lbl66 : CaseStatement: default:\u000a, @NONE, blocks:[10] lbl66 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getApiList(ShopOrderMstDto dto, String cmd, List<ShopOrderMstDto> ret_list, String startdt, String enddt) throws Exception {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v5/vendors/%s/ordersheets";
            String acessKey = dto.getAuthkey1();
            String secretKey = dto.getAuthKey2();
            String vendorid = dto.getVendorId();
            URL2 = String.format(URL2, vendorid);
            boolean flag = true;
            String token = "";
            while (flag) {
                URIBuilder uriBuilder = new URIBuilder().setPath(URL2).addParameter("createdAtFrom", startdt + "+09:00").addParameter("createdAtTo", enddt + "+09:00").addParameter("status", cmd).addParameter("nextToken", token);
                HttpGet get = this.getHttp(uriBuilder, secretKey, acessKey);
                client = HttpClients.createDefault();
                response = client.execute((HttpUriRequest)get);
                int status2 = response.getStatusLine().getStatusCode();
                String message = response.getStatusLine().getReasonPhrase();
                if (status2 == 200) {
                    InputStream is = response.getEntity().getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    JsonObject resObject = this.parser.parse((Reader)br).getAsJsonObject();
                    token = resObject.get("nextToken").getAsString();
                    flag = !token.equals("");
                    JsonArray datas = resObject.get("data").getAsJsonArray();
                    if (datas.size() <= 0) continue;
                    List<ShopOrderMstDto> retNew = this.getNewOrderBind(datas, dto, secretKey, acessKey);
                    ret_list.addAll(retNew);
                    continue;
                }
                throw new Exception(String.format("\ucfe0\ud321\uc11c\ubc84 \uc5d0\ub7ec:{%s}", message));
            }
        }
        catch (Throwable throwable) {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {}
        }
        if (client != null) {
            try {
                client.close();
            }
            catch (IOException iOException) {}
        }
    }

    private List<ShopOrderMstDto> getNewOrderBind(JsonArray datas, ShopOrderMstDto ordDto, String secretKey, String accessKey) throws Exception {
        ArrayList<ShopOrderMstDto> result_dto = new ArrayList<ShopOrderMstDto>();
        for (JsonElement ele : datas) {
            JsonObject data2 = ele.getAsJsonObject();
            JsonObject orderer = data2.get("orderer").getAsJsonObject();
            JsonObject receiver = data2.get("receiver").getAsJsonObject();
            JsonArray orderItems = data2.get("orderItems").getAsJsonArray();
            String status2 = this.jsonElementNullStr(data2.get("status"));
            int i = 0;
            while (i < orderItems.size()) {
                if (!this.isBasic || !ShopOrderDao.get().isOrdered(this.jsonElementNullStr(data2.get("orderId")))) {
                    JsonObject item = orderItems.get(i).getAsJsonObject();
                    ShopOrderMstDto dto = new ShopOrderMstDto();
                    this.setBasicInfo(dto, data2, ordDto, status2);
                    this.setReceiverInfo(dto, receiver);
                    this.setOrdererInfo(dto, orderer);
                    this.setProductInfo(dto, item);
                    String serviceFeeRatio = this.fetchServiceFeeRatio(item, ordDto, accessKey, secretKey);
                    String vendoritemName = this.jsonElementNullStr(item.get("vendorItemName"));
                    dto.setP_product_name(vendoritemName);
                    if (vendoritemName.contains(",")) {
                        dto.setP_sku_value(vendoritemName.substring(vendoritemName.indexOf(",") + 1).trim());
                    } else {
                        dto.setP_sku_value(this.jsonElementNullStr(item.get("sellerProductItemName")));
                    }
                    dto.setSku_value(this.jsonElementNullStr(item.get("externalVendorSkuCode")));
                    dto.setSale_cnt(this.jsonElementNullStr(item.get("shippingCount")));
                    dto.setWon_cost("0");
                    String saleCost = this.jsonElementNullStr(item.get("salesPrice").getAsJsonObject().get("units"));
                    String totalCost = this.jsonElementNullStr(item.get("orderPrice").getAsJsonObject().get("units"));
                    String delvCost = this.jsonElementNullStr(data2.get("shippingPrice").getAsJsonObject().get("units"));
                    dto.setSale_cost(saleCost);
                    dto.setDelv_cost(delvCost);
                    dto.setTotal_cost(totalCost);
                    int paycost = YDMAStringUtil.convertToInt(saleCost) + YDMAStringUtil.convertToInt(totalCost);
                    dto.setPay_cost(Integer.toString(paycost));
                    double orderPrice = Double.parseDouble(totalCost);
                    double ratio = Double.parseDouble(serviceFeeRatio);
                    String mallWonCost = String.valueOf(Math.round(orderPrice * ratio));
                    dto.setMall_won_cost(mallWonCost);
                    String deliveryMethod = this.jsonElementNullStr(item.get("deliveryChargeTypeName"));
                    if (deliveryMethod.equals("paid")) {
                        deliveryMethod = "\uc120\ubd88";
                    }
                    dto.setDelivery_method_str2(deliveryMethod);
                    if (this.isBasic) {
                        dto.setDelivery_id("");
                        dto.setInvoice_no("");
                    } else {
                        if (data2.has("deliveryCompanyName")) {
                            dto.setDeliveryName(this.jsonElementNullStr(data2.get("deliveryCompanyName")));
                        }
                        if (data2.has("invoiceNumber")) {
                            dto.setInvoice_no(this.jsonElementNullStr(data2.get("invoiceNumber")));
                        }
                    }
                    dto.setLabel("");
                    dto.setSku_id(this.jsonElementNullStr(item.get("vendorItemId")));
                    dto.setProduct_name(this.jsonElementNullStr(item.get("vendorItemPackageName")));
                    dto.setBox_ea("0");
                    dto.setMall_exp_cd(this.jsonElementNullStr(data2.get("shipmentBoxId")));
                    dto.setResult_code("1");
                    result_dto.add(dto);
                }
                ++i;
            }
        }
        return result_dto;
    }

    private String fetchServiceFeeRatio(JsonObject item, ShopOrderMstDto ordDto, String accessKey, String secretKey) throws Exception {
        String serviceFeeRatio;
        String kanCategoryId;
        String sellId;
        String sellerProductId = this.jsonElementNullStr(item.get("sellerProductId"));
        try {
            sellId = this.getSellIdFromCoupang(sellerProductId, accessKey, secretKey);
        }
        catch (Exception exception) {
            throw new Exception("\ucfe0\ud321 displayCategoryCode \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
        }
        Map<String, String> cookies = this.login.loginCookie(ordDto.getShop_userid(), ordDto.getShopPw(), ordDto.getShopid(), true, ordDto.getAuthkey1());
        try {
            kanCategoryId = this.getKanCategoryId(sellId, cookies);
        }
        catch (Exception exception) {
            throw new Exception("\ucfe0\ud321 kanCategoryId \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
        }
        try {
            serviceFeeRatio = this.getServiceFee(kanCategoryId, cookies);
        }
        catch (Exception exception) {
            throw new Exception("\ucfe0\ud321 serviceFeeRatio \uac00\uc838\uc624\ub294 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd");
        }
        return serviceFeeRatio;
    }

    private String getServiceFee(String kanCategoryId, Map<String, String> cookies) throws IOException {
        Connection.Response rs = Jsoup.connect((String)("https://wing.coupang.com/tenants/seller-web/v2/vendor-inventory/commission?categoryId=" + kanCategoryId)).cookies(cookies).header("Host", "wing.coupang.com").header("X-Requested-With", "XMLHttpRequest").header("Content-Type", "application/json").header("Origin", "https://wing.coupang.com").method(Connection.Method.GET).timeout(15000).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        JsonObject jsonobject1 = (JsonObject)this.parser.parse(rs.body());
        return String.format("%.3f", 1.0 - (double)jsonobject1.get("serviceFeeRatio").getAsFloat() * 1.1 / 100.0);
    }

    private String getKanCategoryId(String sellId, Map<String, String> cookies) throws IOException {
        Connection.Response rs = Jsoup.connect((String)("https://wing.coupang.com/tenants/seller-web/v2/vendor-inventory/kanCategory?displayCategoryCode=" + sellId)).cookies(cookies).header("Host", "wing.coupang.com").header("X-Requested-With", "XMLHttpRequest").header("Content-Type", "application/json").header("Origin", "https://wing.coupang.com").method(Connection.Method.GET).timeout(15000).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
        JsonObject jsonobject = (JsonObject)this.parser.parse(rs.body());
        return jsonobject.get("kanCategoryId").getAsString();
    }

    private String getSellIdFromCoupang(String sellerProductId, String accessKey, String secretKey) throws Exception {
        String url = "/v2/providers/seller_api/apis/api/v1/marketplace/seller-products/" + sellerProductId;
        URIBuilder uriBuilder = new URIBuilder().setPath(url);
        HttpGet get = this.getHttp(uriBuilder, secretKey, accessKey);
        CloseableHttpClient client = HttpClients.createDefault();
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        String sellId = "";
        if (response.getStatusLine().getStatusCode() == 200) {
            InputStream is = response.getEntity().getContent();
            BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
            JsonObject resObject = (JsonObject)this.parser.parse((Reader)br);
            JsonObject datas1 = (JsonObject)resObject.get("data");
            sellId = datas1.get("displayCategoryCode").getAsString();
        }
        return sellId;
    }

    private void setProductInfo(ShopOrderMstDto dto, JsonObject item) {
        dto.setMall_product_id(this.jsonElementNullStr(item.get("sellerProductId")));
        dto.setCompayny_goods_cd(this.jsonElementNullStr(item.get("externalVendorSkuCode")));
    }

    private void setOrdererInfo(ShopOrderMstDto dto, JsonObject orderer) {
        dto.setUser_id("");
        dto.setUser_name(this.jsonElementNullStr(orderer.get("name")));
        String ordererNumber = this.phonenumber_check(orderer.get("ordererNumber"));
        dto.setUser_tel(ordererNumber);
        String orderersafeNumber = this.phonenumber_check(orderer.get("safeNumber"));
        dto.setUser_cel(orderersafeNumber);
        String email = this.jsonElementNullStr(orderer.get("email"));
        dto.setUser_email(email);
    }

    private void setReceiverInfo(ShopOrderMstDto dto, JsonObject receiver) {
        dto.setReceive_name(this.jsonElementNullStr(receiver.get("name")));
        String tel = this.phonenumber_check(receiver.get("receiverNumber"));
        String safeNumber = this.phonenumber_check(receiver.get("safeNumber"));
        dto.setReceive_tel(tel);
        dto.setReceive_cel(safeNumber);
        dto.setReceive_email("");
        dto.setReceive_zipcode(this.jsonElementNullStr(receiver.get("postCode")));
        String addr = this.jsonElementNullStr(receiver.get("addr1")) + " " + this.jsonElementNullStr(receiver.get("addr2"));
        dto.setReceive_addr(addr);
    }

    private void setBasicInfo(ShopOrderMstDto dto, JsonObject data2, ShopOrderMstDto ordDto, String status2) {
        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setCompno(ordDto.getCompno());
        dto.setShopid(ordDto.getShopid());
        dto.setShop_userid(ordDto.getShop_userid());
        dto.setAuthkey1(ordDto.getAuthkey1());
        dto.setOrder_status(this.getStatus(status2));
        dto.setOrder_id(this.jsonElementNullStr(data2.get("orderId")));
        dto.setOrder_date(this.jsonElementNullStr(data2.get("orderedAt")).replace("T", " "));
        dto.setDelv_msg(this.jsonElementNullStr(data2.get("parcelPrintMessage")));
        dto.setCopy_idx(this.jsonElementNullStr(data2.get("shipmentBoxId")));
    }

    private String getStatus(String status2) {
        switch (status2) {
            case "INSTRUCT": 
            case "ACCEPT": {
                return "100";
            }
            case "DELIVERING": 
            case "DEPARTURE": {
                return "403";
            }
            case "FINAL_DELIVERY": {
                return "410";
            }
        }
        return "";
    }

    private void getApiCancelNReturnList(ShopOrderMstDto dto, List<ShopOrderMstDto> ret_list, String startdt, String enddt, boolean isCancel) {
        CloseableHttpResponse response = null;
        CloseableHttpClient client = null;
        try {
            String URL2 = "/v2/providers/openapi/apis/api/v6/vendors/%s/returnRequests";
            String acessKey = dto.getAuthkey1();
            String secretKey = dto.getAuthKey2();
            String vendorid = dto.getVendorId();
            URL2 = String.format(URL2, vendorid);
            if (isCancel) {
                int i = 0;
                while (i < 2) {
                    URIBuilder uriBuilder = this.getUrlBuilder(URL2, startdt, enddt);
                    if (i == 0) {
                        uriBuilder.addParameter("cancelType", "CANCEL");
                    } else {
                        uriBuilder.addParameter("status", "RU");
                    }
                    HttpGet get = this.getHttp(uriBuilder, secretKey, acessKey);
                    client = HttpClients.createDefault();
                    response = client.execute((HttpUriRequest)get);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        InputStream is = response.getEntity().getContent();
                        BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                        JsonObject resObject = this.parser.parse((Reader)br).getAsJsonObject();
                        JsonArray datas = resObject.get("data").getAsJsonArray();
                        this.getClaimOrderBind(datas, dto, ret_list, isCancel);
                    }
                    ++i;
                }
            } else {
                URIBuilder uriBuilder = this.getUrlBuilder(URL2, startdt, enddt);
                HttpGet get = this.getHttp(uriBuilder, secretKey, acessKey);
                client = HttpClients.createDefault();
                response = client.execute((HttpUriRequest)get);
                if (response.getStatusLine().getStatusCode() == 200) {
                    InputStream is = response.getEntity().getContent();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is, "utf-8"));
                    JsonObject resObject = this.parser.parse((Reader)br).getAsJsonObject();
                    JsonArray datas = resObject.get("data").getAsJsonArray();
                    this.getClaimOrderBind(datas, dto, ret_list, isCancel);
                }
            }
        }
        catch (Exception exception) {}
    }

    private URIBuilder getUrlBuilder(String URL2, String startdt, String enddt) {
        URIBuilder builder = new URIBuilder().setPath(URL2).addParameter("searchType", "timeFrame").addParameter("createdAtFrom", startdt.concat("T01:00")).addParameter("createdAtTo", enddt.concat("T23:59"));
        return builder;
    }

    private void getClaimOrderBind(JsonArray datas, ShopOrderMstDto ordDto, List<ShopOrderMstDto> ret_list, boolean isCancel) {
        try {
            int i = 0;
            while (i < datas.size()) {
                JsonObject data2 = datas.get(i).getAsJsonObject();
                ShopOrderMstDto dto = new ShopOrderMstDto();
                String receiptType = data2.get("receiptType").getAsString();
                String receiptStatus = data2.get("receiptStatus").getAsString();
                String status2 = this.getStatus(receiptType, receiptStatus);
                if (isCancel || !status2.equals("C01")) {
                    dto.setReceiptid(this.jsonElementNullStr(data2.get("receiptId")));
                    dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                    dto.setCompno(ordDto.getCompno());
                    dto.setShopid(ordDto.getShopid());
                    dto.setShop_userid(ordDto.getShop_userid());
                    dto.setAuthkey1(ordDto.getAuthkey1());
                    dto.setOrder_status(status2);
                    dto.setOrder_id(this.jsonElementNullStr(data2.get("orderId")));
                    dto.setOrder_date(this.jsonElementNullStr(data2.get("createdAt")).replace("T", " "));
                    JsonArray array = data2.get("returnItems").getAsJsonArray();
                    JsonObject returnItem = array.get(0).getAsJsonObject();
                    dto.setCopy_idx(this.jsonElementNullStr(returnItem.get("shipmentBoxId")));
                    dto.setReceive_name(this.jsonElementNullStr(data2.get("requesterName")));
                    String tel = this.phonenumber_check(data2.get("requesterRealPhoneNumber"));
                    String safeNumber = this.phonenumber_check(data2.get("requesterPhoneNumber"));
                    dto.setReceive_tel(tel);
                    dto.setReceive_cel(safeNumber);
                    dto.setReceive_email("");
                    dto.setReceive_zipcode(this.jsonElementNullStr(data2.get("requesterZipCode")));
                    String addr = this.jsonElementNullStr(data2.get("requesterAddress")) + " " + this.jsonElementNullStr(data2.get("requesterAddressDetail"));
                    dto.setReceive_addr(addr);
                    dto.setMall_product_id(this.jsonElementNullStr(returnItem.get("sellerProductId")));
                    String vendoritemName = this.jsonElementNullStr(returnItem.get("vendorItemName"));
                    dto.setP_product_name(vendoritemName);
                    if (vendoritemName.contains(",")) {
                        dto.setP_sku_value(vendoritemName.substring(vendoritemName.indexOf(",") + 1).trim());
                    }
                    dto.setSale_cnt(this.jsonElementNullStr(returnItem.get("purchaseCount")));
                    dto.setWon_cost("0");
                    dto.setDelivery_method_str2("");
                    if (data2.has("returnDeliveryDtos")) {
                        JsonArray returnDeliveryDtos = data2.get("returnDeliveryDtos").getAsJsonArray();
                        if (returnDeliveryDtos.size() > 0) {
                            JsonObject returnDeliveryDto = returnDeliveryDtos.get(0).getAsJsonObject();
                            dto.setDelivery_id(this.jsonElementNullStr(returnDeliveryDto.get("deliveryCompanyCode")));
                            dto.setInvoice_no(this.jsonElementNullStr(returnDeliveryDto.get("deliveryInvoiceNo")));
                        } else {
                            dto.setDelivery_id("");
                            dto.setInvoice_no("");
                        }
                    } else {
                        dto.setDelivery_id("");
                        dto.setInvoice_no("");
                    }
                    dto.setLabel("");
                    dto.setSku_id(this.jsonElementNullStr(returnItem.get("vendorItemId")));
                    dto.setProduct_name(this.jsonElementNullStr(returnItem.get("vendorItemPackageName")));
                    dto.setBox_ea("0");
                    dto.setMall_exp_cd(this.jsonElementNullStr(returnItem.get("shipmentBoxId")));
                    dto.setResult_code("1");
                    ret_list.add(dto);
                }
                ++i;
            }
        }
        catch (Exception exception) {}
    }
}

