/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.kdjsystem.mlink.shop.dao.JobLogDTO;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class JobLogDao {
    private static JobLogDao instance = new JobLogDao();

    private JobLogDao() {
    }

    public static JobLogDao get() {
        return instance;
    }

    public int insertJobLog(String logMsg, String jobType) throws Exception {
        int result;
        block5: {
            result = 0;
            Connection connection = null;
            PreparedStatement pstmt = null;
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuilder sql = new StringBuilder();
                    sql.append("INSERT INTO JOBLOG (  \r\n");
                    sql.append("      COMPNO  \r\n");
                    sql.append("    , USER_ID  \r\n");
                    sql.append("    , JOB_TYPE  \r\n");
                    sql.append("    , LOG_MESSAGE  \r\n");
                    sql.append("    , DATE  \r\n");
                    sql.append(") VALUES (  \r\n");
                    sql.append("      ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?  \r\n");
                    sql.append("    , ?) \r\n");
                    pstmt = connection.prepareStatement(sql.toString());
                    int rowIdx = 0;
                    pstmt.setInt(++rowIdx, Integer.parseInt(YDMASessonUtil.getCompnoInfo().getCompno()));
                    pstmt.setString(++rowIdx, YDMASessonUtil.getUserInfo().getUserId());
                    pstmt.setString(++rowIdx, jobType);
                    pstmt.setString(++rowIdx, logMsg);
                    pstmt.setString(++rowIdx, YDMATimeUtil.getCurrentTimeByYDFormat());
                    YDMAStringUtil.Print("[insertJobLog]" + pstmt.toString());
                    result = pstmt.executeUpdate();
                }
                catch (Exception ex) {
                    System.err.println("[insertJobLog] \ub85c\uadf8 \uc800\uc7a5 \uc2e4\ud328: " + ex.getMessage());
                    ex.printStackTrace();
                    result = 0;
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
        return result;
    }

    public List<JobLogDTO> selectJobLog(String prodType, String prodCd, String jobType, String shopCd, String shopUserId, String startDate, String endDate) throws Exception {
        ArrayList<JobLogDTO> list;
        block16: {
            Connection connection = null;
            PreparedStatement pstmt = null;
            list = new ArrayList<JobLogDTO>();
            try {
                try {
                    connection = DBCPInit.getInstance().getConnection();
                    StringBuilder sql = new StringBuilder();
                    sql.append("SELECT \r\n");
                    sql.append("IFNULL(SEQ,  0) AS SEQ, \r\n");
                    sql.append("IFNULL(DATE,  '') AS DATE, \r\n");
                    sql.append("IFNULL(JOBTYPE,  '') AS JOBTYPE, \r\n");
                    sql.append("IFNULL(PRODCD,  '') AS PRODCD, \r\n");
                    sql.append("IFNULL(SHOPCD,  '') AS SHOPCD, \r\n");
                    sql.append("IFNULL(SHOPUSERID,  '') AS SHOPUSERID, \r\n");
                    sql.append("IFNULL(NICKNAME,  '') AS NICKNAME, \r\n");
                    sql.append("IFNULL(SHOPSEQ,  0) AS SHOPSEQ, \r\n");
                    sql.append("IFNULL(SHOPPRODNO,  '') AS SHOPPRODNO, \r\n");
                    sql.append("IFNULL(ORDID,  '') AS ORDID, \r\n");
                    sql.append("IFNULL(LOGMESSAGE,  '') AS LOGMESSAGE \r\n");
                    sql.append("FROM JOBLOG \r\n");
                    sql.append("WHERE (DATE >= ? AND DATE <= ?) \r\n");
                    if (prodType.equals("PRODCD") && !prodCd.equals("")) {
                        sql.append("AND PRODCD = ? \r\n");
                    }
                    if (prodType.equals("SHOPPRODNO") && !prodCd.equals("")) {
                        sql.append("AND SHOPPRODNO = ? \r\n");
                    }
                    if (!jobType.equals("")) {
                        sql.append("AND JOBTYPE = ? \r\n");
                    }
                    if (!shopCd.equals("")) {
                        sql.append("AND SHOPCD = ? \r\n");
                        if (!shopUserId.equals("")) {
                            sql.append("AND SHOPUSERID = ? \r\n");
                        }
                    }
                    sql.append("ORDER BY DATE DESC \r\n");
                    pstmt = connection.prepareStatement(sql.toString());
                    int idx = 1;
                    pstmt.setString(idx++, startDate);
                    pstmt.setString(idx++, endDate);
                    if (prodType.equals("PRODCD") && !prodCd.equals("")) {
                        pstmt.setString(idx++, prodCd);
                    }
                    if (prodType.equals("SHOPPRODNO") && !prodCd.equals("")) {
                        pstmt.setString(idx++, prodCd);
                    }
                    if (!jobType.equals("")) {
                        pstmt.setString(idx++, jobType);
                    }
                    if (!shopCd.equals("")) {
                        pstmt.setString(idx++, shopCd);
                        if (!shopUserId.equals("")) {
                            pstmt.setString(idx++, shopUserId);
                        }
                    }
                    YDMAStringUtil.Print("[selectJobLog]" + pstmt.toString());
                    ResultSet rs = pstmt.executeQuery();
                    while (rs.next()) {
                        JobLogDTO dto = new JobLogDTO();
                        dto.setSeq(rs.getInt("SEQ"));
                        dto.setDate(rs.getString("DATE"));
                        dto.setJobType(rs.getString("JOBTYPE"));
                        dto.setProdCd(rs.getString("PRODCD"));
                        dto.setShopCd(rs.getString("SHOPCD"));
                        dto.setShopUserId(rs.getString("SHOPUSERID"));
                        dto.setNickname(rs.getString("NICKNAME"));
                        dto.setShopSeq(rs.getInt("SHOPSEQ"));
                        dto.setShopProdNo(rs.getString("SHOPPRODNO"));
                        dto.setOrdId(rs.getString("ORDID"));
                        dto.setLogMessage(rs.getString("LOGMESSAGE"));
                        list.add(dto);
                    }
                    rs.close();
                }
                catch (Exception ex) {
                    System.err.println("[selectJobLog] \ub85c\uadf8 \uc870\ud68c \uc2e4\ud328: " + ex.getMessage());
                    ex.printStackTrace();
                    DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                DBCPInit.getInstance().freeConnection(connection, pstmt, null);
                throw throwable;
            }
            DBCPInit.getInstance().freeConnection(connection, pstmt, null);
        }
        return list;
    }
}

