/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.dao;

import com.kdjsystem.mlink.shop.common.QueryStringUtils;
import com.kdjsystem.mlink.shop.dao.WorkmgrlogDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.data.dao.DBCPInit;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class WorkmgrlogDao {
    static WorkmgrlogDao instance = new WorkmgrlogDao();

    public static WorkmgrlogDao get() {
        return instance;
    }

    public List<WorkmgrlogDto> getWorkmgrlogInfo(String startdt, String enddt, String shopcd, String shopId) throws Exception {
        ArrayList<WorkmgrlogDto> list = new ArrayList<WorkmgrlogDto>();
        Connection connection = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                connection = DBCPInit.getInstance().getConnection();
                StringBuffer query = new StringBuffer();
                query.append("SELECT WORKGRP,\r\n");
                query.append("       SHOPCD,\r\n");
                query.append("       IFNULL(SHOPNM, '') AS SHOPNM, \r\n");
                query.append("       IFNULL(SHOPSEQ, 0) AS SHOPSEQ, \r\n");
                query.append("       IFNULL(SHOPPINGID, '') AS SHOPPINGID, \r\n");
                query.append("       IFNULL(nicknm1, '') AS nicknm1, \r\n");
                query.append("       IFNULL(seq, 0) AS seq, \r\n");
                query.append("       IFNULL(prodseq, '') AS prodseq, \r\n");
                query.append("       IFNULL(status, '') AS status, \r\n");
                query.append("       IFNULL(message, '') AS message, \r\n");
                query.append("       IFNULL(additionalSeq, 0) AS additionalSeq, \r\n");
                query.append("       IFNULL(additionalTitle, '') AS additionalTitle, \r\n");
                query.append("       IFNULL(imgoneonone, '') AS imgoneonone, \r\n");
                query.append("       IFNULL(dscamtpercent, '') AS dscamtpercent, \r\n");
                query.append("       IFNULL(margindc, 0) AS margindc, \r\n");
                query.append("       IFNULL(commdc, 0) AS commdc, \r\n");
                query.append("       IFNULL(changeSizeX, '') AS changeSizeX, \r\n");
                query.append("       IFNULL(changeSizeY, '') AS changeSizeY, \r\n");
                query.append("       IFNULL(changeSizeW, '') AS changeSizeW, \r\n");
                query.append("       IFNULL(changeSizeH, '') AS changeSizeH, \r\n");
                query.append("       IFNULL(img_angle, 0) AS img_angle, \r\n");
                query.append("       IFNULL(img_scale_percent, 0) AS img_scale_percent, \r\n");
                query.append("       IFNULL(mirrorimgyn, '') AS mirrorimgyn, \r\n");
                query.append("       IFNULL(goods_keyword, '') AS goods_keyword, \r\n");
                query.append("       IFNULL(class_cd3, '') AS class_cd3, \r\n");
                query.append("       IFNULL(full_name, '') AS full_name, \r\n");
                query.append("       IFNULL(insertDT, '') AS insertDT, \r\n");
                query.append("       IFNULL(goods_cost, 0) AS goods_cost, \r\n");
                query.append("       IFNULL(delv_cost, 0) AS delv_cost, \r\n");
                query.append("       IFNULL(goods_search, '') AS goods_search, \r\n");
                query.append("       IFNULL(sale_cnt, 0) AS sale_cnt \r\n");
                query.append("  FROM workmgrlog");
                query.append(" where shopcd like ?");
                query.append("   and SHOPPINGID like ?");
                query.append("   and INSERTDT between ? and ?");
                query.append(" order by insertdt ");
                pstmt = connection.prepareStatement(query.toString().toUpperCase());
                pstmt.setString(1, shopcd);
                pstmt.setString(2, shopId);
                pstmt.setString(3, startdt);
                pstmt.setString(4, enddt);
                YDMAStringUtil.Print("[getWorkmgrlogInfo]" + pstmt.toString());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    WorkmgrlogDto dto = new WorkmgrlogDto();
                    dto.setWorkgrp(rs.getString("WORKGRP"));
                    dto.setShopcd(rs.getString("SHOPCD"));
                    dto.setShopnm(rs.getString("SHOPNM"));
                    dto.setShopseq(rs.getInt("SHOPSEQ"));
                    dto.setShoppingId(rs.getString("SHOPPINGID"));
                    dto.setNicknm1(rs.getString("NICKNM1"));
                    dto.setSeq(rs.getInt("SEQ"));
                    dto.setProdseq(rs.getString("PRODSEQ"));
                    dto.setStatus(rs.getString("STATUS"));
                    dto.setMessage(rs.getString("MESSAGE"));
                    dto.setAdditionalSeq(rs.getInt("ADDITIONALSEQ"));
                    dto.setAdditionalTitle(rs.getString("ADDITIONALTITLE"));
                    dto.setImgoneonone(rs.getString("IMGONEONONE"));
                    dto.setDscamtpercent(rs.getString("DSCAMTPERCENT"));
                    dto.setMargindc(rs.getFloat("MARGINDC"));
                    dto.setCommdc(rs.getFloat("COMMDC"));
                    dto.setImg_angle(rs.getDouble("IMG_ANGLE"));
                    dto.setImg_scale_percent(rs.getDouble("IMG_SCALE_PERCENT"));
                    dto.setMirrorimgyn(rs.getString("MIRRORIMGYN"));
                    dto.setGoods_keyword(rs.getString("GOODS_KEYWORD"));
                    dto.setClass_cd3(rs.getString("CLASS_CD3"));
                    dto.setFull_name(rs.getString("FULL_NAME"));
                    dto.setInsertDT(rs.getString("INSERTDT"));
                    dto.setGoods_cost(rs.getInt("GOODS_COST"));
                    dto.setDelv_cost(rs.getInt("DELV_COST"));
                    dto.setGoods_search(rs.getString("GOODS_SEARCH"));
                    dto.setSale_cnt(rs.getInt("SALE_CNT"));
                    list.add(dto);
                }
            }
            catch (Exception ex) {
                YDMAStringUtil.Print(ex.getMessage());
                throw ex;
            }
        }
        catch (Throwable throwable) {
            DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
            throw throwable;
        }
        DBCPInit.getInstance().freeConnection(connection, pstmt, rs);
        return list;
    }

    public int insertWorkLog(List<String> sendList) throws Exception {
        int result = 0;
        PreparedStatement pstmt = null;
        try (Connection connection = DBCPInit.getInstance().getConnection();){
            try {
                ArrayList<String> fileds = new ArrayList<String>();
                fileds.add("WORKGRP");
                fileds.add("SHOPCD");
                fileds.add("SHOPNM");
                fileds.add("SHOPSEQ");
                fileds.add("SHOPPINGID");
                fileds.add("NICKNM1");
                fileds.add("SEQ");
                fileds.add("PRODSEQ");
                fileds.add("STATUS");
                fileds.add("MESSAGE");
                fileds.add("ADDITIONALSEQ");
                fileds.add("ADDITIONALTITLE");
                fileds.add("IMGONEONONE");
                fileds.add("DSCAMTPERCENT");
                fileds.add("MARGINDC");
                fileds.add("COMMDC");
                fileds.add("CHANGESIZEX");
                fileds.add("CHANGESIZEY");
                fileds.add("CHANGESIZEW");
                fileds.add("CHANGESIZEH");
                fileds.add("IMG_ANGLE");
                fileds.add("IMG_SCALE_PERCENT");
                fileds.add("MIRRORIMGYN");
                fileds.add("GOODS_KEYWORD");
                fileds.add("CLASS_CD3");
                fileds.add("FULL_NAME");
                fileds.add("INSERTDT");
                fileds.add("GOODS_COST");
                fileds.add("DELV_COST");
                fileds.add("GOODS_SEARCH");
                fileds.add("SALE_CNT");
                pstmt = connection.prepareStatement(QueryStringUtils.queryStringInsert(fileds, "workmgrlog"));
                int i = 0;
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setInt(++i, Integer.parseInt(sendList.get(i - 1)));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setInt(++i, Integer.parseInt(sendList.get(i - 1)));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setInt(++i, Integer.parseInt(sendList.get(i - 1)));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setFloat(++i, Float.parseFloat(sendList.get(i - 1)));
                pstmt.setFloat(++i, Float.parseFloat(sendList.get(i - 1)));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setDouble(++i, Double.parseDouble(sendList.get(i - 1)));
                pstmt.setDouble(++i, Double.parseDouble(sendList.get(i - 1)));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setInt(++i, Integer.parseInt(sendList.get(i - 1)));
                pstmt.setInt(++i, Integer.parseInt(sendList.get(i - 1)));
                pstmt.setString(++i, sendList.get(i - 1));
                pstmt.setInt(++i, Integer.parseInt(sendList.get(i - 1)));
                result = pstmt.executeUpdate();
            }
            catch (Exception e) {
                e.printStackTrace();
                connection.close();
            }
        }
        return result;
    }
}

