/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.auction;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.auction.IShopOrderAuctionCommand;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

class AuctionOrderNewCommand
extends IShopOrderAuctionCommand {
    private static IShopOrderCommand instance = new AuctionOrderNewCommand();
    IShopCommonLogin i = new IShopCommonLogin(){};
    JsonParser jsonparser = new JsonParser();
    private boolean isBasic = false;
    private String cachedHddSearchAccount;

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private AuctionOrderNewCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto dto = param.get(0);
        this.isBasic = dto.getSpecificStatus() == null || dto.getSpecificStatus().equals("");
        this.processOrders(dto, ret);
        return ret;
    }

    private void processOrders(ShopOrderMstDto dto, List<ShopOrderMstDto> ret) throws Exception {
        block29: {
            block28: {
                if (!this.isBasic) break block28;
                this.getNewOrder(dto, ret);
                this.getConfirmOrder(dto, ret);
                this.getDelvieryCompletedOrder(dto, ret);
                break block29;
            }
            switch (dto.getSpecificStatus()) {
                case "\uc2e0\uaddc\uc8fc\ubb38": {
                    this.getNewOrder(dto, ret);
                    break;
                }
                case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                    this.getConfirmOrder(dto, ret);
                    break;
                }
                case "\ubc30\uc1a1\uc911": {
                    this.getDelvieryOrder(dto, ret, false);
                    break;
                }
                case "\ubc30\uc1a1\uc644\ub8cc": {
                    this.getDelvieryOrder(dto, ret, true);
                    break;
                }
                case "\uad6c\ub9e4\ud655\uc815": {
                    this.getDelvieryCompletedOrder(dto, ret);
                    break;
                }
                case "\ucde8\uc18c": {
                    this.getCancelOrder(dto, ret);
                    break;
                }
                case "\ubc18\ud488": {
                    this.getReturnOrder(dto, ret);
                    break;
                }
                case "\uad50\ud658": {
                    this.getExchangeOrder(dto, ret);
                }
            }
        }
    }

    private String gethddSearchAccount(Map<String, String> cookies) throws Exception {
        if (this.cachedHddSearchAccount != null) {
            return this.cachedHddSearchAccount;
        }
        StringBuilder urlBuilder = new StringBuilder("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery");
        urlBuilder.append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append("&searchDateType=").append("&searchSDT=").append("&searchEDT=").append("&searchKey=").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=").append("&totalAccumulate=-").append("&searchTransPolicyType=");
        Document doc = Jsoup.connect((String)urlBuilder.toString()).cookies(cookies).get();
        Elements hiddens = doc.select("input[type=hidden]");
        Map<String, String> datas = ChromeScript.get().getElementIdOrValue(hiddens);
        this.cachedHddSearchAccount = datas.get("hddSearchAccount");
        return this.cachedHddSearchAccount;
    }

    private List<ShopOrderMstDto> getNewOrder(ShopOrderMstDto orderDto, List<ShopOrderMstDto> ret) throws Exception {
        String shopid = orderDto.getShopid();
        String site = shopid.equals("shop00671") ? "1" : "2";
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopid, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        String url = "https://www.esmplus.com/Escrow/Order/NewOrderSearch";
        String referrer = "https://www.esmplus.com/Escrow/Order/NewOrder?menuCode=TDM105";
        Connection.Response rs = Jsoup.connect((String)url).cookies(cookies).referrer(referrer).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).data("page", "1").data("limit", "500").data("siteGbn", site).data("searchAccount", this.gethddSearchAccount(cookies) + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchDistrType", "AL").data("searchAllYn", "N").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchTransPolicyType", "").execute();
        JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
        JsonArray jsonArray = (JsonArray)jsonobject.get("data");
        List<ShopOrderMstDto> params = this.getJsonManager(jsonArray, orderDto, "100", cookies);
        Map<String, List<ShopOrderMstDto>> grouped = params.stream().collect(Collectors.groupingBy(dto -> dto.getMall_product_id() + "_" + dto.getUser_name() + "_" + dto.getUser_tel()));
        for (List<ShopOrderMstDto> group : grouped.values()) {
            if (group.size() <= 1) continue;
            int deliveryFee = this.calculateDeliveryFee(group);
            for (ShopOrderMstDto dto2 : group) {
                dto2.setDelv_cost(String.valueOf(deliveryFee));
                if (deliveryFee <= 0) continue;
                dto2.setDelivery_method_str2("\uc120\ubd88");
            }
        }
        if (params != null) {
            ret.addAll(params);
        }
        return ret;
    }

    private int calculateDeliveryFee(List<ShopOrderMstDto> group) {
        return group.stream().mapToInt(dto -> {
            String cost = dto.getDelv_cost().replaceAll(",", "").trim();
            if ("\ubb34\ub8cc".equals(cost)) {
                return 0;
            }
            try {
                return Integer.parseInt(cost);
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }).max().orElse(0);
    }

    private List<ShopOrderMstDto> getConfirmOrder(ShopOrderMstDto orderDto, List<ShopOrderMstDto> ret) throws Exception {
        String shopid = orderDto.getShopid();
        String site = shopid.equals("shop00671") ? "1" : "2";
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopid, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        String searchAcoount = this.gethddSearchAccount(cookies);
        StringBuilder referrerUrl = new StringBuilder();
        referrerUrl.append("https://www.esmplus.com/Escrow/Delivery/GeneralDelivery").append("?gbn=0").append("&status=0").append("&type=").append("&searchAccount=").append(searchAcoount).append("^").append(id).append("^").append(site).append("&searchDateType=ODD").append("&searchSDT=").append(startdate).append("&searchEDT=").append(enddate).append("&searchKey=ON").append("&searchKeyword=").append("&searchDeliveryType=").append("&searchOrderType=").append("&searchPacking=false").append("&totalAccumulate=-").append("&listAllView=false").append("&searchDistrType=AL").append("&searchTransPolicyType=");
        String refferer = referrerUrl.toString();
        Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/GeneralDeliverySearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("excelInfo", "").data("limit", "500").data("page", "1").data("searchAccount", searchAcoount + "^" + id + "^" + site).data("searchAllYn", "Y").data("searchDateType", "ODD").data("searchDeliveryType", "").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchOrderType", "").data("searchPaking", "false").data("searchSDT", startdate).data("searchStatus", "0").data("searchTransPolicyType", "").data("siteGbn", "0").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").referrer(refferer).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = (JsonObject)this.jsonparser.parse(rs.body());
        JsonArray jsonArray = (JsonArray)jsonobject.get("data");
        Connection.Response rs1 = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/OverseasDeliverySearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("excelInfo", "").data("limit", "500").data("page", "1").data("searchAccount", searchAcoount + "^" + id + "^" + site).data("searchAllYn", "Y").data("searchDateType", "ODD").data("searchDeliveryType", "").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchOrderType", "").data("searchPaking", "false").data("searchSDT", startdate).data("searchStatus", "0").data("searchTransPolicyType", "").data("siteGbn", "0").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").referrer(refferer).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject1 = (JsonObject)this.jsonparser.parse(rs1.body());
        JsonArray jsonArray1 = (JsonArray)jsonobject1.get("data");
        List<ShopOrderMstDto> params = this.getJsonManager(jsonArray, orderDto, "100", cookies);
        List<ShopOrderMstDto> params1 = this.getJsonManager(jsonArray1, orderDto, "100", cookies);
        if (params != null || params1 != null) {
            ret.addAll(params);
            ret.addAll(params1);
        }
        return ret;
    }

    private List<ShopOrderMstDto> getDelvieryCompletedOrder(ShopOrderMstDto orderDto, List<ShopOrderMstDto> ret) throws Exception {
        String orderStatus;
        Connection.Response rs;
        JsonObject jsonobject;
        JsonArray jsonArray;
        List<ShopOrderMstDto> params;
        String shopid = orderDto.getShopid();
        String site = shopid.equals("shop00671") ? "1" : "2";
        String id = orderDto.getShop_userid();
        String pw = orderDto.getShopPw();
        String authKey = orderDto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopid, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(orderDto.getEndDt(), false);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date sdate = formatter.parse(startdate);
        Date edate = formatter.parse(enddate);
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(sdate);
        cal2.setTime(edate);
        cal2.add(1, -1);
        if (cal1.getTimeInMillis() < cal2.getTimeInMillis()) {
            YDMAProgressBar.get().setValue("\uc625\uc158/\uc9c0\ub9c8\ucf13\uc740 1\ub144 \uc774\ub0b4\uc758 \uc8fc\ubb38 \uac74\ub9cc \uac00\uc838\uc62c \uc218 \uc788\uc2b5\ub2c8\ub2e4. \uc218\uc815\ub41c \ub0a0\uc9dc\ub85c \uac80\uc0c9\ud569\ub2c8\ub2e4.", 0);
            startdate = formatter.format(cal2.getTime());
        }
        if ((params = this.getJsonManager2(jsonArray = (JsonArray)(jsonobject = (JsonObject)this.jsonparser.parse((rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/BuyDecisionSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").referrer("https://www.esmplus.com/Escrow/Delivery/BuyDecision?").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).data("page", "1").data("limit", "500").data("siteGbn", site).data("searchAccount", this.gethddSearchAccount(cookies) + "^" + id + "^" + site).data("searchDateType", "TRD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchStatus", "").data("searchAllYn", "N").data("SortFeild", "TransDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").data("searchGlobalShopType", "").data("searchOverseaDeliveryYn", "").execute()).body())).get("data"), orderDto, orderStatus = this.isBasic ? "410" : "901", cookies)) != null) {
            ret.addAll(params);
        }
        return ret;
    }

    private void getDelvieryOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> ret, boolean isCompleted) throws Exception {
        List<ShopOrderMstDto> params;
        String shopcd = dto.getShopid();
        String site = shopcd.equals("shop00671") ? "1" : "2";
        String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
        String id = dto.getShop_userid();
        String pw = dto.getShopPw();
        String shopid = dto.getShopid();
        String authKey = dto.getAuthkey1();
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<String, String> cookies = is.loginCookie(id, pw, shopid, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        String searchType = isCompleted ? "1050" : "1040";
        String orderStatus = isCompleted ? "410" : "403";
        Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Delivery/GetSendingSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "1").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", searchType).data("searchKey", "ON").data("searchKeyword", "").data("excelInfo", "undefined").data("searchStatus", searchType).data("searchAllYn", "N").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").referrer("https://www.esmplus.com/Escrow/Delivery/Sending?menuCode=TDM111").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
        JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
        if (jsonArray.size() > 0 && (params = this.getJsonManager2(jsonArray, dto, orderStatus, cookies)) != null) {
            ret.addAll(params);
        }
    }

    private void getCancelOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> ret) throws Exception {
        String shopcd = dto.getShopid();
        String site = shopcd.equals("shop00671") ? "1" : "2";
        String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
        String id = dto.getShop_userid();
        String pw = dto.getShopPw();
        String authKey = dto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopcd, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("CR", "C01");
        map_parmeters.put("CI", "C01");
        map_parmeters.put("CC", "C02");
        for (String key_param : map_parmeters.keySet()) {
            List<ShopOrderMstDto> params;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/CancelManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + id + "^" + site).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", key_param).data("searchKey", "ON").data("searchKeyword", "").data("orderByType", "").data("excelInfo", "").data("searchStatus", key_param).data("searchAllYn", "N").data("tabGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchTransPolicyType", "AL").referrer("https://www.esmplus.com/Escrow/Claim/CancelRequestManagement?menuCode=TDM115").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
            JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
            if (jsonArray.size() <= 0 || (params = this.getJsonManager2(jsonArray, dto, (String)map_parmeters.get(key_param), cookies)) == null) continue;
            ret.addAll(params);
        }
    }

    private void getReturnOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> ret) throws Exception {
        String shopcd = dto.getShopid();
        String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
        String id = dto.getShop_userid();
        String pw = dto.getShopPw();
        String authKey = dto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopcd, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("RR", "R01");
        map_parmeters.put("RP", "R01");
        map_parmeters.put("RH", "R01");
        map_parmeters.put("RF", "R02");
        for (String key_param : map_parmeters.keySet()) {
            List<ShopOrderMstDto> params;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/ReturnManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("page", "1").data("limit", "500").data("siteGbn", "1").data("searchAccount", site1 + "^" + id).data("searchDateType", "ODD").data("searchSDT", startdate).data("searchEDT", enddate).data("searchType", key_param).data("searchKey", "ON").data("searchKeyword", "").data("orderByType", "").data("excelInfo", "").data("searchStatus", "RR").data("searchAllYn", "N").data("tabGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("searchDistrType", "AL").data("searchRewardStatus", "NN").data("searchFastRefundYn", "").referrer("https://www.esmplus.com/Escrow/Claim/ReturnRequestManagement?menuCode=TDM118").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
            JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
            if (jsonArray.size() <= 0 || (params = this.getJsonManager2(jsonArray, dto, (String)map_parmeters.get(key_param), cookies)) == null) continue;
            ret.addAll(params);
        }
    }

    private void getExchangeOrder(ShopOrderMstDto dto, List<ShopOrderMstDto> ret) throws Exception {
        String shopcd = dto.getShopid();
        String site1 = shopcd.equals("shop00671") ? "A1" : "G1";
        String id = dto.getShop_userid();
        String pw = dto.getShopPw();
        String shopid = dto.getShopid();
        String authKey = dto.getAuthkey1();
        Map<String, String> cookies = this.i.loginCookie(id, pw, shopid, true, authKey);
        String startdate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getStartDt(), false);
        String enddate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(dto.getEndDt(), false);
        LinkedHashMap<String, String> map_parmeters = new LinkedHashMap<String, String>();
        map_parmeters.put("ER", "E01");
        map_parmeters.put("EP", "E02");
        map_parmeters.put("EH", "E01");
        String searchStatus = "";
        for (String key_param : map_parmeters.keySet()) {
            List<ShopOrderMstDto> params;
            Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Escrow/Claim/ExchangeManagementSearch").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("claimCount", "-").data("excelInfo", "").data("limit", "500").data("orderByType", "").data("page", "1").data("searchAccount", site1 + "^" + id).data("searchAllYn", "N").data("searchDateType", "ODD").data("searchDistrType", "AL").data("searchEDT", enddate).data("searchKey", "ON").data("searchKeyword", "").data("searchSDT", startdate).data("searchStatus", searchStatus).data("searchType", key_param).data("siteGbn", "1").data("SortFeild", "PayDate").data("SortType", "Desc").data("start", "0").data("tabGbn", "1").referrer("https://www.esmplus.com/Escrow/Claim/ExchangeRequestManagement?menuCode=TDM123").method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
            searchStatus = key_param;
            JsonObject jsonobject = this.jsonparser.parse(rs.body()).getAsJsonObject();
            JsonArray jsonArray = jsonobject.get("data").getAsJsonArray();
            if (jsonArray.size() <= 0 || (params = this.getJsonManager2(jsonArray, dto, (String)map_parmeters.get(key_param), cookies)) == null) continue;
            ret.addAll(params);
        }
    }

    private List<ShopOrderMstDto> getJsonManager(JsonArray jsonArray, ShopOrderMstDto orderDto, String orderStatus, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            if (jsonArray.size() > 0) {
                Integer i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i.intValue());
                    String orderId = object.get("SiteOrderNo").getAsString();
                    if (!this.isBasic || !ShopOrderDao.get().isOrdered(orderId)) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_status(orderStatus);
                        dto.setOrder_date(object.get("OrderDate").getAsString());
                        dto.setDelv_msg(this.setHtmlTagDelete(object.get("DeliveryMemo").getAsString()));
                        dto.setSale_cnt(object.get("OrderQty").getAsString());
                        dto.setShopid(orderDto.getShopid());
                        dto.setShop_userid(orderDto.getShop_userid());
                        dto.setReceive_name(object.get("RcverName").getAsString());
                        dto.setMall_product_id(object.get("GoodsNo").getAsString());
                        dto.setCompayny_goods_cd(this.setHtmlTagDelete(object.get("SellerMngCode").getAsString()));
                        dto.setP_product_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                        String addOption = this.setHtmlTagDelete(object.get("AddOption").getAsString());
                        dto.setP_sku_value(this.setHtmlTagDelete(object.get("SelOption").getAsString()) + "," + addOption);
                        dto.setWon_cost("0");
                        dto.setMall_won_cost(object.get("SttlExpectedAmnt").getAsString());
                        dto.setSale_cost(object.get("SellPrice").getAsString().replace(",", ""));
                        String fee = this.setHtmlTagDelete(object.get("DeliveryFee").getAsString());
                        String deleveryfee = "";
                        deleveryfee = fee.equals("\uc0c1\uc138\ubcf4\uae30") ? this.getDeliveryFee(orderDto.getShop_userid(), orderId, cookies) : object.get("DeliveryFee").getAsString();
                        dto.setDelv_cost(deleveryfee);
                        if (object.get("DeliveryFeeType").getAsString().equals("\uc120\ubd88") && deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                            dto.setDelivery_method_str2("\ubb34\ub8cc");
                        } else {
                            dto.setDelivery_method_str2(object.get("DeliveryFeeType").getAsString());
                        }
                        dto.setDelivery_id("");
                        dto.setInvoice_no("");
                        dto.setTotal_cost(object.get("OrderAmnt").getAsString().replace(",", ""));
                        int paycost = YDMAStringUtil.convertToInt(object.get("SellPrice").getAsString()) + YDMAStringUtil.convertToInt(deleveryfee);
                        dto.setPay_cost(Integer.toString(paycost));
                        dto.setProduct_id("");
                        dto.setCompno(orderDto.getCompno());
                        dto.setOrder_id(orderId);
                        dto.setLabel(object.get("OrderNo").getAsString());
                        dto.setUser_id(object.get("BuyerID").getAsString());
                        dto.setUser_name(object.get("BuyerName").getAsString());
                        dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerHt")));
                        dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerCp")));
                        dto.setUser_email("");
                        dto.setReceive_tel(this.jsonElementNullStr(object.get("RcverInfoHt")));
                        dto.setReceive_cel(this.jsonElementNullStr(object.get("RcverInfoCp")));
                        dto.setReceive_email("");
                        dto.setReceive_zipcode(object.get("ZipCode").getAsString());
                        dto.setReceive_addr(this.setHtmlTagDelete(object.get("RcverInfoAd").getAsString()));
                        dto.setProduct_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                        dto.setBox_ea("0");
                        dto.setCopy_idx(object.get("CartNo").getAsString());
                        dto.setSku_value(this.setHtmlTagDelete(object.get("SelOption").getAsString()));
                        dto.setMall_exp_cd("0");
                        dto.setAuthkey1(orderDto.getAuthkey1());
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                    i = i + 1;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc625\uc158 \uc2e0\uaddc \uac00\uc838\uc624\uae30 \uc5d1\uc140 \ub9cc\ub4dc\ub294 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private List<ShopOrderMstDto> getJsonManager2(JsonArray jsonArray, ShopOrderMstDto orderDto, String orderStatus, Map<String, String> cookies) throws Exception {
        ArrayList<ShopOrderMstDto> dtolist = new ArrayList<ShopOrderMstDto>();
        try {
            if (jsonArray.size() > 0) {
                Integer i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i.intValue());
                    String orderId = object.get("SiteOrderNo").getAsString();
                    if (!this.isBasic || !ShopOrderDao.get().isOrdered(orderId)) {
                        ShopOrderMstDto dto = new ShopOrderMstDto();
                        dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                        dto.setOrder_status(orderStatus);
                        dto.setOrder_date(object.get("OrderDate").getAsString());
                        if (dto.getOrder_date().equals("")) {
                            dto.setOrder_date(object.get("PayDate").getAsString());
                        }
                        dto.setDelv_msg(object.get("DeliveryMemo").isJsonNull() ? "" : this.setHtmlTagDelete(object.get("DeliveryMemo").getAsString()));
                        dto.setSale_cnt(object.get("OrderQty").getAsString());
                        dto.setShopid(orderDto.getShopid());
                        dto.setShop_userid(orderDto.getShop_userid());
                        dto.setReceive_name(object.get("RcverName").getAsString());
                        dto.setMall_product_id(object.get("GoodsNo").getAsString());
                        dto.setCompayny_goods_cd(this.setHtmlTagDelete(object.get("SellerMngCode").getAsString()));
                        dto.setP_product_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                        String addOption = "";
                        if (object.has("AddOption")) {
                            addOption = this.setHtmlTagDelete(object.get("AddOption").getAsString());
                        }
                        String selOption = "";
                        if (object.has("SelOption")) {
                            selOption = this.setHtmlTagDelete(object.get("SelOption").getAsString());
                        }
                        dto.setP_sku_value(selOption + "," + addOption);
                        dto.setWon_cost("0");
                        String wonCost = "";
                        if (object.has("SttlExpectedAmnt")) {
                            wonCost = object.get("SttlExpectedAmnt").getAsString();
                        }
                        dto.setMall_won_cost(wonCost);
                        dto.setSale_cost(this.jsonElementNullStr(object.get("SellPrice")).replace(",", ""));
                        String fee = "";
                        fee = object.has("DeliveryFee") ? this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DeliveryFee"))) : this.setHtmlTagDelete(this.jsonElementNullStr(object.get("DomstDeliveryFee")));
                        String deleveryfee = "";
                        deleveryfee = fee.equals("\uc0c1\uc138\ubcf4\uae30") ? this.getDeliveryFee(orderDto.getShop_userid(), orderId, cookies) : fee;
                        dto.setDelv_cost(deleveryfee);
                        if (deleveryfee.equals("0") || deleveryfee.equals("\ubb34\ub8cc")) {
                            dto.setDelivery_method_str2("\ubb34\ub8cc");
                        } else {
                            dto.setDelivery_method_str2("\uc120\ubd88");
                        }
                        if (object.has("DeliveryComp")) {
                            String deliveryId = this.jsonElementNullStr(object.get("DeliveryComp"));
                            if (deliveryId.equals("") && object.has("DeliveryCompCode")) {
                                deliveryId = this.jsonElementNullStr(object.get("DeliveryCompCode"));
                            }
                            dto.setDelivery_id(deliveryId);
                        }
                        if (object.has("InvoiceNo")) {
                            String invoiceNo = this.jsonElementNullStr(object.get("InvoiceNo"));
                            if (invoiceNo.contains("<input type")) {
                                invoiceNo = "";
                            }
                            dto.setInvoice_no(invoiceNo);
                        }
                        if (object.has("DeliveryCompNm")) {
                            dto.setDeliveryName(this.jsonElementNullStr(object.get("DeliveryCompNm")));
                        }
                        dto.setProduct_id("");
                        dto.setCompno(orderDto.getCompno());
                        dto.setOrder_id(orderId);
                        dto.setLabel(object.get("OrderNo").getAsString());
                        String userId = "";
                        userId = object.has("BuyerID") ? object.get("BuyerID").getAsString() : object.get("BuyerId").getAsString();
                        dto.setUser_id(userId);
                        dto.setUser_name(object.get("BuyerName").getAsString());
                        if (object.has("BuyerHt")) {
                            dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerHt")));
                            dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerCp")));
                        } else {
                            dto.setUser_tel(this.jsonElementNullStr(object.get("BuyerInfoHt")));
                            dto.setUser_cel(this.jsonElementNullStr(object.get("BuyerInfoCp")));
                        }
                        dto.setUser_email("");
                        dto.setReceive_tel(this.jsonElementNullStr(object.get("RcverInfoHt")));
                        dto.setReceive_cel(this.jsonElementNullStr(object.get("RcverInfoCp")));
                        dto.setReceive_email("");
                        dto.setReceive_zipcode("");
                        dto.setReceive_addr("");
                        dto.setTotal_cost(object.get("OrderAmnt").getAsString().replace(",", ""));
                        int paycost = YDMAStringUtil.convertToInt(object.get("SellPrice").getAsString()) + YDMAStringUtil.convertToInt(deleveryfee);
                        dto.setPay_cost(Integer.toString(paycost));
                        dto.setProduct_name(this.setHtmlTagDelete(object.get("GoodsName").getAsString()));
                        dto.setBox_ea("0");
                        dto.setCopy_idx(object.get("CartNo").getAsString());
                        dto.setSku_value(selOption);
                        dto.setMall_exp_cd("0");
                        dto.setAuthkey1(orderDto.getAuthkey1());
                        dto.setResult_code("1");
                        dtolist.add(dto);
                    }
                    i = i + 1;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc625\uc158 \uc8fc\ubb38\uc218\uc9d1 \ub3c4\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return dtolist;
    }

    private String getDeliveryFee(String sellerID, String siteOrderNo, Map<String, String> cookies) throws Exception {
        String refferUrl = String.format("https://www.esmplus.com/Home/SSO?id=%s&code=%s&Param=OrderNo%%3D%s", sellerID, "TDP132", siteOrderNo);
        Connection.Response rs = Jsoup.connect((String)"https://www.esmplus.com/Member/SignIn/GetCoreAuthToken").cookies(cookies).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").data("SellerId", sellerID).data("MenuCode", "TDP132").data("Param", "OrderNo=" + siteOrderNo).referrer(refferUrl).method(Connection.Method.POST).ignoreContentType(true).followRedirects(true).execute();
        String url = URLDecoder.decode(rs.body(), "UTF-8");
        url = url.replaceAll("\"", "");
        Thread.sleep(1500L);
        Document doc = Jsoup.connect((String)url).cookies(cookies).followRedirects(true).ignoreContentType(true).get();
        Elements ele = doc.select("td").eq(2);
        return ele.text();
    }

    private String setHtmlTagDelete(String value) {
        return value.replaceAll("<(/)?([a-zA-Z]*)(\\s[a-zA-Z]*=[^>]*)?(\\s)*(/)?>", "");
    }
}

