/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.cafe24;

import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class Cafe24AcessToken {
    private static Cafe24AcessToken context = new Cafe24AcessToken();
    private static Map<String, String> accessTokenMap = new HashMap<String, String>();

    static {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (KeyManagementException keyManagementException) {}
    }

    private Cafe24AcessToken() {
    }

    public static Cafe24AcessToken get() {
        return context;
    }

    public String getAccessToken(ShoppingMallDetailDto shoppingMallDetailDto) {
        String key = shoppingMallDetailDto.getShoppingid() + shoppingMallDetailDto.getPassword();
        if (accessTokenMap.get(key) == null) {
            String code = Cafe24AcessToken.getAuthorizationCode(shoppingMallDetailDto);
            accessTokenMap.put(key, Cafe24AcessToken.getClientCredentials(shoppingMallDetailDto, code));
        } else {
            try {
                Connection.Response response_order = Jsoup.connect((String)String.format("https://%s.cafe24api.com/api/v2/admin/dashboard", shoppingMallDetailDto.getShoppingid())).header("Authorization", "Bearer " + accessTokenMap.get(key)).header("Content-Type", "application/json").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
                if (response_order.statusCode() != 200) {
                    String code = Cafe24AcessToken.getAuthorizationCode(shoppingMallDetailDto);
                    accessTokenMap.put(key, Cafe24AcessToken.getClientCredentials(shoppingMallDetailDto, code));
                }
            }
            catch (IOException iOException) {
                String code = Cafe24AcessToken.getAuthorizationCode(shoppingMallDetailDto);
                accessTokenMap.put(key, Cafe24AcessToken.getClientCredentials(shoppingMallDetailDto, code));
            }
        }
        return accessTokenMap.get(key);
    }

    public static String getAuthGrantType(String mallId, String clientId, String callbackURL) {
        String scope = String.join((CharSequence)",", "mall.read_product", "mall.write_product", "mall.read_category", "mall.write_category", "mall.read_store");
        StringBuilder url = new StringBuilder();
        url.append(Cafe24AcessToken.getAuthorizeUrl(mallId)).append("?response_type=code").append("&client_id=").append(clientId).append("&redirect_uri=").append(callbackURL).append("&scope=").append(scope);
        return url.toString();
    }

    public static String getAuthorizeUrl(String mallId) {
        return "https://" + mallId + ".cafe24api.com/api/v2/oauth/authorize";
    }

    public static String getTokenUrl(String mallId) {
        return "https://" + mallId + ".cafe24api.com/api/v2/oauth/token";
    }

    public static String getAuthorizationCode(ShoppingMallDetailDto shoppingMallDetailDto) {
        String callBackUrl = shoppingMallDetailDto.getApikey();
        String mallId = shoppingMallDetailDto.getShoppingid();
        String clientId = shoppingMallDetailDto.getAuthkey1();
        String loginID = shoppingMallDetailDto.getShoppingid();
        String loginPw = shoppingMallDetailDto.getPassword();
        String authorizationRedirect = Cafe24AcessToken.getAuthGrantType(mallId, clientId, callBackUrl);
        try (ChromeDriver driver2 = null;){
            driver2 = ChromeExtention.getInstace().getDriver();
            new WebDriverWait((WebDriver)driver2, 10L);
            driver2.get(authorizationRedirect);
            WebElement elementloginBox = driver2.findElement(By.xpath((String)"/html/body/div[2]/div/section/div/form/div[1]"));
            elementloginBox.findElement(By.id((String)"mall_id")).sendKeys(new CharSequence[]{loginID});
            elementloginBox.findElement(By.id((String)"userpasswd")).sendKeys(new CharSequence[]{loginPw});
            elementloginBox.findElement(By.xpath((String)"/html/body/div[2]/div[2]/section/div/form/div/div[2]/button")).click();
            Thread.sleep(1000L);
            try {
                WebElement login = driver2.findElement(By.xpath((String)"/html/body/div[2]/div/div/div[1]/div[4]"));
                login.findElement(By.id((String)"iptBtnEm")).click();
            }
            catch (Exception exception) {
                YDMAStringUtil.Print("\ube44\ubc00\ubc88\ud638\ubcc0\uacbd\ud560\uac8c \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            Thread.sleep(1000L);
            try {
                WebElement btnsubmit = driver2.findElement(By.xpath((String)"/html/body/div/div[4]"));
                btnsubmit.findElement(By.className((String)"btnSubmit")).click();
            }
            catch (Exception exception) {
                YDMAStringUtil.Print("\ub3d9\uc758\ud568\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            Thread.sleep(1000L);
            try {
                if (ExpectedConditions.alertIsPresent().apply((Object)driver2) != null) {
                    driver2.switchTo().alert().accept();
                }
            }
            catch (Exception e) {
                YDMAStringUtil.Print(e.getMessage());
            }
            Thread.sleep(1000L);
            String redirectUrl = driver2.getCurrentUrl();
            String code = "";
            List params = URLEncodedUtils.parse((String)redirectUrl, (Charset)Charset.defaultCharset());
            for (NameValuePair param : params) {
                if (!param.getName().contains("code")) continue;
                code = param.getValue();
                break;
            }
            YDMAStringUtil.Print("code=" + code);
            String string = code;
            return string;
        }
        return null;
    }

    public static String getClientCredentials(ShoppingMallDetailDto shoppingMallDetailDto, String code) {
        String returnValue;
        block16: {
            Pattern pat = Pattern.compile(".*\"access_token\"\\s*:\\s*\"([^\"]+)\".*");
            String mallId = shoppingMallDetailDto.getShoppingid();
            String clientId = shoppingMallDetailDto.getAuthkey1();
            String clientSecret = shoppingMallDetailDto.getAuthkey2();
            String callBackUrl = shoppingMallDetailDto.getApikey();
            String tokenUrl = Cafe24AcessToken.getTokenUrl(mallId);
            String auth = clientId + ":" + clientSecret;
            String authentication = Base64.getEncoder().encodeToString(auth.getBytes());
            String content = "grant_type=authorization_code&code=" + code + "&redirect_uri=" + callBackUrl;
            BufferedReader reader = null;
            HttpURLConnection connection = null;
            returnValue = "";
            try {
                try {
                    URL url = new URL(tokenUrl);
                    connection = (HttpsURLConnection)url.openConnection();
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("Authorization", "Basic " + authentication);
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    connection.setRequestProperty("Accept", "application/json");
                    connection.setReadTimeout(15000);
                    connection.setConnectTimeout(15000);
                    PrintStream os = new PrintStream(connection.getOutputStream());
                    os.print(content);
                    os.close();
                    reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    String line = null;
                    StringWriter out = new StringWriter(connection.getContentLength() > 0 ? connection.getContentLength() : 2048);
                    while ((line = reader.readLine()) != null) {
                        out.append(line);
                    }
                    String response = out.toString();
                    Matcher matcher = pat.matcher(response);
                    if (matcher.matches() && matcher.groupCount() > 0) {
                        returnValue = matcher.group(1);
                    }
                }
                catch (Exception e) {
                    YDMAStringUtil.Print("Error : " + e.getMessage());
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    connection.disconnect();
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                connection.disconnect();
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            connection.disconnect();
        }
        YDMAStringUtil.Print("Access Token=" + returnValue);
        return returnValue;
    }
}

