/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.kakaostore;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.kakaostore.IShopOrderKakaoStoreCommand;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

class KakaoStoreOrderNewCommand
extends IShopOrderKakaoStoreCommand {
    private static IShopOrderCommand instance = new KakaoStoreOrderNewCommand();
    private boolean isBasic = false;
    JsonParser jsonParser = new JsonParser();

    private KakaoStoreOrderNewCommand() {
    }

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        try {
            ShopOrderMstDto dto = param.get(0);
            String startdt = dto.getStartDt().substring(0, 8);
            String enddt = dto.getEndDt().substring(0, 8);
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
            Date sdate = formatter.parse(startdt);
            Date edate = formatter.parse(enddt);
            long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
            Calendar cal1 = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal1.setTime(sdate);
            cal2.setTime(sdate);
            this.isBasic = dto.getSpecificStatus() == null || dto.getSpecificStatus().equals("");
            String[] orderStatus = this.getOrderStatus(dto.getSpecificStatus());
            int i = 0;
            while (i < (int)range) {
                this.getOrder(dto, startdt, retList, orderStatus);
                cal1.add(5, 1);
                startdt = formatter.format(cal1.getTime());
                ++i;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 \uc8fc\ubb38 \ub3d9\uae30\ud654\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return retList;
    }

    private String[] getOrderStatus(String specifinOrder) {
        if (this.isBasic) {
            return new String[]{"ShippingRequest", "ShippingWaiting", "ShippingComplete", "BuyDecision"};
        }
        switch (specifinOrder) {
            case "\uc2e0\uaddc\uc8fc\ubb38": {
                return new String[]{"ShippingRequest"};
            }
            case "\ubc1c\uc8fc\ud6c4\uc8fc\ubb38": {
                return new String[]{"ShippingWaiting"};
            }
            case "\ubc30\uc1a1\uc911": {
                return new String[]{"ShippingProgress"};
            }
            case "\ubc30\uc1a1\uc644\ub8cc": {
                return new String[]{"ShippingComplete"};
            }
            case "\uad6c\ub9e4\ud655\uc815": {
                return new String[]{"BuyDecision"};
            }
            case "\ucde8\uc18c": {
                return new String[]{"ShippingCancelRequestBuyer", "ShippingCancelRequest", "ShippingCancelRequestSeller", "ShippingCancelComplete", "PayCancelComplete"};
            }
            case "\ubc18\ud488": {
                return new String[]{"ReturnRequest", "ReturnApproved", "ReturnPending", "ShippingRefundComplete", "ReturnCancelComplete", "ReturnRefundComplete", "ReturnShippingComplete"};
            }
            case "\uad50\ud658": {
                return new String[]{"ExchangeRequest", "ExchangeApproved", "ExchangePending", "ExchangeReturning", "ExchangeReturnComplete", "ExchangeShippingProgress", "ExchangeShippingComplete"};
            }
        }
        return new String[0];
    }

    public List<ShopOrderMstDto> getOrder(ShopOrderMstDto dto, String date, List<ShopOrderMstDto> retList, String[] orderStatus) throws Exception {
        try {
            String orderDate = YDMATimeUtil.convertSabangNetClaimDateToClmdt(date, false);
            String apiKey = dto.getApikey();
            String[] stringArray = orderStatus;
            int n = orderStatus.length;
            int n2 = 0;
            while (n2 < n) {
                String orderstat = stringArray[n2];
                StringBuilder urlbuilder = new StringBuilder();
                urlbuilder.append("https://kapi.kakao.com/v2/shopping/orders?").append("orderModifiedAtStart=").append(orderDate + "%2000:00:00").append("&orderModifiedAtEnd=").append(orderDate + "%2023:59:59").append("&orderStatus=").append(orderstat).append("&size=100");
                URL url = new URL(urlbuilder.toString());
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("Host", "kapi.kakao.com");
                conn.setRequestProperty("channel-ids", "101");
                conn.setRequestProperty("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053");
                conn.setRequestProperty("Target-Authorization", "KakaoAK " + apiKey);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoInput(true);
                Throwable throwable = null;
                Object var15_16 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String line;
                    StringBuilder sb = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        sb.append(line);
                    }
                    JsonObject jsonObject = (JsonObject)this.jsonParser.parse(sb.toString());
                    JsonArray arr = (JsonArray)jsonObject.get("contents");
                    if (arr.size() > 0) {
                        for (JsonElement ele : arr) {
                            String kakaoStat = ele.getAsJsonObject().get("orderStatus").getAsString();
                            String orderStat = this.getOrderStat(kakaoStat);
                            if (this.isBasic && kakaoStat.equals("ShippingRequest")) {
                                String odNo = ele.getAsJsonObject().get("orderId").getAsString();
                                this.orderConfirm(odNo, apiKey);
                                continue;
                            }
                            this.dataMapping(dto, ele.getAsJsonObject(), orderStat, retList);
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return retList;
    }

    private String getOrderStat(String kakaoStat) {
        String orderStat = "";
        switch (kakaoStat) {
            case "ShippingRequest": 
            case "ShippingWaiting": {
                orderStat = "100";
                break;
            }
            case "ShippingProgress": {
                orderStat = "403";
                break;
            }
            case "ShippingComplete": 
            case "BuyDecision": {
                orderStat = "410";
                break;
            }
            case "ShippingCancelRequest": 
            case "ShippingCancelRequestBuyer": 
            case "ShippingCancelRequestSeller": {
                orderStat = "C01";
                break;
            }
            case "ShippingCancelComplete": 
            case "PayCancelComplete": {
                orderStat = "C02";
                break;
            }
            case "ReturnApproved": 
            case "ReturnRequest": 
            case "ReturnPending": {
                orderStat = "R01";
                break;
            }
            case "ReturnCancelComplete": 
            case "ReturnRefundComplete": 
            case "ReturnShippingComplete": 
            case "ShippingRefundComplete": {
                orderStat = "R02";
                break;
            }
            case "ExchangePending": 
            case "ExchangeReturnComplete": 
            case "ExchangeRequest": 
            case "ExchangeApproved": 
            case "ExchangeReturning": 
            case "ExchangeShippingProgress": {
                orderStat = "E01";
                break;
            }
            case "ExchangeShippingComplete": {
                orderStat = "E02";
            }
        }
        return orderStat;
    }

    public void orderConfirm(String odNo, String apikey) throws Exception {
        String json = "{\"orderIds\": [" + odNo + "]}";
        try {
            Connection.Response response = Jsoup.connect((String)"https://kapi.kakao.com/v1/shopping/orders/deliveries/status/confirm").header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/json").requestBody(json).followRedirects(true).ignoreContentType(true).ignoreHttpErrors(true).method(Connection.Method.POST).execute();
            YDMAStringUtil.Print(response);
        }
        catch (Exception exception) {
            throw new Exception("\uce74\uce74\uc624\uc2a4\ud1a0\uc5b4 \uc8fc\ubb38\ud655\uc778 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    public List<ShopOrderMstDto> dataMapping(ShopOrderMstDto param, JsonObject object, String status2, List<ShopOrderMstDto> retList) {
        try {
            String odNo = object.get("orderId").getAsString();
            boolean ordMatch = retList.stream().anyMatch(s -> s.getOrder_id().equals(odNo));
            if (!this.isBasic || !ShopOrderDao.get().isOrdered(odNo) && !ordMatch) {
                ShopOrderMstDto dto = new ShopOrderMstDto();
                dto.setShopid(param.getShopid());
                dto.setShop_userid(param.getShop_userid());
                dto.setOrder_id(this.isNullCheck(object.get("orderId")));
                dto.setReg_date(YDMATimeUtil.getCurrentTimeByYDFormat());
                dto.setOrder_status(status2);
                Object ordDt = object.get("createdAt").getAsString();
                ordDt = ((String)ordDt).substring(0, 4) + "-" + ((String)ordDt).substring(4, 6) + "-" + ((String)ordDt).substring(6, 8) + " " + ((String)ordDt).substring(8, 10) + ":" + ((String)ordDt).substring(10, 12) + ":" + ((String)ordDt).substring(12, 14);
                dto.setOrder_date((String)ordDt);
                JsonObject orderDetail = this.getOrderDetailByOrderNo(odNo, param.getApikey());
                JsonObject orderer = (JsonObject)orderDetail.get("orderer");
                String phoneNumber = this.isNullCheck(orderer.get("phoneNumber")).replace("+82 ", "0");
                dto.setUser_tel(phoneNumber);
                JsonObject prdinfo = (JsonObject)orderDetail.get("orderProduct");
                dto.setMall_product_id(this.isNullCheck(prdinfo.get("id")));
                dto.setP_product_name(this.isNullCheck(prdinfo.get("name")));
                dto.setProduct_name(this.isNullCheck(prdinfo.get("name")));
                dto.setCompayny_goods_cd(this.isNullCheck(prdinfo.get("sellerItemNo")));
                dto.setProduct_id(this.isNullCheck(prdinfo.get("sellerItemNo")));
                dto.setCompno(param.getCompno());
                dto.setP_sku_value(this.isNullCheck(prdinfo.get("optionContent")));
                int productPrice = prdinfo.get("settlementBasicPrice").getAsInt();
                int optionPrice = prdinfo.get("optionPrice").getAsInt();
                int baseFee = prdinfo.get("baseFee").getAsInt();
                int displayFee = prdinfo.get("displayFee").getAsInt();
                int deliveryAmount = prdinfo.get("deliveryAmount").getAsInt();
                dto.setWon_cost("0");
                dto.setSale_cnt(this.isNullCheck(prdinfo.get("quantity")));
                dto.setTotal_cost(String.valueOf(productPrice + optionPrice));
                dto.setMall_won_cost(String.valueOf(productPrice + optionPrice - baseFee - displayFee));
                dto.setSale_cost(String.valueOf(productPrice + optionPrice));
                dto.setDelv_cost(this.isNullCheck(prdinfo.get("deliveryAmount")));
                String deliveryAmountType = this.deliveryAmountType(prdinfo.get("deliveryAmountType").getAsString());
                String PayPointTime = this.isNullCheck(prdinfo.get("deliveryAmountPayPointTime"));
                dto.setDelivery_method_str2(deliveryAmountType.equals("\ubb34\ub8cc") ? "\ubb34\ub8cc" : (PayPointTime.equals("PayedToOrder") ? "\uc120\ubd88" : "\ucc29\ubd88"));
                if (orderDetail.has("orderDeliveryRequest")) {
                    JsonObject deliveryReq = (JsonObject)orderDetail.get("orderDeliveryRequest");
                    dto.setDelv_msg(this.isNullCheck(deliveryReq.get("requirement")));
                    String roadZipCode = this.isNullCheck(deliveryReq.get("roadZipCode"));
                    dto.setReceive_zipcode(roadZipCode);
                    dto.setReceive_addr(this.isNullCheck(deliveryReq.get("receiverAddress")));
                    dto.setReceive_tel(this.isNullCheck(deliveryReq.get("receiverPhoneNumber")));
                    dto.setReceive_cel(this.isNullCheck(deliveryReq.get("receiverMobileNumber")));
                    dto.setReceive_name(this.isNullCheck(deliveryReq.get("receiverName")));
                } else {
                    dto.setReceive_addr("");
                    dto.setDelv_msg("");
                    dto.setReceive_tel("");
                    dto.setReceive_cel("");
                    dto.setReceive_name("");
                    dto.setReceive_zipcode("");
                }
                dto.setUser_cel(phoneNumber);
                dto.setUser_email("");
                dto.setReceive_email("");
                dto.setUser_id("");
                dto.setUser_name("");
                dto.setDelivery_id("");
                dto.setInvoice_no("");
                dto.setLabel("");
                dto.setPay_cost(String.valueOf(productPrice + optionPrice + deliveryAmount));
                dto.setBox_ea("0");
                dto.setMall_exp_cd("0");
                dto.setAuthkey1(param.getAuthkey1());
                dto.setResult_code("1");
                retList.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retList;
    }

    private JsonObject getOrderDetailByOrderNo(String odNo, String apikey) throws Exception {
        Connection.Response response_order = Jsoup.connect((String)("https://kapi.kakao.com/v1/shopping/order?order_id=" + odNo)).header("Host", "kapi.kakao.com").header("Authorization", "KakaoAK b99a474fd6fe27f966e76e37591f0053").header("Target-Authorization", "KakaoAK " + apikey).header("channel-ids", "101").header("Content-Type", "application/x-www-form-urlencoded;charset=utf-8").followRedirects(true).ignoreContentType(true).method(Connection.Method.GET).execute();
        return this.jsonParser.parse(response_order.body()).getAsJsonObject();
    }

    public String deliveryAmountType(String keyword) {
        switch (keyword) {
            case "FREE": {
                return "\ubb34\ub8cc";
            }
            case "PAID": {
                return "\uc720\ub8cc";
            }
            case "CONDITIONAL_FREE": {
                return "\uc870\uac74\ubd80\ubb34\ub8cc";
            }
            case "QUANTITY_PAID": {
                return "\uc218\ub7c9\ubcc4 \ubd80\uacfc";
            }
        }
        return keyword;
    }

    private String isNullCheck(JsonElement jsonElement) {
        String value = jsonElement == null ? "" : (jsonElement.isJsonNull() ? "" : (jsonElement.getAsString().isEmpty() ? "" : jsonElement.getAsString()));
        return value;
    }
}

