/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.lotteon;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.data.lotteon.LotteOnProductDto;
import com.kdjsystem.mlink.shop.data.lotteon.ShopLotteOnAdditionalDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class LotteOnProductModifyService
extends IProductModifyStatusApi {
    private static final String Host = "https://openapi.lotteon.com";
    List<ShopOptionDto> shopOptionDtos;

    private String setProductReg(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, List<String> strImages) throws Exception {
        String json = "";
        ObjectMapper mapper = new ObjectMapper();
        LotteOnProductDto.ProductRequest prodRequest = new LotteOnProductDto.ProductRequest();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst> spdLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst>();
        LotteOnProductDto.ProductRequest.SpdLst spd = new LotteOnProductDto.ProductRequest.SpdLst();
        spd.spdNo = dto.getShopprodno();
        this.Transact(dtllist, shoppingMallDetailDto, spd);
        this.Category(dto, dtllist, shoppingMallDetailDto, spd);
        this.Basic(dto, dtllist, spd);
        this.Option(dto, dtllist, spd, strImages, shoppingMallDetailDto);
        this.DetailRemark(dto, spd, dtllist);
        this.ItemBasic(dtllist, spd, dto, shoppingMallDetailDto);
        this.Notice(spd, dtllist, dto);
        this.BasicShipping(dtllist, spd);
        spdLst.add(spd);
        prodRequest.spdLst = spdLst;
        mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        json = mapper.writeValueAsString((Object)prodRequest);
        String imsiitemId = this.productRegSend(json, shoppingMallDetailDto, "/v1/openapi/product/v1/product/modification/request");
        dto.setResult_code("1");
        dto.setShopprodno(imsiitemId);
        return json;
    }

    private void Transact(ShopLotteOnAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        try {
            spd.trGrpCd = "SR";
            spd.trNo = shoppingMallDetailDto.getAuthkey1();
            spd.lrtrNo = "";
            spd.ctrtTypCd = "A";
            if (dtllist.getCtrtTypCd().equals("A")) {
                spd.rtrvTypCd = "ENTP_RTRV";
            }
        }
        catch (Exception exception) {
            throw new Exception("\uac70\ub798\ucc98, \uacc4\uc57d\uc720\ud615\uc744 \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private JsonObject Category(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        Request request2;
        spd.scatNo = dtllist.getIsCategory().equals("1") ? dtllist.getShopcatno() : dto.getShopCid();
        JsonParser parser = new JsonParser();
        OkHttpClient client = new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        Response response = client.newCall(request2 = new Request.Builder().url("https://onpick-api.lotteon.com/cheetah/econCheetah.ecn?job=cheetahStandardCategory&filter_1=" + spd.scatNo).method("GET", null).addHeader("Content-Type", "application/json; charset=\"UTF-8\"").addHeader("Referer", "https://store.lotteon.com/").addHeader("accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/93.0.4577.82 Safari/537.36").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build()).execute();
        JsonObject result = (JsonObject)parser.parse(response.body().string().toString());
        JsonArray data2 = (JsonArray)result.get("itemList");
        if (data2.size() == 0) {
            dto.setResult_text("\ud574\ub2f9 \uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            throw new Exception("\ud574\ub2f9 \uc0c1\ud488\uc758 \uce74\ud14c\uace0\ub9ac \uac12\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        JsonObject itemList = (JsonObject)data2.get(0);
        JsonObject item = (JsonObject)itemList.get("data");
        JsonArray disp_list = (JsonArray)item.get("disp_list");
        JsonObject disp = (JsonObject)disp_list.get(0);
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.DcatLst> dcatLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.DcatLst>();
        LotteOnProductDto.ProductRequest.SpdLst.DcatLst dcat = new LotteOnProductDto.ProductRequest.SpdLst.DcatLst();
        dcat.mallCd = "LTON";
        dcat.lfDcatNo = disp.get("disp_cat_id").getAsString();
        dcatLst.add(dcat);
        spd.dcatLst = dcatLst;
        return item;
    }

    private void Basic(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        try {
            String sellerProductName;
            byte[] sellerProductNameByte;
            String value = "";
            switch (dtllist.getPdPrtWay()) {
                case "1": {
                    value = dto.getGoods_nm();
                    break;
                }
                case "2": {
                    value = dto.getModel_nm();
                    break;
                }
                case "3": {
                    value = dto.getGoods_nm().concat(" (").concat(dto.getModel_nm()).concat(")");
                    break;
                }
                case "4": {
                    value = dto.getModel_nm().concat(" (").concat(dto.getGoods_nm()).concat(")");
                    break;
                }
                case "5": {
                    value = dto.getGoods_nm().concat(" ").concat(dto.getModel_nm());
                    break;
                }
                case "6": {
                    value = dto.getModel_nm().concat(" ").concat(dto.getGoods_nm());
                    break;
                }
                default: {
                    value = dto.getGoods_nm();
                }
            }
            if (!dtllist.getPdNmAddFrtTxt().equals("")) {
                value = dtllist.getPdNmAddFrtTxt().concat(value);
            }
            if (!dtllist.getPdNmAddBackTxt().equals("")) {
                value = value.concat(dtllist.getPdNmAddBackTxt());
            }
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 148);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            if ((sellerProductNameByte = (sellerProductName = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 148) : value).getBytes()).length > 148) {
                String resultSellerProductName = new String(sellerProductNameByte, 0, 148);
                spd.spdNm = resultSellerProductName + "..";
            } else {
                spd.spdNm = sellerProductName;
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void Option(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd, List<String> strImages, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        String img;
        this.shopOptionDtos = this.getProductOptions(dto);
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst> itmLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst>();
        Long salePrice = this.salePrice(dto, dtllist);
        String uploadedImageUrl = img = strImages.get(0);
        List<ShopOptionDto> option_s_in = this.getProductInOptions(dto);
        ArrayList<ShopOptionDto> deleteOptions = new ArrayList<ShopOptionDto>();
        for (ShopOptionDto optDto : option_s_in) {
            ShopOptionDto shopOption = this.shopOptionDtos.stream().filter(p -> p.getOptcompanycd().equals(optDto.getOptcompanycd())).findAny().orElse(null);
            if (shopOption != null) continue;
            optDto.setCnt("0");
            deleteOptions.add(optDto);
        }
        if (deleteOptions.size() > 0) {
            this.setDeleteOptlist(deleteOptions, salePrice, dto, strImages, itmLst, dtllist);
        }
        if (this.shopOptionDtos.size() > 0) {
            spd.stkMgtYn = dtllist.getStkMgtYn().equals("Y") ? dtllist.getStkMgtYn() : "N";
            ArrayList<ShopOptionDto> addOptions = new ArrayList<ShopOptionDto>();
            ArrayList<ShopOptionDto> modifyOptions = new ArrayList<ShopOptionDto>();
            for (ShopOptionDto optDto : this.shopOptionDtos) {
                ShopOptionDto shopOption = option_s_in.stream().filter(p -> p.getOptcompanycd().equals(optDto.getOptcompanycd())).findAny().orElse(null);
                if (shopOption != null) {
                    optDto.setSellerProductItemId(shopOption.getSellerProductItemId());
                    modifyOptions.add(optDto);
                    continue;
                }
                addOptions.add(optDto);
            }
            if (addOptions.size() > 0) {
                this.setAddOptlist(addOptions, salePrice, dto, dtllist, spd, uploadedImageUrl, itmLst);
            } else if (modifyOptions.size() > 0) {
                this.setModifyOptlist(modifyOptions, salePrice, dto, itmLst, dtllist, spd, uploadedImageUrl);
            }
        } else {
            this.getProductShowNum(dto, shoppingMallDetailDto, itmLst);
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst itm = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst();
            spd.sitmYn = "N";
            itm.sitmNo = dto.getShopShowProdNo();
            itm.sortSeq = "1";
            itm.dpYn = "Y";
            itm.slPrc = dto.getGoods_price();
            itm.stkQty = dto.getQty() == null ? "999" : dto.getQty();
            ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst> itmImgLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst>();
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst itmImg = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst();
            itmImg.epsrTypCd = "IMG";
            itmImg.epsrTypDtlCd = "IMG_SQRE";
            itmImg.origImgFileNm = uploadedImageUrl;
            itmImg.rprtImgYn = "Y";
            itmImgLst.add(itmImg);
            itm.itmImgLst = itmImgLst;
            itmLst.add(itm);
        }
        spd.itmLst = itmLst;
    }

    private void getProductShowNum(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, List<LotteOnProductDto.ProductRequest.SpdLst.ItmLst> itmLst) throws IOException {
        String URL2 = "/v1/openapi/product/v1/product/detail";
        String cusNo = shoppingMallDetailDto.getAuthkey1();
        String Json = "{\"trGrpCd\":\"SR\",\"trNo\":\"" + cusNo + "\",\"spdNo\":\"" + dto.getShopprodno() + "\"}";
        OkHttpClient client = new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)Json);
        Request request2 = new Request.Builder().url(Host.concat(URL2)).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build();
        Throwable throwable = null;
        Object var12_13 = null;
        try (Response response = client.newCall(request2).execute();){
            JsonParser parser = new JsonParser();
            JsonObject result = (JsonObject)parser.parse(response.body().string());
            if (result.get("returnCode").getAsString().equals("0000")) {
                JsonObject data2 = (JsonObject)result.get("data");
                JsonArray itemLst = (JsonArray)data2.get("itmLst");
                JsonObject item = (JsonObject)itemLst.get(0);
                String sitmNos = String.valueOf(item.get("sitmNo"));
                dto.setShopShowProdNo(sitmNos.replace("\"", ""));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Long salePrice(ShopProductDto dto, ShopLotteOnAdditionalDto dtllist) throws Exception {
        Long salePrice;
        try {
            salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            int deliveryFee = 0;
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = Integer.parseInt(dto.getDelv_cost());
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = Integer.parseInt(systemconf.getDeliverycost());
                    }
                } else {
                    deliveryFee = dtllist.getExpprc();
                }
                salePrice = salePrice + (long)deliveryFee;
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            ResultMarketPrice resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uac00\ub97c \uacc4\uc0b0\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        return salePrice;
    }

    private int optSalePrice(Long salePrice, ShopLotteOnAdditionalDto dtllist, ShopOptionDto shopOptionDto) {
        int amt = YDMAStringUtil.convertToInt(shopOptionDto.getAmt());
        salePrice = salePrice + YDMAStringUtil.convertToLong(shopOptionDto.getAmt());
        int limit_price = YDMAStringUtil.convertToInt(shopOptionDto.getLimit_price());
        ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
        if (salePrice > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
            optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
        }
        amt = Integer.parseInt(optionprice.getConsumer_if_sale_price());
        return amt;
    }

    private void setDeleteOptlist(List<ShopOptionDto> deleteOptions, Long salePrice, ShopProductDto dto, List<String> strImages, List<LotteOnProductDto.ProductRequest.SpdLst.ItmLst> itmLst, ShopLotteOnAdditionalDto dtllist) {
        int i = 0;
        for (ShopOptionDto shopOptionDto : deleteOptions) {
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst itm = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst();
            int sortseq = i++;
            int amt = this.optSalePrice(salePrice, dtllist, shopOptionDto);
            itm.sortSeq = String.valueOf(sortseq);
            itm.sitmNo = shopOptionDto.getSellerProductItemId() == null ? "" : dto.getShopprodno().concat("_").concat(shopOptionDto.getSellerProductItemId());
            itm.slPrc = String.valueOf(amt);
            itm.stkQty = shopOptionDto.getCnt();
            ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst> itmImgLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst>();
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst itmImg = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst();
            String img = strImages.get(0);
            itmImg.epsrTypCd = "IMG";
            itmImg.epsrTypDtlCd = "IMG_SQRE";
            itmImg.origImgFileNm = img;
            itmImg.rprtImgYn = "Y";
            itmImgLst.add(itmImg);
            itm.itmImgLst = itmImgLst;
            itmLst.add(itm);
        }
    }

    private void setAddOptlist(List<ShopOptionDto> addOptions, Long salePrice, ShopProductDto dto, ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd, String imgPath, List<LotteOnProductDto.ProductRequest.SpdLst.ItmLst> itmLst) {
        LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst optValSrt;
        LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst optSrt;
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst> optValSrtLst;
        List<String> names;
        int i = 0;
        for (ShopOptionDto shopOptionDto : addOptions) {
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst itmOpt;
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst itm = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst();
            int sortseq = i++;
            int amt = this.optSalePrice(salePrice, dtllist, shopOptionDto);
            names = Arrays.asList(shopOptionDto.getOptspecdes().split(":"));
            itm.sortSeq = String.valueOf(sortseq);
            itm.dpYn = "Y";
            itm.slPrc = String.valueOf(amt);
            itm.stkQty = shopOptionDto.getCnt();
            ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst> itmOptLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst>();
            if (!dto.getChar_2_val().isEmpty()) {
                itmOpt = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst();
                itmOpt.optNm = dto.getChar_1_nm();
                itmOpt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + names.get(0) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + names.get(0) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? names.get(0) + dtllist.getAddOptionR() : names.get(0)));
                itmOptLst.add(itmOpt);
            }
            if (!dto.getChar_2_val().isEmpty()) {
                itmOpt = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst();
                itmOpt.optNm = dto.getChar_2_nm();
                itmOpt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + names.get(1) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + names.get(1) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? names.get(1) + dtllist.getAddOptionR() : names.get(1)));
                itmOptLst.add(itmOpt);
            } else {
                itmOpt = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmOptLst();
                itmOpt.optNm = dto.getChar_1_nm();
                itmOpt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + names.get(0) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + names.get(0) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? names.get(0) + dtllist.getAddOptionR() : names.get(0)));
                itmOptLst.add(itmOpt);
            }
            itm.itmOptLst = itmOptLst;
            ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst> itmImgLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst>();
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst itmImg = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst();
            String img = imgPath;
            itmImg.epsrTypCd = "IMG";
            itmImg.epsrTypDtlCd = "IMG_SQRE";
            itmImg.origImgFileNm = img;
            itmImg.rprtImgYn = "Y";
            itmImgLst.add(itmImg);
            itm.itmImgLst = itmImgLst;
            itmLst.add(itm);
        }
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst> optSrtLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst>();
        ArrayList<String> ctName = new ArrayList<String>();
        ArrayList<String> ctName2 = new ArrayList<String>();
        for (ShopOptionDto shopOptionDto : this.shopOptionDtos) {
            names = Arrays.asList(shopOptionDto.getOptspecdes().split(":"));
            ctName.add(names.get(0));
            if (names.size() <= 1) continue;
            ctName2.add(names.get(1));
        }
        List ctNames = ctName.stream().distinct().collect(Collectors.toList());
        List ctNames2 = ctName2.stream().distinct().collect(Collectors.toList());
        if (!ctNames2.isEmpty()) {
            optValSrtLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst>();
            optSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst();
            optSrt.optSeq = 1;
            optSrt.optNm = dto.getChar_1_nm();
            int j = 0;
            while (j < ctNames.size()) {
                optValSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst();
                optValSrt.optValSeq = j;
                optValSrt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + (String)ctNames.get(j) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + (String)ctNames.get(j) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? (String)ctNames.get(j) + dtllist.getAddOptionR() : (String)ctNames.get(j)));
                optValSrtLst.add(optValSrt);
                ++j;
            }
            optSrt.optValSrtLst = optValSrtLst;
            optSrtLst.add(optSrt);
        }
        if (!ctNames2.isEmpty()) {
            optValSrtLst = new ArrayList();
            optSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst();
            optSrt.optSeq = 2;
            optSrt.optNm = dto.getChar_2_nm();
            int z = 0;
            while (z < ctNames2.size()) {
                optValSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst();
                optValSrt.optValSeq = z;
                optValSrt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + (String)ctNames.get(z) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + (String)ctNames.get(z) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? (String)ctNames.get(z) + dtllist.getAddOptionR() : (String)ctNames.get(z)));
                optValSrtLst.add(optValSrt);
                ++z;
            }
            optSrt.optValSrtLst = optValSrtLst;
            optSrtLst.add(optSrt);
        } else {
            optValSrtLst = new ArrayList();
            optSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst();
            optSrt.optSeq = 0;
            optSrt.optNm = dto.getChar_1_nm();
            int y = 0;
            while (y < ctNames.size()) {
                optValSrt = new LotteOnProductDto.ProductRequest.SpdLst.OptSrtLst.OptValSrtLst();
                optValSrt.optValSeq = y;
                optValSrt.optVal = dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("Y") ? dtllist.getAddOptionL() + (String)ctNames.get(y) + dtllist.getAddOptionR() : (dtllist.getAddoptionlb().equals("Y") && dtllist.getAddoptionrb().equals("N") ? dtllist.getAddOptionL() + (String)ctNames.get(y) : (dtllist.getAddoptionlb().equals("N") && dtllist.getAddoptionrb().equals("Y") ? (String)ctNames.get(y) + dtllist.getAddOptionR() : (String)ctNames.get(y)));
                optValSrtLst.add(optValSrt);
                ++y;
            }
            optSrt.optValSrtLst = optValSrtLst;
            optSrtLst.add(optSrt);
        }
        spd.optSrtLst = optSrtLst;
    }

    private void setModifyOptlist(List<ShopOptionDto> modifyOptions, Long salePrice, ShopProductDto dto, List<LotteOnProductDto.ProductRequest.SpdLst.ItmLst> itmLst, ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd, String imgPath) {
        int i = 0;
        for (ShopOptionDto shopOptionDto : modifyOptions) {
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst itm = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst();
            int sortseq = i++;
            int amt = this.optSalePrice(salePrice, dtllist, shopOptionDto);
            itm.sortSeq = String.valueOf(sortseq);
            itm.sitmNo = shopOptionDto.getSellerProductItemId() == null ? "" : dto.getShopprodno().concat("_").concat(shopOptionDto.getSellerProductItemId());
            itm.slPrc = String.valueOf(amt);
            itm.stkQty = shopOptionDto.getCnt();
            ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst> itmImgLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst>();
            LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst itmImg = new LotteOnProductDto.ProductRequest.SpdLst.ItmLst.ItmImgLst();
            String img = imgPath;
            itmImg.epsrTypCd = "IMG";
            itmImg.epsrTypDtlCd = "IMG_SQRE";
            itmImg.origImgFileNm = img;
            itmImg.rprtImgYn = "Y";
            itmImgLst.add(itmImg);
            itm.itmImgLst = itmImgLst;
            itmLst.add(itm);
        }
    }

    private void DetailRemark(ShopProductDto dto, LotteOnProductDto.ProductRequest.SpdLst spd, ShopLotteOnAdditionalDto dtllist) throws Exception {
        ArrayList<LotteOnProductDto.ProductRequest.SpdLst.EpnLst> epnLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.EpnLst>();
        LotteOnProductDto.ProductRequest.SpdLst.EpnLst dscrp = new LotteOnProductDto.ProductRequest.SpdLst.EpnLst();
        LotteOnProductDto.ProductRequest.SpdLst.EpnLst ascnts = new LotteOnProductDto.ProductRequest.SpdLst.EpnLst();
        try {
            dscrp.pdEpnTypCd = "DSCRP";
            Object addDetailPlus = "";
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = dtllist.getDetailKeywordL() + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            dscrp.cnts = dtllist.getPdDtlFrtDec() + IProduct.removeBrokenImgTag(dto.getGoods_remarks()) + dtllist.getPdDtlBackDec();
            epnLst.add(dscrp);
            ascnts.pdEpnTypCd = "AS_CNTS";
            ascnts.cnts = dtllist.getAsGuide();
            epnLst.add(ascnts);
            spd.epnLst = epnLst;
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\uc138\uc124\uba85\uc744 \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void ItemBasic(ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd, ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            spd.cshbltyPdYn = "N";
            spd.ageLmtCd = dtllist.getAgeLmtCd();
            spd.bookCultCstDdctYn = dtllist.getBookCultCstDdctYn();
            spd.epdNo = dto.getCompayny_goods_cd();
            spd.slTypCd = dtllist.getSlTypCd();
            spd.pdTypCd = dtllist.getPdTypCd();
            spd.tdfDvsCd = dtllist.getTdfDvsCd();
            spd.oplcCd = "\uc0c1\ud488\uc0c1\uc138 \ucc38\uc870";
            spd.mfcrNm = dto.getMaker();
            spd.impCoNm = dtllist.getImpCoNm();
            spd.impDvsCd = dtllist.getImpDvsCd();
            spd.pdStatCd = dtllist.getPdStatCd();
            spd.cnclPsbYn = dtllist.getCnclPsbYn();
            spd.immdCnclPsbYn = dtllist.getImmdCnclPsbYn();
            spd.brkHmapPkcpPsbYn = dtllist.getBrkHmapPkcpPsbYn();
            spd.asGuide = dtllist.getAsGuide();
            spd.pdOptmodifyYn = dtllist.getPdOptmodifyYn();
            spd.selSaleOptSetYn = dtllist.getSelSaleOptSetYn();
        }
        catch (Exception exception) {
            throw new Exception("\uae30\ubcf8 \ubd80\uac00\uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        try {
            spd.slStrtDttm = YDMATimeUtil.getCurrentDateHanjin() + "000000";
            spd.slEndDttm = dtllist.getSlEndDttm();
            dto.setSaleenddt(spd.slEndDttm);
            spd.dpYn = "Y";
            spd.prcCmprEpsrYn = dtllist.getPrcCmprEpsrYn();
        }
        catch (Exception exception) {
            throw new Exception("\ud310\ub9e4\uc815\ubcf4\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        try {
            spd.mdlNo = dto.getCompayny_goods_cd();
            spd.prstPsbYn = dtllist.getPrstPsbYn();
        }
        catch (Exception exception) {
            throw new Exception("\uae30\ud0c0\uc815\ubcf4\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        try {
            spd.scKwdLst = new ArrayList<String>();
            String search = dto.getGoods_search();
            String[] splitSearch = search.split(",");
            if (splitSearch.length > 5) {
                int i = 0;
                while (i < 5) {
                    spd.scKwdLst.add(splitSearch[i]);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < splitSearch.length) {
                    spd.scKwdLst.add(splitSearch[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud0a4\uc6cc\ub4dc\ub97c \ub4f1\ub85d\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        LotteOnProductDto.ProductRequest.SpdLst.PurPsbQtyInfo purpsbQtyInfo = new LotteOnProductDto.ProductRequest.SpdLst.PurPsbQtyInfo();
        try {
            purpsbQtyInfo.itmByMinPurYn = dtllist.getItmByMinPurYn();
            if (dtllist.getItmByMinPurYn().equals("Y")) {
                purpsbQtyInfo.itmByMinPurQty = dtllist.getItmByMinPurQty();
            }
            purpsbQtyInfo.itmByMaxPurPsbQtyYn = dtllist.getItmByMaxPurPsbQtyYn();
            if (dtllist.getItmByMaxPurPsbQtyYn().equals("Y")) {
                purpsbQtyInfo.maxPurQty = dtllist.getMaxPurQty();
            }
        }
        catch (Exception exception) {
            throw new Exception("\uad6c\ub9e4\uac00\ub2a5 \uc218\ub7c9\uc815\ubcf4\ub97c \uc785\ub825\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
        spd.purPsbQtyInfo = purpsbQtyInfo;
        spd.brdNo = dtllist.getBrdRegYn().equals("Y") ? "" : "";
    }

    private void Notice(LotteOnProductDto.ProductRequest.SpdLst spd, ShopLotteOnAdditionalDto dtllist, ShopProductDto dto) throws Exception {
        try {
            spd.sbjPstTitUseYn = dtllist.getSbjPstTitUseYn();
            spd.btcAppSetYn = dtllist.getBtcAppSetYn();
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo pdItmsInfo = new LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo();
            ArrayList<LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo.PdItmsArtlLst> pdItmsArtlLst = new ArrayList<LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo.PdItmsArtlLst>();
            List<ShopProdAttrnmDto> lotteonProductAttrList = ShopProductDao.get().getProductLotteOnNotice(dto.getProp1_cd(), "shop0372");
            pdItmsInfo.pdItmsRegWay = "NEW";
            pdItmsInfo.pdItmsCd = lotteonProductAttrList.get(0).getAttrcd();
            pdItmsInfo.pdTempletCd = "";
            for (ShopProdAttrnmDto lotteonProduct : lotteonProductAttrList) {
                LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo.PdItmsArtlLst pdItmsArtl = new LotteOnProductDto.ProductRequest.SpdLst.PdItmsInfo.PdItmsArtlLst();
                ShopProdAttrnmDto shopProdAttrnmDtos = dto.getShopProdAttrnmDtos().stream().filter(p -> p.getAttrnm().contains(lotteonProduct.getAttrvl())).findAny().orElse(null);
                pdItmsArtl.pdItmsCd = lotteonProduct.getAttrcd();
                pdItmsArtl.pdArtlCd = lotteonProduct.getColseq();
                if (dtllist.getBtcAppSetYn().equals("Y")) {
                    pdItmsArtl.pdArtlCnts = "\uc0c1\ud488\uc0c1\uc138\ucc38\uc870";
                } else if (shopProdAttrnmDtos != null) {
                    if (shopProdAttrnmDtos.getProp_val().equals("")) {
                        shopProdAttrnmDtos.setProp_val("\uc0c1\ud488\uc0c1\uc138\ucc38\uc870");
                    }
                    pdItmsArtl.pdArtlCnts = shopProdAttrnmDtos.getProp_val();
                } else {
                    pdItmsArtl.pdArtlCnts = "\uc0c1\ud488\uc0c1\uc138\ucc38\uc870";
                }
                pdItmsArtlLst.add(pdItmsArtl);
            }
            pdItmsInfo.pdItmsArtlLst = pdItmsArtlLst;
            spd.pdItmsInfo = pdItmsInfo;
        }
        catch (Exception exception) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void BasicShipping(ShopLotteOnAdditionalDto dtllist, LotteOnProductDto.ProductRequest.SpdLst spd) throws Exception {
        try {
            spd.dmstOvsDvDvsCd = dtllist.getDmstOvsDvDvsCd();
            spd.pstkYn = "N";
            spd.dvProcTypCd = dtllist.getDvProcTypCd();
            String[] spl = dtllist.getDvPdTypCd().split("%%");
            spd.dvPdTypCd = spl[0];
            spd.sndBgtNday = Integer.parseInt(spl[1]);
            LotteOnProductDto.ProductRequest.SpdLst.SndBgtDdInfo BgtDdInfo = new LotteOnProductDto.ProductRequest.SpdLst.SndBgtDdInfo();
            BgtDdInfo.nldySndCloseTm = dtllist.getNldySndCloseTm();
            BgtDdInfo.satSndPsbYn = dtllist.getSatSndPsbYn();
            if (dtllist.getSatSndPsbYn().equals("Y")) {
                BgtDdInfo.satSndCloseTm = dtllist.getSatSndCloseTm();
            }
            spd.sndBgtDdInfo = BgtDdInfo;
            spd.cmbnDvPsbYn = dtllist.getCmbnDvPsbYn();
            spd.dvRgsprGrpCd = dtllist.getDvRgsprGrpCd();
            spd.dvMnsCd = dtllist.getDvMnsCd();
            spd.owhpNo = dtllist.getOwhpNo();
            spd.hdcCd = dtllist.getHdcCd();
            spd.dvCstPolNo = dtllist.getDvCstPolNo();
            spd.adtnDvCstPolNo = dtllist.getAdtnDvCstPolNo();
            spd.cmbnDvPsbYn = dtllist.getCmbnDvPsbYn();
            spd.dvCstStdQty = dtllist.getDvCstStdQty();
            spd.qckDvUseYn = dtllist.getQckDvUseYn();
            spd.crdayDvPsbYn = dtllist.getCrdayDvPsbYn();
            if (dtllist.getCrdayDvPsbYn().equals("Y")) {
                spd.crdayDvInfo = new LotteOnProductDto.ProductRequest.SpdLst.CrdayDvInfo();
                spd.crdayDvInfo.odCloseTm = dtllist.getOdCloseTm();
            }
            spd.hpDdDvPsbYn = dtllist.getHpDdDvPsbYn();
            spd.saveTypCd = dtllist.getSaveTypCd();
            spd.rtngPsbYn = dtllist.getRtngPsbYn();
            spd.xchgPsbYn = dtllist.getXchgPsbYn();
            spd.echgPsbYn = dtllist.getEchgPsbYn();
            spd.cmbnRtngPsbYn = dtllist.getCmbnRtngPsbYn();
            spd.rtngHdcCd = dtllist.getRtngHdcCd();
            spd.rtngRtrvPsbYn = dtllist.getRtngRtrvPsbYn();
            spd.rtrpNo = dtllist.getRtrpNo();
        }
        catch (Exception exception) {
            throw new Exception("\ubc30\uc1a1\uc815\ubcf4\ub97c \uac00\uc838\uc624\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String productRegSend(String json, ShoppingMallDetailDto shoppingMallDetailDto, String url) throws Exception {
        String code = "";
        OkHttpClient client = new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url(Host.concat(url)).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build();
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (Response response = client.newCall(request2).execute();){
                JsonParser parser = new JsonParser();
                JsonObject result = (JsonObject)parser.parse(response.body().string());
                if (result.get("returnCode").getAsString().equals("0000")) {
                    JsonArray data2 = (JsonArray)result.get("data");
                    JsonObject returnData = (JsonObject)data2.get(0);
                    if (returnData.get("resultCode").getAsString().equals("0000")) {
                        if (data2.size() > 0) {
                            JsonObject data1 = (JsonObject)data2.get(0);
                            code = data1.get("spdNo").getAsString();
                            return code;
                        }
                        throw new Exception(returnData.get("resultMessage").getAsString());
                    }
                    throw new Exception(returnData.get("resultMessage").getAsString());
                }
                String erMessage2 = result.get("message").getAsString();
                throw new Exception(erMessage2);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception("\ub86f\ub370\uc628 \uc0c1\ud488\ub4f1\ub85d \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e.getMessage());
        }
    }

    @Override
    public boolean deleteProduct(ShopProductDto shopProductDto) throws Exception {
        return false;
    }

    private String setProductStop(String status2, ShoppingMallDetailDto shoppingMallDetailDto, ShopProductDto dto, ShopLotteOnAdditionalDto lotteondtllist, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        String code = "";
        String cusNo = shoppingMallDetailDto.getAuthkey1();
        OkHttpClient client = new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        String json2 = "{\r\n  \"spdLst\": [\r\n    {\r\n       \"trGrpCd\": \"SR\",\r\n       \"trNo\": \"" + cusNo + "\", \r\n       \"lrtrNo\": \"\",\r\n       \"spdNo\": \"" + dto.getShopprodno() + "\",\r\n       \"slStatCd\":\"SOUT\"\r\n    }\r\n  ]\r\n}";
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json2);
        Request request2 = new Request.Builder().url(Host.concat("/v1/openapi/product/v1/product/status/change")).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build();
        try {
            Throwable throwable = null;
            Object var15_17 = null;
            try (Response response = client.newCall(request2).execute();){
                JsonParser parser = new JsonParser();
                JsonObject result = (JsonObject)parser.parse(response.body().string());
                if (result.get("returnCode").getAsString().equals("0000")) {
                    JsonArray data2 = (JsonArray)result.get("data");
                    JsonObject returnData = (JsonObject)data2.get(0);
                    if (returnData.get("resultCode").getAsString().equals("0000")) {
                        return code;
                    }
                    String erMessage2 = result.get("message").getAsString();
                    throw new Exception(erMessage2);
                }
                String erMessage2 = result.get("message").getAsString();
                throw new Exception(erMessage2);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new Exception("\ub86f\ub370\uc628 \uc0c1\ud488\uc0c1\ud0dc\ubcc0\uacbd \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4." + e.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean modifyProductStatusDto(ShopProductDto shopProductDto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, String status, ShopProductSendDto shopProductSendDto, Map<String, String> loginCookies) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[0, 8] lbl83 : CaseStatement: default:\u000a, @NONE, blocks:[0, 8] lbl83 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isExistProdNo(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        if (dto.getShopprodno() == null) return false;
        if (dto.getShopprodno().isEmpty()) {
            return false;
        }
        OkHttpClient client = new OkHttpClient().newBuilder().hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        String json = "{\"trGrpCd\": \"SR\",\r\n\"trNo\": \"" + shoppingMallDetailDto.getAuthkey1() + "\",\r\n\"lrtrNo\" : \"\",\r\n\"spdNo\" : \"" + dto.getShopprodno() + "\"\r\n}";
        String url = "/v1/openapi/product/v1/product/detail";
        MediaType mediaType = MediaType.parse((String)"application/json");
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
        Request request2 = new Request.Builder().url(Host.concat(url)).method("POST", body).addHeader("Content-Type", "application/json;").addHeader("Accept", "application/json").addHeader("X-Timezone", "GMT+09:00").addHeader("Accept-Language", "ko").addHeader("X-Agent-Authorization", "t86ur8pop2rb").addHeader("Authorization", "Bearer " + shoppingMallDetailDto.getApikey()).build();
        Throwable throwable = null;
        Object var11_12 = null;
        try (Response response = client.newCall(request2).execute();){
            JsonParser parser = new JsonParser();
            JsonObject result = (JsonObject)parser.parse(response.body().string());
            if (result.get("returnCode").getAsString().equals("0000")) {
                JsonObject data2 = (JsonObject)result.get("data");
                if (data2.size() <= 0) return false;
                String code = data2.get("spdNo").getAsString();
                if (code == null) throw new Exception("\uc0c1\ud488\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                if (!code.equals("")) return true;
                throw new Exception("\uc0c1\ud488\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            String erMessage2 = result.get("message").getAsString();
            throw new Exception(erMessage2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }
}

