/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.dao.ShopCategoryDto;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class NaverStoreCategoryAll {
    public static void getData(String id, String passwd, String authkey) throws Exception {
        YDMAStringUtil.Print("end");
    }

    public static List<ShopCategoryDto> getCategorySearch(Map<String, String> cookies, String cid) throws IOException {
        NaverCate[] naverCates;
        ArrayList<ShopCategoryDto> list = new ArrayList<ShopCategoryDto>();
        String url = String.format("https://sell.smartstore.naver.com/api/category-search/%s?_action=getChild&isValid=true ", cid);
        Connection.Response response = Jsoup.connect((String)url).cookies(cookies).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36").referrer("https://sell.smartstore.naver.com/").ignoreContentType(true).method(Connection.Method.GET).execute();
        String body = response.body();
        if (body.isEmpty()) {
            return list;
        }
        YDMAStringUtil.Print(body);
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        NaverCate[] naverCateArray = naverCates = (NaverCate[])mapper.readValue(body, NaverCate[].class);
        int n = naverCates.length;
        int n2 = 0;
        while (n2 < n) {
            NaverCate cate = naverCateArray[n2];
            ShopCategoryDto shopCateDto = new ShopCategoryDto();
            if (cate.level == 2) {
                shopCateDto.setCatmidcd(cate.id);
                shopCateDto.setCatmidnm(cate.name);
            }
            if (cate.level == 3) {
                shopCateDto.setCatsmacd(cate.id);
                shopCateDto.setCatsmanm(cate.name);
            }
            if (cate.level == 4) {
                shopCateDto.setCatdtlcd(cate.id);
                shopCateDto.setCatdtlnm(cate.name);
            }
            list.add(shopCateDto);
            ++n2;
        }
        return list;
    }

    private static class NaverCate {
        private String id;
        private String parentId;
        private String name;
        private Integer level;
        private Boolean deleted;
        private Boolean juvenileHarmful;
        private Boolean lastLevel;
        private Boolean sellBlogUse;
        private Integer sortOrder;
        private String wholeCategoryId;
        private String wholeCategoryName;

        private NaverCate() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }

        public Boolean getDeleted() {
            return this.deleted;
        }

        public void setDeleted(Boolean deleted) {
            this.deleted = deleted;
        }

        public Boolean getJuvenileHarmful() {
            return this.juvenileHarmful;
        }

        public void setJuvenileHarmful(Boolean juvenileHarmful) {
            this.juvenileHarmful = juvenileHarmful;
        }

        public Boolean getLastLevel() {
            return this.lastLevel;
        }

        public void setLastLevel(Boolean lastLevel) {
            this.lastLevel = lastLevel;
        }

        public Boolean getSellBlogUse() {
            return this.sellBlogUse;
        }

        public void setSellBlogUse(Boolean sellBlogUse) {
            this.sellBlogUse = sellBlogUse;
        }

        public Integer getSortOrder() {
            return this.sortOrder;
        }

        public void setSortOrder(Integer sortOrder) {
            this.sortOrder = sortOrder;
        }

        public String getWholeCategoryId() {
            return this.wholeCategoryId;
        }

        public void setWholeCategoryId(String wholeCategoryId) {
            this.wholeCategoryId = wholeCategoryId;
        }

        public String getWholeCategoryName() {
            return this.wholeCategoryName;
        }

        public void setWholeCategoryName(String wholeCategoryName) {
            this.wholeCategoryName = wholeCategoryName;
        }

        public String getParentId() {
            return this.parentId;
        }

        public void setParentId(String parentId) {
            this.parentId = parentId;
        }

        public String toString() {
            return "NaverCate [id=" + this.id + ", name=" + this.name + ", level=" + String.valueOf(this.level) + ", deleted=" + String.valueOf(this.deleted) + ", juvenileHarmful=" + String.valueOf(this.juvenileHarmful) + ", lastLevel=" + String.valueOf(this.lastLevel) + ", sellBlogUse=" + String.valueOf(this.sellBlogUse) + ", sortOrder=" + String.valueOf(this.sortOrder) + ", wholeCategoryId=" + this.wholeCategoryId + ", wholeCategoryName=" + this.wholeCategoryName + "]";
        }
    }

    private static class NaverCates {
        List<NaverCate> cate;

        private NaverCates() {
        }

        public List<NaverCate> getCate() {
            return this.cate;
        }

        public void setCate(List<NaverCate> cate) {
            this.cate = cate;
        }
    }
}

