/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.naverstore.IShopOrderNaverStoreCommand;
import com.kdjsystem.mlink.shop.data.naverstore.NaverStoreGenerateSignature;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class NaverStoreOrderSearchCommand
extends IShopOrderNaverStoreCommand {
    private static IShopOrderCommand instance = new NaverStoreOrderSearchCommand();
    private final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
    JsonParser parser = new JsonParser();
    ObjectMapper mapper = new ObjectMapper();
    private String merchantNo = "";

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private NaverStoreOrderSearchCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        ShopOrderMstDto dto = param.get(0);
        try {
            if (dto.getVendorId().equals("N")) {
                Map<String, String> cookies = super.getCookies(dto);
                String start = YDMATimeUtil.getTime(dto.getStartDt());
                String end = YDMATimeUtil.getTime(dto.getEndDt());
                this.orderCancel(param, ret, cookies, start, end);
                this.orderReturnList(param, ret, cookies, start, end);
                this.orderExChange(param, ret, cookies, start, end);
                this.orderdelvCompleted(param, ret, cookies);
                this.orderPurchaseDecision(param, ret, cookies, start, end);
            } else {
                NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
                String startdt = dto.getStartDt().substring(0, 8);
                String enddt = dto.getEndDt().substring(0, 8);
                SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
                Date sdate = formatter.parse(startdt);
                Date edate = formatter.parse(enddt);
                long range = Math.abs((edate.getTime() - sdate.getTime()) / 86400000L) + 1L;
                Calendar cal1 = Calendar.getInstance();
                cal1.setTime(sdate);
                String clientId = dto.getEDITAUTHKEY1();
                String clientSecret = dto.getEDITAPIKEY();
                Long timestamp = System.currentTimeMillis();
                String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret, timestamp);
                String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
                int i = 0;
                while (i < (int)range) {
                    this.orderCancelApi(param, ret, accessToken, sdate);
                    this.orderReturnListApi(param, ret, accessToken, sdate);
                    this.orderExChangeApi(param, ret, accessToken, sdate);
                    this.delvCompletedApi(param, ret, accessToken, sdate);
                    cal1.add(5, 1);
                    startdt = formatter.format(cal1.getTime());
                    sdate = formatter.parse(startdt);
                    ++i;
                }
            }
        }
        catch (Exception exception) {}
        return ret;
    }

    private void orderdelvCompleted(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies) throws Exception {
        String DeliveryComplted = this.getDeliveryCompltedOrderStringParam(this.merchantNo);
        String body = this.postSmartStoreGraphQL(cookies, DeliveryComplted).body();
        JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
        JsonObject obj1 = jsonobject.get("data").getAsJsonObject();
        JsonObject obj2 = obj1.get("deliveryStatusListMp").getAsJsonObject();
        JsonArray jsonArray = obj2.get("elements").getAsJsonArray();
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = jsonArray.get(i).getAsJsonObject();
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("productNo").getAsString();
                String expid = object.get("productOrderNo").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setResult_code("1");
                    dto.setOrder_status("410");
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderPurchaseDecision(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        String PurchaseDecision = this.getPurchaseDecisionOrderStringParam(this.merchantNo, start, end);
        String body = this.postSmartStoreGraphQL(cookies, PurchaseDecision).body();
        JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
        JsonObject obj1 = jsonobject.get("data").getAsJsonObject();
        JsonObject obj2 = obj1.get("purchaseDecisionList").getAsJsonObject();
        JsonArray jsonArray = obj2.get("elements").getAsJsonArray();
        if (jsonArray.size() > 0) {
            int i = 0;
            while (i < jsonArray.size()) {
                JsonObject object = jsonArray.get(i).getAsJsonObject();
                String orderid = object.get("orderNo").getAsString();
                String mallid = object.get("productNo").getAsString();
                String expid = object.get("productOrderNo").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setResult_code("1");
                    dto.setOrder_status("410");
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderCancel(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        this.merchantNo = super.getMerchantNo(cookies);
        int k = 0;
        while (k < 2) {
            String status2 = this.getStatusCancel(k);
            String strParam = this.getCancelOrderStringParam(this.merchantNo, status2);
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
            JsonObject obj1 = jsonobject.get("data").getAsJsonObject();
            JsonObject obj2 = obj1.get("cancelListMp").getAsJsonObject();
            JsonArray jsonArray = obj2.get("elements").getAsJsonArray();
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = (JsonObject)jsonArray.get(i);
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status(this.getStatusCancel(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("C02")) {
                            ShopOrderMstDto temp = dto.clone("C02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("claimRequestAdmissionDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception exception) {}
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private void orderReturnList(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        int k = 0;
        while (k < 4) {
            String status2 = this.getStatusReturn(k);
            String strParam = this.getReturnOrderStringParam(this.merchantNo, status2);
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
            JsonObject obj1 = jsonobject.get("data").getAsJsonObject();
            JsonObject obj2 = obj1.get("returnList").getAsJsonObject();
            JsonArray jsonArray = obj2.get("elements").getAsJsonArray();
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = jsonArray.get(i).getAsJsonObject();
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status(this.getStatusReturn(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("R02")) {
                            ShopOrderMstDto temp = dto.clone("R02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("refundDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception exception) {}
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    private String getStatusCancel(String status2) {
        String value = "";
        switch (status2) {
            case "CANCEL_REJECT": 
            case "CANCELING": 
            case "CANCEL_REQUEST": {
                value = "C01";
                break;
            }
            case "ADMIN_CANCEL_DONE": 
            case "CANCEL_DONE": {
                value = "C02";
            }
        }
        return value;
    }

    private String getStatusCancel(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "CANCEL_REQUEST";
                break;
            }
            case 1: {
                value = "CANCEL_DONE";
            }
        }
        return value;
    }

    private String getStatusReturn(String asString) {
        String value = "";
        switch (asString) {
            case "COLLECTING": 
            case "RETURN_REJECT": 
            case "COLLECT_DONE": 
            case "RETURN_REQUEST": {
                value = "R01";
                break;
            }
            case "RETURN_DONE": {
                value = "R02";
            }
        }
        return value;
    }

    private String getStatusReturn(int k) {
        String value = "";
        switch (k) {
            case 0: {
                value = "RETURN_REQUEST";
                break;
            }
            case 1: {
                value = "RETURN_COLLECTING";
                break;
            }
            case 2: {
                value = "RETURN_COLLECT_DONE";
                break;
            }
            case 3: {
                value = "RETURN_DONE";
            }
        }
        return value;
    }

    private void orderExChange(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, Map<String, String> cookies, String start, String end) throws Exception {
        int k = 0;
        while (k < 4) {
            String status2 = this.getStatus(k);
            String strParam = this.getExchangeOrderStringParam(this.merchantNo, status2);
            String body = this.postSmartStoreGraphQL(cookies, strParam).body();
            JsonObject jsonobject = this.parser.parse(body).getAsJsonObject();
            JsonObject obj1 = jsonobject.get("data").getAsJsonObject();
            JsonObject obj2 = obj1.get("exchangeList").getAsJsonObject();
            JsonArray jsonArray = obj2.get("elements").getAsJsonArray();
            if (jsonArray.size() > 0) {
                int i = 0;
                while (i < jsonArray.size()) {
                    JsonObject object = jsonArray.get(i).getAsJsonObject();
                    String orderid = object.get("orderNo").getAsString();
                    String mallid = object.get("productNo").getAsString();
                    String expid = object.get("productOrderNo").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setOrder_status(this.getStatusexChange(object.get("claimStatus").getAsString()));
                        dto.setResult_code("1");
                        if (dto.getOrder_status().equals("E02")) {
                            ShopOrderMstDto temp = dto.clone("E02");
                            try {
                                String orddt = YDMATimeUtil.getDate(object.get("redeliveryOperationDateTime").getAsString());
                                temp.setOrder_date(orddt);
                            }
                            catch (Exception exception) {}
                            ret.add(temp);
                        }
                        ret.add(dto);
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    @Override
    public String jsonElementNullStr(JsonElement val) {
        if (val.isJsonNull()) {
            return "";
        }
        return val.getAsString();
    }

    private String getStatus(int i) {
        String value = "";
        switch (i) {
            case 0: {
                value = "EXCHANGE_REQUEST";
                break;
            }
            case 1: {
                value = "EXCHANGE_COLLECTING";
                break;
            }
            case 2: {
                value = "EXCHANGE_COLLECT_DONE";
                break;
            }
            case 3: {
                value = "EXCHANGE_DONE";
            }
        }
        return value;
    }

    private String getStatusexChange(String string) {
        String value = "";
        switch (string) {
            case "COLLECTING": 
            case "EXCHANGE_REQUEST": 
            case "COLLECT_DONE": 
            case "EXCHANGE_REJECT": {
                value = "E01";
                break;
            }
            case "EXCHANGE_REDELIVERING": 
            case "EXCHANGE_DONE": {
                value = "E02";
            }
        }
        return value;
    }

    private void orderCancelApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate) throws Exception {
        JsonObject object;
        Response response;
        Object var13_16;
        Throwable throwable;
        Request request2;
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                throwable = null;
                var13_16 = null;
                try {
                    response = this.client.newCall(request2).execute();
                    try {
                        if (response.isSuccessful() && (object = this.parser.parse(response.body().string()).getAsJsonObject()).get("data") != null) {
                            JsonObject jsonObject = object.get("data").getAsJsonObject();
                            JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                            for (JsonElement data2 : datas) {
                                JsonObject jsonObject2 = data2.getAsJsonObject();
                                if (!jsonObject2.get("claimType").getAsString().equals("CANCEL")) continue;
                                orderId.add(jsonObject2.get("productOrderId").getAsString());
                            }
                        }
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++j;
            }
        }
        catch (Exception exception) {}
        if (orderId.size() != 0) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
            request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            throwable = null;
            var13_16 = null;
            try {
                response = this.client.newCall(request2).execute();
                try {
                    object = (JsonObject)this.parser.parse(response.body().string());
                    elements = object.get("data").getAsJsonArray();
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object2 = (JsonObject)elements.get(i);
                JsonObject order = object2.get("order").getAsJsonObject();
                JsonObject productOrder = object2.get("productOrder").getAsJsonObject();
                JsonObject cancel = object2.get("cancel").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setOrder_status(this.getStatusCancel(cancel.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("C02")) {
                        ShopOrderMstDto temp = dto.clone("C02");
                        try {
                            String orddt = cancel.get("cancelCompletedDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception exception) {}
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderReturnListApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate) throws Exception {
        JsonObject object;
        Response response;
        Object var13_16;
        Throwable throwable;
        Request request2;
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                throwable = null;
                var13_16 = null;
                try {
                    response = this.client.newCall(request2).execute();
                    try {
                        object = (JsonObject)this.parser.parse(response.body().string());
                        if (object.get("data") != null) {
                            JsonObject jsonObject = object.get("data").getAsJsonObject();
                            JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                            for (JsonElement data2 : datas) {
                                JsonObject jsonObject2 = data2.getAsJsonObject();
                                if (!jsonObject2.get("claimType").getAsString().equals("RETURN")) continue;
                                orderId.add(jsonObject2.get("productOrderId").getAsString());
                            }
                        }
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++j;
            }
        }
        catch (Exception exception) {}
        if (orderId.size() != 0) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
            request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            throwable = null;
            var13_16 = null;
            try {
                response = this.client.newCall(request2).execute();
                try {
                    object = (JsonObject)this.parser.parse(response.body().string());
                    elements = object.get("data").getAsJsonArray();
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object2 = (JsonObject)elements.get(i);
                JsonObject order = object2.get("order").getAsJsonObject();
                JsonObject productOrder = object2.get("productOrder").getAsJsonObject();
                JsonObject returns = object2.get("return").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setOrder_status(this.getStatusReturn(returns.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("R02")) {
                        ShopOrderMstDto temp = dto.clone("R02");
                        try {
                            String orddt = returns.get("returnCompletedDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception exception) {}
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void orderExChangeApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate) throws Exception {
        JsonObject object;
        Response response;
        Object var13_16;
        Throwable throwable;
        Request request2;
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        String[] status2 = new String[]{"CLAIM_REQUESTED", "CLAIM_COMPLETED"};
        JsonArray elements = new JsonArray();
        try {
            int j = 0;
            while (j < 2) {
                request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z&lastChangedType=" + status2[j]).get().addHeader("Authorization", accessToken).build();
                Thread.sleep(450L);
                throwable = null;
                var13_16 = null;
                try {
                    response = this.client.newCall(request2).execute();
                    try {
                        object = (JsonObject)this.parser.parse(response.body().string());
                        if (object.get("data") != null) {
                            JsonObject jsonObject = object.get("data").getAsJsonObject();
                            JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                            for (JsonElement data2 : datas) {
                                JsonObject jsonObject2 = data2.getAsJsonObject();
                                if (!jsonObject2.get("claimType").getAsString().equals("EXCHANGE")) continue;
                                orderId.add(jsonObject2.get("productOrderId").getAsString());
                            }
                        }
                    }
                    finally {
                        if (response != null) {
                            response.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ++j;
            }
        }
        catch (Exception exception) {}
        if (orderId.size() != 0) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
            request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            throwable = null;
            var13_16 = null;
            try {
                response = this.client.newCall(request2).execute();
                try {
                    object = (JsonObject)this.parser.parse(response.body().string());
                    elements = object.get("data").getAsJsonArray();
                }
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object2 = (JsonObject)elements.get(i);
                JsonObject order = object2.get("order").getAsJsonObject();
                JsonObject productOrder = object2.get("productOrder").getAsJsonObject();
                JsonObject exchange = object2.get("exchange").getAsJsonObject();
                String orderid = order.get("orderId").getAsString();
                String mallid = productOrder.get("productId").getAsString();
                String expid = productOrder.get("productOrderId").getAsString();
                for (ShopOrderMstDto dto : param) {
                    if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                    dto.setOrder_status(this.getStatusexChange(exchange.get("claimStatus").getAsString()));
                    dto.setResult_code("1");
                    if (dto.getOrder_status().equals("E02")) {
                        dto.setOrder_status("E02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("E02");
                        try {
                            String orddt = exchange.get("reDeliveryOperationDate").getAsString().substring(0, 19).replace("T", " ");
                            temp.setOrder_date(orddt);
                        }
                        catch (Exception exception) {}
                        ret.add(temp);
                    }
                    ret.add(dto);
                }
                ++i;
            }
        }
    }

    private void delvCompletedApi(List<ShopOrderMstDto> param, List<ShopOrderMstDto> ret, String accessToken, Date sdate) throws Exception {
        Response response22;
        Throwable throwable;
        String datePattern5 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
        SimpleDateFormat format5 = new SimpleDateFormat(datePattern5);
        ArrayList<String> orderId = new ArrayList<String>();
        JsonArray elements = new JsonArray();
        try {
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/last-changed-statuses?lastChangedFrom=" + format5.format(sdate) + "Z").get().addHeader("Authorization", accessToken).build();
            Thread.sleep(450L);
            Throwable throwable2 = null;
            throwable = null;
            try {
                response22 = this.client.newCall(request2).execute();
                try {
                    JsonObject object = (JsonObject)this.parser.parse(response22.body().string());
                    if (object.get("data") != null) {
                        JsonObject jsonObject = object.get("data").getAsJsonObject();
                        JsonArray datas = jsonObject.get("lastChangeStatuses").getAsJsonArray();
                        for (JsonElement data2 : datas) {
                            JsonObject jsonObject2 = data2.getAsJsonObject();
                            if (!jsonObject2.get("productOrderStatus").getAsString().equals("DELIVERED") && !jsonObject2.get("productOrderStatus").getAsString().equals("PURCHASE_DECIDED") && !jsonObject2.get("productOrderStatus").getAsString().equals("DELIVERING")) continue;
                            orderId.add(jsonObject2.get("productOrderId").getAsString());
                        }
                    }
                }
                finally {
                    if (response22 != null) {
                        response22.close();
                    }
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Exception exception) {}
        if (orderId.size() != 0) {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)("{\"productOrderIds\":" + String.valueOf(orderId) + "}"));
            Request request3 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/pay-order/seller/product-orders/query").post(body).addHeader("Authorization", accessToken).addHeader("content-type", "application/json").build();
            throwable = null;
            response22 = null;
            try (Response response = this.client.newCall(request3).execute();){
                JsonObject object = (JsonObject)this.parser.parse(response.body().string());
                elements = object.get("data").getAsJsonArray();
            }
            catch (Throwable response22) {
                if (throwable == null) {
                    throwable = response22;
                } else if (throwable != response22) {
                    throwable.addSuppressed(response22);
                }
                throw throwable;
            }
        }
        if (elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                JsonObject object = (JsonObject)elements.get(i);
                JsonObject delivery = object.get("delivery").getAsJsonObject();
                String delComplted = "";
                if (delivery.get("deliveryStatus") != null) {
                    delComplted = delivery.get("deliveryStatus").getAsString();
                }
                if (delComplted.equals("DELIVERY_COMPLETION")) {
                    JsonObject order = object.get("order").getAsJsonObject();
                    JsonObject productOrder = object.get("productOrder").getAsJsonObject();
                    String orderid = order.get("orderId").getAsString();
                    String mallid = productOrder.get("productId").getAsString();
                    String expid = productOrder.get("productOrderId").getAsString();
                    for (ShopOrderMstDto dto : param) {
                        if (!this.orderCheck(dto, orderid, mallid, expid)) continue;
                        dto.setResult_code("1");
                        dto.setOrder_status("410");
                        ret.add(dto);
                    }
                }
                ++i;
            }
        }
    }

    private String getDeliveryCompltedOrderStringParam(String merchantNo) throws Exception {
        SyncOrder deliveryComplted = new SyncOrder();
        deliveryComplted.operationName = "SmartStoreFindDeliveryStatusesBySummaryInfoType_ForSaleDeliveryStatus";
        deliveryComplted.variables.summaryInfoType = "DELIVERED";
        deliveryComplted.variables.merchantNo = merchantNo;
        deliveryComplted.variables.pagingPage = 1;
        deliveryComplted.variables.pagingSize = 100;
        deliveryComplted.variables.serviceType = "MP";
        String[] sellerSearchType = new String[]{"NORMAL_ORDER", "GIFTING", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL", "ARRIVAL_GUARANTEE"};
        deliveryComplted.variables.sellerOrderSearchTypes = sellerSearchType;
        deliveryComplted.query = super.getDeliveryGraphqlQuery();
        return this.mapper.writeValueAsString((Object)deliveryComplted);
    }

    private String getPurchaseDecisionOrderStringParam(String merchantNo, String startDate, String endDate) throws Exception {
        DeliveryCompleted deliveryComplted = new DeliveryCompleted();
        deliveryComplted.operationName = "SmartStoreFindPurchaseDecisionsByDetailConditions_ForPurchaseDecision";
        deliveryComplted.variables.dateRangeFrom = startDate;
        deliveryComplted.variables.dateRangeTo = endDate;
        deliveryComplted.variables.merchantNo = merchantNo;
        deliveryComplted.variables.pagingPage = 1;
        deliveryComplted.variables.pagingSize = 100;
        deliveryComplted.variables.rangeType = "PURCHASE_DECISION_COMPLETED";
        deliveryComplted.variables.serviceType = "MP";
        deliveryComplted.variables.sortDirection = "DESC";
        deliveryComplted.variables.sortType = "PRODUCT_ORDER_PURCHASE_DECISION_COMPLETE_OPERATION_YMDT";
        deliveryComplted.query = super.getPurchaseDecisionGraphqlQuery();
        return this.mapper.writeValueAsString((Object)deliveryComplted);
    }

    private String getCancelOrderStringParam(String merchantNo, String status2) throws Exception {
        SyncOrder cancelOrder = new SyncOrder();
        cancelOrder.operationName = "findClaimCancelsBySummaryInfoTypeMp_ForClaimCancel";
        cancelOrder.variables.merchantNo = merchantNo;
        cancelOrder.variables.serviceType = "MP";
        cancelOrder.variables.pagingPage = 1;
        cancelOrder.variables.pagingSize = 100;
        cancelOrder.variables.summaryInfoType = status2;
        String[] sellerOrderSearchTypes = new String[]{"NORMAL_ORDER", "GIFTING", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL", "ARRIVAL_GUARANTEE"};
        cancelOrder.variables.sellerOrderSearchTypes = sellerOrderSearchTypes;
        cancelOrder.query = super.getCancelGraphqlQuery();
        return this.mapper.writeValueAsString((Object)cancelOrder);
    }

    private String getReturnOrderStringParam(String merchantNo, String status2) throws Exception {
        SyncOrder returnOrder = new SyncOrder();
        returnOrder.operationName = "findClaimReturnsBySummaryInfoTypeMp_ForClaimReturn";
        returnOrder.variables.merchantNo = merchantNo;
        returnOrder.variables.serviceType = "MP";
        returnOrder.variables.pagingPage = 1;
        returnOrder.variables.pagingSize = 100;
        returnOrder.variables.summaryInfoType = status2;
        String[] sellerOrderSearchTypes = new String[]{"NORMAL_ORDER", "GIFTING", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL", "ARRIVAL_GUARANTEE"};
        returnOrder.variables.sellerOrderSearchTypes = sellerOrderSearchTypes;
        returnOrder.query = super.getReturnGraphqlQuery();
        return this.mapper.writeValueAsString((Object)returnOrder);
    }

    private String getExchangeOrderStringParam(String merchantNo, String status2) throws Exception {
        SyncOrder exchangeOrder = new SyncOrder();
        exchangeOrder.operationName = "SmartStoreFindClaimExchangesBySummaryInfoType_ForClaimExchange";
        exchangeOrder.variables.merchantNo = merchantNo;
        exchangeOrder.variables.serviceType = "MP";
        exchangeOrder.variables.pagingPage = 1;
        exchangeOrder.variables.pagingSize = 100;
        exchangeOrder.variables.summaryInfoType = status2;
        String[] sellerOrderSearchTypes = new String[]{"NORMAL_ORDER", "GIFTING", "TODAY_DISPATCH", "PRE_ORDER", "SUBSCRIPTION", "RENTAL", "ARRIVAL_GUARANTEE"};
        exchangeOrder.variables.sellerOrderSearchTypes = sellerOrderSearchTypes;
        exchangeOrder.query = super.getExchangeGraphqlQuery();
        return this.mapper.writeValueAsString((Object)exchangeOrder);
    }

    private boolean orderCheck(ShopOrderMstDto dto, String orderid, String mallid, String expid) {
        return dto.getOrder_id().equals(orderid) && dto.getMall_product_id().substring(dto.getMall_product_id().lastIndexOf(",") + 1).equals(mallid) && dto.getMall_exp_cd().equals(expid);
    }

    private class DeliveryCompleted {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="dateRange_from")
            private String dateRangeFrom;
            @JsonProperty(value="dateRange_to")
            private String dateRangeTo;
            @JsonProperty(value="detailedOrderStatus")
            private String detailedOrderStatus;
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="orderStatus")
            private String orderStatus;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="rangeType")
            private String rangeType;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="sort_type")
            private String sortType;

            private Variables() {
            }
        }
    }

    private class SyncOrder {
        @JsonProperty(value="operationName")
        private String operationName;
        @JsonProperty(value="variables")
        private Variables variables = new Variables();
        @JsonProperty(value="query")
        private String query;

        private class Variables {
            @JsonProperty(value="merchantNo")
            private String merchantNo;
            @JsonProperty(value="serviceType")
            private String serviceType;
            @JsonProperty(value="paging_page")
            private int pagingPage;
            @JsonProperty(value="paging_size")
            private int pagingSize;
            @JsonProperty(value="sort_type")
            private String sortType;
            @JsonProperty(value="sort_direction")
            private String sortDirection;
            @JsonProperty(value="summaryInfoType")
            public String summaryInfoType;
            @JsonProperty(value="sellerOrderSearchTypes")
            public String[] sellerOrderSearchTypes;

            private Variables() {
            }
        }
    }
}

