/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.naverstore;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jogamp.common.util.InterruptSource;
import com.kdjsystem.mlink.shop.common.ChromeExtention;
import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProdAttrnmDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductNaverStoreAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.dao.WorkMngDetailDto;
import com.kdjsystem.mlink.shop.data.naverstore.NaverStoreGenerateSignature;
import com.kdjsystem.mlink.tot.common.YDMASessonUtil;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.ShopAddProdInfoDto;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.chrome.ChromeDriver;

public class NaverStoreProductRegService
implements IProduct,
IShopCommonLogin {
    final String userAgent = "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36";
    List<String> imageDelete = new ArrayList<String>();
    static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).build();
    List<ShopOptionDto> options = null;

    private void productRegSend(String json, Map<String, String> loginCookie, ShopProductDto dto) throws Exception {
        try {
            Connection.Response rs = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/products").cookies(loginCookie).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").header("Host", "sell.smartstore.naver.com").header("Connection", "keep-alive").header("x-to-stateName", "main.product.create").header("Content-Type", "application/json;charset=UTF-8").header("Origin", "https://sell.smartstore.naver.com").header("Pragma", "no-cache").header("Cache-Control", "no-cache").header("x-current-stateName", "main.product.create").header("x-current-state", "https://sell.smartstore.naver.com/#/products/create").header("Sec-Fetch-Site", "same-origin").header("Sec-Fetch-Mode", "cors").header("Sec-Fetch-Dest", "empty").requestBody(json).referrer("https://sell.smartstore.naver.com/").method(Connection.Method.POST).timeout(15000).ignoreContentType(true).followRedirects(true).ignoreHttpErrors(true).execute();
            String body = rs.body();
            JsonParser parser = new JsonParser();
            JsonObject jsonObject = parser.parse(body).getAsJsonObject();
            if (rs.statusCode() == 200) {
                if (jsonObject.has("productId")) {
                    String prodNo = jsonObject.get("productId").getAsString();
                    dto.setShopprodno(prodNo);
                    dto.setResult_code("1");
                } else {
                    dto.setResult_code("-1");
                    dto.setResult_text("\uc0c1\ud488 \ub4f1\ub85d \uc911 productID \uc5c6\uc74c");
                }
            } else {
                dto.setResult_code("-1");
                if (body.contains("BAD_REQUEST")) {
                    String errorMessage = "";
                    if (jsonObject.has("invalidInputs") && jsonObject.get("invalidInputs").isJsonArray()) {
                        JsonArray invalidInputs = jsonObject.getAsJsonArray("invalidInputs");
                        if (invalidInputs.size() > 0 && invalidInputs.get(0).isJsonObject()) {
                            JsonObject invalidInput = invalidInputs.get(0).getAsJsonObject();
                            errorMessage = this.setErrorMessage(invalidInput.get("message").getAsString());
                        } else {
                            errorMessage = "\uc720\ud6a8\ud558\uc9c0 \uc54a\uc740 \uc785\ub825 \ud56d\ubaa9\uc774 \uc788\uc2b5\ub2c8\ub2e4.";
                        }
                    } else {
                        errorMessage = jsonObject.has("message") ? this.setErrorMessage(jsonObject.get("message").getAsString()) : "\uc54c \uc218 \uc5c6\ub294 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.";
                    }
                    dto.setResult_text(errorMessage);
                } else {
                    dto.setResult_text("\uc0c1\ud488 \ub4f1\ub85d \uc911 \uc5d0\ub7ec\ubc1c\uc0dd \uc0c1\ud0dc\ucf54\ub4dc: [" + rs.statusCode() + "]");
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    private String setErrorMessage(String error) {
        Object errorMessage = "";
        errorMessage = error.contains("\uc785\ub825\ud560 \uc218 \uc5c6\ub294 \ubb38\uc790") || error.contains("\uc0c1\ud488\uba85 \ud56d\ubaa9\uc5d0 \ub4f1\ub85d\ubd88\uac00\uc778 \ud2b9\uc218\ubb38\uc790") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488\uba85 \ud574\ub2f9 \ud2b9\uc218\ubb38\uc790 \uc785\ub825\ubd88\uac00] " + error : (error.contains("\ud310\ub9e4\uc790\uc785\ub825\ud0dc\uadf8 \ud56d\ubaa9\uc5d0 \ud5c8\uc6a9 \ub418\uc9c0 \uc54a\ub294 \ubb38\uc790") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\ud574\ub2f9 \ud0a4\uc6cc\ub4dc \uc785\ub825\ubd88\uac00] " + error : (error.contains("\uc874\uc7ac\ud558\uc9c0 \uc54a\ub294 \uce74\ud14c\uace0\ub9ac \ud56d\ubaa9") || error.contains("\uce74\ud14c\uace0\ub9ac \ub4f1\ub85d \uad8c\ud55c") ? "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : [\uc0c1\ud488 \uce74\ud14c\uace0\ub9ac \uac12 \ubd88\uc77c\uce58 \ubc0f \uc5c6\uc74c] " + error : "\uc0c1\ud488\ub4f1\ub85d\uc2e4\ud328 : " + error));
        return errorMessage;
    }

    private String setProductReg(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> loginCookie, List<String> strImages) throws Exception {
        String json = "";
        JsonParser parser = new JsonParser();
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            String auth;
            String str_info = this.InfoBase(loginCookie);
            JsonObject info = (JsonObject)parser.parse(str_info);
            ResultMarketPrice resultMarketPrice = this.resultMarketPriceSetting(dto, dtllist);
            ProductJSONCreate productJSONCreate = new ProductJSONCreate();
            Product productReg = productJSONCreate.getProduct();
            productReg.saleType = dtllist.getProdstats().equals("02") ? "OLD" : "NEW";
            productReg.excludeAdminDiscount = false;
            productReg.excludeGivePresent = false;
            productReg.payExposure = true;
            String clientId = shoppingMallDetailDto.getEditauthkey1();
            String clientSecret = shoppingMallDetailDto.getEditapikey();
            if ("".equals(clientId) || "".equals(clientSecret)) {
                this.setImage(loginCookie, strImages, productReg, dtllist, shoppingMallDetailDto);
            } else {
                this.setImageApi(clientId, clientSecret, strImages, productReg);
            }
            this.setOriginArea(dto, dtllist, productReg);
            this.setTag(dto, dtllist, productReg, loginCookie, shoppingMallDetailDto);
            int stockqty = 0;
            stockqty = this.setOption(dto, dtllist, resultMarketPrice, productReg, stockqty);
            this.setAddProduct(productReg, dto);
            this.setTax(dto, dtllist, productReg);
            this.setProductNotice(dto, dtllist, productReg);
            this.setProductCerificationAndRemark(dto, dtllist, productReg);
            JsonObject deliveryInfo = null;
            try {
                deliveryInfo = info.get("product").getAsJsonObject().get("deliveryInfo").getAsJsonObject();
            }
            catch (Exception exception) {}
            this.setDeliveryInfo(dto, dtllist, productReg, deliveryInfo);
            NaverProductCate navercate = this.getNaverCategory(dto.getShopCid(), loginCookie, dtllist);
            this.setDiscountInfo(dtllist, productReg, navercate);
            productReg.representImageUrl = "";
            productReg.useSalePeriod = false;
            this.setBookCate(navercate, productReg);
            this.setProdName(dto, dtllist, resultMarketPrice, productReg, stockqty);
            JsonObject simpleAccountInfo = info.get("simpleAccountInfo").getAsJsonObject();
            try {
                auth = simpleAccountInfo.get("productRegistAuthCategories").getAsJsonArray().get(0).getAsString();
            }
            catch (Exception exception) {
                auth = "";
            }
            this.setProductBasicInfo(productJSONCreate, simpleAccountInfo, auth);
            JsonObject ownerChannelInfoList = simpleAccountInfo.get("ownerChannelInfoList").getAsJsonArray().get(0).getAsJsonObject();
            this.setCompanyInfo2(productJSONCreate, simpleAccountInfo, auth, ownerChannelInfoList);
            JsonObject creatableChannelInfoListMap = simpleAccountInfo.get("creatableChannelInfoListMap").getAsJsonObject().get("STOREFARM").getAsJsonArray().get(0).getAsJsonObject();
            SingleChannelProductMap singleChannelProductMap = productJSONCreate.getSingleChannelProductMap();
            this.setSelProductNameUsable(dtllist, navercate, creatableChannelInfoListMap, singleChannelProductMap, simpleAccountInfo);
            this.setCompanyInfo(productJSONCreate, simpleAccountInfo, auth, creatableChannelInfoListMap, singleChannelProductMap, dtllist, dto);
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)productJSONCreate);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return json;
    }

    private void setBookCate(NaverProductCate navercate, Product productReg) throws Exception {
        try {
            if (navercate != null) {
                if (navercate.wholeCategoryName.contains("\ub3c4\uc11c")) {
                    productReg.detailAttribute.setisbnInfo(true);
                    productReg.setCategory().setId(navercate.id).setName(navercate.name).setWholeCategoryId(navercate.wholeCategoryId).setWholeCategoryName(navercate.wholeCategoryName).setLevel(navercate.level).setLastLevel(navercate.lastLevel).setDeleted(navercate.deleted).setSellBlogUse(navercate.sellBlogUse).setSortOrder(navercate.sortOrder).setJuvenileHarmful(navercate.juvenileHarmful).set$order(11).set$resolved(true).setParentId(navercate.parentId).setExceptionalCategoryTypes("BOOK");
                } else {
                    productReg.setCategory().setId(navercate.id).setName(navercate.name).setWholeCategoryId(navercate.wholeCategoryId).setWholeCategoryName(navercate.wholeCategoryName).setLevel(navercate.level).setLastLevel(navercate.lastLevel).setDeleted(navercate.deleted).setSellBlogUse(navercate.sellBlogUse).setSortOrder(navercate.sortOrder).setJuvenileHarmful(navercate.juvenileHarmful).set$order(11).set$resolved(true).setParentId(navercate.parentId);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ub3c4\uc11c\uad00\ub828 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setProductCerificationAndRemark(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, Product productReg) throws Exception {
        try {
            productReg.detailAttribute.setCertificationTargetExcludeContent("TRUE", true);
            productReg.detailAttribute.useReturnCancelNotification = false;
            Object remark = "";
            Object addDetailPlus = "";
            String body = dtllist.getProdinfotop().concat(dto.getGoods_remarks()).replace("&#39;", "");
            remark = dtllist.getProddetailendoutput().equals("01") ? body.concat(dtllist.getProdinfobottom()).replace("&#39;", "") : body;
            if (dtllist.getRemarktop().equals("Y")) {
                remark = "<h2 style='font-size:16px;font-weight: bold;font-family: Dotum;text-align: center;'>\uc0c1\ud488\uba85 : " + dto.getGoods_nm() + "</h2>".concat((String)remark).replace("&#39;", "");
            }
            if (dtllist.getDetailkeywordb().equals("Y")) {
                addDetailPlus = dtllist.getDetailKeywordL() + dto.getGoods_search().replace(",", " ") + dtllist.getDetailKeywordR();
            }
            if (dtllist.getDetailproductcodeb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProductCodeL() + dto.getCompayny_goods_cd() + dtllist.getDetailProductCodeR();
            }
            if (dtllist.getDetailproductnameb().equals("Y")) {
                addDetailPlus = (String)addDetailPlus + dtllist.getDetailProdcutNameL() + dto.getGoods_nm() + dtllist.getDetailProdcutNameR();
            }
            productReg.setDetailContent("NONE", "SEONE", false, (String)addDetailPlus + (String)remark);
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\uc138\uc124\uba85, \uc778\uc99d\uc5ec\ubd80 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private ResultMarketPrice resultMarketPriceSetting(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist) throws Exception {
        ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
        try {
            Long salePrice = YDMAStringUtil.convertToLong(dto.getGoods_cost());
            String deliveryFee = "";
            if (dtllist.getFreedelivery().equals("T")) {
                if (dtllist.getExpprc() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryFee = dto.getDelv_cost();
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryFee = systemconf.getDeliverycost();
                    }
                } else {
                    deliveryFee = String.valueOf(dtllist.getExpprc());
                }
                salePrice = salePrice + (long)Integer.parseInt(deliveryFee);
            }
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            if (salePrice > YDMAStringUtil.convertToLong(resultMarketPrice.getConsumer_if_sale_price())) {
                resultMarketPrice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price, salePrice);
            }
            dto.setGoods_price(resultMarketPrice.getTotal_sale_discount());
            dto.setMarket_price(resultMarketPrice.getTotal_sale_discount());
            dto.setGoods_consumer_price(resultMarketPrice.getTotal_sale_discount());
        }
        catch (Exception e) {
            throw new Exception("ResultMarketPrice \uc138\ud305 \uc911 \uc5d0\ub7ec \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + String.valueOf(e) + "]");
        }
        return resultMarketPrice;
    }

    private void setProductBasicInfo(ProductJSONCreate productJSONCreate, JsonObject simpleAccountInfo, String auth) throws Exception {
        try {
            productJSONCreate.representNo = Integer.valueOf(ShopCommon.jsonElementNullStr(simpleAccountInfo.get("representNo")));
            productJSONCreate.representName = ShopCommon.jsonElementNullStr(simpleAccountInfo.get("representName"));
            productJSONCreate.representType = ShopCommon.jsonElementNullStr(simpleAccountInfo.get("representType"));
            productJSONCreate.setProductRegistAuthCategories(auth);
            productJSONCreate.accountNo = Integer.valueOf(ShopCommon.jsonElementNullStr(simpleAccountInfo.get("accountNo")));
            productJSONCreate.accountId = ShopCommon.jsonElementNullStr(simpleAccountInfo.get("accountId"));
            productJSONCreate.advertiser = Boolean.valueOf(ShopCommon.jsonElementNullStr(simpleAccountInfo.get("advertiser")));
            productJSONCreate.mallSeq = Integer.valueOf(ShopCommon.jsonElementNullStr(simpleAccountInfo.get("mallSeq")));
            productJSONCreate.defaultChannelNo = Integer.valueOf(ShopCommon.jsonElementNullStr(simpleAccountInfo.get("defaultChannelNo")));
            productJSONCreate.accountExternalStatusType = ShopCommon.jsonElementNullStr(simpleAccountInfo.get("accountExternalStatusType"));
            productJSONCreate.npayRefKey = ShopCommon.jsonElementNullStr(simpleAccountInfo.get("npayRefKey"));
            productJSONCreate.payUseYn = Boolean.valueOf(ShopCommon.jsonElementNullStr(simpleAccountInfo.get("payUseYn")));
            productJSONCreate.actionGrade = ShopCommon.jsonElementNullStr(simpleAccountInfo.get("actionGrade"));
            productJSONCreate.branchUseYn = false;
            productJSONCreate.sellerNo = Integer.valueOf(ShopCommon.jsonElementNullStr(simpleAccountInfo.get("sellerNo")));
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud68c\uc0ac\uc815\ubcf4\uad00\ub828 \uc815\ubcf4 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCompanyInfo2(ProductJSONCreate productJSONCreate, JsonObject simpleAccountInfo, String auth, JsonObject ownerChannelInfoList) throws Exception {
        try {
            productJSONCreate.setOwnerChannelInfoList().setId(Integer.valueOf(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("id")).equals("") ? "0" : ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("id")))).setChannelServiceType(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("channelServiceType"))).setAccountNo(Integer.valueOf(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("accountNo")).equals("") ? "0" : ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("accountNo")))).setType(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("type"))).setName(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("name"))).setUrl(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("url"))).setChannelExternalStatusType(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("channelExternalStatusType"))).setPayUseYn(Boolean.valueOf(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("payUseYn")))).setTalkAccountId(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("talkAccountId"))).setTalkExposure(Boolean.valueOf(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("talkExposure")))).setFullUrl(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("fullUrl"))).setMobileUrl(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("mobileUrl")));
            productJSONCreate.thisDayDispatchBasisHour = 1;
            productJSONCreate.thisDayDispatchBasisMinute = 0;
            productJSONCreate.holidayOfTheWeek = "MONDAY";
            productJSONCreate.sellerHolidayList.add("2020-02-19");
            productJSONCreate.enforcedPermitPreOrderConfig = false;
            JsonObject searchableChannelInfoListMap = simpleAccountInfo.get("searchableChannelInfoListMap").getAsJsonObject().get("STOREFARM").getAsJsonArray().get(0).getAsJsonObject();
            productJSONCreate.setSearchableChannelInfoListMap().setId(Integer.valueOf(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("id")).equals("") ? "0" : ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("id")))).setChannelServiceType(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("channelServiceType"))).setAccountNo(Integer.valueOf(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("accountNo")).equals("") ? "0" : ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("accountNo")))).setType(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("type"))).setName(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("name"))).setUrl(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("url"))).setChannelExternalStatusType(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("channelExternalStatusType"))).setPayUseYn(Boolean.valueOf(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("payUseYn")))).setTalkAccountId(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("talkAccountId"))).setTalkExposure(Boolean.valueOf(ShopCommon.jsonElementNullStr(ownerChannelInfoList.get("talkExposure")))).setFullUrl(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("fullUrl"))).setMobileUrl(ShopCommon.jsonElementNullStr(searchableChannelInfoListMap.get("mobileUrl")));
            productJSONCreate.overseas = false;
            productJSONCreate.hasTalkTalkChannel = true;
            productJSONCreate.epOperable = true;
            productJSONCreate.epNaverShoppingOperable = true;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud68c\uc0ac\uc815\ubcf41 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setCompanyInfo(ProductJSONCreate productJSONCreate, JsonObject simpleAccountInfo, String auth, JsonObject creatableChannelInfoListMap, SingleChannelProductMap singleChannelProductMap, ShopProductNaverStoreAdditionDto dtllist, ShopProductDto dto) throws Exception {
        try {
            singleChannelProductMap.setAffiliateInfo(false);
            productJSONCreate.setCreatableChannelInfoListMap().setId(Integer.valueOf(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("id")).equals("") ? "0" : ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("id")))).setChannelServiceType(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("channelServiceType"))).setAccountNo(Integer.valueOf(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("accountNo")).equals("") ? "0" : ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("accountNo")))).setType(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("type"))).setName(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("name"))).setUrl(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("url"))).setChannelExternalStatusType(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("channelExternalStatusType"))).setPayUseYn(Boolean.valueOf(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("payUseYn")))).setTalkAccountId(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("talkAccountId"))).setTalkExposure(Boolean.valueOf(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("talkExposure")))).setFullUrl(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("fullUrl"))).setMobileUrl(ShopCommon.jsonElementNullStr(creatableChannelInfoListMap.get("mobileUrl")));
            JsonObject updatableChannelInfoListMap = simpleAccountInfo.get("updatableChannelInfoListMap").getAsJsonObject().get("STOREFARM").getAsJsonArray().get(0).getAsJsonObject();
            productJSONCreate.setUpdatableChannelInfoListMap().setId(Integer.valueOf(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("id")).equals("") ? "0" : ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("id")))).setChannelServiceType(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("channelServiceType"))).setAccountNo(Integer.valueOf(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("accountNo")).equals("") ? "0" : ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("accountNo")))).setType(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("type"))).setName(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("name"))).setUrl(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("url"))).setChannelExternalStatusType(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("channelExternalStatusType"))).setPayUseYn(Boolean.valueOf(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("payUseYn")))).setTalkAccountId(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("talkAccountId"))).setTalkExposure(Boolean.valueOf(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("talkExposure")))).setFullUrl(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("fullUrl"))).setMobileUrl(ShopCommon.jsonElementNullStr(updatableChannelInfoListMap.get("mobileUrl")));
            productJSONCreate.epEnuriOperable = false;
            productJSONCreate.epDanawaOperable = false;
            productJSONCreate.adult = true;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud68c\uc0ac\uc815\ubcf42 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setSelProductNameUsable(ShopProductNaverStoreAdditionDto dtllist, NaverProductCate navercate, JsonObject creatableChannelInfoListMap, SingleChannelProductMap singleChannelProductMap, JsonObject simpleAccountInfo) throws Exception {
        try {
            singleChannelProductMap.getSTOREFARM().setId("").setSelfProductNameUsable(false).setChannelProductName("").setChannelServiceType("STOREFARM").setChannelProductType("SINGLE").setChannel(null).setChannelProductDisplayStatusType("ON").setChannelProductStatusType("NORMAL").setStoreKeepExclusiveProduct(dtllist.getStoremember().equals("01")).setOrderRequestUsable(false).setBest(false).setBbsConfig(false).setBarcodeImage(null).setChannelNo(Integer.parseInt(ShopCommon.jsonElementNullStr(simpleAccountInfo.get("defaultChannelNo")).equals("") ? "0" : ShopCommon.jsonElementNullStr(simpleAccountInfo.get("defaultChannelNo"))));
            if (navercate == null || !navercate.wholeCategoryName.contains("\ub3c4\uc11c")) {
                singleChannelProductMap.setEpInfo().setNaverShoppingRegistration(!dtllist.getPricecomparison().equals("02")).setEnuriRegistration(!dtllist.getPricecomparison_enuri().equals("02")).setDanawaRegistration(!dtllist.getPricecomparison_danawa().equals("02")).setNaverDisabled(false).setEnuriDisabled(false).setDanawaDisabled(false).setDisabledAll(false);
            } else {
                singleChannelProductMap.setEpInfo().setNaverShoppingRegistration(false).setEnuriRegistration(false).setDanawaRegistration(false).setNaverDisabled(true).setEnuriDisabled(true).setDanawaDisabled(true).setDisabledAll(true);
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ub178\ucd9c\ucc44\ub110, \uc2a4\ud1a0\uc5b4\ucc1c, \uac00\uaca9\ube44\uad50 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setProdName(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, ResultMarketPrice resultMarketPrice, Product productReg, int stockqty) throws Exception {
        try {
            String value = IProduct.formatProductNameByCode2(dtllist.getProdnmoutput(), dto);
            if (dtllist.getProdnmafter().equals("Y")) {
                value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "L", 99);
            }
            if (dtllist.getProdnmrand().equals("Y")) {
                value = ShopCommon.setWordRandomGenerator(value);
            }
            if (!dtllist.getProdnmstart().equals("")) {
                value = dtllist.getProdnmstart().concat(value);
            }
            if (!dtllist.getProdnmend().equals("")) {
                value = value.concat(" ").concat(dtllist.getProdnmend());
            }
            value = this.DeleteEscapeChar(value);
            String sellerProductName = "";
            sellerProductName = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 190) : value;
            productReg.name = sellerProductName;
            productReg.salePrice = resultMarketPrice.getConsumer_if_sale_price();
            productReg.saleStartDate = YDMATimeUtil.getCurrentDateScheduler() + "T00:00:00.000+09:00";
            Object saleEndDate = "";
            if (dtllist.getSalesperiod().equals("")) {
                saleEndDate = "2999-12-31T23:59:59.999+09:00";
                dto.setSaleenddt("2999-12-31 23:59:59");
            } else {
                saleEndDate = YDMATimeUtil.getSaleEndDt(dtllist.getSalesperiod()) + "T23:59:59.999+09:00";
                dto.setSaleenddt(YDMATimeUtil.getSaleEndDt(dtllist.getSalesperiod()) + " 23:59:59");
            }
            productReg.saleEndDate = saleEndDate;
            productReg.stockQuantity = stockqty > 0 ? Integer.valueOf(stockqty) : Integer.valueOf(999);
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc0c1\ud488\uba85, \ud310\ub9e4\uae30\uac04, \uc7ac\uace0 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setDiscountInfo(ShopProductNaverStoreAdditionDto dtllist, Product productReg, NaverProductCate navercate) throws Exception {
        try {
            if (dtllist.getImmediscount().equals("01")) {
                String discountMode = dtllist.getImmediscountvalue1();
                String baseDiscountValue = dtllist.getImmediscountvalue2();
                String baseDiscountType = dtllist.getImmediscountvalue3().equals("01") ? "WON" : "PERCENT";
                String baseStartDate = dtllist.getImmedisstartdate();
                String baseEndDate = dtllist.getImmedisenddate();
                String reserveDiscountValue = dtllist.getImmediscountvalue5();
                String reserveDiscountType = dtllist.getImmediscountvalue6().equals("01") ? "WON" : "PERCENT";
                String reserveStartDate = dtllist.getImmedismobilestartdate();
                Object reserveEndDate = dtllist.getImmedismobileenddate();
                if (discountMode.equals("00") || discountMode.equals("02")) {
                    if (reserveStartDate.isEmpty() || ((String)reserveEndDate).isEmpty()) {
                        throw new Exception("\ub370\uc774\ud130 \uc785\ub825 \uc2e4\ud328: \ub4f1\ub85d\ud558\ub824\ub294 \ubd80\uac00\uc815\ubcf4\uc5d0 \uc608\uc57d\ud560\uc778\uc774 \uccb4\ud06c\ub418\uc5b4 \uc788\uc9c0\ub9cc, \uc2dc\uc791 \ub0a0\uc9dc \ub610\ub294 \uc885\ub8cc \ub0a0\uc9dc\uac00 \ube44\uc5b4 \uc788\uc2b5\ub2c8\ub2e4. \ud655\uc778 \ud6c4 \ub2e4\uc2dc \ub4f1\ub85d\ud574 \uc8fc\uc138\uc694.");
                    }
                    if (reserveStartDate.equals("period")) {
                        LocalDateTime today = LocalDateTime.now().withHour(0).withMinute(0).withSecond(0).withNano(0);
                        LocalDateTime startDay = today.plusDays(1L);
                        LocalDateTime endDay = startDay.plusDays(Integer.parseInt((String)reserveEndDate));
                        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm");
                        reserveStartDate = startDay.format(formatter);
                        reserveEndDate = endDay.format(formatter);
                    }
                }
                if (!((String)reserveEndDate).isEmpty()) {
                    reserveEndDate = ((String)reserveEndDate).substring(0, ((String)reserveEndDate).length() - 1) + "9";
                }
                if ("01".equals(discountMode)) {
                    productReg.setImmediateDiscountMethod().setDiscountUnitType(baseDiscountType).setValue(baseDiscountValue).setStartDate(null).setEndDate(null);
                    productReg.setImmediateMobileDiscountMethod().setDiscountUnitType(baseDiscountType).setValue(baseDiscountValue).setStartDate(null).setEndDate(null);
                    if (!baseStartDate.isEmpty() && !baseEndDate.isEmpty()) {
                        start = baseStartDate + ":00.000+09:00";
                        end = baseEndDate + ":59.999+09:00";
                        productReg.setImmediateDiscountMethod().setDiscountUnitType(baseDiscountType).setValue(baseDiscountValue).setStartDate(start).setEndDate(end);
                        productReg.setImmediateMobileDiscountMethod().setDiscountUnitType(baseDiscountType).setValue(baseDiscountValue).setStartDate(start).setEndDate(end);
                    }
                } else if ("02".equals(discountMode)) {
                    if (!reserveStartDate.isEmpty() && !((String)reserveEndDate).isEmpty()) {
                        productReg.getSpecialDiscountPolicy("RESERVATION").setDiscountUnitType(reserveDiscountType).setValue(reserveDiscountValue).setStartDate(reserveStartDate + ":00.000+09:00").setEndDate((String)reserveEndDate + ":59.999+09:00");
                    }
                } else if ("00".equals(discountMode)) {
                    productReg.setImmediateDiscountMethod().setDiscountUnitType(baseDiscountType).setValue(baseDiscountValue).setStartDate(null).setEndDate(null);
                    productReg.setImmediateMobileDiscountMethod().setDiscountUnitType(baseDiscountType).setValue(baseDiscountValue).setStartDate(null).setEndDate(null);
                    if (!baseStartDate.isEmpty() && !baseEndDate.isEmpty()) {
                        start = baseStartDate + ":00.000+09:00";
                        end = baseEndDate + ":59.999+09:00";
                        productReg.setImmediateDiscountMethod().setDiscountUnitType(baseDiscountType).setValue(baseDiscountValue).setStartDate(start).setEndDate(end);
                        productReg.setImmediateMobileDiscountMethod().setDiscountUnitType(baseDiscountType).setValue(baseDiscountValue).setStartDate(start).setEndDate(end);
                    }
                    if (!reserveStartDate.isEmpty() && !((String)reserveEndDate).isEmpty()) {
                        productReg.getSpecialDiscountPolicy("RESERVATION").setDiscountUnitType(reserveDiscountType).setValue(reserveDiscountValue).setStartDate(reserveStartDate + ":00.000+09:00").setEndDate((String)reserveEndDate + ":59.999+09:00");
                    }
                }
            }
            if (navercate != null && !navercate.wholeCategoryName.contains("\ub3c4\uc11c")) {
                if (dtllist.getPluralbuy().equals("01")) {
                    String pluralBuyType = dtllist.getPluralbuyvalue2().equals("01") ? "WON" : "COUNT";
                    String pluralBuyValue = dtllist.getPluralbuyvalue1();
                    String pluralDiscountType = dtllist.getPluralbuyvalue4().equals("01") ? "WON" : "PERCENT";
                    String pluralDiscountValue = dtllist.getPluralbuyvalue3();
                    productReg.setMultiPurchaseDiscountPolicy(pluralBuyType, pluralBuyValue).setDiscountUnitType(pluralDiscountType).setValue(pluralDiscountValue).setStartDate(null).setEndDate(null);
                    if (!dtllist.getPluralbuystartdate().equals("") && !dtllist.getPluralbuyenddate().equals("")) {
                        productReg.setMultiPurchaseDiscountPolicy(pluralBuyType, pluralBuyValue).setDiscountUnitType(pluralDiscountType).setValue(pluralDiscountValue).setStartDate(dtllist.getPluralbuystartdate() + "T13:10:00.000+09:00").setEndDate(dtllist.getPluralbuyenddate() + "T13:19:59.999+09:00");
                    }
                }
                if (dtllist.getPointreview().equals("01")) {
                    productReg.setReviewPointPolicy(dtllist.getPointreviewvalue1(), dtllist.getPointreviewvalue2(), dtllist.getPointreviewvalue3(), dtllist.getPointreviewvalue4(), dtllist.getPointreviewvalue5(), null, null);
                    if (!dtllist.getPointreviewstartdate().equals("") && !dtllist.getPointreviewenddate().equals("")) {
                        productReg.setReviewPointPolicy(dtllist.getPointreviewvalue1(), dtllist.getPointreviewvalue2(), dtllist.getPointreviewvalue3(), dtllist.getPointreviewvalue4(), dtllist.getPointreviewvalue5(), dtllist.getPointreviewstartdate() + "T00:00:00.000+09:00", dtllist.getPointreviewenddate() + "T23:59:59.999+09:00");
                    }
                }
                if (dtllist.getInterestfree().equals("01")) {
                    productReg.setFreeInterestPolicy(dtllist.getInterestfreevalue1(), null, null);
                    if (!dtllist.getInterestfreestartdate().equals("") && !dtllist.getInterestfreeenddate().equals("")) {
                        productReg.setFreeInterestPolicy(dtllist.getInterestfreevalue1(), dtllist.getInterestfreestartdate() + "T00:00:00.000+09:00", dtllist.getInterestfreeenddate() + "T23:59:59.999+09:00");
                    }
                }
                if (dtllist.getPointprod().equals("01")) {
                    productReg.setPurchasePointPolicy(dtllist.getPointprodvalue2().equals("01") ? "WON" : "PERCENT", dtllist.getPointprodvalue1(), null, null);
                    if (!dtllist.getPointprodstartdate().equals("") && !dtllist.getPointprodenddate().equals("")) {
                        productReg.setPurchasePointPolicy(dtllist.getPointprodvalue2().equals("01") ? "WON" : "PERCENT", dtllist.getPointprodvalue1(), dtllist.getPointprodstartdate() + "T00:00:00.000+09:00", dtllist.getPointprodenddate() + "T23:59:59.999+09:00");
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud560\uc778\ub0b4\uc6a9 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.";
            if (e.getMessage().contains("\uc608\uc57d\ud560\uc778")) {
                message = e.getMessage();
            }
            throw new Exception(message);
        }
    }

    private void setDeliveryInfo(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, Product productReg, JsonObject deliveryInfo) throws Exception {
        try {
            block60: {
                long delvcost;
                block58: {
                    if (deliveryInfo == null) {
                        accountNo = 0;
                        productReg.setDeliveryInfo();
                        productReg.deliveryInfo.deliveryType = dtllist.getShipmethod();
                        productReg.deliveryInfo.deliveryAttributeType = dtllist.getGeneraldelvtyp();
                        productReg.deliveryInfo.installationFee = false;
                        productReg.deliveryInfo.accountNo = accountNo;
                        productReg.deliveryInfo.cloneDeliveryAttributeType = "";
                        if (dtllist.getCustomordtyp().equals("01")) {
                            productReg.setDeliveryInfo().setCustomMadeDirectInputYn(false).setCustomProductAfterOrderYn(true).setExpectedDeliveryPeriodType(dtllist.getSenddate()).setExpectedDeliveryPeriodDirectInput("");
                        } else {
                            productReg.setDeliveryInfo().setCustomMadeDirectInputYn(false).setExpectedDeliveryPeriodType("").setExpectedDeliveryPeriodDirectInput("");
                        }
                    } else {
                        accountNo = 0;
                        accountNo = deliveryInfo.get("accountNo") != null ? deliveryInfo.get("accountNo").getAsInt() : deliveryInfo.get("deliveryBundleGroup").getAsJsonObject().get("accountNo").getAsInt();
                        if (dtllist.getCustomordtyp().equals("01")) {
                            productReg.setDeliveryInfo().setDeliveryType(dtllist.getShipmethod()).setDeliveryAttributeType(dtllist.getGeneraldelvtyp()).setInstallationFee(false).setAccountNo(accountNo).setCloneDeliveryAttributeType(deliveryInfo.get("deliveryAttributeType").getAsString()).setCustomMadeDirectInputYn(false).setCustomProductAfterOrderYn(true).setExpectedDeliveryPeriodType(dtllist.getSenddate()).setExpectedDeliveryPeriodDirectInput("");
                        } else {
                            productReg.setDeliveryInfo().setDeliveryType(dtllist.getShipmethod()).setDeliveryAttributeType(dtllist.getGeneraldelvtyp()).setInstallationFee(false).setAccountNo(accountNo).setCloneDeliveryAttributeType(deliveryInfo.get("deliveryAttributeType").getAsString()).setCustomMadeDirectInputYn(false).setExpectedDeliveryPeriodType("").setExpectedDeliveryPeriodDirectInput("");
                        }
                    }
                    productReg.setDeliveryCompany(dtllist.getDeliverycompanyCode(), dtllist.getDeliverycompanyId());
                    if (!dtllist.getShipdelvtyp().equals("01")) break block58;
                    int delvCost = Integer.parseInt(dto.getDelv_cost());
                    switch (dto.getDelv_type()) {
                        case "0": {
                            if (delvCost > 10) {
                                productReg.setDeliveryFee("PAID", delvCost, null, "PREPAID");
                                break;
                            }
                            throw new Exception("\uc0c1\ud488\uc815\ubcf4\uc758 \ubc30\uc1a1\ube44\uac00 10\uc6d0 \uc774\ud558\uc785\ub2c8\ub2e4. \ubc30\uc1a1\ube44\ub97c 10\uc6d0 \uc774\uc0c1 \uc785\ub825\ud558\uc138\uc694.");
                        }
                        case "1": {
                            productReg.setDeliveryFee("FREE", 0, 0, "");
                            break;
                        }
                        case "2": {
                            productReg.setDeliveryFee("PAID", delvCost, 0, "COLLECT");
                            break;
                        }
                        case "3": {
                            productReg.setDeliveryFee("UNIT_QUANTITY_PAID", delvCost, null, "PREPAID");
                            productReg.deliveryInfo.deliveryFee.repeatQuantity = dto.getDelivery_qty();
                            break;
                        }
                        case "": {
                            if (delvCost == 0) {
                                productReg.setDeliveryFee("FREE", 0, 0, "");
                                dto.setDelv_type("1");
                                break;
                            }
                            if (delvCost > 10) {
                                productReg.setDeliveryFee("PAID", delvCost, null, "PREPAID");
                                dto.setDelv_type("0");
                                break;
                            }
                            throw new Exception("\uc0c1\ud488\uc815\ubcf4\uc758 \ubc30\uc1a1\ube44\uac00 10\uc6d0 \uc774\ud558\uc785\ub2c8\ub2e4. \ubc30\uc1a1\ube44\ub97c 10\uc6d0 \uc774\uc0c1 \uc785\ub825\ud558\uc138\uc694.");
                        }
                        default: {
                            throw new Exception("\uc54c \uc218 \uc5c6\ub294 \ubc30\uc1a1 \uc720\ud615\uc785\ub2c8\ub2e4.");
                        }
                    }
                    delvcost = dto.getDelv_type().equals("1") ? 0 : Integer.parseInt(dto.getDelv_cost());
                    dto.setPack_code_str(dto.getDelv_type().concat("=").concat(String.valueOf(delvcost)));
                    break block60;
                }
                String deliveryCost = "";
                if (dtllist.getDelvcost().equals("9999")) {
                    if (!dto.getDelv_cost().equals("0")) {
                        deliveryCost = dto.getDelv_cost();
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        deliveryCost = systemconf.getDeliverycost();
                    }
                } else {
                    deliveryCost = dtllist.getDelvcost();
                }
                if (dtllist.getShipdelvvalue1().equals("01")) {
                    productReg.setDeliveryFee("FREE", 0, 0, "");
                } else if (dtllist.getShipdelvvalue1().equals("02")) {
                    productReg.setDeliveryFee("CONDITIONAL_FREE", Integer.parseInt(deliveryCost), Integer.parseInt(dtllist.getShipdelvvalue2()), dtllist.getShipdelvvalue8());
                } else if (dtllist.getShipdelvvalue1().equals("03")) {
                    productReg.setDeliveryFee("PAID", Integer.parseInt(deliveryCost), null, dtllist.getShipdelvvalue8());
                } else if (dtllist.getShipdelvvalue1().equals("04")) {
                    if (!dtllist.getShipdelvvalue3().equals("")) {
                        productReg.setDeliveryFee("UNIT_QUANTITY_PAID", Integer.parseInt(deliveryCost), Integer.parseInt(dtllist.getShipdelvvalue3().equals("") ? "0" : dtllist.getShipdelvvalue3()), dtllist.getShipdelvvalue8());
                        productReg.deliveryInfo.deliveryFee.repeatQuantity = dtllist.getShipdelvvalue3();
                    } else {
                        productReg.setDeliveryFee("RANGE_QUANTITY_PAID", Integer.parseInt(deliveryCost), null, dtllist.getShipdelvvalue8());
                        if (dtllist.getShipdelvvalue10().equals("01")) {
                            productReg.deliveryInfo.deliveryFee.secondBaseQuantity = Integer.parseInt(dtllist.getShipdelvvalue4());
                            productReg.deliveryInfo.deliveryFee.freeSectionLastQuantity = Integer.parseInt(dtllist.getShipdelvvalue4());
                            productReg.deliveryInfo.deliveryFee.secondExtraFee = Integer.parseInt(dtllist.getShipdelvvalue7());
                        } else {
                            productReg.deliveryInfo.deliveryFee.freeSectionLastQuantity = Integer.parseInt(dtllist.getShipdelvvalue4());
                            productReg.deliveryInfo.deliveryFee.secondSectionLastQuantity = dtllist.getShipdelvvalue5();
                            productReg.deliveryInfo.deliveryFee.secondExtraFee = Integer.parseInt(dtllist.getShipdelvvalue6());
                            productReg.deliveryInfo.deliveryFee.thirdExtraFee = dtllist.getShipdelvvalue7();
                            productReg.deliveryInfo.deliveryFee.secondBaseQuantity = null;
                        }
                    }
                }
                String delvtype = dtllist.getShipdelvvalue1().equals("01") ? "\ubb34\ub8cc\ubc30\uc1a1" : (dtllist.getShipdelvvalue1().equals("02") ? "\uc870\uac74\ubd80 \ubb34\ub8cc" : (dtllist.getShipdelvvalue1().equals("03") ? "\uc720\ub8cc\ubc30\uc1a1" : "\uc218\ub7c9\ubcc4 \ubc30\uc1a1"));
                delvcost = delvtype.equals("\ubb34\ub8cc\ubc30\uc1a1") ? 0 : Integer.parseInt(deliveryCost);
                dto.setPack_code_str(delvtype.concat("=").concat(String.valueOf(delvcost)));
            }
            if (dtllist.getBundledshipvalue2().equals("01")) {
                if (dtllist.getBundledshipvalue3().equals("01")) {
                    productReg.setDeliveryFeeByArea("AREA_2", dtllist.getBundledshipvalue4(), null);
                } else if (dtllist.getBundledshipvalue3().equals("02")) {
                    productReg.setDeliveryFeeByArea("AREA_3", dtllist.getBundledshipvalue5(), dtllist.getBundledshipvalue6());
                }
            }
            String returnDeliveryCost = "";
            String exchangeDeliveryCost = "";
            if (dtllist.getRetcost().equals("9999")) {
                if (!dto.getDelv_r_cost().equals("0")) {
                    returnDeliveryCost = dto.getDelv_r_cost();
                } else {
                    ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                    returnDeliveryCost = systemconf.getDeliverycost();
                }
            } else {
                returnDeliveryCost = dtllist.getRetcost();
            }
            if (dtllist.getCngcost().equals("9999")) {
                if (!dto.getDelv_r_cost().equals("0")) {
                    exchangeDeliveryCost = String.valueOf(Integer.parseInt(dto.getDelv_r_cost()) * 2);
                } else {
                    ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                    exchangeDeliveryCost = String.valueOf(Integer.parseInt(systemconf.getDeliverycost()) * 2);
                }
            } else {
                exchangeDeliveryCost = dtllist.getCngcost();
            }
            productReg.setClaimDeliveryInfo(Integer.parseInt(dtllist.getRetDeliveryId()), YDMAStringUtil.convertToInt(returnDeliveryCost), YDMAStringUtil.convertToInt(exchangeDeliveryCost), YDMAStringUtil.convertToInt(dtllist.getOutid()), YDMAStringUtil.convertToInt(dtllist.getRetid()));
            productReg.setReturnDeliveryCompany().setRegDate(dtllist.getRegdate()).setModDate(dtllist.getModdate()).setId(YDMAStringUtil.convertToInt(dtllist.getRetDeliveryId())).setAccountNo(YDMAStringUtil.convertToInt(dtllist.getRetdeliveryaccountno())).setReturnDeliveryCompanyPriorityType(dtllist.getRetdelicomprioritytype()).setNaverPayAppointment(Boolean.valueOf(dtllist.getNaverpayappointment())).setDeliveryCompanyName(dtllist.getDeliverycompanyname()).setRegAuditInfo(Long.parseLong(dtllist.getMemberno().equals("") ? "0" : dtllist.getMemberno()), dtllist.getRetloginid(), dtllist.getRetdeliname(), dtllist.getMembertype(), dtllist.getIp(), dtllist.getRequestid(), dtllist.getAdminviewtext());
            productReg.setShippingAddress().setId(Integer.parseInt(dtllist.getOutid())).setAccountNo(YDMAStringUtil.convertToInt(dtllist.getOutaccountno())).setAlias(dtllist.getOutalias()).setAddressBookType(dtllist.getOutaddressbooktype()).setOverseas(Boolean.valueOf(dtllist.getOutoverseas1())).setIsDelete(false);
            productReg.setShippingAddressInfo().setFullAddressInfo(dtllist.getOutfulladdressinfo());
            productReg.setReturnAddress().setId(YDMAStringUtil.convertToInt(dtllist.getRetid().equals("") ? "0" : dtllist.getRetid())).setAccountNo(YDMAStringUtil.convertToInt(dtllist.getRetaccountno().equals("") ? "0" : dtllist.getRetaccountno())).setAlias(dtllist.getRetalias()).setAddressBookType(dtllist.getRetaddressbooktype()).setOverseas(Boolean.valueOf(dtllist.getRetoverseas1())).setIsDelete(false);
            productReg.setReturnAddressInfo().setFullAddressInfo(dtllist.getRetfulladdressinfo());
            if (!dtllist.getBundleaccounno().isEmpty()) {
                productReg.setDeliveryBundleGroup().setId(Integer.parseInt(dtllist.getBundleid().equals("") ? "0" : dtllist.getBundleid())).setAccountNo(Integer.parseInt(dtllist.getBundleaccounno().equals("") ? "0" : dtllist.getBundleaccounno())).setName(dtllist.getBundlename()).setDeliveryFeeChargeMethodType(dtllist.getBundlemethodtype()).setUsable(Boolean.valueOf(dtllist.getBundleusable())).setBaseGroup(Boolean.valueOf(dtllist.getBundlebasegroup())).setRegisterDate(dtllist.getBundleregdate());
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ubc30\uc1a1\uc815\ubcf4 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setProductNotice(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, Product productReg) throws Exception {
        try {
            String prop = dto.getProp1_cd();
            if (dto.getProp1_cd().equals("039")) {
                dto.setProp1_cd("041");
            } else if (dto.getProp1_cd().equals("040")) {
                dto.setProp1_cd("042");
            }
            ShopProductDao.get().setNotice(dto, dto.getShopProdAttrnmDtos());
            List<ShopProdAttrnmDto> naverProductAttrList = ShopProductDao.get().getProductNaverNotice(dto.getProp1_cd());
            Map<Object, Object> requiredInfoCodes = new HashMap();
            if (!naverProductAttrList.isEmpty()) {
                String infoType = naverProductAttrList.get(0).getEName();
                requiredInfoCodes = this.getNaverProductInfoNoticeDetails(infoType);
            }
            if (naverProductAttrList.size() == 0) {
                productReg.detailAttribute.setProductInfoProvidedNotice("ETC").addContent("templateType", "PRODUCT_INFO_PROVIDED_NOTICE").addContent("productInfoProvidedNoticeType", "ETC").addContent("returnCostReason", "0").addContent("noRefundReason", "0").addContent("qualityAssuranceStandard", "0").addContent("compensationProcedure", "0").addContent("troubleShootingContents", "0").addContent("itemName", "\uc0c1\ud488\uc0c1\uc138 \ucc38\uc870").addContent("modelName", "\uc0c1\ud488\uc0c1\uc138 \ucc38\uc870").addContent("certificateDetails", "\ud574\ub2f9\uc0ac\ud56d \uc5c6\uc74c").addContent("manufacturer", "\uc0c1\ud488\uc0c1\uc138 \ucc38\uc870").addContent("customerServicePhoneNumber", "032-675-1102");
            } else {
                String noticeType = naverProductAttrList.get(0).getNoticetype();
                Product.DetailAttribute.ProductInfoProvidedNotice productInfoProvidedNotice = productReg.detailAttribute.setProductInfoProvidedNotice(noticeType);
                productInfoProvidedNotice.addContent("templateType", "PRODUCT_INFO_PROVIDED_NOTICE").addContent("productInfoProvidedNoticeType", noticeType).addContent("returnCostReason", "0").addContent("noRefundReason", "0").addContent("qualityAssuranceStandard", "0").addContent("compensationProcedure", "0").addContent("troubleShootingContents", "0");
                for (ShopProdAttrnmDto shopProdAttrnmDto : naverProductAttrList) {
                    ShopProdAttrnmDto shopProdAttrnmDtos = dto.getShopProdAttrnmDtos().stream().filter(p -> p.getAttrnm().contains(naverProduct.getAttrvl())).findAny().orElse(null);
                    if (shopProdAttrnmDtos != null) {
                        if (shopProdAttrnmDtos.getProp_val().equals("")) {
                            shopProdAttrnmDtos.setProp_val("\uc0c1\uc138\uc124\uba85\ucc38\uc870");
                        }
                        if (dtllist.getCollectiveapplication().equals("01")) {
                            if (dtllist.getTitleyn().equals("01")) {
                                productInfoProvidedNotice.addContent(shopProdAttrnmDto.getAttrnm().replaceAll("vm.content.", ""), shopProdAttrnmDto.getAttrnm().replaceAll("vm.content.", "") + " : \uc0c1\uc138\uc124\uba85\ucc38\uc870");
                            } else {
                                productInfoProvidedNotice.addContent(shopProdAttrnmDto.getAttrnm().replaceAll("vm.content.", ""), YDMAStringUtil.setTextStrtok("\uc0c1\uc138\uc124\uba85\ucc38\uc870", 50));
                            }
                        } else {
                            shopProdAttrnmDto.setProp_val(shopProdAttrnmDtos.getProp_val());
                            if (dtllist.getBanlang().equals("02")) {
                                shopProdAttrnmDtos.setProp_val(shopProdAttrnmDtos.getProp_val().replaceAll("[[*]|?|\"|<|>]", ""));
                            } else if (dtllist.getBanlang().equals("03")) {
                                shopProdAttrnmDtos.setProp_val(shopProdAttrnmDtos.getProp_val().replaceAll("[[*]|?|\"|<|>]", dtllist.getBanlangvalue1()));
                            }
                            String propval = shopProdAttrnmDtos.getProp_val().equals("") ? "\uc0c1\uc138\uc124\uba85\ucc38\uc870" : shopProdAttrnmDtos.getProp_val();
                            propval = propval.replaceAll("[[*]|?|\"|<|>]", "");
                            if (dtllist.getTitleyn().equals("01")) {
                                productInfoProvidedNotice.addContent(shopProdAttrnmDto.getAttrnm().replaceAll("vm.content.", ""), YDMAStringUtil.setTextStrtok(shopProdAttrnmDto.getAttrnm().replaceAll("vm.content.", "") + " : " + propval, 50));
                            } else {
                                productInfoProvidedNotice.addContent(shopProdAttrnmDto.getAttrnm().replaceAll("vm.content.", ""), YDMAStringUtil.setTextStrtok(propval, 50));
                            }
                        }
                    } else {
                        productInfoProvidedNotice.addContent(shopProdAttrnmDto.getAttrnm().replaceAll("vm.content.", ""), shopProdAttrnmDto.getAttrval().equals("") ? "\uc0c1\uc138\uc124\uba85\ucc38\uc870" : shopProdAttrnmDto.getAttrval());
                    }
                    requiredInfoCodes.remove(shopProdAttrnmDto.getAttrnm().replaceAll("vm.content.", ""));
                }
                for (Map.Entry entry : requiredInfoCodes.entrySet()) {
                    if (((String)entry.getKey()).equals("customerServicePhoneNumber")) continue;
                    productInfoProvidedNotice.addContent((String)entry.getKey(), "\uc0c1\uc138\uc124\uba85\ucc38\uc870");
                }
            }
            dto.setProp1_cd(prop);
        }
        catch (Exception e) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uace0\uc2dc\uc815\ubcf4 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.", e);
        }
    }

    private Map<String, String> getNaverProductInfoNoticeDetails(String infoType) throws Exception {
        HashMap<String, String> requiredInfoCodes = new HashMap<String, String>();
        try {
            Connection.Response response = Jsoup.connect((String)("https://sell.smartstore.naver.com/views/kr/shared/products/form/provided-notice/" + infoType.toLowerCase() + ".html")).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Safari/537.36").referrer("https://sell.smartstore.naver.com/").timeout(100000).ignoreHttpErrors(true).ignoreContentType(true).followRedirects(true).execute();
            Document doc = response.parse();
            Elements elements = doc.select(".form-sub-wrap .control-label");
            for (Element element : elements) {
                String forAttribute = element.attr("for").replace("prd_", "");
                if (forAttribute.isEmpty()) continue;
                requiredInfoCodes.put(forAttribute, "\uc0c1\uc138\uc124\uba85\ucc38\uc870");
            }
        }
        catch (Exception e) {
            throw new Exception("\uace0\uc2dc\uc815\ubcf4 \uc870\ud68c \uc2e4\ud328: " + e.getMessage());
        }
        return requiredInfoCodes;
    }

    private void setAddProduct(Product productReg, ShopProductDto dto) throws Exception {
        try {
            List<ShopAddProdInfoDto> addProdList = ShopProductDao.get().getAddProdInfo(dto.getProdseq());
            if (addProdList.size() > 0) {
                productReg.detailAttribute.setSupplementProductInfo("CREATE", 0, true);
                for (ShopAddProdInfoDto addProd : addProdList) {
                    productReg.detailAttribute.setSupplementProducts(Integer.toString(addProd.getProd_cnt()), addProd.getUser_code(), addProd.getProd_cnt() > 0, addProd.getProd_val1(), addProd.getProd_val2().equals("") ? "\ub2e8\ud488" : addProd.getProd_val2(), addProd.getProd_amt());
                }
            } else {
                productReg.detailAttribute.setSupplementProductInfo("CREATE", 0, false);
            }
        }
        catch (Exception e) {
            throw new Exception("\ucd94\uac00\uad6c\ub9e4\uc635\uc158 \uc138\ud305\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud558\uc600\uc2b5\ub2c8\ub2e4. [" + String.valueOf(e) + "]");
        }
    }

    private void setTax(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, Product productReg) throws Exception {
        try {
            boolean isExposed = "01".equals(dtllist.getReview());
            String reason = "";
            if (!isExposed && (reason = dtllist.getReviewUnExposeReason()) == null) {
                reason = "";
            }
            productReg.detailAttribute.setPurchaseReviewInfo(isExposed, reason);
            productReg.detailAttribute.setCustomMadeInfo(false);
            productReg.detailAttribute.taxType = dtllist.getSurtax().equals("01") ? (YDMASessonUtil.getLoginType() == 2 ? (dto.getTax_yn().equals("0") ? "TAX" : "DUTYFREE") : (dto.getTax_yn().equals("4") ? "DUTYFREE" : "TAX")) : dtllist.getSurtax();
            productReg.detailAttribute.minorPurchasable = dtllist.getTypeaddi().equals("Y") ? Boolean.valueOf(dto.getAdult().equals("0")) : Boolean.valueOf(dtllist.getMinortyp().equals("01"));
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ub9ac\ubdf0 \ub178\ucd9c \uc5ec\ubd80, \uacfc\uc138  \uc5ec\ubd80 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private int setOption(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, ResultMarketPrice resultMarketPrice, Product productReg, int stockqty) throws Exception {
        this.options = this.getProductOptions(dto);
        try {
            if (this.options.size() > 0) {
                String[] optionType = this.options.get(0).getName().split(":");
                if (optionType.length == 3) {
                    productReg.detailAttribute.setOptionInfo(true, true);
                    productReg.detailAttribute.setOption(optionType[0], true, "COMBINATION", "CREATE");
                    productReg.detailAttribute.setOption(optionType[1], true, "COMBINATION", "CREATE");
                    productReg.detailAttribute.setOption(optionType[2], true, "COMBINATION", "CREATE");
                } else if (optionType.length == 2) {
                    productReg.detailAttribute.setOptionInfo(true, true);
                    productReg.detailAttribute.setOption(dto.getChar_1_nm().replace(",", ""), true, "COMBINATION", "CREATE");
                    productReg.detailAttribute.setOption(dto.getChar_2_nm().replace(",", ""), true, "COMBINATION", "CREATE");
                } else {
                    productReg.detailAttribute.setOptionInfo(true, false);
                    productReg.detailAttribute.setOption(dto.getChar_1_nm().replace(",", ""), true, "COMBINATION", "CREATE");
                }
                for (ShopOptionDto option2 : this.options) {
                    if (option2.getName().contains("\ud488\uc808") || option2.getOptspecdes().contains("\ud488\uc808") || option2.getCnt().equals("0")) continue;
                    Long salePrice1 = YDMAStringUtil.convertToLong(dto.getGoods_cost());
                    String deliveryFee = "";
                    if (dtllist.getFreedelivery().equals("T")) {
                        if (dtllist.getExpprc() == 9999) {
                            if (!dto.getDelv_cost().equals("") || !dto.getDelv_cost().equals("0")) {
                                deliveryFee = dto.getDelv_cost();
                            } else {
                                ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                                deliveryFee = systemconf.getDeliverycost();
                            }
                        } else {
                            deliveryFee = String.valueOf(dtllist.getExpprc());
                        }
                        salePrice1 = salePrice1 + (long)Integer.parseInt(deliveryFee);
                    }
                    salePrice1 = salePrice1 + YDMAStringUtil.convertToLong(option2.getAmt());
                    int limit_price1 = YDMAStringUtil.convertToInt(option2.getLimit_price());
                    ResultMarketPrice optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price1, salePrice1);
                    if (salePrice1 > YDMAStringUtil.convertToLong(optionprice.getConsumer_if_sale_price())) {
                        optionprice = ShopProductSendDto.getMarketCalcate(dtllist, limit_price1, salePrice1);
                    }
                    String addOptionLeftNm = "";
                    String addOptionRightNm = "";
                    if (dtllist.getAddoptionlb().equals("Y")) {
                        addOptionLeftNm = dtllist.getAddOptionL();
                    }
                    if (dtllist.getAddoptionrb().equals("Y")) {
                        addOptionRightNm = dtllist.getAddOptionR();
                    }
                    String[] name = option2.getOptspecdes().split(":");
                    String firstName = addOptionLeftNm + name[0].replace(",", "") + addOptionRightNm;
                    String secondName = name.length > 1 ? addOptionLeftNm + name[1].replace(",", "") + addOptionRightNm : "";
                    String thirdName = name.length > 2 ? addOptionLeftNm + name[2].replace(",", "") + addOptionRightNm : "";
                    int addAmt = Integer.parseInt(optionprice.getTotal_sale_discount()) - Integer.parseInt(dto.getGoods_price());
                    String cnt = option2.getCnt();
                    if (name.length == 3) {
                        productReg.detailAttribute.setTripleOptCombinations(addAmt, cnt, "", true, "COMBINATION", "CREATE", this.DeleteEscapeChar(firstName), this.DeleteEscapeChar(secondName), this.DeleteEscapeChar(thirdName));
                        stockqty += Integer.parseInt(cnt);
                        continue;
                    }
                    if (name.length == 2) {
                        productReg.detailAttribute.setDoubleOptCombinations(addAmt, cnt, "", true, "COMBINATION", "CREATE", this.DeleteEscapeChar(firstName), this.DeleteEscapeChar(secondName));
                        stockqty += Integer.parseInt(cnt);
                        continue;
                    }
                    productReg.detailAttribute.setOptCombinations(addAmt, cnt, "", true, "COMBINATION", "CREATE", this.DeleteEscapeChar(firstName));
                    stockqty += Integer.parseInt(cnt);
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc635\uc158 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
        return stockqty;
    }

    private void setTag(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, Product productReg, Map<String, String> loginCookie, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        block15: {
            try {
                if (!dtllist.getTag().equals("01")) break block15;
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<String> removetag = new ArrayList<String>();
                List<String> search = new ArrayList<String>();
                if (dto.getExcepkeywdyn().equals("Y")) {
                    if (dto.getExcepkeywd() != null && !dto.getExcepkeywd().isEmpty()) {
                        removetag.addAll(Arrays.asList(dto.getExcepkeywd().split(",")));
                    }
                    if (shoppingMallDetailDto.getForbiddenKeywords() != null && !shoppingMallDetailDto.getForbiddenKeywords().isEmpty()) {
                        removetag.addAll(Arrays.asList(shoppingMallDetailDto.getForbiddenKeywords().split(",")));
                    }
                    if (dtllist.getTagvalue1().equals("01")) {
                        list.addAll(Arrays.asList(dto.getGoods_search().replaceAll("[.!%&-+/]", "").split(",")));
                    } else {
                        list.addAll(Arrays.asList(dtllist.getTagvalue2().replaceAll("[.!%&-+/]", "").split(",")));
                    }
                    search = IProduct.checkSearch(list, removetag, search);
                } else {
                    search.addAll(Arrays.asList(dto.getGoods_search().replaceAll("[.!%&-+/]", "").split(",")));
                }
                productReg.detailAttribute.setSeoInfo("", "");
                int idx = 0;
                List<Object> finalsearch = new ArrayList();
                for (String key : search) {
                    key = key.replaceAll(" ", "");
                    finalsearch.add(key.trim());
                }
                finalsearch = finalsearch.stream().distinct().collect(Collectors.toList());
                int i = 0;
                while (i < finalsearch.size()) {
                    if (idx <= 9) {
                        if (((String)finalsearch.get(i)).getBytes("UTF-8").length <= 29 && !((String)finalsearch.get(i)).isEmpty()) {
                            if (dtllist.getTagvalue3().equals("01")) {
                                JsonParser parser = new JsonParser();
                                String url = String.format("https://sell.smartstore.naver.com/api/product/shared/is-restrict-tag?_action=isRestrictTag&tag=%s", finalsearch.get(i));
                                Connection.Response response = Jsoup.connect((String)url).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").cookies(loginCookie).method(Connection.Method.GET).timeout(15000).ignoreContentType(true).execute();
                                JsonObject body = (JsonObject)parser.parse(response.body());
                                if (!body.get("restricted").getAsBoolean()) {
                                    productReg.detailAttribute.setSeoInfoSellerTags((String)finalsearch.get(i));
                                    ++idx;
                                }
                            } else {
                                productReg.detailAttribute.setSeoInfoSellerTags((String)finalsearch.get(i));
                                ++idx;
                            }
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \ud0dc\uadf8 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
            }
        }
    }

    private void setOriginArea(ShopProductDto dto, ShopProductNaverStoreAdditionDto dtllist, Product productReg) throws Exception {
        try {
            productReg.detailAttribute.setNaverShoppingSearchInfo(dto.getMaker(), "", dto.getBrand_nm());
            productReg.detailAttribute.setAfterServiceInfo(dtllist.getAstelno(), dtllist.getAsdtl());
            productReg.detailAttribute.setPurchaseQuantityInfo(dtllist.getMinimumqty().equals("") ? null : dtllist.getMinimumqty(), dtllist.getMaximumval().equals("") ? null : dtllist.getMaximumval(), dtllist.getMaximumqty().equals("") ? null : dtllist.getMaximumqty());
            switch (dto.getGoods_keyword()) {
                case "shop5001": {
                    this.setHubSellProductOrigin(dto, productReg);
                    break;
                }
                case "shop0283": {
                    this.setDosinProductOrigin(dto, productReg);
                    break;
                }
                case "shop0120": {
                    this.setOwnerclanProductOrigin(dto, productReg);
                    break;
                }
                case "shop0319": {
                    this.setDomeggookProductOrigin(dto, productReg);
                    break;
                }
                case "shop9994": 
                case "shop9995": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "shop0316": {
                    this.setTobizonProudctOrigin(dto, productReg);
                    break;
                }
                case "shop0286": {
                    this.setFunnProductOrigin(dto, productReg);
                    break;
                }
                default: {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                }
            }
            productReg.detailAttribute.setSellerCodeInfo(dto.getCompayny_goods_cd(), "", "", "");
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc6d0\uc0b0\uc9c0, A/S, \uad6c\ub9e4\uc218\ub7c9 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setHubSellProductOrigin(ShopProductDto dto, Product productReg) throws Exception {
        try {
            switch (dto.getProp1_cd()) {
                case "001": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "002": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "003": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                case "004": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                case "005": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "006": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "007": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "008": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "009": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "010": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "011": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "012": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "013": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "014": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "015": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val3());
                    break;
                }
                case "016": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "017": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val3());
                    break;
                }
                case "018": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "019": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "020": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "021": {
                    if (dto.getOrigin().equals("")) {
                        productReg.detailAttribute.setOriginAreaInfo("INCLUDE_IN_DETAILS", "03", "");
                        break;
                    }
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "022": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "023": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                case "024": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "025": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                case "026": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "032": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "033": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "034": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "035": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "036": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "037": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "038": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                default: {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud5c8\ube0c\uc140\ub7ec \uc0c1\ud488\uc758 \uc6d0\uc0b0\uc9c0(\uc81c\uc870\uad6d)\uc744 \uc138\ud305\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setDosinProductOrigin(ShopProductDto dto, Product productReg) throws Exception {
        try {
            switch (dto.getProp1_cd()) {
                case "001": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val10());
                    break;
                }
                case "002": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val9());
                    break;
                }
                case "003": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val8());
                    break;
                }
                case "004": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val7());
                    break;
                }
                case "005": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val10());
                    break;
                }
                case "006": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val11());
                    break;
                }
                case "007": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "008": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val13());
                    break;
                }
                case "009": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "010": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val13());
                    break;
                }
                case "011": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "012": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "014": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "015": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val9());
                    break;
                }
                case "016": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "017": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val10());
                    break;
                }
                case "018": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "019": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val8());
                    break;
                }
                case "020": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "021": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "022": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "023": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val14());
                    break;
                }
                case "024": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "025": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val12());
                    break;
                }
                case "035": {
                    String val = dto.getProp_val4();
                    if (val.equals("") || val == null) {
                        val = dto.getOrigin();
                    }
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", val);
                    break;
                }
                case "041": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val13());
                    break;
                }
                default: {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub3c4\ub9e4\uc758\uc2e0 \uc0c1\ud488\uc758 \uc6d0\uc0b0\uc9c0(\uc81c\uc870\uad6d)\uc744 \uc138\ud305\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setOwnerclanProductOrigin(ShopProductDto dto, Product productReg) throws Exception {
        try {
            switch (dto.getProp1_cd()) {
                case "001": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "002": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "003": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "004": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "005": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "006": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val7());
                    break;
                }
                case "007": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "008": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "009": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "010": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "011": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "012": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "013": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "014": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "015": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "016": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "017": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val7());
                    break;
                }
                case "018": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "019": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                case "020": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val3());
                    break;
                }
                case "021": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val2());
                    break;
                }
                case "022": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val2());
                    break;
                }
                case "023": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val9());
                    break;
                }
                case "024": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val8());
                    break;
                }
                case "025": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val8());
                    break;
                }
                case "026": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "032": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "033": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "034": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "035": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                case "036": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "037": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "038": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                default: {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\uc624\ub108\ud074\ub79c \uc0c1\ud488\uc758 \uc6d0\uc0b0\uc9c0(\uc81c\uc870\uad6d)\uc744 \uc138\ud305\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setDomeggookProductOrigin(ShopProductDto dto, Product productReg) throws Exception {
        try {
            switch (dto.getProp1_cd()) {
                case "001": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "002": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "003": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "004": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "005": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "006": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val7());
                    break;
                }
                case "007": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "008": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val7());
                    break;
                }
                case "009": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val7());
                    break;
                }
                case "010": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val7());
                    break;
                }
                case "011": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "012": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "013": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val6());
                    break;
                }
                case "014": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "015": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val5());
                    break;
                }
                case "016": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "017": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val7());
                    break;
                }
                case "018": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "019": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "020": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "021": {
                    if (dto.getOrigin().equals("")) {
                        productReg.detailAttribute.setOriginAreaInfo("INCLUDE_IN_DETAILS", "03", "");
                        break;
                    }
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "022": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "023": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val9());
                    break;
                }
                case "024": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "025": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val8());
                    break;
                }
                case "026": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "032": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "033": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "034": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "035": {
                    if (dto.getProp_val4().equals("")) {
                        productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                        break;
                    }
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                case "036": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "037": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "038": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                default: {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub3c4\ub9e4\uafb9 \uc0c1\ud488\uc758 \uc6d0\uc0b0\uc9c0(\uc81c\uc870\uad6d)\uc744 \uc138\ud305\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setTobizonProudctOrigin(ShopProductDto dto, Product productReg) throws Exception {
        try {
            switch (dto.getProp1_cd()) {
                case "035": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                default: {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud22c\ube44\uc988\uc628 \uc0c1\ud488\uc758 \uc6d0\uc0b0\uc9c0(\uc81c\uc870\uad6d)\uc744 \uc138\ud305\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setFunnProductOrigin(ShopProductDto dto, Product productReg) throws Exception {
        try {
            switch (dto.getProp1_cd()) {
                case "001": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val8());
                    break;
                }
                case "002": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val11());
                    break;
                }
                case "003": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "004": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "005": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "006": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "007": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "008": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "009": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "010": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "011": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "012": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "013": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "014": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "015": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "016": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "017": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "018": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "019": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "020": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "021": {
                    if (dto.getOrigin().equals("")) {
                        productReg.detailAttribute.setOriginAreaInfo("INCLUDE_IN_DETAILS", "03", "");
                        break;
                    }
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "022": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "023": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "024": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "025": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "026": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "032": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "033": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "034": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "035": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getProp_val4());
                    break;
                }
                case "036": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "037": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                case "038": {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
                default: {
                    productReg.detailAttribute.setOriginAreaInfo("DIRECT_INPUT", "04", dto.getOrigin());
                    break;
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud380\uc564\uc1fc\ud551 \uc0c1\ud488\uc758 \uc6d0\uc0b0\uc9c0(\uc81c\uc870\uad6d)\uc744 \uc138\ud305\ud558\ub294 \ub3c4\uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private String DeleteEscapeChar(String str) {
        String[] deleteStr = new String[]{"*"};
        String[] escapeStr = new String[]{"[*]"};
        int i = 0;
        while (i < deleteStr.length) {
            if (str.contains(deleteStr[i])) {
                str = str.replaceAll(escapeStr[i], "");
            }
            ++i;
        }
        return str;
    }

    private void setImage(Map<String, String> loginCookie, List<String> strImages, Product productReg, ShopProductNaverStoreAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception {
        try {
            List<NaverUploadImage> list = this.getImageUrl(strImages, loginCookie, dtllist, shoppingMallDetailDto);
            int i = 0;
            while (i < list.size()) {
                if (i <= 9) {
                    if (i == 0) {
                        productReg.setImages("REPRESENTATIVE", 1, list.get(i).getThumbnail(), Integer.parseInt(list.get(i).getWidth()), Integer.parseInt(list.get(i).getHeight()), Integer.parseInt(list.get(i).getFileSize()));
                    } else {
                        productReg.setImages("OPTIONAL", i, list.get(i).getThumbnail(), Integer.parseInt(list.get(i).getWidth()), Integer.parseInt(list.get(i).getHeight()), Integer.parseInt(list.get(i).getFileSize()));
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc774\ubbf8\uc9c0 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void setImageApi(String clientId, String clientSecret, List<String> strImages, Product productReg) throws Exception {
        NaverStoreGenerateSignature naverStroeGenerateSignature = new NaverStoreGenerateSignature();
        Long timestamp = System.currentTimeMillis();
        String secretSign = naverStroeGenerateSignature.generateSignature(clientId, clientSecret, timestamp);
        String accessToken = naverStroeGenerateSignature.accessToken(secretSign, clientId, timestamp, "client_credentials", "SELF");
        JsonParser jsonparser = new JsonParser();
        try {
            File pngFile22;
            Object bufferedImage;
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            int maxImages = Math.min(strImages.size(), 10);
            int i = 0;
            while (i < maxImages) {
                File file;
                File uploadFile = file = new File(strImages.get(i));
                String mimeType = this.getMimeType(file);
                if (file.getName().toLowerCase().endsWith("c.jpg")) {
                    bufferedImage = ImageIO.read(file);
                    pngFile22 = new File(file.getParent(), file.getName().replace(".jpg", "_converted.png"));
                    ImageIO.write((RenderedImage)bufferedImage, "png", pngFile22);
                    uploadFile = pngFile22;
                    mimeType = "image/png";
                }
                builder.addFormDataPart("imageFiles", uploadFile.getName(), RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)uploadFile));
                ++i;
            }
            Request request2 = new Request.Builder().url("https://api.commerce.naver.com/external/v1/product-images/upload").post((RequestBody)builder.build()).addHeader("Content-Type", "multipart/form-data").addHeader("Accept", "application/json;charset=UTF-8").addHeader("Authorization", accessToken).build();
            int maxRetries = 3;
            int[] retryDelays = new int[]{3000, 5000, 7000};
            int attempt = 1;
            while (attempt <= maxRetries) {
                block24: {
                    try {
                        bufferedImage = null;
                        pngFile22 = null;
                        try (Response response = client.newCall(request2).execute();){
                            if (!response.isSuccessful() || response.body() == null) {
                                String errorMsg;
                                String string = errorMsg = response.body() != null ? response.body().string() : "No response body";
                                if (response.code() == 429 || errorMsg.toLowerCase().contains("too many request")) {
                                    if (attempt < maxRetries) {
                                        InterruptSource.Thread.sleep((long)retryDelays[attempt]);
                                        break block24;
                                    }
                                    throw new Exception("Too many requests. Max retries reached.");
                                }
                                throw new Exception(errorMsg);
                            }
                            String responseBody = response.body().string();
                            YDMAStringUtil.Print(responseBody);
                            JsonObject jsonObject = (JsonObject)jsonparser.parse(responseBody);
                            JsonArray imagesArray = jsonObject.getAsJsonArray("images");
                            int j = 0;
                            while (j < imagesArray.size()) {
                                JsonObject imageObj = imagesArray.get(j).getAsJsonObject();
                                String imageUrl = imageObj.get("url").getAsString();
                                String type = j == 0 ? "REPRESENTATIVE" : "OPTIONAL";
                                productReg.setImages(type, j + 1, imageUrl, 0, 0, 0);
                                ++j;
                            }
                            break;
                        }
                        catch (Throwable pngFile22) {
                            if (bufferedImage == null) {
                                bufferedImage = pngFile22;
                            } else if (bufferedImage != pngFile22) {
                                ((Throwable)bufferedImage).addSuppressed(pngFile22);
                            }
                            throw bufferedImage;
                        }
                    }
                    catch (Exception ex) {
                        if (attempt == maxRetries) {
                            throw new Exception("\ucee4\uba38\uc2a4 API product-images/upload \uc694\uccad \uc2e4\ud328 (\ucd5c\ub300 \uc7ac\uc2dc\ub3c4): " + ex.getMessage(), ex);
                        }
                        try {
                            InterruptSource.Thread.sleep((long)retryDelays[attempt]);
                        }
                        catch (InterruptedException ie) {
                            InterruptSource.Thread.currentThread().interrupt();
                            throw new Exception("\uc7ac\uc2dc\ub3c4 \ub300\uae30 \uc911 \uc778\ud130\ub7fd\ud2b8\ub428", ie);
                        }
                    }
                }
                ++attempt;
            }
        }
        catch (Exception e) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uc774\ubbf8\uc9c0 \uc785\ub825 \uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + e.getMessage() + "]");
        }
    }

    private String getMimeType(File file) {
        String name = file.getName().toLowerCase();
        if (name.endsWith(".jpg") || name.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (name.endsWith(".png")) {
            return "image/png";
        }
        if (name.endsWith(".gif")) {
            return "image/gif";
        }
        if (name.endsWith(".bmp")) {
            return "image/bmp";
        }
        return "application/octet-stream";
    }

    public NaverProductCate getNaverCategory(String cid, Map<String, String> cookies, ShopProductNaverStoreAdditionDto dtllist) throws Exception {
        NaverProductCate naverCate = null;
        String url = "";
        try {
            url = dtllist.getIsCategory().equals("1") ? String.format("https://sell.smartstore.naver.com/api/category-search/%s?isValid=true ", dtllist.getShopcatno()) : String.format("https://sell.smartstore.naver.com/api/category-search/%s?isValid=true ", cid);
            Connection.Response response = Jsoup.connect((String)url).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").cookies(cookies).method(Connection.Method.GET).ignoreContentType(true).timeout(15000).execute();
            String body = response.body();
            if (body.isEmpty()) {
                return naverCate;
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            naverCate = (NaverProductCate)mapper.readValue(body, NaverProductCate.class);
            return naverCate;
        }
        catch (Exception exception) {
            throw new Exception("\ub370\uc774\ud130\uc785\ub825\uc2e4\ud328 : \uce74\ud14c\uace0\ub9ac \ub300\ubd84\ub958 \uac00\uc838\uc624\uae30 \uc911\uc5d0 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
    }

    private List<NaverUploadImage> getImageUrl(List<String> strImages, Map<String, String> loginCookie, ShopProductNaverStoreAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto) throws Exception, InterruptedException, IOException, FileNotFoundException {
        ArrayList<NaverUploadImage> list = new ArrayList<NaverUploadImage>();
        String pincode = "";
        String popurl = "";
        String upload_path = "";
        try {
            Connection.Response response1 = Jsoup.connect((String)"https://sell.smartstore.naver.com/api/v2/product-photos/bulk-upload").userAgent("Mozilla").referrer("https://sell.smartstore.naver.com/").method(Connection.Method.GET).cookies(loginCookie).timeout(60000).ignoreContentType(true).execute();
            JsonParser parse = new JsonParser();
            JsonObject obj = (JsonObject)parse.parse(response1.body());
            pincode = obj.get("pincode").getAsString();
            popurl = obj.get("popupUrl").getAsString();
            URL urlPop = new URL(popurl);
            upload_path = urlPop.getPath();
        }
        catch (IOException e1) {
            throw new Exception("api/v2/product-photos/bulk-upload \uc911 \uc5d0\ub7ec\ubc1c\uc0dd [" + String.valueOf(e1) + "]");
        }
        for (String image : strImages) {
            String uploadUrl = String.format("https://ecommerce.upphoto.naver.com%s/%s", upload_path.replaceAll("simpleUploader", "simpleUpload"), 0);
            String uploadReferer = String.format("https://ecommerce.upphoto.naver.com%s/%s", upload_path.replaceAll("simpleUpload", "simpleUploader/?pin="), pincode);
            File fileimg = new File(image);
            Throwable throwable = null;
            Object var15_17 = null;
            try (FileInputStream fs1 = new FileInputStream(fileimg);){
                Connection.Response response_upload = Jsoup.connect((String)uploadUrl).userAgent("Mozilla").referrer(uploadReferer).header("Origin", "https://ecommerce.upphoto.naver.com").data("image", fileimg.getName(), (InputStream)fs1).data("pin", pincode).cookies(loginCookie).method(Connection.Method.POST).timeout(60000).execute();
                try {
                    JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{NaverUploadImage.class});
                    Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                    StringReader reader = new StringReader(response_upload.body());
                    NaverUploadImage naverUploadImage = (NaverUploadImage)jaxbUnmarshaller.unmarshal((Reader)reader);
                    naverUploadImage.setThumbnail("http://shop1.phinf.naver.net/".concat(naverUploadImage.getThumbnail()));
                    list.add(naverUploadImage);
                }
                catch (JAXBException e) {
                    throw new Exception("ecommerce.upphoto \uc2ec\ud50c\uc5c5\ub85c\ub4dc \uc911 \uc5d0\ub7ec\ubc1c\uc0dd [" + String.valueOf((Object)e) + "]");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            InterruptSource.Thread.sleep((long)2000L);
        }
        return list;
    }

    public static String getAddress() {
        String addr = "";
        ChromeDriver driver = ChromeExtention.getInstace().getDriver();
        String URL2 = "https://sell.smartstore.naver.com/#/seller/info";
        ChromeScript.get().get(driver, URL2);
        ChromeScript.get().waitOtherPageSleep(URL2, driver);
        String retDetail = driver.getPageSource();
        Document detailDoc = Jsoup.parse((String)retDetail);
        addr = detailDoc.select("input[title=\ucd9c\uace0\uc9c0 \uc8fc\uc18c]").val();
        return addr;
    }

    public static String getReturnAddress() {
        String addr = "";
        ChromeDriver driver = ChromeExtention.getInstace().getDriver();
        String URL2 = "https://sell.smartstore.naver.com/#/seller/info";
        ChromeScript.get().get(driver, URL2);
        ChromeScript.get().waitOtherPageSleep(URL2, driver);
        String retDetail = driver.getPageSource();
        Document detailDoc = Jsoup.parse((String)retDetail);
        addr = detailDoc.select("input[title=\ubc18\ud488/\uad50\ud658\uc9c0 \uc8fc\uc18c]").val();
        return addr;
    }

    public String InfoBase(Map<String, String> cookies) throws Exception {
        String ret = "";
        try {
            String url = "https://sell.smartstore.naver.com/api/products?_action=create";
            Connection.Response response = Jsoup.connect((String)url).cookies(cookies).userAgent("User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/140.0.0.0 Safari/537.36").referrer("https://sell.smartstore.naver.com/").ignoreContentType(true).timeout(15000).method(Connection.Method.GET).execute();
            ret = response.body();
        }
        catch (Exception exception) {
            throw new Exception("\uae30\ubcf8\uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc5d0\ub7ec.. ");
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized ShopProductSendDto excute(ShopProductSendDto sendInfo) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ShopProductSendDto complate(ShopProductSendDto prodList) throws Exception {
        return null;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    private static /* synthetic */ boolean lambda$1(ShopProductDto shopProductDto, WorkMngDetailDto p) {
        return p.getProdseq().equals(shopProductDto.getCompayny_goods_cd());
    }

    private /* synthetic */ String lambda$2(ShopProductDto shopProductDto, ShopProductNaverStoreAdditionDto shopProductNaverStoreAdditionDto, ShoppingMallDetailDto shoppingMallDetailDto, Map map, List list) throws Exception {
        return this.setProductReg(shopProductDto, shopProductNaverStoreAdditionDto, shoppingMallDetailDto, map, list);
    }

    public static class CreatableChannelInfoListMap {
        @JsonProperty(value="STOREFARM")
        public List<STOREFARM_> sTOREFARM = new ArrayList<STOREFARM_>();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class NaverProductCate {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="parentId")
        private String parentId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="level")
        private Integer level;
        @JsonProperty(value="deleted")
        private Boolean deleted;
        @JsonProperty(value="juvenileHarmful")
        private Boolean juvenileHarmful;
        @JsonProperty(value="lastLevel")
        private Boolean lastLevel;
        @JsonProperty(value="sellBlogUse")
        private Boolean sellBlogUse;
        @JsonProperty(value="sortOrder")
        private Integer sortOrder;
        @JsonProperty(value="wholeCategoryId")
        private String wholeCategoryId;
        @JsonProperty(value="wholeCategoryName")
        private String wholeCategoryName;

        public String toString() {
            return "NaverCate{id='" + this.id + "', parentId='" + this.parentId + "', name='" + this.name + "', level=" + String.valueOf(this.level) + ", deleted=" + String.valueOf(this.deleted) + ", juvenileHarmful=" + String.valueOf(this.juvenileHarmful) + ", lastLevel=" + String.valueOf(this.lastLevel) + ", sellBlogUse=" + String.valueOf(this.sellBlogUse) + ", sortOrder=" + String.valueOf(this.sortOrder) + ", wholeCategoryId='" + this.wholeCategoryId + "', wholeCategoryName='" + this.wholeCategoryName + "'}";
        }
    }

    @XmlRootElement(name="item")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    private static class NaverUploadImage {
        private String index;
        private String url;
        private String path;
        private String fileName;
        private String width;
        private String height;
        private String colorSpace;
        private String fileSize;
        private String thumbnail;
        private String imageUrl;

        private NaverUploadImage() {
        }

        public String getImageUrl() {
            return this.imageUrl;
        }

        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        public String getIndex() {
            return this.index;
        }

        public void setIndex(String index) {
            this.index = index;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getWidth() {
            return this.width;
        }

        public void setWidth(String width) {
            this.width = width;
        }

        public String getHeight() {
            return this.height;
        }

        public void setHeight(String height) {
            this.height = height;
        }

        public String getColorSpace() {
            return this.colorSpace;
        }

        public void setColorSpace(String colorSpace) {
            this.colorSpace = colorSpace;
        }

        public String getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(String fileSize) {
            this.fileSize = fileSize;
        }

        public String getThumbnail() {
            return this.thumbnail;
        }

        public void setThumbnail(String thumbnail) {
            this.thumbnail = thumbnail;
        }

        public String toString() {
            return "NaverUploadImage{index='" + this.index + "', url='" + this.url + "', path='" + this.path + "', fileName='" + this.fileName + "', width='" + this.width + "', height='" + this.height + "', colorSpace='" + this.colorSpace + "', fileSize='" + this.fileSize + "', thumbnail='" + this.thumbnail + "'}";
        }
    }

    public static class OwnerChannelInfoList {
        @JsonProperty(value="id")
        public Integer id;
        @JsonProperty(value="channelServiceType")
        public String channelServiceType;
        @JsonProperty(value="accountNo")
        public Integer accountNo;
        @JsonProperty(value="type")
        public String type;
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="url")
        public String url;
        @JsonProperty(value="channelExternalStatusType")
        public String channelExternalStatusType;
        @JsonProperty(value="payUseYn")
        public Boolean payUseYn;
        @JsonProperty(value="talkAccountId")
        public String talkAccountId;
        @JsonProperty(value="talkExposure")
        public Boolean talkExposure;
        @JsonProperty(value="subVerticalServiceTypes")
        public List<Object> subVerticalServiceTypes = new ArrayList<Object>();
        @JsonProperty(value="fullUrl")
        public String fullUrl;
        @JsonProperty(value="mobileUrl")
        public String mobileUrl;

        public OwnerChannelInfoList setId(Integer id) {
            this.id = id;
            return this;
        }

        public OwnerChannelInfoList setChannelServiceType(String channelServiceType) {
            this.channelServiceType = channelServiceType;
            return this;
        }

        public OwnerChannelInfoList setAccountNo(Integer accountNo) {
            this.accountNo = accountNo;
            return this;
        }

        public OwnerChannelInfoList setType(String type) {
            this.type = type;
            return this;
        }

        public OwnerChannelInfoList setName(String name) {
            this.name = name;
            return this;
        }

        public OwnerChannelInfoList setUrl(String url) {
            this.url = url;
            return this;
        }

        public OwnerChannelInfoList setChannelExternalStatusType(String channelExternalStatusType) {
            this.channelExternalStatusType = channelExternalStatusType;
            return this;
        }

        public OwnerChannelInfoList setPayUseYn(Boolean payUseYn) {
            this.payUseYn = payUseYn;
            return this;
        }

        public OwnerChannelInfoList setTalkAccountId(String talkAccountId) {
            this.talkAccountId = talkAccountId;
            return this;
        }

        public OwnerChannelInfoList setTalkExposure(Boolean talkExposure) {
            this.talkExposure = talkExposure;
            return this;
        }

        public OwnerChannelInfoList setSubVerticalServiceTypes(List<Object> subVerticalServiceTypes) {
            this.subVerticalServiceTypes = subVerticalServiceTypes;
            return this;
        }

        public OwnerChannelInfoList setFullUrl(String fullUrl) {
            this.fullUrl = fullUrl;
            return this;
        }

        public OwnerChannelInfoList setMobileUrl(String mobileUrl) {
            this.mobileUrl = mobileUrl;
            return this;
        }
    }

    public static class Product {
        @JsonProperty(value="saleType")
        public String saleType;
        @JsonProperty(value="excludeAdminDiscount")
        public Boolean excludeAdminDiscount;
        @JsonProperty(value="excludeGivePresent")
        public Boolean excludeGivePresent;
        @JsonProperty(value="payExposure")
        public Boolean payExposure;
        @JsonProperty(value="images")
        public List<Image> images = new ArrayList<Image>();
        @JsonProperty(value="videos")
        public List<Object> videos = new ArrayList<Object>();
        @JsonProperty(value="detailAttribute")
        public DetailAttribute detailAttribute = new DetailAttribute();
        @JsonProperty(value="detailContent")
        public DetailContent detailContent;
        @JsonProperty(value="deliveryInfo")
        public DeliveryInfo deliveryInfo;
        @JsonProperty(value="customerBenefit")
        public CustomerBenefit customerBenefit;
        @JsonProperty(value="productStats")
        public ProductStats productStats = new ProductStats();
        @JsonProperty(value="representImageUrl")
        public String representImageUrl;
        @JsonProperty(value="useSalePeriod")
        public Boolean useSalePeriod;
        @JsonProperty(value="category")
        public Category category;
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="salePrice")
        public String salePrice;
        @JsonProperty(value="stockQuantity")
        public Integer stockQuantity;
        @JsonProperty(value="saleStartDate")
        public String saleStartDate;
        @JsonProperty(value="saleEndDate")
        public String saleEndDate;

        @JsonIgnore
        public void setImages(String imageType, Integer order, String imageUrl, Integer width, Integer height, Integer fileSize) {
            Image image = new Image();
            image.imageType = imageType;
            image.order = order;
            image.imageUrl = imageUrl;
            image.width = width;
            image.height = height;
            image.fileSize = fileSize;
            this.images.add(image);
        }

        public void setDetailContent(String editorType, String editorTypeForEditor, Boolean existsRemoveTags, String productDetailInfoContent) {
            this.detailContent = new DetailContent();
            this.detailContent.editorType = editorType;
            this.detailContent.editorTypeForEditor = editorTypeForEditor;
            this.detailContent.existsRemoveTags = existsRemoveTags;
            this.detailContent.productDetailInfoContent = productDetailInfoContent;
        }

        public DeliveryInfo setDeliveryInfo() {
            this.deliveryInfo = new DeliveryInfo();
            return this.deliveryInfo;
        }

        public void setDeliveryCompany(String id, String name) {
            this.deliveryInfo.deliveryCompany = new DeliveryCompany();
            this.deliveryInfo.deliveryCompany.id = id;
            this.deliveryInfo.deliveryCompany.name = name;
        }

        public void setDeliveryFee(String deliveryFeeType, Integer baseFee, Integer freeConditionalAmount, String deliveryFeePayType) {
            this.deliveryInfo.deliveryFee = new DeliveryFee();
            this.deliveryInfo.deliveryFee.deliveryFeeType = deliveryFeeType;
            this.deliveryInfo.deliveryFee.baseFee = baseFee;
            this.deliveryInfo.deliveryFee.freeConditionalAmount = freeConditionalAmount;
            this.deliveryInfo.deliveryFee.deliveryFeePayType = deliveryFeePayType;
        }

        public void setDeliveryFeeByArea(String deliveryAreaType, String area2extraFee, String area3extraFee) {
            this.deliveryInfo.deliveryFee.deliveryFeeByArea = new DeliveryFeeByArea();
            this.deliveryInfo.deliveryFee.deliveryFeeByArea.deliveryAreaType = deliveryAreaType;
            this.deliveryInfo.deliveryFee.deliveryFeeByArea.area2extraFee = area2extraFee;
            this.deliveryInfo.deliveryFee.deliveryFeeByArea.area3extraFee = area3extraFee;
        }

        public void setClaimDeliveryInfo(Integer returnDeliveryCompanySeq, Integer returnDeliveryFee, Integer exchangeDeliveryFee, Integer shippingAddressId, Integer returnAddressId) {
            this.deliveryInfo.claimDeliveryInfo = new ClaimDeliveryInfo();
            this.deliveryInfo.claimDeliveryInfo.returnDeliveryCompanySeq = returnDeliveryCompanySeq;
            this.deliveryInfo.claimDeliveryInfo.returnDeliveryFee = returnDeliveryFee;
            this.deliveryInfo.claimDeliveryInfo.exchangeDeliveryFee = exchangeDeliveryFee;
            this.deliveryInfo.claimDeliveryInfo.shippingAddressId = shippingAddressId;
            this.deliveryInfo.claimDeliveryInfo.returnAddressId = returnAddressId;
        }

        public ReturnDeliveryCompany setReturnDeliveryCompany() {
            this.deliveryInfo.claimDeliveryInfo.returnDeliveryCompany = new ReturnDeliveryCompany();
            return this.deliveryInfo.claimDeliveryInfo.returnDeliveryCompany;
        }

        public ShippingAddress setShippingAddress() {
            this.deliveryInfo.claimDeliveryInfo.shippingAddress = new ShippingAddress();
            return this.deliveryInfo.claimDeliveryInfo.shippingAddress;
        }

        public AddressInfo setShippingAddressInfo() {
            this.deliveryInfo.claimDeliveryInfo.shippingAddress.addressInfo = new AddressInfo();
            return this.deliveryInfo.claimDeliveryInfo.shippingAddress.addressInfo;
        }

        public ReturnAddress setReturnAddress() {
            this.deliveryInfo.claimDeliveryInfo.returnAddress = new ReturnAddress();
            return this.deliveryInfo.claimDeliveryInfo.returnAddress;
        }

        public AddressInfo_ setReturnAddressInfo() {
            this.deliveryInfo.claimDeliveryInfo.returnAddress.addressInfo = new AddressInfo_();
            return this.deliveryInfo.claimDeliveryInfo.returnAddress.addressInfo;
        }

        public DeliveryBundleGroup setDeliveryBundleGroup() {
            this.deliveryInfo.deliveryBundleGroup = new DeliveryBundleGroup();
            return this.deliveryInfo.deliveryBundleGroup;
        }

        private DiscountMethod_ getSpecialDiscountPolicy(String disCountType) {
            if (this.customerBenefit == null) {
                this.customerBenefit = new CustomerBenefit();
            }
            if (this.customerBenefit.specialDiscountPolicies == null) {
                this.customerBenefit.specialDiscountPolicies = new ArrayList<SpecialDiscountPolicies>();
            }
            if (this.customerBenefit.specialDiscountPolicies.isEmpty()) {
                this.customerBenefit.specialDiscountPolicies.add(new SpecialDiscountPolicies());
            }
            SpecialDiscountPolicies policy = this.customerBenefit.specialDiscountPolicies.get(0);
            policy.specialDiscountType = disCountType;
            if (policy.discountMethod == null) {
                policy.discountMethod = new DiscountMethod_();
            }
            return policy.discountMethod;
        }

        private ImmediateDiscountPolicy getImmediateDiscountPolicy() {
            if (this.customerBenefit == null) {
                this.customerBenefit = new CustomerBenefit();
            }
            if (this.customerBenefit.immediateDiscountPolicy == null) {
                this.customerBenefit.immediateDiscountPolicy = new ImmediateDiscountPolicy();
            }
            return this.customerBenefit.immediateDiscountPolicy;
        }

        public DiscountMethod setImmediateDiscountMethod() {
            this.getImmediateDiscountPolicy().discountMethod = new DiscountMethod();
            return this.customerBenefit.immediateDiscountPolicy.discountMethod;
        }

        public MobileDiscountMethod setImmediateMobileDiscountMethod() {
            this.getImmediateDiscountPolicy().mobileDiscountMethod = new MobileDiscountMethod();
            return this.customerBenefit.immediateDiscountPolicy.mobileDiscountMethod;
        }

        public DiscountMethod_ setMultiPurchaseDiscountPolicy(String orderUnitType, String orderValue) {
            if (this.customerBenefit == null) {
                this.customerBenefit = new CustomerBenefit();
            }
            this.customerBenefit.multiPurchaseDiscountPolicy = new MultiPurchaseDiscountPolicy();
            this.customerBenefit.multiPurchaseDiscountPolicy.orderUnitType = orderUnitType;
            this.customerBenefit.multiPurchaseDiscountPolicy.orderValue = orderValue;
            this.customerBenefit.multiPurchaseDiscountPolicy.discountMethod = new DiscountMethod_();
            return this.customerBenefit.multiPurchaseDiscountPolicy.discountMethod;
        }

        public PurchasePointPolicy setPurchasePointPolicy(String benefitUnitType, String value, String startDate, String endDate) {
            if (this.customerBenefit == null) {
                this.customerBenefit = new CustomerBenefit();
            }
            this.customerBenefit.purchasePointPolicy = new PurchasePointPolicy();
            this.customerBenefit.purchasePointPolicy.benefitUnitType = benefitUnitType;
            this.customerBenefit.purchasePointPolicy.value = value;
            this.customerBenefit.purchasePointPolicy.startDate = startDate;
            this.customerBenefit.purchasePointPolicy.endDate = endDate;
            return this.customerBenefit.purchasePointPolicy;
        }

        public ReviewPointPolicy setReviewPointPolicy(String textReviewPoint, String photoVideoReviewPoint, String afterUseTextReviewPoint, String afterUsePhotoVideoReviewPoint, String storeMemberReviewPoint, String startDate, String endDate) {
            if (this.customerBenefit == null) {
                this.customerBenefit = new CustomerBenefit();
            }
            this.customerBenefit.reviewPointPolicy = new ReviewPointPolicy();
            this.customerBenefit.reviewPointPolicy.textReviewPoint = textReviewPoint;
            this.customerBenefit.reviewPointPolicy.photoVideoReviewPoint = photoVideoReviewPoint;
            this.customerBenefit.reviewPointPolicy.afterUseTextReviewPoint = afterUseTextReviewPoint;
            this.customerBenefit.reviewPointPolicy.afterUsePhotoVideoReviewPoint = afterUsePhotoVideoReviewPoint;
            this.customerBenefit.reviewPointPolicy.storeMemberReviewPoint = storeMemberReviewPoint;
            this.customerBenefit.reviewPointPolicy.startDate = startDate;
            this.customerBenefit.reviewPointPolicy.endDate = endDate;
            return this.customerBenefit.reviewPointPolicy;
        }

        public FreeInterestPolicy setFreeInterestPolicy(String value, String startDate, String endDate) {
            if (this.customerBenefit == null) {
                this.customerBenefit = new CustomerBenefit();
            }
            this.customerBenefit.freeInterestPolicy = new FreeInterestPolicy();
            this.customerBenefit.freeInterestPolicy.value = value;
            this.customerBenefit.freeInterestPolicy.startDate = startDate;
            this.customerBenefit.freeInterestPolicy.endDate = endDate;
            return this.customerBenefit.freeInterestPolicy;
        }

        public Category setCategory() {
            this.category = new Category();
            return this.category;
        }

        public class AddressInfo {
            @JsonProperty(value="fullAddressInfo")
            public String fullAddressInfo;

            public AddressInfo setFullAddressInfo(String fullAddressInfo) {
                this.fullAddressInfo = fullAddressInfo;
                return this;
            }
        }

        public class AddressInfo_ {
            @JsonProperty(value="apiType")
            public String apiType;
            @JsonProperty(value="address")
            public String address;
            @JsonProperty(value="basicAddress")
            public String basicAddress;
            @JsonProperty(value="jibunAddress")
            public String jibunAddress;
            @JsonProperty(value="roadNameAddress")
            public String roadNameAddress;
            @JsonProperty(value="massiveAddress")
            public String massiveAddress;
            @JsonProperty(value="detailAddress")
            public String detailAddress;
            @JsonProperty(value="newZipCode")
            public String newZipCode;
            @JsonProperty(value="overseas")
            public Boolean overseas;
            @JsonProperty(value="latitude")
            public Double latitude;
            @JsonProperty(value="longitude")
            public Double longitude;
            @JsonProperty(value="placeId")
            public String placeId;
            @JsonProperty(value="naverMapCode")
            public String naverMapCode;
            @JsonProperty(value="roadGroupId")
            public String roadGroupId;
            @JsonProperty(value="representAddressType")
            public String representAddressType;
            @JsonProperty(value="fullAddressInfo")
            public String fullAddressInfo;
            @JsonProperty(value="zipCode")
            public String zipCode;
            @JsonProperty(value="hasRoadNameAddress")
            public Boolean hasRoadNameAddress;
            @JsonProperty(value="hasJibunAddress")
            public Boolean hasJibunAddress;

            public AddressInfo_ setApiType(String apiType) {
                this.apiType = apiType;
                return this;
            }

            public AddressInfo_ setAddress(String address) {
                this.address = address;
                return this;
            }

            public AddressInfo_ setBasicAddress(String basicAddress) {
                this.basicAddress = basicAddress;
                return this;
            }

            public AddressInfo_ setJibunAddress(String jibunAddress) {
                this.jibunAddress = jibunAddress;
                return this;
            }

            public AddressInfo_ setRoadNameAddress(String roadNameAddress) {
                this.roadNameAddress = roadNameAddress;
                return this;
            }

            public AddressInfo_ setMassiveAddress(String massiveAddress) {
                this.massiveAddress = massiveAddress;
                return this;
            }

            public AddressInfo_ setDetailAddress(String detailAddress) {
                this.detailAddress = detailAddress;
                return this;
            }

            public AddressInfo_ setNewZipCode(String newZipCode) {
                this.newZipCode = newZipCode;
                return this;
            }

            public AddressInfo_ setOverseas(Boolean overseas) {
                this.overseas = overseas;
                return this;
            }

            public AddressInfo_ setLatitude(Double latitude) {
                this.latitude = latitude;
                return this;
            }

            public AddressInfo_ setLongitude(Double longitude) {
                this.longitude = longitude;
                return this;
            }

            public AddressInfo_ setPlaceId(String placeId) {
                this.placeId = placeId;
                return this;
            }

            public AddressInfo_ setNaverMapCode(String naverMapCode) {
                this.naverMapCode = naverMapCode;
                return this;
            }

            public AddressInfo_ setRoadGroupId(String roadGroupId) {
                this.roadGroupId = roadGroupId;
                return this;
            }

            public AddressInfo_ setRepresentAddressType(String representAddressType) {
                this.representAddressType = representAddressType;
                return this;
            }

            public AddressInfo_ setFullAddressInfo(String fullAddressInfo) {
                this.fullAddressInfo = fullAddressInfo;
                return this;
            }

            public AddressInfo_ setZipCode(String zipCode) {
                this.zipCode = zipCode;
                return this;
            }

            public AddressInfo_ setHasRoadNameAddress(Boolean hasRoadNameAddress) {
                this.hasRoadNameAddress = hasRoadNameAddress;
                return this;
            }

            public AddressInfo_ setHasJibunAddress(Boolean hasJibunAddress) {
                this.hasJibunAddress = hasJibunAddress;
                return this;
            }
        }

        public class Category {
            @JsonProperty(value="id")
            public String id;
            @JsonProperty(value="name")
            public String name;
            @JsonProperty(value="wholeCategoryId")
            public String wholeCategoryId;
            @JsonProperty(value="wholeCategoryName")
            public String wholeCategoryName;
            @JsonProperty(value="level")
            public Integer level;
            @JsonProperty(value="lastLevel")
            public Boolean lastLevel;
            @JsonProperty(value="deleted")
            public Boolean deleted;
            @JsonProperty(value="sellBlogUse")
            public Boolean sellBlogUse;
            @JsonProperty(value="sortOrder")
            public Integer sortOrder;
            @JsonProperty(value="juvenileHarmful")
            public Boolean juvenileHarmful;
            @JsonProperty(value="$order")
            public Integer $order;
            @JsonProperty(value="$promise")
            public Promise $promise;
            @JsonProperty(value="$resolved")
            public Boolean $resolved;
            @JsonProperty(value="parentId")
            public String parentId;
            @JsonProperty(value="exceptionalCategoryTypes")
            public List<String> exceptionalCategoryTypes;
            @JsonProperty(value="exceptionalCategoryAttributes")
            public List<Object> exceptionalCategoryAttributes;

            public Category() {
                this.$promise = new Promise();
                this.exceptionalCategoryTypes = new ArrayList<String>();
                this.exceptionalCategoryAttributes = new ArrayList<Object>();
            }

            public Category setId(String id) {
                this.id = id;
                return this;
            }

            public Category setName(String name) {
                this.name = name;
                return this;
            }

            public Category setWholeCategoryId(String wholeCategoryId) {
                this.wholeCategoryId = wholeCategoryId;
                return this;
            }

            public Category setWholeCategoryName(String wholeCategoryName) {
                this.wholeCategoryName = wholeCategoryName;
                return this;
            }

            public Category setLevel(Integer level) {
                this.level = level;
                return this;
            }

            public Category setLastLevel(Boolean lastLevel) {
                this.lastLevel = lastLevel;
                return this;
            }

            public Category setDeleted(Boolean deleted) {
                this.deleted = deleted;
                return this;
            }

            public Category setSellBlogUse(Boolean sellBlogUse) {
                this.sellBlogUse = sellBlogUse;
                return this;
            }

            public Category setSortOrder(Integer sortOrder) {
                this.sortOrder = sortOrder;
                return this;
            }

            public Category setJuvenileHarmful(Boolean juvenileHarmful) {
                this.juvenileHarmful = juvenileHarmful;
                return this;
            }

            public Category set$order(Integer $order) {
                this.$order = $order;
                return this;
            }

            public Category set$resolved(Boolean $resolved) {
                this.$resolved = $resolved;
                return this;
            }

            public Category setParentId(String parentId) {
                this.parentId = parentId;
                return this;
            }

            public Category setExceptionalCategoryTypes(String exceptionalCategoryTypes) {
                this.exceptionalCategoryTypes.add(exceptionalCategoryTypes);
                return this;
            }

            public Category setExceptionalCategoryAttributes(Object exceptionalCategoryAttributes) {
                this.exceptionalCategoryAttributes.add(exceptionalCategoryAttributes);
                return this;
            }
        }

        public class ClaimDeliveryInfo {
            @JsonProperty(value="returnDeliveryCompany")
            public ReturnDeliveryCompany returnDeliveryCompany;
            @JsonProperty(value="returnDeliveryCompanySeq")
            public Integer returnDeliveryCompanySeq;
            @JsonProperty(value="returnDeliveryFee")
            public Integer returnDeliveryFee;
            @JsonProperty(value="exchangeDeliveryFee")
            public Integer exchangeDeliveryFee;
            @JsonProperty(value="shippingAddress")
            public ShippingAddress shippingAddress;
            @JsonProperty(value="shippingAddressId")
            public Integer shippingAddressId;
            @JsonProperty(value="returnAddress")
            public ReturnAddress returnAddress;
            @JsonProperty(value="returnAddressId")
            public Integer returnAddressId;
        }

        public class CustomerBenefit {
            @JsonProperty(value="immediateDiscountPolicy")
            public ImmediateDiscountPolicy immediateDiscountPolicy;
            @JsonProperty(value="multiPurchaseDiscountPolicy")
            public MultiPurchaseDiscountPolicy multiPurchaseDiscountPolicy;
            @JsonProperty(value="purchasePointPolicy")
            public PurchasePointPolicy purchasePointPolicy;
            @JsonProperty(value="reviewPointPolicy")
            public ReviewPointPolicy reviewPointPolicy;
            @JsonProperty(value="freeInterestPolicy")
            public FreeInterestPolicy freeInterestPolicy;
            public List<SpecialDiscountPolicies> specialDiscountPolicies;
        }

        public class DeliveryBundleGroup {
            @JsonProperty(value="id")
            public Integer id;
            @JsonProperty(value="accountNo")
            public Integer accountNo;
            @JsonProperty(value="name")
            public String name;
            @JsonProperty(value="deliveryFeeChargeMethodType")
            public String deliveryFeeChargeMethodType;
            @JsonProperty(value="usable")
            public Boolean usable;
            @JsonProperty(value="baseGroup")
            public Boolean baseGroup;
            @JsonProperty(value="registerDate")
            public String registerDate;

            public DeliveryBundleGroup setId(Integer id) {
                this.id = id;
                return this;
            }

            public DeliveryBundleGroup setAccountNo(Integer accountNo) {
                this.accountNo = accountNo;
                return this;
            }

            public DeliveryBundleGroup setName(String name) {
                this.name = name;
                return this;
            }

            public DeliveryBundleGroup setDeliveryFeeChargeMethodType(String deliveryFeeChargeMethodType) {
                this.deliveryFeeChargeMethodType = deliveryFeeChargeMethodType;
                return this;
            }

            public DeliveryBundleGroup setUsable(Boolean usable) {
                this.usable = usable;
                return this;
            }

            public DeliveryBundleGroup setBaseGroup(Boolean baseGroup) {
                this.baseGroup = baseGroup;
                return this;
            }

            public DeliveryBundleGroup setRegisterDate(String registerDate) {
                this.registerDate = registerDate;
                return this;
            }
        }

        public class DeliveryCompany {
            @JsonProperty(value="id")
            String id;
            @JsonProperty(value="name")
            String name;
        }

        public class DeliveryFee {
            @JsonProperty(value="deliveryFeeType")
            public String deliveryFeeType;
            @JsonProperty(value="baseFee")
            public Integer baseFee;
            @JsonProperty(value="freeConditionalAmount")
            public Integer freeConditionalAmount;
            @JsonProperty(value="deliveryFeePayType")
            public String deliveryFeePayType;
            @JsonProperty(value="freeSectionLastQuantity")
            public int freeSectionLastQuantity;
            @JsonProperty(value="secondSectionLastQuantity")
            public String secondSectionLastQuantity;
            @JsonProperty(value="secondExtraFee")
            public int secondExtraFee;
            @JsonProperty(value="thirdExtraFee")
            public String thirdExtraFee;
            @JsonProperty(value="secondBaseQuantity")
            public Object secondBaseQuantity;
            @JsonProperty(value="deliveryFeeByArea")
            public DeliveryFeeByArea deliveryFeeByArea;
            @JsonProperty(value="repeatQuantity")
            public String repeatQuantity;
        }

        public class DeliveryFeeByArea {
            @JsonProperty(value="deliveryAreaType")
            public String deliveryAreaType;
            @JsonProperty(value="area2extraFee")
            public String area2extraFee;
            @JsonProperty(value="area3extraFee")
            public String area3extraFee;
        }

        public class DeliveryInfo {
            @JsonProperty(value="deliveryType")
            public String deliveryType;
            @JsonProperty(value="deliveryAttributeType")
            public String deliveryAttributeType;
            @JsonProperty(value="deliveryFee")
            public DeliveryFee deliveryFee;
            @JsonProperty(value="claimDeliveryInfo")
            public ClaimDeliveryInfo claimDeliveryInfo;
            @JsonProperty(value="deliveryCompany")
            public DeliveryCompany deliveryCompany;
            @JsonProperty(value="deliveryCompanyId")
            public String deliveryCompanyId;
            @JsonProperty(value="installationFee")
            public Boolean installationFee;
            @JsonProperty(value="accountNo")
            public Integer accountNo;
            @JsonProperty(value="cloneDeliveryAttributeType")
            public String cloneDeliveryAttributeType;
            @JsonProperty(value="deliveryBundleGroup")
            public DeliveryBundleGroup deliveryBundleGroup;
            @JsonProperty(value="customMadeDirectInputYn")
            public Boolean customMadeDirectInputYn;
            @JsonProperty(value="expectedDeliveryPeriodType")
            public String expectedDeliveryPeriodType;
            @JsonProperty(value="expectedDeliveryPeriodDirectInput")
            public String expectedDeliveryPeriodDirectInput;
            @JsonProperty(value="customProductAfterOrderYn")
            public Boolean customProductAfterOrderYn;

            public DeliveryBundleGroup getDeliveryBundleGroup() {
                return this.deliveryBundleGroup;
            }

            public void setDeliveryBundleGroup(DeliveryBundleGroup deliveryBundleGroup) {
                this.deliveryBundleGroup = deliveryBundleGroup;
            }

            public Boolean getCustomProductAfterOrderYn() {
                return this.customProductAfterOrderYn;
            }

            public void setCustomProductAfterOrderYn(Boolean customProductAfterOrderYn) {
                this.customProductAfterOrderYn = customProductAfterOrderYn;
            }

            public String getDeliveryType() {
                return this.deliveryType;
            }

            public String getDeliveryAttributeType() {
                return this.deliveryAttributeType;
            }

            public DeliveryFee getDeliveryFee() {
                return this.deliveryFee;
            }

            public ClaimDeliveryInfo getClaimDeliveryInfo() {
                return this.claimDeliveryInfo;
            }

            public Boolean getInstallationFee() {
                return this.installationFee;
            }

            public Integer getAccountNo() {
                return this.accountNo;
            }

            public String getCloneDeliveryAttributeType() {
                return this.cloneDeliveryAttributeType;
            }

            public Boolean getCustomMadeDirectInputYn() {
                return this.customMadeDirectInputYn;
            }

            public String getExpectedDeliveryPeriodType() {
                return this.expectedDeliveryPeriodType;
            }

            public String getExpectedDeliveryPeriodDirectInput() {
                return this.expectedDeliveryPeriodDirectInput;
            }

            public DeliveryInfo setCustomProductAfterOrderYn(boolean customProductAfterOrderYn) {
                this.customProductAfterOrderYn = customProductAfterOrderYn;
                return this;
            }

            public DeliveryInfo setDeliveryType(String deliveryType) {
                this.deliveryType = deliveryType;
                return this;
            }

            public DeliveryInfo setDeliveryAttributeType(String deliveryAttributeType) {
                this.deliveryAttributeType = deliveryAttributeType;
                return this;
            }

            public DeliveryInfo setDeliveryFee(DeliveryFee deliveryFee) {
                this.deliveryFee = deliveryFee;
                return this;
            }

            public DeliveryInfo setClaimDeliveryInfo(ClaimDeliveryInfo claimDeliveryInfo) {
                this.claimDeliveryInfo = claimDeliveryInfo;
                return this;
            }

            public DeliveryInfo setInstallationFee(Boolean installationFee) {
                this.installationFee = installationFee;
                return this;
            }

            public DeliveryInfo setAccountNo(Integer accountNo) {
                this.accountNo = accountNo;
                return this;
            }

            public DeliveryInfo setCloneDeliveryAttributeType(String cloneDeliveryAttributeType) {
                this.cloneDeliveryAttributeType = cloneDeliveryAttributeType;
                return this;
            }

            public DeliveryInfo setCustomMadeDirectInputYn(Boolean customMadeDirectInputYn) {
                this.customMadeDirectInputYn = customMadeDirectInputYn;
                return this;
            }

            public DeliveryInfo setExpectedDeliveryPeriodType(String expectedDeliveryPeriodType) {
                this.expectedDeliveryPeriodType = expectedDeliveryPeriodType;
                return this;
            }

            public DeliveryInfo setExpectedDeliveryPeriodDirectInput(String expectedDeliveryPeriodDirectInput) {
                this.expectedDeliveryPeriodDirectInput = expectedDeliveryPeriodDirectInput;
                return this;
            }

            public String getDeliveryCompanyId() {
                return this.deliveryCompanyId;
            }

            public void setDeliveryCompanyId(String deliveryCompanyId) {
                this.deliveryCompanyId = deliveryCompanyId;
            }
        }

        public class DetailAttribute {
            @JsonProperty(value="naverShoppingSearchInfo")
            public NaverShoppingSearchInfo naverShoppingSearchInfo = new NaverShoppingSearchInfo();
            @JsonProperty(value="afterServiceInfo")
            public AfterServiceInfo afterServiceInfo;
            @JsonProperty(value="purchaseQuantityInfo")
            public PurchaseQuantityInfo purchaseQuantityInfo;
            @JsonProperty(value="originAreaInfo")
            public OriginAreaInfo originAreaInfo;
            @JsonProperty(value="sellerCodeInfo")
            public SellerCodeInfo sellerCodeInfo;
            @JsonProperty(value="seoInfo")
            public SeoInfo seoInfo;
            @JsonProperty(value="optionInfo")
            public OptionInfo optionInfo;
            @JsonProperty(value="supplementProductInfo")
            public SupplementProductInfo supplementProductInfo;
            @JsonProperty(value="purchaseReviewInfo")
            public PurchaseReviewInfo purchaseReviewInfo;
            @JsonProperty(value="customMadeInfo")
            public CustomMadeInfo customMadeInfo;
            @JsonProperty(value="isbnInfo")
            public isbnInfo isbnInfo;
            @JsonProperty(value="taxType")
            public String taxType;
            @JsonProperty(value="productCertificationInfos")
            public List<Object> productCertificationInfos = new ArrayList<Object>();
            @JsonProperty(value="minorPurchasable")
            public Boolean minorPurchasable;
            @JsonProperty(value="productInfoProvidedNotice")
            public ProductInfoProvidedNotice productInfoProvidedNotice;
            @JsonProperty(value="productAttributes")
            public List<Object> productAttributes = new ArrayList<Object>();
            @JsonProperty(value="consumptionTax")
            public String consumptionTax = "TEN";
            @JsonProperty(value="certificationTargetExcludeContent")
            public CertificationTargetExcludeContent certificationTargetExcludeContent;
            @JsonProperty(value="useReturnCancelNotification")
            public Boolean useReturnCancelNotification;
            @JsonProperty(value="itselfProductionProductYn")
            public Boolean itselfProductionProductYn;
            @JsonProperty(value="manufactureDate")
            public String manufactureDate;
            @JsonProperty(value="validDate")
            public String validDate;
            @JsonProperty(value="sellerCommentContent")
            public String sellerCommentContent;

            public void setAfterServiceInfo(String afterServiceTelephoneNumber, String afterServiceGuideContent) {
                this.afterServiceInfo = new AfterServiceInfo();
                this.afterServiceInfo.afterServiceTelephoneNumber = afterServiceTelephoneNumber;
                this.afterServiceInfo.afterServiceGuideContent = afterServiceGuideContent;
            }

            public void setNaverShoppingSearchInfo(String manufacturerName, String modelName, String brandName) {
                this.naverShoppingSearchInfo = new NaverShoppingSearchInfo();
                this.naverShoppingSearchInfo.manufacturerName = manufacturerName;
                this.naverShoppingSearchInfo.modelName = modelName;
                this.naverShoppingSearchInfo.brandName = brandName;
            }

            public void setPurchaseQuantityInfo(String minPurchaseQuantity, String maxPurchaseQuantityPerId, String maxPurchaseQuantityPerOrder) {
                this.purchaseQuantityInfo = new PurchaseQuantityInfo();
                this.purchaseQuantityInfo.minPurchaseQuantity = minPurchaseQuantity;
                this.purchaseQuantityInfo.maxPurchaseQuantityPerId = maxPurchaseQuantityPerId;
                this.purchaseQuantityInfo.maxPurchaseQuantityPerOrder = maxPurchaseQuantityPerOrder;
            }

            public void setOriginAreaInfo(String type, String code, String content) {
                this.originAreaInfo = new OriginAreaInfo();
                this.originAreaInfo.type = type;
                this.originAreaInfo.originArea = new OriginArea();
                this.originAreaInfo.originArea.code = code;
                this.originAreaInfo.content = content;
            }

            public void setSellerCodeInfo(String sellerManagementCode, String sellerBarcode, String sellerCustomCode1, String sellerCustomCode2) {
                this.sellerCodeInfo = new SellerCodeInfo();
                this.sellerCodeInfo.sellerManagementCode = sellerManagementCode;
                this.sellerCodeInfo.sellerBarcode = sellerBarcode;
                this.sellerCodeInfo.sellerCustomCode1 = sellerCustomCode1;
                this.sellerCodeInfo.sellerCustomCode2 = sellerCustomCode2;
            }

            public void setSeoInfo(String pageTitle, String metaDescription) {
                this.seoInfo = new SeoInfo();
                this.seoInfo.pageTitle = pageTitle;
                this.seoInfo.metaDescription = metaDescription;
            }

            public void setSeoInfoSellerTags(String text) {
                SellerTag sellerTag = new SellerTag();
                sellerTag.text = text;
                this.seoInfo.sellerTags.add(sellerTag);
            }

            public void setOptionInfo(Boolean optionUsable, Boolean useStockManagement) {
                this.optionInfo = new OptionInfo();
                this.optionInfo.optionUsable = optionUsable;
                this.optionInfo.useStockManagement = useStockManagement;
            }

            public void setOption(String groupName, Boolean usable, String optionType, String sortType) {
                Option option2 = new Option();
                option2.groupName = groupName;
                option2.usable = usable;
                option2.optionType = optionType;
                option2.sortType = sortType;
                this.optionInfo.options.add(option2);
            }

            public void setTripleOptCombinations(Integer price2, String stockQuantity, String sellerManagerCode, Boolean usable, String optionType, String sortType, String optionName1, String optionName2, String optionName3) {
                OptionCombination optionCombination = new OptionCombination();
                optionCombination.price = price2;
                optionCombination.stockQuantity = stockQuantity;
                optionCombination.sellerManagerCode = sellerManagerCode;
                optionCombination.usable = usable;
                optionCombination.optionType = optionType;
                optionCombination.sortType = sortType;
                optionCombination.optionName1 = optionName1;
                optionCombination.optionName2 = optionName2;
                optionCombination.optionName3 = optionName3;
                this.optionInfo.optionCombinations.add(optionCombination);
            }

            public void setDoubleOptCombinations(Integer price2, String stockQuantity, String sellerManagerCode, Boolean usable, String optionType, String sortType, String optionName1, String optionName2) {
                OptionCombination optionCombination = new OptionCombination();
                optionCombination.price = price2;
                optionCombination.stockQuantity = stockQuantity;
                optionCombination.sellerManagerCode = sellerManagerCode;
                optionCombination.usable = usable;
                optionCombination.optionType = optionType;
                optionCombination.sortType = sortType;
                optionCombination.optionName1 = optionName1;
                optionCombination.optionName2 = optionName2;
                this.optionInfo.optionCombinations.add(optionCombination);
            }

            public void setOptCombinations(Integer price2, String stockQuantity, String sellerManagerCode, Boolean usable, String optionType, String sortType, String optionName1) {
                OptionCombination optionCombination = new OptionCombination();
                optionCombination.price = price2;
                optionCombination.stockQuantity = stockQuantity;
                optionCombination.sellerManagerCode = sellerManagerCode;
                optionCombination.usable = usable;
                optionCombination.optionType = optionType;
                optionCombination.sortType = sortType;
                optionCombination.optionName1 = optionName1;
                this.optionInfo.optionCombinations.add(optionCombination);
            }

            public void setSupplementProducts(String stockQuantity, String sellerManagerCode, boolean usable, String groupName, String name, int price2) {
                SupplementProducts supplementProduct = new SupplementProducts();
                supplementProduct.stockQuantity = stockQuantity;
                supplementProduct.sellerManagerCode = sellerManagerCode;
                supplementProduct.usable = usable;
                supplementProduct.groupName = groupName;
                supplementProduct.name = name;
                supplementProduct.price = price2;
                this.supplementProductInfo.supplementProducts.add(supplementProduct);
            }

            public void setSupplementProductInfo(String sortType, Integer count, Boolean usable) {
                this.supplementProductInfo = new SupplementProductInfo();
                this.supplementProductInfo.sortType = sortType;
                this.supplementProductInfo.count = count;
                this.supplementProductInfo.usable = usable;
            }

            public void setPurchaseReviewInfo(Boolean purchaseReviewExposure, String reviewUnExposeReason) {
                this.purchaseReviewInfo = new PurchaseReviewInfo();
                this.purchaseReviewInfo.purchaseReviewExposure = purchaseReviewExposure;
                this.purchaseReviewInfo.reviewUnExposeReason = reviewUnExposeReason;
            }

            public void setCustomMadeInfo(Boolean customMade) {
                this.customMadeInfo = new CustomMadeInfo();
                this.customMadeInfo.customMade = customMade;
            }

            public isbnInfo setisbnInfo(boolean independentPublicationYn) {
                this.isbnInfo = new isbnInfo();
                this.isbnInfo.independentPublicationYn = independentPublicationYn;
                return this.isbnInfo;
            }

            public ProductInfoProvidedNotice setProductInfoProvidedNotice(String productInfoProvidedNoticeType) {
                this.productInfoProvidedNotice = new ProductInfoProvidedNotice();
                this.productInfoProvidedNotice.productInfoProvidedNoticeType = productInfoProvidedNoticeType;
                return this.productInfoProvidedNotice;
            }

            public void setCertificationTargetExcludeContent(String kcYn, boolean childYn) {
                this.certificationTargetExcludeContent = new CertificationTargetExcludeContent();
                this.certificationTargetExcludeContent.kcYn = kcYn;
                this.certificationTargetExcludeContent.childYn = childYn;
            }

            public class AfterServiceInfo {
                @JsonProperty(value="afterServiceTelephoneNumber")
                public String afterServiceTelephoneNumber;
                @JsonProperty(value="afterServiceGuideContent")
                public String afterServiceGuideContent;
            }

            public class CertificationTargetExcludeContent {
                @JsonProperty(value="kcYn")
                public String kcYn;
                @JsonProperty(value="childYn")
                public boolean childYn;
            }

            public class CustomMadeInfo {
                @JsonProperty(value="customMade")
                public Boolean customMade;
            }

            @JsonInclude(value=JsonInclude.Include.NON_NULL)
            public class NaverShoppingSearchInfo {
                @JsonProperty(value="manufacturerName")
                public String manufacturerName;
                @JsonProperty(value="modelName")
                public String modelName;
                @JsonProperty(value="brandName")
                public String brandName;
            }

            public class Option {
                @JsonProperty(value="groupName")
                public String groupName;
                @JsonProperty(value="usable")
                public Boolean usable;
                @JsonProperty(value="optionType")
                public String optionType;
                @JsonProperty(value="sortType")
                public String sortType;
            }

            public class OptionCombination {
                @JsonProperty(value="price")
                public Integer price;
                @JsonProperty(value="stockQuantity")
                public String stockQuantity;
                @JsonProperty(value="sellerManagerCode")
                public String sellerManagerCode;
                @JsonProperty(value="usable")
                public Boolean usable;
                @JsonProperty(value="optionType")
                public String optionType;
                @JsonProperty(value="sortType")
                public String sortType;
                @JsonProperty(value="optionName1")
                public String optionName1;
                @JsonProperty(value="optionName2")
                public String optionName2;
                @JsonProperty(value="optionName3")
                public String optionName3;
            }

            public class OptionInfo {
                @JsonProperty(value="optionUsable")
                public Boolean optionUsable;
                @JsonProperty(value="options")
                public List<Option> options = new ArrayList<Option>();
                @JsonProperty(value="optionCombinations")
                public List<OptionCombination> optionCombinations = new ArrayList<OptionCombination>();
                @JsonProperty(value="optionStandards")
                public List<Object> optionStandards = new ArrayList<Object>();
                @JsonProperty(value="optionDeliveryAttributes")
                public List<Object> optionDeliveryAttributes = new ArrayList<Object>();
                @JsonProperty(value="useStockManagement")
                public Boolean useStockManagement;
            }

            public class OriginArea {
                @JsonProperty(value="code")
                public String code;
            }

            public class OriginAreaInfo {
                @JsonProperty(value="type")
                public String type;
                @JsonProperty(value="originArea")
                public OriginArea originArea;
                @JsonProperty(value="content")
                public String content;
            }

            public class ProductInfoProvidedNotice {
                @JsonProperty(value="productInfoProvidedNoticeType")
                public String productInfoProvidedNoticeType;
                @JsonProperty(value="productInfoProvidedNoticeContent")
                public Map<String, String> productInfoProvidedNoticeContent = new HashMap<String, String>();

                public ProductInfoProvidedNotice addContent(String name, String value) {
                    this.productInfoProvidedNoticeContent.put(name, value);
                    return this;
                }
            }

            public class PurchaseQuantityInfo {
                @JsonProperty(value="minPurchaseQuantity")
                public String minPurchaseQuantity;
                @JsonProperty(value="maxPurchaseQuantityPerId")
                public String maxPurchaseQuantityPerId;
                @JsonProperty(value="maxPurchaseQuantityPerOrder")
                public String maxPurchaseQuantityPerOrder;
            }

            public class PurchaseReviewInfo {
                @JsonProperty(value="purchaseReviewExposure")
                public Boolean purchaseReviewExposure;
                @JsonProperty(value="reviewUnExposeReason")
                public String reviewUnExposeReason;
            }

            public class SellerCodeInfo {
                @JsonProperty(value="sellerManagementCode")
                public String sellerManagementCode;
                @JsonProperty(value="sellerBarcode")
                public String sellerBarcode;
                @JsonProperty(value="sellerCustomCode1")
                public String sellerCustomCode1;
                @JsonProperty(value="sellerCustomCode2")
                public String sellerCustomCode2;
            }

            public class SellerTag {
                @JsonProperty(value="text")
                public String text;
            }

            public class SeoInfo {
                @JsonProperty(value="sellerTags")
                public List<SellerTag> sellerTags = new ArrayList<SellerTag>();
                @JsonProperty(value="pageTitle")
                public String pageTitle;
                @JsonProperty(value="metaDescription")
                public String metaDescription;
            }

            public class SupplementProductInfo {
                @JsonProperty(value="sortType")
                public String sortType;
                @JsonProperty(value="count")
                public Integer count;
                @JsonProperty(value="usable")
                public Boolean usable;
                @JsonProperty(value="supplementProducts")
                public List<SupplementProducts> supplementProducts = new ArrayList<SupplementProducts>();
            }

            public class SupplementProducts {
                @JsonProperty(value="stockQuantity")
                public String stockQuantity;
                @JsonProperty(value="sellerManagerCode")
                public String sellerManagerCode;
                @JsonProperty(value="usable")
                public boolean usable;
                @JsonProperty(value="groupName")
                public String groupName;
                @JsonProperty(value="name")
                public String name;
                @JsonProperty(value="price")
                public int price;
            }

            public class isbnInfo {
                @JsonProperty(value="independentPublicationYn")
                public Boolean independentPublicationYn;
            }
        }

        public class DetailContent {
            @JsonProperty(value="editorType")
            public String editorType;
            @JsonProperty(value="editorTypeForEditor")
            public String editorTypeForEditor;
            @JsonProperty(value="existsRemoveTags")
            public Boolean existsRemoveTags;
            @JsonProperty(value="productDetailInfoContent")
            public String productDetailInfoContent;
        }

        public class DiscountMethod {
            @JsonProperty(value="discountUnitType")
            public String discountUnitType;
            @JsonProperty(value="value")
            public String value;
            @JsonProperty(value="startDate")
            public String startDate;
            @JsonProperty(value="endDate")
            public String endDate;

            public DiscountMethod setDiscountUnitType(String discountUnitType) {
                this.discountUnitType = discountUnitType;
                return this;
            }

            public DiscountMethod setValue(String value) {
                this.value = value;
                return this;
            }

            public DiscountMethod setStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public DiscountMethod setEndDate(String endDate) {
                this.endDate = endDate;
                return this;
            }
        }

        public class DiscountMethod_ {
            @JsonProperty(value="discountUnitType")
            public String discountUnitType;
            @JsonProperty(value="value")
            public String value;
            @JsonProperty(value="startDate")
            public String startDate;
            @JsonProperty(value="endDate")
            public String endDate;

            public DiscountMethod_ setDiscountUnitType(String discountUnitType) {
                this.discountUnitType = discountUnitType;
                return this;
            }

            public DiscountMethod_ setValue(String value) {
                this.value = value;
                return this;
            }

            public DiscountMethod_ setStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public DiscountMethod_ setEndDate(String endDate) {
                this.endDate = endDate;
                return this;
            }
        }

        public class FreeInterestPolicy {
            @JsonProperty(value="value")
            public String value;
            @JsonProperty(value="startDate")
            public String startDate;
            @JsonProperty(value="endDate")
            public String endDate;
        }

        public class Image {
            @JsonProperty(value="imageType")
            public String imageType;
            @JsonProperty(value="order")
            public Integer order;
            @JsonProperty(value="imageUrl")
            public String imageUrl;
            @JsonProperty(value="width")
            public Integer width;
            @JsonProperty(value="height")
            public Integer height;
            @JsonProperty(value="fileSize")
            public Integer fileSize;
        }

        public class ImmediateDiscountPolicy {
            @JsonProperty(value="discountMethod")
            public DiscountMethod discountMethod;
            @JsonProperty(value="mobileDiscountMethod")
            public MobileDiscountMethod mobileDiscountMethod;
        }

        public class MobileDiscountMethod {
            @JsonProperty(value="discountUnitType")
            public String discountUnitType;
            @JsonProperty(value="value")
            public String value;
            @JsonProperty(value="startDate")
            public String startDate;
            @JsonProperty(value="endDate")
            public String endDate;

            public MobileDiscountMethod setDiscountUnitType(String discountUnitType) {
                this.discountUnitType = discountUnitType;
                return this;
            }

            public MobileDiscountMethod setValue(String value) {
                this.value = value;
                return this;
            }

            public MobileDiscountMethod setStartDate(String startDate) {
                this.startDate = startDate;
                return this;
            }

            public MobileDiscountMethod setEndDate(String endDate) {
                this.endDate = endDate;
                return this;
            }
        }

        public class ModAuditInfo {
            @JsonProperty(value="memberNo")
            public Number memberNo;
            @JsonProperty(value="loginId")
            public String loginId;
            @JsonProperty(value="name")
            public String name;
            @JsonProperty(value="memberType")
            public String memberType;
            @JsonProperty(value="ip")
            public String ip;
            @JsonProperty(value="requestId")
            public String requestId;
            @JsonProperty(value="adminViewText")
            public String adminViewText;
        }

        public class MultiPurchaseDiscountPolicy {
            @JsonProperty(value="orderUnitType")
            public String orderUnitType;
            @JsonProperty(value="discountMethod")
            public DiscountMethod_ discountMethod;
            @JsonProperty(value="orderValue")
            public String orderValue;
        }

        public class ProductStats {
            String key;
        }

        public class Promise {
            String key;
        }

        public class PurchasePointPolicy {
            @JsonProperty(value="benefitUnitType")
            public String benefitUnitType;
            @JsonProperty(value="value")
            public String value;
            @JsonProperty(value="startDate")
            public String startDate;
            @JsonProperty(value="endDate")
            public String endDate;
        }

        public class RegAuditInfo {
            @JsonProperty(value="memberNo")
            public Number memberNo;
            @JsonProperty(value="loginId")
            public String loginId;
            @JsonProperty(value="name")
            public String name;
            @JsonProperty(value="memberType")
            public String memberType;
            @JsonProperty(value="ip")
            public String ip;
            @JsonProperty(value="requestId")
            public String requestId;
            @JsonProperty(value="adminViewText")
            public String adminViewText;
        }

        public class ReturnAddress {
            @JsonProperty(value="id")
            public Integer id;
            @JsonProperty(value="accountNo")
            public Integer accountNo;
            @JsonProperty(value="alias")
            public String alias;
            @JsonProperty(value="addressType")
            public String addressBookType;
            @JsonProperty(value="addressInfo")
            public AddressInfo_ addressInfo;
            @JsonProperty(value="isOverseas")
            public Boolean isOverseas;
            @JsonProperty(value="isDelete")
            public Boolean isDelete;

            public ReturnAddress setId(Integer id) {
                this.id = id;
                return this;
            }

            public ReturnAddress setAccountNo(Integer accountNo) {
                this.accountNo = accountNo;
                return this;
            }

            public ReturnAddress setAlias(String alias) {
                this.alias = alias;
                return this;
            }

            public ReturnAddress setAddressBookType(String addressBookType) {
                this.addressBookType = addressBookType;
                return this;
            }

            public ReturnAddress setOverseas(Boolean overseas) {
                this.isOverseas = overseas;
                return this;
            }

            public ReturnAddress setIsDelete(Boolean isDelet) {
                this.isDelete = isDelet;
                return this;
            }
        }

        public class ReturnDeliveryCompany {
            @JsonProperty(value="regDate")
            public String regDate;
            @JsonProperty(value="modDate")
            public String modDate;
            @JsonProperty(value="regAuditInfo")
            public RegAuditInfo regAuditInfo;
            @JsonProperty(value="modAuditInfo")
            public ModAuditInfo modAuditInfo;
            @JsonProperty(value="id")
            public Integer id;
            @JsonProperty(value="accountNo")
            public Integer accountNo;
            @JsonProperty(value="returnDeliveryCompanyPriorityType")
            public String returnDeliveryCompanyPriorityType;
            @JsonProperty(value="naverPayAppointment")
            public Boolean naverPayAppointment;
            @JsonProperty(value="deliveryCompanyName")
            public String deliveryCompanyName;

            public ReturnDeliveryCompany setRegAuditInfo(Long memberNo, String loginId, String name, String memberType, String ip, String requestId, String adminViewText) {
                this.regAuditInfo = new RegAuditInfo();
                this.regAuditInfo.memberNo = memberNo;
                this.regAuditInfo.loginId = loginId;
                this.regAuditInfo.name = name;
                this.regAuditInfo.memberType = memberType;
                this.regAuditInfo.ip = ip;
                this.regAuditInfo.requestId = requestId;
                this.regAuditInfo.adminViewText = adminViewText;
                this.modAuditInfo = new ModAuditInfo();
                this.modAuditInfo.memberNo = memberNo;
                this.modAuditInfo.loginId = loginId;
                this.modAuditInfo.name = name;
                this.modAuditInfo.memberType = memberType;
                this.modAuditInfo.ip = ip;
                this.modAuditInfo.requestId = requestId;
                this.modAuditInfo.adminViewText = adminViewText;
                return this;
            }

            public ReturnDeliveryCompany setRegDate(String regDate) {
                this.regDate = regDate;
                return this;
            }

            public ReturnDeliveryCompany setModDate(String modDate) {
                this.modDate = modDate;
                return this;
            }

            public ReturnDeliveryCompany setId(Integer id) {
                this.id = id;
                return this;
            }

            public ReturnDeliveryCompany setAccountNo(Integer accountNo) {
                this.accountNo = accountNo;
                return this;
            }

            public ReturnDeliveryCompany setReturnDeliveryCompanyPriorityType(String returnDeliveryCompanyPriorityType) {
                this.returnDeliveryCompanyPriorityType = returnDeliveryCompanyPriorityType;
                return this;
            }

            public ReturnDeliveryCompany setNaverPayAppointment(Boolean naverPayAppointment) {
                this.naverPayAppointment = naverPayAppointment;
                return this;
            }

            public ReturnDeliveryCompany setDeliveryCompanyName(String deliveryCompanyName) {
                this.deliveryCompanyName = deliveryCompanyName;
                return this;
            }
        }

        public class ReviewPointPolicy {
            @JsonProperty(value="textReviewPoint")
            public String textReviewPoint;
            @JsonProperty(value="photoVideoReviewPoint")
            public String photoVideoReviewPoint;
            @JsonProperty(value="afterUseTextReviewPoint")
            public String afterUseTextReviewPoint;
            @JsonProperty(value="afterUsePhotoVideoReviewPoint")
            public String afterUsePhotoVideoReviewPoint;
            @JsonProperty(value="storeMemberReviewPoint")
            public String storeMemberReviewPoint;
            @JsonProperty(value="startDate")
            public String startDate;
            @JsonProperty(value="endDate")
            public String endDate;
        }

        public class ShippingAddress {
            @JsonProperty(value="id")
            public Integer id;
            @JsonProperty(value="accountNo")
            public Integer accountNo;
            @JsonProperty(value="alias")
            public String alias;
            @JsonProperty(value="addressType")
            public String addressBookType;
            @JsonProperty(value="addressInfo")
            public AddressInfo addressInfo;
            @JsonProperty(value="isOverseas")
            public Boolean isOverseas;
            @JsonProperty(value="isDelete")
            public Boolean isDelete;

            public ShippingAddress setId(Integer id) {
                this.id = id;
                return this;
            }

            public ShippingAddress setAccountNo(Integer accountNo) {
                this.accountNo = accountNo;
                return this;
            }

            public ShippingAddress setAlias(String alias) {
                this.alias = alias;
                return this;
            }

            public ShippingAddress setAddressBookType(String addressBookType) {
                this.addressBookType = addressBookType;
                return this;
            }

            public ShippingAddress setOverseas(Boolean overseas) {
                this.isOverseas = overseas;
                return this;
            }

            public ShippingAddress setIsDelete(Boolean isDelet) {
                this.isDelete = isDelet;
                return this;
            }
        }

        public class SpecialDiscountPolicies {
            public String specialDiscountType;
            public DiscountMethod_ discountMethod;
        }
    }

    public static class ProductJSONCreate {
        @JsonProperty(value="product")
        Product productReg;
        @JsonProperty(value="savedTemplate")
        public SavedTemplate savedTemplate = new SavedTemplate();
        @JsonProperty(value="singleChannelProductMap")
        public SingleChannelProductMap singleChannelProductMap;
        @JsonProperty(value="representNo")
        public Integer representNo;
        @JsonProperty(value="representName")
        public String representName;
        @JsonProperty(value="representType")
        public String representType;
        @JsonProperty(value="productRegistAuthCategories")
        public List<String> productRegistAuthCategories = new ArrayList<String>();
        @JsonProperty(value="accountNo")
        public Integer accountNo;
        @JsonProperty(value="accountId")
        public String accountId;
        @JsonProperty(value="advertiser")
        public Boolean advertiser;
        @JsonProperty(value="mallSeq")
        public Integer mallSeq;
        @JsonProperty(value="defaultChannelNo")
        public Integer defaultChannelNo;
        @JsonProperty(value="accountExternalStatusType")
        public String accountExternalStatusType;
        @JsonProperty(value="npayRefKey")
        public String npayRefKey;
        @JsonProperty(value="payUseYn")
        public Boolean payUseYn;
        @JsonProperty(value="actionGrade")
        public String actionGrade;
        @JsonProperty(value="branchUseYn")
        public Boolean branchUseYn;
        @JsonProperty(value="sellerNo")
        public Integer sellerNo;
        @JsonProperty(value="ownerChannelInfoList")
        public List<OwnerChannelInfoList> ownerChannelInfoList = new ArrayList<OwnerChannelInfoList>();
        @JsonProperty(value="thisDayDispatchBasisHour")
        public Integer thisDayDispatchBasisHour;
        @JsonProperty(value="thisDayDispatchBasisMinute")
        public Integer thisDayDispatchBasisMinute;
        @JsonProperty(value="holidayOfTheWeek")
        public String holidayOfTheWeek;
        @JsonProperty(value="sellerHolidayList")
        public List<String> sellerHolidayList = new ArrayList<String>();
        @JsonProperty(value="enforcedPermitPreOrderConfig")
        public Boolean enforcedPermitPreOrderConfig;
        @JsonProperty(value="overseas")
        public Boolean overseas;
        @JsonProperty(value="hasTalkTalkChannel")
        public Boolean hasTalkTalkChannel;
        @JsonProperty(value="epOperable")
        public Boolean epOperable;
        @JsonProperty(value="epNaverShoppingOperable")
        public Boolean epNaverShoppingOperable;
        @JsonProperty(value="creatableChannelInfoListMap")
        public CreatableChannelInfoListMap creatableChannelInfoListMap;
        @JsonProperty(value="updatableChannelInfoListMap")
        public UpdatableChannelInfoListMap updatableChannelInfoListMap;
        @JsonProperty(value="epEnuriOperable")
        public Boolean epEnuriOperable;
        @JsonProperty(value="epDanawaOperable")
        public Boolean epDanawaOperable;
        @JsonProperty(value="searchableChannelInfoListMap")
        public SearchableChannelInfoListMap searchableChannelInfoListMap;
        @JsonProperty(value="adult")
        public Boolean adult;

        public Product getProduct() {
            if (this.productReg == null) {
                this.productReg = new Product();
            }
            return this.productReg;
        }

        public SingleChannelProductMap getSingleChannelProductMap() {
            if (this.singleChannelProductMap == null) {
                this.singleChannelProductMap = new SingleChannelProductMap();
            }
            return this.singleChannelProductMap;
        }

        public void setProductRegistAuthCategories(String val) {
            this.productRegistAuthCategories.add(val);
        }

        public OwnerChannelInfoList setOwnerChannelInfoList() {
            OwnerChannelInfoList ownerChannelInfo = new OwnerChannelInfoList();
            this.ownerChannelInfoList.add(ownerChannelInfo);
            return ownerChannelInfo;
        }

        public STOREFARM_ setCreatableChannelInfoListMap() {
            if (this.creatableChannelInfoListMap == null) {
                this.creatableChannelInfoListMap = new CreatableChannelInfoListMap();
            }
            STOREFARM_ storefarm_ = new STOREFARM_();
            this.creatableChannelInfoListMap.sTOREFARM.add(storefarm_);
            return storefarm_;
        }

        public STOREFARM_ setUpdatableChannelInfoListMap() {
            if (this.updatableChannelInfoListMap == null) {
                this.updatableChannelInfoListMap = new UpdatableChannelInfoListMap();
            }
            STOREFARM_ storefarm_ = new STOREFARM_();
            this.updatableChannelInfoListMap.sTOREFARM.add(storefarm_);
            return storefarm_;
        }

        public STOREFARM_ setSearchableChannelInfoListMap() {
            if (this.searchableChannelInfoListMap == null) {
                this.searchableChannelInfoListMap = new SearchableChannelInfoListMap();
            }
            STOREFARM_ storefarm_ = new STOREFARM_();
            this.searchableChannelInfoListMap.sTOREFARM.add(storefarm_);
            return storefarm_;
        }

        public class SavedTemplate {
            @JsonProperty(value="EVENT_PHRASE")
            public Boolean eVENTPHRASE = false;
        }
    }

    public static class STOREFARM_ {
        @JsonProperty(value="id")
        public Integer id;
        @JsonProperty(value="channelServiceType")
        public String channelServiceType;
        @JsonProperty(value="accountNo")
        public Integer accountNo;
        @JsonProperty(value="type")
        public String type;
        @JsonProperty(value="name")
        public String name;
        @JsonProperty(value="url")
        public String url;
        @JsonProperty(value="channelExternalStatusType")
        public String channelExternalStatusType;
        @JsonProperty(value="payUseYn")
        public Boolean payUseYn;
        @JsonProperty(value="talkAccountId")
        public String talkAccountId;
        @JsonProperty(value="talkExposure")
        public Boolean talkExposure;
        @JsonProperty(value="subVerticalServiceTypes")
        public List<Object> subVerticalServiceTypes = new ArrayList<Object>();
        @JsonProperty(value="fullUrl")
        public String fullUrl;
        @JsonProperty(value="mobileUrl")
        public String mobileUrl;

        public STOREFARM_ setId(Integer id) {
            this.id = id;
            return this;
        }

        public STOREFARM_ setChannelServiceType(String channelServiceType) {
            this.channelServiceType = channelServiceType;
            return this;
        }

        public STOREFARM_ setAccountNo(Integer accountNo) {
            this.accountNo = accountNo;
            return this;
        }

        public STOREFARM_ setType(String type) {
            this.type = type;
            return this;
        }

        public STOREFARM_ setName(String name) {
            this.name = name;
            return this;
        }

        public STOREFARM_ setUrl(String url) {
            this.url = url;
            return this;
        }

        public STOREFARM_ setChannelExternalStatusType(String channelExternalStatusType) {
            this.channelExternalStatusType = channelExternalStatusType;
            return this;
        }

        public STOREFARM_ setPayUseYn(Boolean payUseYn) {
            this.payUseYn = payUseYn;
            return this;
        }

        public STOREFARM_ setTalkAccountId(String talkAccountId) {
            this.talkAccountId = talkAccountId;
            return this;
        }

        public STOREFARM_ setTalkExposure(Boolean talkExposure) {
            this.talkExposure = talkExposure;
            return this;
        }

        public STOREFARM_ setSubVerticalServiceTypes(List<Object> subVerticalServiceTypes) {
            this.subVerticalServiceTypes = subVerticalServiceTypes;
            return this;
        }

        public STOREFARM_ setFullUrl(String fullUrl) {
            this.fullUrl = fullUrl;
            return this;
        }

        public STOREFARM_ setMobileUrl(String mobileUrl) {
            this.mobileUrl = mobileUrl;
            return this;
        }
    }

    public static class SearchableChannelInfoListMap {
        @JsonProperty(value="STOREFARM")
        public List<STOREFARM_> sTOREFARM = new ArrayList<STOREFARM_>();
    }

    public static class SingleChannelProductMap {
        @JsonProperty(value="STOREFARM")
        public STOREFARM sTOREFARM;

        private STOREFARM getSTOREFARM() {
            if (this.sTOREFARM == null) {
                this.sTOREFARM = new STOREFARM();
            }
            return this.sTOREFARM;
        }

        public EpInfo setEpInfo() {
            if (this.getSTOREFARM().epInfo == null) {
                this.getSTOREFARM().epInfo = new EpInfo();
            }
            return this.getSTOREFARM().epInfo;
        }

        public void setAffiliateInfo(Boolean affiliateYn) {
            this.getSTOREFARM().affiliateInfo = new AffiliateInfo();
            this.getSTOREFARM().affiliateInfo.affiliateYn = affiliateYn;
        }

        public class AffiliateInfo {
            @JsonProperty(value="affiliateYn")
            public Boolean affiliateYn;
        }

        public class EpInfo {
            @JsonProperty(value="naverShoppingRegistration")
            public Boolean naverShoppingRegistration;
            @JsonProperty(value="enuriRegistration")
            public Boolean enuriRegistration;
            @JsonProperty(value="danawaRegistration")
            public Boolean danawaRegistration;
            @JsonProperty(value="naverDisabled")
            public Boolean naverDisabled;
            @JsonProperty(value="enuriDisabled")
            public Boolean enuriDisabled;
            @JsonProperty(value="danawaDisabled")
            public Boolean danawaDisabled;
            @JsonProperty(value="disabledAll")
            public Boolean disabledAll;

            public EpInfo setNaverShoppingRegistration(Boolean naverShoppingRegistration) {
                this.naverShoppingRegistration = naverShoppingRegistration;
                return this;
            }

            public EpInfo setEnuriRegistration(Boolean enuriRegistration) {
                this.enuriRegistration = enuriRegistration;
                return this;
            }

            public EpInfo setDanawaRegistration(Boolean danawaRegistration) {
                this.danawaRegistration = danawaRegistration;
                return this;
            }

            public EpInfo setNaverDisabled(Boolean naverDisabled) {
                this.naverDisabled = naverDisabled;
                return this;
            }

            public EpInfo setEnuriDisabled(Boolean enuriDisabled) {
                this.enuriDisabled = enuriDisabled;
                return this;
            }

            public EpInfo setDanawaDisabled(Boolean danawaDisabled) {
                this.danawaDisabled = danawaDisabled;
                return this;
            }

            public EpInfo setDisabledAll(Boolean disabledAll) {
                this.disabledAll = disabledAll;
                return this;
            }
        }

        public class STOREFARM {
            @JsonProperty(value="id")
            public String id;
            @JsonProperty(value="selfProductNameUsable")
            public Boolean selfProductNameUsable;
            @JsonProperty(value="channelProductName")
            public String channelProductName;
            @JsonProperty(value="channelServiceType")
            public String channelServiceType;
            @JsonProperty(value="channelProductType")
            public String channelProductType;
            @JsonProperty(value="channel")
            public Object channel;
            @JsonProperty(value="epInfo")
            public EpInfo epInfo;
            @JsonProperty(value="channelProductDisplayStatusType")
            public String channelProductDisplayStatusType;
            @JsonProperty(value="channelProductStatusType")
            public String channelProductStatusType;
            @JsonProperty(value="storeKeepExclusiveProduct")
            public Boolean storeKeepExclusiveProduct;
            @JsonProperty(value="orderRequestUsable")
            public Boolean orderRequestUsable;
            @JsonProperty(value="best")
            public Boolean best;
            @JsonProperty(value="bbsConfig")
            public Boolean bbsConfig;
            @JsonProperty(value="materialImages")
            public List<Object> materialImages = new ArrayList<Object>();
            @JsonProperty(value="tagImages")
            public List<Object> tagImages = new ArrayList<Object>();
            @JsonProperty(value="barcodeImage")
            public Object barcodeImage;
            @JsonProperty(value="affiliateInfo")
            public AffiliateInfo affiliateInfo;
            @JsonProperty(value="channelNo")
            public Integer channelNo;

            public STOREFARM setId(String id) {
                this.id = id;
                return this;
            }

            public STOREFARM setSelfProductNameUsable(Boolean selfProductNameUsable) {
                this.selfProductNameUsable = selfProductNameUsable;
                return this;
            }

            public STOREFARM setChannelProductName(String channelProductName) {
                this.channelProductName = channelProductName;
                return this;
            }

            public STOREFARM setChannelServiceType(String channelServiceType) {
                this.channelServiceType = channelServiceType;
                return this;
            }

            public STOREFARM setChannelProductType(String channelProductType) {
                this.channelProductType = channelProductType;
                return this;
            }

            public STOREFARM setChannel(Object channel) {
                this.channel = channel;
                return this;
            }

            public STOREFARM setEpInfo(EpInfo epInfo) {
                this.epInfo = epInfo;
                return this;
            }

            public STOREFARM setChannelProductDisplayStatusType(String channelProductDisplayStatusType) {
                this.channelProductDisplayStatusType = channelProductDisplayStatusType;
                return this;
            }

            public STOREFARM setChannelProductStatusType(String channelProductStatusType) {
                this.channelProductStatusType = channelProductStatusType;
                return this;
            }

            public STOREFARM setStoreKeepExclusiveProduct(Boolean storeKeepExclusiveProduct) {
                this.storeKeepExclusiveProduct = storeKeepExclusiveProduct;
                return this;
            }

            public STOREFARM setOrderRequestUsable(Boolean orderRequestUsable) {
                this.orderRequestUsable = orderRequestUsable;
                return this;
            }

            public STOREFARM setBest(Boolean best) {
                this.best = best;
                return this;
            }

            public STOREFARM setBbsConfig(Boolean bbsConfig) {
                this.bbsConfig = bbsConfig;
                return this;
            }

            public STOREFARM setMaterialImages(List<Object> materialImages) {
                this.materialImages = materialImages;
                return this;
            }

            public STOREFARM setTagImages(List<Object> tagImages) {
                this.tagImages = tagImages;
                return this;
            }

            public STOREFARM setBarcodeImage(Object barcodeImage) {
                this.barcodeImage = barcodeImage;
                return this;
            }

            public STOREFARM setAffiliateInfo(AffiliateInfo affiliateInfo) {
                this.affiliateInfo = affiliateInfo;
                return this;
            }

            public STOREFARM setChannelNo(Integer channelNo) {
                this.channelNo = channelNo;
                return this;
            }
        }
    }

    public static class UpdatableChannelInfoListMap {
        @JsonProperty(value="STOREFARM")
        public List<STOREFARM_> sTOREFARM = new ArrayList<STOREFARM_>();
    }
}

