/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.ssgmarket;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kdjsystem.mlink.shop.common.IShopOrderCommand;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.ssgmarket.IShopSSGOrderCommand;
import com.kdjsystem.mlink.shop.data.ssgmarket.SSGOrderDto;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SSGOrderConfirmCommand
extends IShopSSGOrderCommand {
    private static IShopOrderCommand instance = new SSGOrderConfirmCommand();
    private static final String Host = "https://eapi.ssgadm.com";

    public static IShopOrderCommand getInstance() {
        return instance;
    }

    private SSGOrderConfirmCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        ObjectMapper mapper = new ObjectMapper();
        try {
            for (ShopOrderMstDto dto : param) {
                String json = this.setRequestParams(dto);
                OkHttpClient client = new OkHttpClient().newBuilder().build();
                MediaType mediaType = MediaType.parse((String)"");
                RequestBody body = RequestBody.create((MediaType)mediaType, (String)json);
                Request request2 = new Request.Builder().url(Host.concat("/api/pd/1/updateOrderSubjectManage.ssg")).method("POST", body).addHeader("Authorization", param.get(0).getApikey()).addHeader("accept", "application/json").addHeader("Content-Type", "application/json").build();
                try {
                    Throwable throwable = null;
                    Object var12_15 = null;
                    try (Response response = client.newCall(request2).execute();){
                        SSGOrderDto.ResponseBody responseBody = (SSGOrderDto.ResponseBody)mapper.readValue(response.body().string().toString(), SSGOrderDto.ResponseBody.class);
                        if (responseBody.getResult().getResultCode().equals("00")) {
                            dto.setResult_code("1");
                            dto.setOrder_status("100");
                        } else {
                            dto.setResult_code("-1");
                            dto.setResult_text(responseBody.getResult().getResultDesc());
                        }
                        retList.add(dto);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    throw new Exception(e);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return retList;
    }

    private String setRequestParams(ShopOrderMstDto dto) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        String json = "";
        try {
            SSGOrderDto.ReqOrderSubjectManager reqOrderSubjectManager = new SSGOrderDto.ReqOrderSubjectManager();
            reqOrderSubjectManager.requestOrderSubjectManage = new SSGOrderDto.ReqOrderSubjectManager.RequestOrderSubjectManage();
            reqOrderSubjectManager.requestOrderSubjectManage.shppNo = dto.getCopy_idx();
            reqOrderSubjectManager.requestOrderSubjectManage.shppSeq = dto.getMall_exp_cd();
            mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            json = mapper.writeValueAsString((Object)reqOrderSubjectManager);
        }
        catch (Exception e) {
            throw new Exception("\uc8fc\ubb38\ud655\uc778 \ub370\uc774\ud130 \uc785\ub825\uc2dc \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4." + String.valueOf(e));
        }
        return json;
    }
}

