/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.tossShopping;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.data.tossShopping.ShopTossShoppingQuestionContext;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.QuestListDto;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class ShopTossShoppingQuestionSearch
extends ShopTossShoppingQuestionContext {
    @Override
    public List<QuestListDto> excute(List<QuestListDto> prodList) throws Exception {
        ArrayList<QuestListDto> dtoArray = new ArrayList<QuestListDto>();
        IShopCommonLogin is = new IShopCommonLogin(){};
        Map<Object, Object> cookies = new HashMap();
        cookies = is.getTossCookies(prodList.get(0).getShopid(), prodList.get(0).getShopPw());
        JsonObject requestBody = new JsonObject();
        requestBody.addProperty("page", (Number)1);
        requestBody.addProperty("pageSize", (Number)50);
        JsonArray statuses = new JsonArray();
        statuses.add("READY");
        requestBody.add("statuses", (JsonElement)statuses);
        JsonArray types = new JsonArray();
        requestBody.add("types", (JsonElement)types);
        requestBody.addProperty("merchantId", prodList.get(0).getApikey());
        Connection.Response response = Jsoup.connect((String)"https://shopping-merchant-api.toss.im/api-public/v3/shopping-merchant/product/inquiry/all").header("Content-Type", "application/json").requestBody(requestBody.toString()).cookies(cookies).method(Connection.Method.POST).ignoreContentType(true).execute();
        JsonParser parser = new JsonParser();
        JsonObject jsonResponse = parser.parse(response.body()).getAsJsonObject();
        JsonObject successObject = jsonResponse.getAsJsonObject("success");
        JsonArray inquiries = successObject.getAsJsonArray("inquiries");
        int i = 0;
        while (i < inquiries.size()) {
            JsonObject inquiry = inquiries.get(i).getAsJsonObject();
            QuestListDto dto = new QuestListDto();
            dto.setSubject(inquiry.get("inquiryType").getAsString());
            dto.setQnaseq(inquiry.get("id").getAsString());
            dto.setStat(inquiry.get("inquiryType").getAsString());
            dto.setQgubun(inquiry.get("inquiryType").getAsString());
            dto.setRegdm(YDMATimeUtil.getCurrentTime());
            dto.setShopid(prodList.get(0).getShopid());
            dto.setShopnm(prodList.get(0).getShopnm());
            dto.setInsnm(inquiry.get("userName").getAsString());
            dto.setInsdm(this.convertDateFormat(inquiry.get("createdAt").getAsString()));
            dto.setQuests(inquiry.get("inquiryText").getAsString());
            dto.setMprodid(inquiry.get("productId").getAsString());
            dto.setProdnm(inquiry.get("productName").getAsString());
            dto.setOrdid(inquiry.has("orderId") && !inquiry.get("orderId").isJsonNull() ? inquiry.get("orderId").getAsString() : "");
            String str = inquiry.get("inquiryStatus").getAsString();
            String qst_stat = str.equals("READY") ? "\ubbf8\ub2f5\ubcc0" : "\ub2f5\ubcc0\uc644\ub8cc";
            dto.setQnastat(this.getExcellFileManager(qst_stat));
            dtoArray.add(dto);
            ++i;
        }
        return dtoArray;
    }

    public String getExcellFileManager(String status2) throws Exception {
        String value = "";
        try {
            switch (status2) {
                case "\ubbf8\ub2f5\ubcc0": {
                    value = "100";
                    break;
                }
                case "1": {
                    value = "101";
                    break;
                }
                case "2": {
                    value = "102";
                    break;
                }
                case "3": {
                    value = "104";
                    break;
                }
                case "\ub2f5\ubcc0\uc644\ub8cc": {
                    value = "103";
                }
            }
        }
        catch (Exception exception) {
            throw new Exception("\ud1a0\uc2a4\uc1fc\ud551 \uc5d1\uc140\ud30c\uc77c \uc0c1\ud0dc\uac12 \ubcc0\uacbd\ud558\ub294\uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd \ud588\uc2b5\ub2c8\ub2e4.");
        }
        return value;
    }

    private String convertDateFormat(String dateStr) {
        try {
            SimpleDateFormat inputFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX");
            Date date = inputFormat.parse(dateStr);
            SimpleDateFormat outputFormat = new SimpleDateFormat("yyyyMMdd");
            return outputFormat.format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }
}

