/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.jobLog;

import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ProductSchedulerSyncDTO;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductShortDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.jobLog.JobLogDTO;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.dao.ShoppingMallDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JobLogHelper {
    public static final String \uc0c1\ud488 = "PROD";
    public static final String \uc8fc\ubb38 = "ORD";
    public static final String \ubb38\uc758 = "QNA";
    public static final String \uc610\ub9bc = "YEL";
    public static final String \uc218\uc2e0 = "RECV";
    public static final String \ub4f1\ub85d = "REG";
    public static final String \uc218\uc815 = "MODI";
    public static final String \uc0ad\uc81c = "DEL";
    public static final String \uc218\uc9d1 = "COLLECT";
    public static final String \ud655\uc778 = "CONFIRM";
    public static final String \ub3d9\uae30\ud654 = "SYNC";
    public static final String \ub3c4\ub9e4\uc8fc\ubb38 = "DOME_SEND";
    public static final String \ub3c4\ub9e4\uc218\uc9d1 = "DOME_COLLECT";
    public static final String \ubc1c\uc1a1 = "DELV_SEND";
    public static final String \ucd94\uac00 = "ADD";
    public static final String \ub3c4\ub9e4\ubab0\uc218\uc815 = "DOME_MODI";
    public static final String \ub3c4\ub9e4\ub3d9\uae30\ud654 = "DOME_SYNC";
    public static final String \uc5d1\uc140 = "EXCEL";
    public static final String \uac80\uc0c9 = "SEARCH";
    public static final String \uc2a4\ucf00\uc974\ub7ec = "SCHEDULER";
    public static final String \uc0c1\ud488\uc218\uc2e0 = "PROD_RECV";
    public static final String \uc0c1\ud488\ub4f1\ub85d = "PROD_REG";
    public static final String \uc0c1\ud488\uc218\uc815 = "PROD_MODI";
    public static final String \uc0c1\ud488\uc0ad\uc81c = "PROD_DEL";
    public static final String \uc0c1\ud488\ub3d9\uae30\ud654 = "PROD_SYNC";
    public static final String \uc8fc\ubb38\uc218\uc9d1 = "ORD_COLLECT";
    public static final String \uc8fc\ubb38\ud655\uc778 = "ORD_CONFIRM";
    public static final String \uc8fc\ubb38\ub3d9\uae30\ud654 = "ORD_SYNC";
    public static final String \uc8fc\ubb38_\ub3c4\ub9e4\uc8fc\ubb38 = "ORD_DOME_SEND";
    public static final String \uc8fc\ubb38_\ub3c4\ub9e4\uc218\uc9d1 = "ORD_DOME_COLLECT";
    public static final String \uc8fc\ubb38_\ub3c4\ub9e4\ub3d9\uae30\ud654 = "ORD_DOME_SYNC";
    public static final String \uc8fc\ubb38\ubc1c\uc1a1 = "ORD_DELV_SEND";
    public static final String \ubb38\uc758\uc218\uc9d1 = "QNA_NEW";
    public static final String \ubb38\uc758\ub2f5\ubcc0 = "QNA_SEND";
    public static final String \uc610\ub9bc\ucd94\uac00 = "YEL_ADD";
    public static final String \uc610\ub9bc\uc0ad\uc81c = "YEL_DEL";
    public static final String \uc610\ub9bc\uc218\uc815 = "YEL_MODI";
    public static final String \uc610\ub9bc\ub3c4\ub9e4\ubab0\uc218\uc815 = "YEL_DOME_MODI";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\ub3d9\uae30\ud654 = "[\uc2a4\ucf00\uc974\ub7ec] \ub3d9\uae30\ud654 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\ud488\ub2e8\uc885 = "[\uc2a4\ucf00\uc974\ub7ec] \ud488\ub2e8\uc885 \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc0c1\ud0dc\ubcc0\uacbd = "[\uc2a4\ucf00\uc974\ub7ec] \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\uc544\uc774\ud15c\uc704\ub108 = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \uc544\uc774\ud15c\uc704\ub108\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\uc544\uc774\ud15c\uc704\ub108_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \uc544\uc774\ud15c\uc704\ub108\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\ubc18\ub824 = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \ubc18\ub824\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\ubc18\ub824_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \ubc18\ub824\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\ub178\ucd9c\uc81c\ud55c = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \ub178\ucd9c\uc81c\ud55c\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\ub178\ucd9c\uc81c\ud55c_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \ub178\ucd9c\uc81c\ud55c\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\uce74\ud0c8\ub85c\uadf8 = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \uce74\ud0c8\ub85c\uadf8\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\uce74\ud0c8\ub85c\uadf8_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \uce74\ud0c8\ub85c\uadf8\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc885\ub8cc = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc885\ub8cc\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc885\ub8cc_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc885\ub8cc\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc911\uc9c0 = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc911\uc9c0_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ud1a0\uc2a4_\ubc18\ub824 = "[\uc2a4\ucf00\uc974\ub7ec] \ud1a0\uc2a4 \ubc18\ub824\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ud1a0\uc2a4_\ubc18\ub824_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \ud1a0\uc2a4 \ubc18\ub824\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\uc911\ubcf5\ub4f1\ub85d = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \uc911\ubcf5\ub4f1\ub85d\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\uc911\ubcf5\ub4f1\ub85d_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \uc911\ubcf5\ub4f1\ub85d\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\ud074\ub9b0\ub300\uc0c1 = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \ud074\ub9b0\ub300\uc0c1\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\ud074\ub9b0\ub300\uc0c1_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \ud074\ub9b0\ub300\uc0c1\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\ud310\ub9e4\uc911\uc9c0 = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\ud310\ub9e4\uc911\uc9c0_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ud1a1\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc911\uc9c0 = "[\uc2a4\ucf00\uc974\ub7ec] \ud1a1\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ud1a1\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc911\uc9c0_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \ud1a1\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ud310\ub9e4\uc911\uc9c0\ucc98\ub9ac_\uc1fc\ud551\ubab0 = "[\uc2a4\ucf00\uc974\ub7ec] \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc6b0\ud074\ub9ad\uc0ad\uc81c = "[\uc0ad\uc81c] \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uac15\uc81c\uc0ad\uc81c = "[\uac15\uc81c\uc0ad\uc81c] \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uac80\uc0c9\uc870\uac74\uc0ad\uc81c = "[\uac80\uc0c9\uc870\uac74\uc0ad\uc81c] \uc0c1\ud488\uc774 \uc0ad\uc81c\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc0c1\ud488\uc2a4\ucf00\uc974\ub7ec\uc218\uc2e0\uc644\ub8cc = "[\uc2a4\ucf00\uc974\ub7ec] \uc0c1\ud488\uc218\uc2e0\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc0c1\ud488\uc218\uc2e0\uc644\ub8cc = "\uc0c1\ud488\uc218\uc2e0\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc0c1\ud488\uc5d1\uc140\uc218\uc2e0\uc644\ub8cc = "[\uc5d1\uc140 \uc5c5\ub85c\ub4dc] \uc0c1\ud488\uc218\uc2e0\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc0c1\ud488\uac80\uc0c9\uc218\uc2e0\uc644\ub8cc = "[\uc0c1\ud488\uac80\uc0c9] \uc0c1\ud488\uc218\uc2e0\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc0c1\ud488\uc218\uc815\uc644\ub8cc = "\uc0c1\ud488\uc218\uc815\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc0c1\ud488\uc0c1\ud0dc\ubcc0\uacbd\uc644\ub8cc = "\uc0c1\ud488 \uc0c1\ud0dc \ubcc0\uacbd\uc774 \uc644\ub8cc\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
    public static final String \uc2e4\ud328 = "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";

    public static JobLogDTO createJobLogForDome(ProductItemDto ProductItem, String jobType, String jobDetail, String jobResult) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setJobDetail(jobDetail);
        dto.setProdCd(ProductItem != null ? ProductItem.getIcode() : "");
        dto.setJobResult(jobResult);
        if (jobType.equals(\uc0c1\ud488\uc218\uc2e0)) {
            dto.setLogMessage(JobLogHelper.setDomeLogMsg(jobDetail));
        } else {
            dto.setLogMessage(\uc0c1\ud488\uc218\uc815\uc644\ub8cc);
        }
        return dto;
    }

    public static JobLogDTO createJobLogForProdSync(ShopProductShortDto shopProductShortDto, ProductSchedulerSyncDTO productSchedulerSyncDTO, String jobResult) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(\uc0c1\ud488\ub3d9\uae30\ud654);
        dto.setJobMain(\uc0c1\ud488);
        dto.setJobSub(\ub3d9\uae30\ud654);
        dto.setJobDetail(\uc2a4\ucf00\uc974\ub7ec);
        dto.setProdCd(shopProductShortDto.getCompayny_goods_cd());
        dto.setShopCd(productSchedulerSyncDTO.getShopcd());
        dto.setShopUserId(productSchedulerSyncDTO.getShoppingid());
        dto.setNickname(productSchedulerSyncDTO.getNickname());
        dto.setShopSeq(productSchedulerSyncDTO.getShopseq());
        dto.setJobResult(jobResult);
        dto.setLogMessage(\uc2a4\ucf00\uc974\ub7ec_\ub3d9\uae30\ud654);
        return dto;
    }

    public static JobLogDTO createJobLogForProdIn(ShopProductDto shopProductDto, String jobType, String jobResult, String logMsg) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setProdCd(shopProductDto.getCompayny_goods_cd());
        dto.setShopProdNo(shopProductDto.getShopprodno());
        dto.setShopCd(shopProductDto.getShopcd());
        dto.setShopUserId(shopProductDto.getShopuserid());
        dto.setNickname(JobLogHelper.getNickname(shopProductDto.getShopcd(), shopProductDto.getShopuserid(), shopProductDto.getShopseq()));
        dto.setShopSeq(Integer.parseInt(shopProductDto.getShopseq()));
        dto.setJobResult(jobResult);
        dto.setLogMessage(logMsg);
        return dto;
    }

    public static JobLogDTO createJobLogForProdIn(String shopprodno, ShoppingMallDetailDto shoppingMallDetailDto, String jobType, String jobDetail, String jobResult, String logMsg) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setJobDetail(jobDetail);
        dto.setShopProdNo(shopprodno);
        dto.setShopCd(shoppingMallDetailDto.getShopcd());
        dto.setShopUserId(shoppingMallDetailDto.getShoppingid());
        dto.setNickname(JobLogHelper.getNickname(shoppingMallDetailDto.getShopcd(), shoppingMallDetailDto.getShoppingid(), shoppingMallDetailDto.getShopseq()));
        dto.setShopSeq(Integer.parseInt(shoppingMallDetailDto.getShopseq()));
        dto.setJobResult(jobResult);
        dto.setLogMessage(JobLogHelper.setLogMsg(logMsg));
        return dto;
    }

    public static JobLogDTO createJobLogForProdIn(ShopProductDto shopProductDto, String jobType, String jobDetail, String jobResult, String logMsg) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setJobDetail(jobDetail);
        dto.setProdCd(shopProductDto.getCompayny_goods_cd());
        dto.setShopProdNo(shopProductDto.getShopprodno());
        dto.setShopCd(shopProductDto.getShopcd());
        dto.setShopUserId(shopProductDto.getShopuserid());
        dto.setNickname(JobLogHelper.getNickname(shopProductDto.getShopcd(), shopProductDto.getShopuserid(), shopProductDto.getShopseq()));
        dto.setShopSeq(Integer.parseInt(shopProductDto.getShopseq()));
        dto.setJobResult(jobResult);
        dto.setLogMessage(logMsg);
        return dto;
    }

    public static JobLogDTO createJobLogForProdInfo(ShopProductDto shopProductDto, String jobType, String jobResult, String logMsg) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setProdCd(shopProductDto != null ? shopProductDto.getCompayny_goods_cd() : "");
        dto.setJobResult(jobResult);
        dto.setLogMessage(logMsg);
        return dto;
    }

    public static JobLogDTO createJobLogForProdInfo(ShopProductDto shopProductDto, String jobType, String jobDetail, String jobResult, String logMsg) {
        JobLogDTO dto = new JobLogDTO();
        dto.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        dto.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        dto.setJobMain(parsed.get("jobMain"));
        dto.setJobSub(parsed.get("jobSub"));
        dto.setJobDetail(jobDetail);
        dto.setProdCd(shopProductDto != null ? shopProductDto.getCompayny_goods_cd() : "");
        dto.setJobResult(jobResult);
        dto.setLogMessage(logMsg);
        return dto;
    }

    public static JobLogDTO createJobLogForOrder(ShopOrderMstDto shopOrderMstDto, String jobType, String jobDetail, String jobResult, String logMsg) {
        JobLogDTO jobLogDTO = new JobLogDTO();
        jobLogDTO.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        jobLogDTO.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        jobLogDTO.setJobMain(parsed.get("jobMain"));
        jobLogDTO.setJobSub(parsed.get("jobSub"));
        jobLogDTO.setJobDetail(jobDetail);
        jobLogDTO.setProdCd(shopOrderMstDto.getCompayny_goods_cd());
        jobLogDTO.setShopProdNo(shopOrderMstDto.getMall_product_id());
        jobLogDTO.setShopCd(shopOrderMstDto.getShopid());
        jobLogDTO.setShopUserId(shopOrderMstDto.getShop_userid());
        jobLogDTO.setNickname(JobLogHelper.getNickname(shopOrderMstDto.getShopid(), shopOrderMstDto.getShop_userid(), shopOrderMstDto.getShopseq()));
        jobLogDTO.setShopSeq(Integer.parseInt(shopOrderMstDto.getShopseq()));
        jobLogDTO.setOrdId(JobLogHelper.getOrderId(shopOrderMstDto, jobType));
        jobLogDTO.setProductName(shopOrderMstDto.getP_product_name());
        jobLogDTO.setOptionName(shopOrderMstDto.getP_sku_value());
        jobLogDTO.setSaleCnt(Integer.parseInt(shopOrderMstDto.getSale_cnt()));
        jobLogDTO.setSaleCost(JobLogHelper.getOrderCost(shopOrderMstDto, jobType));
        jobLogDTO.setReceiveName(shopOrderMstDto.getReceive_name());
        jobLogDTO.setJobResult(jobResult);
        jobLogDTO.setLogMessage(logMsg);
        return jobLogDTO;
    }

    public static JobLogDTO createJobLogForDomeSync(ShopOrderMstDto shopOrderMstDto, String jobType, String jobDetail, String jobResult, String logMsg) {
        JobLogDTO jobLogDTO = new JobLogDTO();
        jobLogDTO.setJobDate(YDMATimeUtil.getCurrentTimeByYDFormat());
        jobLogDTO.setJobType(jobType);
        Map<String, String> parsed = JobLogHelper.parseJobType(jobType);
        jobLogDTO.setJobMain(parsed.get("jobMain"));
        jobLogDTO.setJobSub(parsed.get("jobSub"));
        jobLogDTO.setJobDetail(jobDetail);
        jobLogDTO.setProdCd(shopOrderMstDto.getCompayny_goods_cd());
        jobLogDTO.setShopCd(shopOrderMstDto.getShopid());
        jobLogDTO.setShopUserId(shopOrderMstDto.getShop_userid());
        jobLogDTO.setNickname(JobLogHelper.getNickname(shopOrderMstDto.getShopid(), shopOrderMstDto.getShop_userid(), shopOrderMstDto.getShopseq()));
        jobLogDTO.setShopSeq(Integer.parseInt(shopOrderMstDto.getShopseq()));
        jobLogDTO.setOrdId(JobLogHelper.getOrderId(shopOrderMstDto, jobType));
        jobLogDTO.setReceiveName(shopOrderMstDto.getReceive_name());
        jobLogDTO.setJobResult(jobResult);
        jobLogDTO.setLogMessage(JobLogHelper.setLogMsg(shopOrderMstDto, jobDetail, logMsg));
        return jobLogDTO;
    }

    private static String getNickname(String shopCd, String shopUserId, String shopSeq) {
        List<Object> nicknameList = new ArrayList();
        ShoppingMallDao dao = new ShoppingMallDao();
        try {
            nicknameList = dao.getShopidAlllist();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String nickname = nicknameList.stream().filter(list -> shopCd.equals(list.get(1)) && shopUserId.equals(list.get(3)) && shopSeq.equals(list.get(2))).map(list -> (String)list.get(6)).findFirst().orElse("");
        return nickname;
    }

    private static String getOrderId(ShopOrderMstDto order, String jobType) {
        String orderId = "";
        orderId = jobType.contains("DOME") ? order.getDosinOrder_code() : order.getOrder_id();
        return orderId;
    }

    private static int getOrderCost(ShopOrderMstDto order, String jobType) {
        int cost = 0;
        cost = jobType.contains("DOME") ? Integer.parseInt(order.getWon_cost()) : Integer.parseInt(order.getSale_cost());
        return cost;
    }

    private static String setLogMsg(ShopOrderMstDto dto, String jobDetail, String logMsg) {
        StringBuilder sb = new StringBuilder();
        if (!jobDetail.equals("")) {
            sb.append("[\uc2a4\ucf00\uc974\ub7ec] ");
        }
        if (!logMsg.equals("")) {
            sb.append(logMsg);
            return sb.toString();
        }
        switch (dto.getOrder_status()) {
            case "100": {
                String option2 = dto.getP_sku_value();
                String optionText = option2 == null || option2.isEmpty() ? "" : "| " + option2;
                sb.append(String.format("%s %s | %s\uac1c | %s\uc6d0", dto.getP_product_name(), optionText, dto.getSale_cnt(), dto.getTotal_cost()));
                break;
            }
            case "410": 
            case "C01": 
            case "C02": 
            case "E01": 
            case "E02": 
            case "R01": 
            case "R02": {
                sb.append(String.format("%s | %s | %s\uac1c | %s\uc6d0", dto.getReceive_name(), dto.getP_product_name(), dto.getSale_cnt(), dto.getSale_cost()));
                break;
            }
            case "500": {
                sb.append(String.format("\uc218\ucde8\uc778\uba85 : %s | \uc8fc\ubb38\ubc88\ud638 : %s | \uc0c1\ud488\ucf54\ub4dc : %s | \uc218\ub7c9 : %s", dto.getReceive_name(), dto.getDosinOrder_code(), dto.getCompayny_goods_cd(), dto.getSale_cnt()));
                break;
            }
            case "501": {
                String productName = dto.getProduct_name().isEmpty() ? dto.getP_product_name() : dto.getProduct_name();
                sb.append(String.format("%s | %s | %s", productName, dto.getReceive_name(), dto.getDs_order_status()));
                break;
            }
            case "402": {
                sb.append(String.format("%s | %s | %s | %s", dto.getProduct_name(), dto.getReceive_name(), dto.getDs_order_status(), dto.getInvoice_no()));
                break;
            }
        }
        return sb.toString();
    }

    private static String setDomeLogMsg(String jobDetail) {
        switch (jobDetail) {
            case "SEARCH": {
                return \uc0c1\ud488\uac80\uc0c9\uc218\uc2e0\uc644\ub8cc;
            }
            case "EXCEL": {
                return \uc0c1\ud488\uc5d1\uc140\uc218\uc2e0\uc644\ub8cc;
            }
            case "SCHEDULER": {
                return \uc0c1\ud488\uc2a4\ucf00\uc974\ub7ec\uc218\uc2e0\uc644\ub8cc;
            }
        }
        return "";
    }

    public static String setJobTypeName(String str) {
        switch (str) {
            case "PROD_RECV": {
                return "\uc0c1\ud488 \uc218\uc2e0";
            }
            case "PROD_REG": {
                return "\uc0c1\ud488 \ub4f1\ub85d";
            }
            case "PROD_MODI": {
                return "\uc0c1\ud488 \uc218\uc815";
            }
            case "PROD_DEL": {
                return "\uc0c1\ud488 \uc0ad\uc81c";
            }
            case "PROD_SYNC": {
                return "\uc0c1\ud488 \ub3d9\uae30\ud654";
            }
            case "ORD_COLLECT": {
                return "\uc8fc\ubb38 \uc218\uc9d1";
            }
            case "ORD_CONFIRM": {
                return "\uc8fc\ubb38 \ud655\uc778";
            }
            case "ORD_SYNC": {
                return "\uc8fc\ubb38 \ub3d9\uae30\ud654";
            }
            case "ORD_DOME_SEND": {
                return "\ub3c4\ub9e4 \uc8fc\ubb38";
            }
            case "ORD_DOME_COLLECT": {
                return "\ub3c4\ub9e4 \uc218\uc9d1";
            }
            case "ORD_DOME_SYNC": {
                return "\ub3c4\ub9e4\ub3d9\uae30\ud654";
            }
            case "ORD_DELV_SEND": {
                return "\uc8fc\ubb38 \ubc1c\uc1a1";
            }
            case "YEL_ADD": {
                return "\uc610\ub9bc \uc0c1\ud488\ucd94\uac00";
            }
            case "YEL_DEL": {
                return "\uc610\ub9bc \uc0c1\ud488\uc0ad\uc81c";
            }
            case "YEL_MODI": {
                return "\uc610\ub9bc \uc0c1\ud488\uc218\uc815";
            }
            case "YEL_DOME_MODI": {
                return "\uc610\ub9bc \ub3c4\ub9e4\ubab0\uc218\uc815";
            }
        }
        return "";
    }

    public static String setJobMainName(String str) {
        switch (str) {
            case "PROD": {
                return "\uc0c1\ud488";
            }
            case "ORD": {
                return "\uc8fc\ubb38";
            }
            case "QNA": {
                return "\ubb38\uc758";
            }
            case "YEL": {
                return "\uc610\ub9bc";
            }
        }
        return "";
    }

    public static String setJobSubName(String str) {
        switch (str) {
            case "RECV": {
                return "\uc218\uc2e0";
            }
            case "REG": {
                return "\ub4f1\ub85d";
            }
            case "MODI": {
                return "\uc218\uc815";
            }
            case "DEL": {
                return "\uc0ad\uc81c";
            }
            case "COLLECT": {
                return "\uc218\uc9d1";
            }
            case "SYNC": {
                return "\ub3d9\uae30\ud654";
            }
            case "DOME_SEND": {
                return "\ub3c4\ub9e4\uc8fc\ubb38";
            }
            case "DOME_COLLECT": {
                return "\ub3c4\ub9e4\uc218\uc9d1";
            }
            case "DELV_SEND": {
                return "\ubc1c\uc1a1";
            }
            case "ADD": {
                return "\uc0c1\ud488\ucd94\uac00";
            }
            case "DOME_MODI": {
                return "\ub3c4\ub9e4\ubab0\uc218\uc815";
            }
            case "DOME_SYNC": {
                return "\ub3c4\ub9e4\ub3d9\uae30\ud654";
            }
        }
        return "";
    }

    public static String setJobDetailName(String str) {
        switch (str) {
            case "SEARCH": {
                return "\uac80\uc0c9";
            }
            case "EXCEL": {
                return "\uc5d1\uc140";
            }
            case "SCHEDULER": {
                return "\uc2a4\ucf00\uc974\ub7ec";
            }
        }
        return "";
    }

    public static Map<String, String> parseJobType(String jobType) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (jobType == null || jobType.isEmpty()) {
            result.put("jobMain", "");
            result.put("jobSub", "");
            return result;
        }
        HashMap<String, String[]> overrideMap = new HashMap<String, String[]>();
        overrideMap.put(\uc610\ub9bc\ub3c4\ub9e4\ubab0\uc218\uc815, new String[]{\uc610\ub9bc, \ub3c4\ub9e4\ubab0\uc218\uc815});
        if (overrideMap.containsKey(jobType)) {
            String[] arr = (String[])overrideMap.get(jobType);
            result.put("jobMain", arr[0]);
            result.put("jobSub", arr[1]);
            return result;
        }
        String[] parts = jobType.split("_");
        if (parts.length == 2) {
            result.put("jobMain", parts[0]);
            result.put("jobSub", parts[1]);
        } else if (parts.length == 3) {
            result.put("jobMain", parts[0]);
            result.put("jobSub", parts[1] + "_" + parts[2]);
        } else {
            result.put("jobMain", "");
            result.put("jobSub", "");
        }
        return result;
    }

    public static String setLogMsg(String logMsg) {
        switch (logMsg) {
            case "\uc1fc\ud551\ubab0 \uc0ad\uc81c \uc791\uc5c5 \uc911 \uc2e4\ud328 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2e4\ud328;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \uc544\uc774\ud15c\uc704\ub108\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\uc544\uc774\ud15c\uc704\ub108_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \ub178\ucd9c\uc81c\ud55c\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\ub178\ucd9c\uc81c\ud55c_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \ucfe0\ud321 \ubc18\ub824\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ucfe0\ud321_\ubc18\ub824_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \uce74\ud0c8\ub85c\uadf8\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\uce74\ud0c8\ub85c\uadf8_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc885\ub8cc\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc885\ub8cc_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\uc2a4\ub9c8\ud2b8\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc911\uc9c0_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \ud1a0\uc2a4 \ubc18\ub824\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ud1a0\uc2a4_\ubc18\ub824_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\ud310\ub9e4\uc911\uc9c0_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \uc911\ubcf5\ub4f1\ub85d\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\uc911\ubcf5\ub4f1\ub85d_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] 11\ubc88\uac00 \ud074\ub9b0\ub300\uc0c1\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_11\ubc88\uac00_\ud074\ub9b0\ub300\uc0c1_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \ud1a1\uc2a4\ud1a0\uc5b4 \ud310\ub9e4\uc911\uc9c0\uc5d0 \ud574\ub2f9\ub418\ub294 \uc0c1\ud488\uc774 \uc218\uc815\ub300\uae30 \uc0c1\ud0dc\ub85c \ubcc0\uacbd\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ud1a1\uc2a4\ud1a0\uc5b4_\ud310\ub9e4\uc911\uc9c0_\uc1fc\ud551\ubab0;
            }
            case "[\uc2a4\ucf00\uc974\ub7ec] \uc0c1\ud488\uc774 \uc1fc\ud551\ubab0\uc5d0\uc11c \ud310\ub9e4\uc911\uc9c0 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.": {
                return \uc2a4\ucf00\uc974\ub7ec_\uc0ad\uc81c_\ud310\ub9e4\uc911\uc9c0\ucc98\ub9ac_\uc1fc\ud551\ubab0;
            }
        }
        return logMsg;
    }
}

