/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.onchannel;

import com.kdjsystem.mlink.shop.common.ChromeScript;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.dao.ProductItemDto;
import com.kdjsystem.mlink.shop.dao.ProductResultDto;
import com.kdjsystem.mlink.shop.dao.ShopCateDto;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopDeliveryDto;
import com.kdjsystem.mlink.shop.dao.ShopOrderDao;
import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDao;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.shop.mlink.MLinkDomeOrderCollectConnection;
import com.kdjsystem.mlink.tot.common.YDMAProgressBar;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import com.kdjsystem.mlink.tot.data.excel.MyExcelManager;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.Select;

public class OnChannelCommon {
    public static OnChannelCommon instance = new OnChannelCommon();

    private OnChannelCommon() {
    }

    public static OnChannelCommon get() {
        return instance;
    }

    public List<ShopOrderMstDto> OnchannelOrderSearch(List<ShopOrderMstDto> orderList, ShoppingMallDetailDto shopDto, YDMAProgressBar console, boolean isAll) throws Exception {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        int page = 0;
        try {
            ChromeDriver driver = IShopCommonLogin.loginOnchannel(shopDto.getShoppingid(), shopDto.getPassword(), shopDto.getShopcd(), true);
            Map<String, String> cookies = ChromeScript.get().getCookies(driver);
            driver.quit();
            for (ShopOrderMstDto dto : orderList) {
                if (!dto.getCompayny_goods_cd().substring(0, 2).equals("CH")) {
                    throw new Exception("\uc628\ucc44\ub110 \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud574 \uc8fc\uc138\uc694. " + dto.getCompayny_goods_cd());
                }
                String orderCode = dto.getDosinOrder_code().contains("-") ? dto.getDosinOrder_code().split("-")[0] : dto.getDosinOrder_code();
                String URL2 = "https://www.onch3.co.kr/admin_mem_prd.html?ol=prd_code&ost=" + orderCode + "&sf=1";
                Document body = Jsoup.connect((String)URL2).cookies(cookies).get();
                String receiverName = body.select("li.prd_list_name > div").text().replace("\ubc1b\ub294\uc0ac\ub78c \uc544\uc774\ub514/\uc5f0\ub77d\ucc98", "").replaceAll("[^\uac00-\ud7a3|\u3131-\u314e|A-Z|a-z]", "");
                String devStat = body.select("li.prd_list_state > div > b").text().replace("\ubc30\uc1a1\uc0c1\ud0dc", "").trim();
                if (!receiverName.contains(dto.getReceive_name())) continue;
                dto.setDelivery_id("");
                dto.setInvoice_no("");
                switch (devStat) {
                    case "\ubc30\uc1a1\uc900\ube44\uc911": {
                        dto.setOrder_status("501");
                        dto.setDs_order_status("\ubc30\uc1a1\uc900\ube44");
                        break;
                    }
                    case "\ubc1c\uc1a1\uc644\ub8cc": {
                        List<ShopDeliveryDto> datasource = ShopCommonDao.get().getExpress(dto.getShopid());
                        String delvnum = body.select("li.prd_list_state > div").text().replace("\uc1a1\uc7a5\uc870\ud68c \uc1a1\uc7a5\ubcf5\uc0ac", "").trim();
                        String[] delvinfo = delvnum.split("\\)");
                        delvinfo = delvinfo[1].split(" ");
                        String delv = delvinfo[1];
                        ShopDeliveryDto delvname = MLinkDomeOrderCollectConnection.get().findDelvName(dto, delv, datasource);
                        dto.setDs_order_status("\ubc1c\uc1a1\uc644\ub8cc");
                        dto.setDelivery_id(delvname.getDlvID());
                        dto.setInvoice_no(delvinfo[2]);
                        dto.setOrder_status("402");
                        break;
                    }
                    default: {
                        dto.setDs_order_status(devStat);
                    }
                }
                ++page;
                if (dto.getInvoice_no().equals("")) {
                    MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, page, "", false, console);
                } else {
                    MLinkDomeOrderCollectConnection.get().showDomeMessage(dto, page, "", true, console);
                }
                dto.setResult_code("1");
                ret.add(dto);
            }
            if (!isAll) {
                this.setValue(console, "---------------------------------------------------------------------------------------", page);
                this.setValue(console, String.format("[\uacb0\uacfc] \ub3d9\uae30\ud654 %s\uac74 \uc785\ub2c8\ub2e4.", page), page);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setValue(console, "\uc628\ucc44\ub110 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. [" + String.valueOf(e) + "]", page);
        }
        return ret;
    }

    public ProductResultDto getProductUploadMapping(MyExcelManager readExcelManager) throws Exception {
        ProductResultDto productResult = new ProductResultDto();
        List<List<String>> sheetContents = readExcelManager.getSheetContents(0, 2);
        List<List<String>> categContents = readExcelManager.getSheetContents(1, 2);
        new IShopCommonLogin(){};
        ArrayList<ProductItemDto> items = new ArrayList<ProductItemDto>();
        int i = 0;
        while (i < sheetContents.size()) {
            ProductItemDto item = new ProductItemDto();
            item.setSearch("shop9996");
            item.setIcode(sheetContents.get(i).get(1));
            item.setCid(sheetContents.get(i).get(3));
            item.setCateg_nm("");
            item.setCate_depth("");
            item.setIname(sheetContents.get(i).get(4));
            item.setIcountry(sheetContents.get(i).get(9));
            item.setMaker(sheetContents.get(i).get(11));
            String[] image = new String[]{sheetContents.get(i).get(14).replaceAll("https", "http"), sheetContents.get(i).get(15).replaceAll("https", "http"), sheetContents.get(i).get(16).replaceAll("https", "http"), sheetContents.get(i).get(17).replaceAll("https", "http"), sheetContents.get(i).get(18).replaceAll("https", "http"), sheetContents.get(i).get(13).replaceAll("https", "http")};
            item.setImg(image);
            item.setContent(sheetContents.get(i).get(19));
            String price2 = sheetContents.get(i).get(37);
            if (sheetContents.get(i).get(24).trim().length() > 0) {
                StringBuffer sb = new StringBuffer();
                String type = sheetContents.get(i).get(24).split("\\*\\*")[0];
                List<String> depth = Arrays.asList(type.split("\\*"));
                Arrays.asList(sheetContents.get(i).get(23).split("\n"));
                if (depth.size() > 1) {
                    String title = sheetContents.get(i).get(23).replaceFirst("\n", "=").replace("\n", "");
                    if (!title.contains("=")) {
                        title = title.concat("=").concat("\uc635\uc158\uac12");
                    }
                    sb.append("[" + title + "]\n");
                    List<String> options = Arrays.asList(sheetContents.get(i).get(24).split("\n"));
                    int k = 0;
                    while (k < options.size()) {
                        List<String> option2 = Arrays.asList(options.get(k).split("\\*"));
                        sb.append(option2.get(0).concat("=").concat(option2.get(1)).concat("=").concat(String.valueOf(YDMAStringUtil.convertToLong(price2.equals("") ? sheetContents.get(i).get(72) : price2) + YDMAStringUtil.convertToLong(option2.get(3))).concat("=0=0=").concat(option2.get(5).equals("Y") ? "0" : "1")).concat("\n"));
                        ++k;
                    }
                } else {
                    sb.append("[" + sheetContents.get(i).get(23) + "]\n");
                    List<String> options = Arrays.asList(sheetContents.get(i).get(24).split("\n"));
                    int k = 0;
                    while (k < options.size()) {
                        List<String> option3 = Arrays.asList(options.get(k).split("\\*"));
                        sb.append(option3.get(0).concat("==").concat(String.valueOf(YDMAStringUtil.convertToLong(price2.equals("") ? sheetContents.get(i).get(72) : price2) + YDMAStringUtil.convertToLong(option3.get(2))).concat("=0=0=").concat(option3.get(4).equals("Y") ? "0" : "1")).concat("\n"));
                        ++k;
                    }
                }
                item.setSelect_option(sb.toString());
                item.setText_option("");
            }
            item.setBrand(sheetContents.get(i).get(29));
            item.setTax(sheetContents.get(i).get(31).equals("") ? "0" : (sheetContents.get(i).get(31).equals("\uacfc\uc138") ? "0" : "1"));
            item.setAdult(sheetContents.get(i).get(32).equals("18\uc138\uc774\uc6a9\uac00") ? "1" : "0");
            item.setItype(sheetContents.get(i).get(34).equals("") ? "0" : (sheetContents.get(i).get(34).equals("\uc2e0\uc0c1\ud488") ? "0" : "1"));
            item.setPrice(price2.equals("") ? sheetContents.get(i).get(72) : price2);
            item.setPrice_consumer(price2.equals("") ? sheetContents.get(i).get(72) : price2);
            String limitprice = String.valueOf(YDMAStringUtil.convertToLong(sheetContents.get(i).get(5)) - YDMAStringUtil.convertToLong(price2.equals("") ? sheetContents.get(i).get(72) : price2));
            item.setLimit_price(limitprice.equals("0") ? "0" : sheetContents.get(i).get(5));
            item.setIslimit(limitprice.equals("0") ? "0" : "1");
            item.setGosi_code(sheetContents.get(i).get(40));
            if (sheetContents.get(i).get(41).equals("Y")) {
                item.setGosi1("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi2("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi3("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi4("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi5("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi6("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi7("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi8("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi9("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi10("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi11("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi12("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi13("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi14("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi15("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi16("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi17("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi18("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi19("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi20("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi21("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
                item.setGosi22("\uc0c1\uc138\uc124\uba85 \ucc38\uc870");
            } else {
                int k = 42;
                while (k < sheetContents.get(i).size()) {
                    switch (k) {
                        case 42: {
                            item.setGosi1(sheetContents.get(i).get(k));
                            break;
                        }
                        case 43: {
                            item.setGosi2(sheetContents.get(i).get(k));
                            break;
                        }
                        case 44: {
                            item.setGosi3(sheetContents.get(i).get(k));
                            break;
                        }
                        case 45: {
                            item.setGosi4(sheetContents.get(i).get(k));
                            break;
                        }
                        case 46: {
                            item.setGosi5(sheetContents.get(i).get(k));
                            break;
                        }
                        case 47: {
                            item.setGosi6(sheetContents.get(i).get(k));
                            break;
                        }
                        case 48: {
                            item.setGosi7(sheetContents.get(i).get(k));
                            break;
                        }
                        case 49: {
                            item.setGosi8(sheetContents.get(i).get(k));
                            break;
                        }
                        case 50: {
                            item.setGosi9(sheetContents.get(i).get(k));
                            break;
                        }
                        case 51: {
                            item.setGosi10(sheetContents.get(i).get(k));
                            break;
                        }
                        case 52: {
                            item.setGosi11(sheetContents.get(i).get(k));
                            break;
                        }
                        case 53: {
                            item.setGosi12(sheetContents.get(i).get(k));
                            break;
                        }
                        case 54: {
                            item.setGosi13(sheetContents.get(i).get(k));
                            break;
                        }
                        case 55: {
                            item.setGosi14(sheetContents.get(i).get(k));
                            break;
                        }
                        case 56: {
                            item.setGosi15(sheetContents.get(i).get(k));
                            break;
                        }
                        case 57: {
                            item.setGosi16(sheetContents.get(i).get(k));
                            break;
                        }
                        case 58: {
                            item.setGosi17(sheetContents.get(i).get(k));
                            break;
                        }
                        case 59: {
                            item.setGosi18(sheetContents.get(i).get(k));
                            break;
                        }
                        case 60: {
                            item.setGosi19(sheetContents.get(i).get(k));
                            break;
                        }
                        case 61: {
                            item.setGosi20(sheetContents.get(i).get(k));
                            break;
                        }
                        case 62: {
                            item.setGosi21(sheetContents.get(i).get(k));
                            break;
                        }
                        case 63: {
                            item.setGosi22(sheetContents.get(i).get(k));
                        }
                    }
                    ++k;
                }
            }
            int num = i;
            List shopCategorys = categContents.stream().filter(d -> ((String)d.get(0)).equals(((List)sheetContents.get(num)).get(0))).findAny().orElse(null);
            item.setEs(sheetContents.get(i).get(3));
            if (shopCategorys != null) {
                int k = 0;
                while (k < shopCategorys.size()) {
                    switch (k) {
                        case 1: {
                            item.setPa_auction((String)shopCategorys.get(k));
                            item.setEs_auction((String)shopCategorys.get(k));
                            break;
                        }
                        case 2: {
                            item.setEs_gmarket((String)shopCategorys.get(k));
                            ShopCateDto.MallCategoryList categnm = ShopProductDao.get().getFindShopCategory("shop0068", item.getEs_gmarket());
                            item.setPa_gmarket(categnm.getShopcatenm());
                            break;
                        }
                        case 3: {
                            item.setPa_11st((String)shopCategorys.get(k));
                            item.setEs_11st((String)shopCategorys.get(k));
                            break;
                        }
                        case 4: {
                            item.setPa_interpark((String)shopCategorys.get(k));
                            item.setEs_interpark((String)shopCategorys.get(k));
                            break;
                        }
                        case 5: {
                            item.setPa_storefarm((String)shopCategorys.get(k));
                            item.setEs_storefarm((String)shopCategorys.get(k));
                            break;
                        }
                        case 6: {
                            item.setEsm_gmarket(((String)shopCategorys.get(k)).substring(0, ((String)shopCategorys.get(k)).indexOf("*")));
                            item.setEsm_auction(((String)shopCategorys.get(k)).substring(0, ((String)shopCategorys.get(k)).indexOf("*")));
                            break;
                        }
                        case 7: {
                            item.setEs_coupang((String)shopCategorys.get(k));
                            break;
                        }
                        case 8: {
                            item.setEs_tmon((String)shopCategorys.get(k));
                            break;
                        }
                        case 9: {
                            item.setEs_wemarket((String)shopCategorys.get(k));
                            break;
                        }
                    }
                    ++k;
                }
            }
            item.setPa("");
            item.setIname_del("");
            item.setDelivery_amount(sheetContents.get(i).get(73));
            item.setR_delivery_amount("0");
            item.setDelivery_type("0");
            item.setDelivery_qty("0");
            item.setNotice("");
            item.setIsreturn("1");
            item.setKeyword(shopCategorys.size() > 17 ? (String)shopCategorys.get(17) : "");
            item.setReg_datetime(sheetContents.get(i).size() > 74 ? sheetContents.get(i).get(74) : YDMATimeUtil.getCurrentTimeByYDFormat());
            item.setUp_datetime(sheetContents.get(i).size() > 74 ? sheetContents.get(i).get(74) : YDMATimeUtil.getCurrentTimeByYDFormat());
            item.setStatus("0");
            item.setCert_type("0");
            item.setCert_no("");
            item.setCert("");
            items.add(item);
            ++i;
        }
        productResult.items = items;
        return productResult;
    }

    public String ConvertDictionaryToParameter(Map<String, String> parameters) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        for (String key : parameters.keySet()) {
            String value = parameters.get(key);
            if (value.equals("") || value.equals("0")) continue;
            list.add((CallSite)((Object)(key + ":" + value)));
        }
        return list.stream().collect(Collectors.joining(","));
    }

    public String ConvertDictionaryTLisyoParameter(List<List<String>> contents) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        int i = 0;
        while (i < contents.size()) {
            String value = contents.get(i).get(1);
            if (!value.equals("") && !value.equals("0")) {
                list.add((CallSite)((Object)(contents.get(i).get(0) + ":" + value)));
            }
            ++i;
        }
        return list.stream().collect(Collectors.joining(","));
    }

    public void OrderListComplate(List<ShopOrderMstDto> list, ShoppingMallDetailDto shopdto, YDMAProgressBar console) throws Exception {
        ChromeDriver driver = IShopCommonLogin.loginOnchannel(shopdto.getShoppingid(), shopdto.getPassword(), shopdto.getShopcd(), true);
        int page = 0;
        int order = 0;
        Map<String, Map<String, List<ShopOrderMstDto>>> mapList = list.stream().filter(d -> d.getDosinstatus() != null && !d.getDosinstatus().equals("\ud488\uc808")).collect(Collectors.groupingBy(ShopOrderMstDto::getReceive_addr, Collectors.groupingBy(ShopOrderMstDto::getVendorId)));
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\ud488\uc808\uc0c1\ud488 \ubc0f \ub3d9\uc77c\ubc30\uc1a1\uc9c0 \uc81c\uc678 " + mapList.size() + "\uac74\uc758 \uc8fc\ubb38\uc815\ubcf4 \uc804\uc1a1\uc744 \uc2dc\uc791\ud569\ub2c8\ub2e4", 0);
        List<Object> datas = new ArrayList();
        for (String addr : mapList.keySet()) {
            try {
                Map<String, List<ShopOrderMstDto>> map = mapList.get(addr);
                for (String vendorId : map.keySet()) {
                    datas = map.get(vendorId);
                    String phone = ((ShopOrderMstDto)datas.get(0)).getReceive_cel().equals("") ? ((ShopOrderMstDto)datas.get(0)).getReceive_tel() : ((ShopOrderMstDto)datas.get(0)).getReceive_cel();
                    String phone2 = ((ShopOrderMstDto)datas.get(0)).getReceive_tel().equals("") ? ((ShopOrderMstDto)datas.get(0)).getReceive_cel() : ((ShopOrderMstDto)datas.get(0)).getReceive_tel();
                    for (ShopOrderMstDto shopOrderMstDto : datas) {
                        String message;
                        String URL2 = String.format("https://www.onch3.co.kr/prd_order_pg.html?num=%s", shopOrderMstDto.getCompayny_goods_cd());
                        ChromeScript.get().get(driver, URL2);
                        Select selectbox = new Select(driver.findElement(By.id((String)"select_option")));
                        selectbox.selectByVisibleText(shopOrderMstDto.getP_sku_value2());
                        driver.executeScript(String.format("document.getElementById(\"prd_cnt\").value=\"%s\"", shopOrderMstDto.getSale_cnt()), new Object[0]);
                        driver.findElementByXPath("/html/body/div[2]/div/table/tbody/tr[2]/td/table/tbody/tr[4]/td/table/tbody/tr[6]/td/table/tbody/tr[3]/td/a/img").click();
                        driver.findElement(By.name((String)"order_nm")).sendKeys(new CharSequence[]{((ShopOrderMstDto)datas.get(0)).getReceive_name()});
                        driver.findElement(By.name((String)"mem_tell")).sendKeys(new CharSequence[]{phone});
                        driver.findElement(By.name((String)"mem_phone")).sendKeys(new CharSequence[]{phone2});
                        driver.findElement(By.name((String)"zip1")).sendKeys(new CharSequence[]{((ShopOrderMstDto)datas.get(0)).getReceive_zipcode()});
                        driver.findElement(By.name((String)"mem_address")).sendKeys(new CharSequence[]{((ShopOrderMstDto)datas.get(0)).getReceive_addr()});
                        driver.findElement(By.name((String)"comment")).sendKeys(new CharSequence[]{((ShopOrderMstDto)datas.get(0)).getDelv_msg() == null ? "" : ((ShopOrderMstDto)datas.get(0)).getDelv_msg()});
                        Thread.sleep(1000L);
                        driver.executeScript("confirm_order();", new Object[]{""});
                        Thread.sleep(1000L);
                        driver.findElementByClassName("ol_btn_complete").click();
                        if (ExpectedConditions.alertIsPresent().apply((Object)driver) != null) {
                            driver.switchTo().alert().accept();
                            Thread.sleep(1000L);
                        }
                        URL2 = driver.getCurrentUrl();
                        URL aURL = new URL(URL2);
                        String odno = aURL.getQuery();
                        int cut = odno.indexOf("&");
                        if (!(odno = odno.substring(5, cut)).equals("") | odno != null) {
                            if (!odno.equals("")) {
                                for (ShopOrderMstDto shopOrderMstDto2 : datas) {
                                    shopOrderMstDto2.setDosinOrder_code(odno + "-" + shopdto.getShopseq());
                                    shopOrderMstDto2.setOrder_status("500");
                                    shopOrderMstDto2.setResult_code("1");
                                    shopOrderMstDto2.setDs_order_status("\ub3c4\ub9e4\uc2e0\uaddc");
                                    ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
                                    retList.add(shopOrderMstDto2);
                                    ShopOrderDao.get().SaveOrUpdate(retList);
                                    ++order;
                                    String headerText = " \u2192 \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.\n     ";
                                    String comment = String.format("\uc218\ucde8\uc778\uba85 : %s, \uc8fc\ubb38\ubc88\ud638 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", shopOrderMstDto2.getReceive_name(), shopOrderMstDto2.getDosinOrder_code(), shopOrderMstDto2.getCompayny_goods_cd(), shopOrderMstDto2.getSale_cnt(), "\uc8fc\ubb38\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \uc811\uc218 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                                    this.setValueAndJobLog(console, headerText + comment, ++page, shopOrderMstDto, "ORD_DOME_SEND", "\uc131\uacf5", comment);
                                }
                                continue;
                            }
                            for (ShopOrderMstDto shopOrderMstDto3 : datas) {
                                message = String.format("\uc218\ucde8\uc778\uba85 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", shopOrderMstDto3.getReceive_name(), shopOrderMstDto3.getCompayny_goods_cd(), shopOrderMstDto3.getSale_cnt(), odno);
                                MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, message, ++page);
                                shopOrderMstDto3.setResult_code("-1");
                            }
                            continue;
                        }
                        for (ShopOrderMstDto shopOrderMstDto4 : datas) {
                            message = String.format("\uc218\ucde8\uc778\uba85 : %s, \uc0c1\ud488\ucf54\ub4dc : %s, \uc218\ub7c9 : %s, \uc804\uc1a1\ub0b4\uc6a9 : %s", shopOrderMstDto4.getReceive_name(), shopOrderMstDto4.getCompayny_goods_cd(), shopOrderMstDto4.getSale_cnt(), "\uc8fc\ubb38\uc804\uc1a1\uc744 \ud558\uc9c0 \ubabb\ud558\uc600\uc2b5\ub2c8\ub2e4.");
                            MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, message, ++page);
                            shopOrderMstDto4.setResult_code("-1");
                        }
                    }
                }
            }
            catch (Exception e) {
                MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "\uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4. " + e.getMessage(), ++page);
            }
        }
        driver.quit();
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, "---------------------------------------------------------------------------------------", page);
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, String.format("[\uc628\ucc44\ub110 \uacb0\uacfc] \uc8fc\ubb38 \uac74\uc218 %s\uac74 \uc785\ub2c8\ub2e4.", order), page);
    }

    public List<ShopOrderMstDto> getSearchOnchannel(Map<String, String> cookies, List<ShopOrderMstDto> list, ChromeDriver driver) {
        ArrayList<ShopOrderMstDto> ret = new ArrayList<ShopOrderMstDto>();
        try {
            for (ShopOrderMstDto dto : list) {
                if (!dto.getCompayny_goods_cd().substring(0, 2).equals("CH")) {
                    throw new Exception("\uc628\ucc44\ub110 \uc0c1\ud488\uc774 \uc544\ub2d9\ub2c8\ub2e4. \uc0c1\ud488\ucf54\ub4dc\ub97c \ud655\uc778\ud574 \uc8fc\uc138\uc694. " + dto.getCompayny_goods_cd());
                }
                Document body = Jsoup.connect((String)("https://www.onch3.co.kr/idx_search_main.php?sear_txt=" + dto.getCompayny_goods_cd())).cookies(cookies).get();
                String prdcode = body.select("a[href*=stxt=" + dto.getCompayny_goods_cd() + "]").first().toString();
                int endpoint = prdcode.indexOf("&");
                prdcode = prdcode.substring(28, endpoint);
                String img = body.select("a[href*=stxt=" + dto.getCompayny_goods_cd() + "]").next().first().attr("src").toString();
                ChromeScript.get().get(driver, String.format("https://www.onch3.co.kr/onch_view.html?num=%s", prdcode));
                if (driver.findElementByClassName("btn_approve") != null) {
                    driver.findElementByClassName("btn_approve").click();
                }
                if (ExpectedConditions.alertIsPresent().apply((Object)driver) != null) {
                    driver.switchTo().alert().accept();
                    Thread.sleep(1000L);
                }
                if (ExpectedConditions.alertIsPresent().apply((Object)driver) != null) {
                    driver.switchTo().alert().accept();
                    Thread.sleep(1000L);
                }
                if (driver.findElementByClassName("btn_app_complete") != null) {
                    driver.findElementByClassName("btn_order").click();
                }
                Select selectbox = new Select(driver.findElement(By.id((String)"select_option")));
                List option_list = selectbox.getOptions();
                ArrayList<String> options = new ArrayList<String>();
                ArrayList<String> options_cost = new ArrayList<String>();
                for (WebElement option2 : option_list) {
                    if (!option2.getText().contains("_") || option2.getText().contains("\ud488\uc808")) continue;
                    String[] temp = option2.getText().split("_\\(");
                    options.add(option2.getText());
                    options_cost.add(temp[1].replaceAll("[^0-9]", ""));
                }
                String price2 = (String)options_cost.get(0);
                String deliv_cost = driver.findElementByXPath("/html/body/div[2]/div/table/tbody/tr[2]/td/table/tbody/tr[4]/td/table/tbody/tr[6]/td/table/tbody/tr[7]/td[2]").getText().replaceAll("[^0-9]", "");
                if (price2.equals("")) {
                    price2 = "0";
                }
                Object option3 = "[\uc0c1\ud488\uc120\ud0dd]\n";
                int i = 0;
                while (i < options.size()) {
                    option3 = (String)option3 + (String)options.get(i) + "==" + (String)options_cost.get(i) + "=0=0=0\n";
                    ++i;
                }
                if (!price2.equals("0")) {
                    dto.setDosinstatus("\ud310\ub9e4\uc911");
                } else {
                    dto.setDosinstatus("\ud488\uc808");
                }
                dto.setOrdimg(img);
                dto.setDsGoods_cost(price2);
                dto.setDsdelv_type("0");
                dto.setDsdelv_cost(deliv_cost);
                dto.setDosinoption((String)option3);
                dto.setSku_value((String)option3);
                dto.setCompayny_goods_cd(prdcode);
                ret.add(dto);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    private void setValue(YDMAProgressBar console, String message, int page) {
        MLinkCommon.get().setValueYDMAprogrssBarisScheduler(console, message, page);
    }

    private void setValueAndJobLog(YDMAProgressBar console, String message, int page, ShopOrderMstDto shopOrderMstDto, String jobType, String jobResult, String logMsg) {
        MLinkCommon.get().setValueYDMAprogrssBarisSchedulerAndJobLog(console, message, page, shopOrderMstDto, jobType, jobResult, logMsg);
    }

    public static class Categorys {
        private String cid;
        private String categ_nm;
        private String depth;

        public String getCid() {
            return this.cid;
        }

        public void setCid(String cid) {
            this.cid = cid;
        }

        public String getCateg_nm() {
            return this.categ_nm;
        }

        public void setCateg_nm(String categ_nm) {
            this.categ_nm = categ_nm;
        }

        public String getDepth() {
            return this.depth;
        }

        public void setDepth(String depth) {
            this.depth = depth;
        }
    }
}

