/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.gsshop;

import com.kdjsystem.mlink.shop.dao.ShopOrderMstDto;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopApiClient;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopOrderColumn;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRow;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRows;
import com.kdjsystem.mlink.shop.data.gsshop.IShopOrderGsShopCommand;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import com.kdjsystem.mlink.tot.common.YDMATimeUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.client.utils.URIBuilder;

public class GsShopOrderSearchCommand
extends IShopOrderGsShopCommand {
    private static GsShopOrderSearchCommand instance = new GsShopOrderSearchCommand();
    private final String \ubc30\uc1a1\uc644\ub8cc = "6";
    private final String \ucde8\uc18c = "3";

    public static GsShopOrderSearchCommand getInstance() {
        return instance;
    }

    private GsShopOrderSearchCommand() {
    }

    @Override
    public List<ShopOrderMstDto> Completed(List<ShopOrderMstDto> param) throws Exception {
        ArrayList<ShopOrderMstDto> retList = new ArrayList<ShopOrderMstDto>();
        Map<String, String> cookies = this.getLoginCookie(param);
        this.searchCancelOrder(param, retList, cookies);
        this.searchDelvCompleteOrder(param, retList, cookies);
        this.searchRetunNExchangeOrder(param, retList, cookies);
        return retList;
    }

    private void searchCancelOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, Map<String, String> cookies) {
        String start = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getStartDt(), false);
        String end = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getEndDt(), false);
        String userId = param.get(0).getShop_userid();
        try {
            GsShopRows rows = GsShopApiClient.search(this.getUrl(userId, start, end, "3"), cookies);
            if (rows.getTotalCount() > 0) {
                for (GsShopRow row : rows.getRows()) {
                    String orderId = row.getCell(GsShopOrderColumn.ORD_NO.idx);
                    String productId = row.getCell(GsShopOrderColumn.PRD_CD.idx);
                    String expid = row.getCell(GsShopOrderColumn.ATTR_PRD_CD.idx);
                    for (ShopOrderMstDto dto : param) {
                        if (!this.isOrderCheck(dto, orderId, productId, expid)) continue;
                        dto.setOrder_status("C02");
                        dto.setResult_code("1");
                        ShopOrderMstDto temp = dto.clone("C02");
                        temp.setOrder_date(row.getCell(GsShopOrderColumn.ORD_CNL_DTM.idx));
                        retList.add(dto);
                        retList.add(temp);
                    }
                }
            }
        }
        catch (Exception exception) {
            YDMAStringUtil.Print("\ucde8\uc18c \uc8fc\ubb38 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\ubc1c\uc0dd");
        }
    }

    private void searchDelvCompleteOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, Map<String, String> cookies) {
        String start = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getStartDt(), false);
        String end = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getEndDt(), false);
        String userId = param.get(0).getShop_userid();
        try {
            GsShopRows rows = GsShopApiClient.search(this.getUrl(userId, start, end, "6"), cookies);
            if (rows.getTotalCount() > 0) {
                for (GsShopRow row : rows.getRows()) {
                    String orderId = row.getCell(GsShopOrderColumn.ORD_NO.idx);
                    String productId = row.getCell(GsShopOrderColumn.PRD_CD.idx);
                    String expid = row.getCell(GsShopOrderColumn.ATTR_PRD_CD.idx);
                    for (ShopOrderMstDto dto : param) {
                        if (!this.isOrderCheck(dto, orderId, productId, expid)) continue;
                        dto.setOrder_status("410");
                        dto.setResult_code("1");
                        retList.add(dto);
                    }
                }
            }
        }
        catch (Exception exception) {
            YDMAStringUtil.Print("\ubc30\uc1a1\uc644\ub8cc \uc8fc\ubb38 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\ubc1c\uc0dd");
        }
    }

    private void searchRetunNExchangeOrder(List<ShopOrderMstDto> param, List<ShopOrderMstDto> retList, Map<String, String> cookies) {
        String start = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getStartDt(), false);
        String end = YDMATimeUtil.convertSabangNetClaimDateToClmdt(param.get(0).getEndDt(), false);
        String userId = param.get(0).getShop_userid();
        try {
            GsShopRows rows = GsShopApiClient.search(this.getReturnNExchangeUrl(userId, start, end), cookies);
            if (rows.getTotalCount() > 0) {
                for (GsShopRow row : rows.getRows()) {
                    String orderId = row.getCell(62);
                    String expid = row.getCell(48);
                    String productId = row.getCell(67);
                    for (ShopOrderMstDto dto : param) {
                        if (!this.isOrderCheck(dto, orderId, productId, expid)) continue;
                        String orderStatus = row.getCell(4);
                        if ("\ubc18\ud488\uc644\ub8cc".equals(orderStatus)) {
                            dto.setOrder_status("R02");
                            dto.setResult_code("1");
                            ShopOrderMstDto temp = dto.clone("R02");
                            temp.setOrder_date(row.getCell(17));
                            retList.add(dto);
                            retList.add(temp);
                            continue;
                        }
                        dto.setOrder_status("R01");
                        dto.setResult_code("1");
                        retList.add(dto);
                    }
                }
            }
        }
        catch (Exception exception) {
            YDMAStringUtil.Print("\ubc30\uc1a1\uc644\ub8cc \uc8fc\ubb38 \ub3d9\uae30\ud654 \uc911 \uc5d0\ub7ec\ubc1c\uc0dd");
        }
    }

    private String getUrl(String usereId, String start, String end, String stat) throws URISyntaxException {
        URIBuilder builder = new URIBuilder("https://withgs.gsshop.com/dlv/dirdlvOrdMng/list").addParameter("flag", "").addParameter("ecDirdlvOboxYn", "").addParameter("dirdlvRelsInfoImprovTgtYn", "N").addParameter("downPsblYn", "null").addParameter("intgSrchLinkOrdNo", "").addParameter("dateTime", YDMATimeUtil.getCurrentTimeByYDFormat()).addParameter("soldOut", "").addParameter("prdCd", "").addParameter("itemCd", "").addParameter("sendFlag", "").addParameter("rcvfromDtm", "").addParameter("rcvToDtm", "").addParameter("rcvQryTerm", "").addParameter("rcvSrchCond", "").addParameter("chkOrgSupCd", usereId).addParameter("chkSupCd", usereId).addParameter("userDownLoadYn", "0").addParameter("mobilCpnAutoRfnSupYn", "N").addParameter("ansimCelphnSupYn", "N").addParameter("srchPrdCd", "").addParameter("giftPkgSupYn", "N").addParameter("hisOrdNo", "").addParameter("allMaskingYn", "N").addParameter("relsSchdDtEntYn", "0").addParameter("qryTerm", "A").addParameter("fromSearchDtm", start).addParameter("toSearchDtm", end).addParameter("prdCdType", "A").addParameter("searchPrdCd", "").addParameter("srchCond", "A").addParameter("srchText", "").addParameter("ordTyp", "0").addParameter("dlvGbn", "0").addParameter("ordCnfYn", "0").addParameter("ordSt", stat).addParameter("fileDownGbn", "1").addParameter("fileDownGbnDtl", "1").addParameter("pageIdx", "1").addParameter("rowsPerPage", "50").addParameter("pageRange", "10");
        URI uri = builder.build();
        return uri.toString();
    }

    private String getReturnNExchangeUrl(String usereId, String start, String end) throws URISyntaxException {
        URIBuilder builder = new URIBuilder("https://withgs.gsshop.com/dlv/dirdlvRtpMng/list").addParameter("flag", "").addParameter("ecDirdlvOboxYn", "").addParameter("downPsblYn", "null").addParameter("intgSrchLinkOrdNo", "").addParameter("chkOrgSupCd", usereId).addParameter("chkSupCd", usereId).addParameter("userDownLoadYn", "0").addParameter("hisOrdNo", "").addParameter("qryTerm", "A").addParameter("fromSearchDtm", start).addParameter("toSearchDtm", end).addParameter("prdCdType", "A").addParameter("searchPrdCd", "").addParameter("srchCond", "A").addParameter("srchText", "").addParameter("pickSubj", "0").addParameter("pickSt", "0").addParameter("arfnSt", "0").addParameter("fileDownGbn", "").addParameter("fileDownGbnDtl", "1").addParameter("pageIdx", "1").addParameter("rowsPerPage", "50").addParameter("pageRange", "10");
        URI uri = builder.build();
        return uri.toString();
    }

    private boolean isOrderCheck(ShopOrderMstDto dto, String orderId, String productId, String expid) {
        return dto.getOrder_id().equals(orderId) && dto.getMall_product_id().equals(productId) && dto.getMall_exp_cd().equals(expid);
    }
}

