/*
 * Decompiled with CFR 0.152.
 */
package com.kdjsystem.mlink.shop.data.gsshop;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kdjsystem.mlink.shop.common.IProduct;
import com.kdjsystem.mlink.shop.common.IProductModifyStatusApi;
import com.kdjsystem.mlink.shop.common.IShopCommonLogin;
import com.kdjsystem.mlink.shop.common.MarketPriceCalc;
import com.kdjsystem.mlink.shop.common.ResultMarketPrice;
import com.kdjsystem.mlink.shop.common.ShopCommon;
import com.kdjsystem.mlink.shop.dao.RegResultDTO;
import com.kdjsystem.mlink.shop.dao.ShopCommonDao;
import com.kdjsystem.mlink.shop.dao.ShopOptionDto;
import com.kdjsystem.mlink.shop.dao.ShopPreferencesDto;
import com.kdjsystem.mlink.shop.dao.ShopProductAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductDto;
import com.kdjsystem.mlink.shop.dao.ShopProductGsShopAdditionDto;
import com.kdjsystem.mlink.shop.dao.ShopProductSendDto;
import com.kdjsystem.mlink.shop.dao.ShoppingMallDetailDto;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopApiClient;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopExitsProductCd;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRow;
import com.kdjsystem.mlink.shop.data.gsshop.GsShopRows;
import com.kdjsystem.mlink.shop.mlink.MLinkCommon;
import com.kdjsystem.mlink.tot.common.YDMAStringUtil;
import java.io.File;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.http.client.utils.URIBuilder;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class GsShopProductModifyService
extends IProductModifyStatusApi {
    JsonParser jsonParser = new JsonParser();
    IShopCommonLogin is = new IShopCommonLogin(){};
    ObjectMapper mapper = new ObjectMapper();

    @Override
    public boolean modifyProductStatusDto(ShopProductDto shopProductDto, ShopProductAdditionDto dtllist, ShoppingMallDetailDto shoppingMallDetailDto, String status2, ShopProductSendDto sendProdList, Map<String, String> cookies) throws Exception {
        this.mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        this.mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        boolean flag = true;
        String loginID = shoppingMallDetailDto.getShoppingid();
        shopProductDto.getCompayny_goods_cd();
        try {
            switch (status2) {
                case "8": {
                    flag = this.saleStop(loginID, shopProductDto, cookies);
                    break;
                }
                case "9": {
                    flag = this.saleResume(loginID, shopProductDto, cookies);
                    break;
                }
                case "6": 
                case "7": {
                    flag = this.deleteOrTerminateSale(loginID, shopProductDto, cookies);
                    break;
                }
                case "0": {
                    throw new Exception("\uc0c1\ud488 \uc218\uc815 \uc2e4\ud328: \uc9c0\uc5d0\uc2a4\uc0f5 \uc0c1\ud488\uc218\uc815 \uc900\ube44\uc911\uc785\ub2c8\ub2e4...");
                }
            }
        }
        catch (Exception e) {
            shopProductDto.setResult_code("-1");
            shopProductDto.setResult_text(e.getMessage());
            return false;
        }
        return flag;
    }

    private boolean saleStop(String loginID, ShopProductDto shopProductDto, Map<String, String> cookies) throws Exception {
        if (shopProductDto.getShopprodno().contains("GSSHOP")) {
            String goodsCd = shopProductDto.getCompayny_goods_cd();
            String prodno = GsShopExitsProductCd.get().getisExistsProdNo(goodsCd, cookies);
            if (prodno.equals(goodsCd)) {
                throw new Exception("\uc544\uc9c1 GS\uc0c1\ud488\ucf54\ub4dc\uac00 \uc0dd\uc131\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4. gs\uc0c1\ud488\ucf54\ub4dc \uc0dd\uc131\ub41c \uc774\ud6c4\uc5d0 \ud310\ub9e4\uc911\uc9c0 \uac00\ub2a5\ud569\ub2c8\ub2e4.");
            }
            shopProductDto.setShopprodno(prodno);
        }
        return this.productTerminateOrStopSale(loginID, shopProductDto.getShopprodno(), cookies, "35");
    }

    private boolean saleResume(String loginID, ShopProductDto shopProductDto, Map<String, String> cookies) throws Exception {
        if (shopProductDto.getShopprodno().contains("GSSHOP")) {
            String goodsCd = shopProductDto.getCompayny_goods_cd();
            String prodno = GsShopExitsProductCd.get().getisExistsProdNo(goodsCd, cookies);
            if (prodno.equals(goodsCd)) {
                throw new Exception("GS\uc0c1\ud488\ucf54\ub4dc\uac00 \uc5c6\ub294\ub370 \ud310\ub9e4\uc911\uc9c0\uc0c1\ud0dc\uc5d0 \uc788\uc744\uc218\uc5c6\uc11c \uc7ac\uac1c \uc2e4\ud328\ud569\ub2c8\ub2e4.");
            }
            shopProductDto.setShopprodno(prodno);
        }
        return this.productResumeSale(loginID, shopProductDto.getShopprodno(), cookies);
    }

    private boolean productResumeSale(String loginID, String goodId, Map<String, String> cookies) throws Exception {
        GsShopRows rows = this.findSaleStatusAndStock(goodId, cookies, "10");
        List<GsShopRow> rowList = rows.getRows();
        if (rowList == null || rowList.isEmpty()) {
            return false;
        }
        ArrayList<SprodIntList> sprodIntList = new ArrayList<SprodIntList>();
        int totcnt = rowList.size();
        for (GsShopRow row : rowList) {
            SprodIntList sprodInt = new SprodIntList();
            sprodInt.suppCode = loginID;
            sprodInt.partNum = row.getCell(6);
            sprodInt.goodId = goodId;
            sprodInt.newSaleFlag = "N";
            sprodInt.oldNewSaleFlag = "Y";
            sprodInt.closeDesc = "";
            sprodInt.allQty = "9999";
            sprodInt.reqAllQty = "0";
            sprodInt.addPoint = "5";
            sprodInt.dtype = row.getCell(42);
            sprodInt.stype = row.getCell(43);
            sprodInt.crtype = row.getCell(44);
            sprodInt.oldSaleFlag = "Y";
            sprodInt.reordTemp = 5;
            sprodInt.parProdIntId = goodId;
            sprodInt.goodNm = row.getCell(8);
            sprodInt.saleEndId = "WITH";
            sprodInt.saleEndIdSub = "WITH";
            sprodInt.qryGbn = "10";
            sprodInt.attrInclYn = "";
            sprodInt.totCnt = totcnt;
            sprodIntList.add(sprodInt);
        }
        try {
            Connection.Response rs = this.getConnection(this.mapper.writeValueAsString(sprodIntList), cookies).execute();
            if (rs.statusCode() == 200) {
                String body = rs.body();
                YDMAStringUtil.Print("================ \uc9c0\uc5d0\uc2a4\uc0f5 \uc0c1\ud488\uc7ac\uac1c \uacb0\uacfc" + body + "============================");
                JsonObject obj = this.jsonParser.parse(body).getAsJsonObject();
                if (obj.has("output") && obj.get("errCnt").getAsInt() == 0) {
                    return true;
                }
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private boolean deleteOrTerminateSale(String loginID, ShopProductDto shopProductDto, Map<String, String> cookies) throws Exception {
        if (shopProductDto.getShopprodno().contains("GSSHOP")) {
            String goodsCd = shopProductDto.getCompayny_goods_cd();
            String prodno = GsShopExitsProductCd.get().getisExistsProdNo(goodsCd, cookies);
            if (prodno.equals(goodsCd)) {
                return this.productDelete(loginID, goodsCd, cookies);
            }
            shopProductDto.setShopprodno(prodno);
        }
        return this.productTerminateOrStopSale(loginID, shopProductDto.getShopprodno(), cookies, "31");
    }

    private boolean productTerminateOrStopSale(String loginID, String goodId, Map<String, String> cookies, String closeDesc) throws Exception {
        GsShopRows rows = this.findSaleStatusAndStock(goodId, cookies, "20");
        List<GsShopRow> rowList = rows.getRows();
        if (rowList == null || rowList.isEmpty()) {
            return false;
        }
        GsShopRow row = rowList.get(0);
        ArrayList<SprodIntList> sprodIntList = new ArrayList<SprodIntList>();
        SprodIntList sprodInt = new SprodIntList();
        sprodInt.suppCode = loginID;
        sprodInt.partNum = "";
        sprodInt.goodId = goodId;
        sprodInt.newSaleFlag = "Y";
        sprodInt.oldNewSaleFlag = "N";
        sprodInt.closeDesc = closeDesc;
        sprodInt.allQty = "";
        sprodInt.reqAllQty = "";
        sprodInt.addPoint = "";
        sprodInt.dtype = row.getCell(42);
        sprodInt.stype = row.getCell(43);
        sprodInt.crtype = row.getCell(44);
        sprodInt.oldSaleFlag = "N";
        sprodInt.reordTemp = 0;
        sprodInt.parProdIntId = goodId;
        sprodInt.goodNm = row.getCell(8);
        sprodInt.saleEndId = "";
        sprodInt.saleEndIdSub = "";
        sprodInt.qryGbn = "20";
        sprodInt.attrInclYn = "Y";
        sprodInt.totCnt = 1;
        sprodIntList.add(sprodInt);
        try {
            Connection.Response rs = this.getConnection(this.mapper.writeValueAsString(sprodIntList), cookies).execute();
            if (rs.statusCode() == 200) {
                String body = rs.body();
                YDMAStringUtil.Print("================ \uc9c0\uc5d0\uc2a4\uc0f5 \uc0c1\ud488\ud310\ub9e4\uc911\uc9c0 \uacb0\uacfc" + body + "============================");
                JsonObject obj = this.jsonParser.parse(body).getAsJsonObject();
                if (obj.has("output") && obj.get("errCnt").getAsInt() == 0) {
                    return true;
                }
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private GsShopRows findSaleStatusAndStock(String goodId, Map<String, String> cookies, String gbn) throws Exception {
        String today = LocalDate.now(ZoneId.of("Asia/Seoul")).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String baseUrl = "https://withgs.gsshop.com/prd/prdMgrList/searchPrdListAjax";
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("suppCode", "");
        params.put("dateFrom", today);
        params.put("dateTo", today);
        params.put("newSaleFlag", "NTYW");
        params.put("goodNm", "");
        params.put("goodId", goodId);
        params.put("intGoodNm", "");
        params.put("suppGoodId", "");
        params.put("promoNm", "");
        params.put("informNm", "");
        params.put("goodType", "");
        params.put("qtyReqTot", "");
        params.put("regSubj", "");
        params.put("dealYn", "N");
        params.put("dealTypCd", "AL");
        params.put("rowsPerPage", "50");
        params.put("goodIdList", "");
        params.put("suppGoodIdList", "");
        params.put("qryGbn", gbn);
        params.put("qryStd", "S");
        params.put("saleEndRsn", "");
        params.put("pageIdx", "1");
        params.put("rowsPerPage", "50");
        params.put("pageRange", "5");
        return GsShopApiClient.search(baseUrl, params, cookies);
    }

    private Connection getConnection(String sprodIntList, Map<String, String> cookies) {
        Connection conn = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdMgrList/updatePrdChgReq").cookies(cookies).header("Accept", "application/json, text/javascript, */*; q=0.01").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").data("sprodIntList", sprodIntList).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).ignoreContentType(true);
        return conn;
    }

    private boolean productDelete(String loginID, String goodsCd, Map<String, String> cookies) {
        ArrayList<GsScmPrdChgreq> gsScmPrdChgReqL = new ArrayList<GsScmPrdChgreq>();
        GsScmPrdChgreq gsScmPrdChgReq = new GsScmPrdChgreq();
        gsScmPrdChgReq.suppCode = loginID;
        gsScmPrdChgReq.suppGoodsCode = goodsCd;
        gsScmPrdChgReqL.add(gsScmPrdChgReq);
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdRegModifyList_M/deletePrd").cookies(cookies).header("Accept", "application/json, text/javascript, */*; q=0.01").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").data("gsScmPrdChgreq", this.mapper.writeValueAsString(gsScmPrdChgReqL)).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                String body = rs.body();
                YDMAStringUtil.Print("================ \uc9c0\uc5d0\uc2a4\uc0f5 \uc0c1\ud488\uc0c2\uac8c \uacb0\uacfc" + body + "============================");
                JsonObject obj = this.jsonParser.parse(body).getAsJsonObject();
                if (obj.has("output")) {
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    private boolean productModify(Map<String, String> jsonMap, Map<String, String> cookies) throws Exception {
        block6: {
            try {
                Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M/modPrdBaseInfo").cookies(cookies).header("Accept", "application/json, text/javascript, */*; q=0.01").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").data("lgecScmProduct", jsonMap.get("lgecScmProduct")).data("lgecScmPrditm", jsonMap.get("lgecScmPrditm")).data("lgecScmPrdGov", jsonMap.get("lgecScmPrdGov")).data("gsScmPrdAsInfo", jsonMap.get("gsScmPrdAsInfo")).data("gsClassAttribList", "[]").data("gsScmAddInfo", jsonMap.get("gsScmAddInfo")).data("gsScmPrdUdas", jsonMap.get("gsScmPrdUdas")).data("regQaAttFileInfo", "[]").data("regDeAttFileInfo", jsonMap.get("regDeAttFileInfo")).data("regQaIngreAttFileInfo", "").data("regPiAttFileInfo", jsonMap.get("regPiAttFileInfo")).data("srcGubun", "W").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").referrer("https://withgs.gsshop.com/prd/prdRegModifyList_M?gMenuId=A2000").method(Connection.Method.POST).ignoreContentType(true).execute();
                if (rs.statusCode() != 200) break block6;
                String body = rs.body();
                YDMAStringUtil.Print("================ \uc9c0\uc5d0\uc2a4\uc0f5 \uc0c1\ud488\uc218\uc815 \uacb0\uacfc" + body + "============================");
                JsonObject obj = this.jsonParser.parse(body).getAsJsonObject();
                if (obj.has("output")) {
                    if (obj.get("output").getAsInt() == 1) {
                        JsonObject prdSaleAgreeDocCntnt = new JsonObject();
                        prdSaleAgreeDocCntnt.addProperty("prdSaleAgreeDocCntnt", "");
                        rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/prdReg_M/prdSaleAgreeDocCre").cookies(cookies).header("Accept", "application/json, text/javascript, */*; q=0.01").header("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8").data("lgecScmProduct", jsonMap.get("lgecScmProduct2")).data("prdSaleAgreeDoc", prdSaleAgreeDocCntnt.getAsString()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").referrer("https://withgs.gsshop.com/prd/prdRegModifyList_M?gMenuId=A2000").method(Connection.Method.POST).ignoreContentType(true).execute();
                        if (rs.statusCode() == 200) {
                            body = rs.body();
                            YDMAStringUtil.Print("================ \uc9c0\uc5d0\uc2a4\uc0f5 \uc0c1\ud488\uc218\uc815 \uac31\uc2e0 \uacb0\uacfc" + body + "============================");
                            obj = this.jsonParser.parse(body).getAsJsonObject();
                            if (obj.has("output")) {
                                return obj.get("output").getAsInt() == 1;
                            }
                            throw new Exception("[ERROR CODE:" + obj.get("_ERROR_CODE").getAsString() + "]" + obj.get("_ERROR_MSG").toString());
                        }
                    }
                    break block6;
                }
                throw new Exception("[ERROR CODE:" + obj.get("_ERROR_CODE").getAsString() + "]" + obj.get("_ERROR_MSG").toString());
            }
            catch (Exception e) {
                throw new Exception("\uc0c1\ud488 \uc218\uc815 \uc911 \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4:" + e.getMessage());
            }
        }
        return false;
    }

    private Map<String, String> makeProductJson(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, String loginID, ShopProductGsShopAdditionDto gsShopAddidto, List<String> strImages, Map<String, String> loginCookies) throws Exception {
        HashMap<String, String> needJsonMap = new HashMap<String, String>();
        LgecScmProduct lgecScmProduct = new LgecScmProduct();
        this.BasicSetting(lgecScmProduct, dto, gsShopAddidto, loginID);
        this.priceSetting(lgecScmProduct, dto, gsShopAddidto);
        this.imageSetting(strImages, lgecScmProduct, loginCookies);
        if (lgecScmProduct.imgFile1.isEmpty()) {
            throw new Exception("\ub300\ud45c\uc774\ubbf8\uc9c0 1\uac1c\ub3c4 \ub4f1\ub85d \uc2e4\ud328 \ud655\uc778 \ud6c4 \ub4f1\ub85d\ud574\uc8fc\uc138\uc694...");
        }
        this.ProductNameSetting(lgecScmProduct, gsShopAddidto, dto);
        this.categorySetting(lgecScmProduct, gsShopAddidto, dto, loginCookies);
        this.displayStoreSeting(lgecScmProduct, gsShopAddidto, loginCookies);
        this.certificationSetting(lgecScmProduct, gsShopAddidto);
        this.DelvierySetting(lgecScmProduct, gsShopAddidto);
        ArrayList<LgecScmPrditm> lgecScmPrditmList = new ArrayList<LgecScmPrditm>();
        this.optionSetting(lgecScmProduct, lgecScmPrditmList, dto, gsShopAddidto);
        List<LgecScmPrdGov> lgecScmPrdGovList = this.lgecScmPrdGovSetting(loginID, dto.getCompayny_goods_cd(), lgecScmProduct.mdId, lgecScmProduct.classCd, loginCookies);
        GsScmPrdAsInfo gsScmPrdAsInfo = this.gsScmPrdAsInfoSetting(loginID, dto, gsShopAddidto);
        GsScmAddInfo gsScmAddInfo = this.gsScmAddInfoSetting(loginID, dto, gsShopAddidto);
        List<GsScmPrdUdas> gsScmPrdUdasList = this.gsScmPrdUdasListSetting(loginID, dto.getCompayny_goods_cd());
        List<RegDeAttFileInfo> regDeAttFileInfoList = this.regDeAttFileInfoSetting(lgecScmProduct.classCd);
        ArrayList<RegPiAttFileInfo> regPiAttFileInfoList = new ArrayList<RegPiAttFileInfo>();
        regPiAttFileInfoList.add(new RegPiAttFileInfo());
        needJsonMap.put("lgecScmProduct", this.mapper.writeValueAsString((Object)lgecScmProduct));
        lgecScmProduct.goodsCode = "";
        needJsonMap.put("lgecScmProduct2", this.mapper.writeValueAsString((Object)lgecScmProduct));
        needJsonMap.put("lgecScmPrditm", this.mapper.writeValueAsString(lgecScmPrditmList));
        needJsonMap.put("lgecScmPrdGov", this.mapper.writeValueAsString(lgecScmPrdGovList));
        needJsonMap.put("gsScmPrdAsInfo", this.mapper.writeValueAsString((Object)gsScmPrdAsInfo));
        needJsonMap.put("gsScmAddInfo", this.mapper.writeValueAsString((Object)gsScmAddInfo));
        needJsonMap.put("gsScmPrdUdas", this.mapper.writeValueAsString(gsScmPrdUdasList));
        needJsonMap.put("regDeAttFileInfo", this.mapper.writeValueAsString(regDeAttFileInfoList));
        needJsonMap.put("regPiAttFileInfo", this.mapper.writeValueAsString(regPiAttFileInfoList));
        return needJsonMap;
    }

    private void BasicSetting(LgecScmProduct reg1, ShopProductDto dto, ShopProductGsShopAdditionDto gsShopAddidto, String loginID) {
        reg1.prefMedia = "EC";
        reg1.media = "EC";
        reg1.chanlCd = "EC";
        reg1.prodType = "S";
        reg1.suppCode = loginID;
        reg1.suppGoodsCode = dto.getCompayny_goods_cd();
        reg1.mdId = gsShopAddidto.getMdGubunId();
        reg1.repMdUserId = gsShopAddidto.getMdId();
        reg1.brandId = gsShopAddidto.getBrandId();
        reg1.brandName = gsShopAddidto.getBrandName();
        reg1.orgprdPkgCnt = String.valueOf(gsShopAddidto.getPackageQuantity());
        reg1.exbType = gsShopAddidto.getOptionDisplayType();
        reg1.taxType = gsShopAddidto.getVatType();
        reg1.factoryName = gsShopAddidto.getManufacturer().isEmpty() ? dto.getMaker() : gsShopAddidto.getManufacturer();
        reg1.nativeCountry = dto.getOrigin();
        reg1.suppModelCode = YDMAStringUtil.setTextStrtok(dto.getModel_nm(), 20);
        reg1.weightUnit = gsShopAddidto.getWeightUnit();
        reg1.weight = String.valueOf(gsShopAddidto.getWeight());
        reg1.mobileCpnAuroRfnSupFlg = "N";
        reg1.bookChkYnFlag = "N";
        reg1.orderMakeType = "";
        reg1.orderMakeTerm = "";
        reg1.orderMakeDesc = "";
        reg1.orderMakeReqRsn = "";
        reg1.goodsCode = dto.getShopprodno();
    }

    private void priceSetting(LgecScmProduct reg1, ShopProductDto dto, ShopProductGsShopAdditionDto gsShopAddidto) throws Exception {
        ResultMarketPrice resultMarketPrice = new ResultMarketPrice();
        try {
            String price_cost;
            if (gsShopAddidto.getAddDeliveryCostYN().equals("Y")) {
                if (gsShopAddidto.getDeliveryFee() == 9999) {
                    if (!dto.getDelv_cost().equals("0")) {
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(dto.getDelv_cost()));
                    } else {
                        ShopPreferencesDto systemconf = ShopCommonDao.get().getSystemConf();
                        price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + Integer.parseInt(systemconf.getDeliverycost()));
                    }
                } else {
                    price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()) + gsShopAddidto.getDeliveryFee());
                }
            } else {
                price_cost = String.valueOf(Integer.parseInt(dto.getGoods_cost()));
            }
            Long salePrice = YDMAStringUtil.convertToLong(price_cost);
            int limit_price = YDMAStringUtil.convertToInt(dto.getLimit_price());
            resultMarketPrice = MarketPriceCalc.get().setCompliancePrice(limit_price).setTestPrice(salePrice.longValue()).setSellerDc(gsShopAddidto.getSellerDc()).setDc(gsShopAddidto.getDcrate()).setFlatDc(gsShopAddidto.getFlatdc()).setMargin(gsShopAddidto.getMargindc()).setCommission(gsShopAddidto.getCommdc()).calculate();
            dto.setGoods_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setMarket_price(resultMarketPrice.getConsumer_if_sale_price());
            dto.setGoods_consumer_price(resultMarketPrice.getConsumer_if_sale_price());
            reg1.khsPrice = resultMarketPrice.getConsumer_if_sale_price();
            reg1.feeAmt = String.valueOf(Math.floor((float)Integer.parseInt(reg1.khsPrice) * (1.0f - gsShopAddidto.getCommdc() / 100.0f)));
            reg1.computedFee = String.valueOf(gsShopAddidto.getCommdc());
        }
        catch (Exception exception) {
            throw new Exception("\uc0c1\ud488\uc0c1\ud0dc, \ud310\ub9e4\uac00 \ub4f1\ub85d \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void imageSetting(List<String> strImages, LgecScmProduct reg1, Map<String, String> loginCookies) {
        String url = "https://withgs.gsshop.com/prd/prdReg_M/prdRegImgInfo_I/upload";
        String suppGoodsCode = reg1.suppGoodsCode;
        int index = 0;
        int size = 0;
        String startTag = "<p id=\"_prdRegUploadMessage\">";
        String endTag = "</p>";
        for (String path : strImages) {
            if (index == 8) break;
            File file = new File(path);
            if (file.exists()) {
                int end;
                int start;
                MultipartBody.Builder builder = this.getImageBuilder(suppGoodsCode, index, size, file);
                String body = GsShopApiClient.postMultipart(url, loginCookies, builder.build());
                if (body.isEmpty() || (start = body.indexOf(startTag)) == -1 || (end = body.indexOf(endTag, start)) == -1) continue;
                String jsonPart = body.substring(start + startTag.length(), end);
                String jsonStr = jsonPart.replace("&#034;", "\"").trim();
                try {
                    JsonNode node = this.mapper.readTree(jsonStr);
                    size = node.get("size").asInt();
                    this.imageBinding(reg1, index, node.get("path").asText() + "/" + node.get("name").asText());
                }
                catch (Exception exception) {
                    continue;
                }
                ++index;
                continue;
            }
            YDMAStringUtil.Print("\uc774\ubbf8\uc9c0 \ud30c\uc77c \uc5c6\uc74c: " + path);
        }
    }

    private MultipartBody.Builder getImageBuilder(String suppGoodsCode, int index, int size, File file) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        builder.addFormDataPart("prdImg", file.getName(), RequestBody.create((MediaType)MediaType.parse((String)"image/jpeg"), (File)file));
        builder.addFormDataPart("kind", "img");
        builder.addFormDataPart("index", String.valueOf(index));
        builder.addFormDataPart("mode", "new");
        builder.addFormDataPart("oldFileName", "");
        builder.addFormDataPart("suppGoodsCode", suppGoodsCode);
        builder.addFormDataPart("oldSize", "0");
        builder.addFormDataPart("totalSize", String.valueOf(size));
        return builder;
    }

    private void imageBinding(LgecScmProduct reg1, int index, String name) {
        switch (index) {
            case 0: {
                reg1.imgFile1 = name;
                break;
            }
            case 1: {
                reg1.imgFile2 = name;
                break;
            }
            case 2: {
                reg1.imgFile3 = name;
                break;
            }
            case 3: {
                reg1.imgFile4 = name;
                break;
            }
            case 4: {
                reg1.imgFile5 = name;
                break;
            }
            case 5: {
                reg1.imgFile6 = name;
                break;
            }
            case 6: {
                reg1.imgFile7 = name;
                break;
            }
            case 7: {
                reg1.imgFile8 = name;
            }
        }
    }

    private void ProductNameSetting(LgecScmProduct reg1, ShopProductGsShopAdditionDto gsShopAddidto, ShopProductDto dto) {
        String value = IProduct.formatProductNameByCode(gsShopAddidto.getProdnmoutput(), dto);
        if (gsShopAddidto.getProdnmafter().equals("Y")) {
            value = ShopCommon.setAddKeywordInProdName(value, dto.getGoods_search(), "B", 99);
        }
        if (gsShopAddidto.getProdnmrand().equals("Y")) {
            value = ShopCommon.setWordRandomGenerator(value);
        }
        if (!gsShopAddidto.getProdnmaddfront().equals("")) {
            value = gsShopAddidto.getProdnmaddfront().concat(value);
        }
        if (!gsShopAddidto.getProdnmaddback().equals("")) {
            value = value.concat(" ").concat(gsShopAddidto.getProdnmaddback());
        }
        reg1.ecPrdName2 = dto.getProdnmlenyn().equals("Y") ? YDMAStringUtil.setTextStrtok(value, 150) : value;
        reg1.goodsName = YDMAStringUtil.setTextStrtok(value, 30);
        reg1.goodsDesc = YDMAStringUtil.setTextStrtok(value, 30);
    }

    private void categorySetting(LgecScmProduct reg1, ShopProductGsShopAdditionDto gsShopAddidto, ShopProductDto dto, Map<String, String> loginCookies) throws Exception {
        if (gsShopAddidto.getUseAdditionalCategory().equals("Y")) {
            reg1.class1 = gsShopAddidto.getLagcatcd();
            reg1.class2 = gsShopAddidto.getMidcatcd();
            reg1.class3 = gsShopAddidto.getSmlcatcd();
            reg1.class4 = gsShopAddidto.getDetcatcd();
            reg1.classCd = gsShopAddidto.getShopcatno();
        } else if (MLinkCommon.get().isNotNullEmpty(dto.getShopCid())) {
            String classcd;
            reg1.classCd = classcd = dto.getShopCid();
            reg1.class1 = classcd.substring(0, 3);
            reg1.class2 = classcd.substring(3, 5);
            reg1.class3 = classcd.substring(5, 7);
            if (classcd.length() == 9) {
                reg1.class4 = classcd.substring(7, 9);
            }
        } else {
            String[] parts;
            if (dto.getGmcategnm() == null || dto.getGmcategnm().isBlank()) {
                throw new Exception("\uce74\ud14c\uace0\ub9ac \uc815\ubcf4\uac00 \uc5c6\uc5b4 \ud0a4\uc6cc\ub4dc \uae30\ubc18 \uac80\uc0c9\uc744 \uc2dc\ub3c4\ud588\uc73c\ub098, \uac80\uc0c9\uc5d0 \ud544\uc694\ud55c \ud0a4\uc6cc\ub4dc\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
            }
            String[] stringArray = parts = dto.getGmcategnm().split(">");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                URIBuilder builder = new URIBuilder("https://withgs.gsshop.com/prd/prdReg_M/ajaxSearchPrdClassList").addParameter("sname", element).addParameter("shopAttrCd", "");
                GsShopRows rows = GsShopApiClient.search(builder.build().toString(), loginCookies);
                List<GsShopRow> rowList = rows.getRows();
                if (rowList != null && !rowList.isEmpty()) {
                    GsShopRow row = rowList.get(0);
                    reg1.class1 = row.getCell(4);
                    reg1.class2 = row.getCell(5);
                    reg1.class3 = row.getCell(6);
                    reg1.class4 = row.getCell(7);
                    reg1.classCd = row.getCell(4) + row.getCell(5) + row.getCell(6) + row.getCell(7);
                    return;
                }
                ++n2;
            }
            throw new Exception("\uce74\ud14c\uace0\ub9ac \uc815\ubcf4\uac00 \uc5c6\uc5b4 \ud0a4\uc6cc\ub4dc \uae30\ubc18 \uac80\uc0c9\uc744 \uc2dc\ub3c4\ud588\uc73c\ub098, \ud0a4\uc6cc\ub4dc\uc5d0 \ub9de\ub294 \uce74\ud14c\uace0\ub9ac\uac00 \ud558\ub098\ub3c4 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
    }

    private void displayStoreSeting(LgecScmProduct reg1, ShopProductGsShopAdditionDto gsShopAddidto, Map<String, String> loginCookies) throws Exception {
        if (!gsShopAddidto.getUseAdditionalDisplayStore().equals("Y")) {
            String categoryName = ShopCommonDao.get().getCategoryMatchCode("shop0007", reg1.classCd);
            String[] names = categoryName.split(">");
            String endName = names[names.length - 1];
            URIBuilder builder = new URIBuilder("https://withgs.gsshop.com/prd/prdReg_M/ajaxSearchSectClassList").addParameter("sname", endName).addParameter("shopAttrCd", "S");
            GsShopRows rows = GsShopApiClient.search(builder.build().toString(), loginCookies);
            List<GsShopRow> rowList = rows.getRows();
            if (rowList != null && !rowList.isEmpty()) {
                GsShopRow row = rowList.get(0);
                reg1.expSectid1 = row.getCell(6);
                reg1.seqSectid = row.getCell(6);
                return;
            }
            throw new Exception("\uce74\ud14c\uace0\ub9ac \ub4b7\ubd80\ubd84 [" + endName + "] \uc73c\ub85c \uac80\uc0c9 \uc2dc \ud574\ub2f9\ub418\ub294 \uc9c4\uc5f4\ub9e4\uc7a5\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        reg1.expSectid1 = gsShopAddidto.getDisplayStoreNo();
        reg1.seqSectid = gsShopAddidto.getDisplayStoreNo();
    }

    private void certificationSetting(LgecScmProduct reg1, ShopProductGsShopAdditionDto gsShopAddidto) {
        reg1.paraImPrdYn = gsShopAddidto.getParaImPrdYn();
        reg1.adultChkYn = gsShopAddidto.getAdultChkYn();
        reg1.cvsRetFlg = gsShopAddidto.getCvsRetFalg();
        reg1.suppNotifyText = gsShopAddidto.getSuppNotifyText();
        reg1.scYnFlag = "3";
        reg1.scYnFlag2 = "3";
        reg1.scNum = "";
        reg1.scGubun = "";
        reg1.scOrg = "0";
        reg1.scModel = "";
        reg1.scDate = "";
        reg1.scFile = "N";
        reg1.scFileName = "";
        reg1.scFileDescYn = "";
        reg1.scEnd = "";
    }

    private void DelvierySetting(LgecScmProduct reg1, ShopProductGsShopAdditionDto gsShopAddidto) {
        reg1.fixShipCntr = gsShopAddidto.getShippingOriginCode();
        reg1.fixRetCntr = gsShopAddidto.getReturnAddressCode();
        reg1.deliveryType = gsShopAddidto.getDeliveryType();
        reg1.collectType = gsShopAddidto.getCollectType();
        reg1.chargeFlag = gsShopAddidto.getDeliveryFeeType();
        reg1.shipPrice = String.valueOf(gsShopAddidto.getDeliveryFee());
        reg1.shipPriceExemptionYN = gsShopAddidto.getDeliveryFeeExemptionYN();
        reg1.shipPriceExemptionPrice = gsShopAddidto.getDeliveryFeeExemptionPrice();
        reg1.rtnFlag = gsShopAddidto.getRefundedAt();
        reg1.carrierMethod = gsShopAddidto.getDeliveryCompany();
        reg1.rtnCharge = gsShopAddidto.getReturnFeeYN();
        reg1.rtnQty = gsShopAddidto.getReturnFee() / 100;
        reg1.chgCharge = gsShopAddidto.getExchangeFeeYN();
        reg1.chgQty = gsShopAddidto.getExchangeFee() / 100;
        reg1.packShipFlag = gsShopAddidto.getPackShipFlag();
        reg1.lengthUnit = gsShopAddidto.getLenthCode();
        reg1.quantityUnit = gsShopAddidto.getWeightCode();
        reg1.jejuRtpAmtYn = gsShopAddidto.getJejuAddReturnFeeYN();
        reg1.jejuExchAmtYn = gsShopAddidto.getJejuAddExchangeFeeYN();
        reg1.ilndRtpAmtYn = gsShopAddidto.getIslandsMountainsAddReturnFeeYN();
        reg1.ilndExchAmtYn = gsShopAddidto.getIslandsMountainsAddExchangeFeeYN();
        if (gsShopAddidto.getJejuAndIslandsMountainsYN().equals("Y")) {
            reg1.jejuDlvPsblYn = gsShopAddidto.getJejuShippingAvailableYN();
            reg1.jejuChrDlvYn = gsShopAddidto.getJejuAddDeliveryFeeYN();
            reg1.jejuExchRtpChrYn = gsShopAddidto.getJejuAddReturnFeeYN();
            reg1.ilndDlvPsblYn = gsShopAddidto.getIslandsMountainsShippingAvailableYN();
            reg1.ilndChrDlvYn = gsShopAddidto.getIslandsMountainsAddDeliveryFeeYN();
            reg1.ilndExchRtpChrYn = gsShopAddidto.getIslandsMountainsAddReturnFeeYN();
            reg1.jejuChrDlvcAmt = String.valueOf(gsShopAddidto.getJejuAddDeliveryFee());
            reg1.jejuRtpAmt = String.valueOf(gsShopAddidto.getJejuAddReturnFee());
            reg1.jejuExchAmt = String.valueOf(gsShopAddidto.getJejuAddExchangeFee());
            reg1.ilndChrDlvcAmt = String.valueOf(gsShopAddidto.getIslandsMountainsAddDeliveryFee());
            reg1.ilndRtpAmt = String.valueOf(gsShopAddidto.getIslandsMountainsAddReturnFee());
            reg1.ilndExchAmt = String.valueOf(gsShopAddidto.getIslandsMountainsAddExchangeFee());
        } else {
            reg1.jejuDlvPsblYn = "N";
            reg1.jejuChrDlvYn = "N";
            reg1.jejuExchRtpChrYn = "N";
            reg1.ilndDlvPsblYn = "N";
            reg1.ilndChrDlvYn = "N";
            reg1.ilndExchRtpChrYn = "N";
            reg1.jejuChrDlvcAmt = "0";
            reg1.jejuRtpAmt = "0";
            reg1.jejuExchAmt = "0";
            reg1.ilndChrDlvcAmt = "0";
            reg1.ilndRtpAmt = "0";
            reg1.ilndExchAmt = "0";
        }
        reg1.stdRelsDt = gsShopAddidto.getStandardShippingDate();
        reg1.thedayRels = gsShopAddidto.getSameDayShippingCutoffTime();
        reg1.rtnShipPrdid = "1092355615";
        reg1.jejuRtpDlvcCd = "1092355615";
        reg1.jejuRtpOnewyRndtrpCd = 60;
        reg1.jejuExchOnewyRndtrpCd = 60;
        reg1.ilndChrDlvcCd = "1092355615";
        reg1.ilndRtpOnewyRndtrpCd = 100;
        reg1.ilndExchOnewyRndtrpCd = 100;
        reg1.ilndRtpDlvcCd = "1092355615";
    }

    private void optionSetting(LgecScmProduct reg1, List<LgecScmPrditm> regList, ShopProductDto dto, ShopProductGsShopAdditionDto gsShopAddidto) {
        String prdid = dto.getShopprodno();
        if (dto.getChar_1_nm().equals("\ub2e8\ud488")) {
            reg1.attrTitle1 = "\ubcf8\uc81c\ud488";
            reg1.attrTitle2 = "SIZE";
            reg1.attrTitle3 = "STYLE";
            reg1.attrTitle4 = "\ubcc4\ub3c4\uad6c\uc131";
            LgecScmPrditm reg2 = new LgecScmPrditm();
            reg2.attrTitleCd1 = "\ubcf8\uc81c\ud488";
            reg2.attrTitleCd2 = "SIZE";
            reg2.attrTitleCd3 = "STYLE";
            reg2.attrTitleCd4 = "\ubcc4\ub3c4\uad6c\uc131";
            reg2.exbType = reg1.exbType;
            reg2.suppCode = reg1.suppCode;
            reg2.suppGoodsCode = reg1.suppGoodsCode;
            reg2.ordQty = String.valueOf(gsShopAddidto.getOrderableQty());
            reg2.atpQty = String.valueOf(gsShopAddidto.getStockAlertQty());
            reg2.colorDesc = "\ub2e8\ud488";
            reg2.sizeDesc = "None";
            reg2.styleDesc = "None";
            reg2.freeGiftDesc = "None";
            reg2.exposSeq = "1";
            regList.add(reg2);
        } else {
            List<ShopOptionDto> optionList = this.getProductOptions(dto);
            ArrayList<String> option1List = new ArrayList<String>();
            ArrayList<String> option2List = new ArrayList<String>();
            ArrayList<String> option3List = new ArrayList<String>();
            for (ShopOptionDto opt : optionList) {
                String optSpec = opt.getOptspecdes();
                if (opt.getName().contains("\ud488\uc808") || opt.getOptspecdes().contains("\ud488\uc808") || opt.getCnt().equals("0")) continue;
                String[] options = optSpec.split(":");
                if (options.length > 0) {
                    option1List.add(options[0]);
                }
                if (options.length > 1) {
                    option2List.add(options[1]);
                }
                if (options.length <= 2) continue;
                option3List.add(options[2]);
            }
            String optionNameRaw = optionList.get(0).getName().replaceAll("&", "");
            String[] optionNames = optionNameRaw.split(":");
            int optionDepth = this.getOpgetOptionDepthtionDepth(option1List, option2List, option3List);
            switch (optionDepth) {
                case 1: {
                    reg1.attrTitle1 = optionNames[0];
                    reg1.attrTitle2 = "SIZE";
                    reg1.attrTitle3 = "STYLE";
                    reg1.attrTitle4 = "\ubcc4\ub3c4\uad6c\uc131";
                    int i = 0;
                    while (i < option1List.size()) {
                        LgecScmPrditm reg2 = new LgecScmPrditm();
                        reg2.attrTitleCd1 = optionNames[0];
                        reg2.attrTitleCd2 = "SIZE";
                        reg2.attrTitleCd3 = "STYLE";
                        reg2.attrTitleCd4 = "\ubcc4\ub3c4\uad6c\uc131";
                        reg2.exbType = reg1.exbType;
                        reg2.suppCode = reg1.suppCode;
                        reg2.suppGoodsCode = reg1.suppGoodsCode;
                        reg2.ordQty = String.valueOf(gsShopAddidto.getOrderableQty());
                        reg2.atpQty = String.valueOf(gsShopAddidto.getStockAlertQty());
                        reg2.colorDesc = (String)option1List.get(i);
                        reg2.sizeDesc = "None";
                        reg2.styleDesc = "None";
                        reg2.freeGiftDesc = "None";
                        reg2.exposSeq = String.valueOf(i);
                        reg2.prdid = prdid;
                        reg2.variantsCode = prdid + "00" + (i + 1);
                        reg2.suppPrditmid = prdid + "00" + (i + 1);
                        regList.add(reg2);
                        ++i;
                    }
                    break;
                }
                case 2: {
                    reg1.attrTitle1 = optionNames[0];
                    reg1.attrTitle2 = optionNames[1];
                    reg1.attrTitle3 = "STYLE";
                    reg1.attrTitle4 = "\ubcc4\ub3c4\uad6c\uc131";
                    int i = 0;
                    while (i < option1List.size()) {
                        LgecScmPrditm reg2 = new LgecScmPrditm();
                        reg2.attrTitleCd1 = optionNames[0];
                        reg2.attrTitleCd2 = optionNames[1];
                        reg2.attrTitleCd3 = "STYLE";
                        reg2.attrTitleCd4 = "\ubcc4\ub3c4\uad6c\uc131";
                        reg2.exbType = reg1.exbType;
                        reg2.suppCode = reg1.suppCode;
                        reg2.suppGoodsCode = reg1.suppGoodsCode;
                        reg2.ordQty = String.valueOf(gsShopAddidto.getOrderableQty());
                        reg2.atpQty = String.valueOf(gsShopAddidto.getStockAlertQty());
                        reg2.colorDesc = (String)option1List.get(i);
                        reg2.sizeDesc = (String)option2List.get(i);
                        reg2.styleDesc = "None";
                        reg2.freeGiftDesc = "None";
                        reg2.exposSeq = String.valueOf(i);
                        reg2.prdid = prdid;
                        reg2.variantsCode = prdid + "00" + (i + 1);
                        reg2.suppPrditmid = prdid + "00" + (i + 1);
                        regList.add(reg2);
                        ++i;
                    }
                    break;
                }
                case 3: {
                    reg1.attrTitle1 = optionNames[0];
                    reg1.attrTitle2 = optionNames[1];
                    reg1.attrTitle3 = optionNames[2];
                    reg1.attrTitle4 = "\ubcc4\ub3c4\uad6c\uc131";
                    int i = 0;
                    while (i < option1List.size()) {
                        LgecScmPrditm reg2 = new LgecScmPrditm();
                        reg2.attrTitleCd1 = optionNames[0];
                        reg2.attrTitleCd2 = optionNames[1];
                        reg2.attrTitleCd3 = optionNames[2];
                        reg2.attrTitleCd4 = "\ubcc4\ub3c4\uad6c\uc131";
                        reg2.exbType = reg1.exbType;
                        reg2.suppCode = reg1.suppCode;
                        reg2.suppGoodsCode = reg1.suppGoodsCode;
                        reg2.ordQty = String.valueOf(gsShopAddidto.getOrderableQty());
                        reg2.atpQty = String.valueOf(gsShopAddidto.getStockAlertQty());
                        reg2.colorDesc = (String)option1List.get(i);
                        reg2.sizeDesc = (String)option2List.get(i);
                        reg2.styleDesc = (String)option3List.get(i);
                        reg2.freeGiftDesc = "None";
                        reg2.exposSeq = String.valueOf(i);
                        reg2.prdid = prdid;
                        reg2.variantsCode = prdid + "00" + (i + 1);
                        reg2.suppPrditmid = prdid + "00" + (i + 1);
                        regList.add(reg2);
                        ++i;
                    }
                    break;
                }
            }
        }
    }

    private int getOpgetOptionDepthtionDepth(List<String> option1List, List<String> option2List, List<String> option3List) {
        if (option2List.isEmpty()) {
            return 1;
        }
        if (option3List.isEmpty()) {
            return 2;
        }
        return 3;
    }

    private List<LgecScmPrdGov> lgecScmPrdGovSetting(String loginID, String suppGoodsCode, String mdId, String prdClass, Map<String, String> cookies) throws Exception {
        ArrayList<LgecScmPrdGov> list = new ArrayList<LgecScmPrdGov>();
        try {
            Connection.Response rs = Jsoup.connect((String)"https://withgs.gsshop.com/prd/iframe/prdRegPrdGovIframe/listPrdLargeGovGrpNm").data("prdClass", prdClass).data("govPublsPrdGrpCd", "").userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(cookies).header("Accept", "application/json, text/javascript, */*; q=0.01").method(Connection.Method.POST).ignoreContentType(true).execute();
            if (rs.statusCode() == 200) {
                URIBuilder builder;
                JsonObject obj = this.jsonParser.parse(rs.body()).getAsJsonObject();
                JsonArray output = obj.get("output").getAsJsonArray();
                String govPublsPrdGrpCd = "";
                for (JsonElement ele : output) {
                    obj = ele.getAsJsonObject();
                    if (!obj.has("govPublsPrdGrpCd") || obj.get("govPublsPrdGrpCd").isJsonNull() || !"43".equals(obj.get("govPublsPrdGrpCd").getAsString())) continue;
                    govPublsPrdGrpCd = "43";
                    break;
                }
                if (govPublsPrdGrpCd.isEmpty()) {
                    govPublsPrdGrpCd = output.get(0).getAsJsonObject().get("govPublsPrdGrpCd").getAsString();
                }
                if ((rs = Jsoup.connect((String)(builder = new URIBuilder("https://withgs.gsshop.com/prd/prdReg_M/iframe/prdRegPrdGovNew").addParameter("editMode", "Y").addParameter("viewType", "U").addParameter("prdClass", prdClass).addParameter("prdClassAll", prdClass).addParameter("govPublsPrdGrpCd", govPublsPrdGrpCd).addParameter("suppGoodsCode", "").addParameter("media", "EC")).build().toString()).userAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36").cookies(cookies).header("Accept", "application/json, text/javascript, */*; q=0.01").method(Connection.Method.POST).ignoreContentType(true).execute()).statusCode() == 200) {
                    obj = this.jsonParser.parse(rs.body()).getAsJsonObject();
                    JsonArray prdGovGList = obj.get("prdGovGList").getAsJsonArray();
                    for (JsonElement ele : prdGovGList) {
                        obj = ele.getAsJsonObject();
                        String exposeSeq = obj.get("exposSeq").getAsString();
                        String govPublsItmNm = obj.get("govPublsItmNm").getAsString();
                        String noteCntnt = obj.has("noteCntnt") && !obj.get("noteCntnt").isJsonNull() ? obj.get("noteCntnt").getAsString() : "";
                        String govPublsItmCntnt = obj.has("govPublsItmCntnt") && !obj.get("govPublsItmCntnt").isJsonNull() ? obj.get("govPublsItmCntnt").getAsString() : "\uc0c1\ud488 \uc0c1\uc138\uc815\ubcf4\uc5d0 \ubcc4\ub3c4 \ud45c\uae30";
                        String govPublsItmCd = obj.get("govPublsItmCd").getAsString();
                        String compGbnCd = obj.has("compGbnCd") && !obj.get("compGbnCd").isJsonNull() ? obj.get("compGbnCd").getAsString() : "";
                        list.add(this.createLgecScmPrdGov(loginID, suppGoodsCode, exposeSeq, govPublsItmNm, noteCntnt, govPublsItmCntnt, govPublsItmCd, compGbnCd, mdId, prdClass));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new Exception("\uc9c0\uc5d0\uc2a4\uc0f5 \uace0\uc2dc\uc815\ubcf4 \uc138\ud305 \uc911, \uc5d0\ub7ec\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4 [" + String.valueOf(e) + "]");
        }
        return list;
    }

    private LgecScmPrdGov createLgecScmPrdGov(String suppCode, String suppGoodsCode, String exposSeq, String govPublsItmNm, String noteCntnt, String govPublsItmCntnt, String govPublsItmCd, String compGbnCd, String mdId, String prdClass) {
        LgecScmPrdGov lgecScmPrdGov = new LgecScmPrdGov();
        lgecScmPrdGov.suppCode = suppCode;
        lgecScmPrdGov.suppGoodsCode = suppGoodsCode;
        lgecScmPrdGov.exposSeq = exposSeq;
        lgecScmPrdGov.govPublsItmNm = govPublsItmNm;
        lgecScmPrdGov.govPublsItmCntnt = govPublsItmCntnt;
        lgecScmPrdGov.govPublsItmCd = govPublsItmCd;
        if (!noteCntnt.isEmpty()) {
            lgecScmPrdGov.noteCntnt = noteCntnt;
            lgecScmPrdGov.errYn = "N";
        }
        if (!compGbnCd.isEmpty()) {
            lgecScmPrdGov.compGbnCd = compGbnCd;
        }
        lgecScmPrdGov.mdId = mdId;
        lgecScmPrdGov.prdClass = prdClass;
        return lgecScmPrdGov;
    }

    private GsScmPrdAsInfo gsScmPrdAsInfoSetting(String loginID, ShopProductDto dto, ShopProductGsShopAdditionDto gsShopAddidto) {
        GsScmPrdAsInfo gsScmPrdAsInfo = new GsScmPrdAsInfo();
        gsScmPrdAsInfo.prdid = "";
        gsScmPrdAsInfo.prdId = "";
        gsScmPrdAsInfo.suppCode = loginID;
        gsScmPrdAsInfo.suppGoodsCode = dto.getCompayny_goods_cd();
        gsScmPrdAsInfo.asInfo = "";
        gsScmPrdAsInfo.settleInfo = "30";
        gsScmPrdAsInfo.mdId = gsShopAddidto.getMdGubunId();
        gsScmPrdAsInfo.brandId = gsShopAddidto.getBrandId();
        return gsScmPrdAsInfo;
    }

    private GsScmAddInfo gsScmAddInfoSetting(String loginID, ShopProductDto dto, ShopProductGsShopAdditionDto gsShopAddidto) {
        GsScmAddInfo gsScmAddInfo = new GsScmAddInfo();
        gsScmAddInfo.prdid = "";
        gsScmAddInfo.suppCode = loginID;
        gsScmAddInfo.suppGoodsCode = dto.getCompayny_goods_cd();
        gsScmAddInfo.mobileStation = "SK";
        gsScmAddInfo.mobileName = "";
        gsScmAddInfo.mobilePrc = "";
        gsScmAddInfo.appUrl = "";
        gsScmAddInfo.freeYn = "N";
        gsScmAddInfo.appYn = "N";
        gsScmAddInfo.svcYn = "N";
        gsScmAddInfo.cardYn = "N";
        gsScmAddInfo.settleInfo = "01";
        gsScmAddInfo.mdId = gsShopAddidto.getMdGubunId();
        gsScmAddInfo.brandId = gsShopAddidto.getBrandId();
        gsScmAddInfo.jobFlag = "I";
        return gsScmAddInfo;
    }

    private List<GsScmPrdUdas> gsScmPrdUdasListSetting(String loginID, String suppGoodsCode) {
        ArrayList<GsScmPrdUdas> list = new ArrayList<GsScmPrdUdas>();
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 1, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 2, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 3, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 4, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 5, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 6, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 7, "09"));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 8, "18"));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 9, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 10, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 11, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 12, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 13, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 14, ""));
        list.add(this.createGsScmPrdUdas(loginID, suppGoodsCode, 15, "N"));
        return list;
    }

    private GsScmPrdUdas createGsScmPrdUdas(String loginID, String suppGoodsCode, int udaId, String udaValue) {
        GsScmPrdUdas gsScmPrdUdas = new GsScmPrdUdas();
        gsScmPrdUdas.suppCode = loginID;
        gsScmPrdUdas.suppGoodsCode = suppGoodsCode;
        gsScmPrdUdas.udaId = udaId;
        gsScmPrdUdas.udaValue = udaValue;
        return gsScmPrdUdas;
    }

    private List<RegDeAttFileInfo> regDeAttFileInfoSetting(String classCd) {
        ArrayList<RegDeAttFileInfo> list = new ArrayList<RegDeAttFileInfo>();
        list.add(this.createRegDeAttFileInfo("50", "\ud45c\uc2dc\uad11\uace0 \uc99d\ube59\uc11c\ub958 1", classCd));
        list.add(this.createRegDeAttFileInfo("51", "\ud45c\uc2dc\uad11\uace0 \uc99d\ube59\uc11c\ub958 2", classCd));
        list.add(this.createRegDeAttFileInfo("39", "\ud45c\uc2dc\uad11\uace0 \uc99d\ube59\uc11c\ub958 3", classCd));
        return list;
    }

    private RegDeAttFileInfo createRegDeAttFileInfo(String supPrdNeedDocNo, String docNm, String classCd) {
        RegDeAttFileInfo regDeAttFileInfo = new RegDeAttFileInfo();
        regDeAttFileInfo.supPrdNeedDocNo = supPrdNeedDocNo;
        regDeAttFileInfo.docNm = docNm;
        regDeAttFileInfo.noteCntnt = "\"\ud45c\uc2dc\uad11\uace0\uc5d0 \ub300\ud55c \uc99d\ube59 \uc790\ub8cc<br/>\\n- KC\uc778\uc99d, \uc548\uc804\ud655\uc778\ub300\uc0c1\uc0dd\ud65c\ud654\ud559\uc81c\ud488\uc778\uc99d, \ud488\ubaa9\uc81c\uc870\ubcf4\uace0\uc11c, \uce5c\ud658\uacbd,\uc720\uae30\ub18d\uc778\uc99d, \ud2b9\ud5c8, \uc2dc\ud5d8\uc131\uc801\uc11c\"";
        regDeAttFileInfo.prdClsCd = classCd;
        return regDeAttFileInfo;
    }

    @Override
    public boolean isExistProdNo(ShopProductDto dto, ShoppingMallDetailDto shoppingMallDetailDto, Map<String, String> cookies) throws Exception {
        String date364DaysAgo = LocalDate.now(ZoneId.of("Asia/Seoul")).minusDays(364L).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String today = LocalDate.now(ZoneId.of("Asia/Seoul")).format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        String coGoodsCond = "";
        String coGoodsTxt = "";
        if (dto.getShopprodno().contains("GSSHOP")) {
            coGoodsCond = "1";
            coGoodsTxt = dto.getCompayny_goods_cd();
        } else {
            coGoodsCond = "2";
            coGoodsTxt = dto.getShopprodno();
        }
        String baseUrl = "https://withgs.gsshop.com/prd/prdRegModifyList_M/list";
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("coGoodsCond", coGoodsCond);
        params.put("coGoodsNmCond", "1");
        params.put("setInfo1", "Y");
        params.put("setInfo2", "Y");
        params.put("setInfo3", "Y");
        params.put("setInfo4", "Y");
        params.put("setInfo5", "Y");
        params.put("coSetDe", "0");
        params.put("coSetMd", "0");
        params.put("coSetSh", "0");
        params.put("coSetQa", "0");
        params.put("coGoodsTxt", coGoodsTxt);
        params.put("coGoodsNmTxt", "");
        params.put("coMediaType", "");
        params.put("blckPrd", "");
        params.put("regSubj", "");
        params.put("dpatOpVal", "");
        params.put("saleEndRsnCd", "");
        params.put("clsChkStCd", "");
        params.put("mdId", "");
        params.put("rowsPerPage", "50");
        params.put("dateFrom", date364DaysAgo);
        params.put("dateTo", today);
        params.put("pageIdx", "1");
        params.put("pageRange", "10");
        try {
            GsShopRows rows = GsShopApiClient.search(baseUrl, params, cookies);
            if (rows.getTotalCount() > 0) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    @Override
    public RegResultDTO deleteAfterRegister(ShopProductSendDto sendInfo, ShopProductDto prodInfo) throws Exception {
        return null;
    }

    @Override
    public boolean deleteProduct(ShopProductDto shopProductDto) throws Exception {
        return false;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class GsScmAddInfo {
        private String prdid;
        private String suppCode;
        private String suppGoodsCode;
        private String mobileStation;
        private String mobileName;
        private String mobilePrc;
        private String appUrl;
        private String freeYn;
        private String appYn;
        private String svcYn;
        private String cardYn;
        private String settleInfo;
        private String mdId;
        private String brandId;
        private String jobFlag;

        private GsScmAddInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class GsScmPrdAsInfo {
        private String prdId;
        private String prdid;
        private String suppCode;
        private String suppGoodsCode;
        private String asInfo;
        private String settleInfo;
        private String mdId;
        private String brandId;

        private GsScmPrdAsInfo() {
        }
    }

    private class GsScmPrdChgreq {
        private String suppCode;
        private String suppGoodsCode;

        private GsScmPrdChgreq() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class GsScmPrdUdas {
        private String suppCode;
        private String suppGoodsCode;
        private String goodsCode = "";
        private int udaId;
        private String udaValue;
        private String regType = "I";

        private GsScmPrdUdas() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class LgecScmPrdGov {
        private String suppCode;
        private String suppGoodsCode;
        private String exposSeq;
        private String govPublsPrdGrpCd = "43";
        private String chgGovPublsPrdGrpCd = "43";
        private String oldGovPublsPrdGrpCd = "43";
        private String govPublsItmNm;
        private String noteCntnt;
        private String lineType = "G";
        private String type = "I";
        private String govPublsItmCd;
        private String govPublsItmCntnt;
        private String prdExplnGbnCd = "G";
        private String compGbnCd;
        private String exposyn = "1";
        private String mandYn = "Y";
        private String media = "EC";
        private String mdId;
        private String prdClass;
        private String errYn;

        private LgecScmPrdGov() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class LgecScmPrditm {
        private String type = "C";
        private String prdid = "1104752963";
        private String rowId = "";
        private String attrTitleCd1;
        private String attrTitleCd2;
        private String attrTitleCd3;
        private String attrTitleCd4;
        private String exbType;
        private String styleType = "G";
        private String suppCode;
        private String suppGoodsCode;
        private String color = "";
        private String goodsSize = "";
        private String style = "";
        private String freeGift = "";
        private String ordQty;
        private String atpQty;
        private String dmOrdQty = "";
        private String inactiveDate = "";
        private String prditmid = "";
        private String variantsCode = "";
        private String settleInfo = "30";
        private String colorDesc;
        private String sizeDesc;
        private String styleDesc;
        private String freeGiftDesc;
        private String imsiFlag = "";
        private String mdId = "";
        private String brandId = "";
        private String prefMedia = "";
        private String colorArs = "";
        private String sizeArs = "";
        private String styleArs = "";
        private String freeGiftArs = "";
        private String saleCloseTxt = "";
        private String suppModelCode = "";
        private String exposSeq;
        private String suppPrditmid;
        private String optGrpCdChgYn = "N";
        private List<Object> supPrdAttrOptList = new ArrayList<Object>();

        private LgecScmPrditm() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class LgecScmProduct {
        private String taxPaperFlag = "Y";
        private String fixShipFlag = "N";
        private String fixShipPrdid = "";
        private String fixShipAmt = "0";
        private String consignDeFlag = "N";
        private String consignReFlag = "N";
        private String dtctCd = "";
        private String fixShipCntr;
        private String fixRetCntr;
        private String suppCode;
        private String suppGoodsCode;
        private String line1Class = "";
        private String line2Class = "";
        private String line3Class = "";
        private String class1;
        private String class2;
        private String class3;
        private String class4;
        private String classCd;
        private String goodsName;
        private String cgInfo1 = "";
        private String nativeCountry;
        private String factoryName;
        private String factoryBizno = "";
        private String lastCost = "";
        private String khsPrice;
        private String mdId;
        private String sufficientCnt = "";
        private String slideGubun = "";
        private String sectid = "";
        private String imgFile1 = "";
        private String imgFile2 = "";
        private String imgFile3 = "";
        private String imgFile4 = "";
        private String imgFile5 = "";
        private String imgFile6 = "";
        private String imgFile7 = "";
        private String imgFile8 = "";
        private String expReqDate = "";
        private String goodsCode = "";
        private String insFlag = "";
        private String sendFlag = "";
        private String sectDispFlag = "";
        private String enterId = "";
        private String enterDate = "";
        private String goodsDesc;
        private String cgInfo2 = "";
        private String cgInfo3 = "";
        private String cgInfo4 = "";
        private String taxType;
        private String deliveryType;
        private String collectType;
        private String shipCode = "";
        private String settleInfo = "01";
        private String carrierMethod;
        private String width = "";
        private String length = "";
        private String height = "";
        private String feeType = "01";
        private String feeAmt;
        private String descImg1 = "";
        private String descImg2 = "";
        private String descImg3 = "";
        private String descImg4 = "";
        private String descImg5 = "";
        private String descImg6 = "";
        private String descImg7 = "";
        private String descImg8 = "";
        private String descImg9 = "";
        private String descImg10 = "";
        private String expSectid1;
        private String expSectid2 = "";
        private String expSectid3 = "";
        private String expSectid4 = "";
        private String expSectid5 = "";
        private String expSectid6 = "";
        private String expSectid7 = "";
        private String expSectid8 = "";
        private String expSectid9 = "";
        private String gift = "";
        private String qaRemiReq = "";
        private String purchaseType = "03";
        private String ordQty = "";
        private String prodType;
        private String ordPattern = "";
        private String jucklibFlag = "";
        private String juklibType = "";
        private String juklibClass = "";
        private String muijaType = "";
        private String muijaInstallMm = "";
        private String juklibClassExternal = "";
        private String atpFlag = "N";
        private String ecAddPoint = "";
        private String insPath = "";
        private String ecPrdName1 = "";
        private String ecPrdName2;
        private String ecPrdName3 = "";
        private String oahuPmoName = "";
        private String suppGoodsName = "";
        private String exbType;
        private String attrTitleCd1 = "";
        private String attrTitleCd2 = "";
        private String attrTitleCd3 = "";
        private String attrTitleCd4 = "";
        private String imgFileGift1 = "";
        private String imgFileGift2 = "";
        private String styleChkFlg = "";
        private String mdNotifyText = "";
        private String chargeFlag;
        private String descType = "";
        private String suppModelCode;
        private String brandId;
        private String brandName;
        private String openNotFlag = "";
        private String clsfyDate = "";
        private String clsfyStatus = "";
        private String clsfyCmmnt = "";
        private String regFlag = "";
        private String subsuppCd = "";
        private String reserveSaleYn = "";
        private String orderMakeYn = "false";
        private String ecstdDay = "";
        private String subDesc = "";
        private String codeChk = "";
        private String prdAuth = "";
        private String gatherType = "";
        private String afterShipYn = "";
        private String shipPrice;
        private String shipPriceExemptionYN;
        private int shipPriceExemptionPrice;
        private String attrTitle1;
        private String attrTitle2;
        private String attrTitle3;
        private String attrTitle4;
        private String attrMngYn = "Y";
        private String giftType = "";
        private String shipLimitAmt = "";
        private String subPackFlag = "";
        private String rtnFlag;
        private String rtnTime = "";
        private String rtnCharge;
        private String rtnShipPrdid;
        private int rtnQty;
        private int chgQty;
        private String scYnFlag;
        private String scYnFlag2;
        private String scNum;
        private String scGubun;
        private String scOrg;
        private String scModel;
        private String scDate;
        private String scFile;
        private String scFileName;
        private String scFileDescYn;
        private String scEnd;
        private String ifYn = "";
        private String adultChkYn;
        private String chargePlusFlag = "";
        private String returnDesc = "";
        private String shipLimitAmtFlag = "";
        private String shipLimitYn = "";
        private String prodDate = "";
        private String searchKey1 = "";
        private String tmpString = "";
        private String computedFee;
        private String bookChkYnFlag;
        private String requestMemo = "";
        private String reserveStartDate = "";
        private String reserveEndDate = "";
        private String reserveShipDate = "";
        private String reserveShipEndDate = "";
        private String orderMakeTerm;
        private String orderMakeType;
        private String orderMakeDesc;
        private String orderMakeReqRsn;
        private String shipCondTxt = "";
        private String isCallBS = "";
        private String settleInfoUpdate = "";
        private String isInterfaceBS = "";
        private String cvsRetFlg;
        private String prefMedia;
        private String media;
        private String dmOrdQty = "";
        private String orderAloneLimit = "N";
        private String sizeCd = "";
        private String weightUnit;
        private String weight;
        private String softFlag = "";
        private String barcode = "";
        private String seqSectid;
        private String suppNotifyText;
        private String smsKind = "";
        private String smsType = "";
        private String packShipFlag;
        private String lengthUnit;
        private String quantity = "";
        private String quantityUnit;
        private String prdAddCmposCntnt = "";
        private String addCmposPkgCnt = "";
        private String addCmposMnfcCoNm = "";
        private String addCmposOrgpNm = "";
        private String prdAddPkgYn = "N";
        private String orgprdPkgCnt;
        private String repMdUserId;
        private String subRepMdUserId = "";
        private String mobileCpnAuroRfnSupFlg = "N";
        private String autoRfnRt = "";
        private String validTermGbn = "";
        private String validTermDdcnt = "";
        private String validDtm = "";
        private String validEndTime = "";
        private String instlCostYn = "";
        private String dpatOpVal = "";
        private String gshsPickYn = "N";
        private String llcGshsPickYn = "N";
        private String dpatMargnSeq = "";
        private String orgpCd = "";
        private String forgnDlvPsblYn = "N";
        private String forgnDlvWeihtVal = "";
        private String stdRelsDt;
        private String thedayRels;
        private String dirdlvMngAgncyYn = "N";
        private String bundlDlvPsblQty = "";
        private String forgnDirprhYn = "";
        private String prdRelsCntryVal = "";
        private String shipOverRsn = "";
        private String shipRtnOverRsn = "";
        private String clerncSign = "";
        private String chanlCd;
        private String imgFile12 = "";
        private String addDesc = "";
        private String jejuDlvPsblYn;
        private String jejuChrDlvYn;
        private String jejuChrDlvcCd;
        private String jejuExchRtpChrYn;
        private String jejuRtpDlvcCd;
        private int jejuRtpOnewyRndtrpCd;
        private int jejuExchOnewyRndtrpCd;
        private String jejuChrDlvcAmt;
        private String jejuRtpAmt;
        private String jejuExchAmt;
        private String ilndChrDlvcAmt;
        private String ilndRtpAmt;
        private String ilndExchAmt;
        private String ilndDlvPsblYn;
        private String ilndChrDlvYn;
        private String ilndChrDlvcCd;
        private String ilndExchRtpChrYn;
        private String ilndRtpDlvcCd;
        private int ilndRtpOnewyRndtrpCd;
        private int ilndExchOnewyRndtrpCd;
        private String dd3InDlvNoadmtRegonYn = "";
        private String addModelNo = "";
        private String hcYn = "N";
        private String hcTermCd = "";
        private String paraImPrdYn;
        private String apntDtDlvYn = "N";
        private String apntDtDlvTyp = "default";
        private String withClsChkSuccYn = "Y";
        private String advrCnsdrMandVal = "0";
        private String ocrLinkNo = "";
        private String ocrLinkNoYn = "N";
        private String seasnYear = "";
        private String seasnGbnCd = "";
        private String seasnGbnDtlCd = "";
        private String jejuRtpAmtYn = "Y";
        private String jejuExchAmtYn = "Y";
        private String ilndRtpAmtYn = "Y";
        private String ilndExchAmtYn = "Y";
        private String inactiveDt = "29991231235959";
        private String srcMdid = "83071";
        private String ecStdDelivery = "1";
        private String prdNmStrDt = "";
        private String prdNmEndDt = "";
        private String dealYn = "";
        private String dealPrdYn = "N";
        private String regChanlGrpCd = "GE";
        private String scFileUploadYn = "N";
        private String scYnFlag_Re = "N";
        private String prdTypCd = "S";
        private String chgCharge = "Y";

        private LgecScmProduct() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class RegDeAttFileInfo {
        private String supPrdNeedDocNo;
        private String docNm;
        private String issueOrgNm = "\uad00\ub828 \uc778\uc99d\uae30\uad00";
        private String noteCntnt;
        private String prdClsCd;
        private String chanlCd = "P";
        private String supCd = "";
        private String supPrdCd = "";
        private String postAcpYn = "0";
        private String crpdNoYn = "1";
        private String brandCd = "";
        private String statusCd = "";
        private String count = "";
        private String prdCd = "";
        private String oldSupPrdCd = "";
        private String atachFileSize = "";
        private String uploadFileNm = "";
        private String atachFileNm = "";
        private String atachFilePathNm = "";
        private String maxSeq = "0";
        private String fileCnt = "";
        private String chgYn = "";
        private String paiNeedDocRsltNo = "";
        private String cnsdrEntValYn = "";
        private String cnsdrEntValNm = "";

        private RegDeAttFileInfo() {
        }
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
    private class RegPiAttFileInfo {
        private String supPrdNeedDocNo = "101";
        private String docNm = "\uc218\uc785\uba74\uc7a5";
        private String issueOrgNm = "\uad00\uc138\uccad";
        private String noteCntnt = "\uac11\uc9c0, \uc744\uc9c0";
        private String supCd = "";
        private String supPrdCd = "";
        private String postAcpYn = "0";
        private String crpdNoYn = "0";
        private String brandCd = "";
        private String statusCd = "";
        private String count = "";
        private String prdCd = "";
        private String oldSupPrdCd = "";
        private String atachFileSize = "";
        private String uploadFileNm = "";
        private String atachFileNm = "";
        private String atachFilePathNm = "";
        private String maxSeq = "0";
        private String fileCnt = "";
        private String chgYn = "";
        private String paiNeedDocRsltNo = "";
        private String cnsdrEntValYn = "";
        private String cnsdrEntValNm = "";

        private RegPiAttFileInfo() {
        }
    }

    private class SprodIntList {
        private String suppCode;
        private String subCode = "";
        private String partNum;
        private String goodId;
        private String rowId = "";
        private String newSaleFlag;
        private String oldNewSaleFlag;
        private String closeDesc;
        private String closeDescCntnt = "";
        private String allQty;
        private String reqAllQty;
        private String reqDmQty = "";
        private String addPoint;
        private String intGoodPreReq = "N";
        private String mode = "newSaleFlag";
        private String ecYn = "N";
        private String dtype;
        private String stype;
        private String dmQty = "";
        private String goodType = "S";
        private String crtype;
        private String oldAddPoint = "";
        private String oldSaleFlag;
        private String saleMedia = "EC";
        private String chanlTyp = "";
        private int reordTemp;
        private String imendFlag = "N";
        private String parProdIntId;
        private String oldImendFlag = "N";
        private String attrMngYn = "E";
        private String goodNm;
        private String intGoodNm = "";
        private String saleEndId;
        private String saleEndIdSub;
        private String srRegId = "";
        private String qryGbn;
        private String attrInclYn;
        private String dealYn = "";
        private String stockInSaleYn = "";
        private int totCnt;

        private SprodIntList() {
        }
    }
}

